/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/TextSrc.h>
#include <X11/Xaw/TextSink.h>
#include <X11/Xaw/AsciiSrc.h>
#include <X11/Xaw/AsciiSink.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "rotate.h"
#include "jutil.h"

/* --- macros --- */

#define small_number -10e32
#define large_number 10e32

/* --- global variables --- */

float SMALLr[14] =
  { 0.02, 0.05, 0.1, 0.2, 0.4, 0.5, 0.6, 0.8, 1.0, 2.0, 4.0, 6.0, 8.0, 10.0 };

int get_f_ind(float val, float *vec, int len);
void csorta(float *bufin, int *ibufdx, float *bufout, int n);
void Print_Header(FILE *inf, char fname[]);

/* --- functions --- */

void rot_output_ps(Widget w, XtPointer clidat, XtPointer calldat)
  {
  Widget *yoke = (Widget *)clidat;
  RotateWidget cw = (RotateWidget)yoke[0];
  int i, flags, nzee=0, *indx;
  ptset_t *pts, *container;
  axes_t *axes;
  float ox = 0, oy = 0, xaa, yaa, zaa, fx, r, plx1, minx, miny, maxx, maxy,
    maxz, minz, zsiz, xkmmax, ykmmax, zkmmax, min_sphere = 6, max_sphere = 15,
   *xp, *yp, *zp, *zees;
  FILE  *inf;
  char ps_file[50], *psdir, psfile[200];

  strcpy(ps_file, "spinout.ps");

  if((inf = fopen(ps_file, "w")) == NULL)
    {
    printf("Can't open postscript file...continuing\n");
    return;
    }

  /* include the header   */

  /* plot a grey border around each layer */

  fprintf(inf, "%%!PS\n");

  if((psdir = getenv("PSHEAD")) == NULL)
    {
    fprintf(stderr, "Can't find the Postscript header file head.big.\n");
    fprintf(stderr, "Please set the ENV variable PSHEAD .............\n");
    fprintf(inf, "%%%%  need to include the header file here \n");
    }
  else
    {
    sprintf(psfile,"%s/head.big",psdir);
    Print_Header(inf,  psfile);
    }

  fprintf(inf,"  %% The following tranlsates the origin to the center"
	  " of the 8.5X11 page\n");
  fprintf(inf, " %% START PLOT \n\n");
  fprintf(inf, " 4.25 inch  5.5 inch translate \n\n");
  fprintf(inf, " %% following code is also included in the new head.big"
	  " file \n");
  fprintf(inf, " %%       for now I include it - later this will be removed"
	  " \n");
  fprintf(inf, "/bbinc { 0.05 } def\n");
  fprintf(inf, "/Kool {          %% usage: x y  size Kool\n");
  fprintf(inf, "                 %%  to reverse the sphere sizes use  /bb  -1 mul 21 add  exch def\n");
  fprintf(inf, "         /bb exch def\n");
  fprintf(inf, "           gsave\n");
  fprintf(inf, "           translate\n");
  fprintf(inf, "           newpath\n");
  fprintf(inf, "            0 0  1 bb mul 0 360 arc clip\n");
  fprintf(inf, "            0 setgray\n");
  fprintf(inf, "         newpath   0 0  1 bb mul 0 360 arc fill\n");
  fprintf(inf, "          0 bbinc 1 bbinc add { \n");
  fprintf(inf, "          /siz exch def\n");
  fprintf(inf, "           siz setgray\n");
  fprintf(inf, "          /rad { 1.1 siz sub } def\n");
  fprintf(inf, "          newpath   .4 bb mul .4 bb mul  1 bb mul rad mul"
	  " 0 360 arc fill\n");
  fprintf(inf, "             } for\n");
  fprintf(inf, "           grestore\n");
  fprintf(inf, "      } def\n");

  XtVaGetValues((Widget)cw, XtNpointSet, &pts, XtNaxes, &axes, XtNxmin, &minx,
		XtNxmax, &maxx, XtNymin, &miny, XtNymax, &maxy, XtNxAngle,
		&xaa, XtNyAngle, &yaa, XtNzAngle, &zaa, XtNcontainer,
		&container, XtNsetFlags, &flags, NULL);

/*************   find bounds   *********/

  minx = large_number;
  maxx = small_number;
  miny = large_number;
  maxy = small_number;
  minz = large_number;
  maxz = small_number;

  XtVaGetValues((Widget)cw, XtNcontainer, &container, XtNsetFlags, &flags,
		NULL);

  if(flags & ROTMASK_CONTAINER)
    {
    for(i = 0, xp = container->x, yp = container->y;
	i < container->n; i++, xp++, yp++)
      {
      minx = min2(minx, *xp);
      maxx = max2(maxx,*xp);
      miny = min2(miny, *yp);
      maxy = max2(maxy,*yp);
      }
    }

  XtVaGetValues((Widget)cw, XtNpointSet, &pts, NULL);

  if(pts)
    {
    nzee = pts->n;
    if(nzee>0)
    {
    zees = alloc_fvec(0, nzee);
    indx = alloc_ivec(0, nzee);
    }

    for(i = 0, xp = pts->x, yp = pts->y, zp = pts->z; i < pts->n; i++, xp++,
	yp++, zp++)
      {
      minx = min2(minx, *xp);
      maxx = max2(maxx,*xp);
      miny = min2(miny, *yp);
      maxy = max2(maxy,*yp);
      minz = min2(minz, *zp);
      maxz = max2(maxz,*zp);
      zees[i] = *zp;
      }

    csorta(zees, indx, zees, nzee);
    }

  /* go through the line data (point pairs) */

  XtVaGetValues((Widget)cw, XtNlineSet, &pts, NULL);
  if(pts)
    {
    for(i = 0, xp = pts->x, yp = pts->y, zp = pts->z; i < pts->n; i+=2,
	xp+=2, yp+=2, zp+=2)
      {
      /* the current line is (*xp, *yp, *zp) to (*(xp+1), *(yp+1), *(zp+1));
	 ignore the z-coordinates to get the project (unscaled) line
	 (*xp, *yp) to (*(xp+1), *(yp+1)) */

      minx = min2(minx, *xp);
      maxx = max2(maxx,*xp);
      miny = min2(miny, *yp);
      maxy = max2(maxy,*yp);
      minx = min2(minx, *(xp+1));
      maxx = max2(maxx,*(xp+1));
      miny = min2(miny, *(yp+1));
      maxy = max2(maxy,*(yp+1));
      }
    }

  /******************************/

  printf("AGAIN Xmin = %f, Xmax = %f, Ymin = %f, Ymax = %f\n", minx, maxx,
	 miny, maxy);

  xkmmax = maxx - minx;
  ykmmax = maxy - miny;
  zkmmax = maxz - minz;

  if(xkmmax > ykmmax) plx1 = 6.5 * 72.0 / xkmmax;
  else plx1 = 7.5 * 72.0 / ykmmax;

  if((plx1 * xkmmax / 72.0) > 6.5) plx1 = 6.5 * 72.0 / xkmmax;

  fprintf(inf,"  %% The following variables (bx and bz) are the  x-y scaling"
	  " variables\n");
  fprintf(inf,"  %%     by changing these you can expand or diminish the"
	  " plot\n\n");
  fprintf(inf, " /bx { %f mul } def  /bz { %f mul } def \n\n", plx1, plx1);
  fprintf(inf,"  %%     Add Border around plot\n");
  fprintf(inf, " %f bx .1 inch sub %f bz .1 inch sub %f bx .1 inch add %f bz"
	  " .1 inch add  bord stroke \n", minx, miny, maxx, maxy);
  fprintf(inf,"  %%     Title\n");
  fprintf(inf,"  14 HV\n");
  fprintf(inf, " %f bx .1 inch sub \n %f bx .1 inch add \n add 2 div %f bz .1"
	  " inch add\n .1 inch add   moveto () censhow\n", minx,  maxx, maxy);

  /* translate and set the scaling  */

  fprintf(inf, "/eqsiz { 0.4 mul } def  %%   earthquake size   \n");
  fprintf(inf, "/eqpl { eqsiz 0 360 arc stroke } def\n");
  fprintf(inf, " %%  SYMBOLS that all use the same format:  x y size"
	  " <symbol>\n");
  fprintf(inf, "%%  xmark xsquare xtri xtriangle xrotsq xdiamond\n\n");
  fprintf(inf, "%%  Use these to change the symbols for different event"
	  " files\n");
  fprintf(inf, "%%  to change the earthquake plotting to a fancier plot,"
	  " uncomment the following macro\n");
  fprintf(inf, "%%  (to uncomment a line, remove the %% from the beginning)"
	  " \n\n");
  fprintf(inf, " %%       for now I use the Kool routine for plotting"
	  " events\n");
  fprintf(inf, " %%      to change this, replace Kool with eqpl, or pop 1"
	  " eqpl \n");
  fprintf(inf, " %%       \n");

  /* go through the point data */
 
  XtVaGetValues((Widget)cw, XtNpointSet, &pts, NULL);
  if(pts)
    {
    for(i = 0; i < pts->n; i++)
      {
      /* the current point is (*xp, *yp, *zp); ignore *zp to get the
         projected (unscaled) point (*xp, *yp) */

      /* fprintf(inf,"%f bx %f bz 10 eqpl \n",*xp,*yp); */

      xp = pts->x + indx[i];
      yp = pts->y + indx[i];
      zp = pts->z + indx[i];

      zsiz = ((max_sphere - min_sphere) * ((*zp - minz) / zkmmax)
	      + min_sphere);

      fprintf(inf,"%f bx %f bz %f Kool \n", *xp, *yp, zsiz);
      }
    }

  /* go through the line data (point pairs) */

  XtVaGetValues((Widget)cw, XtNlineSet, &pts, NULL);
  if(pts)
    {
    for(i = 0, xp = pts->x, yp = pts->y, zp = pts->z; i < pts->n; i+=2,
	xp+=2, yp+=2, zp+=2)
      {
      /* the current line is (*xp, *yp, *zp) to (*(xp+1), *(yp+1), *(zp+1));
	 ignore the z-coordinates to get the project (unscaled) line
	 (*xp, *yp) to (*(xp+1), *(yp+1)) */

      /* if(i==(pts->n-24)) fprintf(inf,"    \n  %% border \n"); */

      fprintf(inf, "%f bx %f bz moveto %f bx %f bz lineto stroke  \n",
	      *xp, *yp, *(xp+1), *(yp+1));
      }
    }
  fprintf(inf,"\n\n");

  /*************   container     ***************/

  if(flags & ROTMASK_CONTAINER)
    {
    fprintf(inf,"%%    container stuff   \n");

    for(i = 0, xp = container->x, yp = container->y, zp = container->z;
	i < container->n; i+=2, xp+=2, yp+=2, zp+=2)
      {
      /* do what you want with *xp, *yp, *zp, *(xp+1), *(yp+1), *(zp+1) */

      fprintf(inf,"%f bx %f bz moveto %f bx %f bz lineto stroke  \n",
	      *xp, *yp, *(xp+1), *(yp+1));
      }
    }
  fprintf(inf,"\n\n");

  /*************   axes    ***************/

  /* XtVaGetValues((Widget)cw, XtNlineSet, &axes, NULL); */

#if 0

  axes = cw->rotate.axes;
  fprintf(inf, "%f bx %f bz moveto %f bx %f bz lineto stroke  %f bx %f bz"
	  " moveto (z) show\n", axes->ox, axes->oy, axes->zax, axes->zay,
	  axes->zax, axes->zay);
  fprintf(inf, "%f bx %f bz moveto %f bx %f bz lineto stroke  (y) show\n",
	  axes->ox,axes->oy, axes->yax, axes->yay);
  fprintf(inf, "%f bx %f bz moveto %f bx %f bz lineto stroke  \n",
	  axes->ox, axes->oy, axes->xax, axes->xay);

  puts("-- axis endpoints --");
  printf("X: (%f, %f)\n", axes->xfx, axes->xfy);
  printf("Y: (%f, %f)\n", axes->yfx, axes->yfy);
  printf("Z: (%f, %f)\n", axes->zfx, axes->zfy);
#endif

  ox = oy = 0;
  fprintf(inf, "%f bx %f bz moveto %f bx %f bz lineto stroke  %f bx %f bz"
	  " moveto (z) show\n", ox, oy, axes->zfx, axes->zfy, axes->zfx,
	  axes->zfy);
  fprintf(inf, "%f bx %f bz moveto %f bx %f bz lineto stroke %f bx %f bz"
	  " moveto (y) show\n", ox, oy, axes->yfx, axes->yfy, axes->yfx,
	  axes->yfy);
  fprintf(inf, "%f bx %f bz moveto %f bx %f bz lineto stroke %f bx %f bz"
	  " moveto (x) show \n", ox, oy, axes->xfx, axes->xfy, axes->xfx,
	  axes->xfy);

  fprintf(inf, "\n\n");

  if(flags & ROTMASK_ANGLES)
    {
    fprintf(inf, "%% Adding in the rotation angles\n");
    fprintf(inf, "10 HV\n");
    fprintf(inf, "0.0 %f bz 0.2 inch add moveto  (X:%.1f\\312\\040Y:"
	    "%.1f\\312\\040Z:%.1f\\312) censhow\n",
	    maxy, rad2deg(xaa), rad2deg(yaa), rad2deg(zaa));
    }

  /*************  km scale    ***************/

  fx = (int)fabs(xkmmax) / 4.0;

  if(fx == 0.0) fx = fabs(xkmmax) / 4;

  if(fx > 100) fx = 100 * (int)(0.5 + fx / 100);
  if(fx > 1000) fx = 1000 * (int)(0.5 + fx / 1000);

  r = 10.0 * (int)(fx / 10.0);

  if(fx < 10)
    {
    i = get_f_ind(fx, SMALLr, 14);
    r = SMALLr[i];
    }

  /* if focal mecahnisms are being plotted move the kmscale down a bit */

  fx = (maxx + minx) / 2.0;
  /*fy =  miny;*/

  fprintf(inf, " %f bx %f bz -0.5 inch add %f kmscale\n\n", fx, miny, r);
  fprintf(inf, "%% 0.0 %f bz 0.2 inch add moveto (title) censhow\n\n" , maxy);
  fprintf(inf, "showpage \n");
  fclose(inf);

  fprintf(stderr, " nzee  = %d\n" , nzee);

  fprintf(stderr, "  \nPostscript file: spinout.ps \n\n");
  fprintf(stderr, "  to plot: lpr spinout.ps\n to view use:  ghostview"
	  " spinout.ps \n(works better than pageview) \n");
  fprintf(stderr, "  Further selections of postscript in the spin module"
	  " will overwrite this file \n");
  fprintf(stderr, "     ....so copy this file if you want to save it for"
	  " later \n");


  if(pts)
  {
     if(nzee>0)
     {
	free_fvec(zees, 0, nzee);
	free_ivec(indx, 0, nzee);
     }
  }
  }
