/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <stdio.h>
#include <math.h>

/* --- local headers --- */

#include "geotouch.h"

/* --- structure definitions and prototypes --- */

typedef struct
  { 
  double min, max;
  double ave, adev, sdev, var, skew, curt;
  double med, quartileu, octileu;
  double quartilel, octilel;
  } hstat;

float *alloc_fvec(long first, long last);
int *alloc_ivec(long first, long last);
double *alloc_dvec(long first, long last);
void free_dvec(double *a, long first, long last);
void free_fvec(float *a, long first, long last);
void free_ivec(int *a, long first, long last);
void  dsorta(double *bufin, int *ibufdx, double *bufout, int n);
void  csorta(float *bufin, int *ibufdx, float *bufout, int n);

/* --- functions --- */

/*FUNC DEF */ void print_stats(hstat *o)
{

   fprintf(stderr,"STATS: min max ave adev var sdev skew curt med quart oct\n");
   fprintf(stderr,"STATS: %f %f %f %f %f %f %f %f %f %f %f\n",  
	   o->min,
	   o->max,
	   o->ave,
	   o->adev,
	   o->var,
	   o->sdev,
	   o->skew,
	   o->curt,
	   o->med, 
	   o->quartilel,
	   o->octilel );
   
   fprintf(stderr,"STATS:\nmin=%f\nmax=%f\naverage=%f\navedev=%f\nvariance=%f\nstdev=%f\nskew=%f\ncurt=%f\nmedian=%f\nquartile=%f\noctile=%f\n",  
	   o->min,
	   o->max,
	   o->ave,
	   o->adev,
	   o->var,
	   o->sdev,
	   o->skew,
	   o->curt,
	   o->med, 
	   o->quartilel,
	   o->octilel );
   

}

/*FUNC DEF */void quick_stats(float *vec, int n, hstat *o)
  {
  
  /* these are basically from numerical recipes in C, 
     although I think I found a bug in their code  */

  
     int i;
  double min = 1e30, max = -1e30, diff,
    ave = 0, adev = 0, sdev = 0, var = 0, skew = 0, curt = 0,
    sdiff = 0, med = 0, quartile = 0, octile = 0;


  min = max = vec[0];
  for (i = 0; i < n; i++)
    {
    ave += vec[i];
    if(vec[i]<min) min = vec[i];
    if(vec[i]>max) max = vec[i];
    }
  ave /= n;

  for (i = 0; i < n; i++)
    {
    diff = vec[i] - ave;
    sdiff += diff;
    adev += fabs(diff);
    var  += sqr(diff);
    skew += diff * diff * diff;
    curt += diff * diff * diff * diff;
    }

  adev /= n;
  var = ((var - sdiff * sdiff / n) / (n - 1));
  sdev = sqrt(var);
  if(var != 0.0)
    {
    skew /= (n * var * sdev);
    curt = ((curt / (n * var * var)) - 3.0);
    }
  else skew = curt = 0.0;

  o->min = min;
  o->max = max;
  o->ave = ave;
  o->adev = adev;
  o->var = var;
  o->sdev = sdev;
  o->skew = skew;
  o->curt = curt;

  o->med = med;
  o->quartilel = quartile;
  o->octilel = octile;


  }


/*FUNC DEF */void get_stats(float *vec, int n, hstat *o)
  {
  
  /* these are basically from numerical recipes in C, 
     although I think I found a bug in their code  */

  float *vex;
  int *indv, i, medp, forthp, eightp;
  double min = 1e30, max = -1e30, diff,
    ave = 0, adev = 0, sdev = 0, var = 0, skew = 0, curt = 0,
    sdiff = 0, med = 0, quartile = 0, octile = 0;

  vex  = alloc_fvec(0, n);
  indv = alloc_ivec(0, n);    

  for (i = 0; i < n; i++)
    {
    ave += vec[i];
    vex[i] = vec[i];
    }
  ave /= n;

  csorta(vex, indv, vex, n);
  medp = n / 2;
  forthp = n / 4;
  eightp = n / 8;

   /*fprintf(stderr,"n=%d medp=%d %d %d\n", n, medp, forthp, eightp);*/
   /*for(i=0; i<n; i++){
        fprintf(stderr,"%d %f %f\n",i, vec[i], vex[i]); }*/

  med = vex[medp];
  quartile = vex[forthp];
  octile = vex[eightp];

  min = vex[0];
  max = vex[n - 1];

  for (i = 0; i < n; i++)
    {
    diff = vec[i] - ave;
    sdiff += diff;
    adev += fabs(diff);
    var  += sqr(diff);
    skew += diff * diff * diff;
    curt += diff * diff * diff * diff;
    }

  adev /= n;
  var = ((var - sdiff * sdiff / n) / (n - 1));
  sdev = sqrt(var);
  if(var != 0.0)
    {
    skew /= (n * var * sdev);
    curt = ((curt / (n * var * var)) - 3.0);
    }
  else skew = curt = 0.0;

  o->min = min;
  o->max = max;
  o->ave = ave;
  o->adev = adev;
  o->var = var;
  o->sdev = sdev;
  o->skew = skew;
  o->curt = curt;

  o->med = med;
  o->quartilel = quartile;
  o->octilel = octile;

  free_fvec(vex, 0, n);
  free_ivec(indv, 0, n);
  }

void get_dstats(double *vec, int n, hstat *o)
  {

  /* these are basically from numerical recipes in C, 
     although I think I found a bug in their code  */

  int i, *indv, medp, forthp, eightp;
  double *vex, min = 1e30, max = -1e30, diff,
    ave = 0, adev = 0, sdev = 0, var = 0, skew = 0, curt = 0,
    sdiff = 0, med = 0, quartile = 0, octile = 0;

  vex  = alloc_dvec(0, n);
  indv = alloc_ivec(0, n);

  for(i = 0; i < n; i++)
    { 
    ave += vec[i];
    vex[i] = vec[i];
    }
  ave /= n;

  dsorta(vex, indv, vex, n);

  medp = n / 2;
  forthp = n / 4;
  eightp = n / 8;

   /*fprintf(stderr,"n=%d medp=%d %d %d\n", n, medp, forthp, eightp);*/
   /*for(i=0; i<n; i++){
     fprintf(stderr,"%d %f %f\n",i, vec[i], vex[i]); }*/

  med = vex[medp];
  quartile = vex[forthp];
  octile = vex[eightp];

  min = vex[0];
  max = vex[n - 1];

  for (i = 0; i < n; i++)
    {
    diff = vec[i] - ave;
    sdiff += diff;
    adev += fabs(diff);
    var += sqr(diff);
    skew += diff * diff * diff;
    curt += diff * diff * diff * diff;
    }

  adev /= n;
  var = ((var - sdiff * sdiff / n) / (n - 1));
  sdev = sqrt(var);
  if(var != 0.0)
    {
    skew /= (n * var * sdev);
    curt = ((curt / (n * var * var)) - 3.0);
    }
  else skew = curt = 0.0;

  o->min = min;
  o->max = max;
  o->ave = ave;
  o->adev = adev;
  o->var = var;
  o->sdev = sdev;
  o->skew = skew;
  o->curt = curt;

  o->med = med ;
  o->quartilel = quartile;
  o->octilel = octile;

  free_dvec(vex, 0, n);
  free_ivec(indv, 0 , n);
  }
