
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

void usleep(unsigned int useconds);

    


/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jml.h"
#include "jutil.h"
#include "user2pix.h"

/* --- macros --- */

#define NUM_SEL 50

/* --- global variables and function prototypes --- */

extern int screenx, screeny;

void csorta(float *bufin, int *ibufdx, float *bufout, int n);
void create_Acard(ac_rec *ac , char *acrd);
void tojul(int year, int month, int day, int *jul);
void send_repaint(Widget wij, int x, int y, int w, int h);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
void draw_Xmark(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void get_tim_str(char *jtim);
void Print_Header(FILE *inf, char fname[]);
Boolean readac(FILE *f, ac_rec *a);

extern void setup_pat_ps(FILE *inf);

/* --- functions --- */
static double  DEG2RAD= 3.14159265358979323846/180.0;
static     double  RAD2DEG = 180.0/3.14159265358979323846;


/**********************************************/
typedef struct
  {
 double x,y,z;
  } Vector3d;
/*************************************************************/
/*************************************************************/
/*************************************************************/
/*************************************************************/
Vector3d cross_prod(Vector3d B, Vector3d A)
  {
    Vector3d c;
     c.x = (B.y*A.z) - (A.y*B.z);
     c.y = (A.x*B.z) - (B.x*A.z);
     c.z = (B.x*A.y) - (A.x*B.y);
    return (c);
 }
/*************************************************************/
/*************************************************************/
/*************************************************************/
/*************************************************************/
void foc_point(double delta_B, double delta_P, double delta_T, double *h, double *v)
{

  /* plot a focal point on a ternary diagram  */

  double db ,  dp,  dt, censin, cencos ;
  double denom ;
  double phi;

   db=delta_B*DEG2RAD;
   dp=delta_P*DEG2RAD;
   dt=delta_T*DEG2RAD;
  
    censin=sin(DEG2RAD*35.26);
    cencos=cos(DEG2RAD*35.26);
  
  phi =atan2( sin(dt),sin(dp)) - 45*DEG2RAD;

  denom = (censin*sin(db)+cencos*cos(db)*cos(phi) );
  
  *h = (cos(db)*sin(phi))/denom;
  
  *v = (cencos*sin(db)-censin*cos(db)*cos(phi))/denom;

  }

/*************************************************************/
/*************************************************************/
/*************************************************************/
/*************************************************************/
void B_foc_vec(double Paz, double Pdip, double Taz, double Tdip, double *B_dip, double *B_az)
  {
 
    double zp, hp, xp, yp, zt, ht, xt, yt;
    
    Vector3d  B, T1, P1;
    
    /**** convert P and T axis to cartesian coordinates  ***/
    
    
    zp= cos(DEG2RAD*Pdip  );
    hp= sin(DEG2RAD*Pdip);
    yp= hp*cos(DEG2RAD*Paz );
    xp= hp*sin(DEG2RAD*Paz);
    
    

    P1.x = xp;
    P1.y = yp;
    P1.z = zp;
    
    zt= cos(DEG2RAD*Tdip);
    ht= sin(DEG2RAD*Tdip);
    yt= ht*cos(DEG2RAD*Taz);
    xt= ht*sin(DEG2RAD*Taz);
    
    T1.x = xt;
    T1.y =yt;
    T1.z = zt;
    
    /*** now get the cross product B =   P X T  ***/
    
    B = cross_prod(P1, T1);

    
     *B_dip =RAD2DEG* acos(B.z);
     *B_az=RAD2DEG*atan2( B.x, B.y);


    if(*B_az<0.0) *B_az+=360;
    
    
       if(B.z>0.0)
       {
       *B_az =    *B_az-180;
       *B_dip  =      90-*B_dip;
       }
       else
       {
       *B_az =    *B_az;
       *B_dip  =  90-*B_dip;
       }
       
if(*B_dip<0) *B_dip *= -1.0;

     
 }

/*************************************************************/
/*************************************************************/
/*************************************************************/
/*************************************************************/
void focal_ternary(Widget wij, mpic * mplot)
  {
  Display *disp;
  Window wind;
  GC ggc;
  JGRAPH ngr;
  int ix, iy, hsize,  k, i, j, kount, kx, ky, psize = 4,
    ntype = 7,  ktype[7],
      col_fillsphere = 25,
    col_perimsphere = 22,  
    xstamp_pos, ystamp_pos, xstamp_width, ystamp_width;
  float tminx, tmaxx, tminy, tmaxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, px, py, phi, lam;
  float bot=10000.0, top=-100000.0;
  double  minx = 0.0, maxx = 1.0, miny = 0.0, maxy = 1.0;
  
  Position        x, y;
  Dimension       width, height;
  double B_dip,  B_az, h, v;
  
  XPoint p[6];
  /* XtVaGetValues(wij, XtNdata, &mplot, NULL); */
  
  wind = XtWindow(mplot->wij);
  disp = XtDisplay(mplot->wij);
  ggc = mplot->ggc;
  
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  
  if( mplot->foc_in_layer == 1 && mplot->image.nz > 1)
    {
      top  = mplot->image.z_parts[mplot->image_layer - 1]; 
      bot  = mplot->image.z_parts[mplot->image_layer];
    }


  ystamp_pos = (((float)height * 3.0) / 4.0);
  xstamp_width = ystamp_width = (height - ystamp_pos) - 10;
  xstamp_pos = width-xstamp_width-4;
  ystamp_pos -= 50;

  miny = 1.414443;
  maxy = -0.706992;
  minx = -1.224679;
  maxx = 1.224679;
 
  window(&ngr, minx, maxx, miny, maxy);
  viewport(&ngr, xstamp_pos, xstamp_pos + xstamp_width,
	   ystamp_pos + ystamp_width, ystamp_pos);
  
  hsize = ystamp_width;
  
  ix = user_to_pix_x(&ngr, (double)0.0);
  iy = user_to_pix_y(&ngr, (double)0.0);
  

  foc_point(90.0, 0.0 , 0.0, &h, &v);
  p[0].x = user_to_pix_x(&ngr, (double)h);
  p[0].y = user_to_pix_y(&ngr, (double)v);
  p[3].x = user_to_pix_x(&ngr, (double)h);
  p[3].y = user_to_pix_y(&ngr, (double)v);
  
  
  foc_point(0.0, 90.0 , 0.0, &h, &v);
  p[1].x = user_to_pix_x(&ngr, (double)h);
  p[1].y = user_to_pix_y(&ngr, (double)v);
  foc_point(0.0, 0.0 , 90.0, &h, &v);
  p[2].x = user_to_pix_x(&ngr, (double)h);
  p[2].y = user_to_pix_y(&ngr, (double)v);


  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_fillsphere)]);
  
  XFillPolygon(disp, wind, ggc, p, 4,  Nonconvex, CoordModeOrigin );
  
  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_perimsphere)]);
  XDrawLines(disp, wind, ggc, p, 4,  CoordModeOrigin );


  draw_just_text(disp, wind, ggc, p[0].x,
		 p[0].y, "SS", HJ_LEFT,
		 VJ_BASELINE);
  draw_just_text(disp, wind, ggc, p[1].x,
		 p[1].y, "N", HJ_RIGHT,
		 VJ_BASELINE);
  draw_just_text(disp, wind, ggc, p[2].x,
		 p[2].y, "R", HJ_LEFT,
		 VJ_BASELINE);


  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
      tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
      tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
      tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
      tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }
  
  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
      tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
      tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    }
  else
    {
      tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
      tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }
  
  bottom_left_x = (float)tminx;
  bottom_left_y = (float)tminy;
  top_right_x = (float)tmaxx;
  top_right_y = (float)tmaxy;
  
  for(j = 0; j < ntype; j++) ktype[j] = 0;
  k = 0;
  
  for (kount = 0; kount < mplot->num_focm_files; kount++)
    {
      for(i = 0; i < mplot->focm[kount].numpoints; i++)
	{
	  
	  if(!mplot->focm[kount].focs[i].on_off)continue;

	  if( !(mplot->foc_in_layer == 0 || 
		(mplot->foc_in_layer == 1 && mplot->focm[kount].focs[i].loc.z < bot  
		 && mplot->focm[kount].focs[i].loc.z >= top)) ) continue; 

	  phi = mplot->focm[kount].focs[i].loc.x;
	  lam = mplot->focm[kount].focs[i].loc.y;
	  geo2xy(mplot, phi, lam, &px, &py);
	  
	  if((px >= bottom_left_x) && (px <= top_right_x) && (py >= bottom_left_y)
	     && (py <= top_right_y))
	    {
	      k++;
	      
	      B_foc_vec(mplot->focm[kount].focs[i].fm.strk1,
			mplot->focm[kount].focs[i].fm.dip1,
			mplot->focm[kount].focs[i].fm.strk2, 
			mplot->focm[kount].focs[i].fm.dip2, 
			&B_dip,  &B_az );
	      
	      foc_point( B_dip , mplot->focm[kount].focs[i].fm.pdip,  
			 mplot->focm[kount].focs[i].fm.tdip, &h, &v );
	

	      kx = user_to_pix_x(&ngr, (double)h);
	      ky = user_to_pix_y(&ngr, (double)v);
	      
	      XSetForeground(disp, ggc, mplot->colors[XmapAppColor( mplot->focm[kount].focs[i].type  )]);
 

	      draw_Xmark(disp, wind, ggc, kx, ky, psize);

	
	    }
	}
    }

 
  XFlush(disp);

  fprintf(stdout, "\n\n-------------------------------------\n");
  fprintf(stdout, "Lower Left(x,y)= %f %f km\n", bottom_left_x, bottom_left_y);
  fprintf(stdout, "Upper Right(x,y)= %f %f km\n", top_right_x, top_right_y);

  xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);

  
  fprintf(stdout, "Lower Left(lat,lon)= %f %f deg\n",phi, lam);
  xy2geo(mplot, &phi, &lam, top_right_x, top_right_y);

  lam *= -1;
  fprintf(stdout, "Upper Right(lat,lon)= %f %f deg\n", phi, lam);
  fprintf(stdout, "\n");
  fprintf(stdout, "k=%d Focal P-T axes\n", k);

  }
/*************************************************************/
/*************************************************************/
/*************************************************************/
/*************************************************************/

void do_a_ternary(Widget wij, mpic * mplot, double tminx, double tminy, double tmaxx, double tmaxy , double ternsize, FILE *inf)
{
  Display *disp;
  Window wind;
  GC ggc;
  JGRAPH ngr;
  int ix, iy,   k, i, j, kount, kx, ky, psize = 4,
    ntype = 7,  ktype[7],
     col_fillsphere = 25,
    col_perimsphere = 22,  
    xstamp_pos, ystamp_pos, xstamp_width, ystamp_width;
  float  bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, px, py, phi, lam;
  float bot=10000.0, top=-100000.0;
  double xi,   minx = 0.0, maxx = 1.0, miny = 0.0, maxy = 1.0;
  
  Position        x, y;
  Dimension       width, height;
  double B_dip,  B_az, h, v;
  
  XPoint p[6];
  /* XtVaGetValues(wij, XtNdata, &mplot, NULL); */
  
  wind = XtWindow(mplot->wij);
  disp = XtDisplay(mplot->wij);
  ggc = mplot->ggc;
  
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  
  /** coordinates are in km from origin  */
  
  bottom_left_x = (float)tminx;
  bottom_left_y = (float)tminy;
  top_right_x = (float)tmaxx;
  top_right_y = (float)tmaxy;

  ystamp_pos = user_to_pix_y(&mplot->gr , tminy+(tmaxy-tminy)/2.-ternsize/2.);
  xstamp_pos = user_to_pix_x(&mplot->gr , tminx+(tmaxx-tminx)/2.-ternsize/2.);
  
  xstamp_width =   user_to_pix_x(&mplot->gr , tminx+(tmaxx-tminx)/2.+ternsize/2.);
  ystamp_width = user_to_pix_y(&mplot->gr , tminy+(tmaxy-tminy)/2.+ternsize/2.);



  miny = 1.414443;
  maxy = -0.706992;
  minx = -1.224679;
  maxx = 1.224679;
 
  window(&ngr, minx, maxx, miny, maxy);
  viewport(&ngr, xstamp_pos,  xstamp_width,
	    ystamp_pos, ystamp_width );
  
  ix = user_to_pix_x(&ngr, (double)0.0);
  iy = user_to_pix_y(&ngr, (double)0.0);


  
fprintf(inf, "gsave \n");
 
 xi = ternsize;
 
fprintf(inf, " %f bx %f bz %f bx %f bz bord stroke \n",bottom_left_x, bottom_left_y, top_right_x, top_right_y);
fprintf(inf, " %f bx %f bz translate \n", tminx+(tmaxx-tminx)/2., tminy+(tmaxy-tminy)/2.0 );

 foc_point(90.0, 0.0 , 0.0, &h, &v);
 p[0].x = user_to_pix_x(&ngr, (double)h);
  p[0].y = user_to_pix_y(&ngr, (double)v);
  p[3].x = user_to_pix_x(&ngr, (double)h);
  p[3].y = user_to_pix_y(&ngr, (double)v);
  
  fprintf(inf, " %f ternx %f ternz moveto \n", h,v);
  
  foc_point(0.0, 90.0 , 0.0, &h, &v);
  p[1].x = user_to_pix_x(&ngr, (double)h);
  p[1].y = user_to_pix_y(&ngr, (double)v);
  
  fprintf(inf, " %f ternx %f ternz lineto \n", h,v);
 

  
  foc_point(0.0, 0.0 , 90.0, &h, &v);

  
  p[2].x = user_to_pix_x(&ngr, (double)h);
  p[2].y = user_to_pix_y(&ngr, (double)v);
  
  fprintf(inf, " %f ternx %f ternz lineto closepath gsave 1 setgray fill grestore\n", h,v);
  fprintf(inf, " 0 setgray stroke \n");

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_fillsphere)]);
  
  XFillPolygon(disp, wind, ggc, p, 4,  Nonconvex, CoordModeOrigin );
  
  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_perimsphere)]);
  XDrawLines(disp, wind, ggc, p, 4,  CoordModeOrigin );

  /*
  draw_just_text(disp, wind, ggc, p[0].x,
		 p[0].y, "SS", HJ_LEFT,
		 VJ_BASELINE);
  draw_just_text(disp, wind, ggc, p[1].x,
		 p[1].y, "N", HJ_RIGHT,
		 VJ_BASELINE);
  draw_just_text(disp, wind, ggc, p[2].x,
		 p[2].y, "R", HJ_LEFT,
		 VJ_BASELINE);
		 */


  

  
  for(j = 0; j < ntype; j++) ktype[j] = 0;
  k = 0;
  
  for (kount = 0; kount < mplot->num_focm_files; kount++)
    {
      for(i = 0; i < mplot->focm[kount].numpoints; i++)
	{
	  
	  if(!mplot->focm[kount].focs[i].on_off)continue;

	  if( !(mplot->foc_in_layer == 0 || 
		(mplot->foc_in_layer == 1 && mplot->focm[kount].focs[i].loc.z < bot  
		 && mplot->focm[kount].focs[i].loc.z >= top)) ) continue; 

	  phi = mplot->focm[kount].focs[i].loc.x;
	  lam = mplot->focm[kount].focs[i].loc.y;
	  geo2xy(mplot, phi, lam, &px, &py);
	  
	  if((px >= bottom_left_x) && (px <= top_right_x) && (py >= bottom_left_y)
	     && (py <= top_right_y))
	    {
	      k++;
	      
	      B_foc_vec(mplot->focm[kount].focs[i].fm.strk1,
			mplot->focm[kount].focs[i].fm.dip1,
			mplot->focm[kount].focs[i].fm.strk2, 
			mplot->focm[kount].focs[i].fm.dip2, 
			&B_dip,  &B_az );
	      
	      foc_point( B_dip , mplot->focm[kount].focs[i].fm.pdip,  
			 mplot->focm[kount].focs[i].fm.tdip, &h, &v );
	

	      kx = user_to_pix_x(&ngr, (double)h);
	      ky = user_to_pix_y(&ngr, (double)v);
	      
	      XSetForeground(disp, ggc, mplot->colors[XmapAppColor( mplot->focm[kount].focs[i].type  )]);
 

	      draw_Xmark(disp, wind, ggc, kx, ky, psize);

	      fprintf(inf, "%f %f %f terncol1",
		      mplot->jmlcol[mplot->focm[kount].focs[i].type].red,
		      mplot->jmlcol[mplot->focm[kount].focs[i].type].green,
		      mplot->jmlcol[mplot->focm[kount].focs[i].type].blue);
 
	      fprintf(inf, " %f ternx %f ternz siz xplus \n", h,v);
	
	    }
	}
    }

 fprintf(inf, "\ngrestore\n");
  XFlush(disp);

}
/*************************************************************/
/*************************************************************/
void PS_focal_ternary(Widget wij, mpic * mplot)
  {
  float tminx, tmaxx, tminy, tmaxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, px, py, phi, lam;
  int k, i, j, kount, ntype = 7, itype[7] = {18, 23, 22, 21, 19, 20, 2},
    ktype[7];
  
float bot=10000, top=-10000;
  char *ctype[7] = {"strikeslip", "rev-oblSS", "obl-rev", "reverse",
		    "norm-oblSS", "obl-norm", "normal"},
    *psdir, psfile[200], jtim[25];
  FILE *inf;

  double B_dip,  B_az, h, v;
  
  /* XtVaGetValues(wij, XtNdata, &mplot, NULL); */

  if((inf = fopen("foc_ternary.ps", "w")) == NULL)
    {
    printf("Can't open foc_ternary.ps file...continuing\n");
    return;
    }
  if( mplot->foc_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }

  fprintf(inf, "%%!PS\n");
  if((psdir = getenv("PSHEAD")) == NULL)
    {
    fprintf(stderr, "%%%%  Can't find header file. \n");
    fprintf(stderr, "%%%%  Please set env varible: PSHEAD \n");
    fprintf(inf, "%%%%  Please set env varible: PSHEAD \n");
    fprintf(inf, "%%%%  ( need to include the header file here )\n");
    }
  else
    {
    sprintf(psfile, "%s/head.big", psdir);
    Print_Header(inf,  psfile);
    }

  get_tim_str(jtim);
  fprintf(inf,"%%  Postscript file Created: %s ", jtim);
  fprintf(inf, " %%--------------------------------------------- \n");

  
  fprintf(inf, "%% Summary of Focal Mechanisms:\n");
 fprintf(inf, "\n\n%% -------------------------------------\n");
  
  fprintf(inf, " 4 inch 5 inch translate %% center of the plot\n\n");
  fprintf(inf, "/ternx { 2 inch mul } def \n");
  fprintf(inf, "/ternz { 2 inch mul } def \n");
  fprintf(inf, "/siz { .1 inch } def \n");
  fprintf(inf, " \n          %% \n");
  fprintf(inf, "/setcol1  { setrgbcolor } def \n");
  fprintf(inf, " \n          %% this is the lighter-background color setting"
	  "\n");
  fprintf(inf, "/setcol2  { setrgbcolor } def \n");
  fprintf(inf, "\n   /BW { /setcol1  { pop pop pop 0 setgray } def "
	  "\n /setcol2  { pop pop pop 1 setgray } def \n } def\n");
  fprintf(inf, "           %% for Black and White figures uncomment the"
	  " following line:\n\n");

  if(mplot->BW_flag == 1)
    {
    fprintf(inf, "           BW\n\n"); 
    setup_pat_ps(inf);
    }
  else fprintf(inf, "           %%BW\n\n");

  fprintf(inf, "%%----------------COLOR Stuff  ------------\n\n");
  fprintf(inf, "  /setcolP { 1.000000 0.980392 0.803922 setcol1 }"
	  " def     %%  P-axis\n");
  fprintf(inf, "  /setcolT { 0.498039 1.000000 0.831373 setcol1 }"
	  " def     %%  T-axis\n\n");
  fprintf(inf, "  /external_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /map_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /internal_back_color { 0.560784 0.737255 0.560784 setcol2 }"
	  " def\n");
  fprintf(inf, "  /fill_color { 0.411765 0.411765 0.411765  setcol2 } def\n");
  fprintf(inf, "  /perim_color { 0.529412 0.807843 1.000000  setcol1 } def\n");
  fprintf(inf, "  /lines_color { 0.321569 0.545098 0.545098  setcol1 } def\n");
  fprintf(inf, "  internal_back_color \n");
  

  /* set up selection box   */

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    } 
  else
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }

  bottom_left_x = (float)tminx;
  bottom_left_y = (float)tminy;
  top_right_x = (float)tmaxx;
  top_right_y = (float)tmaxy;


 fprintf(inf, "gsave \n");
 fprintf(inf, "/focfilcol { 0 0 0  setcol1  } def\n");
 fprintf(inf, "-0.000000 ternx 1.414443 ternz  .5 inch add translate\n");
 fprintf(inf, " 45 90 -45 90 0 focu \n");
 fprintf(inf, " grestore \n");


 fprintf(inf, "gsave \n");
 fprintf(inf, "/focfilcol { 0 0 0  setcol1  } def\n");
 fprintf(inf, "-1.224679 ternx  -.3 inch add -0.706992 ternz   -.3 inch add translate\n");
 fprintf(inf, " 45 45 225 45 0 focu \n");
 fprintf(inf, " grestore \n");


 fprintf(inf, "gsave \n");
 fprintf(inf, "/focfilcol { 0 0 0 setcol1  } def\n");
 fprintf(inf, "1.224679 ternx  .3 inch add -0.706992 ternz   -.3 inch add translate\n");
 fprintf(inf, " 45 45 225 45 1 focu \n");
 fprintf(inf, " grestore \n");


  
  
  fprintf(inf, "\n%% -----------------Coordinates--------------------\n");
  fprintf(inf, "%% Lower Left(x,y)= %f %f km\n", bottom_left_x, bottom_left_y);
  fprintf(inf, "%% Upper Right(x,y)= %f %f km\n", top_right_x, top_right_y);

  xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);

  
  fprintf(inf, "%% Lower Left(lat,lon)= %f %f deg\n",phi, lam);
  xy2geo(mplot, &phi, &lam, top_right_x, top_right_y);

  lam *= -1;
  fprintf(inf, "%% Upper Right(lat,lon)= %f %f deg\n", phi, lam);
  fprintf(inf, "\n%% -------------------------------------\n");
  
  fprintf(inf, "\n\n");
  
fprintf(inf, "gsave\n");
fprintf(inf, "%% %f bx %f bz\n", bottom_left_x, bottom_left_y);
fprintf(inf, "%% %f bx %f bz bord stroke\n", top_right_x, top_right_y);

fprintf(inf, "%% %f bx %f bz translate\n", bottom_left_x, top_right_y);
fprintf(inf, "%% /ternx { .2 inch mul } def \n");
fprintf(inf, "%% /ternz { .2 inch mul } def \n");
fprintf(inf, "%% /siz { .03 inch } def \n");
 
  foc_point(90.0, 0.0 , 0.0, &h, &v);
 fprintf(inf, "1 setgray\n");
 fprintf(inf, "%f ternx %f ternz moveto\n", h, v);
 
  
  foc_point(0.0, 90.0 , 0.0, &h, &v);
 fprintf(inf, "%f ternx %f ternz lineto\n", h, v);
 
  foc_point(0.0, 0.0 , 90.0, &h, &v);
  fprintf(inf, "%f ternx %f ternz lineto\n", h, v);
  fprintf(inf, " closepath fill\n");
  

fprintf(inf, "0 setgray\n");
  
 foc_point(90.0, 0.0 , 0.0, &h, &v);
 fprintf(inf, "0 setgray\n");
 fprintf(inf, "%f ternx %f ternz moveto\n", h, v);
 
  
  foc_point(0.0, 90.0 , 0.0, &h, &v);
 fprintf(inf, "%f ternx %f ternz lineto\n", h, v);
 
  foc_point(0.0, 0.0 , 90.0, &h, &v);
  fprintf(inf, "%f ternx %f ternz lineto\n", h, v);
  fprintf(inf, " closepath stroke\n");
  



  for(j = 0; j < ntype; j++) ktype[j] = 0;

  k = 0;
  for(kount = 0; kount < mplot->num_focm_files; kount++)
    {
    for(i = 0; i < mplot->focm[kount].numpoints; i++)
      {

 if(!mplot->focm[kount].focs[i].on_off)continue;

      if( !(mplot->foc_in_layer == 0 || 
	    (mplot->foc_in_layer == 1 && mplot->focm[kount].focs[i].loc.z < bot  
	     && mplot->focm[kount].focs[i].loc.z >= top)) ) continue; 


      phi = mplot->focm[kount].focs[i].loc.x;
      lam = mplot->focm[kount].focs[i].loc.y;

      geo2xy(mplot, phi, lam, &px, &py);

      if((px >= bottom_left_x) && (px <= top_right_x) && (py >= bottom_left_y)
	 && (py <= top_right_y))
	{
	k++;
	/* Plotting starts here  */
	B_foc_vec(mplot->focm[kount].focs[i].fm.strk1,
		  mplot->focm[kount].focs[i].fm.dip1,
		  mplot->focm[kount].focs[i].fm.strk2, 
		  mplot->focm[kount].focs[i].fm.dip2, 
		  &B_dip,  &B_az );
	
	foc_point( B_dip , mplot->focm[kount].focs[i].fm.pdip,  
		   mplot->focm[kount].focs[i].fm.tdip, &h, &v );
	
	fprintf(inf, "   %f ternx %f ternz siz xmark\n", h, v);

	

	for(j = 0; j < ntype; j++)
	  if(itype[j] == mplot->focm[kount].focs[i].type) ktype[j]++;
	}
      }
    }
    fprintf(inf, "\n");
  fprintf(inf, "grestore\n");
  fprintf(inf, "\n");
 
  fprintf(inf, "\n\n");
  fprintf(inf, "0 setgray\n");
  fprintf(inf, "/info_table  { \n");
  fprintf(inf, "0 0 moveto (k=%d Focal P-T axes) show\n", k);
  fprintf(inf, "0 -.2 inch  moveto (Summary of Focal Mechanisms:) show\n");
  fprintf(inf, "/pin { -15 mul -20 add } def\n");

  for(j = 0; j < ntype; j++)
    fprintf(inf, "0 %d pin moveto (%-5d %s) show\n",j+1,  ktype[j], ctype[j]);

  fprintf(inf, " } def \n");
  fprintf(inf, "\n\n %% to NOT plot the text summary, comment out next line"
	  " \n");
  fprintf(inf, " gsave -1 ternx -1 ternz translate 0 -.4 inch translate info_table"
	  "  grestore  \n\n");
  fprintf(inf, "  showpage \n");

  fclose(inf);

  fprintf(stderr, "\n\n Done: to see plot submit file foc_ternary.ps to printer\n"
	  "     (or ghostview), e.g.: lpr foc_ternary.ps\n");

  
  }
/**********************************************/
int count_focs(mpic *mplot, double bottom_left_x, double  bottom_left_y,  double top_right_x,  double top_right_y)
{

  int k, i, kount;
 float bot=10000, top=-10000;
  float phi, lam, px, py;
   k = 0;
  
  for (kount = 0; kount < mplot->num_focm_files; kount++)
    {
      for(i = 0; i < mplot->focm[kount].numpoints; i++)
	{
	  
	  if(!mplot->focm[kount].focs[i].on_off)continue;

	  if( !(mplot->foc_in_layer == 0 || 
		(mplot->foc_in_layer == 1 && mplot->focm[kount].focs[i].loc.z < bot  
		 && mplot->focm[kount].focs[i].loc.z >= top)) ) continue; 

	  phi = mplot->focm[kount].focs[i].loc.x;
	  lam = mplot->focm[kount].focs[i].loc.y;
	  geo2xy(mplot, phi, lam, &px, &py);
	  
	  if((px >= bottom_left_x) && (px <= top_right_x) && (py >= bottom_left_y)
	     && (py <= top_right_y))
	    {
	      k++;


	    }
	}
    }
  return(k);
}



/**********************************************/
/**********************************************/


void auto_focal_ternary(Widget wij, mpic * mplot)
{
  Display *disp;
  Window wind;
  GC ggc;
 
  int ix, iy,    i, j, col_perimsphere = 22;
    
  double tminx, tmaxx, tminy, tmaxy, ternsize;

  float bot=10000.0, top=-100000.0;
 
  
  char lab[20];
  Position        x, y;
  Dimension       width, height;
  
  int nx, ny;
double dxblock, ex, dyblock, why;
 FILE *inf;
 
  
  /* XtVaGetValues(wij, XtNdata, &mplot, NULL); */
  
  wind = XtWindow(mplot->wij);
  disp = XtDisplay(mplot->wij);
  ggc = mplot->ggc;

  if((inf = fopen("auto_ternary.addps", "w")) == NULL)
    {
    printf("Can't open   auto_ternary.addps file...continuing\n");
    }
    if(inf==NULL) { inf = stdout; }
    
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  
  if( mplot->foc_in_layer == 1 && mplot->image.nz > 1)
    {
      top  = mplot->image.z_parts[mplot->image_layer - 1]; 
      bot  = mplot->image.z_parts[mplot->image_layer];
    }


     nx = 10;
     ny = 10;
     
  
     dxblock = mplot->gr.user_xdif/(float)nx;
     dyblock = mplot->gr.user_ydif/(float)ny;
     
     dxblock = (mplot->origin.maxx-mplot->origin.minx)/(float)nx;
     dyblock = (mplot->origin.maxy-mplot->origin.miny)/(float)ny;
     
     
     
     
     for(i=0; i<=nx; i++)
       {
	 ex = (double)mplot->origin.minx+(float)i*dxblock;
	 
	 XDrawLine(disp, wind, ggc,
		   user_to_pix_x(&mplot->gr, (double)ex),
		   user_to_pix_y(&mplot->gr, (double)mplot->origin.miny),
		   user_to_pix_x(&mplot->gr, (double)ex),
		   user_to_pix_y(&mplot->gr, (double)mplot->origin.maxy));
       }
     
     for(i=0; i<=ny; i++)
       {
	 why = (double)mplot->origin.miny+(float)i*dyblock;
	 
	 XDrawLine(disp, wind, ggc,
		   user_to_pix_x(&mplot->gr, (double)mplot->origin.minx),
		   user_to_pix_y(&mplot->gr, (double)why),
		   user_to_pix_x(&mplot->gr, (double)mplot->origin.maxx),
		   user_to_pix_y(&mplot->gr, (double)why));
       }
     
     XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_perimsphere)]);
     
     if(dxblock>=dyblock)
       {
	 ternsize =  dyblock/2.5;
       }
     else
       {
	 ternsize = dxblock/2.5 ;
       }
    
     
     fprintf(inf, "/ternx { %f bx mul } def \n", ternsize);
     fprintf(inf, "/ternz { %f bz mul } def \n", ternsize);
     fprintf(inf, "/siz { 1.8 } def\n");
     fprintf(inf, "/terncol1 { setrgbcolor } def \n");  
     for(i=0; i<nx; i++)
       {  
	 for(j=0; j<ny; j++)
	   {
	     sprintf(lab,"(%2d,%2d)", i, j);
	     ex =  (double)mplot->origin.minx+(float)i*dxblock+0.5*dxblock;
	    why = (double)mplot->origin.miny+(float)j*dyblock+0.5*dyblock;
	    /* draw_just_text(disp, wind, ggc, user_to_pix_x(&mplot->gr, (double)ex),
	       user_to_pix_y(&mplot->gr, (double)why), lab, HJ_LEFT,
	       VJ_BASELINE); */
	    
	    tminx = (double)mplot->origin.minx+(float)i*dxblock;
	    tmaxx = tminx + dxblock;
	    tminy = (double)mplot->origin.miny+(float)j*dyblock;
	    tmaxy = tminy + dyblock;
	    ternsize = min2( ( tmaxx-tminx ),  ( tmaxy-tminy )  );
	    
	    ix = (user_to_pix_x(&mplot->gr, (double)tmaxx) - user_to_pix_x(&mplot->gr, (double)tminx) );
	    iy = -(user_to_pix_y(&mplot->gr, (double)tmaxy) + user_to_pix_y(&mplot->gr, (double)tminy) );
	    
	    /* fprintf(stderr, "ix = %d  iy = %d\n", ix, iy); */
	    
	    if(ix>=iy)
	      {
		ternsize =  dyblock;
	      }
	    else
	      {
		ternsize = dxblock ;
	      }
	    
	    /* fprintf(stderr, "minx=%f miny=%f maxx=%f maxy=%f ternsize=%f\n", tminx,  tminy,  tmaxx, tmaxy , ternsize); */
	    
	    
	    
	    
	    if( count_focs(mplot, tminx, tminy,  tmaxx,  tmaxy) > 0 )
	      {
		do_a_ternary(wij, mplot, tminx,  tminy,  tmaxx, tmaxy , ternsize, inf);
	      }
	    
	    
	   }
       }
     
}

/**********************************************/
/**********************************************/

void Auto_focal_summary(mpic * mplot)
  {
   
    auto_focal_ternary( mplot->wij,  mplot);
    
  }
