/*	
Fri Dec 31 16:53:19 EST 1993
borrowed and modified from PQL............. JML
Fri May 20 10:06:57 EDT 1994
    modified for XMAP


This collection of routines allow a user to reference particular pixels
  of a pixmap indirectly through the user's own coordinate system. The user
  creates this mapping explicitly by allocating a "graph" structure (defined in
  "defines.h" and setting its fields as desired, either through calls to
  viewport() and window() or by direct assignment. Mappings may be either
  linear or logarithmic.
	Note that y-values of pixmaps increase going down. The pix_ymin and
  pix_ymax fields should be set to lesser and greater positive integer values
  respectively. The conversion functions will handle the inversion. (It is
  assumed that the user's xy-coordinates increase to the right and up.)
*/

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <stdio.h>
#include <string.h>

/* --- local headers --- */

#include "user2pix.h"

/* --- functions --- */

/* change user-coordinate system */

void window(JGRAPH *gr, double x1, double x2, double y1, double y2)
  {

  gr->user_xmin = x1;
  gr->user_xmax = x2;
  gr->user_ymin = (float)y1;
  gr->user_ymax = (float)y2;
  gr->user_xdif = gr->user_xmax - gr->user_xmin;
  gr->user_ydif = (double)gr->user_ymax - (double)gr->user_ymin;
  if(gr->user_ydif == 0)
    {
    gr->user_ymax++;
    gr->user_ymin--;  
    gr->user_ydif = (double)gr->user_ymax - (double)gr->user_ymin;
    }
  }

/* change area of pixmap to which user-coordinates will be mapped
   y1 must be less than y2, i.e, y1 is 'above' y2 in the actual pixmap;
   note that this does not create a viewport in the strict sense of the
   word, i.e., vectors will not be clipped at the boundaries of the
   viewport, but only at the boundaries of the enclosing pixmap      */

void viewport(JGRAPH *gr, int x1, int x2, int y1, int y2)
  {

  gr->pix_xmin = x1;
  gr->pix_xmax = x2;
  gr->pix_xdif = x2 - x1;
  gr->pix_ymin = y1;
  gr->pix_ymax = y2;
  gr->pix_ydif = y2 - y1;
  }

/* convert user x-coordinates to pixels */

int user_to_pix_x(JGRAPH *gr, double x)
  {
  double a = x, b;

  b = (((a - gr->user_xmin) / gr->user_xdif)
       * ((double)gr->pix_xdif) + ((double)gr->pix_xmin));

 /* fprintf(stderr, "ux: %f %d\n", a, (int)b);*/

  return((int)b);
  }

/* convert user y-coordinates to pixels */

int user_to_pix_y(JGRAPH *gr, double y)
  {
  double a = y, b;

  b = (((double)gr->pix_ydif) - ((double)(a - gr->user_ymin) / gr->user_ydif)
       * ((double)gr->pix_ydif) + ((double)gr->pix_ymin));

  /*fprintf(stderr, "uy: %f %d\n", a, (int)b);*/

  return((int)b);
  }

/* convert pixels to user x-coordinates */

double pix_to_user_x(JGRAPH *gr, int pix_x)
  {
  double a, factor;

  factor = ((double)pix_x - gr->pix_xmin) / ((double)gr->pix_xdif);
  a = factor * gr->user_xdif + gr->user_xmin;
 
  return(a);
  }

/* convert pixels to user y-coordinates */

double pix_to_user_y(JGRAPH *gr, int pix_y)
  {
  double a, factor;

  factor = 1.0 - (((double)pix_y - gr->pix_ymin) / ((double)gr->pix_ydif));
  a = factor * gr->user_ydif + gr->user_ymin;

  return(a);
  }


void copy_graph(JGRAPH *gr, JGRAPH *gnew)
  {

  memcpy((void *)gnew, (void *)gr, sizeof(JGRAPH));
  }

void print_graph(JGRAPH *gr)
  {

  fprintf(stderr, "user_xmin=%f user_xmax=%f user_ymin=%f user_ymax=%f\n"
	  "      pix_xmin=%d pix_xmax=%d pix_ymax=%d pix_ymin=%d \n",
	  gr->user_xmin, gr->user_xmax, gr->user_ymin, gr->user_ymax,
	  gr->pix_xmin, gr->pix_xmax, gr->pix_ymax, gr->pix_ymin);
  }
