
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>

/* --- local headers --- */

#include "geotouch.h"
#include "xlext.h"
#include "colorquant.h"

/* --- typedefs and macros --- */

typedef unsigned long Pixel;

typedef struct jml_image
  {
  unsigned int sx;	/* image width (in pixels)	*/
  unsigned int sy;	/* image height (in pixels)	*/
  float lat, lon, dx, dy;
  char regis[3];
  char *i_format;
  char *i_coord;
  int coordflag, regisflag, formatflag;
  unsigned int K;
  unsigned int *pixels;
  qcolor_t *colors;
  } jml_image;

#define SET_DPOS(pos) (dpos[orient] = x + pos[orient] * dotpkm[orient])

/* --- function prototypes --- */

void get_sat_image(char *inputfile, jml_image *jml);

/* --- functions --- */

void draw_text(Display *d, Window w, GC gc, int x, int y, char *str)
  {

  XDrawString(d, w, gc, x, y, str, strlen(str));
  }

/* --------------------------------------------------------- */

void draw_just_text(Display *d, Window w, GC gc, int x, int y, char *str,
		    htext_just hjust, vtext_just vjust)
  {
  XGCValues values;
  int len = strlen(str), direction, ascent, descent;
  XCharStruct overall;

  XGetGCValues(d, gc, GCFont, &values);
  XQueryTextExtents(d, values.font, str, len, &direction, &ascent, &descent,
		    &overall);

  switch(hjust)
    {
    case HJ_CENTER:
      x -= overall.width / 2;
      break;

    case HJ_RIGHT:
      x -=  overall.width;
      break;

    case HJ_LEFT:
      break;
    }

  switch(vjust)
    {
    case VJ_TOP:
      y += ascent;
      break;

    case VJ_CENTER:
      y += (ascent - descent) / 2;
      break;

    case VJ_BOTTOM:
      y -= descent;
      break;

    case VJ_BASELINE:
      break;
    }

  XDrawString(d, w, gc, x, y, str, len);
  }


/* --------------------------------------------------------- */

/* x, y			position for scale
   orient		0 = horiz, 1 = vert
   len			length of scale in km
   kmpbtic		km per big-tick divison
   ltic			# of little-tick divisions for every big-tick
			division
   tickdir		Do ticks go left/up (-1) or right/down (1)?
   linedir		Increase scale going left/up (-1) or right/down (1)
   offset		Value to label minimum of scale with
   label		Function used to label big ticks
   hjust, vjust		how text should be justified
   dotpkm_x, dotpkm_y	Size of 1 km on screen in X- and Y-direction
   btic_len		Length of a big tick-mark
   ltic_len		Length of a small tick-mark
   tick_space		Space between end of tick and start of text

   */

void draw_scale(Display *d, Window w, GC gc, int x, int y, int orient,
		float len, float kmpbtic, int ltic, int tickdir, int linedir,
		float offset, char *(*label)(float), htext_just hjust,
		vtext_just vjust, float dotpkm_x, float dotpkm_y,
		int btic_len, int ltic_len, int tick_space)
  {
  float dotpkm[2] = { dotpkm_x, dotpkm_y };
  float pos[2] = { 0.0, 0.0 };	/* Current "cursor" position along scale */
  float val = 0.0;		/* Current value along scale */
  int dpos[2];			/* A position converted to dots */
  int dpos2[2];
  int rorient = 1 - orient;	/* Reverse of orient */
  float kmpltic = kmpbtic / ltic; /* Km per little-tick division */

  dpos[0] = x, dpos[1] = y;

  for(;;)
    {
    int i;	/* COunter for little tick */
    float lpos[2] = {pos[0], pos[1]};	/* Position for little tick */

    /* Draw the big tick */

    dpos2[orient] = dpos[orient];
    dpos2[rorient] = dpos[rorient] + btic_len * tickdir;
    XDrawLine(d, w, gc, dpos[0], dpos[1], dpos2[0], dpos2[1]);

    /* Draw the text for the tick */

    dpos2[rorient] += tick_space * tickdir;
    draw_just_text(d, w, gc, dpos2[0], dpos2[1],
		   (*label)(val + offset), hjust, vjust);

    /* Draw all the little ticks inbetween */

    for(i = ltic - 1; i > 0; i--)
      {
      val = (lpos[orient] += kmpltic * linedir);
      SET_DPOS(lpos);
      if(val >= len) goto end;	/* Off end of scale */

      dpos2[orient] = dpos[orient];
      dpos2[rorient] = dpos[rorient] + ltic_len * tickdir;
      XDrawLine(d, w, gc, dpos[0], dpos[1], dpos2[0], dpos2[1]);
      }

    /* Increment */

    val = (pos[orient] += kmpbtic * linedir);
    SET_DPOS(pos);
    if(val >= len) goto end;	/* Off end of scale */
    }

end:

  /* Draw last big-tick */

  pos[orient] = len;
  SET_DPOS(pos);

  dpos2[orient] = dpos[orient];
  dpos2[rorient] = dpos[rorient] + btic_len * tickdir;
  XDrawLine(d, w, gc, dpos[0], dpos[1], dpos2[0], dpos2[1]);

  /* Draw the text for the tick */

  dpos2[rorient] += tick_space * tickdir;
  draw_just_text(d, w, gc, dpos2[0], dpos2[1], (*label)(val), hjust, vjust);

  /* Draw the line along the axis of the scale */
  XDrawLine(d, w, gc, dpos[0], dpos[1], x, y);
  }

/* --------------------------------------------------------- */

#if 0
void draw_ellipse1(Display *dpy, Window xwin, GC gc,int x, int y,int siz1,
		   int siz2)
{
	/*pw_put(pw1,x,y,1);*/
}
#endif

/* --------------------------------------------------------- */

void draw_triang(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  float sin30 = 0.5, cos30 = 0.866025;
  int x2, y2, x3, y3, x4, y4;

  /* pw_put(pw1,x,y,1); */
 

  x2 = x - siz * cos30;
  y2 = y - siz * sin30;
  x3 = x + siz * cos30;
  y3 = y - siz * sin30;
  x4 = x;
  y4 = y + siz;

  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);
  XDrawLine(dpy, xwin, gc, x3, y3, x4, y4);
  XDrawLine(dpy, xwin, gc, x4, y4, x2, y2);
  }

/* --------------------------------------------------------- */

void draw_triang_2(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  float sin30 = 0.5, cos30 = 0.866025;
  int x2, y2, x3, y3, x4, y4;
  

  /* pw_put(pw1,x,y,1); */

  x2 = x - siz * cos30;
  y2 = y + siz * sin30;
  x3 = x + siz * cos30;
  y3 = y + siz * sin30;
  x4 = x;
  y4 = y - siz;

  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);
  XDrawLine(dpy, xwin, gc, x3, y3, x4, y4);
  XDrawLine(dpy, xwin, gc, x4, y4, x2, y2);
  }

/* --------------------------------------------------------- */

void draw_square(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  int x2, y2, x3, y3, x4, y4, x5, y5;
  int fsiz=(float)siz*0.7071067;
  
  /* pw_put(pw1,x,y,1); */

  x2 = x - fsiz;
  y2 = y + fsiz;
  x3 = x + fsiz;
  y3 = y + fsiz;
  x4 = x + fsiz;
  y4 = y - fsiz;
  x5 = x - fsiz;
  y5 = y - fsiz;

  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);
  XDrawLine(dpy, xwin, gc, x3, y3, x4, y4);
  XDrawLine(dpy, xwin, gc, x4, y4, x5, y5);
  XDrawLine(dpy, xwin, gc, x5, y5, x2, y2);
  }

/* --------------------------------------------------------- */

void draw_star_david(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {

  draw_triang(dpy, xwin, gc, x, y, siz);
  draw_triang_2(dpy, xwin, gc, x,  y, siz);
  }

void draw_star5(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
 XPoint p[6];

 float c36=0.809017, s36=0.5877853, c18=0.9510565, s18=0.3090170;
 
 p[0].x = x-siz*s36;
 p[0].y = y+siz*c36;
 p[1].x  = x+siz*c18;
 p[1].y = y-siz*s18;
 p[2].x  = x-siz*c18;
 p[2].y = y-siz*s18;
 p[3].x  = x+siz*s36;
 p[3].y = y+siz*c36;
 p[4].x  = x;
 p[4].y = y-siz;

 p[5].x = x-siz*s36;
 p[5].y = y+siz*c36;
   XDrawLines(dpy, xwin, gc, p, 6, CoordModeOrigin );




  }
void fill_star5(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
 XPoint p[6];

 float c36=0.809017, s36=0.5877853, c18=0.9510565, s18=0.3090170;
 
 p[0].x = x-siz*s36;
 p[0].y = y+siz*c36;
 p[1].x  = x+siz*c18;
 p[1].y = y-siz*s18;
 p[2].x  = x-siz*c18;
 p[2].y = y-siz*s18;
 p[3].x  = x+siz*s36;
 p[3].y = y+siz*c36;
 p[4].x  = x;
 p[4].y = y-siz;

 p[5].x = x-siz*s36;
 p[5].y = y+siz*c36;
   XFillPolygon(dpy, xwin, gc, p, 6,  Nonconvex, CoordModeOrigin );




  }






void draw_ex(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  int x2, y2, x3, y3;
  int fsiz=(float)siz*0.7071067;

  /* pw_put(pw1,x,y,1); */

  x2 = x - fsiz;
  y2 = y + fsiz;
  x3 = x + fsiz;
  y3 = y - fsiz;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);

  x2 = x - fsiz;
  y2 = y - fsiz;
  x3 = x + fsiz;
  y3 = y + fsiz;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);
  }

/* --------------------------------------------------------- */

void draw_Circle(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  int x1, y1, circle = 23040;
  int fsiz=(float)siz*1.3;

  /* pw_put(pw1,x,y,1); */

  x1 = x - fsiz/2;
  y1 = y - fsiz/2;
	  XDrawArc(dpy, xwin, gc,
		   x1,
		   y1,
		   fsiz, fsiz, 0, circle);
  }

void draw_Fill_Circle(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  int x1, y1, circle = 23040;
  int fsiz=(float)siz*1.3;

  /* pw_put(pw1,x,y,1); */

  x1 = x - fsiz/2;
  y1 = y - fsiz/2;
	  XFillArc(dpy, xwin, gc,
		   x1,
		   y1,
		   fsiz, fsiz, 0, circle);
  }

void draw_asterix(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  int x1, y1;
  int i;
  float ang;
    int fsiz=(float)siz*0.7071067;


  for(i=0; i<361; i+=30)
     {
     ang = (float)i*XMAP_PI/180.0;
     
     x1 = x+fsiz*cos(ang);
     y1 = y+fsiz*sin(ang);
     
     XDrawLine(dpy, xwin, gc, x, y, x1, y1);
     }
  
  }


void draw_Plus(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  int x2, y2, x3, y3;
  int fsiz=(float)siz*0.7071067;

  /* pw_put(pw1,x,y,1); */

  x2 = x - fsiz;
  y2 = y;
  x3 = x + fsiz;
  y3 = y;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);

  x2 = x;
  y2 = y - fsiz;
  x3 = x;
  y3 = y + fsiz;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);
  }

void draw_Diamond(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
  {
  int x2, y2, x3, y3;

  /* pw_put(pw1,x,y,1); */

  x2 = x - 0.5 * siz;
  y2 = y;
  x3 = x;
  y3 = y - 0.75 * siz;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);

  x2 = x;
  y2 = y - 0.75 * siz;
  x3 = x + 0.5 * siz;
  y3 = y;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);

  x2 = x + 0.5 * siz;
  y2 = y;
  x3 = x;
  y3 = y + 0.75 * siz;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);

  x2 = x;
  y2 = y + 0.75 * siz;
  x3 = x - 0.5 * siz;
  y3 = y;
  XDrawLine(dpy, xwin, gc, x2, y2, x3, y3);
  }

/* --------------------------------------------------------- */

GC copy_gc(Display *disp, Window drawable, GC old)
  {
  XGCValues values;
  GC new;

  new = XCreateGC(disp, drawable, 0L, &values);
  XCopyGC(disp, old, 0xFFFFFFFF, new);
  return(new);
  }

/* ================= Setup and Support routines =============== */

void alloc_named_colors(Display *disp, Colormap col, char *names,
			Pixel *colors, int num)
  {
  XColor rgb;
  int i, num2, screen_num;
  Colormap stdcmp;

  screen_num = DefaultScreen(disp);
  stdcmp = XDefaultColormap(disp, screen_num);

  fprintf(stderr, "in alloc_named_colors=.....num=%d\n", num);
  rgb.flags = (DoRed | DoGreen | DoBlue);

  for(i = 0; i < COLORS_WM; i++)
    {
    rgb.pixel = i;
    XQueryColor(disp, stdcmp, &rgb);
    XAllocColor(disp, col, &rgb);
    colors[i] = rgb.pixel;
    }

  for(i = 0; i < COLORS_APP; i++)
    {
    /* fprintf(stderr,"color[%d]=%s\n",i, names+i*25); */
    XParseColor(disp, stdcmp, names + i * 25, &rgb); 
    XAllocColor(disp, col, &rgb);
    colors[XmapAppColor(i)] = rgb.pixel;
    }

  num2 = COLORS_WM + COLORS_APP;
  /* fprintf(stderr,"num2=%d colorsmax=%d\n" , num2, COLORS_MAX); */

  XParseColor(disp, stdcmp, "pink", &rgb);
  for(i = num2; i < COLORS_MAX ; i++)
    {
    XAllocColor(disp, col, &rgb);
    colors[i] = rgb.pixel;
    /* fprintf(stderr,"Extra color[%d]=   %d %d %d : %ld\n", i, rgb.red, rgb.green,
       rgb.blue, rgb.pixel); */
    }

/* fprintf(stderr,"done with alloc_named_colors\n"); */

  }

/* --------------------------------------------------------- */

void alloc_named_colorsSAT(Display *disp,Colormap col,char *names,
			   Pixel *colors, int num, char *filename,
			   jml_image *jml)
  {
  XColor rgb, xcol;
  int i, screen_num, j, n, num1, num2;
  Colormap stdcmp;

  screen_num = DefaultScreen(disp);
  stdcmp = DefaultColormap(disp, screen_num);
 
  fprintf(stderr,"in alloc_named_colorsSAT=.....num=%d\n", num);
  get_sat_image(filename, jml);

  fprintf(stderr, " jml_image: %d %d %d %f %f %f %f\n", jml->sx, jml->sy,
	  jml->K, jml->lat, jml->lon,jml->dx, jml->dy);
  fprintf(stderr, " jml_image: regis=%s flag=%d \n", jml->regis,
	  jml->regisflag);

  rgb.flags = (DoRed | DoGreen | DoBlue);
  for(i = 0; i < COLORS_WM; i++)
    {
    rgb.pixel = i;
    XQueryColor(disp, stdcmp, &rgb);
    XStoreColor(disp, col, &rgb);
    colors[XmapWMColor(i)] = rgb.pixel;
    }
  num1 = COLORS_APP;
  rgb.flags = (DoRed | DoGreen | DoBlue);

  for(i = 0; i < COLORS_APP; i++)
    {
    /* fprintf(stderr,"color[%d]=%s\n",i, names+i*25); */
    XParseColor(disp, stdcmp, names + i * 25, &rgb); 
    rgb.pixel = XmapAppColor(i);
    /* fprintf(stderr,"color[%d]=%s : %d %d %d : %ld\n",i, names+i*25, rgb.red,
       rgb.green,  rgb.blue, rgb.pixel); */
    XStoreColor(disp, col, &rgb);
    colors[XmapAppColor(i)] = rgb.pixel;
    }

  /* add in the Quantized colors */
  rgb.flags = (DoRed | DoGreen | DoBlue);

  for(j = 0; j<jml->K; j++)
    {
    rgb.pixel = XmapQuantColor(j);

    rgb.red = (short)(jml->colors[j].r * 256);
    rgb.green = (short)(jml->colors[j].g * 256);
    rgb.blue = (short)(jml->colors[j].b * 256);  
    XStoreColor(disp, col, &rgb);
    colors[XmapQuantColor(j)] = rgb.pixel;
    /* fprintf(stderr,"Quant color[%d]= %d : %d %d %d : %ld\n", XmapQuantColor(j), j,
       rgb.red, rgb.green,  rgb.blue, rgb.pixel); */
    }

  /* fill in the rest of the colors  to 255  */

  num2 = COLORS_WM + COLORS_APP + jml->K;

   fprintf(stderr,"num2=%d colorsmax=%d\n" , num2, COLORS_MAX); 

  XParseColor(disp, stdcmp, "pink", &rgb);
  for(i = num2; i < COLORS_MAX; i++)
    {
    rgb.pixel = i;
    XStoreColor(disp, col, &rgb);
    colors[i] = rgb.pixel;
    /* fprintf(stderr,"Extra color[%d]=   %d %d %d : %ld\n", i, rgb.red, rgb.green,
       rgb.blue, rgb.pixel); */
    }

  n = 255;
  xcol.pixel = n;
  xcol.red = (short)(65535);
  xcol.green = (short)(65535);
  xcol.blue  = (short)(65535);  
  XStoreColor(disp, col, &xcol);
  colors[n] = xcol.pixel;
  }

/* --------------------------------------------------------- */

void load_named_fonts(Display *disp, char *names[], Font fonts[],
		      XFontStruct *font_infos[], int num)
  {
  int i;

  for(i = 0; i < num; i++)
    {
      /* fprintf(stderr,"font %d %s\n", i, names[i]); */
    font_infos[i] = XLoadQueryFont(disp, names[i]);
    fonts[i] = font_infos[i]->fid;
    }
  }

/* --------------------------------------------------------- */
