
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* --- local headers --- */

#include "geotouch.h"
#include "xlext.h"
#include "mpic.h"
#include "post_color.h"
#include "user2pix.h"
#include "geotouch-help.h"

/* --- global variables --- */

XtAppContext apcon;
char MAPCODE[30];
extern int screenx, screeny;
extern int default_depth;

char *font_names[] =
  {
  "*helvetica-medium-r-*-120-*",
  "*helvetica-medium-r-*-240-*",
  "*helvetica-medium-r-*-240-*",
  "*helvetica-medium-r-*-120-*"
  };

/* --- macros --- */

#define DIAGNOST 0

#define NUM_COLORS 255
#define NUM_FONTS (sizeof(font_names) / sizeof(char *))

/* --- function prototypes --- */
void start_utm_sphr(float phi1, float lam1);
void start_utm_ellipsoid(float phi1, float lam1);
void start_cen_utm_ellipsoid(ORG *origin );
void start_cen_utm_sphr(ORG *origin);


void start_Lambert_Az_sphr( float phi0, float lam0, float phi, float lam );



void start_albers(ORG *origin  );
void start_albers2(float phi1, float phi2, float lam1, float lam2);
void albers_EAsphr_xy(float phi, float lam, float *x, float *y);
void start_merc_sphr(ORG *origin );
void start_miller_sphr(float phi1, float lam1, float lam0);
void start_ngclc(float phi1, float lam1);
void start_no_proj(float phi1, float lam1);
void alloc_named_colorsSAT(Display *disp, Colormap col, char *names,
			   Pixel *colors, int num, char *filename,
			   jml_image *jml);
void alloc_named_colors(Display *disp, Colormap col, char *names,
			Pixel *colors, int num);
void jgclc(float phio, float lamo, float phi, float lam, float *x, float *y);
void jlcgc(float phio, float lamo, float *phi, float *lam, float ex,
	   float why);
int Get_org(ORG *org, char *file);
void Dump_org(ORG *org);
int Get_Map2(char *mapfile, mpic *m);
int Get_Point_Labs(char *markfile, mpic *m);
void clcgc(float phio[3], float lamo[3], float phi[3], float lam[3], float *ex,
	   float *why);
void break_line(char *line, int *fake_argc, char **fake_argv);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);

int Get_Image_GMT(char *file, mpic *m);
int Get_Image_CDF(char *file, mpic *m);
int Get_Stations(char *stafile, mpic *m);
int Get_Sources(char source_file[50], mpic *m);
void init_mpic_class(XtAppContext apcon);
void init_xsec_class(XtAppContext apcon);
int get_colors(char color_names[255][25], int *numcols);
int Get_Lips(char *lipfile, mpic *m);
int Get_Map_GMT(char *mapfile, mpic *m);
int Get_Stuff2(mpic *m);
int Get_Stuff1(mpic *m);
int Get_ThreeD(char *infile, mpic *mplot);
int modify_color_scheme(mpic *oneplot);
int Get_Stations(char *stafile, mpic *m);
int Get_Image_GMT(char *file, mpic *m);
int Get_Focs(char foc_file[50], mpic *m);
int Get_Focs_Ext(char foc_file[50], mpic *m);

int Get_Image(char image_file[50], mpic *m);
int Get_Wells(char *wellfile, mpic *m);
int Get_Map3(char *mapfile, mpic *m);
int Load_Xsec(char *xsecfile, mpic *mplot);
void init_xdipParms(mpic *mp);
void make_mpic_window(Widget top, mpic *mplot, Font *fonts);
void Do_Contour_Field(Display *gdisp, char ps_file[50], mpic *mplot);
void Do_Contour_Field_NoDISP(char ps_file[200], mpic *mplot);
void Init_Focs(mpic *oneplot);
void Set_Explode_Focs(mpic *mplot);

int change_ps_colors(mpic *mplot);
void Do_Postscript(Display * gdisp, char ps_file[50], mpic *mplot);
void  flip_color_palette(mpic *m);

float fix_lon(float lon);
void Set_1_1( mpic *mplot);


/* --- functions --- */

void startup_help(void)
  {
  fprintf(stderr, "%s", GEOTOUCH_HELP);
  fprintf(stderr, "\n");
  exit(0);
  }

/* --------------------------------------------------------- */

void submap8(int nargc, char **nargv)
  {
  char post_file[100], color_names[255][25], *default_map, *envformat,
    parse_flag[100], xsecfile[100], *source_file, source_format[10],  focal_format[10];
  /* float p1old[3], p2old[3], l1old[3], l2old[3]; */
  float bx1, by1, lon1, lon2, cenlon, phi, lam, garb1, garb2;
  int i, j, Xloc = 100, Yloc = 100, igarb1, iyesno, Post_Out = 0, numcols,
    shiftx, shifty, org_type, projtype, kparse, do_get_cont = 0, do_get_xsec,
    gscr_num;
  char *jinput;
  static int xmarg = 50, ymarg = 70;
  mpic *oneplot = XmapNewElement(mpic);
  Dimension win_hite, win_width;
  Position win_x, win_y;
  Display *gdisp;
  Screen *gscr;
  Visual *default_visual;
  Colormap gcol;
  Pixel *colors;		/* Pixel-values of colors */
  Font *fonts;			/* Font IDs of fonts to use */
  
  XFontStruct **font_infos;	/* All the info about the fonts */
  Widget top;
  XVisualInfo vis;
  static XrmOptionDescRec options[] =
    { { "-label", "*Command.label", XrmoptionSepArg, NULL } };

#include "Geotouch.fallback.h"

  if(nargc < 2)
    {
    fprintf(stderr, "USAGE %s orgfile stations sources\n", nargv[0]);
    fprintf(stderr, " Options: \n");
    fprintf(stderr, "\n -B switch to Black and White\n -D depth range\n"
	    " -z depth range\n -w width range\n -F focal mechanism file\n"
	    " -W well file\n -S extra source file\n"
	    " -M geomap file\n -X cross section file\n -T TITLE\n");
    exit(0);
    }

  top = XtVaAppInitialize(&apcon, "Geotouch", options, XtNumber(options),
			  (Cardinal *)&nargc, nargv, fallback_resources,
			  NULL);
  init_mpic_class(apcon);
  init_xsec_class(apcon);

  /* Init the colors and fonts */

  i = get_colors(color_names, &numcols);

 /*  i = change_ps_colors(oneplot); */

  gdisp = XtDisplay(top);
  gscr = XtScreen(top);
  gscr_num = DefaultScreen(gdisp);

  default_depth = DefaultDepth(gdisp, gscr_num);
  default_visual = DefaultVisual(gdisp, gscr_num);

  fonts = XmapNewArray(Font, NUM_FONTS);
  font_infos = XmapNewArray(XFontStruct *, NUM_FONTS);
  load_named_fonts(gdisp, font_names, fonts, font_infos, NUM_FONTS);
  fprintf(stderr, "Screen Pixel Depth=%d \n Number of Colors: %d\n", default_depth,
	  numcols);

  if((source_file = getenv("XMA_SPE_SRC")) != NULL)
    strcpy(oneplot->src_dump_file, source_file);
  else strcpy(oneplot->src_dump_file, "DUMP_SRC");

  strcpy(oneplot->origin_file, nargv[1]);

  /* fprintf(stderr,"src_dump %s  org=%s\n",oneplot->src_dump_file,
     oneplot->origin_file); */

  /* Read the origin file */
  Get_org(&oneplot->origin, nargv[1]);
  Dump_org(&oneplot->origin);
  org_type = oneplot->origin.type;
  oneplot->project_type = oneplot->origin.proj;


  /*  copy all the input params for later use  */

  oneplot->nargc = nargc;
  oneplot->nargv = XmapNewArray(char *, nargc);
  for(i = 0; i < nargc; i++) oneplot->nargv[i]= nargv[i];
  

  /* override the projection  */

  if(nargc >= 4)
    {
    for(i = 4; i < nargc; i++)
      {
      if(strcmp(nargv[i], "-P") == 0)
	{
	projtype = atoi(nargv[i + 1]);
	break;
	}
      }
    }
  oneplot->origin.maxx = oneplot->origin.nxblk * oneplot->origin.dx;
  oneplot->origin.maxy = oneplot->origin.nyblk * oneplot->origin.dy;

  shiftx = screenx - 2 * xmarg;
  shifty = screeny - 2 * ymarg;

  if(shifty <= shiftx)
    {
    screeny = shifty;
    screenx = (int)((float)screeny * oneplot->origin.maxx
		    / oneplot->origin.maxy);
    }
  else
    {
    screenx = shiftx;
    screeny = (int)((float)screenx * oneplot->origin.maxy
		    / oneplot->origin.maxx);
    }

  /* fill up the origin structure */

  oneplot->origin.minx = 0.0;
  oneplot->origin.miny = 0.0;

  /*
   * if (oneplot->project_type <= 1 && org_type <= 1 &&
   * oneplot->origin.maxx > 300.0 || oneplot->origin.maxy > 300.0) {
   * fprintf(stderr," The target area is very large, switching to
   * ALbers conic eq area projection  \n"); oneplot->project_type = 2;
   * }
   */

  fprintf(stderr, "org_type = %d map projection = %d \n", oneplot->origin.type,
	  oneplot->origin.proj);

  if(org_type <= 1)
    {
    /* find lower left corner  */
    garb1 = oneplot->origin.miny;
    garb2 = oneplot->origin.minx;


    if(oneplot->origin.proj!=5)
      {
      
      oneplot->origin.lammin = fix_lon(oneplot->origin.lam);
      oneplot->origin.phimin = oneplot->origin.phi;
      }
    else
      {
      oneplot->origin.lammin = oneplot->origin.lam;
      oneplot->origin.phimin = oneplot->origin.phi;     
      }
    

    /*  upper right  corner  */
    garb1 = oneplot->origin.maxy;
    garb2 = oneplot->origin.maxx;
    
    jlcgc(oneplot->origin.phi, oneplot->origin.lam, &phi, &lam, garb1, garb2);
    fprintf(stderr,"xm7 1: %f %f\n", phi, lam);
 
    oneplot->origin.phimax = phi;
    
    if(oneplot->origin.proj!=5)
      {
	
	oneplot->origin.lammax = fix_lon(lam);
      }
    
    else
      {
	oneplot->origin.lammax = lam;
      }
    
    
    fprintf(stderr, "Bounds 1: x1=%f x2=%f y1=%f y2=%f \n",
	      oneplot->origin.minx, oneplot->origin.maxx,
	    oneplot->origin.miny, oneplot->origin.maxy  );
    
    fprintf(stderr, "Bounds 1: p1=%f p2=%f l1=%f l2=%f \n",
	    oneplot->origin.phimin, oneplot->origin.phimax,
	    oneplot->origin.lammin, oneplot->origin.lammax  );
    
    
    switch(oneplot->project_type)
      {
      case 0:
        start_ngclc(oneplot->origin.phimin, oneplot->origin.lammin);
	break;
	
      case 1:
	break;
	
      case 2:
	start_albers(&oneplot->origin);
	break;
	
      case 3:
	
	start_merc_sphr(&oneplot->origin);
	
	break;
	
      case 4:
	
	lon1 = fix_lon(oneplot->origin.lammin);
	lon2 = fix_lon(oneplot->origin.lammax);
	/*
	  if(lon1 < 0.0 && lon2 >= 0.0) lon2 -= 360;
	  if(cenlon < -180) cenlon += 360;
	  if(cenlon > 180) cenlon -= 360;
	  */
	cenlon = (lon1 + lon2) / 2;
        
	start_miller_sphr(oneplot->origin.phimin, oneplot->origin.lammin,
			  cenlon);
	break;
	
      case 5:
	start_no_proj(oneplot->origin.phimin, oneplot->origin.lammin);
	break;
	
      case 6:
	start_utm_sphr(oneplot->origin.phimin, oneplot->origin.lammin);
	break;
	  
      case 7:
	start_utm_ellipsoid(oneplot->origin.phimin, oneplot->origin.lammin);
	break;
	
      case 8:
	start_cen_utm_sphr(&oneplot->origin);
	break;

      case 9:
	start_cen_utm_ellipsoid(&oneplot->origin);
	break;
	
      case 10:
	fprintf(stderr,"lam0=%f phi0=%f\n",oneplot->origin.lam0,  oneplot->origin.phi0);
	start_Lambert_Az_sphr(oneplot->origin.phi0,  oneplot->origin.lam0,oneplot->origin.phi,  oneplot->origin.lam);
	break;
	


      default:
	break;
      }
    }

  /*
   * fprintf(stderr, "x1=%f x2=%f y1=%f y2=%f \n",oneplot->origin.minx,
   * oneplot->origin.maxx, oneplot->origin.miny, oneplot->origin.maxy);
   * 
   * fprintf(stderr, "p1=%f p2=%f l1=%f l2=%f \n",oneplot->origin.phimin,
   * oneplot->origin.phimax, oneplot->origin.lammin,
   * oneplot->origin.lammax  );
   */
  if(org_type == 2)
    {
      /*
       * fprintf(stderr,"dx=%f dy=%f p1=%f p2=%f l1=%f l2=%f x1=%f
       * x2=%f y1=%f y2=%f\n", oneplot->origin.dx,
       * oneplot->origin.dy, oneplot->origin.phimin,
       * oneplot->origin.phimax, oneplot->origin.lammin,
       * oneplot->origin.lammax, oneplot->origin.maxx,
       * oneplot->origin.minx, oneplot->origin.maxy,
       * oneplot->origin.miny);
       */
      
      fprintf(stderr, "Bounds: type2 x1=%f x2=%f y1=%f y2=%f \n"
	      ,oneplot->origin.minx, oneplot->origin.maxx,
	      oneplot->origin.miny, oneplot->origin.maxy  );
     
      fprintf(stderr, "Bounds: type2 p1=%f p2=%f l1=%f l2=%f \n",
	      oneplot->origin.phimin, oneplot->origin.phimax,
	      oneplot->origin.lammin, oneplot->origin.lammax  );
      
      switch(oneplot->project_type)
	{
	case 0:
	  start_ngclc(oneplot->origin.phimin, oneplot->origin.lammin);
	  break;
	  
	case 2:
	  start_albers(&oneplot->origin);
	  
	  break;
	  
	case 3:
	  
	  start_merc_sphr(&oneplot->origin);
	  
	  break;
	  
	case 4:
	  lon1 = fix_lon(oneplot->origin.lammin);
	  lon2 = fix_lon(oneplot->origin.lammax);
	
	  cenlon = (lon1 + lon2) / 2;
	  /**************   should add this code in the main code  ****/
          if(lon1>=0 && lon2<0)
	    {
	      cenlon = (lon1 + (360+lon2))/2;
	    }
	  
	
	  fprintf(stderr, "lin1 = %f lon2 = %f  cenlon = %f\n", lon1, lon2, cenlon);
	  

	  start_miller_sphr(oneplot->origin.phimin, oneplot->origin.lammin,
			    cenlon);
	  break;
	
	case 5:
	  start_no_proj(oneplot->origin.phimin, oneplot->origin.lammin);
	  break;
	  
	case 6:
	  start_utm_sphr(oneplot->origin.phimin, oneplot->origin.lammin);
	  break;
	  
	case 7:
	  start_utm_ellipsoid(oneplot->origin.phimin, oneplot->origin.lammin);
	  break;
	  
	case 8:
	  start_cen_utm_sphr(&oneplot->origin);
	  break;
	
	case 9:
	  start_cen_utm_ellipsoid(&oneplot->origin);
	  break;
	
    case 10:
	fprintf(stderr,"lam0=%f phi0=%f\n",oneplot->origin.lam0,  oneplot->origin.phi0);
	
	start_Lambert_Az_sphr(oneplot->origin.phi0,  oneplot->origin.lam0,oneplot->origin.phi,  oneplot->origin.lam);
	break;
	



	default:
	  break;
	}

    phi = oneplot->origin.phimin;
    lam = oneplot->origin.lammax;

    geo2xy(oneplot, phi, lam, &bx1, &by1);
    oneplot->origin.maxx = bx1;

    phi = oneplot->origin.phimax;
    lam = oneplot->origin.lammin;

    geo2xy(oneplot, phi, lam, &bx1, &by1);
    oneplot->origin.maxy = by1;
    oneplot->origin.dx = oneplot->origin.maxx / oneplot->origin.nxblk;
    oneplot->origin.dy = oneplot->origin.maxy / oneplot->origin.nyblk;
    }

  strcpy(oneplot->Overall_title, " ");

  
#if DIAGNOST
    fprintf(stderr,
	    "dx=%f dy=%f p1=%f p2=%f l1=%f l2=%f x1=%f x2=%f y1=%f y2=%f\n", 
	    oneplot->origin.dx, oneplot->origin.dy,
	    oneplot->origin.phimin, oneplot->origin.phimax,
	    oneplot->origin.lammin, oneplot->origin.lammax,
	    oneplot->origin.maxx, oneplot->origin.minx, oneplot->origin.maxy,
	    oneplot->origin.miny);
    fprintf(stderr,
	    "nx=%d ny=%d\n", 
             oneplot->origin.nxblk, oneplot->origin.nyblk );

      fprintf(stderr,"1 %d %d %d %d %f %f\n",
	      oneplot->project_type,
oneplot->origin.nxblk, oneplot->origin.nyblk,
	      oneplot->origin.nzblk, oneplot->origin.dx, oneplot->origin.dy);
  fprintf(stderr,"%f\n%f\n", oneplot->origin.phimin, oneplot->origin.lammin);
  
	      
#endif

  /* figure out if the user has requested a 'simple' map with the -J option */
  /*
   * if yes, wait til later to read in the J or GMT map or a
   * complicated -M map    otherwise try to read in a default map
   */

  oneplot->num_map_files = 0;
  oneplot->force_source = 0;


  iyesno = 0;

  if(nargc >= 4)
    {
    for(i = 4; i < nargc; i++)
      {
      if((strcmp(nargv[i], "-J") == 0) || (strcmp(nargv[i], "-M") == 0)
	 || (strcmp(nargv[i], "-m") == 0)) iyesno = 1;

      if( (strcmp(nargv[i], "-force_source") == 0) )   oneplot->force_source = 1;


      }
    }

  if(iyesno == 0)
    {
    if((default_map = getenv("XMA_THEMAP")) != NULL)
      {
      strcat(default_map, "\0");
      fprintf(stderr, "   Trying default map, XMA_THEMAP=%s\n", default_map);
      if(strstr(default_map, "BIN") != NULL)
        iyesno = Get_Map3(default_map, oneplot);
      else iyesno = Get_Map2(default_map, oneplot);
      if(iyesno > 0)
        strcpy(oneplot->map[oneplot->num_map_files - 1].map_code,
	       "0abcdefghijklmnopqrst");
      /* Get_Map_GMT(default_map, oneplot); */
      }
    else
      {
      fprintf(stderr, "  No default map available, try setting  env variable"
	      " XMA_THEMAP\n");
      }
    }

  /*
   * if (oneplot->xy_map.numpoints > 0) oneplot->map_flag = 1; else
   * oneplot->map_flag = 0;
   */

  /********  STATION PLOT  *********/
oneplot->points_store = 0;
  oneplot->num_sta_files = 0;
  oneplot->sta_color = 7;
  oneplot->sta_col = 7;
  oneplot->special_station_color = 2;
  oneplot->sta_name_flag = 0;
  oneplot->special_sta_col = 13;
  oneplot->current_src = 0;
  oneplot->src_in_layer = 0;
  oneplot->foc_in_layer = 0;
  oneplot->max_more_src = 0;
  oneplot->src_color = 14;
  oneplot->num_labels = -1;
  oneplot->SourceSize = 3;
  oneplot->SourceSlope = 3.6*8.0;
  oneplot->max_mag = -999;
  oneplot->min_mag = 999;
  oneplot->MaxDepth = oneplot->origin.nzblk;
  oneplot->MinDepth = 0.0;
  oneplot->image_flag = 0;
  oneplot->image.nx = 0;
  oneplot->image.ny = 0;
  oneplot->image.nz = 0;
  oneplot->src_flag = 1;
  oneplot->fancy_src_flag = 0;
  oneplot->mag_src_flag = 1;
  oneplot->time_src_flag = 0;
  oneplot->time_plot_wait = 5.0;
  oneplot->more_src_flag = 0;
  oneplot->special_station_flag = 0;
  oneplot->current_sta = 0;
  oneplot->add_poly_lines = 0;
  oneplot->grid_flag = 0;
  oneplot-> map_point_flag = 0;

  oneplot->foc_summary_flag = 0;

  oneplot->foc_auto_summary_flag = 0;
  oneplot->Hi_Lite_flag = 0;
  oneplot->Integrate_flag = 0;
  oneplot->Draw_spline_flag = 0;
  oneplot->Replot_Poly_flag = 0;
  oneplot->Replot_target_flag = 0;

  
  oneplot->geotab_flag = 0;
  oneplot->stuff_flag = 1;
  oneplot->connect_flag = 0;
  oneplot->zoom_flag = 0;
  oneplot->zoom_flag2 = 0;
  oneplot->picsource_flag = 0;
  oneplot->picsource_outflag = 1;
  oneplot->zoom.numpoints = 0;
  oneplot->picsource.numpoints = 0;
  oneplot->plot_cont_flag = 0;
  oneplot->plot_cont_points = 0;
  oneplot->plot_cont_values = 0;
  oneplot->SourceSize = 3;
  oneplot->src_depth_color = 0;
  oneplot->size_sta = 4;
  oneplot->point_flag = 0;
  oneplot->point_onoff = 0;
  oneplot->current_point = 0;
  oneplot->size_well = 6;
  oneplot->wells_flag = 0;
  oneplot->wells_project_flag = 1;
  oneplot->wells_symbol_flag = 1;
  oneplot->wells_name_flag = 0;
  oneplot->wells_proj_all = 0;
  oneplot->wells_thickness = 1;
  oneplot->plot_well_leg = 0;
  oneplot->num_well_leg = 0;
  
  oneplot->size_focm = 24;
  oneplot->focm_flag = 0;
  oneplot->focm_color = 0;
  oneplot->focal_explode = 0;
  oneplot->focal_selection = 0;
  oneplot->focal_plot_style = 1;
  oneplot->focal_mag_scale = 1;
  oneplot->focal_current = 0;
  oneplot->focal_total_num = 0;
  oneplot->num_focm_files = 0;
  oneplot->num_wells_files = 0;
  oneplot->screen_size_flag = 1;
  /* preset colors..... */
  oneplot->xsec_flag = 1;
  oneplot->src_color = 14;
  oneplot->BW_flag = 0;
  oneplot->stuff_color = 3;
  oneplot->title_color = 6;
  oneplot->map_color = 3;
  oneplot->bord_color = 2;
  oneplot->picsource_color = 5;
  oneplot->num_xsec = -1;
  oneplot->hoz_slab_flag = 0;
  oneplot->hoz_slab_top = -10;
  oneplot->hoz_slab_bot = 6370;
  oneplot->wire_flag = 0;
  oneplot->wire_num = 0;
  oneplot->wire_tot = 0;
  oneplot->lip_flag = 0;
  oneplot->lip_num = 0;
  oneplot->lip_tot = 0;
  oneplot->halfwidth = 1.0;
  oneplot->halfwidth = (oneplot->origin.nxblk * oneplot->origin.dx) / 24.0;
  oneplot->ScreenX = screenx;
  oneplot->ScreenY = screeny;
  oneplot->LocX = 50;
  oneplot->LocY = 50;
  oneplot->num_colors = numcols;
  oneplot->num_fixed_colors = 60;
  oneplot->NumPal= 2;
  oneplot->Pal_index[0] = oneplot->num_fixed_colors;
  oneplot->Pal_num[0] = 40;
  oneplot->Pal_num[1] = 40;
  oneplot->Pal_index[1] = oneplot->num_fixed_colors + 40;
  oneplot->Which_Pal = 0;
  oneplot->Reverse_Pal = 0;
  oneplot->MinColor = oneplot->Pal_index[oneplot->Which_Pal];
  oneplot->MaxColor = oneplot->MinColor + oneplot->Pal_num[oneplot->Which_Pal]-1;
  /* initialize color scheme   */
  oneplot->special_src_col = 13;
  oneplot->special_perim_col = 21;
  oneplot->special_name_col = 1;
  oneplot->back_label_col = 0;
  oneplot->name_label_col = 2;
  oneplot->date_col = 3;
  oneplot->fill_arc_col = 21;
  oneplot->draw_arc_col = 25;
  oneplot->fancy_src_col = 21;
  oneplot->fancy_perim_col = 14;
  oneplot->magscale_col = 1;
  oneplot->special_station_col = 19;
  oneplot->exploding_line_col = 1;
  oneplot->back_foc_col = 1;
  oneplot->ptax_col = 0;
  oneplot->faultplane_col = 0;
  oneplot->strikeslip_col = 18;
  oneplot->rev_oblSS_col = 23;
  oneplot->obl_rev_col = 22;
  oneplot->reverse_col = 21;
  oneplot->norm_oblSS_col = 19;
  oneplot->oblq_norm_col = 20;
  oneplot->normal_col = 2;
  oneplot->xsec_col = 1;
  oneplot->box_xsec_col = 18;
  oneplot->zoom_box_col = 22;
  oneplot->spline_col = 22;
  oneplot->spline_points_col = 1;
  oneplot->bord_col = 2;
  oneplot->back_fill_col = 24;
  oneplot->stuff_col = 3;
  oneplot->map_col = 3;
  oneplot->src_col = 14;
  oneplot->title_col = 6;
  oneplot->picsource_col = 5;
  oneplot->text_col = 3;
  oneplot->background_col = 0;
  oneplot->foreground_col = 1;

  modify_color_scheme(oneplot);

  for(i = 0; i < numcols; i++)
    {
    oneplot->jmlcol[i].red = jmlcol[i].red;
    oneplot->jmlcol[i].green = jmlcol[i].green;
    oneplot->jmlcol[i].blue = jmlcol[i].blue;
    }

  envformat = getenv("XMA_HYPO_FORMAT");

  /* setenv XMA_HYPO_FORMAT UW  */

  if(envformat == NULL)
    {
    fprintf(stderr, "env variable: XMA_HYPO_FORMAT not set.  Using default"
	    " UW format hypocenters\n");
    envformat = "UW";
    }
  strcpy(oneplot->hypo_format_str, envformat);

  
 
  /*
   * fprintf(stderr,"entering the MAIN loop\n");	fprintf(stderr,"
   * number of colors: %d\n", numcols); fprintf(stderr,"  number of
   * fonts: %d\n", NUM_FONTS);
   */
 
  XtVaSetValues(top, XtNwidth, screenx, XtNheight, screeny, XtNx, Xloc,
		XtNy, Yloc, NULL);

  
fprintf(stderr,"entering the MAIN loop\n");
 

  if(oneplot->project_type <= 1)
    {
    oneplot->origin.minx = 0.0;
    oneplot->origin.maxx = oneplot->origin.nxblk * oneplot->origin.dx;
    oneplot->origin.miny = 0.0;
    oneplot->origin.maxy = oneplot->origin.nyblk * oneplot->origin.dy;
    }

  if(oneplot->project_type > 1)
    {
    oneplot->origin.minx = 0.0;
    oneplot->origin.miny = 0.0;
    phi = oneplot->origin.phimin;
    lam = oneplot->origin.lammax;
    geo2xy(oneplot, phi, lam, &bx1, &by1);
    oneplot->origin.maxx = bx1;
    phi = oneplot->origin.phimax;
    lam = oneplot->origin.lammin;
    geo2xy(oneplot, phi, lam, &bx1, &by1);
    oneplot->origin.maxy = by1;
    }

  if(nargc >= 3)
    {
    oneplot->current_sta = oneplot->num_sta_files;
    iyesno = Get_Stations(nargv[2], oneplot);
    fprintf(stderr, "Number of Stations Files = %d\n", oneplot->num_sta_files);
    oneplot->stations[oneplot->current_sta].symbol = 0;
    }

  if(nargc >= 4) iyesno = Get_Sources(nargv[3], oneplot);

  oneplot->zoom_flag2 = 0;
  oneplot->zoom.numpoints = 0;
  oneplot->zoom.zooms[oneplot->zoom.numpoints].x1 = oneplot->origin.minx;
  oneplot->zoom.zooms[oneplot->zoom.numpoints].x2 = oneplot->origin.maxx;
  oneplot->zoom.zooms[oneplot->zoom.numpoints].y1 = oneplot->origin.miny;
  oneplot->zoom.zooms[oneplot->zoom.numpoints].y2 = oneplot->origin.maxy;
  
fprintf(stderr,"Parsing parameters....\n");
 
  if(nargc >= 4)
    {
    for(i = 4; i < nargc; i += 2)
      {
      sscanf(nargv[i], "%s", parse_flag);
      fprintf(stderr, "%d %s\n", i, parse_flag);
      if(parse_flag[0] == '-')
	{
	switch(parse_flag[1])
	  {
	  case 'P':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    oneplot->project_type = atoi(parse_flag);
	    fprintf(stderr, "Map set = %s\n", parse_flag);
	    break;

	  case 'p':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Points set = %s\n", parse_flag);
	    Get_Point_Labs(parse_flag, oneplot);
	    break;

	  case 'Y':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "WireFrame set = %s\n", parse_flag);
	    Get_ThreeD(parse_flag, oneplot);
	    break;

	  case 'C':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    /* may have to delay this until after the making of the widgets */
	    do_get_cont = 1;
	    fprintf(stderr, "Contour set = %s\n", parse_flag);
	    oneplot->field_name = parse_flag;
	    /* strcpy(oneplot->field_name, parse_flag); */
	    /* Do_Contour_Field_NoDISP(parse_flag, oneplot); */
	    break;

	  case 'B':
	    oneplot->BW_flag = 1;
	    break;

	  case 'D':
	    sscanf(nargv[i + 1], "%f", &garb1);
	    oneplot->MaxDepth = garb1;
	    fprintf(stderr, "Max Depth: %f\n", garb1);
	    break;

	  case 'z':
	    sscanf(nargv[i + 1], "%f", &garb1);
	    oneplot->MinDepth = garb1;
	    fprintf(stderr, "Min Depth: %f\n", garb1);
	    break;

	  case 'Z':
	    sscanf(nargv[i + 1], "%f", &garb1);
	    oneplot->MaxDepth = garb1;
	    fprintf(stderr, "Max Depth: %f\n", garb1);
	    break;

	  case 'w':
	    sscanf(nargv[i + 1], "%f", &garb1);
	    oneplot->halfwidth = garb1;
	    fprintf(stderr, "halfwidth set: %f\n", garb1);
	    break;

	  case 'F':
	    kparse = strlen(parse_flag);
	    fprintf(stderr, "parseflag=%d %s\n", kparse, parse_flag);
	    strcpy(focal_format,"uw");
	    
	    if(kparse > 2)
	      {
	      strncpy(focal_format, parse_flag + 2, kparse);
	      fprintf(stderr, "focal format = %s\n", focal_format);
	      }
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    oneplot->focm_flag = 2;
	    fprintf(stderr, "Focals set = %s\n...Please wait, doing"
		    " calculations....\n", parse_flag);
	    if(strcmp(focal_format,"ext")==0)
	      {
		
		fprintf(stderr, "focal format = %s\n", focal_format);
		Get_Focs_Ext(parse_flag, oneplot);
		Init_Focs(oneplot);
		
	      }
	    else
	      {
		  
	      
		Get_Focs(parse_flag, oneplot);
		Init_Focs(oneplot);
		Set_Explode_Focs(oneplot);
		
	      }
	    
	    
	    break;

	  case 'I':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Image set = %s\n", parse_flag);
	    oneplot->image_flag = 1;
	    iyesno = Get_Image(parse_flag, oneplot);
	    break;

	  case 'W':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Wells set = %s\n", parse_flag);
	    oneplot->wells_flag = 2;
	    iyesno = Get_Wells(parse_flag, oneplot);
	    break;

	  case 'E':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Ellipse set = %s\n", parse_flag);
	    oneplot->lip_flag = 1;
	    iyesno = Get_Lips(parse_flag, oneplot);
                  	    break;

	  case 'S':
	    kparse = strlen(parse_flag);
	    fprintf(stderr, "parseflag=%d %s\n", kparse, parse_flag);
	    if(kparse > 2)
	      {
	      strncpy(source_format, parse_flag + 2, kparse);
	      fprintf(stderr, "source format = %s\n", source_format);
	      strcpy(oneplot->hypo_format_str, source_format);
	      }
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Source set = %s\n", parse_flag);
	    oneplot->more_src_flag = 1;
	    oneplot->current_src = oneplot->max_more_src;
	    iyesno = Get_Sources(parse_flag, oneplot);
	    fprintf(stderr, "max_more_src = %d\n", oneplot->max_more_src);
	    break;

	  case 'R':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Station set = %s\n", parse_flag);
	    oneplot->current_sta = oneplot->num_sta_files;
	    iyesno = Get_Stations(parse_flag, oneplot);
	    oneplot->stations[oneplot->current_sta].symbol = 0;
	    fprintf(stderr, "Number of Stations Files = %d\n",
		    oneplot->num_sta_files);
	    break;

	  case 'r':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Station set = %s\n", parse_flag);
	    oneplot->current_sta = oneplot->num_sta_files;
	    iyesno = Get_Stations(parse_flag, oneplot);
	    fprintf(stderr, "Number of Stations Files = %d\n",
		    oneplot->num_sta_files);
	    sscanf(nargv[i + 2], "%s", parse_flag);
	    if(iyesno > 0)
	      oneplot->stations[oneplot->current_sta].symbol
	        = atoi(parse_flag);
	    i++;
	    break;

	  case 'J':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Map set = %s\n", parse_flag);
	    Get_Map_GMT(parse_flag, oneplot);
	    if(oneplot->xy_map.numpoints > 0) oneplot->map_flag = 1;
	    else oneplot->map_flag = 0;
	    break;

	  case 'M':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Map set = %s\n", parse_flag);
	    if(strstr(parse_flag, "BIN") != NULL)
	      iyesno = Get_Map3(parse_flag, oneplot);
	    else iyesno = Get_Map2(parse_flag, oneplot);
	    if(iyesno > 0)
	      strcpy(oneplot->map[oneplot->num_map_files - 1].map_code,
		     "0abcdefghijklmnopqrst");
	    break;

	  case 'm':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Map set = %s\n", parse_flag);
	    if(strstr(parse_flag, "BIN") != NULL)
	      iyesno = Get_Map3(parse_flag, oneplot);
	    else iyesno = Get_Map2(parse_flag, oneplot);
	    sscanf(nargv[i + 2], "%s", parse_flag);
	    if(iyesno > 0)
	      strcpy(oneplot->map[oneplot->num_map_files - 1].map_code,
		     parse_flag);
	    i++;
	    break;

	  case 'X':
	    do_get_xsec = 1;
	    sscanf(nargv[i + 1], "%s", xsecfile);
	    fprintf(stderr, "Xsect set = %s\n", xsecfile);
	    break;

	  case 'Q':
	    Post_Out = 1;
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    strcpy(post_file, parse_flag);
	    fprintf(stderr, "Post File set = %s\n", post_file);
	    break;

	  case 'T':
	    sscanf(nargv[i + 1], "%s", parse_flag);
	    fprintf(stderr, "Title set = %s\n", parse_flag);
	    strcpy(oneplot->Overall_title, parse_flag);
	    for(j = 0; j < strlen(oneplot->Overall_title); j++)
	      {
	      if(oneplot->Overall_title[j] == '_')
	        oneplot->Overall_title[j] = ' ';
	      }
	    oneplot->Overall_title[strlen(oneplot->Overall_title)] = '\0';
	    break;

	  case 'G':	/* geometry  */
	    sscanf(nargv[i + 1], "%d", &igarb1);
	    Xloc = igarb1;
	    sscanf(nargv[i + 2], "%d", &igarb1);
	    Yloc = igarb1;
	    sscanf(nargv[i + 3], "%d", &igarb1);
	    screenx = igarb1;
	    sscanf(nargv[i + 4], "%d", &igarb1);
	    screeny = igarb1;
	    i += 3;

	    XtVaSetValues(top, XtNwidth, screenx, XtNheight, screeny,
			  XtNx, Xloc, XtNy, Yloc, NULL);
	    fprintf(stderr, "%d %d %d %d\n", win_x, win_y, win_hite,
		    win_width);
	    oneplot->LocX = Xloc;
	    oneplot->LocY = Yloc;
	    oneplot->ScreenX = screenx;
	    oneplot->ScreenY = screeny;
	    break;

	  case 'H':	/* help  */
          case 'h':
	    startup_help();
	    break;

	  }
	}
      }
    }

  init_xdipParms(oneplot);
  fprintf(stderr,"Making widgets...\n");
  make_mpic_window(top, oneplot, fonts);
  fprintf(stderr,"Setting colors...\n");
  colors = XmapNewArray(Pixel, COLORS_MAX);

  if(default_depth < 2)
    {
    colors[0] = BlackPixel(gdisp, gscr_num);
    for(i = 1; i < numcols; i++)
      colors[i] = WhitePixel(gdisp, gscr_num);

    colors[24] = BlackPixel(gdisp, gscr_num);
    }
  else
    {
    iyesno = 0;

    if(nargc >= 4)
      {
      for(i = 4; i < nargc; i++)
	{
	if((strcmp(nargv[i], "-L") == 0))
	  {
	  iyesno = 1;
	  sscanf(nargv[i + 1], "%s", parse_flag);
	  }
	}
      }
    if(iyesno == 0)
      {
      gcol = XDefaultColormap(gdisp, gscr_num);
      alloc_named_colors(gdisp, gcol, &(color_names[0][0]), colors, numcols);
      oneplot->plotsat_flag = 0;
      }
    else
      {
      fprintf(stderr, "%s\n", parse_flag);

      if(!XMatchVisualInfo(gdisp, gscr_num, DefaultDepth(gdisp, gscr_num),
			   PseudoColor, &vis))
	{
	fprintf(stderr, "visual info match failed.\n");
	exit(-1);
	}
      gcol = XCreateColormap(gdisp, XtWindow(oneplot->wij), vis.visual,
			     AllocNone);

      if(!XAllocColorCells(gdisp, gcol, False, NULL, 0, colors, COLORS_MAX))
	{
	fprintf(stderr, "colorcell allocation failed.\n");
	exit(-1);
	}
      alloc_named_colorsSAT(gdisp, gcol, &(color_names[0][0]), colors,
			    numcols, parse_flag, &(oneplot->satimage));
      XtVaSetValues(top, XtNcolormap, gcol, NULL);
      oneplot->plotsat_flag = 1;
      oneplot->satimage_flag = 1;

      /* XSetBackground(gdisp, oneplot->ggc, WhitePixel(gdisp,gscr_num)); */
      XSetBackground(gdisp, oneplot->ggc, colors[0]);

      /* XtVaSetValues(oneplot->vport, XtNcolors, numcols, XtNcolormap, gcol,
	 NULL); */

      }
    }

  oneplot->colors = colors;
  oneplot->colmap = gcol;

 
  
  /* this version uses the min-max x-y in km's to determine the LAT-LON
     tics  */

  if(org_type == 2) Get_Stuff2(oneplot);
  else Get_Stuff1(oneplot);

  if(do_get_cont == 1)
    Do_Contour_Field_NoDISP(oneplot->field_name, oneplot);

  if(do_get_xsec == 1)
    {
    window(&oneplot->gr, (double)oneplot->origin.minx,
	   (double)oneplot->origin.maxx, (double)oneplot->origin.miny,
	   (double)oneplot->origin.maxy);
    viewport(&oneplot->gr, 35, 500, 20, 500);
    iyesno = Load_Xsec(xsecfile, oneplot);
    }

  if(Post_Out == 1)
    {
    if(oneplot->plot_cont_flag == 1) oneplot->plot_cont_points = 1;
    Do_Postscript(gdisp, post_file, oneplot);
    exit(0);
    }

  /*
   * if(default_depth<2) { XSetForeground(gdisp, oneplot->ggc,
   * WhitePixel(gdisp,gscr_num)); XSetBackground(gdisp, oneplot->ggc,
   * BlackPixel(gdisp,gscr_num)); }
   */


    if( ( jinput = getenv("XMA_PALETTE_REV")) == NULL)
       {
       oneplot->Reverse_Pal =0;
       
       }
    else
       {
       oneplot->Reverse_Pal = atoi(jinput);
       if(oneplot->Reverse_Pal==1)
        flip_color_palette(oneplot);
       }

 i = change_ps_colors(oneplot);


  /*
    colors[i] = rgb.pixel;
     fprintf(stderr,"Extra color[%d]=   %d %d %d : %ld\n", i, rgb.red, rgb.green,
       rgb.blue, rgb.pixel);
       */




 /*
  for(i=0; i<COLORS_MAX; i++)
    {

      rgb.pixel = i;
    
      XQueryColor(gdisp, oneplot->colmap , &rgb);
fprintf(stderr,"Oneplot color[%d] :   %d %d %d : %ld\n", i, rgb.red, rgb.green,
       rgb.blue, rgb.pixel);
    }
*/
  fprintf(stderr,"Going to main loop...\n");

   Set_1_1(oneplot);

  XtAppMainLoop(apcon);

 
  
  }

/* ----------------------------------------------------- */
