dumphinvFLIP <-
function(A, PTS, SENSOR=NULL , fout="foc.lst" )
  {
    if(missing(fout)) { fout="foc.lst" }
    if(missing(SENSOR)) { SENSOR=NULL }

   
       
       REVS = setSENSOR(A, SENSOR)

     ACON = file(description =fout, open = "w")

    
    phiorg= A$LOC$lat
    lamorg= A$LOC$lon
    hozerr= A$LOC$hozerr
    verterr=A$E$sterrz
    gap = A$LOC$gap
    delta = A$LOC$delta
    rms= A$LOC$rms
    depth= A$LOC$z
    serrmag = A$E$sterrmag
    mag = A$LOC$mag



    iphi1 = floor(phiorg); 
    iphi2 =  floor(((phiorg-iphi1)*6000.0 ));
    temlam = lamorg;
    if(lamorg< 0.0)
      {
        temlam = -lamorg;
      }
    ilam1 = floor(temlam); 
    ilam2 =  floor(((temlam-ilam1)*6000.0 ));

    idep = floor(depth*100);

    irms = floor(rms*100);
    if(is.na(mag)) mag = 0
    imag = floor(mag*10);
    ismmag1 = floor(serrmag*100);
    if(is.na(ismmag1)) ismmag1 = 0
    ismaz1 = floor(0);
    ismaz2 = floor(0);
    iintaz1=floor(0);
    iintaz2= floor(0);
    iintmag=floor(0);
    idurmag =floor(0);
    ilargerr = floor(0);
    ihozerr=floor(hozerr*100);
    iverterr = floor(verterr*100);

    igap = floor(gap);
    idelta = floor(delta);


    hrmk="   ";
    
    yy = A$LOC$yr-2000
    mo=A$LOC$mo
    dd=A$LOC$dom
    hh=A$LOC$hr
    mi=A$LOC$mi
    isec=floor(A$LOC$sec*100)

    nump = length(PTS$parr[!is.na(PTS$parr)])
    nums= length(PTS$sarr[!is.na(PTS$sarr)])
    numpols = length(PTS$pol[!is.na(PTS$parr) & !is.na(PTS$pol)] )

    H1 = sprintf("%02d%2d%2d%2d%2d%4d%2d %4d%3d %4d%5d%2d%3d%3d%3d%4d%3d%2d%4d%3d%2d%4d%2d%4d%4d%4d%4d%2d",
      yy,mo,dd,hh,mi,isec,
      iphi1,iphi2,ilam1,ilam2,
      idep, imag,nump, igap,idelta,irms,ismaz1,ismaz2,
      ismmag1, iintaz1,iintaz2,iintmag ,idurmag,
      ilargerr,
      nums, ihozerr,iverterr,numpols)

    
    cat(" ", file = ACON, sep = "\n")
    cat(H1, file = ACON, sep = "\n")

##################################
##################################
##################################

    w = which(!is.na(PTS$pol) & !is.na(PTS$parr) )
   ##### print("HHAHAHAHAHAHHAHAHAHHAHAHHA")
   ##### print(cbind( REVS$name[w], REVS$updir[w],  PTS$pol[w], PTS$name[w] ) )

    
    for(i in 1:length(w) )
      {
        j = w[i]
        prmk=" P";
        hpol=PTS$pol[j];
        if(REVS$updir[j]<0)
          {
           if( PTS$pol[j]=="U")
             {
               hpol = "D"
             }
           if( PTS$pol[j]=="D")
             {
               hpol = "U"
             }
         }
        
           
        
        
        ipw=0;
        
        ipsec=floor((PTS$parr[j]*100.));
        if(is.na(ipsec)) ipsec = 0
        if(is.na(PTS$pres[j])) { ipres=0  }
        else { 
          ipres=floor(PTS$pres[j]*100.);
        }
       
        if(is.na(ipres)) ipres = 0
        if(ipres>9999)ipres=9999;
        
        ipuse=floor(PTS$perr[j]*100.);
        if(is.na(ipuse)) ipuse = 0
        
        issec=floor(0.0*100.);
        if(is.na(issec)) issec = 0
        
        srmk="  ";
        
        iswgt=0;
        isres=0;
        
        imaxpp=0;
        isuse=floor(0*100.);
        if(is.na(isuse)) isuse = 0
#####/*   for now, leave out the p and s delays  */

        ipdel=0;
        isdel=0;
        idist=round(10.*PTS$dis[j]);
        if(is.na(idist)) idist = 0
        iang= round(PTS$angP[j]);
         if(is.na(iang)) next
        iclock=0;
        astarmk="0";
        idur=0;

        
        iaz=round(fmod(PTS$gaz[j], 360));
        if(is.na(iaz)) next
        idurmag=0;
        iamp=0;
        iimpp=0;
        iimps=0;
        ##   fprintf(stderr,"%s %d %d %d \n", pick.chan.name, idist,iang, iaz);

  ##  print(paste(sep=' ', PTS$name[j],prmk,hpol,ipw,yy,mo,dd,hh,mi,
     ##       ipsec,ipres,ipuse,issec,srmk,iswgt,isres,imaxpp,isuse,
     ##       ipdel,isdel,
     ##       idist,iang,iclock,astarmk,idur,iaz,
     ##       idurmag,iamp,iimpp,iimps))


        

        Pcard = sprintf("%-4s%2s%1s%1d %2d%2d%2d%2d%2d%5d%4d%3d%5d%2s%2d%4d%3d%3d%4d%4d%4d%3d%5d%1s%4d%3d%2d%2d%4d%4d",
          PTS$name[j],prmk,hpol,ipw,yy,mo,dd,hh,mi,
          ipsec,ipres,ipuse,issec,srmk,iswgt,isres,imaxpp,isuse,
          ipdel,isdel,
          idist,iang,iclock,astarmk,idur,iaz,
          idurmag,iamp,iimpp,iimps)

       ## print(Pcard)
        cat(Pcard, file = ACON, sep = "\n")

      }
    close(ACON)

  }
