getPTS <-
function(pfile, stafile, velfile, UP= TRUE, zerostaz=FALSE)
  {
    ##########  fill up a strucuture showing the location of
    ##########  the points on the focal sphere of radiating double couple
      ##### zerostaz=TRUE forces the station elevations to be zero
    
    if(missing(UP)) UP = TRUE
    if(missing(zerostaz)) zerostaz=FALSE
    
    
    ####  if(is.character( pfile )){ Apf = getpfile(pfile) } else  { Apf = pfile }
    Apf = getpfile(pfile)
    V = Get1Dvel(velfile, PLOT=FALSE)
   
    sta =setstas(stafile)
     
    if(zerostaz) sta$z = rep(0, length(sta$z))
    
    MC = Apf$MC[[1]]

    
    if(length(sta$name)<1)  return(NULL)
    if(length(V$zp)<1) return(NULL)

    pstas = unique(Apf$STAS$name)
    savepoles = vector()
    parr = vector()
    sarr = vector()
    pres = vector()
    perr = vector()
    
    for(j in 1:length(pstas))
      {
        w = which(pstas[j]==Apf$STAS$name  & Apf$STAS$phase=="P")
        if(length(w)<1)
          {
            parr[j] = NA
        savepoles[j] = NA
            pres[j] = NA
        perr[j] = NA
          }
        else
          {
        parr[j] = Apf$STAS$sec[w]
        savepoles[j] = Apf$STAS$pol[w]
        pres[j] = Apf$STAS$res[w]
        perr[j] = Apf$STAS$err[w]
      }
        ws = which(pstas[j]==Apf$STAS$name  & Apf$STAS$phase=="S")
        
        if(length(ws)<1)
          {
            sarr[j] = NA
          }
        else
          { 
            sarr[j] = Apf$STAS$sec[ws]
          }
        
      }
   
    m1 = match(pstas, sta$name)

    #######  here there may be stations in the pickfile that are not in the station file!
    #######   if so, we really should remove these
    
    rem1 = which(is.na(m1))
 
    if(length(rem1)>0)
      {
        m1 = m1[-rem1]
        savepoles = savepoles[-rem1]
        parr = parr[-rem1]
        sarr = sarr[-rem1]
        pres = pres[-rem1]
        perr = perr[-rem1]
      }
  
    
###  cbind(Apf$STA$name[-rem1], sta$name[m1])
###  cbind(Apf$STA$name[-rem1], sta$name[m1])
    
 ###    savepoles = Apf$STAS$ppol[-rem1]
    
    name =sta$name[m1]
    lat=sta$lat[m1]
    lon=sta$lon[m1]
    z=sta$z[m1]
    
 ######  cbind(Apf$STA$name, sta$name[m1])

   
           
    
    Dis1 = GreatDist(Apf$LOC$lon,  Apf$LOC$lat , lon, lat )
    
    Ang1 = greatAz(Apf$LOC$lat,Apf$LOC$lon,lat, lon)

#####     plot(sta$lon[m1], sta$lat[m1])
#####points(Apf$LOC$lon,  Apf$LOC$lat, pch=3)
#####text(sta$lon[m1], sta$lat[m1], labels=formatC(Ang1) , pos=3)

    gaz=rep(NA,length(lat))
    angP=rep(NA,length(lat))
    angS=rep(NA,length(lat))
    ttP=rep(NA,length(lat))
    ttS=rep(NA,length(lat))
    idis=rep(NA,length(lat))
    
    for(i in 1:length(lat))
      {
      ######  print(paste(sep=' ',i, i, Apf$STA$name[i], name[i], Dis1$dkm[i]  ))
        if(is.na(name[i]) |  is.na(Dis1$dkm[i]) ) next
        dis = Dis1$dkm[i]
        hpz  =  Apf$LOC$z
        stz  = z[i]
        stn  = name[i]
   ######   print(paste(sep=' ',Apf$STA$name[i], name[i],  dis, hpz, stz))
################   need velocity for this program travel.time1D
        mytt = travel.time1D( dis, hpz, stz,  length(V$zp), V$zp, V$vp );
        gaz[i] = Ang1[i]
        angP[i] = mytt$angle
        ttP[i] =  mytt$tt
        mytt = travel.time1D( dis, hpz, stz,  length(V$zs), V$zs, V$vs ); 
        angS[i] = mytt$angle
        ttS[i] =  mytt$tt
      }

 if(is.null(MC))
   {
     MC = NULL
     MEC = NULL
     GP  = NULL
     GPV = NULL
     GPS = NULL
     GS = NULL
     GSV = NULL
     GSH = NULL
     
   }
 else
   {

     angsense = GetRakeSense(MC$U$az, MC$U$dip, MC$V$az, MC$V$dip,
       MC$P$az, MC$P$dip,MC$T$az, MC$T$dip)
     MEC = GetRake(MC$F$az-90,MC$F$dip ,  MC$G$az -90, MC$G$dip , angsense)
     
     phiS=MEC$az1
     del=MEC$dip1
     lam=MEC$rake1
     
     GP = radP( del, phiS, lam , angP, gaz)
     GPV = radSV( del, phiS, lam , angP, gaz)
     GPS = radSH( del, phiS, lam , angP, gaz)

     GS = radP( del, phiS, lam , angS, gaz)
     GSV = radSV( del, phiS, lam , angS, gaz)
     GSH = radSH( del, phiS, lam , angS, gaz)
   }
    QP = qpoint(gaz, angP, UP=UP, PLOT=FALSE)
    
    PTS = list(name=name, lat=lat, lon=lon,elev=z, parr=parr, sarr=sarr,
      pres=pres, perr=perr, pol = savepoles ,  gaz=gaz,  dis=Dis1$dkm ,
      angP=angP, angS=angS, ttP=ttP, ttS=ttS , strike=MEC$az1,  dip=MEC$dip1,
      rake=MEC$rake1, prad=GP, svrad=GPV, shrad=GPS, prad2=GS, svrad2=GSV,
      shrad2=GSH, Ex=QP$x, Ey=QP$y  )

    return(PTS)

  }
