getSENSORfile <-
function(SENSORfile=NULL)
  {
    ####  read in a SENSOR inforamtion file
    ### example:
      ###    DAS   Station   SENSOR_SN  SENSOR CHANS              TIME1   TIME2
      ###   945C    H11        999       L28    V.N.E     2005:184:00:00  2005:188:13:59
      ###   945C    H30        999       L28    V.N.E         2005:188:15:23  2005:225:13:24

### input A = pickfile structure, SENSOR = structure or file name to read in the structure
    if(missing(SENSORfile))
      {
        SENSORfile=NULL
      }
    if(is.list(SENSORfile))
      {
        if(length(SENSORfile$name)>0)
        return(SENSORfile)
      }
    if(!file.exists(SENSORfile))
      {
        SENSORfile=NULL
      }
    
    if(is.null(SENSORfile))
      {
        return(list(DAS=NA, name=NA, inst1=NA, inst2=NA,  chans=NA,  t1=NA, t2=NA, type=0, SENSORsensitivity(0)))
      }
      
    SENSOR = scan(file=SENSORfile, skip=1, list(DAS="", name="", inst1="", inst2="",  chans="",  t1="", t2=""), quiet=TRUE)
    N =length(SENSOR$inst2)
    if(N<1)
      {
        print("No SENSOR  file")
        return(list(DAS=NA, name=NA, inst1=NA, inst2=NA,  chans=NA,  t1=NA, t2=NA, type=0, SENSORsensitivity(0)))
      }
###   SENSOR$chan
    
    SENSOR$type = rep(0,length(SENSOR$inst2))
    
    SENSOR$type[grep("L28", SENSOR$inst2) ] = 3
    
    SENSOR$type[grep( "40T",  SENSOR$inst2) ] = 1
    
    
    SENSOR = c(SENSOR , SENSORsensitivity(SENSOR$type))

    
    CHANS =  SENSOR$chans
    ochans = strsplit(split='\\.', CHANS)
    
    tags = vector()
    flag = vector()
     k = 1 
    for( i in 1:length( ochans))
      {
        for(j in 1:length(ochans[[i]]))
          {
            tags[k] = paste(sep=".", SENSOR$name[i], ochans[[i]][j])
            flag[k] = i
            k = k + 1
          }
        

      }

    SENSOR$tags = tags
    SENSOR$flag = flag
    
    return(SENSOR)
    
  }
