printmc <-
function(MC, verbose=FALSE)
  {
    if(missing(verbose)) verbose=FALSE

    if(verbose)
      {
        print(paste(sep=" ", "F=", formatC(MC$F$az, digits=3, width=3) , formatC(MC$F$dip, digits=3, width=3) ,
                    "G=",formatC( MC$G$az , digits=3, width=3) , formatC(MC$G$dip, digits=3, width=3),
                    "U=",  formatC(MC$U$az, digits=3, width=3) , formatC(MC$U$dip, digits=3, width=3) ,
                    "V=",formatC( MC$V$az, digits=3, width=3) , formatC(MC$V$dip, digits=3, width=3) ,
                    "P=", formatC(MC$P$az, digits=3, width=3) , formatC(MC$P$dip, digits=3, width=3) ,
                    "T=", formatC(MC$T$az, digits=3, width=3) , formatC(MC$T$dip, digits=3, width=3) ))
      }


    Mcard = sprintf("M F %3d%3d G %3d%3d U %3d%3d V %3d%3d P %3d%3d T %3d%3d",
      round(MC$F$az), round(MC$F$dip), round(MC$G$az), round(MC$G$dip), round(MC$U$az),
      round(MC$U$dip), round(MC$V$az), round(MC$V$dip), round(MC$P$az ),
      round(MC$P$dip), round(MC$T$az), round(MC$T$dip))

    return(Mcard)
  }
