`seisglyph` <-
function(ampv, xv, inx1, inx2, iny1, iny2, lcol=0,  border=1, rcol=1, xaxis=TRUE, twd=1, xpd=TRUE)
  {
    ### plot time series as an insert to an existing plot
    ###  ampv = time series amplitude
    ###  xv =   x-axis
    ###  inx1, inx2, iny1, iny2 = location in plot where ts should be plotted
    ### lcol=0,  border=1, rcol=1 color of line, border of rect and rect fill
    ###  seisglyph(ampv, xz, inx1, inx2, iny1, iny2)
    

    if(missing(border)) { border=0 }
    if(missing(rcol)) { rcol=1 }
    if(missing(lcol)) { lcol=0 }
    if(missing(xaxis)) { xaxis=TRUE }
    if(missing(twd)) { twd=1 }
    if(missing(xpd)) { xpd=TRUE }
    

       z = RESCALE(ampv, iny1, iny2, min(ampv), max(ampv) )
       xz = RESCALE(xv,inx1,inx2, min(xv), max(xv))  

    if(!is.na(border) | !is.na(rcol) )
      {
       rect(inx1, iny1, inx2, iny2, col=rcol, border=border, xpd=xpd)
     }
    
       lines(xz,z, col=lcol, lwd=twd, xpd=xpd)

    if(xaxis)
      {
       tx=pretty(xv)
       tx = tx[tx<=max(xv)&tx>=min(xv)]
       txp = RESCALE(tx,inx1,inx2, min(xv), max(xv))
       segments(txp,rep(iny1, length(txp)), txp, rep(iny1+0.02*(iny2-iny1), length(txp)), xpd=xpd)
       segments(txp,rep(iny2, length(txp)), txp, rep(iny2-0.02*(iny2-iny1), length(txp)), xpd=xpd)
       text(txp,rep(iny2, length(txp)), labels=tx, pos=3, xpd=xpd)
     }
       
  }

