setSENSOR <-
function(A, SENSORfile=NULL)
  {
    
### input A = pickfile structure, SENSORfile = list of reversal times/
###   
    if(missing(SENSORfile))
      {
        
       
        print(paste(sep=' ', "NOTE: using default SENSORfile=",SENSORfile))
      }

    
    SENSOR =  getSENSORfile(SENSORfile)

    ##   set up return structure
    REVS = list(name=A$STAS$name,
      comp=A$STAS$comp,
      updir=rep(1, length(A$STAS$comp) ),
      sense=rep(1, length(A$STAS$comp) ),
      code=rep(1, length(A$STAS$comp) )
      )

    
    if(is.null(SENSORfile))
      {
         print(paste(sep=' ', "NOTE: BEWARE SENSORfile=NULL"))
        return(REVS)
      }
    else
      {
        tag1 = paste(sep=".", REVS$name, REVS$comp)

        
        g1 = grep('\\.V', tag1)
        
        m2 = match(  tag1[g1], SENSOR$tags )

       m1= m2[!is.na(m2)]
         g1=g1[!is.na(m2)]
        
        ###  cbind(tag1[g1], SENSOR$tags[m1])
        k1 = SENSOR$flag[m1]

        print( g1)
        print( k1)
        
        REVS$updir[g1] =  SENSOR$updir[k1]
        REVS$updir[is.na(REVS$updir)] = 1
        REVS$sense[g1]=  SENSOR$sense[k1]
        REVS$code[g1]=  SENSOR$code[k1]
       ##    cbind(REVS$name,REVS$comp, REVS$updir , REVS$code)
    ##   print(    cbind(REVS$name[g1],REVS$comp[g1],  SENSOR$tags[k1]  ))

        
        REVS$tags = tag1
        
      }
    
    return(REVS)
    
  }
