\name{FPF-package}
\alias{FPF-package}
\alias{FPF}
\docType{package}
\title{
Front end for fpfit
}
\description{
Use fpfit to calculate the focal mechanism.
}
\details{
\tabular{ll}{
Package: \tab FPF\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-07-25\cr
License: \tab GPL\cr
}
Program manipulates data as a wrapper or front end to
run the program fpfit on the system.
The code for fpfit can be obtained through the USGS,
or through my own website, in modified form.
}
\author{
Jonathan M. Lees<jonathan.lees.edu>
Maintainer:Jonathan M. Lees<jonathan.lees.edu>

}
\references{
Reasonberg, P.,  and  D. Oppenheimer,  FPFIT, FPPLOT AND FPPAGE: FORTRAN
Computer Programs For Calculating And Displaying Earthquake Fault-Plane
Solutions, U.S. GEOLOGICAL SURVEY OPEN-FILE REPORT NO. 85-739.

}

\keyword{ package }
\seealso{
RFOC
}
\examples{
\dontrun{
SENSOR =  getSENSORfile(SENSORfile)
 FOCPLOTPARAMS <<-   list(fkind=0, PLANES=TRUE, SEIS=FALSE,NAME=TRUE, POINTS=TRUE,
  PT=TRUE,
           NET=TRUE,TIT=TRUE,  MECUP=TRUE)

##  OUTDIR =  "/data/wadati/lees/Site/Hengil/DATA_RFORMAT"

##  hengilR=list.files(OUTDIR, pattern="R$", full.names=TRUE)

data(HENG)
pfile=HENG$pickfile

A = getpfile(pfile, stafile=stafile)

REVS = setSENSOR(A, SENSOR=SENSORfile )

sethpinv(fout="fpfit.inp", REV=REVS)

PTS = getPTS(HENG$pickfile, stafile, velfile, UP= TRUE)

runfpfit(A, PTS, SENSOR=SENSORfile)




}


}
