\name{HENG}
\alias{HENG}

\docType{data}
\title{Hengil Waveforms
}
\description{Seismic Waveform Data and Pickfile from Hengil Geothermal Field
}
\usage{data(HENG)}
\format{
  The format is:
List of 22
 $ JSTR     :List of 60
  ..$ : num [1:5000] -25.475 60.946 85.78 37.603 0.352 ...
  ..$ : num [1:5000] -49.18 -24.34 -6.46 -40.24 -71.03 ...
  ..$ : num [1:5000] 10.18 2.23 1.24 -17.14 9.68 ...
  ..$ : num [1:5000] 38.053 22.656 0.803 -23.534 -57.308 ...
  ..$ : num [1:5000] -23.43 9.84 24.74 46.1 65.47 ...
  ..$ : num [1:5000] 31.19 -9.04 -59.21 -90.5 -59.71 ...
  ..$ : num [1:5000] 1056 1613 2328 1947 1009 ...
  ..$ : num [1:5000] 24589 29009 32888 36037 38358 ...
  ..$ : num [1:5000] -14285 -11074 -8053 -4889 -1868 ...
  ..$ : num [1:5000] 748 636 538 378 218 ...
  ..$ : num [1:5000] 84.525 -17.293 -0.903 148.596 139.159 ...
  ..$ : num [1:5000] -1340 -1259 -1208 -1037 -762 ...
  ..$ : num [1:5000] -185 -365 -481 -481 -441 ...
  ..$ : num [1:5000] -732 -702 -647 -650 -714 ...
  ..$ : num [1:5000] -732 -804 -806 -716 -520 ...
  ..$ : num [1:5000] 535 615 950 1128 978 ...
  ..$ : num [1:5000] -281 -317 -241 -181 -182 ...
  ..$ : num [1:5000] -116.9 83.3 244.7 131 116.6 ...
  ..$ : num [1:5000] -766 -728 -669 -595 -503 ...
  ..$ : num [1:5000] 519 402 312 261 247 ...
  ..$ : num [1:5000] 328 283 221 179 170 ...
  ..$ : num [1:5000] -25.57 5.22 105.55 138.33 171.11 ...
  ..$ : num [1:5000] -243.1 -248.1 -92.6 63.8 157.2 ...
  ..$ : num [1:5000] 227.5 142.1 -78.4 -180.2 -101.8 ...
  ..$ : num [1:5000] -308 -381 -411 -380 -349 ...
  ..$ : num [1:5000] -90.73 23.01 31.95 -3.31 -47.52 ...
  ..$ : num [1:5000] 364 377 343 268 259 ...
  ..$ : num [1:5000] 24.3 -15.5 -43.8 -26.9 -15.5 ...
  ..$ : num [1:5000] 190 144.8 102.5 78.7 41.5 ...
  ..$ : num [1:5000] 26.4 104.9 192.3 250.9 238.5 ...
  ..$ : num [1:5000] 76.2 93.1 47.9 -16.6 -47.4 ...
  ..$ : num [1:5000] -59.4 -121.4 -202.9 -155.7 -31 ...
  ..$ : num [1:5000] -201 -173 -164 -190 -134 ...
  ..$ : num [1:5000] -156.07 -249.45 -335.37 -234.55 4.35 ...
  ..$ : num [1:5000] -134.5 -80.8 45.8 175 136.7 ...
  ..$ : num [1:5000] -184 -268 -203 -100 -130 ...
  ..$ : num [1:5000] 14.28 -29.43 -35.39 -24.96 -5.59 ...
  ..$ : num [1:5000] -175.7 20.5 192.3 193.8 27.5 ...
  ..$ : num [1:5000] 15.8 -171.4 -302.6 -279.7 -159.5 ...
  ..$ : num [1:5000] 14.59 -35.57 -23.65 4.66 -27.13 ...
  ..$ : num [1:5000] -21.7 -25.7 -23.2 -19.3 -59.5 ...
  ..$ : num [1:5000] 30.1 81.3 -25 -26 55 ...
  ..$ : num [1:5000] 38.7 24.3 11.9 21.4 46.7 ...
  ..$ : num [1:5000] 20.36 20.36 49.16 7.44 -1.99 ...
  ..$ : num [1:5000] 55.161 6.983 11.95 15.427 -0.467 ...
  ..$ : num [1:5000] -21.6 -77.7 -83.7 -88.6 -90.1 ...
  ..$ : num [1:5000] 83.7 17.2 -40 -44.4 -76.2 ...
  ..$ : num [1:5000] 49.3 49.3 11.1 19.5 22 ...
  ..$ : num [1:5000] -882 -2837 -4030 -3950 -1232 ...
  ..$ : num [1:5000] 18784 17162 14889 12027 9403 ...
  ..$ : num [1:5000] 18806 16818 14942 13177 11094 ...
  ..$ : num [1:5000] -31.3 -20.37 -19.38 -5.97 -15.41 ...
  ..$ : num [1:5000] 64.47 25.73 -5.07 11.82 91.29 ...
  ..$ : num [1:5000] 178 208 163 113 115 ...
  ..$ : num [1:5000] 68.3 -16.1 -27 28.1 27.1 ...
  ..$ : num [1:5000] -161.9 -161.4 -98.9 -23.4 24.3 ...
  ..$ : num [1:5000] 375.3 404.6 232.3 31.6 86.7 ...
  ..$ : num [1:5000] -64.9 -82.8 59.3 138.2 73.2 ...
  ..$ : num [1:5000] -168.83 -307.4 -166.84 3.52 145.57 ...
  ..$ : num [1:5000] -171.2 42.3 138.2 121.8 106.9 ...
 $ STNS     : chr [1:60] "H16" "H16" "H16" "H30" ...
 $ dir      :function (path = ".", pattern = NULL, all.files = FALSE, full.names = FALSE, 
    recursive = FALSE)  
 $ ifile    : chr "/home/bourbon/DATA/Hengill/UW/2005071116342W"
 $ COMPS    : chr [1:60] "V" "N" "E" "V" ...
 $ OCOMPS   : chr [1:60] "SHV" "SHN" "SHE" "SHV" ...
 $ dt       : num [1:60] 0.002 0.002 0.002 0.002 0.002 ...
 $ KNOTES   : chr [1:60] "H16 SHV" "H16 SHN" "H16 SHE" "H30 SHV" ...
 $ info     :List of 18
  ..$ fn  : chr [1:60] "/home/bourbon/DATA/Hengill/UW/2005071116342W" "/home/bourbon/DATA/Hengill/UW/2005071116342W" "/home/bourbon/DATA/Hengill/UW/2005071116342W" "/home/bourbon/DATA/Hengill/UW/2005071116342W" ...
  ..$ name: chr [1:60] "H16" "H16" "H16" "H30" ...
  ..$ yr  : int [1:60] 2005 2005 2005 2005 2005 2005 2005 2005 2005 2005 ...
  ..$ jd  : num [1:60] 192 192 192 192 192 192 192 192 192 192 ...
  ..$ mo  : int [1:60] 7 7 7 7 7 7 7 7 7 7 ...
  ..$ dom : int [1:60] 11 11 11 11 11 11 11 11 11 11 ...
  ..$ hr  : int [1:60] 16 16 16 16 16 16 16 16 16 16 ...
  ..$ mi  : int [1:60] 34 34 34 34 34 34 34 34 34 34 ...
  ..$ sec : num [1:60] 21 21 21 21 21 21 21 21 21 21 ...
  ..$ msec: num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  ..$ dt  : num [1:60] 0.002 0.002 0.002 0.002 0.002 ...
  ..$ t1  : num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  ..$ t2  : num [1:60] 0.118 0.118 0.118 0.118 0.118 ...
  ..$ off : num [1:60] 0 0 0 0 0 0 0 0 0 0 ...
  ..$ n1  : int [1:60] 5000 5000 5000 5000 5000 5000 5000 5000 5000 5000 ...
  ..$ n2  : int [1:60] 5000 5000 5000 5000 5000 5000 5000 5000 5000 5000 ...
  ..$ n3  : int [1:60] 5000 5000 5000 5000 5000 5000 5000 5000 5000 5000 ...
  ..$ n   : int [1:60] 5000 5000 5000 5000 5000 5000 5000 5000 5000 5000 ...
 $ dat      : NULL
 $ nn       : int 60
 $ ex       : num [1:5000] 0 0.002 0.004 0.006 0.008 ...
 $ pcol     : num [1:60] 3 3 3 4 4 4 5 5 5 6 ...
 $ ok       : int [1:60] 3 2 1 6 5 4 9 8 7 12 ...
 $ wintim   : num 193
 $ ftime    : chr [1:60] "2005_7_11_16_34_21_0" "2005_7_11_16_34_21_0" "2005_7_11_16_34_21_0" "2005_7_11_16_34_21_0" ...
 $ pickfile :List of 14
  ..$ PF      : chr [1:40] "A 200507111634 22.42 64N0402  21W1887  4.23      17/013 204  2 0.02  0.1AD E1" "E LQ 0.024 0.004 0.024 0.024   17.38  26      0.10 0.04 0.10 0.01" "F 254  4  0.03 349 49  0.08 161 41  0.12   0.00   0.00" ".H40.SHV (P P D 23.466 0 0.006 0.021)" ...
  ..$ AC      : chr "A 200507111634 22.42 64N0402  21W1887  4.23      17/013 204  2 0.02  0.1AD E1"
  ..$ LOC     :List of 15
  .. ..$ yr    : num 2005
  .. ..$ mo    : num 7
  .. ..$ dom   : num 11
  .. ..$ hr    : num 16
  .. ..$ mi    : num 34
  .. ..$ sec   : num 22.4
  .. ..$ jd    : num 192
  .. ..$ lat   : num 64.1
  .. ..$ lon   : num -21.3
  .. ..$ z     : num 4.23
  .. ..$ mag   : num NA
  .. ..$ gap   : num 204
  .. ..$ delta : num 2
  .. ..$ rms   : num 0.02
  .. ..$ hozerr: num 0.1
  ..$ MC      : NULL
  ..$ STAS    :List of 13
  .. ..$ tag  : chr [1:30] "H40.SHV" "H33.SHV" "H73.SHV" "H32.SHV" ...
  .. ..$ name : chr [1:30] "H40" "H33" "H73" "H32" ...
  .. ..$ comp : chr [1:30] "V" "V" "V" "V" ...
  .. ..$ c3   : chr [1:30] "SHV" "SHV" "SHV" "SHV" ...
  .. ..$ phase: chr [1:30] "P" "P" "P" "P" ...
  .. ..$ sec  : num [1:30] 23.5 23.7 23.5 23.7 23.6 ...
  .. ..$ err  : num [1:30] 0.006 0.016 0.008 0.01 0.01 0.008 0.03 0.008 0.01 0.012 ...
  .. ..$ pol  : chr [1:30] "D" "U" "D" "D" ...
  .. ..$ flg  : num [1:30] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ res  : num [1:30] 0.021 0.047 0.02 0.005 0.011 -0.01 0.01 0.009 0.03 0.008 ...
  .. ..$ lat  : num [1:30] 64 64 64.1 64 64.1 ...
  .. ..$ lon  : num [1:30] -21.3 -21.4 -21.3 -21.4 -21.3 ...
  .. ..$ z    : num [1:30] 0.36 0.59 0.44 0.58 0.43 0.38 0.41 0.45 0.37 0.39 ...
  ..$ LIP     :List of 5
  .. ..$ x  : num [1:3] -0.959 -0.125 0.246
  .. ..$ y  : num [1:3] -0.0671 -0.144 0.2136
  .. ..$ z  : num [1:3] -0.276 0.982 -0.946
  .. ..$ az : num [1:3] 4 49 41
  .. ..$ dip: num [1:3] 254 349 161
  ..$ E       :List of 14
  .. ..$ LOC     : chr "LQ"
  .. ..$ rms     : num 0.024
  .. ..$ meanres : num 0.004
  .. ..$ sdres   : num 0.024
  .. ..$ sdmean  : num 0.024
  .. ..$ sswres  : num 17.4
  .. ..$ ndf     : num 26
  .. ..$ fixflgs : chr "    "
  .. ..$ sterrx  : num 0.1
  .. ..$ sterry  : num 0.04
  .. ..$ sterrz  : num 0.1
  .. ..$ sterrt  : num 0.01
  .. ..$ mag     : num NA
  .. ..$ sterrmag: num NA
  ..$ F       :List of 11
  .. ..$ azim1  : num 254
  .. ..$ plunge1: num 4
  .. ..$ val1   : num 0.03
  .. ..$ azim2  : num 349
  .. ..$ plunge2: num 49
  .. ..$ val2   : num 0.08
  .. ..$ azim3  : num 161
  .. ..$ plunge3: num 41
  .. ..$ val3   : num 0.12
  .. ..$ herr   : num 0
  .. ..$ verr   : num 0
  ..$ filename: chr "/home/bourbon/DATA/Hengill/UW/2005071116342p"
  ..$ UWFILEID: chr "20050711163422"
  ..$ comments: chr "AUTO PICK: cpick Ver. 6.21 Thu Sep 15 20:58:59 2005"
  ..$ OSTAS   : chr [1:28] "H16.SHN" "H30.SHE" "H32.SHN" "H32.SHE" ...
  ..$ H       :List of 10
  .. ..$ yr : num 2005
  .. ..$ mo : num 7
  .. ..$ dom: num 11
  .. ..$ hr : num 16
  .. ..$ mi : num 34
  .. ..$ sec: num NA
  .. ..$ lat: num 22.4
  .. ..$ lon: num 64.1
  .. ..$ z  : num -21.3
  .. ..$ mag: num 4.23
  ..$ N       :List of 1
  .. ..$ name: chr "2005071116342p"
 $ velfile  : chr "/home/lees/Site/Hengil/krafla.vel"
 $ stafile  : chr "/home/lees/Site/Hengil/hengil_sta.LLZ"
 $ aname    : chr "/home/bourbon/DATA/Hengill/UW/2005071116342"
 $ UWFILEID : chr "2005071116342"
 $ RFilename: chr "/home/lees/Site/Hengil/DATA_RFORMAT/HENG"
}
\details{
  List includes waveform data and pickfile used for earthquake
  location and focal mechanism.
}
\source{
  Jonathan M. Lees
}
\references{

  Tang, C.; Rial, J. A. and Lees, J. M. Seismic Imaging
  of the Geothermal Field at Hengill,
  Iceland Using Shear-wave Splitting 2006, 87, T13A-0496.
}
\examples{

\dontrun{
require(RSEIS)
data(HENG)
swig(HENG, sel=HENG$COMPS=="V")
}


}
\keyword{misc}
