\name{getPTS}
\alias{getPTS}
\title{Get Raypath Source-Reciever Points
}
\description{Get inforamtion for raypaths
  from source to reciever including travel times and predicted
  arrival times for P and S-waves.  Calculates the
  incident angles for P and S-waves based on the 1D velocity structure.
}
\usage{
getPTS(pfile, stafile, velfile, UP = TRUE, zerostaz = FALSE)
}
\arguments{
  \item{pfile}{pickfile
}
  \item{stafile}{station location file
}
  \item{velfile}{velocity file
}
  \item{UP}{logical, upper or lower hemisphere, default=TRUE
}
  \item{zerostaz}{logical, forces the station elevations to be zero, default=TRUE
}
}
\details{Reads in files and sets parameters for fpfit 
}
\value{list:
  name,lat,lon,elev,parr,sarr,pres,perr,pol,gaz,dis,angP,angS,
  ttP,ttS,strike,dip,rake,
  prad,svrad,shrad,prad2,
  svrad2,shrad2,
  Ex,Ey
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{The output is  a structure with empty
  place holders for other information.
  
}


\seealso{getpfile, getSENSORfile, setSENSOR, sethpinv
}
\examples{

\dontrun{


SENSOR =  getSENSORfile(SENSORfile)
 FOCPLOTPARAMS <<-   list(fkind=0, PLANES=TRUE, SEIS=FALSE,NAME=TRUE, POINTS=TRUE,  PT=TRUE,
           NET=TRUE,TIT=TRUE,  MECUP=TRUE)

##  OUTDIR =  "/data/wadati/lees/Site/Hengil/DATA_RFORMAT"

##  hengilR=list.files(OUTDIR, pattern="R$", full.names=TRUE)

data(HENG)
pfile=HENG$pickfile

A = getpfile(pfile, stafile=stafile)

REVS = setSENSOR(A, SENSOR=SENSORfile )

sethpinv(fout="fpfit.inp", REV=REVS)

PTS = getPTS(HENG$pickfile, stafile, velfile, UP= TRUE)



}


}
\keyword{misc}
