\name{getSENSORfile}
\alias{getSENSORfile}
\title{Get Sensor Information File
}
\description{Get Sensor Information File
}
\usage{
getSENSORfile(SENSORfile = NULL)
}
\arguments{
  \item{SENSORfile}{character file name of sensor information
}
}
\details{This program reads in a text file of sensor information
  similar to that used by PASSCAL in years past. The first line
  is a header line followed by many lines containing information.

  \verb{
DAS   Station   SENSOR_SN  SENSOR CHANS  TIME1   TIME2
945C    H11     999  L28    V.N.E     2005:184:00:00  2005:188:13:59
945C    H30     999  L28    V.N.E         2005:188:15:23  2005:225:13:24
9472    H01     T4891  CMG40T    V.N.E    2005:183:13:28  2005:191:09:55
9472    H31     T4891  CMG40T    V.N.E    2005:191:10:29  2005:225:13:49
  }
  
}
\value{List containing the information in the file.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{File Must be on disk and readable.
}


\seealso{setSENSOR
}
\examples{

\dontrun{

SENSORfile = 'hengill.sensors'
SENSOR =  getSENSORfile(SENSORfile)
data.frame(SENSOR)

}

}
\keyword{misc}
