\name{makeMEC}
\alias{makeMEC}
\title{Makemec
}
\description{Make a focal mechanism list.
}
\usage{
makeMEC(pfile, stafile, velfile, SENSOR = SENSOR)
}
\arguments{
  \item{pfile}{character, pickfile name on disk
}
  \item{stafile}{character, station file name on disk
}
  \item{velfile}{character, velocity file name on disk
}
  \item{SENSOR}{character, Sensor information file name on disk
}
}
\details{Takes all the inputs from
  the various ascii text files and makes a focal mechnism by running
  fpfit
  
}
\value{MEC list:
az1,dip1,az2,dip2,dir,rake1,dipaz1,rake2,dipaz2,P,T,U,V,M,F,G,strike,dipdir,dip,rake,UP,sense
  
  
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{This is a wrapper for several programs.
  
}


\seealso{getpfile, getPTS, runfpfit, CONVERTSDR, GetRake
}
\examples{
\dontrun{
data(HENG)
stafile = "hengil_sta.LLZ"
velfile = "krafla.vel"
rev.file = "hengill.REV"
SENSORfile = 'hengill.sensors'
MEC=makeMEC(HENG$pickfile, stafile, velfile, SENSOR=SENSOR)
}
}
\keyword{misc}
