\name{runfpfit}
\alias{runfpfit}
\title{Run fpfit
}
\description{Run the program fpfit
  externally on via a system call.
}
\usage{
runfpfit(A, PTS, SENSOR = SENSOR)
}
\arguments{
  \item{A}{List output of program getpfile
}
  \item{PTS}{list output of program getPTS
}
  \item{SENSOR}{character, SENSOR information file
}
}
\details{The program fpfit must be installed and
  executable (i.e. in the path)
  on the computer.
  
}
\value{output of fpfitSOLcard which reads in the file.
list( ddaz=ddaz,  dip=dip,  slip=slip, CNVRG=CNVRG )
  
}
\references{
  Reasonberg, P.,  and  D. Oppenheimer,  FPFIT, FPPLOT AND FPPAGE: FORTRAN
Computer Programs For Calculating And Displaying Earthquake Fault-Plane
Solutions, U.S. GEOLOGICAL SURVEY OPEN-FILE REPORT NO. 85-739.
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Before running this code, first install fpfit.
  You should have the Lees version that dumps out the
  files to disk and reads in the input parameters from a file.

  To set your path name first run: echo $PATH

  bash:
    PATH=\$PATH:/data/myscripts
}



\examples{

\dontrun{
SENSOR =  getSENSORfile(SENSORfile)
 FOCPLOTPARAMS <<-   list(fkind=0, PLANES=TRUE, SEIS=FALSE,NAME=TRUE, POINTS=TRUE,  PT=TRUE,
           NET=TRUE,TIT=TRUE,  MECUP=TRUE)

##  OUTDIR =  "/data/wadati/lees/Site/Hengil/DATA_RFORMAT"

##  hengilR=list.files(OUTDIR, pattern="R$", full.names=TRUE)

data(HENG)
pfile=HENG$pickfile

A = getpfile(pfile, stafile=stafile)

REVS = setSENSOR(A, SENSOR=SENSORfile )

sethpinv(fout="fpfit.inp", REV=REVS)

PTS = getPTS(HENG$pickfile, stafile, velfile, UP= TRUE)

runfpfit(A, PTS, SENSOR=SENSORfile)

}



}
\keyword{misc}
