\name{setSENSOR}
\alias{setSENSOR}
\title{Set sensors in a pickfile
}
\description{Match sesnors in a pickfile to those in the
  sensor file.
}
\usage{
setSENSOR(A, SENSORfile = NULL)
}
\arguments{
  \item{A}{pickfile list
}
  \item{SENSORfile}{character string to sensor information file
}
}
\details{Read in sensor information file,
  assign sensor information to stations in pickfile.
}
\value{REVS list: name, comp, updir, sense, code
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Uses an old style of network configuration file from PASSCAL.
}


\seealso{getpfile, getSENSORfile
}
\examples{

\dontrun{

SENSOR =  getSENSORfile(SENSORfile)

data(HENG)
pfile=HENG$pickfile

A = getpfile(pfile, stafile=stafile)

REVS = setSENSOR(A, SENSOR=SENSORfile )

}


}
\keyword{misc}
