\name{setfoccerSEIS}
\alias{setfoccerSEIS}
\title{SetFoccer
}
\description{Set the focal mech into the SEIS list
}
\usage{
setfoccerSEIS(SEIS, stafile, velfile, SENSOR = NULL, FPFIT = FALSE, FOCPLOTPARAMS=NULL)
}
\arguments{
  \item{SEIS}{List from RSEIS
}
  \item{stafile}{station file
}
  \item{velfile}{velocity file
}
  \item{SENSOR}{sensor list
}
  \item{FPFIT}{logical, TRUE=run fpfit
  }
 \item{FOCPLOTPARAMS}{
    list(fkind=1, PLANES=TRUE, SEIS=FALSE,NAME=TRUE, POINTS=TRUE,  PT=TRUE,
          NET=TRUE,TIT=TRUE,  MECUP=TRUE)
  }

  
}
\details{Reads in a SEIS file and prepares
  the files for fpfit, and calculates the focal mechanism.
}
\value{List:
A,MEC,GU,pscale,col,MECUP,fkind,PLANES,SEIS,NAME,POINTS,PT,NET,TIT,wfile
  
}
\references{
  Reasonberg, P.,  and  D. Oppenheimer,  FPFIT, FPPLOT AND FPPAGE: FORTRAN
Computer Programs For Calculating And Displaying Earthquake Fault-Plane
Solutions, U.S. GEOLOGICAL SURVEY OPEN-FILE REPORT NO. 85-739.

}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Runs fpfit
}



\examples{
\dontrun{
SENSOR =  getSENSORfile(SENSORfile)
 FOCPLOTPARAMS <<-   list(fkind=0, PLANES=TRUE, SEIS=FALSE,NAME=TRUE, POINTS=TRUE,  PT=TRUE,
           NET=TRUE,TIT=TRUE,  MECUP=TRUE)

##  OUTDIR =  "/data/wadati/lees/Site/Hengil/DATA_RFORMAT"

##  hengilR=list.files(OUTDIR, pattern="R$", full.names=TRUE)

data(HENG)
pfile=HENG$pickfile

A = getpfile(pfile, stafile=stafile)

REVS = setSENSOR(A, SENSOR=SENSORfile )

sethpinv(fout="fpfit.inp", REV=REVS)

PTS = getPTS(HENG$pickfile, stafile, velfile, UP= TRUE)

runfpfit(A, PTS, SENSOR=SENSORfile)

AFOC = setfoccerSEIS(HENG, stafile, velfile, SENSOR=SENSOR, FPFIT=TRUE)
AFOC$fkind = 1

FOCPLOTPARAMS = list(fkind=1, PLANES=TRUE, SEIS=FALSE,NAME=TRUE, POINTS=TRUE,  PT=TRUE,
  NET=TRUE,TIT=TRUE,  MECUP=TRUE)

assign("FOCPLOTPARAMS", FOCPLOTPARAMS,  env = .GlobalEnv)
pfoccer0(AFOC )


}



}
\keyword{misc}
