cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C
C nplot.f - A (sub)set of CalComp HCBS-compatible plotting routines for
C           output to selected device routines 
C
C ---------------------------------------------------------------------------
C r saltus 12/24/92 - conversion from xplot.f to switch between x-window and
C                     postscript drivers
C 
C ---------------------------------------------------------------------------
C
C Entry points:
C
C      Call PLOTS (Arguments ignored)
C
C         PLOTS  is the first plotting routine called and must be called exactly
C         once by the program
C
C         CALL PLOT (0.0,0.0,999) terminates all plotting
C
C      Call PLOT (x,y,ipen)
C
C         x     = X-coordinate
C         y     = Y-coordinate
C         ipen  = Function code
C
C                 +999 = End of run
C                   +3 = Move to (X,Y)
C                   +2 = Draw to (X,Y)
C                 -999 = End of frame
C
C                 All other values ignored
C
C      Call NEWPEN (ipen)
C
C         ipen  = Line color (1 to 20 pixels on an Apple LaserWriter)
C
C      Call SYMBOL (x, y, hgt, text, angle, nc)
C
C         x     = X-coordinate
C         y     = Y-coordinate
C         hgt   = Character height
C         text = character string or integer symbol number
C         angle = Character angle
C         nc    = Number of characters (nc>0) or integer symbol number (nc=<0)
C
C
c Notes:
C
C                                  Disclaimer
C
C Although  this program has been tested by the Geological Survey, United States
C Department of the Interior, no warranty, expressed or implied, is made by  the
C Geological  Survey,  as  to  the  accuracy  and functioning of the program and
C related program material, nor shall the fact of  distribution  constitute  any
C such  warranty,  and  no responsibility is assumed by the Geological Survey in
C connection therewith.
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine STARTPLOT (iplotr)
      Implicit   None
      integer iplotr
      integer nxplotr, npplotr
      common /npswitch/ nxplotr, npplotr

      if (iplotr .eq. 1) then
          nxplotr = 1
          npplotr = 0
      else if (iplotr .eq. 2) then
          nxplotr = 0
          npplotr = 1
      else if (iplotr .eq. 3) then
          nxplotr = 1
          npplotr = 1
      else if (iplotr .eq. 0) then
          nxplotr = 0
          npplotr = 0
      else
          print *, ' ** iplotr not understood in STARTPLOT'
      endif

      if ((nxplotr.ne.0).or.(npplotr.ne.0)) then
        call plots(0,0,0)
      endif

      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine NEWPLOT (iplotr)
      Implicit   None
      integer iplotr
      integer nxplotr, npplotr
      common /npswitch/ nxplotr, npplotr
      
c     close old plot (except X window)
      if (nxplotr.ne.1) then
        call plot(0.,0.,999)
      end if

 80     print *,' '
        print *,'Enter 1 for x window plot'
        print *,'      2 for Postscript file'
        print *,'      3 for both'
        print *,'      0 to quit plotting'
        read(5,*)iplotr
        if (iplotr .eq. 1) then
          nxplotr = 1
          npplotr = 0
        else if (iplotr .eq. 2) then
          nxplotr = 0
          npplotr = 1
        else if (iplotr .eq. 3) then
          nxplotr = 1
          npplotr = 1
        else if (iplotr .eq. 4) then
          nxplotr = 0
          npplotr = 0
        else
          print *, ' ** Value not understood, try again...'
          goto 80
        endif

c     open new plot
      if ((nxplotr.ne.0).or.(npplotr.ne.0)) then
        call plots(0,0,0)
      endif

      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine CLOSEPLOT ()
      Implicit   None
      integer iplotr
      character*1 aplotr
      integer nxplotr, npplotr
      common /npswitch/ nxplotr, npplotr
      
      print *,' '
      print *,'Enter 0 to quit plotting'
c      read(5,'(a)') aplotr
      read (5,*) iplotr

      call sleep (iplotr)

c     close plot
      call plot(0.,0.,999)

      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine setscale (scfactor)

c     Non-standard call to change scale.

      real scfactor
      real scalefactor
      common/factor0/ scalefactor

      scalefactor = scfactor

      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine PLOTS (ibuf, nloc, ldev)

      Implicit   None

      integer iplotr
      integer nxplotr, npplotr
      common /npswitch/ nxplotr, npplotr

C     nxplotr = 1 - x window plotting
C     npplotr = 1 - Adobe Illus (postscript) plotting

      Integer    ibuf(*), nloc, ldev
      Integer    j, afnch

      real scalefactor
      common/factor0/ scalefactor

      if (scalefactor.eq.0.0)  scalefactor = 1.0

c      print *, ' ** in plots... nx,np=', nxplotr, npplotr

      if (nxplotr.eq.0 .and. npplotr.eq.0) then
 80     print *,' '
        print *,'Enter 1 for X window plot'
        print *,'      2 for Postscript file'
        print *,'      3 for both'
        print *,'      0 to quit plotting'
        read(5,*)iplotr
        if (iplotr .eq. 1) then
          nxplotr = 1
          npplotr = 0
        else if (iplotr .eq. 2) then
          nxplotr = 0
          npplotr = 1
        else if (iplotr .eq. 3) then
          nxplotr = 1
          npplotr = 1
        else if (iplotr .eq. 0) then
          nxplotr = 0
          npplotr = 0
        else
          print *, ' ** Value not understood, try again...'
          goto 80
        endif
      endif

      if (nxplotr.eq.1) then
        call nxplots(ibuf,nloc,ldev)
        call flushxw()
      endif
      if (npplotr.eq.1) then
        call npplots(ibuf,nloc,ldev)
      end if

      Return

      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine PLOT(x, y, ipen)

      Implicit   None

      Real       x, y
      Real       xp, yp
      Integer    ipen

      common /npswitch/ nxplotr, npplotr
      integer nxplotr, npplotr

      real scalefactor
      common/factor0/ scalefactor

      xp = x * scalefactor
      yp = y * scalefactor

      if (nxplotr.eq.1) then
        call nxplot(xp,yp,ipen)
        call flushxw()
      endif
      if (npplotr.eq.1) then
        call npplot(xp,yp,ipen)
      end if

      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine NEWPEN (ipen)

      Implicit   None

      Integer    ipen

      common /npswitch/ nxplotr, npplotr
      integer nxplotr, npplotr


      if (nxplotr.eq.1) then
        call nxnewpen(ipen)
        call flushxw()
      endif
      if (npplotr.eq.1) then
        call npnewpen(ipen)
      end if

      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine SYMBOL (x, y, hgt, text, angle, nc)

      Implicit   None

      Real       x, y, hgt, angle
      Real       xs, ys, ht
      Character*(*) text
      Integer    nc,itext

      common /npswitch/ nxplotr, npplotr
      integer nxplotr, npplotr

      real scalefactor
      common/factor0/ scalefactor

      xs = x * scalefactor
      ys = y * scalefactor
      ht = hgt * scalefactor

      if (nxplotr.eq.1) then
        call nxsymbol(xs,ys,ht,text,angle,nc)
        call flushxw()
      endif
      if (npplotr.eq.1) then
        call npsymbol(xs,ys,ht,text,angle,nc)
      endif

      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C
C
C postscript original code from Larry Baker - modified by r saltus for hp-ux and
C character variables in symbol calls 4/92
C
C xplot.f - A (sub)set of CalComp HCBS-compatible plotting routines for
C           output to native x through the library routines by Joe Plesha
C
C converted from Larry Baker's postscript conversion by Rick Saltus 9/92
C
C
C Entry points:
C
C      Call nxPLOTS (Arguments ignored)
C
C         PLOTS  is the first plotting routine called and must be called exactly
C         once by the program
C
C         CALL PLOT (0.0,0.0,999) terminates all plotting
C
C      Call PLOT (x,y,ipen)
C
C         x     = X-coordinate
C         y     = Y-coordinate
C         ipen  = Function code
C
C                 +999 = End of run
C                   +3 = Move to (X,Y)
C                   +2 = Draw to (X,Y)
C                 -999 = End of frame
C
C                 All other values ignored
C
C      Call nxNEWPEN (ipen)
C
C         ipen  = Line color (1 to 20 pixels on an Apple LaserWriter)
C
C      Call nxSYMBOL (x, y, hgt, text, angle, nc)
C
C         x     = X-coordinate
C         y     = Y-coordinate
C         hgt   = Character height
C         text = character string or integer symbol number
C         angle = Character angle
C         nc    = Number of characters (nc>0) or integer symbol number (nc=<0)
C
C
C Notes:
C
C                                  Disclaimer
C
C Although  this program has been tested by the Geological Survey, United States
C Department of the Interior, no warranty, expressed or implied, is made by  the
C Geological  Survey,  as  to  the  accuracy  and functioning of the program and
C related program material, nor shall the fact of  distribution  constitute  any
C such  warranty,  and  no responsibility is assumed by the Geological Survey in
C connection therewith.
C
C
      Subroutine nxPLOTS (ibuf, nloc, ldev)
C
      Implicit   None
C
      common /nxbakerp/xorig,yorig
      real xorig,yorig
      common /xpltscale/mpx,mpy,xinch,yinch,dpi,lastxx,lastyy
      real xinch,yinch,dpi
      integer mpx,mpy,jx,jy,lastxx,lastyy
c     Save /nxbakerp/
c     Save /xpltscale/
C
      Integer    ibuf(*), nloc, ldev
C
      Integer    j, afnch
c     Character  title*80, create*34, for*80, afname*80
C
      real scalefactor
      common/factor0/ scalefactor

      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
C
      Data       isopen/.FALSE./
c
c     set default screen mapping in inches
c
      xinch=11.
      yinch=8.5
c
c     initialize origin offset
c
c      xorig=0.
c      yorig=0.
c     Shift origin in window a bit so that window plot looks 
c      more like postscript plot.
      xorig=0.25
      yorig=0.25
      xorig = xorig * scalefactor
      yorig = yorig * scalefactor
C
C...  Reset buffer pointer
      ipctr = 1
C
c...  findout max screen size
c
      call sizexw(jx,jy)
c     print *,'X PLOTS: Max screen size = ',jx,jy
c
c...  scale screen dimensions to match yinch/xinch ratio
c
      mpx=min(jx,800)
      mpy=int(real(mpx)*yinch/xinch)
      dpi=real(mpx)/xinch
c
c...  open x drawing window
c
c     print *,'X PLOTS: Requested window size = ',mpx,mpy
      call initxw(mpx,mpy)
c
c...  set an 8 color palette for newpen colors
c
c     print *,'X PLOTS: Setting 8 color palette'
c       call palxw(   0,   0,   0, 0 )
c       call palxw( 248, 248, 248, 1 )
        call palxw( 255,   0,   0, 0 )
        call palxw(  56, 255, 255, 1 )
c       call palxw( 255,   0,   0, 2 )
c       call palxw( 255, 128,   0, 3 )
        call palxw( 255, 128,   0, 2 )
        call palxw( 255, 255,   0, 3 )
        call palxw(   0, 128,   0, 4 )
        call palxw(   0, 128, 255, 5 )
        call palxw(   0,   0, 255, 6 )
        call palxw( 255,   0, 255, 7 )
        call palxw(   0,   0,   0, 8 )
c
c...  set drawing color = 1
c
c     print *,'X PLOTS: setting color and line style'
c     call setcolorxw(1)
c     call setlinexw(1,1,0)
C
C...  Allow file to be written by PLOT entry points now
C
      isopen = .TRUE.
C
c     print *,'X PLOTS: done with setup.'
      call plot(0.,0.,3)
      call flushxw()

      Return
C
      End
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine nxPLOT (x, y, ipen)
C
      Implicit   None
C
      character*1 junkans

      common /nxbakerp/xorig,yorig
      real xorig,yorig,xt,yt
      common /xpltscale/mpx,mpy,xinch,yinch,dpi,lastxx,lastyy
      real xinch,yinch,dpi
      integer mpx,mpy,jx,jy,lastxx,lastyy
c     Save /nxbakerp/
c     Save /xpltscale/
C
      Real       x, y
      Integer    ipen
C
      Integer    j, xx, yy, xfloor, yfloor, xceil, yceil
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
C
C...  No calls allowed before Call PLOTS (0,0,0) or after Call PLOT (x,y,999)
C
      If (.not. isopen) Then
         Goto 9000
      End If
C
C...  offset origin
C
      xt=x+xorig
      yt=y+yorig
C
C...     reset origin if ipen<0
C
      if (ipen.lt.0) then
c
c     reset origin
c
c        print *,'PLOT - origin reset'
         xorig=xorig + x
         yorig=yorig + y
      end if
C
C...  Scale the x and y coordinates
C
      xx = nint (dpi * xt)
      yy = nint (dpi * yt)
C
      if ((xx.gt.mpx).or.(yy.gt.mpy)) then
        print *,'X PLOT: outside window x,y = ',xx,yy
      end if
C
      If (ipen .eq. 2) Then
C
C...     DRAW command
c
c        draw line in x window
c
c        print *,'X PLOT: linexw ',lastxx,lastyy,xx,yy
         call linexw(lastxx,lastyy,xx,yy,1,2)
         lastxx=xx
         lastyy=yy
c
C...     Mark this frame dirty
c        ismove = .FALSE.
c        dirty  = .TRUE.
C
      Else If ((ipen .eq. 3) .or. (ABS(ipen) .eq. 999)) Then
C
C...     MOVE or END PLOT command
C
c        ismove = .TRUE.
C
C...     Print the page if this is the END OF FRAME/RUN
C
         If (ABS(ipen) .eq. 999) Then
               call flushxw
               lastxx = 0
               lastyy = 0
c              virgin = .TRUE.
               if (ipen .eq. -999) then
                 print *, ' Hit CR to continue: '
                 read '(a)', junkans
                 call clearxw ()
               endif
C
         End If
C
C...     Flush buffers and close file if this is the END OF RUN
C...     (or the END OF FRAME in the Encapsulated PostScript version)
C
         If (ipen .eq. 999) Then
c           Call TRAILR
            call closexw
            Goto 9000
         End If
C
      End If
C
C...  Save last coordinate positions for initiation of a sequence of DRAW
C...  commands or the continuation of DRAW commands that span multiple paths.
      lastxx = xx
      lastyy = yy
C
 9000 Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine nxNEWPEN (ipen)
C
      Implicit   None
C
c     Include    'PostScript.inc'
C
c     Logical    ISAI
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
C
      Integer    ipen
C
      Real       rpen
      Integer    j, jpen
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
C...  If DRAW or NEWPEN, virgin: .TRUE. -> .FALSE. (new page)
C...  If DRAW, dirty: .FALSE. -> .TRUE.
c     Logical    island, virgin, dirty, ismove
c     Integer    dpi, page, kount
c     Real       pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
c     Common /PSC0M/  island, virgin, dirty, ismove, dpi, page, kount,
c    1                pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
c     Save   /PSC0M/
C
C...  No calls allowed before Call PLOTS (0,0,0) or after Call PLOT (x,y,999)
      If (.not. isopen) Then
         Goto 9000
      End If
C
      jpen = ipen
      jpen = mod(jpen,8)
      if (jpen.eq.0) jpen=8
      call flushxw
c      call setcolorxw(jpen)
c      call setlinexw (1,jpen,0)
      call flushxw
C
 9000 Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine nxSYMBOL (x, y, hgt, text, angle, nc)
C
      Implicit   None
C
      External   PLOT
C
      common /nxbakerp/xorig,yorig
      real xorig,yorig,xt,yt
      common /xpltscale/mpx,mpy,xinch,yinch,dpi,lastxx,lastyy
      real xinch,yinch,dpi
      integer mpx,mpy,jx,jy,lastxx,lastyy
c
C
      Real       x, y, hgt, angle
      Character*(*) text
      Integer    nc,itext
C
      Real       rangle, rsin, rcos, bx(2), by(2), bbx, bby
      Integer    i, j, nch, xx, yy, scale, pscale, afnch
      Character  cbuf*255, afname*80
      Save       pscale
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
c     Save /nxbakerp/
c     Save /xpltscale/
C
C...  No calls allowed before Call PLOTS (0,0,0) or after Call PLOT (x,y,999)
      If (.not. isopen) Then
         Goto 9000
      End If
C
C...
C     reset origin
C
      xt=x+xorig
      yt=y+yorig
C
C...  Scale the x and y coordinates
C
      xx = NINT (dpi * xt)
      yy = NINT (dpi * yt)
C
c     print *,'X SYMBOL: x,y,xt,yt,xx,yy = ',x,y,xt,yt,xx,yy
C
      nch=nc
      If (nch .le. 0) Then
         if (nc.lt.-1) call plot(x,y,2)
         itext=ichar(text(1:1))
c        print *,'X SYMBOL: symbol # =',itext
         Call PLSSYMB(x,y,itext,hgt)
         call flushxw ()
      Else
c        print *,'X SYMBOL: text =',text
c         cbuf=' '
c         cbuf=text(1:nch)//char(0)
c         call writexw(xx,yy,cbuf(1:nch))
         call symbl (x, y, hgt, text, angle, nc)
         call flushxw ()
      End If
c
 9000 Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C$NOSTANDARD SYSTEM
C
C this HP UX system directive enables DATE and TIME calls
C
C original code from Larry Baker - modified by r saltus for hp-ux and
C character variables in symbol calls 4/92
C
C PostScript.for - A  (sub)set  of CalComp HCBS-compatible plotting routines for
C output to PostScript devices (laser printers, phototypesetters, film  writers,
C etc.) and writing Encapsulated PostScript files (including Adobe Illustrator).
C
C
C Entry points:
C
C      Call npPLOTS (Arguments ignored)
C
C         PLOTS  is the first plotting routine called and must be called exactly
C         once by the program
C
C         CALL PLOT (0.0,0.0,999) terminates all plotting
C
C      Call npPLOT (x,y,ipen)
C
C         x     = X-coordinate
C         y     = Y-coordinate
C         ipen  = Function code
C
C                 +999 = End of run
C                   +3 = Move to (X,Y)
C                   +2 = Draw to (X,Y)
C                 -999 = End of frame
C
C                 All other values ignored
C
C      Call npNEWPEN (ipen)
C
C         ipen  = Line width (1 to 20 pixels on an Apple LaserWriter)
C
C      Call npSYMBOL (x, y, hgt, itext, angle, nc)
C
C         x     = X-coordinate
C         y     = Y-coordinate
C         hgt   = Character height
C         itext = Hollerith character string or integer symbol number
C         angle = Character angle
C         nc    = Number of characters (nc>0) or integer symbol number (nc=<0)
C
C
C Notes:
C
C      1.  The  name  of the PostScript device is specified by PARAMETER DEVICE.
C          The following devices names are recognized:
C
C             LASERWRITER     Apple LaserWriter (300 dpi)
C             LINOTRONIC      Linotronic phototypesetter (7200 dpi)
C             EPSF            Encapsulated PostScript (7200 dpi)
C             ILLUSTRATOR     Adobe Illustrator (7200 dpi)
C
C          Any other value for DEVICE is treated as a generic PostScript printer
C          with arbitrary resolution (supplied in PARAMETER ( DEVDPI = n ).)
C
C      2.  The file name used to contain the PostScript commands is specified by
C          PARAMETER DEVNAM.  The  following  file  names  are  defined  in  the
C          include files:
C
C             LASERWRITER     LaserWriter.ps
C             LINOTRONIC      Linotronic.ps
C             EPSF            PostScript.epsf
C             ILLUSTRATOR     Illustrator.epsf
C
C          If a file name is not legal on your system, alter the line
C
C             Parameter  ( DEVNAM = ... )
C
C          to define an acceptable file name.
C
C      3.  The PostScript operators "grestoreall" and "initgraphics" are used in
C          the Document Setup portion of the Document Body to restore the device
C          to its initial state for beginning a new document.  This violates the
C          Document Structuring Conventions, which prohibit  the  use  of  these
C          operators in a conforming document.  However, if there is no document
C          processor or filter program which manages the  device,  there  is  no
C          alternative  method  to reinitialize the device (using software).  To
C          convert the document to a conforming  document,  which  can  then  be
C          safely  incorporated into another document, remove or comment-out the
C          two offending lines in the PostScript output file (there is a comment
C          immediately  before  them containing these same instructions.)  These
C          lines do  not  appear  in  Encapsulated  PostScript  files  or  Adobe
C          Illustrator files, since they are not intended to be sent directly to
C          a PostScript device.
C
C      4.  The Encapsulated PostScript File Format does not permit more than one
C          page in a document.  Therefore, the PostScript output file is  closed
C          at  the  end  of  the  first page, whether or not the plotting job is
C          finished.  If the program attempts to plot  another  page,  an  error
C          message is printed and the program is stopped.
C
C      5.  If  your  Fortran  compiler  does  not  support the VAX IMPLICIT NONE
C          statement, they may simply be commented out.
C
C      6.  If your Fortran compiler does not support the VAX form of the INCLUDE
C          statement, replace the lines
C
C             Include    'PostScript.inc'
C
C          with the lines
C
C             Character  DEVICE*(*), DEVNAM*(*)
C             Integer    DEVDPI
C             Parameter  ( DEVICE = 'LASERWRITER' )
C             Parameter  ( DEVNAM = 'LaserWriter.ps' )
C             Parameter  ( DEVDPI = 300 )
C
C          to select the output device (in this case, an Apple LaserWriter), the
C          name of the output file (in this  case,  'LaserWriter.ps'),  and  the
C          resolution of the device (used only for generic PostScript printers).
C
C      7.  The  OPEN  statment  for DEVNAM contains the non-standard VAX keyword
C          option  CARRIAGECONTROL='LIST'  so  that  the  file  containing   the
C          PostScript  commands  can  be typed or edited like a normal text file
C          (no line is longer than 80 characters) and when it is "PRINT"ed,  all
C          characters  are  sent  to  the PostScript printer, including those in
C          column 1 (which would otherwise be interpreted as as Fortran carriage
C          control  characters  and  would  NOT be sent).  (An alternative is to
C          write a space character at the front of every  record  in  SUBROUTINE
C          FLUSH.)
C
C      8.  System-specific  SUBROUTINES USERID,  DATE,  and  TIME  are called to
C          obtain the user name of the caller and the date and time of  the  run
C          for the header records in the document (%%...).
C
C      9.  SUBROUTINE SYMBOL silently truncates the passed character string to
C          255 characters.
C
C     10.  SUBROUTINE SYMBOL  declares  its  passed (Hollerith) character string
C          using the VAX INTEGER*4 statement and uses a  64A4  FORMAT  statement
C          specification  to  perform  Hollerith-to-character string conversion.
C          These may have to be modified for your Fortran compiler.
C
C     11.  SUBROUTINE AFMBB returns the bounding-box of a character string.   It
C          uses the Adobe Font Metric information supplied by  BLOCK DATA AFMBD,
C          which is generated automatically by the Parse_AFM_File program.
C
C
C Bugs:
C
C      1.  The bounding-box calculations do not take pen width into account.
C
C      2.  Characters  passed  to SUBROUTINE SYMBOL are assumed to be Clean7Bit.
C          No escape character substitution is performed.
C
C
C References:
C
C      Adobe Systems, Inc. publications:
C         PostScript Language Reference Manual, Second Edition (includes
C            Document Structuring Conventions -- Version 3.0 and
C            Encapsulated PostScript File Format -- Version 3.0)
C         PostScript Language Tutorial and Cookbook
C         PostScript Language Program Design
C         PostScript Language Supplement for the Linotronic Imagesetter
C            Version 47.1
C         Adobe Illustrator Document Format -- Version 2.0
C      California Computer Products, Inc. publications:
C         Programming CalComp Electromechanical Plotters
C
C
C Author:
C
C      Lawrence M. Baker
C      U.S. Geological Survey
C      345 Middlefield Road  MS977
C      Menlo Park, CA  94025
C      (415)329-5608 or FTS 459-5608
C
C
C                                  Disclaimer
C
C Although  this program has been tested by the Geological Survey, United States
C Department of the Interior, no warranty, expressed or implied, is made by  the
C Geological  Survey,  as  to  the  accuracy  and functioning of the program and
C related program material, nor shall the fact of  distribution  constitute  any
C such  warranty,  and  no responsibility is assumed by the Geological Survey in
C connection therewith.
C
C
C Modifications:
C
C      V1.3  Insert "grestoreall" and "initgraphics" in preamble in case
C               previous job aborts w/o issuing "grestore."
C      V2.0  Consolidate original PostScript.for (for Apple LaserWriters) and
C               Linotronic.for (for Linotronic phototypesetters) into a generic
C               PostScript.for which uses PostScript.inc to specify the device.
C            Remove the lines added in V1.3.
C            Implement Document Structuring Conventions -- Version 2.1.
C            Implement Encapsulated PostScript File Format -- Version 2.0.
C            Implement relative moves, draws ("v"->"rmoveto", "r"->"rlineto").
C      V2.1  %%BoundingBox cannot specify "(atend)" in Encapsulated PostScript
C               Files -- must re-read PostScript file to update %%BoundingBox.
C            Change resolution of Encapsulated Postscript Files from 4096 dpi to
C               7200 dpi (100X PostScript default user space).
C            Change private abbreviations to those used by Adobe Illustrator
C               ("d"->"L", "s"->"S", "newpen"->"w").
C            Restore the lines added in V1.3 for documents intended to be sent
C               directly to the device, i.e., non-Encapsulated PostScript Files.
C      V2.2  Adobe Illustrator ignores commands inside a %%BeginSetup/%%EndSetup
C               construct.  %%BeginSetup/%%EndSetup were removed so it would
C               recognize commands to set rounded end cap and line joins.
C      V2.3  Always issue a "showpage" to undo the effect of the transformation
C               in "everypage", even if something has not been written to the
C               page.  (E.g., QPLOT writes an empty initial frame with only a
C               call to NEWPEN in it.)
C      V2.4  (Incomplete) support for passthru of character strings (SYMBOL
C               entry point).
C      V2.5  Correct Encapsulated PostScript to include "everypage" for proper
C               scaling, etc.
C      V3.0  Implement Document Structuring Conventions -- Version 3.0.
C            Implement Encapsulated PostScript File Format -- Version 3.0.
C            Complete implementation of passthru of character strings (SYMBOL
C               entry point).
C            Implement Adobe Font Metric File parser (Parse_AFM_File.for) to
C               automate the creation of BLOCK DATA AFMBD containing bounding-
C               box dimensions used by SUBROUTINE AFMBB.
C            Increase common use of Adobe Illustrator syntax.
C            Add DEVDPI to include file for generic PostScript printers.
C
C
      Subroutine npPLOTS (ibuf, nloc, ldev)
C
      Implicit   None
C
      Include    'PostScript.inc'
C
      common /bakerp/xorig,yorig
      real xorig,yorig
c
      integer ival,iaquest
      character*80 filename
C
      Integer    ICHANL, JCHANL, LPBUF
      Parameter  ( ICHANL =   1 )
      Parameter  ( JCHANL =   2 )
      Parameter  ( LPBUF  =  80 )
      Logical    ISEPSF, ISAI
c     Parameter  ( ISEPSF = DEVICE .eq. 'EPSF' .or.
c    1                      DEVICE .eq. 'ILLUSTRATOR' )
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
      Character  VERSN*3
      Parameter  ( VERSN  = '3.0' )
C
c     Integer    ibuf(*), nloc, ldev
      Integer    ibuf, nloc, ldev
C
      Integer    j, afnch
      Character  title*80, create*34, for*80, afname*80
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
      Character  pbuf*(LPBUF)
      Common /IOC0N/  pbuf
C...  If DRAW or NEWPEN, virgin: .TRUE. -> .FALSE. (new page)
C...  If DRAW, dirty: .FALSE. -> .TRUE.
      Logical    island, virgin, dirty, ismove
      Integer    dpi, page, kount
      Real       pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Common /PSC0M/  island, virgin, dirty, ismove, dpi, page, kount,
     1                pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Save   /PSC0M/
C
c      Data       isopen/.FALSE./
c
      ISEPSF = DEVICE .eq. 'EPSF' .or.
     1                      DEVICE .eq. 'ILLUSTRATOR' 
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
      page=0
c
c     initialize origin offset
c
      xorig=0.
      yorig=0.
C
C...  Open plot file for PostScript plotting characters
C
      filename=DEVNAM
      ival=iaquest('Name for plot file',filename,'(a80)',1)
c
      Open (Unit=ICHANL,File=filename,Status='unknown',Form='Formatted')
c    1      Carriage Control='List')
C
C...  Open temporary plot file for Encapsulated PostScript Files
C...  (cannot use "%%BoundingBox: (atend)")
C
      If (ISEPSF) Then
         Open (Unit=JCHANL,Status='Scratch',Form='Unformatted')
      End If
C
C...  Reset buffer pointer
      ipctr = 1
C
C
C...  Use Document Structuring Conventions Specification Version 3.0  ..........
C
C
C...  Start of Document Header  ................................................
C
C
      Call PUTSTR ('%!PS-Adobe-3.0',14)
      If (ISEPSF) Then
         Call PUTSTR ('EPSF-3.0',8)
      End If
      Call PUTLIN (' ',0)
      Call PUTLIN ('%%Creator: USGS Viewer.PostScript V'//VERSN,38)
c     for = '%%For:'
c     Call USERID (for(8:))
c     Do 1200 j = LEN(for),1,-1
c        If (for(j:j) .ne. ' ') Then
c           Goto 1300
c        End If
c1200    Continue
c1300 Call PUTLIN (for,j)
      title = '%%Title:'
      Inquire (Unit=ICHANL,Name=title(10:))
C...  Assume the semantics of Inquire are the same as a character assignment
C...  statement, i.e., Name is padded with blanks.
      Do 1000 j = LEN(title),1,-1
         If (title(j:j) .ne. ' ') Then
            Goto 1100
         End If
 1000    Continue
 1100 Call PUTLIN (title,j)
      create = '%%CreationDate:'
c     Call DATE (create(17:25))
c     Call TIME (create(27:34))
      Call PUTLIN (create,LEN(create))
      Call PUTLIN ('%%DocumentData: Clean7Bit',25)
C...  Only supposed to appear if font actually used!!!
      Call PUTSTR ('%%DocumentNeededResources: font',31)
      Call AFMFON (afname,afnch)
      Call PUTLIN (afname,afnch)
      If (.not. ISAI) Then
         Call PUTLIN
     1      ('%%DocumentSuppliedResources: procset USGS_Viewerdict 2 2',
     2       56)
      End If
      Call PUTLIN ('%%Orientation: Landscape',24)
C...  This line is replaced by the correct limits for Encapsulated PostScript
C...  Files (including Adobe Illustrator) when the plot is done
      Call PUTLIN ('%%BoundingBox: (atend)',22)
      dxlow = 1E10
      dylow = 1E10
      dxhi  = 0.0
      dyhi  = 0.0
      If (ISAI) Then
         Call PUTLIN ('%%TemplateBox:0 0 0 0',21)
      End If
      If (.not. ISAI) Then
         If (ISEPSF) Then
            Call PUTLIN ('%%Pages: 0',10)
         Else
            Call PUTLIN ('%%Pages: (atend)',16)
            Call PUTLIN ('%%PageOrder: Ascend',19)
         End If
      End If
      Call PUTLIN ('%%EndComments',13)
C
C
C...  End of Document Header  ..................................................
C
C
C...  Start of Document Prologue  ..............................................
C
C
C...  Device-specific prologue
C
C...  Assume portrait (or unspecified) orientation
c     island = .FALSE.
      island = .TRUE.
C
      If (ISAI) Then
C
C...     Adobe Illustrator (Encapsulated PostScript subset)
C
         dpi = 7200
C
      Else
C
         Call PUTLIN ('%%BeginProlog',13)
C
C...     Create a private dictionary called "USGS_Viewerdict"
C
         Call PUTLIN ('%%BeginResource: procset USGS_Viewerdict 2 2',44)
         Call PUTLIN
     1      ('userdict /USGS_Viewerdict 12 dict dup begin put',47)
C
         If (ISEPSF) Then
C
C...        Encapsulated PostScript
C
            dpi = 7200
C
         Else
C
            Call PUTLIN ('% Conditionally define "setstrokeadjust" ' //
     1                   'for Level 1 devices',60)
            Call PUTLIN ('/setstrokeadjust where',22)
            Call PUTLIN ('   {pop}',8)
            Call PUTLIN ('   {/setstrokeadjust /pop load def}',35)
            Call PUTLIN ('   ifelse',9)
C
            If (DEVICE .eq. 'LINOTRONIC') Then
C
C...           Linotronic phototypesetter (1270 dpi, or better)
C
*              dpi = 1270
               dpi = 7200
C
C...           Set page size to 11 by 17 inches, 1/2 inch offset (on 12 inch
C...           wide paper), landscape orientation, with origin in the lower left
C...           corner, positive X from left to right, positive Y from bottom to
C...           top.
C
C...           Linotronic private verb in statusdict:
C
C...              width height offset orientation - setpageparams -
C
C                 \------------------------------------------------\
C                 /     -      +------------------------------+    /
C                 \     ^      |                              |    \
C                 /   width    |  <--       height       -->  |    /
C                 \     v     ^|                              |^   \
C                 /     -     y+------------------------------+x   /
C                 \     ^      x-> =0     orientation    =1 <-y    \
C                 /   offset                                       /
C                 \     v               paper motion ->            \
C                 /------------------------------------------------/
C
               Call PUTLIN ('/device_setup {',15)
               Call PUTLIN ('   statusdict begin',19)
               Call PUTLIN ('% Change "false" to "true" in the' //
     1                      ' following two lines to produce' //
     2                      ' negative images',80)
               Call PUTLIN ('   /negativeprint false def',27)
               Call PUTLIN ('   /mirrorprint false def',25)
               Call PUTLIN
     1            ('   11 72 mul 17 72 mul .5 72 mul 0 setpageparams',
     2            48)
               Call PUTLIN ('   end',6)
               Call PUTLIN ('   } bind def',13)
C
C...           Setup transformation for portrait orientation, assuming a 17 X 11
C...           page size
               Call PUTLIN ('/portrait {',11)
               Call PUTLIN ('   0 11 72 mul translate',24)
               Call PUTLIN ('   -90 rotate',13)
               Call PUTLIN ('   } bind def',13)
C...           No transformation for landscape orientation
               Call PUTLIN ('/landscape {} def',17)
C...           Force landscape orientation (for now)
               island = .TRUE.
C
            Else
C
C...           Apple LaserWriter (300 dpi) and generic PostScript printers
C
               dpi = DEVDPI
C
C...           By default, the page is in portrait orientation, with origin in
C...           the lower left corner, positive X from left to right, positive
C...           Y from bottom to top.
C
               Call PUTLIN ('/device_setup {} def',20)
C
C...           No transformation for portrait orientation
               Call PUTLIN ('/portrait {} def',16)
C...           Setup transformation for landscape orientation, assuming an
C...           8.5 X 11 page size
               Call PUTLIN ('/landscape {',12)
               Call PUTLIN ('   8.5 72 mul 0 translate',25)
               Call PUTLIN ('   90 rotate',12)
               Call PUTLIN ('   } bind def',13)
C...           Force landscape orientation (for now)
               island = .TRUE.
C
            End If
C
         End If
C
C...     Start of commands issued at the start of every page
C
C...     Scale transformation matrix from 72/in to dpi (user=device coords)
         If (island) then
               Call PUTLIN ('/landscape {',12)
               Call PUTLIN ('   8.25 72 mul 0.25 72 mul translate',36)
               Call PUTLIN ('   90 rotate',12)
               Call PUTLIN ('   } bind def',13)
         End If
         Call PUTLIN ('/everypage {',12)
         Call PUTSTR ('   72',5)
         Call PUTINT (dpi)
         Call PUTLIN ('div dup scale',13)
         If (.not. ISEPSF) Then
C...        Automatic stroke adjustment (Level 2 devices only)
            Call PUTLIN ('   true setstrokeadjust',23)
         End If
C...     Use rounded end caps and inflection elbows for polylines
         Call PUTLIN ('   1 setlinecap',15)
         Call PUTLIN ('   1 setlinejoin',16)
         Call PUTLIN ('   } bind def',13)
C
C...     End of commands issued at the start of every page
C
C...     Define abbreviations for "moveto", "rmoveto", "lineto", "rlineto",
C...     "stroke", "newpen", and "setfont" using Adobe Illustrator's mnemonics
C
         Call PUTLIN ('/m /moveto load def',19)
         Call PUTLIN ('/v /rmoveto load def',20)
         Call PUTLIN ('/L /lineto load def',19)
         Call PUTLIN ('/r /rlineto load def',20)
         Call PUTLIN ('/S /stroke load def',19)
         Call PUTLIN ('/w /setlinewidth load def',25)
         Call PUTLIN ('/z {pop pop pop exch findfont exch scalefont ' //
     1                'setfont} bind def',62)
C
         Call PUTLIN ('end',3)
         Call PUTLIN ('%%EndProcSet',12)
C
C...     End of definitions in private dictionary "USGS_Viewerdict"
C
C
      End If
C
C
C...  End of Document Prologue  ................................................
C
C
      Call PUTLIN ('%%EndProlog',11)
C
C
C...  Start of Document Body  ..................................................
C
C
C...  Start of Document Setup  .................................................
C
C
      Call PUTLIN ('%%BeginSetup',12)
C
      Call PUTSTR ('%%IncludeResource: font',23)
      Call PUTLIN (afname,afnch)
      If (.not. ISAI) Then
         If (ISEPSF) Then
            Call PUTLIN ('USGS_Viewerdict begin',21)
         Else
            Call PUTLIN ('% Remove the next two lines to make this a' //
     1                   ' conforming document',62)
            Call PUTLIN ('% (i.e., to incorporate this document into' //
     1                   ' another document)',60)
            Call PUTLIN ('grestoreall',11)
            Call PUTLIN ('initgraphics',12)
            Call PUTLIN ('USGS_Viewerdict begin',21)
            Call PUTLIN ('device_setup',12)
         End If
      End If
C
      Call PUTLIN ('%%EndSetup',10)
C
C
C...  End of Document Setup  ...................................................
C
C
C...  Initialize variables used by PLOT entry points
C
      kount = 0
C
C...  Allow file to be written by PLOT entry points now
C
      isopen = .TRUE.
C
      Return
C
      End
      Subroutine npPLOT (x, y, ipen)
C
      Implicit   None
C
      common /bakerp/xorig,yorig
      real xorig,yorig,xt,yt
C
      Include    'PostScript.inc'
C
      Integer    ICHANL, JCHANL, LPBUF, MAXVRT
      Parameter  ( ICHANL =   1 )
      Parameter  ( JCHANL =   2 )
      Parameter  ( LPBUF  =  80 )
      Parameter  ( MAXVRT = 256 )
      Logical    ISEPSF, ISAI
c     Parameter  ( ISEPSF = DEVICE .eq. 'EPSF' .or.
c    1                      DEVICE .eq. 'ILLUSTRATOR' )
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
C
      Real       x, y
      Integer    ipen
C
      Real       xlast, ylast
      Save       xlast, ylast
      Integer    j, xx, yy, xfloor, yfloor, xceil, yceil
      Integer    lastxx, lastyy, lastdx, lastdy
      Save       lastxx, lastyy, lastdx, lastdy
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
      Character  pbuf*(LPBUF)
      Common /IOC0N/  pbuf
C...  If DRAW or NEWPEN, virgin: .TRUE. -> .FALSE. (new page)
C...  If DRAW, dirty: .FALSE. -> .TRUE.
      Logical    island, virgin, dirty, ismove
      Integer    dpi, page, kount
      Real       pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Common /PSC0M/  island, virgin, dirty, ismove, dpi, page, kount,
     1                pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Save   /PSC0M/
C
      Data       kount/0/, page/0/, virgin/.TRUE./, dirty/.FALSE./
      ISEPSF = DEVICE .eq. 'EPSF' .or.
     1                      DEVICE .eq. 'ILLUSTRATOR' 
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
C
C...  No calls allowed before Call PLOTS (0,0,0) or after Call PLOT (x,y,999)
C
      If (.not. isopen) Then
         Goto 9000
      End If
C
C...  offset origin
C
      xt=x+xorig
      yt=y+yorig
C
C...     reset origin if ipen<0
C
      if (ipen.lt.0) then
c
c     reset origin
c
c        print *,'PLOT - origin reset'
         xorig=xorig + x
         yorig=yorig + y
      end if
C
C...  Scale the x and y coordinates
C
      xx = NINT (dpi * xt)
      yy = NINT (dpi * yt)
C
      If (ipen .eq. 2) Then
C
C...     DRAW command
C
         If (virgin) Then
            Call NEWPAG
         End If
C...     Update bounding box dimensions
         If (ismove) Then
            pxlow = MIN (xlast,pxlow)
            pylow = MIN (ylast,pylow)
            pxhi  = MAX (xlast,pxhi )
            pyhi  = MAX (ylast,pyhi )
         End If
         pxlow = MIN (x,pxlow)
         pylow = MIN (y,pylow)
         pxhi  = MAX (x,pxhi )
         pyhi  = MAX (y,pyhi )
C...     Appending to previous path?
         If (kount .gt. 0) Then
C...        Yes, room for more vertices in current path?
            If (kount .ge. MAXVRT) Then
C...           No, draw the current path
               Call PUTLIN ('S',1)
               kount = 0
            End If
         End If
C...     Move to the previous vertex first if starting a new path (must
C...     be absolute coordinates) or if previous call was a MOVE.
         If (kount .eq. 0) Then
            Call ABSMOV (lastxx,lastyy)
            kount = kount + 1
         Else If ((.not. ISAI) .and. ismove) Then
            Call OPTMOV (lastxx,lastyy,lastdx,lastdy)
            kount = kount + 1
         End If
C...     Append the new vertex to the end of the current path
         If (ISAI) Then
            Call ABSDRW (xx,yy)
         Else
            Call OPTDRW (xx,yy,lastxx,lastyy)
         End If
         kount = kount + 1
C...     Mark this frame dirty
         ismove = .FALSE.
         dirty  = .TRUE.
C
      Else If ((ipen .eq. 3) .or. (ABS(ipen) .eq. 999)) Then
C
C...     MOVE or END PLOT command
C
         If (.not. virgin) Then
C...        Is there a path open?
            If (kount .gt. 0) Then
C...           Is it Abobe Illustrator (absolute MOVEs/DRAWs only)?
               If (ISAI) Then
C...              Yes, draw the current path
                  Call PUTLIN ('S',1)
                  kount = 0
               Else
C...              No, if last op this path was a DRAW, save the coordinates
                  If (.not. ismove) Then
                     lastdx = lastxx
                     lastdy = lastyy
                  End If
               End If
            End If
         End If
         xlast  = x
         ylast  = y
         ismove = .TRUE.
C
C...     Print the page if this is the END OF FRAME/RUN
C
         If (ABS(ipen) .eq. 999) Then
            If (.not. virgin) Then
C...           Is there a path open?
               If (kount .gt. 0) Then
C...              Yes, draw the current path
                  Call PUTLIN ('S',1)
                  kount = 0
               End If
C...           Display the page (even if something has not been written on it)
               If (.not. ISAI) Then
C...              Technically, Encapsulated PostScript files shouldn't have any
C...              "showpage"'s in them.  But the specification recognizes that
C...              too many documents already have "showpage" in them, so it is
C...              up to the importing application to redefine "showpage" so its
C...              effect is benign.  The advantage in having "showpage" in the
C...              file is that the document can be previewed by sending the file
C...              to a PostScript device, just like a standard PostScript file.
                  Call PUTLIN ('showpage',8)
               End If
               If (.not. ISEPSF) Then
                  Call PUTLIN ('%%PageTrailer',13)
               End If
               If (dirty) Then
                  If (.not. ISEPSF) Then
                     xfloor = INT (pxlow*72)
                     yfloor = INT (pylow*72)
                     xceil  = INT (pxhi*72)
                     If (xceil .lt. pxhi*72) Then
                        xceil = xceil + 1
                     End If
                     yceil  = INT (pyhi*72)
                     If (yceil .lt. pyhi*72) Then
                        yceil = yceil + 1
                     End If
                     Call PUTSTR ('%%PageBoundingBox:',18)
                     Call PUTINT (xfloor)
                     Call PUTINT (yfloor)
                     Call PUTINT (xceil )
                     Call PUTINT (yceil )
                     Call PUTLIN (' ',0)
                  End If
                  dxlow = MIN (pxlow,dxlow)
                  dylow = MIN (pylow,dylow)
                  dxhi  = MAX (pxhi, dxhi )
                  dyhi  = MAX (pyhi, dyhi )
                  dirty = .FALSE.
               Else If (.not. ISEPSF) Then
                  Call PUTLIN ('%%PageBoundingBox: (none)',25)
               End If
               lastxx = 0
               lastyy = 0
               virgin = .TRUE.
            End If
C
         End If
C
C...     Flush buffers and close file if this is the END OF RUN
C...     (or the END OF FRAME in the Encapsulated PostScript version)
C
         If (ipen .eq. 999) Then
            Call TRAILR
            Goto 9000
         End If
C
      End If
C
C...  Save last coordinate positions for initiation of a sequence of DRAW
C...  commands or the continuation of DRAW commands that span multiple paths.
      lastxx = xx
      lastyy = yy
C
 9000 Return
C
      End
      Subroutine npNEWPEN (ipen)
C
      Implicit   None
C
      Include    'PostScript.inc'
C
      Logical    ISAI
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
C
      Integer    ipen
C
      Real       rpen
      Integer    j, jpen
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
C...  If DRAW or NEWPEN, virgin: .TRUE. -> .FALSE. (new page)
C...  If DRAW, dirty: .FALSE. -> .TRUE.
      Logical    island, virgin, dirty, ismove
      Integer    dpi, page, kount
      Real       pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Common /PSC0M/  island, virgin, dirty, ismove, dpi, page, kount,
     1                pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Save   /PSC0M/
C
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
C...  No calls allowed before Call PLOTS (0,0,0) or after Call PLOT (x,y,999)
      If (.not. isopen) Then
         Goto 9000
      End If
C
      If (virgin) Then
         Call NEWPAG
      Else
C...     Is there a path open?
         If (kount .gt. 0) Then
C...        Yes, draw the current path
            Call PUTLIN ('S',1)
            kount = 0
         End If
      End If
C
C...  Scale "pen width" so its the same as on a 300 dpi LaserWriter
C
      jpen = ipen
      If (jpen .lt. 1) Then
         jpen = 1
      End If
      If (jpen .gt. 20) Then
         jpen = 20
      End If
      rpen = jpen * (dpi/300.)
      If (ISAI) Then
         Call PUTFLT (rpen/100.)
      Else
         Call PUTINT (NINT(rpen))
      End If
      Call PUTLIN ('w',1)
C
 9000 Return
C
      End
      Subroutine npSYMBOL (x, y, hgt, text, angle, nc)
C
      Implicit   None
C
c     External   VWPLOT
      External   PLOT
C
      common /bakerp/xorig,yorig
      real xorig,yorig,xt,yt
c
      Include    'PostScript.inc'
C
      Logical    ISAI
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
      Real       FUDGE
      Parameter  ( FUDGE  = 1.5 )
C
      Real       x, y, hgt, angle
      Character*(*) text
      Integer    nc,itext
C
      character*(1) slash
C
      Real       rangle, rsin, rcos, bx(2), by(2), bbx, bby
      Integer    i, j, nch, xx, yy, scale, pscale, afnch
      Character  cbuf*255, afname*80
      Save       pscale
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
C...  If DRAW or NEWPEN, virgin: .TRUE. -> .FALSE. (new page)
C...  If DRAW, dirty: .FALSE. -> .TRUE.
      Logical    island, virgin, dirty, ismove
      Integer    dpi, page, kount
      Real       pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Common /PSC0M/  island, virgin, dirty, ismove, dpi, page, kount,
     1                pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Save   /PSC0M/
C
C     NOTE: 92 is ASCII code for the backslash (\) symbol
C           Different unix F77 compilers treat this symbol differently,
C           so I had to put this code in instead of explicit '\'.
C
      slash=char(92)
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
C...  No calls allowed before Call PLOTS (0,0,0) or after Call PLOT (x,y,999)
      If (.not. isopen) Then
         Goto 9000
      End If
C
      If (virgin) Then
         Call NEWPAG
         pscale = 0
      Else
C...     Is there a path open?
         If (kount .gt. 0) Then
C...        Yes, draw the current path
            Call PUTLIN ('S',1)
            kount = 0
         End If
      End If
C...
C     reset origin
C
      xt=x+xorig
      yt=y+yorig
C
C...  Scale the x and y coordinates
C
      xx = NINT (dpi * xt)
      yy = NINT (dpi * yt)
C
C...  Make sure string will fit in cbuf
      nch = MIN (nc,255)
      If (nch .le. 0) Then
         If (ISAI) Then
C...        Group graphic elements into a single composite object
            Call PUTSTR ('u',1)
         End If
c        Call PLSYMB (x,y,hgt,itext,angle,nch,VWPLOT)
         if (nc.lt.-1) call plot(x,y,2)
         itext=ichar(text(1:1))
         Call PLSSYMB(x,y,itext,hgt)
         If (ISAI) Then
C...        Is there a path open?
            If (kount .gt. 0) Then
C...           Yes, draw the current path
               Call PUTSTR ('S',1)
               kount = 0
            End If
C...        End of composite object
            Call PUTLIN ('U',1)
         End If
      Else
c        Write (cbuf,'(64A4)') (itext(j), j = 1,(nch+3)/4)
         Write (cbuf,'(256a1)') (text(j:j), j = 1,nc)
         scale = NINT (hgt*dpi*FUDGE)
         If (scale .ne. pscale) Then
            Call AFMFON (afname,afnch)
            Call PUTSTR ('/'//afname,afnch+1)
            If (ISAI) Then
               Call PUTFLT (scale/100.)
            Else
               Call PUTINT (scale)
            End If
            Call PUTLIN ('0 0 0 z',7)
            pscale = scale
         End If
C...     Update bounding box dimensions
         rangle = ( ATAN(1.) / 45. ) * angle
         rsin = SIN (rangle)
         rcos = COS (rangle)
         Call AFMBB (cbuf,nch,bx(1),by(1),bx(2),by(2))
         Do 1200 j = 1,2
            Do 1100 i = j,3-j,(3-j)-j
               bbx = x + ( hgt * FUDGE * ( bx(i)*rcos - by(j)*rsin ) )
               bby = y + ( hgt * FUDGE * ( bx(i)*rsin + by(j)*rcos ) )
               pxlow = MIN (bbx,pxlow)
               pylow = MIN (bby,pylow)
               pxhi  = MAX (bbx,pxhi )
               pyhi  = MAX (bby,pyhi )
 1100          Continue
 1200       Continue
         If (ISAI) Then
            Call PUTSTR ('[',1)
            Call PUTFLT ( rcos)
            Call PUTFLT ( rsin)
            Call PUTFLT (-rsin)
            Call PUTFLT ( rcos)
            Call PUTFLT (xx/100.)
            Call PUTFLT (yy/100.)
            Call PUTSTR ('] e',3)
            Call PUTINT (nch)
            If (nch .le. 64) Then
C...           String fits on one line
               Call PUTSTR ('('//cbuf(1:nch)//')',nch+2)
            Else
C...           Split string across multiple lines using PostScript end-of-line
C...           continuation (\<EOL>)
               Call PUTSTR ('('//cbuf(1:64)//slash,64+2)
               Do 6300 j = 65,nch-64,64
                  Call PUTSTR (cbuf(j:j+63)//slash,64+1)
 6300             Continue
               Call PUTSTR (cbuf(j:nch)//')',nch-j+1+1)
            End If
            Call PUTLIN ('t T',3)
         Else
            Call ABSMOV (xx,yy)
            If (angle .ne. 0.0) Then
               Call PUTSTR ('gsave',5)
               Call PUTFLT (angle)
               Call PUTSTR ('rotate',6)
            End If
            If (nch .le. 64) Then
C...           String fits on one line
               Call PUTSTR ('('//cbuf(1:nch)//')',nch+2)
            Else
C...           Split string across multiple lines using PostScript end-of-line
C...           continuation (\<EOL>)
               Call PUTSTR ('('//cbuf(1:64)//slash,64+2)
               Do 8300 j = 65,nch-64,64
                  Call PUTSTR (cbuf(j:j+63)//slash,64+1)
 8300             Continue
               Call PUTSTR (cbuf(j:nch)//')',nch-j+1+1)
            End If
            Call PUTSTR ('show',4)
            If (angle .ne. 0.0) Then
               Call PUTSTR ('grestore',8)
            End If
            Call PUTLIN (' ',0)
         End If
      End If
C
 9000 Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine AFMFON (string, nc)
C
      Implicit   None
C
      Real       xlow, ylow, xhi, yhi
      Integer    nc
      Character  string*(*)
C
C...  Device font metrics in Block Data AFMBD
C
      Real       fm(6,0:255)
      Integer    nfname
      Character  fname*80
      Common /AFMCM1/  nfname, fm
      Common /AFMCM2/  fname
C
      Real       x, y, x0, y0
      Integer    j, ic
C
C...  Return name of loaded font
C
      string = fname(1:nfname)
      nc     = nfname
      Return
C
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Entry AFMBB (string, nc, xlow, ylow, xhi, yhi)
C
C
C...  Return bounding-box dimensions for string
C
      xlow = 0.0
      ylow = 0.0
      xhi  = 0.0
      yhi  = 0.0
      x0 = 0.0
      y0 = 0.0
      Do 2000 j = 1,nc
         ic = ICHAR (string(j:j))
C...     Substitute ASCII Space character if illegal value from ICHAR
         If ((ic .lt. 0) .or. (ic .gt. 255)) Then
            ic = 32
         End If
         xlow = MIN (x0+fm(3,ic),xlow)
         ylow = MIN (y0+fm(4,ic),ylow)
         xhi  = MAX (x0+fm(5,ic),xhi )
         yhi  = MAX (y0+fm(6,ic),yhi )
         x0 = x0 + fm(1,ic)
         y0 = y0 + fm(2,ic)
 2000    Continue
      Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine NEWPAG
C
      Implicit   None
C
      Include    'PostScript.inc'
C
      Logical    ISEPSF, ISAI
c     Parameter  ( ISEPSF = DEVICE .eq. 'EPSF' .or.
c    1                      DEVICE .eq. 'ILLUSTRATOR' )
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
C
C...  If DRAW or NEWPEN, virgin: .TRUE. -> .FALSE. (new page)
C...  If DRAW, dirty: .FALSE. -> .TRUE.
      Logical    island, virgin, dirty, ismove
      Integer    dpi, page, kount
      Real       pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Common /PSC0M/  island, virgin, dirty, ismove, dpi, page, kount,
     1                pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Save   /PSC0M/
C
      ISEPSF = DEVICE .eq. 'EPSF' .or.
     1                      DEVICE .eq. 'ILLUSTRATOR' 
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
      page = page + 1
      If (ISEPSF .and. (page .gt. 1)) Then
C
C...     Attempt to draw more than one page in an Encapsulated PostScript or
C...     Adobe Illustrator document
C
         Write (*,601)
  601    Format (/' Warning:  Multiple pages are not allowed in an',
     1            ' Encapsulated PostScript document.'/
     2            '           Further plotting calls will be ignored.'/)
         Call TRAILR
         Goto 9000
      End If
      If (ISAI) Then
C...     Use rounded end caps and inflection elbows for polylines
         Call PUTLIN ('1 J',3)
         Call PUTLIN ('1 j',3)
C...     Use black for path strokes and character fills
         Call PUTLIN ('0 G',3)
         Call PUTLIN ('0 g',3)
      Else If (ISEPSF) Then
C...     Initialize PostScript environment for the page
         If (island) Then
            Call PUTLIN ('landscape',9)
         Else
            Call PUTLIN ('portrait',8)
         End If
         Call PUTLIN ('everypage',9)
      Else
         Call PUTSTR ('%%Page:',7)
         Call PUTINT (page)
         Call PUTINT (page)
         Call PUTLIN (' ',0)
C...     Initialize PostScript environment for next page
         Call PUTLIN ('%%BeginPageSetup',16)
         If (island) Then
            Call PUTLIN ('landscape',9)
         Else
            Call PUTLIN ('portrait',8)
         End If
         Call PUTLIN ('everypage',9)
         Call PUTLIN ('%%EndPageSetup',14)
         Call PUTLIN ('%%PageBoundingBox: (atend)',26)
      End If
      pxlow = 1E10
      pylow = 1E10
      pxhi  = 0.0
      pyhi  = 0.0
      virgin = .FALSE.
C
 9000 Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine TRAILR
C
      Implicit   None
C
      Include    'PostScript.inc'
C
      Integer    ICHANL, JCHANL, LPBUF
      Parameter  ( ICHANL =   1 )
      Parameter  ( JCHANL =   2 )
      Parameter  ( LPBUF  =  80 )
      Logical    ISEPSF, ISAI
c     Parameter  ( ISEPSF = DEVICE .eq. 'EPSF' .or.
c    1                      DEVICE .eq. 'ILLUSTRATOR' )
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
C
      Integer    j, xfloor, yfloor, xceil, yceil
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
      Character  pbuf*(LPBUF)
      Common /IOC0N/  pbuf
C...  If DRAW or NEWPEN, virgin: .TRUE. -> .FALSE. (new page)
C...  If DRAW, dirty: .FALSE. -> .TRUE.
      Logical    island, virgin, dirty, ismove
      Integer    dpi, page, kount
      Real       pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Common /PSC0M/  island, virgin, dirty, ismove, dpi, page, kount,
     1                pxlow, pylow, pxhi, pyhi, dxlow, dylow, dxhi, dyhi
      Save   /PSC0M/
C
      ISEPSF = DEVICE .eq. 'EPSF' .or.
     1                      DEVICE .eq. 'ILLUSTRATOR' 
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
C
C...  Start of Document Trailer  .........................................
C
C
      Call PUTLIN ('%%Trailer',9)
      If (.not. ISAI) Then
         Call PUTLIN ('end',3)
      End If
      xfloor = INT (dxlow*72)
      xceil  = INT (dxhi*72)
      If (xceil .lt. dxhi*72) Then
         xceil = xceil + 1
      End If
      yfloor = INT (dylow*72)
      yceil  = INT (dyhi*72)
      If (yceil .lt. dyhi*72) Then
         yceil = yceil + 1
      End If
      If (.not. ISEPSF) Then
         Call PUTSTR ('%%BoundingBox:',14)
         Call PUTINT (xfloor)
         Call PUTINT (yfloor)
         Call PUTINT (xceil )
         Call PUTINT (yceil )
         Call PUTLIN (' ',0)
         Call PUTSTR ('%%Pages:',8)
         Call PUTINT (page)
         Call PUTLIN ('1',1)
      End If
      Call PUTLIN ('%%EOF',5)
C
C
C...  End of Document Trailer    .........................................
C
C
      Call PFLUSH
      If (ISEPSF) Then
         End File (Unit=JCHANL)
         Rewind (Unit=JCHANL)
 5200    Read (JCHANL,End=5900) ipctr, pbuf
         If ((ipctr .eq. LEN('%%BoundingBox: (atend)')+1) .and.
     1       (pbuf(1:ipctr-1) .eq. '%%BoundingBox: (atend)')) Then
            ipctr = 15
            Call PUTINT (xfloor)
            If (ISAI) Then
C...           Old versions of Adobe Illustrator don't like any spaces
C...           after the colon (see also "%%TemplateBox:0 0 0 0" above)
               Do 5300 j = 16,ipctr-1
                  pbuf(j-1:j-1) = pbuf(j:j)
 5300             Continue
               ipctr = ipctr - 1
            End If
            Call PUTINT (yfloor)
            Call PUTINT (xceil )
            Call PUTINT (yceil )
         End If
         Write (ICHANL,'(A)') pbuf(1:ipctr-1)
         Goto 5200
 5900    Close (Unit=JCHANL)
      End If
      Close (Unit=ICHANL)
C
C...  Disallow any further access to the file now
C
c     isopen = .FALSE.
C
      Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C-
c     modified by saltus 1/21/93
c
      Subroutine ABSMOV (xx, yy)
C
C...  Append the new vertex to the end of the current path
C
      Implicit   None
C
      Include    'PostScript.inc'
C
      Logical    ISAI
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
C
      Integer    xx, yy, lastxx, lastyy
C
      Integer    i, j, k, ncabs, ncrel, nai
      Logical    useabs
      Character  absstr*13, relstr*13, aistr*15, abs*2, rel*2
c     character*1 ans
C
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
c     ISAI   = .false.
      abs = ' m'
      Goto 1000
C
      Entry ABSDRW (xx, yy)
c     print *,'ABSDRW xx, yy'
c     print *,xx,yy
c     read(5,'(a1)')ans
C
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
      abs = ' L'
C
 1000 Call VECSTR (xx,yy,absstr,ncabs)
      useabs = .TRUE.
      Goto 4000
C
      Entry OPTMOV (xx, yy, lastxx, lastyy)
C
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
      abs = ' m'
      rel = ' v'
      Goto 2000
C
      Entry OPTDRW (xx, yy, lastxx, lastyy)
C
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
      abs = ' L'
      rel = ' r'
C
C...  Absolute coordinates
 2000 Call VECSTR (xx,yy,absstr,ncabs)
C...  Relative coordinates
      Call VECSTR (xx-lastxx,yy-lastyy,relstr,ncrel)
C
C...  Use the shorter of the two
      If (ncabs .lt. ncrel) Then
         useabs = .TRUE.
      Else If (ncrel .lt. ncabs) Then
         useabs = .FALSE.
C...  They're both the same length, so use absolute coordinates,
C...  provided they're on-scale
      Else If (absstr(ncabs:ncabs) .ne. '999999 999999') Then
         useabs = .TRUE.
      Else
         useabs = .FALSE.
      End If
C
 4000 If (useabs) Then
         ncabs = ncabs + 2
         absstr(ncabs-1:ncabs) = abs
         If (ISAI) Then
            nai = ncabs
            Do 4100 j = 1,nai
               aistr(j:j) = absstr(j:j)
 4100          Continue
         Else
            Call PUTSTR (absstr,ncabs)
         End If
      Else
         ncrel = ncrel + 2
         relstr(ncrel-1:ncrel) = rel
         If (ISAI) Then
            nai = ncrel
            Do 4200 j = 1,nai
               aistr(j:j) = relstr(j:j)
 4200          Continue
         Else
            Call PUTSTR (relstr,ncrel)
         End If
      End If
c
      If (ISAI) Then
c
C...     Convert coordinates from 7200 dpi to 72 dpi (knowing format is I6.3)
         i = nai + 3
         k = nai + 1
         Do 4300 j = nai,1,-1
            If (aistr(j:j) .eq. ' ') Then
C...           Insert a decimal point when loop reaches j-3
               k = j - 3
            End If
            If (j .eq. k) Then
C...           Eliminate non-significant zeroes
               If (aistr(i:i+1) .eq. '00') Then
                  i = i + 2
               Else
                  If (aistr(i+1:i+1) .eq. '0') Then
                     aistr(i+1:i+1) = aistr(i:i)
                     i = i + 1
                  End If
                  i = i - 1
                  aistr(i:i) = '.'
               End If
            End If
            i = i - 1
            aistr(i:i) = aistr(j:j)
 4300       Continue
         Call PUTSTR (aistr(i:),nai+3-i)
      End If
C
 9000 Return
C
      End
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine VECSTR (x, y, str, nc)
C
C...  Size of str must accomodate two 6 digit integer coordinates
C...  (Note:  For Adobe Illustrator, the format used is I6.3 so that the
C...  coordinates can be converted from 7200 dpi to 72 dpi by inserting
C...  a decimal point before the second-to-the-last character.)
C
      Implicit   None
C
      Include    'PostScript.inc'
C
      Logical    ISAI
c     Parameter  ( ISAI   = DEVICE .eq. 'ILLUSTRATOR' )
C
      Integer    x, y, nc
      Character  str*13
C
      Integer    i, j
      Character  t*1
      ISAI   = DEVICE .eq. 'ILLUSTRATOR' 
C
      If (ISAI) Then
         Write (str,101,Err=9900) x, y
  101    Format (I6.3, ',', I6.3)
      Else
         Write (str,102,Err=9900) x, y
  102    Format (I6, ',', I6)
      End If
      i = 1
      Do 1000 j = 1,LEN(str)-1
         t = str(j:j)
         If (t .ne. ' ') Then
            If (t .eq. ',') Then
               t = ' '
            End If
            str(i:i) = t
            i = i + 1
         End If
 1000    Continue
 1900 str(i:) = str(LEN(str):LEN(str))
C
 9000 nc = i
      Return
C
 9900 str = '999999 999999'
      i = LEN(str)
      Goto 9000
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine PUTINT (i)
C
      Implicit   None
C
      Integer    LPBUF
      Parameter  ( LPBUF  =  80 )
C
      Real       r
      Integer    i, nc
      Character  cn*(*), c1*1
C
      Integer    j, ni
      Logical    newlin
      Character  ci*8
C
      Integer    ipctr, lci
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
      Character  pbuf*(LPBUF)
      Common /IOC0N/  pbuf
C
      Write (ci,101) i
  101 Format (I8)
      lci = LEN(ci)
      Goto 1000
C
C
      Entry PUTFLT (r)
C
C
      Write (ci,102) r
  102 Format (F8.3)
C
C     saltus fix (4/10/92) - add leading zero if blank...
C
      If (ci(4:4) .eq. ' ') Then
         ci(4:4) = '0'
      End If
      lci = LEN(ci)
  990 If (ci(lci:lci) .eq. '0') Then
         lci = lci - 1
         Goto 990
      End If
      If (ci(lci:lci) .eq. '.') Then
         lci = lci - 1
      End If
C
 1000 Do 1100 j = lci,1,-1
         If (ci(j:j) .eq. ' ') Then
            Goto 1200
         End If
 1100    Continue
C...  Fortran-77 specifies j = 0 at this point
C     j = 0
 1200 ni = lci - j
      If (ipctr .gt. 1) Then
         If (ipctr+ni .gt. LPBUF) Then
            Call PFLUSH
         End If
      End If
      If (ipctr .gt. 1) Then
         pbuf(ipctr:ipctr) = ' '
         ipctr = ipctr + 1
      End If
      pbuf(ipctr:ipctr+ni-1) = ci(j+1:lci)
      ipctr = ipctr + ni
      Goto 9000
C
C
      Entry PUTSTR (cn, nc)
C
C
      newlin = .FALSE.
      Goto 3000
C
C
      Entry PUTLIN (cn, nc)
C
C
      newlin = .TRUE.
C
 3000 If (nc .gt. 0) Then
         If (ipctr .gt. 1) Then
            If (ipctr+nc .gt. LPBUF) Then
               Call PFLUSH
            End If
         End If
         If (ipctr .gt. 1) Then
            pbuf(ipctr:ipctr) = ' '
            ipctr = ipctr + 1
         End If
         pbuf(ipctr:ipctr+nc-1) = cn(1:nc)
         ipctr = ipctr + nc
      End If
      If (newlin) Then
         Call PFLUSH
      End If
      Goto 9000
C
C
      Entry PUTCHR (c1)
C
C
      If (ipctr .gt. 1) Then
         If (ipctr+1 .gt. LPBUF) Then
            Call PFLUSH
         End If
      End If
      If (ipctr .gt. 1) Then
         pbuf(ipctr:ipctr) = ' '
         ipctr = ipctr + 1
      End If
      pbuf(ipctr:ipctr) = c1
      ipctr = ipctr + 1
C
 9000 Return
C
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine PFLUSH
C
      Implicit   None
C
      Include    'PostScript.inc'
C
      Integer    ICHANL, JCHANL, LPBUF
      Parameter  ( ICHANL =   1 )
      Parameter  ( JCHANL =   2 )
      Parameter  ( LPBUF  =  80 )
      Logical    ISEPSF
c     Parameter  ( ISEPSF = DEVICE .eq. 'EPSF' .or.
c    1                      DEVICE .eq. 'ILLUSTRATOR' )
C
      Integer    ipctr
      Logical    isopen
      Common /IOC0M/  ipctr, isopen
      Character  pbuf*(LPBUF)
      Common /IOC0N/  pbuf
C
      ISEPSF = DEVICE .eq. 'EPSF' .or.
     1                      DEVICE .eq. 'ILLUSTRATOR' 
      If (ipctr .gt. 1) Then
         If (ISEPSF) Then
            Write (JCHANL) ipctr, pbuf
         Else
            Write (ICHANL,'(A)') pbuf(1:ipctr-1)
         End If
         ipctr = 1
      End If
C
      Return
C
      End
C
C-
Cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine plssymb(x,y,itsymb,ht)
C
C     Modified from Bruce Chuchel's pltsymb for the 
C     postscript and simple plot systems on Musette
C
C     Plots a centered symbol of various kinds.
C
C                  PLTSYMB     		PLSSYMB
C                  old symbol           new symbol
C      isymb = 0 = none			box
C      isymb = 1 = plus			circle
C      isymb = 2 = box			triangle (apex up)
C      isymb = 3 = minute strike	plus
C      isymb = 4 = second strike  	X
C      isymb = 5 = X			diamond
C      isymb = 6 = circle 		triangle (down)
C      isymb = 7 = edge tic		pentagon
C      isymb = 8 = edge tic		hexagon
C      isymb = 9 = diamond		octagon
C      isymb = 10 = triangle (apex up)	X and diamond
C      isymb = 11 = triangle (apex down)X and plus
C      isymb = 12 = pentagon		box and X
C      isymb = 13 = hexagon		minute strike
C      isymb = 14 = octagon		second strike	
C              15   			edge tic (old 7)
C              16                       edge tic (old 8)
C      isymb = 19 = Point		Point
C      isymb = 20 -> 32 map back to 1 - 13
C
c      Real xcir(50),ycir(50)
      Real xcir(37),ycir(37)
      Integer nsymb(33)
C
      Character xyzprj*1
      Common /proj/xyzprj
      Common /inchbounds/xltmp,xrtmp,ybtmp,yttmp
C
C     remap old symbol numbers
C
      Data nsymb/2,6,10,1,5,9,11,12,13,14,5,5,5,3,4,7,8,3,3,19,
     &           2,6,10,1,5,9,11,12,13,14,9,1,2/
C
      Data xcir/1.000000,0.9848077,0.9396926,0.8660254,0.7660444,
     & 0.6427876,0.5000000,0.3420202,0.1736482,-4.3711388E-08,
     & -0.1736482,-0.3420201,-0.5000001,-0.6427876,-0.7660444,
     & -0.8660255,-0.9396926,-0.9848077,-1.000000,-0.9848077,
     & -0.9396926,-0.8660253,-0.7660445,-0.6427875,-0.4999999,
     & -0.3420201,-0.1736481,1.1924881E-08,0.1736481,0.3420201,
     & 0.5000004,0.6427875,0.7660443,0.8660256,0.9396926,
     & 0.9848078,1.000000/
C
      Data ycir/0.0000000E+00,0.1736482,0.3420201,0.5000000,0.6427876,
     & 0.7660444,0.8660254,0.9396926,0.9848077,1.000000,0.9848077,
     & 0.9396926,0.8660254,0.7660444,0.6427876,0.4999999,0.3420202,
     & 0.1736483,-8.7422777E-08,-0.1736482,-0.3420202,-0.5000002,
     & -0.6427876,-0.7660446,-0.8660254,-0.9396926,-0.9848078,
     & -1.000000,-0.9848077,-0.9396926,-0.8660252,-0.7660445,
     & -0.6427878,-0.4999998,-0.3420204,-0.1736480,1.7484555E-07/
C
C
C  sqrt3 = sqrt(3.0)
      Data sqrt3/1.7320508/
C
      iclip = 0
C
C - Larry Baker symbol calls.
C
C   remap symbol numbers
C
      isymb=nsymb(itsymb+1)
C
    5 continue
      If (itsymb.GE.20.AND.itsymb.LE.32) Then
C        Call symbol(x,y,ht,isymb-20,0.,-1)
         isymb=itsymb-19
         end if
C
C - Mariano/Simpson symbol call.s
C
c     Else
         ht2=0.5*ht
         x1=x-ht2
         x2=x+ht2
         y1=y-ht2
         y2=y+ht2
C
c         x1=amax1(x1,xltmp)
c         x2=amin1(x2,xrtmp)
c         y1=amax1(y1,ybtmp)
c         y2=amin1(y2,yttmp)
C
C - Plot plus
C
         If (isymb.EQ.1) Then
            call plot(x1,y,3)
            call plot(x2,y,2)
            call plot(x,y1,3)
            call plot(x,y2,2)
C
C - Plot box
C
         Else If (isymb.EQ.2) Then
            call plot(x1,y1,3)
            call plot(x2,y1,2)
            call plot(x2,y2,2)
            call plot(x1,y2,2)
            call plot(x1,y1,2)
C
C - Plot minute strike
C
         Else If (isymb.EQ.3) Then
            y1=y-sqrt3*ht2/4
            call plot(x-ht2/4,y1,3)
            y2=y+sqrt3*ht2/4
            call plot(x+ht2/4,y2,2)
C
C - Plot second strike
C
         Else If (isymb.EQ.4) Then
            y1=y-sqrt3*ht2/4
            call plot(x-ht2/4,y1,3)
            y2=y+sqrt3*ht2/4
            call plot(x+ht2/4,y2,2)
            x=x+.02
            y3=y-sqrt3*ht2/4
            call plot(x-ht2/4,y3,3)
            y4=y+sqrt3*ht2/4
            call plot(x+ht2/4,y4,2)
C
C - Plot X
C
         Else If (isymb.EQ.5) Then
            call plot(x1,y2,3)
            call plot(x2,y1,2)
            call plot(x1,y1,3)
            call plot(x2,y2,2)
C
C         special code for double symbols
C
            if (itsymb.eq.10) then
              isymb=9
              goto 5
            else if (itsymb.eq.11) then
              isymb=1
              goto 5
            else if (itsymb.eq.12) then
              isymb=2
              goto 5
            end if
C
C - Plot circle
C
         Else If (isymb.EQ.6) Then
            nsides=37
            x1=x+ht2*xcir(1)
            y1=y+ht2*ycir(1)
            call plot(x1,y1,3)
            Do 30 i=2,nsides
            x1=x+ht2*xcir(i)
            y1=y+ht2*ycir(i)
c            x1=amax1(x1,xltmp)
c            x1=amin1(x1,xrtmp)
c            y1=amax1(y1,ybtmp)
c            y1=amin1(y1,yttmp)
            call plot(x1,y1,2)
   30       Continue
C
C - Plot edge tic
C
         Else If (isymb.EQ.7) Then
            call plot(x,y,3)
            call plot(x,y+ht,2)
C
C - Plot edge tic
C
         Else If (isymb.EQ.8) Then
            call plot(x,y,3)
            call plot(x+ht,y,2)
C
C - Plot diamond
C
         Else If (isymb.EQ.9) Then
            call plot(x,y2,3)
            call plot(x2,y,2)
            call plot(x,y1,2)
            call plot(x1,y,2)
            call plot(x,y2,2)
C
C - Plot triangle (apex up)
C
         Else If (isymb.EQ.10) Then
            y3=y-ht/3
            x3=x-(ht/3)*sqrt3
            x4=x+(ht/3)*sqrt3
c            y3=amax1(y3,ybtmp)
c            x3=amax1(x1,xltmp)
c            x4=amin1(x2,xrtmp)
            call plot(x,y2,3)
            call plot(x4,y3,2)
            call plot(x3,y3,2)
            call plot(x,y2,2)
C
C  - Plot triangle (apex down)
C
         Else If (isymb.EQ.11) Then
            y3=y-ht/3
            x3=x-(ht/3)*sqrt3
            x4=x+(ht/3)*sqrt3
c            y3=amax1(y3,ybtmp)
c            x3=amax1(x1,xltmp)
c            x4=amin1(x2,xrtmp)
            call plot(x4,y2,3)
            call plot(x3,y2,2)
            call plot(x,y3,2)
            call plot(x4,y2,2)
C
C - Plot pentagon
C
         Else If (isymb.EQ.12) Then
C - Cos (18.0) = 0.9510565, (18.0 is in degrees).
            radius=ht2/0.9510565
            call plotngon(x,y,5,radius,18.0,iclip,xltmp,xrtmp,
     & ybtmp,yttmp,0)
C
C - Plot hexagon
C
         Else If (isymb.EQ.13) Then
C - Sin (60.0) = 0.8660254,  (60.0 is in degrees).
            radius=ht2/0.8660254
            Call plotngon(x,y,6,radius,0.0,iclip,xltmp,xrtmp,
     & ybtmp,yttmp,0)
C
C - Plot octagon
C
         Else If (isymb.EQ.14) Then
C - Cos (22.5) = 0.9238795,  (22.5 is in degrees).
            radius=ht2/0.9238795
            Call plotngon(x,y,8,radius,22.5,iclip,xltmp,xrtmp,
     & ybtmp,yttmp,0)
         Else If (isymb.EQ.19) Then
            call plot(x-0.004,y-0.004,3)
            call plot(x+0.004,y+0.004,2)
         End If
c     End If
      
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C  plotngon - Draws an n-sided polygon centered on (x,y).  Uses the Larry 
C           Baker plot library.  NOTE: The symbol is drawn as an open shaped 
C           n-gon; and NSIDE, must be greater than or equal to three (3).
C-
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine plotngon(x,y,nside,radius,theta,nclip,xleft,xright,
     & ybot,ytop,itype)
C
cd      Print *,' Made it to plotngon'
      If (nside.GE.3) Then
         absrad = abs(radius)
         therad = theta * 3.14159 / 180.0
         thedel = 2.0 * 3.14159 / nside
         thenew = therad
         xlast = x + absrad * cos(therad)
         ylast = y + absrad * sin(therad)
C
cd         Print *,' plotting sides'
         If (nclip.EQ.1) Then
            Do 10 i = 1,nside
            thenew = thenew + thedel
            xnew = x + absrad * cos(thenew)
            ynew = y + absrad * sin(thenew)
            Call plotclip(xlast,ylast,xnew,ynew,xleft,xright,
     & ybot,ytop,itype,inout)
            xlast = xnew
            ylast = ynew
10          Continue
         Else
            Do 20 i = 1,nside
            thenew = thenew + thedel
            xnew = x + absrad * cos(thenew)
            ynew = y + absrad * sin(thenew)
            Call plotline(xlast,ylast,xnew,ynew,itype)
            xlast = xnew
            ylast = ynew
20          Continue
         End If
      End If
C
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C  plotclip - Clips and draws a line segment passed to the routine using the 
C             Larry Baker plot library passed to the routine.
C
C-
      Subroutine plotclip(x1,y1,x2,y2,xleft,xright,ybot,ytop,itype,
     & inout)
C
      Call tstend(inout,x1,y1,x2,y2,xleft,xright,ybot,ytop)
C
      If (inout.EQ.3) Then
         Call plotline(x1,y1,x2,y2,itype)
      Else If (inout.EQ.2) Then
         Call clipper(xone,yone,x1,y1,x2,y2,xleft,xright,ybot,ytop)
         Call plotline(xone,yone,x2,y2,itype)
      Else If (inout.EQ.1) Then
         Call clipper(xtwo,ytwo,x2,y2,x1,y1,xleft,xright,ybot,ytop)
         Call plotline(x1,y1,xtwo,ytwo,itype)
      Else If (inout.EQ.0) Then
         Call clipper(xone,yone,x1,y1,x2,y2,xleft,xright,ybot,ytop)
         Call clipper(xtwo,ytwo,x2,y2,x1,y1,xleft,xright,ybot,ytop)
         Call plotline(xone,yone,xtwo,ytwo,itype)
      End If
C
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C  plotline - Plots a line segment using the Larry Baker plot library.
C             NOTE: It is recommended to use a Call to PLOTCLIP rather than
C             direct calls to PLOTLINE.  This will prevent lines from being
C             drawn off of a "window".
C
C-
      Subroutine plotline(x1,y1,x2,y2,incr)
C
      If (incr.EQ.0) Then
         call plot(x1,y1,+3)
         call plot(x2,y2,+2)
      Else
         iflag = 1
         If (incr.LT.0) iflag = 0
         del = abs(incr / 100.0)
         delx = x2 - x1
         dely = y2 - y1
         dist = sqrt(delx**2 + dely**2)
         ncount = int(dist / del)
         If (ncount.LE.0.AND.iflag.EQ.1) Then
            call plot(x1,y1,+3)
            call plot(x2,y2,+2)
         Else If (ncount.GE.1) Then
            test = dist - ncount * del
            idraw = 1
            If (test.GT.0.0.AND.test.LT.0.01) idraw = 0
            xadd = delx / ncount
            yadd = dely / ncount
            xp1 = x1
            yp1 = y1
            Do 10 i = 1,ncount
            xp2 = xp1 + xadd
            yp2 = yp1 + yadd
            iodd = mod((i+iflag),2)
            If (iodd.EQ.0) Then
               call plot(xp1,yp1,+3)
               call plot(xp2,yp2,+2)
            End If
            xp1 = xp2
            yp1 = yp2
10          Continue
            If (iodd.EQ.1.AND.idraw.EQ.1) Then
               call plot(xp2,yp2,+3)
               call plot(x2,y2,+2)
            End If
         End If
      End If
C
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C  clipper - Clips the line segment (x1,y1),(x2,y2) passed to it
C            to fit in the window defined by the x,y:
C
C               xleft<x<xright
C               ybot<y<ytop
C
C         Clipper assumes that the line segment passed to it does
C         indeed cross the given window; use tstend to determine
C         whether a line segment does indeed cross window.
C-
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine clipper(x,y,x1,y1,x2,y2,xleft,xright,ybot,ytop)
C
      delx=x2-x1
      dely=y2-y1
C
      If (abs(dely).LT.1.e-16)dely=sign(1.e-16,dely)
      If (abs(delx).LT.1.e-16)delx=sign(1.e-16,delx)
C
      slope=dely/delx
      b=y2-slope*x2
C
C - Clip along top or bottom edges.
C
      x=x1
      If (y1.GT.ytop) Then
         x=(ytop-b)/slope
         y=ytop
      Else If (y1.LT.ybot) Then
         x=(ybot-b)/slope
         y=ybot
      End If
c
c - Clip along left or right edges.
c
      If (x.GT.xright) Then
         x=xright
         y=slope*xright+b
      Else If (x.LT.xleft) Then
         x=xleft
         y=slope*xleft+b
      End If
C
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C  tstend - TeST END - Tests the endpoints of the line (x1,y1),
C           (x2,y2) for mapping onto region 0000 (See "Principles
C           of Interactive Computer Graphics", by Newman and
C           Sproull, figure 5-5, page 66.)
C
C           Region 0000 is defined as any x,y:
C              xleft < x < xright
C              ybot  < y < ytop
C
C             inout = Value describing properties of pair
C                 3 = Both points in region 0000
C                 2 = point (x2,y2) within region 0000, (x1,y1) outside
C                 1 = point (x1,y1) within region 0000, (x2,y2) outside
C                 0 = line segment crosses region 0000 (endpoints
C                     are outside)
C                -1 = line segment is entirely off screen
C
C-
      Subroutine tstend(inout,x1,y1,x2,y2,xleft,xright,ybot,ytop)
C
      If (x1.GT.x2) Then
         xmn = x2
         xmx = x1
      Else
         xmn = x1
         xmx = x2
      End If
C
      If (y1.GT.y2) Then
         ymn = y2
         ymx = y1
      Else
         ymn = y1
         ymx = y2
      End If
C
      If (xleft.GT.xright) Then
         xl = xright
         xr = xleft
      Else
         xr = xright
         xl = xleft
      End If
C
      If (ybot.GT.ytop) Then
         yb = ytop
         yt = ybot
      Else
         yt = ytop
         yb = ybot
      End If
C
C - Take care of the easy cases when both points are inside or both ponts
C   outside of the region.
C
      If (xmx.LE.xr.AND.xmn.GE.xl.AND.ymx.LE.yt.AND.ymn.GE.yb) Then
         inout = 3
         Return
      Else
         If ((xmx.LT.xl.OR.xmn.GT.xr).OR.
     &       (ymx.LT.yb.OR.ymn.GT.yt)) Then
            inout = -1
            Return
         End If
      End If
C
      Call fndcde(ione4,ione3,ione2,ione1,x1,y1,xl,xr,yb,yt)
      Call fndcde(itwo4,itwo3,itwo2,itwo1,x2,y2,xl,xr,yb,yt)
C
      nsum1 = ione4 + ione3 + ione2 + ione1
      nsum2 = itwo4 + itwo3 + itwo2 + itwo1
C
      If (nsum1.EQ.0.AND.nsum2.EQ.0) Then
         inout = 3
      Else If (nsum1.EQ.0) Then
         inout = 1
      Else If (nsum2.EQ.0) Then
         inout = 2
      Else
         inout = -1
         If ((ione4.EQ.1.AND.itwo4.EQ.1).OR.
     &       (ione3.EQ.1.AND.itwo3.EQ.1).OR.
     &       (ione2.EQ.1.AND.itwo2.EQ.1).OR.
     &       (ione1.EQ.1.AND.itwo1.EQ.1)) Return
C
         delx = x2 - x1
         dely = y2 - y1
         If (abs(delx).LT.1.e-18) delx = sign(1.e-18,delx)
         If (abs(dely).LT.1.e-18) dely = sign(1.e-18,dely)
C
         slope = dely / delx
         b = y2 - slope * x2
C
         ytest = slope * xl + b
         If (ytest.LT.yb.OR.ytest.GT.yt) Go To 10
         inout = 0
         Return
   10    Continue
C
         ytest = slope * xr + b
         If (ytest.LT.yb.OR.ytest.GT.yt) Go To 20
         inout = 0
         Return
   20    Continue
C
         xtest = (yb - b) / slope
         If (xtest.LT.xl.OR.xtest.GT.xr) Go To 30
         inout = 0
         Return
   30    Continue
C
         xtest = (yt - b) / slope
         If (xtest.LT.xl.OR.xtest.GT.xr) Go To 40
         inout = 0
   40    Continue
      End If
C
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C  fndcde - FiND CoDE - Returns the code for the region, ex-
C           pressed as ibit4,ibit3,ibit2,ibit1, of the screen
C           location (x,y).  See Figure 5-5, p.66, "Principles
C           of Interactive Computer Graphics", by Newman and
C           Sproull, 1979.
C
C           ibit1 = 1, if x < xleft
C           ibit2 = 1, if x > xright
C           ibit3 = 1, if y < ybot
C           ibit4 = 1, if y > ytop
C
C-
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine fndcde(ibit4,ibit3,ibit2,ibit1,x,y,xleft,xright,
     &ybot,ytop)
C
      ibit4=0
      ibit3=0
      ibit2=0
      ibit1=0
C
      If (x.LT.xleft) Then
         ibit1=1
      Else If (x.GT.xright) Then
         ibit2=1
      End If
C
      If (y.LT.ybot) Then
         ibit3=1
      Else If (y.GT.ytop) Then
         ibit4=1
      End If
C
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Block Data AFMBD
C
C AFMBD - Device font metrics for PostScript Viewer.
C
C         Created by Parse_AFM_File at 19-MAR-1992 16:59:28.20.
C
C         Font: Helvetica
C         File: PUB1:[BAKER.GRAPHICS.VIEWER.DEVICES]HELVETICA.AFM;1           
C
      Real       fm(6,0:255)
      Integer    nfname
      Character  fname*80
      Common /AFMCM1/  nfname, fm
      Common /AFMCM2/  fname
      Save   /AFMCM1/, /AFMCM2/
      Data       nfname/ 9/
      Data       fname/'Helvetica'/
*StartFontMetrics 2.0
*Comment Copyright (c) 1984 Adobe Systems Incorporated. 	All Rights Reserved.
*Comment Creation Date:Tue Aug 5 11:33:55 PDT 1986
*FontName Helvetica
*EncodingScheme AdobeStandardEncoding
*FullName Helvetica
*FamilyName Helvetica
*Weight Medium
*ItalicAngle 0.0
*IsFixedPitch false
*UnderlinePosition -97
*UnderlineThickness 73
*Version 001.001
*Notice Helvetica is a registered trademark of Allied Corporation.
*FontBBox -174 -220 1001 944
*CapHeight 729
*XHeight 525
*Descender -219
*Ascender 729
*StartCharMetrics 228
      Data (fm(i,  0),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  1),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  2),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  3),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  4),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  5),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  6),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  7),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  8),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,  9),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 10),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 11),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 12),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 13),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 14),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 15),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 16),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 17),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 18),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 19),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 20),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 21),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 22),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 23),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 24),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 25),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 26),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 27),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 28),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 29),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 30),i=1,6) /0,0,0,0,0,0/
      Data (fm(i, 31),i=1,6) /0,0,0,0,0,0/
*C 32 ; WX 278 ; N space ; B 0 0 0 0 ;
      Data (fm(i, 32),i=1,6) /278E-3,0,0E-3,0E-3,0E-3,0E-3/
*C 33 ; WX 278 ; N exclam ; B 124 0 208 729 ;
      Data (fm(i, 33),i=1,6) /278E-3,0,124E-3,0E-3,208E-3,729E-3/
*C 34 ; WX 355 ; N quotedbl ; B 52 462 305 708 ;
      Data (fm(i, 34),i=1,6) /355E-3,0,52E-3,462E-3,305E-3,708E-3/
*C 35 ; WX 556 ; N numbersign ; B 14 -20 542 698 ;
      Data (fm(i, 35),i=1,6) /556E-3,0,14E-3,-20E-3,542E-3,698E-3/
*C 36 ; WX 556 ; N dollar ; B 33 -125 518 770 ;
      Data (fm(i, 36),i=1,6) /556E-3,0,33E-3,-125E-3,518E-3,770E-3/
*C 37 ; WX 889 ; N percent ; B 29 -20 859 708 ;
      Data (fm(i, 37),i=1,6) /889E-3,0,29E-3,-20E-3,859E-3,708E-3/
*C 38 ; WX 667 ; N ampersand ; B 52 -23 637 710 ;
      Data (fm(i, 38),i=1,6) /667E-3,0,52E-3,-23E-3,637E-3,710E-3/
*C 39 ; WX 222 ; N quoteright ; B 64 476 158 708 ;
      Data (fm(i, 39),i=1,6) /222E-3,0,64E-3,476E-3,158E-3,708E-3/
*C 40 ; WX 333 ; N parenleft ; B 73 -213 291 729 ;
      Data (fm(i, 40),i=1,6) /333E-3,0,73E-3,-213E-3,291E-3,729E-3/
*C 41 ; WX 333 ; N parenright ; B 38 -213 256 729 ;
      Data (fm(i, 41),i=1,6) /333E-3,0,38E-3,-213E-3,256E-3,729E-3/
*C 42 ; WX 389 ; N asterisk ; B 40 452 343 740 ;
      Data (fm(i, 42),i=1,6) /389E-3,0,40E-3,452E-3,343E-3,740E-3/
*C 43 ; WX 584 ; N plus ; B 50 -10 534 474 ;
      Data (fm(i, 43),i=1,6) /584E-3,0,50E-3,-10E-3,534E-3,474E-3/
*C 44 ; WX 278 ; N comma ; B 87 -150 192 104 ;
      Data (fm(i, 44),i=1,6) /278E-3,0,87E-3,-150E-3,192E-3,104E-3/
*C 45 ; WX 333 ; N hyphen ; B 46 240 284 313 ;
      Data (fm(i, 45),i=1,6) /333E-3,0,46E-3,240E-3,284E-3,313E-3/
*C 46 ; WX 278 ; N period ; B 87 0 191 104 ;
      Data (fm(i, 46),i=1,6) /278E-3,0,87E-3,0E-3,191E-3,104E-3/
*C 47 ; WX 278 ; N slash ; B -8 -21 284 708 ;
      Data (fm(i, 47),i=1,6) /278E-3,0,-8E-3,-21E-3,284E-3,708E-3/
*C 48 ; WX 556 ; N zero ; B 43 -23 507 709 ;
      Data (fm(i, 48),i=1,6) /556E-3,0,43E-3,-23E-3,507E-3,709E-3/
*C 49 ; WX 556 ; N one ; B 102 0 347 709 ;
      Data (fm(i, 49),i=1,6) /556E-3,0,102E-3,0E-3,347E-3,709E-3/
*C 50 ; WX 556 ; N two ; B 34 0 511 710 ;
      Data (fm(i, 50),i=1,6) /556E-3,0,34E-3,0E-3,511E-3,710E-3/
*C 51 ; WX 556 ; N three ; B 32 -23 506 709 ;
      Data (fm(i, 51),i=1,6) /556E-3,0,32E-3,-23E-3,506E-3,709E-3/
*C 52 ; WX 556 ; N four ; B 28 0 520 709 ;
      Data (fm(i, 52),i=1,6) /556E-3,0,28E-3,0E-3,520E-3,709E-3/
*C 53 ; WX 556 ; N five ; B 35 -23 513 709 ;
      Data (fm(i, 53),i=1,6) /556E-3,0,35E-3,-23E-3,513E-3,709E-3/
*C 54 ; WX 556 ; N six ; B 43 -23 513 709 ;
      Data (fm(i, 54),i=1,6) /556E-3,0,43E-3,-23E-3,513E-3,709E-3/
*C 55 ; WX 556 ; N seven ; B 46 0 520 709 ;
      Data (fm(i, 55),i=1,6) /556E-3,0,46E-3,0E-3,520E-3,709E-3/
*C 56 ; WX 556 ; N eight ; B 37 -23 513 709 ;
      Data (fm(i, 56),i=1,6) /556E-3,0,37E-3,-23E-3,513E-3,709E-3/
*C 57 ; WX 556 ; N nine ; B 38 -23 509 709 ;
      Data (fm(i, 57),i=1,6) /556E-3,0,38E-3,-23E-3,509E-3,709E-3/
*C 58 ; WX 278 ; N colon ; B 110 0 214 525 ;
      Data (fm(i, 58),i=1,6) /278E-3,0,110E-3,0E-3,214E-3,525E-3/
*C 59 ; WX 278 ; N semicolon ; B 110 -150 215 516 ;
      Data (fm(i, 59),i=1,6) /278E-3,0,110E-3,-150E-3,215E-3,516E-3/
*C 60 ; WX 584 ; N less ; B 45 -10 534 474 ;
      Data (fm(i, 60),i=1,6) /584E-3,0,45E-3,-10E-3,534E-3,474E-3/
*C 61 ; WX 584 ; N equal ; B 50 112 534 352 ;
      Data (fm(i, 61),i=1,6) /584E-3,0,50E-3,112E-3,534E-3,352E-3/
*C 62 ; WX 584 ; N greater ; B 50 -10 539 474 ;
      Data (fm(i, 62),i=1,6) /584E-3,0,50E-3,-10E-3,539E-3,474E-3/
*C 63 ; WX 556 ; N question ; B 77 0 509 738 ;
      Data (fm(i, 63),i=1,6) /556E-3,0,77E-3,0E-3,509E-3,738E-3/
*C 64 ; WX 1015 ; N at ; B 34 -146 951 737 ;
      Data (fm(i, 64),i=1,6) /1015E-3,0,34E-3,-146E-3,951E-3,737E-3/
*C 65 ; WX 667 ; N A ; B 17 0 653 729 ;
      Data (fm(i, 65),i=1,6) /667E-3,0,17E-3,0E-3,653E-3,729E-3/
*C 66 ; WX 667 ; N B ; B 79 0 623 729 ;
      Data (fm(i, 66),i=1,6) /667E-3,0,79E-3,0E-3,623E-3,729E-3/
*C 67 ; WX 722 ; N C ; B 48 -23 677 741 ;
      Data (fm(i, 67),i=1,6) /722E-3,0,48E-3,-23E-3,677E-3,741E-3/
*C 68 ; WX 722 ; N D ; B 89 0 667 729 ;
      Data (fm(i, 68),i=1,6) /722E-3,0,89E-3,0E-3,667E-3,729E-3/
*C 69 ; WX 667 ; N E ; B 90 0 613 729 ;
      Data (fm(i, 69),i=1,6) /667E-3,0,90E-3,0E-3,613E-3,729E-3/
*C 70 ; WX 611 ; N F ; B 90 0 579 729 ;
      Data (fm(i, 70),i=1,6) /611E-3,0,90E-3,0E-3,579E-3,729E-3/
*C 71 ; WX 778 ; N G ; B 44 -23 709 741 ;
      Data (fm(i, 71),i=1,6) /778E-3,0,44E-3,-23E-3,709E-3,741E-3/
*C 72 ; WX 722 ; N H ; B 83 0 644 729 ;
      Data (fm(i, 72),i=1,6) /722E-3,0,83E-3,0E-3,644E-3,729E-3/
*C 73 ; WX 278 ; N I ; B 100 0 194 729 ;
      Data (fm(i, 73),i=1,6) /278E-3,0,100E-3,0E-3,194E-3,729E-3/
*C 74 ; WX 500 ; N J ; B 17 -26 426 729 ;
      Data (fm(i, 74),i=1,6) /500E-3,0,17E-3,-26E-3,426E-3,729E-3/
*C 75 ; WX 667 ; N K ; B 79 0 658 729 ;
      Data (fm(i, 75),i=1,6) /667E-3,0,79E-3,0E-3,658E-3,729E-3/
*C 76 ; WX 556 ; N L ; B 80 0 533 729 ;
      Data (fm(i, 76),i=1,6) /556E-3,0,80E-3,0E-3,533E-3,729E-3/
*C 77 ; WX 833 ; N M ; B 75 0 761 729 ;
      Data (fm(i, 77),i=1,6) /833E-3,0,75E-3,0E-3,761E-3,729E-3/
*C 78 ; WX 722 ; N N ; B 76 0 646 729 ;
      Data (fm(i, 78),i=1,6) /722E-3,0,76E-3,0E-3,646E-3,729E-3/
*C 79 ; WX 778 ; N O ; B 38 -23 742 741 ;
      Data (fm(i, 79),i=1,6) /778E-3,0,38E-3,-23E-3,742E-3,741E-3/
*C 80 ; WX 667 ; N P ; B 91 0 617 730 ;
      Data (fm(i, 80),i=1,6) /667E-3,0,91E-3,0E-3,617E-3,730E-3/
*C 81 ; WX 778 ; N Q ; B 38 -59 742 741 ;
      Data (fm(i, 81),i=1,6) /778E-3,0,38E-3,-59E-3,742E-3,741E-3/
*C 82 ; WX 722 ; N R ; B 93 0 679 729 ;
      Data (fm(i, 82),i=1,6) /722E-3,0,93E-3,0E-3,679E-3,729E-3/
*C 83 ; WX 667 ; N S ; B 48 -23 621 741 ;
      Data (fm(i, 83),i=1,6) /667E-3,0,48E-3,-23E-3,621E-3,741E-3/
*C 84 ; WX 611 ; N T ; B 21 0 593 729 ;
      Data (fm(i, 84),i=1,6) /611E-3,0,21E-3,0E-3,593E-3,729E-3/
*C 85 ; WX 722 ; N U ; B 85 -23 645 729 ;
      Data (fm(i, 85),i=1,6) /722E-3,0,85E-3,-23E-3,645E-3,729E-3/
*C 86 ; WX 667 ; N V ; B 30 0 645 729 ;
      Data (fm(i, 86),i=1,6) /667E-3,0,30E-3,0E-3,645E-3,729E-3/
*C 87 ; WX 944 ; N W ; B 22 0 929 729 ;
      Data (fm(i, 87),i=1,6) /944E-3,0,22E-3,0E-3,929E-3,729E-3/
*C 88 ; WX 667 ; N X ; B 22 0 649 729 ;
      Data (fm(i, 88),i=1,6) /667E-3,0,22E-3,0E-3,649E-3,729E-3/
*C 89 ; WX 667 ; N Y ; B 13 0 661 729 ;
      Data (fm(i, 89),i=1,6) /667E-3,0,13E-3,0E-3,661E-3,729E-3/
*C 90 ; WX 611 ; N Z ; B 28 0 583 729 ;
      Data (fm(i, 90),i=1,6) /611E-3,0,28E-3,0E-3,583E-3,729E-3/
*C 91 ; WX 278 ; N bracketleft ; B 64 -214 250 729 ;
      Data (fm(i, 91),i=1,6) /278E-3,0,64E-3,-214E-3,250E-3,729E-3/
*C 92 ; WX 278 ; N backslash ; B -8 -20 284 729 ;
      Data (fm(i, 92),i=1,6) /278E-3,0,-8E-3,-20E-3,284E-3,729E-3/
*C 93 ; WX 278 ; N bracketright ; B 23 -215 209 729 ;
      Data (fm(i, 93),i=1,6) /278E-3,0,23E-3,-215E-3,209E-3,729E-3/
*C 94 ; WX 469 ; N asciicircum ; B 44 333 425 713 ;
      Data (fm(i, 94),i=1,6) /469E-3,0,44E-3,333E-3,425E-3,713E-3/
*C 95 ; WX 556 ; N underscore ; B -22 -175 578 -125 ;
      Data (fm(i, 95),i=1,6) /556E-3,0,-22E-3,-175E-3,578E-3,-125E-3/
*C 96 ; WX 222 ; N quoteleft ; B 65 459 158 708 ;
      Data (fm(i, 96),i=1,6) /222E-3,0,65E-3,459E-3,158E-3,708E-3/
*C 97 ; WX 556 ; N a ; B 42 -23 535 540 ;
      Data (fm(i, 97),i=1,6) /556E-3,0,42E-3,-23E-3,535E-3,540E-3/
*C 98 ; WX 556 ; N b ; B 54 -23 523 729 ;
      Data (fm(i, 98),i=1,6) /556E-3,0,54E-3,-23E-3,523E-3,729E-3/
*C 99 ; WX 500 ; N c ; B 31 -23 477 540 ;
      Data (fm(i, 99),i=1,6) /500E-3,0,31E-3,-23E-3,477E-3,540E-3/
*C 100 ; WX 556 ; N d ; B 26 -23 495 729 ;
      Data (fm(i,100),i=1,6) /556E-3,0,26E-3,-23E-3,495E-3,729E-3/
*C 101 ; WX 556 ; N e ; B 40 -23 513 541 ;
      Data (fm(i,101),i=1,6) /556E-3,0,40E-3,-23E-3,513E-3,541E-3/
*C 102 ; WX 278 ; N f ; B 18 0 258 733 ; L i fi ; L l fl ;
      Data (fm(i,102),i=1,6) /278E-3,0,18E-3,0E-3,258E-3,733E-3/
*C 103 ; WX 556 ; N g ; B 29 -220 489 540 ;
      Data (fm(i,103),i=1,6) /556E-3,0,29E-3,-220E-3,489E-3,540E-3/
*C 104 ; WX 556 ; N h ; B 70 0 486 729 ;
      Data (fm(i,104),i=1,6) /556E-3,0,70E-3,0E-3,486E-3,729E-3/
*C 105 ; WX 222 ; N i ; B 66 0 150 729 ;
      Data (fm(i,105),i=1,6) /222E-3,0,66E-3,0E-3,150E-3,729E-3/
*C 106 ; WX 222 ; N j ; B -18 -220 153 729 ;
      Data (fm(i,106),i=1,6) /222E-3,0,-18E-3,-220E-3,153E-3,729E-3/
*C 107 ; WX 500 ; N k ; B 58 0 502 729 ;
      Data (fm(i,107),i=1,6) /500E-3,0,58E-3,0E-3,502E-3,729E-3/
*C 108 ; WX 222 ; N l ; B 68 0 152 729 ;
      Data (fm(i,108),i=1,6) /222E-3,0,68E-3,0E-3,152E-3,729E-3/
*C 109 ; WX 833 ; N m ; B 71 0 763 540 ;
      Data (fm(i,109),i=1,6) /833E-3,0,71E-3,0E-3,763E-3,540E-3/
*C 110 ; WX 556 ; N n ; B 70 0 487 540 ;
      Data (fm(i,110),i=1,6) /556E-3,0,70E-3,0E-3,487E-3,540E-3/
*C 111 ; WX 556 ; N o ; B 36 -23 510 540 ;
      Data (fm(i,111),i=1,6) /556E-3,0,36E-3,-23E-3,510E-3,540E-3/
*C 112 ; WX 556 ; N p ; B 54 -219 523 540 ;
      Data (fm(i,112),i=1,6) /556E-3,0,54E-3,-219E-3,523E-3,540E-3/
*C 113 ; WX 556 ; N q ; B 26 -219 495 540 ;
      Data (fm(i,113),i=1,6) /556E-3,0,26E-3,-219E-3,495E-3,540E-3/
*C 114 ; WX 333 ; N r ; B 69 0 321 540 ;
      Data (fm(i,114),i=1,6) /333E-3,0,69E-3,0E-3,321E-3,540E-3/
*C 115 ; WX 500 ; N s ; B 34 -24 459 540 ;
      Data (fm(i,115),i=1,6) /500E-3,0,34E-3,-24E-3,459E-3,540E-3/
*C 116 ; WX 278 ; N t ; B 14 -24 254 667 ;
      Data (fm(i,116),i=1,6) /278E-3,0,14E-3,-24E-3,254E-3,667E-3/
*C 117 ; WX 556 ; N u ; B 65 -23 482 525 ;
      Data (fm(i,117),i=1,6) /556E-3,0,65E-3,-23E-3,482E-3,525E-3/
*C 118 ; WX 500 ; N v ; B 10 0 486 525 ;
      Data (fm(i,118),i=1,6) /500E-3,0,10E-3,0E-3,486E-3,525E-3/
*C 119 ; WX 722 ; N w ; B 6 0 708 525 ;
      Data (fm(i,119),i=1,6) /722E-3,0,6E-3,0E-3,708E-3,525E-3/
*C 120 ; WX 500 ; N x ; B 17 0 473 525 ;
      Data (fm(i,120),i=1,6) /500E-3,0,17E-3,0E-3,473E-3,525E-3/
*C 121 ; WX 500 ; N y ; B 20 -219 478 525 ;
      Data (fm(i,121),i=1,6) /500E-3,0,20E-3,-219E-3,478E-3,525E-3/
*C 122 ; WX 500 ; N z ; B 31 0 457 525 ;
      Data (fm(i,122),i=1,6) /500E-3,0,31E-3,0E-3,457E-3,525E-3/
*C 123 ; WX 334 ; N braceleft ; B 43 -214 276 731 ;
      Data (fm(i,123),i=1,6) /334E-3,0,43E-3,-214E-3,276E-3,731E-3/
*C 124 ; WX 260 ; N bar ; B 100 -215 160 729 ;
      Data (fm(i,124),i=1,6) /260E-3,0,100E-3,-215E-3,160E-3,729E-3/
*C 125 ; WX 334 ; N braceright ; B 29 -214 262 731 ;
      Data (fm(i,125),i=1,6) /334E-3,0,29E-3,-214E-3,262E-3,731E-3/
*C 126 ; WX 584 ; N asciitilde ; B 75 267 508 438 ;
      Data (fm(i,126),i=1,6) /584E-3,0,75E-3,267E-3,508E-3,438E-3/
      Data (fm(i,127),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,128),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,129),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,130),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,131),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,132),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,133),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,134),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,135),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,136),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,137),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,138),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,139),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,140),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,141),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,142),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,143),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,144),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,145),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,146),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,147),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,148),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,149),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,150),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,151),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,152),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,153),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,154),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,155),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,156),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,157),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,158),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,159),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,160),i=1,6) /0,0,0,0,0,0/
*C 161 ; WX 333 ; N exclamdown ; B 121 -214 205 525 ;
      Data (fm(i,161),i=1,6) /333E-3,0,121E-3,-214E-3,205E-3,525E-3/
*C 162 ; WX 556 ; N cent ; B 52 -120 510 628 ;
      Data (fm(i,162),i=1,6) /556E-3,0,52E-3,-120E-3,510E-3,628E-3/
*C 163 ; WX 556 ; N sterling ; B 26 -21 535 726 ;
      Data (fm(i,163),i=1,6) /556E-3,0,26E-3,-21E-3,535E-3,726E-3/
*C 164 ; WX 167 ; N fraction ; B -174 -21 336 708 ;
      Data (fm(i,164),i=1,6) /167E-3,0,-174E-3,-21E-3,336E-3,708E-3/
*C 165 ; WX 556 ; N yen ; B 11 0 545 710 ;
      Data (fm(i,165),i=1,6) /556E-3,0,11E-3,0E-3,545E-3,710E-3/
*C 166 ; WX 556 ; N florin ; B 11 -214 542 742 ;
      Data (fm(i,166),i=1,6) /556E-3,0,11E-3,-214E-3,542E-3,742E-3/
*C 167 ; WX 556 ; N section ; B 44 -215 506 729 ;
      Data (fm(i,167),i=1,6) /556E-3,0,44E-3,-215E-3,506E-3,729E-3/
*C 168 ; WX 556 ; N currency ; B 67 126 489 554 ;
      Data (fm(i,168),i=1,6) /556E-3,0,67E-3,126E-3,489E-3,554E-3/
*C 169 ; WX 191 ; N quotesingle ; B 48 462 142 708 ;
      Data (fm(i,169),i=1,6) /191E-3,0,48E-3,462E-3,142E-3,708E-3/
*C 170 ; WX 333 ; N quotedblleft ; B 48 459 299 708 ;
      Data (fm(i,170),i=1,6) /333E-3,0,48E-3,459E-3,299E-3,708E-3/
*C 171 ; WX 556 ; N guillemotleft ; B 98 106 455 438 ;
      Data (fm(i,171),i=1,6) /556E-3,0,98E-3,106E-3,455E-3,438E-3/
*C 172 ; WX 333 ; N guilsinglleft ; B 91 112 243 436 ;
      Data (fm(i,172),i=1,6) /333E-3,0,91E-3,112E-3,243E-3,436E-3/
*C 173 ; WX 333 ; N guilsinglright ; B 85 112 239 436 ;
      Data (fm(i,173),i=1,6) /333E-3,0,85E-3,112E-3,239E-3,436E-3/
*C 174 ; WX 500 ; N fi ; B 12 0 436 733 ;
      Data (fm(i,174),i=1,6) /500E-3,0,12E-3,0E-3,436E-3,733E-3/
*C 175 ; WX 500 ; N fl ; B 17 0 430 733 ;
      Data (fm(i,175),i=1,6) /500E-3,0,17E-3,0E-3,430E-3,733E-3/
      Data (fm(i,176),i=1,6) /0,0,0,0,0,0/
*C 177 ; WX 556 ; N endash ; B -5 240 561 313 ;
      Data (fm(i,177),i=1,6) /556E-3,0,-5E-3,240E-3,561E-3,313E-3/
*C 178 ; WX 556 ; N dagger ; B 38 -178 513 710 ;
      Data (fm(i,178),i=1,6) /556E-3,0,38E-3,-178E-3,513E-3,710E-3/
*C 179 ; WX 556 ; N daggerdbl ; B 38 -178 513 710 ;
      Data (fm(i,179),i=1,6) /556E-3,0,38E-3,-178E-3,513E-3,710E-3/
*C 180 ; WX 278 ; N periodcentered ; B 87 318 211 442 ;
      Data (fm(i,180),i=1,6) /278E-3,0,87E-3,318E-3,211E-3,442E-3/
      Data (fm(i,181),i=1,6) /0,0,0,0,0,0/
*C 182 ; WX 537 ; N paragraph ; B 48 -178 522 729 ;
      Data (fm(i,182),i=1,6) /537E-3,0,48E-3,-178E-3,522E-3,729E-3/
*C 183 ; WX 350 ; N bullet ; B 50 220 300 470 ;
      Data (fm(i,183),i=1,6) /350E-3,0,50E-3,220E-3,300E-3,470E-3/
*C 184 ; WX 222 ; N quotesinglbase ; B 64 -129 158 103 ;
      Data (fm(i,184),i=1,6) /222E-3,0,64E-3,-129E-3,158E-3,103E-3/
*C 185 ; WX 333 ; N quotedblbase ; B 47 -129 300 103 ;
      Data (fm(i,185),i=1,6) /333E-3,0,47E-3,-129E-3,300E-3,103E-3/
*C 186 ; WX 333 ; N quotedblright ; B 49 476 302 708 ;
      Data (fm(i,186),i=1,6) /333E-3,0,49E-3,476E-3,302E-3,708E-3/
*C 187 ; WX 556 ; N guillemotright ; B 98 106 451 438 ;
      Data (fm(i,187),i=1,6) /556E-3,0,98E-3,106E-3,451E-3,438E-3/
*C 188 ; WX 1000 ; N ellipsis ; B 115 0 885 104 ;
      Data (fm(i,188),i=1,6) /1000E-3,0,115E-3,0E-3,885E-3,104E-3/
*C 189 ; WX 1000 ; N perthousand ; B 9 -20 993 740 ;
      Data (fm(i,189),i=1,6) /1000E-3,0,9E-3,-20E-3,993E-3,740E-3/
      Data (fm(i,190),i=1,6) /0,0,0,0,0,0/
*C 191 ; WX 611 ; N questiondown ; B 95 -213 528 525 ;
      Data (fm(i,191),i=1,6) /611E-3,0,95E-3,-213E-3,528E-3,525E-3/
      Data (fm(i,192),i=1,6) /0,0,0,0,0,0/
*C 193 ; WX 333 ; N grave ; B 22 592 231 740 ;
      Data (fm(i,193),i=1,6) /333E-3,0,22E-3,592E-3,231E-3,740E-3/
*C 194 ; WX 333 ; N acute ; B 92 592 301 740 ;
      Data (fm(i,194),i=1,6) /333E-3,0,92E-3,592E-3,301E-3,740E-3/
*C 195 ; WX 333 ; N circumflex ; B 20 591 307 741 ;
      Data (fm(i,195),i=1,6) /333E-3,0,20E-3,591E-3,307E-3,741E-3/
*C 196 ; WX 333 ; N tilde ; B 5 589 319 716 ;
      Data (fm(i,196),i=1,6) /333E-3,0,5E-3,589E-3,319E-3,716E-3/
*C 197 ; WX 333 ; N macron ; B 28 621 302 694 ;
      Data (fm(i,197),i=1,6) /333E-3,0,28E-3,621E-3,302E-3,694E-3/
*C 198 ; WX 333 ; N breve ; B 15 594 316 729 ;
      Data (fm(i,198),i=1,6) /333E-3,0,15E-3,594E-3,316E-3,729E-3/
*C 199 ; WX 333 ; N dotaccent ; B 115 605 219 709 ;
      Data (fm(i,199),i=1,6) /333E-3,0,115E-3,605E-3,219E-3,709E-3/
*C 200 ; WX 333 ; N dieresis ; B 30 605 296 708 ;
      Data (fm(i,200),i=1,6) /333E-3,0,30E-3,605E-3,296E-3,708E-3/
      Data (fm(i,201),i=1,6) /0,0,0,0,0,0/
*C 202 ; WX 333 ; N ring ; B 79 566 255 741 ;
      Data (fm(i,202),i=1,6) /333E-3,0,79E-3,566E-3,255E-3,741E-3/
*C 203 ; WX 333 ; N cedilla ; B 39 -214 287 0 ;
      Data (fm(i,203),i=1,6) /333E-3,0,39E-3,-214E-3,287E-3,0E-3/
      Data (fm(i,204),i=1,6) /0,0,0,0,0,0/
*C 205 ; WX 333 ; N hungarumlaut ; B -35 592 348 740 ;
      Data (fm(i,205),i=1,6) /333E-3,0,-35E-3,592E-3,348E-3,740E-3/
*C 206 ; WX 333 ; N ogonek ; B 57 -189 265 15 ;
      Data (fm(i,206),i=1,6) /333E-3,0,57E-3,-189E-3,265E-3,15E-3/
*C 207 ; WX 333 ; N caron ; B 19 590 306 740 ;
      Data (fm(i,207),i=1,6) /333E-3,0,19E-3,590E-3,306E-3,740E-3/
*C 208 ; WX 1000 ; N emdash ; B -9 240 1001 313 ;
      Data (fm(i,208),i=1,6) /1000E-3,0,-9E-3,240E-3,1001E-3,313E-3/
      Data (fm(i,209),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,210),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,211),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,212),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,213),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,214),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,215),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,216),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,217),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,218),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,219),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,220),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,221),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,222),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,223),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,224),i=1,6) /0,0,0,0,0,0/
*C 225 ; WX 1000 ; N AE ; B 11 0 950 729 ;
      Data (fm(i,225),i=1,6) /1000E-3,0,11E-3,0E-3,950E-3,729E-3/
      Data (fm(i,226),i=1,6) /0,0,0,0,0,0/
*C 227 ; WX 370 ; N ordfeminine ; B 37 301 333 740 ;
      Data (fm(i,227),i=1,6) /370E-3,0,37E-3,301E-3,333E-3,740E-3/
      Data (fm(i,228),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,229),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,230),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,231),i=1,6) /0,0,0,0,0,0/
*C 232 ; WX 556 ; N Lslash ; B 0 0 552 729 ;
      Data (fm(i,232),i=1,6) /556E-3,0,0E-3,0E-3,552E-3,729E-3/
*C 233 ; WX 778 ; N Oslash ; B 30 -23 744 742 ;
      Data (fm(i,233),i=1,6) /778E-3,0,30E-3,-23E-3,744E-3,742E-3/
*C 234 ; WX 1000 ; N OE ; B 43 -20 959 739 ;
      Data (fm(i,234),i=1,6) /1000E-3,0,43E-3,-20E-3,959E-3,739E-3/
*C 235 ; WX 365 ; N ordmasculine ; B 40 301 324 741 ;
      Data (fm(i,235),i=1,6) /365E-3,0,40E-3,301E-3,324E-3,741E-3/
      Data (fm(i,236),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,237),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,238),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,239),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,240),i=1,6) /0,0,0,0,0,0/
*C 241 ; WX 889 ; N ae ; B 34 -20 845 546 ;
      Data (fm(i,241),i=1,6) /889E-3,0,34E-3,-20E-3,845E-3,546E-3/
      Data (fm(i,242),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,243),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,244),i=1,6) /0,0,0,0,0,0/
*C 245 ; WX 278 ; N dotlessi ; B 94 0 178 525 ;
      Data (fm(i,245),i=1,6) /278E-3,0,94E-3,0E-3,178E-3,525E-3/
      Data (fm(i,246),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,247),i=1,6) /0,0,0,0,0,0/
*C 248 ; WX 222 ; N lslash ; B 0 0 212 729 ;
      Data (fm(i,248),i=1,6) /222E-3,0,0E-3,0E-3,212E-3,729E-3/
*C 249 ; WX 611 ; N oslash ; B 18 -27 529 548 ;
      Data (fm(i,249),i=1,6) /611E-3,0,18E-3,-27E-3,529E-3,548E-3/
*C 250 ; WX 944 ; N oe ; B 40 -22 899 540 ;
      Data (fm(i,250),i=1,6) /944E-3,0,40E-3,-22E-3,899E-3,540E-3/
*C 251 ; WX 611 ; N germandbls ; B 126 -20 566 729 ;
      Data (fm(i,251),i=1,6) /611E-3,0,126E-3,-20E-3,566E-3,729E-3/
      Data (fm(i,252),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,253),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,254),i=1,6) /0,0,0,0,0,0/
      Data (fm(i,255),i=1,6) /0,0,0,0,0,0/
*C -1 ; WX 667 ; N Aacute ; B 17 0 653 939 ;
*C -1 ; WX 667 ; N Acircumflex ; B 17 0 653 940 ;
*C -1 ; WX 667 ; N Adieresis ; B 17 0 653 907 ;
*C -1 ; WX 667 ; N Agrave ; B 17 0 653 939 ;
*C -1 ; WX 667 ; N Aring ; B 17 0 653 940 ;
*C -1 ; WX 667 ; N Atilde ; B 17 0 653 915 ;
*C -1 ; WX 722 ; N Ccedilla ; B 48 -214 677 741 ;
*C -1 ; WX 667 ; N Eacute ; B 90 0 613 939 ;
*C -1 ; WX 667 ; N Ecircumflex ; B 90 0 613 940 ;
*C -1 ; WX 667 ; N Edieresis ; B 90 0 613 907 ;
*C -1 ; WX 667 ; N Egrave ; B 90 0 613 939 ;
*C -1 ; WX 722 ; N Eth ; B 0 0 667 729 ;
*C -1 ; WX 278 ; N Iacute ; B 71 0 280 939 ;
*C -1 ; WX 278 ; N Icircumflex ; B -1 0 286 940 ;
*C -1 ; WX 278 ; N Idieresis ; B 9 0 275 907 ;
*C -1 ; WX 278 ; N Igrave ; B 1 0 210 939 ;
*C -1 ; WX 722 ; N Ntilde ; B 76 0 646 915 ;
*C -1 ; WX 778 ; N Oacute ; B 38 -23 742 939 ;
*C -1 ; WX 778 ; N Ocircumflex ; B 38 -23 742 940 ;
*C -1 ; WX 778 ; N Odieresis ; B 38 -23 742 907 ;
*C -1 ; WX 778 ; N Ograve ; B 38 -23 742 939 ;
*C -1 ; WX 778 ; N Otilde ; B 38 -23 742 915 ;
*C -1 ; WX 667 ; N Scaron ; B 48 -23 621 939 ;
*C -1 ; WX 667 ; N Thorn ; B 91 0 617 729 ;
*C -1 ; WX 722 ; N Uacute ; B 85 -23 645 939 ;
*C -1 ; WX 722 ; N Ucircumflex ; B 85 -23 645 940 ;
*C -1 ; WX 722 ; N Udieresis ; B 85 -23 645 907 ;
*C -1 ; WX 722 ; N Ugrave ; B 85 -23 645 939 ;
*C -1 ; WX 667 ; N Yacute ; B 13 0 661 944 ;
*C -1 ; WX 667 ; N Ydieresis ; B 13 0 661 907 ;
*C -1 ; WX 611 ; N Zcaron ; B 28 0 583 939 ;
*C -1 ; WX 556 ; N aacute ; B 42 -23 535 740 ;
*C -1 ; WX 556 ; N acircumflex ; B 42 -23 535 741 ;
*C -1 ; WX 556 ; N adieresis ; B 42 -23 535 708 ;
*C -1 ; WX 556 ; N agrave ; B 42 -23 535 740 ;
*C -1 ; WX 556 ; N aring ; B 42 -23 535 741 ;
*C -1 ; WX 556 ; N atilde ; B 42 -23 535 716 ;
*C -1 ; WX 260 ; N brokenbar ; B 100 -215 160 729 ;
*C -1 ; WX 500 ; N ccedilla ; B 31 -214 477 540 ;
*C -1 ; WX 737 ; N copyright ; B -13 -23 751 741 ;
*C -1 ; WX 400 ; N degree ; B 50 409 350 709 ;
*C -1 ; WX 584 ; N divide ; B 50 -10 534 474 ;
*C -1 ; WX 556 ; N eacute ; B 40 -23 513 740 ;
*C -1 ; WX 556 ; N ecircumflex ; B 40 -23 513 741 ;
*C -1 ; WX 556 ; N edieresis ; B 40 -23 513 708 ;
*C -1 ; WX 556 ; N egrave ; B 40 -23 513 740 ;
*C -1 ; WX 556 ; N eth ; B 36 -23 510 729 ;
*C -1 ; WX 278 ; N iacute ; B 65 0 274 740 ;
*C -1 ; WX 278 ; N icircumflex ; B -7 0 280 741 ;
*C -1 ; WX 278 ; N idieresis ; B 3 0 269 708 ;
*C -1 ; WX 278 ; N igrave ; B -5 0 204 740 ;
*C -1 ; WX 584 ; N logicalnot ; B 40 82 544 352 ;
*C -1 ; WX 584 ; N minus ; B 40 194 544 270 ;
*C -1 ; WX 556 ; N mu ; B 65 -219 482 525 ;
*C -1 ; WX 584 ; N multiply ; B 50 -10 534 476 ;
*C -1 ; WX 556 ; N ntilde ; B 70 0 487 716 ;
*C -1 ; WX 556 ; N oacute ; B 36 -23 510 740 ;
*C -1 ; WX 556 ; N ocircumflex ; B 36 -23 510 741 ;
*C -1 ; WX 556 ; N odieresis ; B 36 -23 510 708 ;
*C -1 ; WX 556 ; N ograve ; B 36 -23 510 740 ;
*C -1 ; WX 834 ; N onehalf ; B 30 -21 804 709 ;
*C -1 ; WX 834 ; N onequarter ; B 30 -21 804 709 ;
*C -1 ; WX 333 ; N onesuperior ; B 60 284 219 709 ;
*C -1 ; WX 556 ; N otilde ; B 36 -23 510 716 ;
*C -1 ; WX 584 ; N plusminus ; B 40 0 544 618 ;
*C -1 ; WX 737 ; N registered ; B -13 -23 751 741 ;
*C -1 ; WX 500 ; N scaron ; B 34 -24 459 740 ;
*C -1 ; WX 556 ; N thorn ; B 54 -219 523 729 ;
*C -1 ; WX 834 ; N threequarters ; B 30 -21 804 709 ;
*C -1 ; WX 333 ; N threesuperior ; B 12 270 320 709 ;
*C -1 ; WX 1000 ; N trademark ; B 63 320 938 741 ;
*C -1 ; WX 333 ; N twosuperior ; B 11 284 321 710 ;
*C -1 ; WX 556 ; N uacute ; B 65 -23 482 740 ;
*C -1 ; WX 556 ; N ucircumflex ; B 65 -23 482 741 ;
*C -1 ; WX 556 ; N udieresis ; B 65 -23 482 708 ;
*C -1 ; WX 556 ; N ugrave ; B 65 -23 482 740 ;
*C -1 ; WX 500 ; N yacute ; B 20 -219 478 740 ;
*C -1 ; WX 500 ; N ydieresis ; B 20 -219 478 708 ;
*C -1 ; WX 500 ; N zcaron ; B 31 0 457 740 ;
*EndCharMetrics
*StartKernData
*StartKernPairs 105
*
*KPX A y -18
*KPX A w -18
*KPX A v -18
*KPX A space -55
*KPX A quoteright -74
*KPX A Y -74
*KPX A W -37
*KPX A V -74
*KPX A T -74
*
*KPX F period -111
*KPX F comma -111
*KPX F A -55
*
*KPX L y -37
*KPX L space -37
*KPX L quoteright -55
*KPX L Y -74
*KPX L W -74
*KPX L V -74
*KPX L T -74
*
*KPX P space -18
*KPX P period -129
*KPX P comma -129
*KPX P A -74
*
*KPX R Y -18
*KPX R W -18
*KPX R V -18
*KPX R T -18
*
*KPX T y -55
*KPX T w -55
*KPX T u -37
*KPX T space -18
*KPX T semicolon -111
*KPX T s -111
*KPX T r -37
*KPX T period -111
*KPX T o -111
*KPX T i -37
*KPX T hyphen -55
*KPX T e -111
*KPX T comma -111
*KPX T colon -111
*KPX T c -111
*KPX T a -111
*KPX T O -18
*KPX T A -74
*
*KPX V y -37
*KPX V u -37
*KPX V semicolon -37
*KPX V r -37
*KPX V period -92
*KPX V o -55
*KPX V i -18
*KPX V hyphen -55
*KPX V e -55
*KPX V comma -92
*KPX V colon -37
*KPX V a -74
*KPX V A -74
*
*KPX W y -9
*KPX W u -18
*KPX W semicolon -18
*KPX W r -18
*KPX W period -55
*KPX W o -18
*KPX W i 0
*KPX W hyphen -18
*KPX W e -18
*KPX W comma -55
*KPX W colon -18
*KPX W a -37
*KPX W A -37
*
*KPX Y v -55
*KPX Y u -55
*KPX Y space -18
*KPX Y semicolon -65
*KPX Y q -92
*KPX Y period -129
*KPX Y p -74
*KPX Y o -92
*KPX Y i -37
*KPX Y hyphen -92
*KPX Y e -92
*KPX Y comma -129
*KPX Y colon -55
*KPX Y a -74
*KPX Y A -74
*
*KPX f quoteright 18
*KPX f f -18
*
*KPX one one -74
*
*KPX quoteleft quoteleft -18
*
*KPX quoteright space -37
*KPX quoteright s -18
*KPX quoteright quoteright -18
*
*KPX r quoteright 37
*KPX r period -55
*KPX r comma -55
*
*KPX space Y -18
*KPX space T -18
*KPX space A -55
*
*KPX v period -74
*KPX v comma -74
*
*KPX w period -55
*KPX w comma -55
*
*KPX y period -74
*KPX y comma -74
*EndKernPairs
*EndKernData
*StartComposites 56
*CC Zcaron 2 ; PCC Z 0 0 ; PCC caron 139 199 ;
*CC zcaron 2 ; PCC z 0 0 ; PCC caron 83 0 ;
*CC Scaron 2 ; PCC S 0 0 ; PCC caron 167 199 ;
*CC scaron 2 ; PCC s 0 0 ; PCC caron 83 0 ;
*CC Ccedilla 2 ; PCC C 0 0 ; PCC cedilla 207 0 ;
*CC ccedilla 2 ; PCC c 0 0 ; PCC cedilla 96 0 ;
*CC Ydieresis 2 ; PCC Y 0 0 ; PCC dieresis 167 199 ;
*CC ydieresis 2 ; PCC y 0 0 ; PCC dieresis 83 0 ;
*CC Uacute 2 ; PCC U 0 0 ; PCC acute 194 199 ;
*CC Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex 194 199 ;
*CC Udieresis 2 ; PCC U 0 0 ; PCC dieresis 194 199 ;
*CC Ugrave 2 ; PCC U 0 0 ; PCC grave 194 199 ;
*CC uacute 2 ; PCC u 0 0 ; PCC acute 111 0 ;
*CC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex 111 0 ;
*CC udieresis 2 ; PCC u 0 0 ; PCC dieresis 111 0 ;
*CC ugrave 2 ; PCC u 0 0 ; PCC grave 111 0 ;
*CC Iacute 2 ; PCC I 0 0 ; PCC acute -21 199 ;
*CC Icircumflex 2 ; PCC I 0 0 ; PCC circumflex -21 199 ;
*CC Idieresis 2 ; PCC I 0 0 ; PCC dieresis -21 199 ;
*CC Igrave 2 ; PCC I 0 0 ; PCC grave -21 199 ;
*CC iacute 2 ; PCC dotlessi 0 0 ; PCC acute -27 0 ;
*CC icircumflex 2 ; PCC dotlessi 0 0 ; PCC circumflex -27 0 ;
*CC idieresis 2 ; PCC dotlessi 0 0 ; PCC dieresis -27 0 ;
*CC igrave 2 ; PCC dotlessi 0 0 ; PCC grave -27 0 ;
*CC Eacute 2 ; PCC E 0 0 ; PCC acute 188 199 ;
*CC Ecircumflex 2 ; PCC E 0 0 ; PCC circumflex 188 199 ;
*CC Edieresis 2 ; PCC E 0 0 ; PCC dieresis 188 199 ;
*CC Egrave 2 ; PCC E 0 0 ; PCC grave 188 199 ;
*CC eacute 2 ; PCC e 0 0 ; PCC acute 117 0 ;
*CC ecircumflex 2 ; PCC e 0 0 ; PCC circumflex 117 0 ;
*CC edieresis 2 ; PCC e 0 0 ; PCC dieresis 117 0 ;
*CC egrave 2 ; PCC e 0 0 ; PCC grave 117 0 ;
*CC Aacute 2 ; PCC A 0 0 ; PCC acute 167 199 ;
*CC Acircumflex 2 ; PCC A 0 0 ; PCC circumflex 167 199 ;
*CC Adieresis 2 ; PCC A 0 0 ; PCC dieresis 167 199 ;
*CC Agrave 2 ; PCC A 0 0 ; PCC grave 167 199 ;
*CC aacute 2 ; PCC a 0 0 ; PCC acute 111 0 ;
*CC acircumflex 2 ; PCC a 0 0 ; PCC circumflex 111 0 ;
*CC adieresis 2 ; PCC a 0 0 ; PCC dieresis 111 0 ;
*CC agrave 2 ; PCC a 0 0 ; PCC grave 111 0 ;
*CC Oacute 2 ; PCC O 0 0 ; PCC acute 222 199 ;
*CC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 222 199 ;
*CC Odieresis 2 ; PCC O 0 0 ; PCC dieresis 222 199 ;
*CC Ograve 2 ; PCC O 0 0 ; PCC grave 222 199 ;
*CC oacute 2 ; PCC o 0 0 ; PCC acute 111 0 ;
*CC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 111 0 ;
*CC odieresis 2 ; PCC o 0 0 ; PCC dieresis 111 0 ;
*CC ograve 2 ; PCC o 0 0 ; PCC grave 111 0 ;
*CC Atilde 2 ; PCC A 0 0 ; PCC tilde 167 199 ;
*CC atilde 2 ; PCC a 0 0 ; PCC tilde 111 0 ;
*CC Ntilde 2 ; PCC N 0 0 ; PCC tilde 200 199 ;
*CC ntilde 2 ; PCC n 0 0 ; PCC tilde 117 0 ;
*CC Otilde 2 ; PCC O 0 0 ; PCC tilde 222 199 ;
*CC otilde 2 ; PCC o 0 0 ; PCC tilde 111 0 ;
*CC Aring 2 ; PCC A 0 0 ; PCC ring 167 199 ;
*CC aring 2 ; PCC a 0 0 ; PCC ring 111 0 ;
*EndComposites
*EndFontMetrics
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c    rstemplate - very simple x-window template system for use by
c                 xgetginpt
c
      subroutine rsmaketemplate(labels,n,size)
      character*(*) labels
      dimension labels(n)
      real size
c
c     uses Plesha's xdevice calls to make a set of command boxes
c     along the right side of the xwindow
c
c     labels = array of box labels
c     n = number of boxes
c     size = size (in inches) of boxes to draw
c
      character*5 tlabs
      dimension tlabs(30)
      common/rstemplatec/tlabs
      integer ntbox
      real sizetbox
      common/rstemplate/ntbox,sizetbox
      integer jx1,jx2,jy1,jy2,jint,i,iy,j,offx,offy,lenc
      character*6 label
c
c     this common ties to xplot library
c
      common /xpltscale/mpx,mpy,xinch,yinch,dpi,lastxx,lastyy
      real xinch,yinch,dpi
      integer mpx,mpy,jx,jy,lastxx,lastyy
c
      do 10 i=1,n
        tlabs(i)=labels(i)
   10 continue
      ntbox=n
      sizetbox=size
c
c     make boxes
c
      jint=nint(size*dpi)
      jx1=mpx-jint
      jx2=mpx
      jy1=mpy-jint*n
      jy2=mpy
      call linexw(jx1,jy2,jx1,jy1,1,2)
      call linexw(jx2,jy2,jx2,jy1,1,2)
      do 15 i=1,n+1
        iy=mpy-(i-1)*jint
        call linexw(jx1,iy,jx2,iy,1,2)
  15  continue
c
c     write labels
c
      offy=nint(size*dpi/2.)-5
      do 20 i=1,n
        lenc=itlen(tlabs(i))
        label=tlabs(i)(1:lenc)//char(0)
        offx=nint(size*dpi/2.)-nint(7.*float(lenc)/2.)
        ix=jx1+offx
        iy=mpy-i*jint+offy
        call writexw(ix,iy,label)
  20  continue
c
      return
      end     
c
c     rsintemplate - return the command string if nx,ny points are in template
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine rsintemplate(nx,ny,tcom,mode)
c
c     nx,ny = position on screen
c     tcom = string to return command in
c     mode = 0 if in template
c            1 if not in template
c
      integer nx,ny,mode
      character*(*) tcom
c
      character*5 tlabs
      dimension tlabs(30)
      common/rstemplatec/tlabs
      integer ntbox
      real sizetbox
      common/rstemplate/ntbox,sizetbox
      integer jx1,jx2,jy1,jy2,jint,i,iy,j,offx,offy,lenc
c
c     this common ties to xplot library
c
      common /xpltscale/mpx,mpy,xinch,yinch,dpi,lastxx,lastyy
      real xinch,yinch,dpi
      integer mpx,mpy,jx,jy,lastxx,lastyy
c
c     print *,'RSINTEMPLATE: start'
c
      jint=nint(sizetbox*dpi)
      jx1=mpx-jint
      jx2=mpx
      jy1=mpy-jint*ntbox
      jy2=mpy
c
      mode=1
      if ((nx.ge.jx1).and.(nx.le.jx2).and.(ny.ge.jy1).and.(ny.le.jy2))
     & then
        mode=0
        lenc=max(len(tcom),5)
        i=1+int(real(jy2-ny)/real(jint))
        tcom=tlabs(i)(1:lenc)
      end if
c     print *,'RSINTEMPLATE: end'
      return
      end

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     GETGINPT - gets a Graphic Input Point from a terminal
C
C     This subroutine is just for native x gin (using Plesha's xdevice.c)
C
C     CALL GET_GIN_PT (itek,a,xi,yi,xhite,yhite,mode)
C
C       itek = ignored
C
C       a     = a single character returned along with location information
C
C       xi,yi = Position in plot units (inches, usually but not always)
C               of the input point on the screen
C
C       xhite,yhite = Width (xhite) and Height (yhite) of the screen in
C                     plotting units (pseudo-inches)
C
C       mode  = 0 (got new command)
C             = 1 (got valid point locations)
C
C       Called by: Getbodypt (hypermag) and other user programs
C-
      subroutine get_gin_pt(itek,a,xi,yi,xhite,yhite,mode)
      character*(*) a
C
C     Call the appropriate graphic input routine
C
      call getxgin(a,xi,yi,xhite,yhite,mode)
      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine getxgin(a,x,y,xhite,yhite,mode)

C     GETXGIN - gets a point from an x window

      Character a*(*),tcom*1
      common /xpltscale/mpx,mpy,xinch,yinch,dpi,lastxx,lastyy
      real xinch,yinch,dpi
      integer mpx,mpy,jx,jy,lastxx,lastyy
C
C     set Graphic Input (GIN) mode for one event
C
      call get_pointxw(nx,ny,nbutton)
C
C     decide if point is in command template
C
      mnx=nx
      mny=ny
      call rsintemplate(mnx,mny,tcom,nmode)
c     print *,'GETXGIN: tcom, mode = ',tcom,nmode
      mode=1
      if (nmode.eq.0) then
        a=tcom
        mode=0
      end if
C
C     Convert terminal coordinates to inches
C
      x=real(nx)*xinch/real(mpx)
      y=real(ny)*yinch/real(mpy)
c     print *,'GETXGIN: x,y =',x,y
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine cursor(x,y)

      common /xpltscale/mpx,mpy,xinch,yinch,dpi,lastxx,lastyy
      real xinch,yinch,dpi
      integer mpx,mpy,jx,jy,lastxx,lastyy
      common /nxbakerp/xorig,yorig
      real xorig,yorig,xt,yt
      real scalefactor
      common/factor0/ scalefactor
C
      call get_pointxw(nx,ny,nbutton)
C
C     Convert terminal coordinates to inches
C
      x=real(nx)*xinch/real(mpx) - xorig
      y=real(ny)*yinch/real(mpy) - yorig
      x = x/scalefactor
      y = y/scalefactor
c     print *,'CURSOR: x,y =',x,y

      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine MPAXIS (x,y,label,nchar,sizel,axlen,angle,VMIN,VMAX,dv,
     &                   ITIC,sizen,fmt,lcode)
C
C MPAXIS - Plot an annotated axis.
C
C Call MPAXIS (x,y,label,nchar,sizel,axlen,angle,vmin,vmax,dv,
C              itic,sizen,fmt,lcode)
C
C      (x,y)  = Starting coordinates for axis generation
C      label  = Alphanumeric text string for labelling the axis
C      nchar  = Number of characters in the axis label
C               + = Annotations are generated above the axis
C               - = Annotations are generated below the axis
C      sizel  = Character size of axis label
C      axlen  = Axis length in inches
C      angle  = Angle in degrees at which axis is to be drawn
C      vmin   = First axis value
C      vmax   = Last axis value
C      dv     = Delta annotation value
C      itic   = Tic labeling interval (1 = every one, 2 = every other, etc)
C      sizen  = Character size of numeric labels
C      fmt    = Fortran format for numeric labels
C      lcode  = 0 for labels parallel to axis, 1 for perpendicular
C               (lcode not checked yet, all labels parallel)
C
C    Called by:  User program
C
C        Calls:  PLOT, SYMBOL, NUMBER, IDEBLANK
C
C Commons used:  None
C
C-
C
      Parameter  (RADN = 0.01745329)
      Character*50 axnum,fmt*(*),label*(*)
      ticlen=.06
C
C...  Locate which side of the axis to annotate and label
      side = +1.0
      nc = nchar
C
C...  Negative nchar?
      If (nc .lt. 0) Then
         nc = -nc
         side = -1.0
      End If
C
C..   Determine value of dv exponent
C      exp = 0.0
C      adv = ABS (dv)
C
C...  Zero delta annotation value?
C      If (adv .ne. 0.0) Then
C...     dv exponent calculation completed?
C   20    If (adv .ge. 99.0) Then
C            adv = adv / 10.0
C            exp = exp + 1.0
C            Goto 20
C         End If
C...     dv exponent calculation completed?
C   30    If (adv .lt. 0.01) Then
C            adv = adv * 10.0
C            exp = exp - 1.0
C            Goto 30
C         End If
C      End If
C
C...  Compute normalized fval and dv
C      val = fval * (10.0**(-exp))
C      adv = dv   * (10.0**(-exp))
C
      exp=0.0
      val=vmin
      adv=dv
C...  Set up angular orientation variables
      t2 = angle * RADN
      sina = SIN (t2)
      cosa = COS (t2)
      dlen = (axlen / abs(vmax-vmin))*abs(dv)
C
      dx = -sizen
      dy = (sizen/2+ticlen*2.+.05)*side - sizen/2
      xx = x + dx*cosa - dy*sina
      yy = y + dy*cosa + dx*sina
C
C...  Annotate axis
      ntic = int(abs(vmax-vmin)/abs(dv)+1)
      if ((itic.gt.0).and.(sizen.gt.0)) then
      Do 60 i = 1,ntic
         if (mod(i-1,itic).eq.0) then
            write(axnum,fmt)val
            nfmt=ideblank(axnum)
            call symbol(xx,yy,sizen,axnum,angle,nfmt)
            end if
         val = val + adv
         xx  = xx + cosa * dlen
   60    yy  = yy + sina * dlen
         end if
C
C...  Label axis
      t2 = nc
C
C...  Does dv exponent exist?
      If (exp .ne. 0.0) t2 = nc + 6
C
      dx = -(sizel/2)*t2 + 0.5*axlen
      dy = (sizel/2+sizen+ticlen*2.+.1)*side - sizel/2
      xx = x + dx*cosa - dy*sina
      yy = y + dy*cosa + dx*sina
      Call SYMBOL (xx,yy,sizel,label,angle,nc)
C
C...  No dv exponent to plot?
      If (exp .ne. 0.0) Then
C...     Plot exponent
         Call SYMBOL (999.,999.,0.14,'  *10',angle,5)
         t2 = nc + 5
         xx = xx + (t2*cosa - 0.8*sina)*0.14
         yy = yy + (t2*sina + 0.8*cosa)*0.14
         Call NUMBER (xx,yy,0.07,exp,angle,-1)
      End If
C
C...  Draw axis and tic marks
      dx = -ticlen * side * sina
      dy = +ticlen * side * cosa
      dxm = dx*2.0
      dym = dy*2.0
      xx = x
      yy = y
      Call PLOT (xx,yy,3)
      Do 80 i = 1,ntic
         Call PLOT (xx,yy,2)
         if (mod(i-1,itic).eq.0) then
         call plot (xx+dxm,yy+dym,2)
         else
         Call PLOT (xx+dx,yy+dy,2)
         end if
         Call PLOT (xx,yy,3)
         xx = xx + cosa * dlen
   80    yy = yy + sina * dlen
C
C...  Plot rest of axis
      xx = x + cosa * axlen
      yy = y + sina * axlen
      Call PLOT (xx,yy,2)
C
      Return
C
      End
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C
      SUBROUTINE MPLINE2 (N,X,Y,XMIN,XMAX,XL,YMIN,YMAX,YL,
     1                   LINTYP,MARKER,SIZE,IPEN,SVAREA)
C
C MPLINE2 -- Poly-line drawing subroutine
C
C           Draw a line through a set of points, with an optional
C           marker displayed at each point.  (The line may be
C           invisible.)  Clipping is performed using user supplied
C           limits.
C
C CALL MPLINE2(N,X,Y,XMIN,XMAX,XL,YMIN,YMAX,YL,
C             LINTYP,MARKER,SIZE,IPEN,SVAREA)
C
C      N      = Number of data points.
C      X      = X coordinates of data points.
C      Y      = Y coordiantes of data points.
C      XMIN,XMAX = X clipping limits, in data units.
C      XL     = Length of X axis, in plotting units.
C      YMIN,YMAX = Y clipping limits, in data units.
C      YL     = Length of Y axis, in plotting units.
C      LINTYP = Line type flag:  <0 -> Plot markers at points
C                                =0 -> Connect points by lines
C                                >0 -> Connect markers at points with lines
C      MARKER = Symbol number
C      SIZE   = Marker size
C      IPEN   = Move to first point with pen up (IPEN=3) or down (IPEN=2)
C      SVAREA = Real array length 2 to save previous position (in plotting
C               units) for next call to MPLINE2 .
C               SVAREA must be valid if IPEN=2.
C
C Note:  The data value (XMIN,YMIN) is mapped to plotting position (0.,0.);
C        data value (XMAX,YMAX) is mapped to plotting position (XL,YL).
C
C      Called by: User program
C
C          Calls: Plot, Symbol, Plclip
C
C   Commons used: none
C-
C
      DIMENSION  X(1), Y(1), SVAREA(2), VECTOR(4), WINDOW(4)
      character*1 cmarker
C
      PX(XV) = (XV-XMIN) / DX
      PY(YV) = (YV-YMIN) / DY
C
      cmarker=char(marker)
C
      DX = (XMAX-XMIN) / XL
      DY = (YMAX-YMIN) / YL
      WINDOW(1) = 0.0
      WINDOW(2) = 0.0
      WINDOW(3) = XL
      WINDOW(4) = YL
C...  Make sure N >= 1
      IF (N .LE. 0) GOTO 9000
C...  Get previous position from save area
      XP = PX(XMIN)
      YP = PY(YMIN)
      JPEN = 3
      IF (LINTYP .LT. 0) GOTO 1000
      IF (IPEN .NE. 2) GOTO 1000
      XP = SVAREA(1)
      YP = SVAREA(2)
      JPEN = 2
C...  Do loop 1,N
 1000 DO 3000 J = 1,N
         VECTOR(1) = XP
         VECTOR(2) = YP
         VECTOR(3) = PX(X(J))
         VECTOR(4) = PY(Y(J))
         XP = VECTOR(3)
         YP = VECTOR(4)
C...  Clip vector
         CALL PLCLIP(VECTOR,WINDOW,NCLIP)
         IF (NCLIP .GE. 3) GOTO 3000
C...  End points for calls to PLOT and SYMBOL
         XT = VECTOR(3)
         YT = VECTOR(4)
C...  If line, plot line
         IF (LINTYP .LT. 0) GOTO 2000
         CALL PLOT(VECTOR(1),VECTOR(2),3)
         CALL PLOT(XT,YT,JPEN)
         IF (LINTYP .EQ. 0) GOTO 3000
C...  If end point not clipped, plot symbol
 2000    IF (VECTOR(3) .NE. XP) GOTO 3000
         IF (VECTOR(4) .EQ. YP)
     1      CALL SYMBOL(XT,YT,SIZE,CMARKER,0.0,-1)
 3000    JPEN = 2
C
C...  Save last point position for next call to MPLINE2.
      SVAREA(1) = XP
      SVAREA(2) = YP
C
C...  Return
 9000 RETURN
C
      END
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C
      Subroutine PLCLIP (vector, window, iclip)
C
C PLCLIP - Clip vector to plotting window.
C
C Call PLCLIP (vector,window,iclip)
C
C      vector = The vector to be clipped (in place)
C               (vector(1,1),vector(2,1)) to (vector(1,2),vector(2,2))
C      window = Clipping limits (X-Min,Y-Min), (X-Max,Y-Max)
C      iclip  = 0 If vector good
C             = 1 If vector clipped once
C             = 2 If vector clipped twice
C             = 3 If vector bad
C
C       Called by:  PLPLOT, PLINE1, PLINE2
C
C           Calls:  None
C
C Parameters used:  None
C
C    Commons used:  None
C
C-
C
      Dimension  vector(2,2), window(2,2)
C
C...  Vector limits check and clipping
C
C...  Test each coordinate
      iclip = 0
      Do 100 i = 1,2
         nerr = 0
C
C...     Test individual ordinates
   50    Do 90 j = 1,2
C
C...        Test upper limits
            almt = window(j,2)
C
C...        Upper limit OK?
            If (vector(j,i) .gt. almt) Then
C
C...           Upper limit bad?
               If (vector(j,3-i) .gt. almt) Then
                  Goto 9900
               Else
c    LEES : change 
c                  Goto 70
                  nerr = nerr + 1

               End If
            End If
C
C...        Test lower limits
            almt = window(j,1)
C
C...        Lower limit OK?
            If (vector(j,i) .lt. almt) Then
C
C...           Lower limit bad?
               If (vector(j,3-i) .lt. almt) Goto 9900
C
C...           Ordinate out of range - attempt intersection
   70          nerr = nerr + 1
C
C...           Intersection failure?
               If (nerr .gt. 2) Then
                  Goto 9900
               Else
                  vector(3-j,i) = ((vector(3-j,1)-vector(3-j,2))/
     1                             (vector(  j,1)-vector(  j,2)))*
     2                             (almt-vector(j,1)) + vector(3-j,1)
                  vector(  j,i) = almt
                  Goto 50
               End If
            End If
   90       Continue
C
C...     Test for any clipping done for this point
  100    If (nerr .gt. 0) iclip = iclip + 1
C
 9000 Return
C
C...  Intersection failure
 9900 iclip = 3
      Goto 9000
C
      End
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Subroutine AXIS (x,y,label,nchar,axlen,angle,fval,dv)
C
C AXIS - Plot an annotated axis.
C
C Call AXIS (x,y,label,nchar,axlen,angle,fval,dv)
C
C      (x,y)  = Starting coordinates for axis generation
C      label  = Alphanumeric text string for labelling the axis
C      nchar  = Number of characters in the axis label
C               + = Annotations are generated above the axis
C               - = Annotations are generated below the axis
C      axlen  = Axis length in inches
C      angle  = Angle in degrees at which axis is to be drawn
C      fval   = First annotation value
C      dv     = Delta annotation value
C
C    Called by:  User program
C
C        Calls:  NUMBER, PLOT, SYMBOL
C
C Commons used:  None
C
C-
C
      Parameter  (RADN = 0.01745329)
      character*5 label*(*)
C
C...  Locate which side of the axis to annotate and label
      side = +1.0
      nc = nchar
C
C...  Negative nchar?
      If (nc .lt. 0) Then
         nc = -nc
         side = -1.0
      End If
C
C..   Determine value of dv exponent
      exp = 0.0
      adv = ABS (dv)
C
C...  Zero delta annotation value?
      If (adv .ne. 0.0) Then
C...     dv exponent calculation completed?
   20    If (adv .ge. 99.0) Then
            adv = adv / 10.0
            exp = exp + 1.0
            Goto 20
         End If
C...     dv exponent calculation completed?
   30    If (adv .lt. 0.01) Then
            adv = adv * 10.0
            exp = exp - 1.0
            Goto 30
         End If
      End If
C
C...  Compute normalized fval and dv
      val = fval * (10.0**(-exp))
      adv = dv   * (10.0**(-exp))
C
C...  Set up angular orientation variables
      t2 = angle * RADN
      sina = SIN (t2)
      cosa = COS (t2)
C
      dx = -0.1
      dy = 0.15*side - 0.05
      xx = x + dx*cosa - dy*sina
      yy = y + dy*cosa + dx*sina
C
C...  Annotate axis
      ntic = axlen + 1.0
      Do 60 i = 1,ntic
         Call NUMBER (xx,yy,0.105,val,angle,2)
         val = val + adv
         xx  = xx + cosa
   60    yy  = yy + sina
C
C...  Label axis
      t2 = nc
C
C...  Does dv exponent exist?
      If (exp .ne. 0.0) t2 = nc + 6
C
      dx = -0.07*t2 + 0.5*axlen
      dy = 0.325*side - 0.075
      xx = x + dx*cosa - dy*sina
      yy = y + dy*cosa + dx*sina
      Call SYMBOL (xx,yy,0.14,label,angle,nc)
C
C...  No dv exponent to plot?
      If (exp .ne. 0.0) Then
C...     Plot exponent
         Call SYMBOL (999.,999.,0.14,'  *10',angle,5)
         t2 = nc + 5
         xx = xx + (t2*cosa - 0.8*sina)*0.14
         yy = yy + (t2*sina + 0.8*cosa)*0.14
         Call NUMBER (xx,yy,0.07,exp,angle,-1)
      End If
C
C...  Draw axis and tic marks
      dx = -0.07 * side * sina
      dy = +0.07 * side * cosa
      xx = x
      yy = y
      Call PLOT (xx,yy,3)
      Do 80 i = 1,ntic
         Call PLOT (xx,yy,2)
         Call PLOT (xx+dx,yy+dy,2)
         Call PLOT (xx,yy,3)
         xx = xx + cosa
   80    yy = yy + sina
C
      Return
C
      End
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C
      SUBROUTINE LINE (XARRAY,YARRAY,NPTS,INC,LINTYP,INTEQ)
C
C LINE - connected pairs of points.
C
C CALL LINE (XARRAY,YARRAY,NPTS,INC,LINTYP,INTEQ)
C
C      XARRAY = Array of X values
C      YARRAY = Array of Y values
C      NPTS   = Number of points to be plotted
C      INC    = Increment between points in arrays
C      LINTYP = Plot control
C               < 0 = Plot markers at points
C               = 0 = Connect points by lines
C               > 0 = Plot markers at points and connect by lines
C      INTEQ  = INTEGER equivalent of marker to be used, if any
C
C Called by:  User program
C
C Calls:  PLOT, SYMBOL, WHERE
C
C COMMONs used:  None
C
C-
C
      DIMENSION  XARRAY(1), YARRAY(1)
      character*1 cinteq
C
      cinteq=char(inteq)
C
C...  Initialize subscripts
      LMIN = NPTS*INC + 1
      LDX = LMIN + INC
      NL = LMIN - INC
C
C...  Set maxs/mins and scaling factors
      FIRSTX = XARRAY(LMIN)
      DELTAX = XARRAY(LDX)
      FIRSTY = YARRAY(LMIN)
      DELTAY = YARRAY(LDX)
C
C...  Get current location
      CALL WHERE(XN,YN,DF)
      DF = AMAX1(ABS((XARRAY( 1)-FIRSTX)/DELTAX-XN),
     1           ABS((YARRAY( 1)-FIRSTY)/DELTAY-YN))
      DL = AMAX1(ABS((XARRAY(NL)-FIRSTX)/DELTAX-XN),
     1           ABS((YARRAY(NL)-FIRSTY)/DELTAY-YN))
      IPEN = 3
      ICODE = -1
      NT = IABS(LINTYP)
C
C...  No markers plotted?
      IF (LINTYP .EQ. 0) NT = 1
C
C...  Data ascending order?
      IF (DL .GE. DF) GOTO 10
C
C...  Set for descending order data
      NF = NL
      NA = ((NPTS-1)/NT)*NT + NT - (NPTS-1)
      KK = -INC
      GOTO 20
C
C...  Set for ascending order data
   10 NF = 1
      NA = NT
      KK = INC
C
C...  Markers, lines, or both?  M, L, B
   20 IF (LINTYP)              30,40,50
C
C...  Set for markers only
   30 IPENA = 3
      ICODEA = -1
      LSW = 1
      GOTO 60
C
C...  Set for lines
   40 NA = LDX
   50 IPENA = 2
      ICODEA = -2
      LSW = 0
C
C...  Plot data
   60 DO 120 I = 1,NPTS
         XN = (XARRAY(NF)-FIRSTX) / DELTAX
         YN = (YARRAY(NF)-FIRSTY) / DELTAY
C
C...  Time to plot a marker?     N, Y, N
         IF (NA - NT)           80,70,90
C
C...  Plot symbol
   70    CALL SYMBOL(XN,YN,0.08,CINTEQ,0.0,ICODE)
         NA = 1
         GOTO 110
C
C...  Line to be plotted?
   80    IF (LSW .NE. 0) GOTO 100
C
C...  Plot line
   90    CALL PLOT(XN,YN,IPEN)
C
C...  Count data point
  100    NA = NA + 1
  110    NF = NF + KK
         ICODE = ICODEA
  120    IPEN = IPENA
C
      RETURN
C
      END
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C
      SUBROUTINE SCALE (ARRAY,AXLEN,NPTS,INC)
C
C SCALE - Scale data values for LINE and AXIS.
C
C CALL SCALE (ARRAY,AXLEN,NPTS,INC)
C
C      ARRAY  = Array of unscaled data points
C      AXLEN  = Length of scaled axis in inches
C      NPTS   = Number of data points to be scaled
C      INC    = Increment between points in ARRAY
C
C Called by:  User program
C
C Calls:  None
C
C COMMONs used:  None
C
C-
C
      DIMENSION  ARRAY(1), UNITS(7)
C
      DATA UNITS(1)/1./,UNITS(2)/2./,UNITS(3)/4./,UNITS(4)/5./
      DATA UNITS(5)/8./,UNITS(6)/10./,UNITS(7)/20./
C
C...  Determine min and max values of ARRAY
      K = IABS(INC)
      J = NPTS * K
      AMIN = ARRAY(1)
      AMAX = AMIN
      DO 10 I = 1,J,K
         A = ARRAY(I)
C
C...  New min found?
         IF (A .LT. AMIN) AMIN = A
C
C...  New max found?
         IF (A .GT. AMAX) AMAX = A
   10    CONTINUE
C
C...  Compute delta value for unscaled unit interval
      DV = (AMAX-AMIN) / AXLEN
C
C...  Delta OK?
      IF (DV .GT. 0.0) GOTO 20
C
C...  Error - AMAX and AMIN not in correct range
      DV = ABS((AMIN+AMIN)/AXLEN) + 1.0
C
C...  Compute tens power of DV value (watch out for negative logs!)
   20 ADV = ALOG10(DV)
      LOGDV = IFIX(ADV)
      IF (FLOAT(LOGDV) .GT. ADV) LOGDV = LOGDV - 1
      A = 10.0**LOGDV
C
C...  Compute normalized DV value (1. < DV < 10.)
      DV = DV/A
C
C...  Locate closest "UNIT" DV value (normalized)
      DO 30 I = 1,6
C
C...  Value found?
         IF (UNITS(I) .GE. DV) GOTO 50
   30    CONTINUE
C
C...  Expand unit DV to floating
   50 DV = UNITS(I) * A
C
C...  Compute "UNIT" minimum based on "UNIT" DV
      ADV = AINT(AMIN/DV)
      IF (ADV .GT. AMIN/DV) ADV = ADV - 1.
      TMIN = DV * ADV
C
C...  Does adjusted "UNIT" scale fit axis length?
      IF ((TMIN+(AXLEN+0.01)*DV) .GE. AMAX) GOTO 60
      ADV = AINT(AMIN/A)
      IF (ADV .GT. AMIN/A) ADV = ADV - 1.
      TMIN = A * ADV
C
C...  Does adjusted "UNIT" scale fit axis length?
      IF ((TMIN+(AXLEN+0.01)*DV) .GE. AMAX) GOTO 60
      I = I + 1
      GOTO 50
C
C...  Compute final adjusted minimum
   60 TMIN = TMIN - DV*AINT((AXLEN+(TMIN-AMAX)/DV)/2.0)
C
C...  Does TMIN need correction?
      IF (AMIN*TMIN .LE. 0.0) TMIN = 0.0
C
C...  Scale direction OK?
      IF (INC .GT. 0) GOTO 70
C
C...  Reverse direction of scale
      TMIN = TMIN + DV*AINT(AXLEN+0.5)
      DV = -DV
C
C...  Set scale factors into user's array
   70 J = J + 1
      ARRAY(J) = TMIN
      K = J + K
      ARRAY(K) = DV
C
      RETURN
C
      END
C-T  SUBROUTINE CURVE
C
C-F  PERFORMS CURVE APPROXIMATION WITH SOLID OR DASHED LINES
C
C-L  FORTRAN
C
C  COPYRIGHT C1976, VERSATEC INC., SANTA CLARA, CALIFORNIA 95051
C
C  THE CONTENTS OF THIS DOCUMENT ARE PROPRIETARY TO VERSATEC, INC.,
C  AND ARE NOT TO BE DISCLOSED TO OTHERS OR USED FOR PURPOSES OTHER
C  THAN INTENDED WITHOUT THE WRITTEN APPROVAL OF VERSATEC.
C
C
C  CALLING SEQUENCE:   CALL CURVE (X,Y,NE,DELTA)
C
C    WHERE:   X,Y  IS AN ARRAY OF COORDINATE POINTS TO BE JOINED
C                  BY A SMOOTH CURVE.
C
C              NE  (ABSOLUTE) IS THE NUMBER OF COORDINATE POINTS
C                  IN X AND Y.
C
C                  -NE  INDICATES THAT SCALE FACTORS ARE LOCATED AS THE
C                       LAST TWO ELEMENTS OF EACH DATA ARRAY (I.E.
C                       NE+1 AND NE+2).
C
C                  +NE  INDICATES THAT THE COORDINATE POINTS ARE ALREADY
C                       SCALED FOR PLOTTING (NO SCALE FACTORS).
C
C           DELTA  (ABSOLUTE) IS THE SEGMENT LENGTH FOR THE INCREMENTAL
C                  APPROXIMATION OF THE CURVE.
C
C                  +DELTA  INDICATES THAT THE CURVE IS TO BE GENERATED
C                          WITH A SOLID LINE.
C
C                  -DELTA  INDICATES THAT THE CURVE IS TO BE GENERATED
C                          WITH DASHED LINES (OF 'DELTA' LENGTH).
C
C  CALLS:   PLOT
C
C  COMMON VARIABLES USED:  -NONE-
C
C
C-P  50034-20030 REV. B           - PART NUMBER
C
C-S  RSX-11                       - OPERATING SYSTEM
C
C    AUTHOR: J.R. DAVIS             09/01/77
C
      SUBROUTINE CURVE (X,Y,NE,DELTA)
      DIMENSION X(*),Y(*)
C
C
C
C...   SET SCALE FACTORS
      XOFF = 0.
      YOFF = 0.
      XFAC = 1.
      YFAC = 1.
      NET = NE
      IF (NET)  10,900,20
   10 NET = -NET
      XOFF = X(NET+1)
      YOFF = Y(NET+1)
      XFAC = X(NET+2)
      YFAC = Y(NET+2)
C
C...   CHECK FOR SOLID OR DASHED LINES
   20 MPEN = 4
      DELT = DELTA
      IF (DELT)  30,900,50
   30 DELT = -DELT
      MPEN = 5
C
C...   INITIALIZE
   50 K = 1
      IPEN = 3
      DLTSQ = DELTA*DELTA
C
C
C      BEGIN MAIN LOOP.  (X1,Y1) IS JOINED TO (X2,Y2) BY ARC WITH
C      DIRECTION COSINES (C1,S1) AND (C2,S2) AT END POINTS.  FINAL
C      VALUES FOR PREVIOUS ARC ARE TAKEN AS INITIAL VALUES FOR
C      NEW ARC.
C
C...   COMPUTE FOR NEW END POINT
  110 X2 = (X(K)-XOFF)/XFAC
      Y2 = (Y(K)-YOFF)/YFAC
      IF (K.EQ.NET) GO TO 130
      IF (K.GT.1)  GO TO 140
C
C...   FIRST DATA POINT (K=1)
  120 DLTX1 = (X(2)-X(1))/XFAC
      DLTY1 = (Y(2)-Y(1))/YFAC
      DLTX2 = (X(3)-X(2))/XFAC
      DLTY2 = (Y(3)-Y(2))/YFAC
      T1 = DLTX1*DLTX1 + DLTY1*DLTY1
      T2 = DLTX2*DLTX2 + DLTY2*DLTY2
      T3 = 2.*SQRT(T1*T2)
      T1 = -T1
      T2 = T3 + T2
      GO TO 150
C
C...   LAST DATA POINT (K=NET)
  130 DLTX1 = X1 - (X(K-2)-XOFF)/XFAC
      DLTY1 = Y1 - (Y(K-2)-YOFF)/YFAC
      DLTX2 = X2 - X1
      DLTY2 = Y2 - Y1
      T1 = DLTX1*DLTX1 + DLTY1*DLTY1
      T2 = DLTX2*DLTX2 + DLTY2*DLTY2
      T3 = 2.*SQRT(T1*T2)
      T2 = -T2
      T1 = T3 + T1
      GO TO 150
C
C...   INTERIM DATA POINT (1<K<NET)
  140 DLTX1 = X2 - X1
      DLTY1 = Y2 - Y1
      DLTX2 = (X(K+1)-X(K))/XFAC
      DLTY2 = (Y(K+1)-Y(K))/YFAC
      T1 = DLTX1*DLTX1 + DLTY1*DLTY1
      T2 = DLTX2*DLTX2 + DLTY2*DLTY2
C
  150 E = DLTX1*T2 + DLTX2*T1
      F = DLTY1*T2 + DLTY2*T1
      G = SQRT(E*E+F*F)
      IF (G.NE.0.)  G = 1./G
      C2 = G*E
      S2 = G*F
      IF (K.EQ.1)  GO TO 180
C
      U = X2 - X1
      V = Y2 - Y1
      G = U*U + V*V
      A = C1*C2 + S1*S2
C
C...   CHECK IF (X2,Y2) IS MORE THAN 'DELTA' AWAY FROM (X1,Y1)
      IF (G.GE.DLTSQ)  GO TO 200
C
C...   DISTINGUISH BETWEEN CLOSE POINTS AND COICIDENT POINTS
      IF (G.GT.0.)  GO TO 170
C
C...   TEST FOR TANGENTIAL DISCONTINUITY
      IF (A.LE.0.99996)  GO TO 180
C
C...   (X1,Y1),(X2,Y2) LESS THAN 'DELTA' APART; SKIP TO NEXT POINT.
  170 K = K + 1
      IF (K.LE.NET)  GO TO 110
C
  180 CALL PLOT (X2,Y2,IPEN)
      H = DELT
      IPEN = 2
      GO TO 320
C
C...   CALCULATE COEFFICIENTS OF CUBICS FOR X AND Y
  200 A = 7. - A
      E = C1 + C2
      F = S1 + S2
      B = U*E + V*F
      T = SQRT(B*B+2.*A*G)
      C = (T+B)/G
      T = 3.*(T-B)/A
      G = C/12.
      A = G*(C*U-3.*E)
      B = G*(C*V-3.*F)
      U = G*(C2-C1) + A
      V = G*(S2-S1) + B
      C = -C/9.
      A = A*C
      B = B*C
      G = H
C
C
C      X AND Y COORDINATES OF ARC ARE GIVEN AS CUBICS IN A PARAMETER
C      GOING FROM ZERO TO T AND HELD IN G.  THE INCREMENT IS DELTA.
C      G IS SET INITIALLY TO SPACE THE FIRST POINT OF THE NEW ARC
C      AT DISTANCE DELTA FROM THE LAST POINT OF THE PREVIOUS ARC.
C
C...   GENERATE SEGMENTS OF ARC APPROXIMATION
  220 E = G*(G*(A*G+U)+C1) + X1
      F = G*(G*(B*G+V)+S1) + Y1
      CALL PLOT (E,F,IPEN)
      IPEN = MPEN - IPEN
      G = G + DELT
      H = G - T
      IF (H.LE.0.)  GO TO 220
C
C...   ARC (X1,Y1) TO (X2,Y2) COMPLETE, SETUP FOR NEXT ARC
  320 X1 = X2
      Y1 = Y2
      C1 = C2
      S1 = S2
      K = K + 1
      IF (K.LE.NET)  GO TO 110
C
C
C...   CLOSE TO LAST POINT OF CURVE
      CALL PLOT (X2,Y2,IPEN)
  900 RETURN
      END

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      SUBROUTINE NUMBER (X,Y,HEIGHT,FPN,ANGLE,NDIG)
C
C NUMBER - Plot numeric value.
c
c mods by R Saltus 1/92 for incorporation in SimplePlotSystem
C
C *** Machine character set dependent  (see DATA statement) ***
C
C CALL NUMBER (X,Y,HEIGHT,FPN,ANGLE,NDIG)
C
C      (X,Y)  = Starting coordinates for 1st char (REAL)
C      HEIGHT = Character height (REAL)
C      FPN    = Number to be converted to digits and plotted (REAL)
C      ANGLE  = Angle at which numeric string is to be plotted
C               in degrees measured from the X-axis (REAL)
C      NDIG   = Specification of the number of digits and the type
C               of numeric string to be plotted (INTEGER)
C               >  0 = Number of digits to the right of the decimal
C                      point to be plotted (last digit is rounded)
C               =  0 = Rounded integer portion of FPN is plotted
C                      with a decimal point
C               = -1 = Rounded integer portion of FPN is plotted
C                      without the decimal point
C               < -1 = Rounded integer portion of FPN is plotted
C                      after having the least significant digits
C                      truncated (IABS(NDEC)-1 digits are truncated)
C
C Called by:  User program
C
C Calls:  SYMBOL
C
C COMMONs used:  None
C
C-
C
      Character*1 Numbers,Numb,minus,ipoint
      Dimension Numbers(10)
c     Equivalence (inumb,Numb)
c     DATA  MINUS/1H-/, IPOINT/1H./
      data minus/'-'/, ipoint/'.'/
C
C...  Note:  The following DATA statement is dependent on the character
C...  set and should be changed to equal the decimal integer value for
C...  the character 0 (zero) in your computer's character set (ASCII=48).
C
      DATA  IZERO/48/
      DATA Numbers/'0','1','2','3','4','5',
     & '6','7','8','9'/
C
C...  Initialize
      T1 = FPN
      XZ = X
      YZ = Y
C
C...  Number negative?
      IF (T1 .GE. 0.0) GOTO 20
      CALL SYMBOL(XZ,YZ,HEIGHT,MINUS,ANGLE,1)
      XZ = 999.0
      YZ = 999.0
      T1 = -T1
C
C...  Set working digit count
   20 ND = -NDIG
C
C...  Fractional part to be plotted?
      IF (NDIG .GT. 0) GOTO 40
C
C...  Round and truncate for integer
      IF (NDIG .EQ. 0) ND = 1
      ND = ND - 1
      T2 = IFIX((T1+0.5)/(10.0**ND)) + 0.5
      ND = 0
      IF (NDIG .EQ. 0) ND = -1
      GOTO 50
C
C...  Round for fraction
   40 T2 = T1 + 0.5/(10.0**NDIG)
C
C...  Find number of digits to the left of the decimal point
   50 NL = 1
C
C...  No more digits to the left of the decimal point?
   60 IF (T2 .LT. 10.0) GOTO 70
      T2 = T2 / 10.0
      NL = NL + 1
      GOTO 60
C
C...  Set plottable digit count
   70 NP = NL - ND
C
C...  Bad digit count?
      IF (NP .LE. 0) NP = 1
C
C...  Time to plot decimal point?
   80 IF (NL .NE. 0) GOTO 100
C
C...  No decimal point?
      IF (NDIG .LT. 0) GOTO 120
      CALL SYMBOL(XZ,YZ,HEIGHT,IPOINT,ANGLE,1)
      IF (NDIG .NE. 0) NP = NP + 1
      GOTO 110
C
C...  Plot digit
  100 continue
      IDIG = T2
      T2 = (T2-IDIG)*10.0
      numb=numbers(idig+1)
c     IDIG = IDIG + IZERO -1
      CALL SYMBOL(XZ,YZ,HEIGHT,numb,ANGLE,1)
c     original code:
c 110 XZ = 999.0
c     YZ = 999.0
c     
c     quick saltus fix:
  110 xz=xz+(height*.65)*cos(angle)
      yz=yz+(height*.65)*sin(angle)
C
C...  Count digit
      NP = NP - 1
  120 NL = NL - 1
C
C...  More digits to plot?
      IF (NP .GT. 0) GOTO 80
C
      RETURN
C
      END
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C
      Subroutine WHERE (xnow, ynow, dfact)
C
C WHERE - Return the present location and drawing factor.
C
C Call WHERE (xnow,ynow,dfact)
C
C      xnow   = Current X-coordinate.
C      ynow   = Current Y-coordinate.
C      dfact  = Current drawing factor.
C
C    Called by:  LINE and user program
C
C        Calls:  None
C
C Commons used:  /PLTCOM/  pref,fact
C
C-
C
C     Include 'PltCom/NoList'
      Common /lbwhere/ xn,yn,df
C
C...  Return present location and drawing factor
      xnow = xn
      ynow = yn
      dfact = df
C
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C    IDEBLANK- removes all blanks and returns length
C
C    ireturn = IDEBLANK (string)
C
C       ireturn = length of the string without blanks
C        string = character string to be de-blanked
C
C-
      Integer Function ideblank(string)
      Character*256 string*(*),temp
      j=1
      temp=' '
      itemp=len(string)
      Do 10 i=1,itemp
      If (string(i:i).EQ.' ')Go To 10
      temp(j:j)=string(i:i)
      j=j+1
   10 Continue
      string=temp
      ideblank=j-1
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
CS    USGS Function IGETTOK
C     Version: 1.0
C     Technical Contact: Richard W. Saltus
C     Release: not released
C
C     Function IGETTOK
C
C     Program purpose:
C             - Selects next alpha-numeric token, special symbol,
C               or quoted string from BUF.
C               Puts token in TOK.  Returns ierr & itype to describe
C               token.
C
C     Instructions for use:
C           LEN = IGETTOK(BUF,TOK,IERR,ITYPE)
C
      INTEGER FUNCTION IGETTOK(BUF,TOK,IERR,ITYPE)
C-
C
C     Variables and parameters:
C
C                LEN = Length of BUF read.
C
C                BUF = Character string to search for token
C
C                TOK = Token found (Character string)
C
C               IERR = 1 , got a token
C                      0 , got a token, hit end of BUF
C                     -1 , didn't get a token, hit end of BUF
C
C               ITYPE = 1 , got an alpha-numeric token
C                       0 , got a quoted token
C                      -1 , got a single symbol
C
C         Called by: Style, IxQUEST subroutines, user program
C
C             Calls: ICTYPE
C
C      Commons used: none
C-
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Character*(*) buf,tok
      lbuf=len(buf)
      lmax=len(tok)
      ltok=0
C
      Do 10 i=1,lbuf
      If (ictype(buf(i:i)).LT.0) Then
C
C     got special symbol (non alpha-numeric)
C
         If (ltok.GT.0) Then
C
C       already have a token, this must end it
C
            igettok=i-1
            itype=1
            ierr=1
            Return
         Else
C
C       don't have a token yet
C
            If (buf(i:i).EQ.' ') Then
C
C         got a blank, skip it
C
               Continue
            Else If (buf(i:i).EQ.'''') Then
C
C         got a quote (begin quoted token)
C
               itemp=i
    5          Continue
               iend=index(buf(itemp+1:lbuf),'''')
               If (iend.EQ.0) Then
C
C           didn't find another quote
C
                  tok=buf(i:lbuf)
                  igettok=lbuf
                  itype=0
                  ierr=0
                  Return
               Else
C
C           did find another quote
C
                  nloc=itemp+iend+1
                  If (buf(nloc:nloc).EQ.'''') Then
C
C             paired quotes within quotes, keep looking for end
C
                     itemp=nloc
                     Go To 5
                  Else
C
C           found end of quoted token
C
                     tok=buf(i:itemp+iend)
                     igettok=itemp+iend
                     itype=0
                     If (i+iend.EQ.lbuf) Then
                        ierr=0
                     Else
                        ierr=1
                     End If
                  End If
                  Return
               End If
            Else
C
C       special symbol is token
C
               tok(1:1)=buf(i:i)
               itype=-1
               ierr=1
               igettok=i
               Return
            End If
         End If
      Else
C
C     got alpha-numeric
C
         ltok=ltok+1
         tok(ltok:ltok)=buf(i:i)
      End If
C
   10 Continue
C
C     reached end of buffer, all alpha-numerics
C
      itype=1
      igettok=lbuf
      If (ltok.EQ.0) Then
C
C       all blanks (no token)
C
         ierr=-1
      Else
C
C       got token
C
         ierr=0
      End If
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     INTEGER FUNCTION IGETVALS
C
C    VARIABLE FORMAT READ OF VARIABLE LENGTH ARRAYS
C
C      ireturn = IGETVALS (RVAL,ILEN,IUNIT)
C
C    IRETURN = THE NUMBER OF REAL NUMBERS READ INTO THE RVAL ARRAY
C            = -1 IF THE END OF THE FILE WAS ENCOUNTERED (NO VALUES READ)
C
C    RVAL = ARRAY TO RECEIVE THE VALUES
C    ILEN = SIZE OF THE RVAL ARRAY
C    IUNIT= FORTRAN UNIT TO READ VALUES FROM
C
C     CALLS: INEXTVAL
C-
      Integer Function igetvals(rval,ilen,iunit)
      Dimension rval(ilen)
      Character*100 inbuf
      iread=0
      ierr=1
   10 Continue
      If ((iread.LE.ilen).AND.(ierr.NE.-1)) Then
         Read (iunit,100,End =30)inbuf
  100 Format (a100)
      ipos=1
      ierr=1
   20 Continue
      If ((iread.LT.ilen).AND.(ierr.EQ.1).AND.(ipos.LE.100)) Then
         iread=iread+1
         inex=inextval(inbuf(ipos:100),rval(iread),ierr)
         ipos=ipos+inex-1
         If (ierr.EQ.-2) Then
            iread=iread-1
            ierr=0
            End If
         Go To 20
         End If
      Go To 10
      End If
C
C     FALLS OUT HERE WHEN ARRAY IS FULL, OR TRANSLATION ERROR OCCURS
C
      If (ierr.EQ.-1)iread=iread-1
      igetvals=iread
      Return
C
C     HIT END OF FILE
C
   30 If (iread.EQ.0) Then
         igetvals=-1
         Else
         igetvals=iread
         End If
      End
CS    USGS Function ITLEN
C     Version: 1.0
C     Technical Contact: Richard W. Saltus
C     Release: not released
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     Function ITLEN
C
C     Program purpose:
C         This function returns the length of a character string without
C         trailing blanks.
C
C     Instructions for use:
C         Use this function to find out the position of the last non-blank
C         character in a string.
      INTEGER FUNCTION ITLEN(STRING)
C-
C
C     Variables and parameters:
C
C     ireturn = ITLEN (string)
C
C        ireturn = the length of the string without trailing blanks
C         string = string to have trailing blanks removed from
C
C^
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Character string*(*)
      i=len(string)
   10 Continue
      If (string(i:i).NE.' ')Go To 15
      i=i-1
      If (i.LE.0)Go To 15
      Go To 10
   15 Continue
      itlen=i
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     ICTYPE - decides if a character is alphabetic, numeric, or other
C
C     ireturn = ICTYPE (C)
C
C            C = Single character (character*1)
C
C      ireturn =  1 , alpha (a-z,A-Z)
C              =  0 , digit (0-9)
C              = -1 , other
C
C      Called by: IGETTOK
C
C        Calls: none
C
C      Common: none
C-
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Integer Function ictype(c)
      Character*1 c,digits*10,abc*52
C
      digits='0123456789'
      abc='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'
C
      If (index(abc,c).GT.0) Then
         ictype=1
         Else If (index(digits,c).GT.0) Then
         ictype=0
         Else
         ictype=-1
         End If
      Return
      End
CS    USGS Function IRQUEST
C     Version: 1.0
C     Technical Contact: Richard W. Saltus
C     Release: not released
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     Function IRQUEST
C
C     Program purpose:
C         This function asks a question requiring a real number response.
C         It allows a default answer (if the user simply presses return).
C         The question is re-asked if a non-numeric answer is supplied.
C         The special character sequence "//" can be answered to indicate
C         a special condition.
C
C     Instructions for use:
C         This function should be called to ask all questions requiring decimal
C         numbers as answers.
C
      INTEGER FUNCTION IRQUEST(QUEST,RVAL,FORM,MODE)
C-
C
C     Variables and parameters:
C
C     ireturn = IRQUEST (quest,rval,form,mode)
C
C      ireturn =  -1 if '//' was given as response (user wants out)
C                  0 if no response (user took default)
C                  1 if user responded (returns response in aval)
C
C        quest =  Character string containing question to be asked
C                 (with no ? at the end, it is added by function)
C
C         rval =  Real variable to receive answer
C                 (used to pass default if one is available)
C
C         form =  Character string containing fortran format to be
C                 used to format the default contained in rval
C
C         mode =  Integer control parameter:
C
C            mode = 0, required response (no default allowed)
C            mode <>0, default allowed
C
C         Calls: ITLEN, GETANS
C^
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Character quest*(*),form*(*),rstr2*30
      Character*100 str,form2*10,ans*30,astr*30
      irquest=0
      iqlen=itlen(quest)
C
C     Format default for inclusion in question
C
      Write (rstr2,form)rval
      irlen=ideblank(rstr2)
      If (mode.NE.0) Then
C
C     If default allowed, insert it in question
C
         str=quest(1:iqlen)//' ['//rstr2(1:irlen)//']?'
         islen=iqlen+irlen+4
      Else
C
C        No default, just add '?' to question
C
         str=quest(1:iqlen)//'?'
         islen=iqlen+1
      End If
C
C     Construct format for printing the question
C
      Write (form2,105)islen
  105 Format ('(x,a',i3,',$)')
C
C     Repeats to here if question is re-asked
C
   13 Continue
C
C     call getans to obtain answer
C
      Call getans(str,form2,ans)
C
C      If getans is not used, the following statements will ask question
C
C      Write (6,form2)str
C      Read (5,110)ans
  110 Format (a30)
C
C     Check answer
C
      ialen=ideblank(ans)
      If (ialen.NE.0) Then
C
C        Got an answer
C
         If (ans.EQ.'//') Then
            irquest=-1
         Else
C
C           Convert answer to real number
C
            irquest=1
            Read (ans(1:ialen),120,err=25)rval
  120       Format (f20.0)
         End If
      Else
C
C        Didn't get an answer, if no default re-ask question
C
         If (mode.EQ.0)Go To 13
      End If
      Return
C
C     Couldn't convert the answer to a real number
C
   25 Continue
      Write (6,130)
  130 Format (' Please answer again, I''m expecting a number.')
      Go To 13
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     INTEGER FUNCTION INEXTVAL
C
C     ATTEMPTS TO DECODE NEXT ATOM INTO A REAL VARIABLE
C
C       iposition = INEXTVAL (BUF,RVAL,IERR)
C
C      iposition = The last position read in BUF + 1
C
C           BUF  = Character string to decode into real numbers
C
C          RVAL  = Real array to hold real numbers obtained
C
C           IERR = 1 - GOT A VALUE
C                  0 - GOT A VALUE, THEN HIT END OF STRING
C                 -1 - DECODE ERROR
C                 -2 - DIDN'T GET A VALUE, HIT END OF STRING
C
C
C-
      Integer Function inextval(buf,rval,ierr)
      Character*(*) buf
      iblen=len(buf)
C
C     LOCATE FIRST NON-BLANK CHARACTER
C
      lpos=1
      Do 10 i=1,iblen
   10 If (buf(i:i).NE.' ')Go To 20
C
C     FALLS OUT HERE IF ALL BLANK - END OF BUFFER
C
      ierr=-2
      inextval=0
      Return
C
C     FOUND A NON-BLANK CHARACTER, CHECK FOR ','
C
   20 Continue
      lpos=i
      If (buf(lpos:lpos).NE.',')Go To 30
C
C     EQUALS ',' - SO RETURN VALUE OF ZERO
C
      rval=0.
      ierr=1
      inextval=lpos+1
      Return
C
C     FIND END OF TOKEN
C
   30 Continue
      Do 40 i=lpos,iblen
   40 If ((buf(i:i).EQ.' ').OR.(buf(i:i).EQ.','))Go To 50
C
C     REACHED END OF STRING
C
      i=i+1
C
C     REACHED END OF TOKEN
C
   50 Continue
      irpos=i-1
C
C     DECODE TOKEN
C
      Read (buf(lpos:irpos),110,err=60)rval
  110 Format (f20.0)
C
C     SUCCESSFUL DECODE - NORMAL EXIT
C
      ierr=1
C
C     SET CORRECT POSITION - PAST NEXT COMMA, OR AT NEXT NON-BLANK
C
      Do 55 j=i,iblen
   55 If (buf(j:j).NE.' ')Go To 57
C
C     HIT END OF STRING
C
      ierr=0
      inextval=0
      Return
C
C     IF POINTING TO COMMA, ADVANCE BY ONE
C
   57 Continue
      inextval=j
      If (buf(j:j).EQ.',')inextval=j+1
      Return
C
C     UNABLE TO DECODE
C
   60 Continue
      ierr=-1
      inextval=0
      Return
      End
CS    USGS Function IIQUEST
C     Version: 1.0
C     Technical Contact: Richard W. Saltus
C     Release: not released
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     Function IIQUEST
C
C     Program purpose:
C         This function asks a question which requires an integer as response.
C         If a default is available, the user may take it by simply pressing
C         return. If a non-integer response is given, the question is re-asked.
C         Use of the special string "//" allows the user to signal the main
C         program (usually used to flag the end of a list or desire to exit
C         a program section).
C
C     Instructions for use:
C         This function should be used to ask all questions requiring integral
C         response.
C
      INTEGER FUNCTION IIQUEST(QUEST,IVAL,FORM,MODE)
C-
C
C     Variables and parameters:
C
C    IIQUEST - Asks a question with an integer answer
C
C     ireturn = IIQUEST (quest,ival,form,mode)
C
C      ireturn =  -1 if '//' was given as response (user wants out)
C                  0 if no response (user took default)
C                  1 if user responded (returns response in aval)
C
C        quest =  Character string containing question to be asked
C                 (with no ? at the end, it is added by function)
C
C         ival =  integer variable to receive answer
C                 (used to pass default if one is available)
C
C         form =  Character string containing fortran format to be
C                 used to format the default contained in ival
C
C         mode =  Integer control parameter:
C
C            mode = 0, required response (no default allowed)
C            mode <>0, default allowed
C
C         Calls: ITLEN, GETANS
C^
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Character quest*(*),form*(*),rstr2*30
      Character*100 str,form2*10,ans*30,astr*30
      iiquest=0
      iqlen=itlen(quest)
C
C     Format default for insertion into question
C
      Write (rstr2,form)ival
      irlen=ideblank(rstr2)
      If (mode.NE.0) Then
C
C        Construct question with default in brackets
C
         str=quest(1:iqlen)//' ['//rstr2(1:irlen)//']?'
         islen=iqlen+irlen+4
      Else
C
C        No default, add '?' to question
C
         str=quest(1:iqlen)//'?'
         islen=iqlen+1
      End If
C
C     Make fortran format for printing of question
C
      Write (form2,105)islen
  105 Format ('(x,a',i3,',$)')
C
C     Repeats to here if question is re-asked
C
   13 Continue
C
C     call getans to obtain answer
C
      Call getans(str,form2,ans)
C
C     If GETANS is not used, the following two statements will ask question
C
C      Write (6,form2)str
C      Read (5,110)ans
  110 Format (a30)
C
C     Check answer
C
      ialen=ideblank(ans)
      If (ialen.NE.0) Then
C
C        Got an answer
C
         If (ans.EQ.'//') Then
            iiquest=-1
         Else
C
C           Convert answer to an integer
C
            iiquest=1
            Read (ans(1:ialen),120,err=25)ival
  120       Format (i11)
         End If
      Else
C
C        Didn't get an answer, if no default ask question again
C
         If (mode.EQ.0)Go To 13
      End If
      Return
C
C     Couldn't decode, give error and ask question again
C
   25 Continue
      Write (6,130)
  130 Format (' Please answer again, I expect a number.')
      Go To 13
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     DOWNSHIFT - Converts uppercase to lowercase.
C               All non-uppercase characters unchanged.
C
C     CALL DOWNSHIFT(A)
C
C             A = A character string of any length
C
C-
      SUBROUTINE DOWNSHIFT(A)
      CHARACTER*(*) A,UP*(26),DOWN*(26)
      UP='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
      DOWN='abcdefghijklmnopqrstuvwxyz'
      ILEN=LEN(A)
      DO 10 I=1,ILEN
        INUM=INDEX(UP,A(I:I))
        IF (INUM.NE.0) A(I:I)=DOWN(INUM:INUM)
  10      CONTINUE
      RETURN
      END
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     UPSHIFT - Converts lowercase to uppercase.
C               All non-lowercase characters unchanged.
C
C     CALL UPSHIFT(A)
C
C             A = A character string of any length
C
C-
      SUBROUTINE UPSHIFT(A)
      CHARACTER*(*) A,UP*(26),DOWN*(26)
      UP='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
      DOWN='abcdefghijklmnopqrstuvwxyz'
      ILEN=LEN(A)
      DO 10 I=1,ILEN
        INUM=INDEX(DOWN,A(I:I))
        IF (INUM.NE.0) A(I:I)=UP(INUM:INUM)
  10      CONTINUE
      RETURN
      END
CS    USGS Function IAQUEST
C     Version: 1.0
C     Technical Contact: R. Saltus
C     Release: not released
C
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C     Function IAQUEST
C
C     Program purpose:
C         Asks a question requiring a character-string response.
C         Allows the use of a default answer and will optionally upshift the
C         response.
C
C     Instructions for use:
C         This subroutine should be called whenever a character-string response
C         is called for in a FORTRAN program.
C
      Integer Function iaquest(quest,aval,form,mode)
C-
C
C     Variables and parameters:
C     ireturn = IAQUEST (quest,aval,form,mode)
C
C      ireturn =  -1 if '//' was given as response (user wants out)
C                  0 if no response (user took default)
C                  1 if user responded (returns response in aval)
C
C        quest =  Character string containing question to be asked
C                 (with no ? at the end, it is added by function)
C
C         aval =  Character string to receive answer
C                 (used to pass default if one is available)
C
C         form =  Character string containing fortran format to be
C                 used to read the user response
C
C         mode =  Integer control parameter:
C
C              mode > 0, default allowed
C              mode = 0, no default allowed, DO NOT upshift response
C note: changed for UNIX, Vax version used to upshift on mode=0
C              mode < 0, default allowed, upshift response
C
C         Calls ITLEN, UPSHIFT, GETANS
C^
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      Character quest*(*),form*(*),aval*(*)
      Character*100 str,form2*10,ans*80,astr*30
      iaquest=0
      iqlen=itlen(quest)
      irlen=itlen(aval)
C
C     If response is to be upshifted, upshift default
C
      If (mode.LT.0)Call upshift(aval)
      If (irlen.EQ.0)irlen=1
C
C     Insert default answer into question
C
      If (mode.NE.0) Then
         str=quest(1:iqlen)//' ['//aval(1:irlen)//']?'
         islen=iqlen+irlen+4
      Else
         str=quest(1:iqlen)//'?'
         islen=iqlen+1
      End If
C
C     Construct fortran format for printing of question
C
      Write (form2,105)islen
  105 Format ('(x,a',i3,',$)')
C
C     Repeats to here if question is re-asked
C
   13 Continue
C
C     Call getans to obtain answer (allows multiple answers per line)
C
      Call getans(str,form2,ans)
C
C     If getans is not used, the following two statements ask question
C
C       Write (6,form2)str
C       Read (5,form)ans
C
C     Check answer
C
      ialen=31
      ialen=itlen(ans)
      If (ialen.NE.0) Then
C
C     got an answer
C
C     find first non-blank character
C
      do 5,ifirst=1,ialen
      if (ans(ifirst:ifirst).ne.' ') goto 6
   5  continue
   6  continue
      ans(1:ialen)=ans(ifirst:ialen)
         If (ans(ifirst:ialen).EQ.'//') Then
            iaquest=-1
         Else
            iaquest=1
C
C           Move answer into AVAL
C
            aval(1:len(aval))=ans(1:len(aval))
            If (mode.LT.0)Call upshift(aval)
         End If
      Else
C
C        Didn't get an answer, if no default ask question again
C
         If (mode.EQ.0)Go To 13
      End If
      Return
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
CS    Subroutine GETANS
C     Version: 1.0 (Unix F77) 3/87
C     Technical Contact: Richard W. Saltus
C     Release: not released
C
C     Subroutine GETANS
C
C     Program purpose:
C         This subroutine is called by IAQUEST, IIQUEST, and IRQUEST to
C         ask questions and get responses. It allows for buffering of
C         input, answers to multiple questions on a single line, echoing
C         of program dialog, or input of answers from a file.
C
C     GETANS - Reads next answer from saved command line,
C              prompts for new command line if old command line empty.
C              Answers in the command line are delimited by semi-colons.
C
C       GETANS recognizes the following special commands:
C
C              <filename - takes subsequent input from the file 'filename'
C                          NOTE: read on fortran unit 16
C              >filename - records questions and responses to 'filename'
C                          NOTE: written to fortran unit 17
C              >*        - echos questions and answers at terminal
C              ><        - stops recording
C              ><*       - stops echoing
C              #stuff#   - skips stuff between pound signs
C
C     Instructions for use:
C         Intended for use by the IxQUEST subroutines only.
C
       SUBROUTINE GETANS(QUEST,QFORM,ANS)
C-
C
C     Variables and parameters:
C
C
C     Call GETANS (quest, qform, ans)
C
C          quest = character variable, question to be asked
C
C          qform = character variable, fortran format for question
C
C          ans   = character variable to receive answer
C
C     Called by IIQUEST, IAQUEST, IRQUEST
C
C     Calls IGETTOK
C
C     Commons used : /GETCOM/ nextc, ifile, isfile, command
C
C^
C
      Character*(*) quest,qform,ans
      Common /getcom/nextc,ifile,isfile,command
      Character*(80) command,tok,form*40
      Logical asked,typed
C
C     initialize token
C
    1 Continue
      tok=' '
      lentok=0
      ic=len(command)
      it=len(tok)
      asked=.false.
      typed=.false.
C
C     If nothing in command line, ask question
C
    5 Continue
      If ((nextc.EQ.0).OR.(nextc.GT.ic)) Then
         If (ifile.EQ.0) Then
C
C        ask question at terminal
C
            asked=.true.
            typed=.true.
            Write (6,qform)quest
            Read (5,100)command
  100       Format (a80)
         Else
C
C        read command from file
C
            asked=.true.
         Read (ifile,100,End =99,err=99)command
      End If
      nextc=1
      End If
C
C     get a token from the command line
C
   10 Continue
      lenread=igettok(command(nextc:ic),tok(lentok+1:it),ierr,itype)
      nextc=lenread+nextc
      If (ierr.GE.0) Then
C
C     got a token
C
         If (tok(lentok+1:lentok+1).EQ.';') Then
C
C     got end of token
C
            If (nextc.GE.ic)nextc=0
         Else If (tok(lentok+1:lentok+1).EQ.'#') Then
C
C     skip over stuff between #'s in command line
C
            iskip=index(command(nextc:ic),'#')
            If (iskip.EQ.0) Then
C
C     skip rest of record
C
               nextc=0
               Go To 5
            Else
C
C     skip past next #
C
               nextc=nextc+iskip
               Go To 5
            End If
         Else
C
C     didn't get a ';' or a '#' - append new tok to old tok (reduce multiple
C                                 blanks to a single blank between tokens)
C
            newlen=itlen(tok(lentok+1:it))
            If (lenread.GT.newlen) Then
               newlen=newlen+1
               Do 20 icnt=newlen+lentok+1,lentok+1,-1
               itemp=icnt+1
               tok(itemp:itemp)=tok(icnt:icnt)
   20          continue
               tok(lentok+1:lentok+1)=' '
            End If
            lentok=lentok+newlen
            If (ierr.EQ.0) Then
C
C     hit end of command line
C
               nextc=0
            End If
C
C     keep reading command line
C
            Goto 10
         End If
      Else
C
C      didn't get a token (hit end of line)
C
         nextc=0
         If ((lentok.EQ.0).AND.(.NOT.asked))Goto 5
      End If
C
C      ready to return answer
C
      ans=' '
      If (lentok.GT.0) Then
         If (tok(1:1).EQ.'<') Then
C
C     open file for command reading
C
            If (ifile.NE.0)Close (ifile)
            Open (16,file=tok(2:lentok),form='formatted',
     &      status='old',err=98)
            ifile=16
            nextc=0
            Go To 1
         Else If (tok(1:1).EQ.'>') Then
            If (tok(2:2).EQ.'*') Then
C
C     set echo flag for command echoing at terminal
C
               iecho=1
            Else If (tok(2:2).EQ.'<') Then
               If (tok(3:3).EQ.'*') Then
C
C      turn off command echoing
C
                  iecho=0
               Else
C
C      close recording file
C
                  Close (isfile)
                  isfile=0
                  Go To 1
               End If
            Else
C
C     Open recording file
C
               If (isfile.NE.0)Close (isfile)
               Open (17,file=tok(2:lentok),form='formatted',status=
     &         'unknown',err=97)
               isfile=17
               Go To 1
            End If
         Else
C
C     pass answer back and quit
C
            ans=tok(1:lentok)
         End If
      End If
      If (isfile.NE.0) Then
C
C     record question and answer in recording file
C
         If (lentok.LE.0)tok(1:1)=' '
         ir=max(1,lentok)
         iq=itlen(quest)
         Write (form,103)iq,ir
  103    Format ('(x,a1,a',i2,',a1,a',i2,')')
         Write (isfile,form)'#',quest(1:iq),'#',tok(1:ir)
      End If
      If ((iecho.NE.0).AND.(.NOT.typed)) Then
C
C     Echo question and answer at terminal
C
         If (lentok.LE.0)tok(1:1)=' '
         ir=max(1,lentok)
         iq=itlen(quest)
         Write (form,104)iq,ir
  104    Format ('(x,a',i2,',x,a',i2,')')
         Write (6,form)quest(1:iq),tok(1:ir)
      End If
      Return
C
C     error on recording file open
C
   97 Continue
      If (lentok.GE.2) Then
         Write (form,105)lentok-1
  105    Format ('(x,a35,a',i2,')')
         Write (6,form)'Unable to open the recording file: ',
     &          tok(2:lentok)
      Else
         Write (6,106)
  106    Format ('No name specified for recording file.')
      End If
      Go To 1
C
C     error on command file open
C
   98 Continue
      If (lentok.GE.2) Then
         Write (form,110)lentok-1
         Write (6,form)'Unable to open the command file: ',
     &   tok(2:lentok)
  110    Format ('(x,a33,a',i2,')')
      Else
         Write (6,111)
  111    Format ('No name specified for command file.')
      End If
      Go To 1
C
C     hit end of command file
C
   99 Continue
      Close (ifile)
      ifile=0
      Go To 5
      End
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine symbl (xz, yz, ht, itext, angle, nz)
c     modified from larry baker symbol.
c
c call symbl (x,y,hgt,itext,angle,nc)
c
c      (x,y)  = starting coordinate of the text generation.
c      ht     = character height specification (inches).
c               if hgt <= 0.0, slant letters are used.
c               (^'s in the slant string turn slant on and off...)
c      itext  = alphanumeric text to be generated.
c      angle  = angle at which the character line is plotted.
c      nc     = number of characters to be plotted.
c               negative means plot string backwards starting from right end.
c
c               >  0 =  alpha text, number of characters to be plotted.
c
c
c
      dimension  xs(25), ys(25), ipen(25)
      character itext*(*)
      dimension  asin(5), acos(5)
c
      common /symbol0/  xo,yo,xc,yc,theta,fct,xa,ya

      data  radco/0.01745329/,fnn/999.0/,fctr/0.7/,facc/0.0/,theta/0.0/
      data  ancc/1.0/,ancs/0.0/,xt/0.0/,yt/0.0/
      data  msk4/15/,msk5/31/,msk8/255/,msk11/2047/,mskall/-1/
      data  kbit/8/,mskbit/255/,nchar/2/,nchrs/128/,epsil/0.0000277/
      data  asin(1)/0./,asin(2)/1./,asin(3)/0./,asin(4)/-1./,asin(5)/0./
      data  acos(1)/1./,acos(2)/0./,acos(3)/-1./,acos(4)/0./,acos(5)/1./
c
      common/isavepi/ isaveflag, isave, isaveb

      x = xz
      y = yz
      hgt=ht
      nc = abs(nz)
      div = 6.0

c...  Check for positioning instructions.
c       Need to add rotations.
      if (itext(1:2).eq.'\\c') then
        itext = itext(3:)
        lent = lentrue (itext)
        xoff = 0.5*hgt*lent
        x = x - xoff
      else if (itext(1:2).eq.'\\r') then
        itext = itext(3:)
        lent = lentrue (itext)
        xoff = hgt*lent
        x = x - xoff
      endif

c...  character text output
      fct = abs(hgt)/div

c...  new angle in this symbol call?
      if (angle .ne. theta) then
c...  calculate a new theta
      theta = angle
      ang = amod(angle,360.0)
      if (ang .lt. 0) ang = 360.0 - ang
      i = (ang + epsil)/90.0
      a = i * 90.0
      if (abs(ang-a) .le. epsil) then
        ancs = asin(i+1)
        ancc = acos(i+1)
      else
        ancc = theta * radco
        ancs = sin(ancc)
        ancc = cos(ancc)
      endif
      endif

      xoff=0.
      if(nz.lt.0)  xoff=xoff-6.0
      yoff=0.

      do 260 ind=1,nc

      k=ind
c     plot string backwards if nz is negative...
      if(nz.lt.0) k=nc+1-ind

      if(itext(k:k).eq.' ') goto 250
      if(itext(k:k).eq.'^'.and.ht.lt.0.0) then
c        leave a little extra space to accomodate slant...
        if(hgt.lt.0.0.and.nz.gt.0) then
          xoff=xoff+3.0
        else if(hgt.gt.0.and.nz.lt.0) then
          xoff=xoff-3.0
        endif
        hgt=-hgt
        goto 260
      endif

      nvd = ichar(itext(k:k))
c      print *, 'nvd=',nvd

      call chargen(xs,ys,ipen,num,nvd,ichrl)
c      do 210 i=1,num
c 210  print *, xs(i),ys(i),ipen(i)
c     fix lower case 'i' to make dot more separate...
      if(nvd.eq.ichar('i')) then
        ys(2)=3.5
        ys(3)=5.5
      endif

      do 240 i=1,num
      xt=0.7*fct*(xs(i) + xoff)
      yt=fct*(ys(i) + yoff)

c     negative hgt signifies slant letters...
c      if(hgt.lt.0)  xt=xt+0.2*yt
c      if(hgt.lt.0)  xt=xt+0.25*yt
c      if(hgt.lt.0)  xt=xt+0.3*yt
      if(hgt.lt.0)  xt=xt+0.4*yt

      if(theta.ne.0.0) then
        xtp=(ancc*xt - ancs*yt)
        ytp=(ancs*xt + ancc*yt)
        xt=xtp
        yt=ytp
      endif

      xt = x + xt
      yt = y + yt
      ic=ipen(i)+2
c      print *, '>>',xt,yt,ic

      call nxplot (xt,yt,ic)
 240  continue

 250  xoff=xoff+sign(6.0,real(nz))
      yoff=yoff+0.

 260  continue

      return
      end


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      SUBROUTINE CHARGEN(X,Y,IPEN,NXYC,ICHAR,ICHRL)
c     Borrowed from Ron Wahl plot package.
C
      DIMENSION X(1),Y(1),IPEN(1)
C
C  THE FOLLOWING CHARACTER CONSTANTS ARE GENERATED FOR
C  A 32 OR 36 BIT MACHINE WITH STANDARD ASCII CHARACTER
C  SET.
C
      DIMENSION ICODE(190),ICA(76),ICB(76),ICC(38),
     1  INDX(128)
C
      EQUIVALENCE (ICODE(1),ICA(1)),(ICODE(77),ICB(1)),
     1   (ICODE(153),ICC(1))
C
      DATA ICA/
     1    1797120,   58406463,  847319000,   34695604,
     2  953683920,  906230790,  820090744, 1068285446,
     3  856655768,  419377407,  913277339,  105979967,
     4  953828664,  575375524,  114823152,  503836720,
     5  895742065,  594277893,  469607644,  513465123,
     6  184399125,  942853674,  509867046,  206986040,
     7 1068110922,  167652043,  753051730,  972862755,
     8  673446733, 1068808824,  724011528,  946180045,
     9  441837914,  377083199,  764643157, 1068915118,
     1  414943112,  216050360,  558149612,  355547370,
     2  410749733,  383967807,  945411341,  428513305,
     3  155290303,  224029514,  628357644, 1066784678,
     4 1064912024, 1064978584,  311658329,  585282296,
     5  950845396,  274986589,  367363665,  285127423,
     6 1061230168,  541326216,  271411627, 1063380351,
     7  750151053,  251560457,  699020526,  553423904,
     8  167682726,  615421968, 1069081300,  699020490,
     9  506500128,  246976494,  270836991,  328116832,
     1  765027148,  405010668,  224029546, 1068643532/
      DATA ICB/
     1  324126419,  425788536,  476921809,  274957524,
     2  367363665, 1069070975,  213093002, 1060549247,
     3  750151053,  409437851,  203754047,  564840789,
     4  745616537,  950133311,  590346386,  138046316,
     5 1066314336,  220530729,  150919574,  547805582,
     6  948748232, 1067484078,  602071944,  698986443,
     7  372544544,  237239142,  786608888,  947982312,
     8  643532696,  541102783,  237239209,  333636280,
     9  673247208,  778625599,  674795496,  541106158,
     1  224029545,  641241033, 1059994413,  765854729,
     2  941938086,  237238810,  193907558,  167675640,
     3  598382608,  643355411,  947490797,  154925966,
     4 1069193232,  251586062, 1069156112,  674990984,
     5  786543551,  775681563,  277084680,  675019158,
     6  379192383,  949085503,  191624734, 1068285468,
     7  155322984,  615422098,  237236948,  730940152,
     8 1059391529,  186976297,  687782164,  345161262,
     9  696320587,  615424703,  541102804,  628708415,
     1  704525560,  338465824,  968067812, 1060190444/
      DATA ICC/
     1  338658184,  419334884, 1064951324,  982627641,
     2 1067081252,  741049224,  419332792,  942706654,
     3  945927435, 1067628827,  338658056,  285117156,
     4  345160288,  167576139,  615421968,  959677140,
     5  276996043,  730940105, 1068473144,  338658056,
     6  271055588,  189409888,  419346708, 1066487326,
     7  696320588,  218024504,  271842072,  150915099,
     8 1067503148,  753009676,  217921273,  553550380,
     9  493958809,  946442214,  423884700,  376817882,
     1  781542271,         63/
      DATA INDX/
     1    -1,   16,   33,   50,   82,   99,  144,  161,
     2   164,  193,  242,  259,  275,  291,   -1,   -1,
     3    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
     4   308,  340,  371,  416,  420,  452,  467,  496,
     5    -1,  514,  545,  592,  626,  673,  721,  755,
     6   784,  800,  816,  850,  867,  897,  900,  928,
     7   931,  961,  976,  996, 1028, 1044, 1088, 1122,
     8  1137, 1187, 1232, 1266, 1313, 1328, 1345, 1360,
     9  1393, 1441, 1459, 1504, 1524, 1554, 1584, 1602,
     1  1635, 1666, 1697, 1715, 1746, 1761, 1778, 1794,
     2  1826, 1856, 1891, 1924, 1970, 1987, 2016, 2020,
     3  2048, 2065, 2083, 2099, 2115, 2129, 2145, 2163,
     4    -1, 2192, 2227, 2272, 2292, 2337, 2369, 2388,
     5  2448, 2468, 2496, 2528, 2548, 2562, 2608, 2628,
     6  2660, 2706, 2752, 2771, 2804, 2832, 2852, 2867,
     7  2884, 2912, 2932, 2948, 2978, 2995, 3025,   -1/
C
      DATA NWPW/ 5/
C
c      I=IAND(ICHAR,255)
      i = mod (ichar, 256)
      NXY=INDX(I+1)
      IF (NXY.GT.0) GO TO 5
      ICHAR=0
      RETURN
    5 ICHRL=ICHAR
C
      IF (ICHAR.GT.255.AND.I.GT.23) GO TO 10
      ITA=0
      GO TO 20
   10 ITA=1
C
C  INITIALIZE
c   20 N=IAND(NXY,15)
   20 n = mod (nxy, 16)
      NXY=NXY/16
      IW=ICODE(NXY)
      IF (N.EQ.0) GO TO 40
      DO 30 I=1,N
        IW=IW/64
   30   CONTINUE
   40 I1=NWPW-N
      IP=1
      LZ=0
      N=0
      DO 120 J=1,15
        DO 110 I=1,I1
c          IXY=IAND(IW,63)
          ixy = mod (iw, 64)
          IF (IXY-56) 50,60,70
C
C  X-Y COORDINATE
   50     N=N+1
c          Y(N)=FLOAT(IAND(IXY,7)-LZ)
          y(n)=float(mod(ixy,8)-lz)
          X(N)=FLOAT(IXY/8)
          IF (ITA.NE.0) X(N)=X(N)+.333333*Y(N)
          IPEN(N)=IP
          IP=0
          GO TO 100
C
C  PEN DOWN CONDITION
   60     IP=1
          GO TO 100
C
C  OTHER CONTROLS
   70     IF (IXY-58) 80,90,130
C
C  LOWER ZONE
   80     LZ=6
          GO TO 100
C
C  UPPER ZONE
   90     LZ=0
C
  100       IW=IW/64
  110     CONTINUE
        NXY=NXY+1
        IW=ICODE(NXY)
        I1=NWPW
  120   CONTINUE
C
  130 NXYC=N
C
      RETURN
C
      END


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      integer function lentrue (string)
c     Gives position of last non-blank, non-tab, non-null character 
c     in a string.  Returns 0 if no such beast exists in the string.

      character*(*) string
      character*1 blank, tab, null
      parameter (blank=' ')

      tab=char(9)
      null=char(0)
      lentrue=0

      do 100 i=len(string),1,-1
        if (       string(i:i).ne.blank
     &       .and. string(i:i).ne.tab
     &       .and. string(i:i).ne.null) then
          lentrue=i
          return
        endif
 100  continue

      return
      end


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      real function xlengstr (string)

c     Calculates the length of a string in the existing Adobe font.
c      (For 1 inch high characters?)

      character string*(*)
      parameter (fudge = 1.5)

      nc = lentrue (string)

      call AFMBB (string, nc, xlow, ylow, xhi, yhi)

      xlengstr = fudge * (xhi - xlo)

      return
      end


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine centxt (x,y,ht,string,angle,lens)

c     Plots centered text.

      character*(*) string
      parameter (pi=3.1415927, deg2rad=0.17453293e-1, rad2deg=57.295779)

      xoff = ht * xlengstr (string)
c      print *, '  ** xoff =', xoff

      xs = x - 0.5*xoff*cos(angle*deg2rad)
      ys = y - 0.5*xoff*sin(angle*deg2rad)

      call symbol (xs,ys,ht,string,angle,lens)

      return
      end


