      program fppage
c
c     Version 1.3  -  March 10, 1988
c
c     Purpose:       Plot earthquake ray polarities and fault planes on a lower hemisphere equal area projection.
c                    Makes multiple plots per page.
c
c     Input file:    A file of the type "*.pol", which is generated by the program "Fpfit" (see "Fpfit, Fpplot, and Fppage: Fortran
c                    computer programs for calculating and displaying earthquake fault-plane solutions,
c                    by P. Reasenberg and D. Oppenheimer, U.S. Geological Survey Open-File Rep. 85-739)
c
c     Required routines: Calcomp style plot routines plots, plot, newpen, symbol.
c
c     Output:        Graphic output only
c
c     Authors:       Paul Reasenberg and David Oppenheimer, U.S.G.S. in Menlo Park.  Some of the routines
c                    were adopted from code written by John Lahr, Bruce Julian, and Fred Klein.
c

      real              ain                             
c                                                       ! ray angle of incidence
      real              azm                             
c                                                       ! ray azimuth
      real              cx                              
c                                                       ! x position of stereo net center
      real              cxmax                           
c                                                       ! greatest x position in plot
      real              cy                              
c                                                       ! y position of stereo net center
      real              da1                             
c                                                       ! dip angle of principle plane
      real              da2                             
c                                                       ! dip angle of auxilliary plane
      character*11      datef                           
c                                                       ! requested event date and origin time
      character*11      datei                           
c                                                       ! scratch variable for event date and origin time
      real              dd1                             
c                                                       ! dip direction of principle plane
      real              dd2                             
c                                                       ! dip direction of auxilliary plane
      character*1       disc                            
c                                                       ! flag: if "*" then first motion discrepant with solution
      real              dist                            
c                                                       ! epicentral distance
      real              dx                              
c                                                       ! incremental x position between beachballs
      real              dy                              
c                                                       ! incremental y position between beachballs
      character*132     eventf                          
c                                                       ! hypo71 summary card from .fps file
      character*132     eventi                          
c                                                       ! hypo71 summary card from .pol file
      character*50      filfps                          
c                                                       ! file name of .fps file
      character*50      filnam                          
c                                                       ! file name of data
      integer           funit                           
c                                                       ! logical unit ".fps" file
      character*1       head                            
c                                                       ! header flag: n=plot event number, d=event date
      real              hite                            
c                                                       ! height of event #
      integer           i                               
c                                                       ! loop index over number of lines of nearby solutions
      integer           iday                            
c                                                       ! day
      integer           ihr                             
c                                                       ! hour
      integer           iline                           
c                                                       ! input line number
      integer           imin                            
c                                                       ! minute
      integer           imo                             
c                                                       ! month
      integer           ios                             
c                                                       ! io status descriptor
      integer           iunit                           
c                                                       ! logical unit ".pol" file
      integer           iyr                             
c                                                       ! year
      character*40      line                            
c                                                       ! scratch variable for plot output
      character*40      line1                           
c                                                       ! scratch variable for plot output
      character*40      line2                           
c                                                       ! scratch variable for plot output
      character*1       mult                            
c                                                       ! flag: y(n)=do (not) plot multiple solutions
      integer           mxevnt                          
c                                                       ! maximum number of events per page
      integer           mxplot                          
c                                                       ! maximum number of events to plot
      character*4       name                            
c                                                       ! station name
      integer           nchar                           
c                                                       ! number of characters to be plotted
      integer           nev                             
c                                                       ! event number
      logical           new                             
c                                                       ! flag: true prior to initializing plot software
      integer           nlabel                          
c                                                       ! current event label number
      integer           nskip                           
c                                                       ! number of events to skip
      integer           num                             
c                                                       ! number of events plotted in a frame
      integer           numtot                          
c                                                       ! total number of events plotted
      integer           ny                              
c                                                       ! number of beachballs in y direction
      character*1       option                          
c                                                       ! plot option
      integer           ounit                           
c                                                       ! logical unit for output (0 for UNIX, 6 for VMS)
      real              pi                              
c                                                       ! pi
      character*1       pltpol                          
c                                                       ! flag: y(n)=do (not) plot first motion data
      integer           pls                             
c                                                       ! 0(1)=plot +(solid circle for compressional symbol)
      character*4       prmk                            
c                                                       ! first motion description (eg. ipu0)
      logical           proces                          
c                                                       ! t(f)=plot this mechanism
      real              rad                             
c                                                       ! pi/180
      real              rmax1                           
c                                                       ! radius of stereo net
      real              rmax2                           
c                                                       ! radius of first motion symbol
      real              sa1                             
c                                                       ! rake of auxilliary plane
      real              sa2                             
c                                                       ! rake of auxilliary plane
      character*1       star                            
c                                                       ! multiple indicator
      character*1       sym                             
c                                                       ! first motion direction
      character*80      title                           
c                                                       ! data set descriptor
      real              wt                              
c                                                       ! weight assigned to pick quality in program fpfit
      real              xpos                            
c                                                       ! x plot position
      real              ypage                           
c                                                       ! y page height
      real              ypos                            
c                                                       ! y plot position
c
      parameter (iunit = 9, funit = 10, ounit = 0)
      parameter (hite = 0.135, mxevnt = 48, rmax1 = 0.4, rmax2 = .0585,
     & ypage = 8.0)
      new = .true.
      pi = atan(1.0)*4.0
      rad = pi/180.0
      dy = rmax1*3
      ny = ypage/dy
      dx = dy
c
c  interrogate user for input
c
10    filnam = 'none'
      call askc ('Enter name of ".pol" file:  ', filnam)
      if (filnam .ne. 'none') open (iunit, file = filnam, status =
     & 'old', blank = 'zero', iostat = ios)
      if (ios .ne. 0 .or. filnam .eq. 'none') then
        write (ounit, '(a)') 'Error opening file - try again'
        goto 10
      end if
      write (ounit, '(a)') ' '
      write (ounit, '(1x, a)')  'Menu of plot options'
      write (ounit, '(1x, a)') 
     & 'a = plot sequential mechanisms in .pol file'
      write (ounit, '(1x, a)')  'f = request mechanisms from .fps file'
      write (ounit, '(a)') ' '
20    option = 'a'
      call askc ('Enter option:  ', option)
      if (option .ne. 'a' .and. option .ne. 'f') then
        write (ounit, 30) '**** Unknown option; please try again ****'
30      format (//, a, /)
        goto 20
      else if (option .eq. 'a') then
40      nskip = 0
        nskip = jask ('Enter number of mechanisms to skip (including'//
     & ' multiple solutions):  ', nskip)
        if (nskip .lt. 0) then
          write (ounit, 30) '**** Invalid number; try again ****'
          goto 40
        end if
50      mxplot = 0
        mxplot = jask ('Enter number of mechanisms to plot (0=all):  ',
     & mxplot)
        if (mxplot .lt. 0) then
          write (ounit, '(a)') '**** Invalid number; try again ****'
          goto 50
        end if
      else if (option .eq. 'f') then
60      filfps = 'none'
        call askc ('Enter name of ".fps" file:  ', filfps)
        if (filfps .ne. 'none') then
          open (funit, file = filfps, status = 'old', blank
     & = 'zero', iostat = ios)
        end if
        if (ios .ne. 0 .or. filfps .eq. 'none') then
          write (ounit, '(a)') 'Error opening file - try again'
        goto 60
        end if
      end if
70    head = 'd'
      call askc ('Plot event headers as numbers (n) or dates (d)?  ',
     & head)
      if (head .ne. 'd' .and. head .ne. 'n') then
        write (ounit, '(a)') 
     & '**** Please answer "d" or "n"; try again ****'
        goto 70
      end if
80    mult = 'y'
      call askc ('Plot multiple solutions (y or n)?  ', mult)
      if (mult .ne. 'y' .and. mult .ne. 'n') then
        write (ounit, '(a)')
     & '**** Please answer "y" or "n"; try again ****'
        goto 80
      end if
90    pltpol = 'y'
      call askc ('Plot first motion data (y or n)?  ', pltpol)
      if (pltpol .ne. 'y' .and. pltpol .ne. 'n') then
        write (ounit, '(a)')
     & '**** Please answer "y" or "n"; try again ****'
        goto 90
      else if (pltpol .eq. 'y') then
94      pls = 0
        pls = jask ('Plot compression symbol as "+" (=0) or solid cir'//
     & 'cle (=1)?  ', pls)
        if (pls .ne. 0 .and. pls .ne. 1) then
          write (ounit,'(a)')
     & '**** Please enter "0" or "1"; try again ****'
          goto 94
        end if
      end if
c
c initialize plot program
c
      if (new) then
        call plots (0., 0., 0)
        call plot (.5, .1, -3)
	new = .false.
      end if
c
c read title
c
      nlabel = 0
      nev = 0
      num = 0
      numtot = 0
      cxmax = 0.
      read (iunit, 95, err = 2000) title
95    format (a)
      iline = 1
      if (option .eq. 'f') then
        proces = .true.
      else
        proces = .false.
      end if
c
c  read event, but first find out which event to plot
c
100   if (option .eq. 'f' .and. proces) then
        read (funit, 95, end = 1010) eventf
        read (eventf, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
        write (datef, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
      end if
      iline = iline + 1
      read (iunit, 95, end = 1000, err = 2000) eventi
      nev = nev + 1
      if (option .eq. 'f') then
        read (eventi, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
        write (datei, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
      end if
105   if (option .eq. 'a' .and. nev .gt. nskip) then
        proces = .true.
      else if (option .eq. 'f') then
        if (datei .eq. datef) then
          proces = .true.
        else if (datei .gt. datef) then
          write (ounit, 110)  eventf(1:11)
110       format (/, '**** Requested event: ', a, ' not found ****')
          read (funit, 95, end = 1010) eventf
          read (eventf, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
          write (datef, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
          goto 105
        else
          proces = .false.
        end if
      end if
c
c  plot this event
c
      read (eventi, 120, err = 2000) dd1, da1, sa1, star
120   format (t81, f4.0, f3.0, f4.0, t129, a1)
      if (proces .and. (mult .eq. 'y' .or. 
     & (mult .eq. 'n' .and. star .eq.' '))) then
        if (star .eq. ' ') nlabel = nlabel + 1  
        num = num + 1
        numtot = numtot + 1
c
c stop if more than mxplot events
c
        if (mxplot .gt. 0 .and. numtot .gt. mxplot) then
          goto 1000
        end if
c
c end plot frame if more than mxevnt events
c
        if (num .gt. mxevnt) then
          num = 1
          call plot (0., 0., -999)
          call plot (.5, .1, -3)
          call newpen (2)
        end if
        cy = ypage - dy*float(mod(num - 1, ny)) - rmax1*3.0
        cx = rmax1 + dx*float((num - 1)/ny )
        if (mod(num - 1, ny) .eq. 0) cxmax = cxmax + dx
        xpos = cx - rmax1 + .10
        ypos = cy + rmax1 + .20
        if (head .eq. 'n') then
          if (nlabel .lt. 10) then
            nchar = 2
            write (line, '(i1, a1)') nlabel, star
          else if (nlabel .ge. 10 .and. nlabel .lt. 100) then
            nchar = 3
            write (line, '(i2, a1)') nlabel, star
          else
            nchar = 4
            write (line, '(i3, a1)') nlabel, star
          end if
          call symbol (xpos, ypos, hite, line, 0., nchar)
c          call symbol (xpos, ypos, hite, %ref(line), 0., nchar)	! VMS version
        else
          write (line1, '(a11, a1)') eventi(1:11), star
          nchar = 12
          call symbol (xpos, ypos, hite*.50, line1, 0., nchar)
c          call symbol (xpos, ypos, hite*.50, %ref(line1), 0., nchar)	! VMS version
          write (line2, 130) eventi(39:43), eventi(46:50)
130       format ('Z=', a5, '  M=', a5)
          nchar = 16
          call symbol (xpos, ypos-hite*.65, hite*.40, line2,
     & 0., nchar)
c          call symbol (xpos, ypos-hite*.65, hite*.40, %ref(line2),	! VMS version
c     & 0., nchar)							! VMS version
        end if
c
c plot stereo net perimeters
c
        call strnt1 (cx, cy, rad, rmax1)
c
c plot nodal planes and "p" and "t" axes
c
        call plotpl (cx, cy, da1, pi, rad, rmax1, dd1 - 90.)
        call auxpln (dd1, da1, sa1, dd2, da2, sa2)
        call plotpl (cx, cy, da2, pi, rad, rmax1, dd2 - 90.)
        call tpplt1 (cx, cy, da1, dd1, rmax2*1.5, pi, pltpol, rad,
     & rmax1, sa1, 1.0)
      end if
c
c  skip the auxilliary solutions
c
140   iline = iline + 1
      read (iunit, 95) line
      if (line(1:4) .eq. 'P-AX' .or. line(1:4) .eq. 'T-AX') goto 140
c
c read phase card
c
150   iline = iline + 1
      read (iunit, 160, end = 1000, err = 2000) name, dist, azm, ain,
     & prmk, wt, disc
160   format (a4, 3f6.1, 3x, a4, f5.2, 2x, a1)
      if (name .ne. '    ') then
        if (proces .and. ((mult .eq. 'n' .and. star .eq.
     &  ' ') .or. mult .eq. 'y') .and. (pltpol .eq. 'y')) then
c
c plot first motion
c
          if (prmk(3:3) .eq. 'U' .or. prmk(3:3) .eq. '+'
     & .or. prmk(3:3) .eq. 'C') then
            sym = 'C'
          else
            sym = 'D'
          end if
          call pltsm1 (ain, azm, cx, cy, rmax2, '    ', pi, rad,
     & rmax1, sym, 1.0, pls)
        end if
        goto 150
      end if
      goto 100
c
c end of file
c
1000  call plot (0., 0., -998)
      indx = 1
      do 1004 i = 50, 1, -1
        if (filnam(i:i) .ne. ' ') then
          indx = i
          goto 1005
        end if
1004  continue
1005  write (ounit, 1006) filnam(1:indx)
1006  format (//,'End of file ', a, ' reached', /)
1009  filnam = 'stop'
      call askc ('Enter name of next ".pol" file ("stop" to stop):  ',
     & filnam)
      if (filnam .eq. 'stop') then
        goto 1010
      else
        close (iunit)
        open (iunit, file = filnam, status = 'old', blank
     & = 'zero', iostat = ios)
        if (ios .ne. 0) then
          write (ounit, '(a)') 'Error opening file - try again'
          goto 1009
        else
          proces = .false.
          read (iunit, 95, err = 2000) title
          iline = 1
          goto 100
        end if
      end if
1010  call plot (0., 0., 999)
      if (mod(numtot, mxevnt) .eq. 0) then
        write (ounit, 1015) numtot/mxevnt
1015    format ('Total number of plot pages =', i3)
      else
        write (ounit, 1015) numtot/mxevnt + 1
      end if
      close (iunit)
      close (funit)
      stop
c
c  read error
c
2000  write (ounit, '(a, i7)') 'Read error on line', iline
      stop
      end
