      program fpplot
c
c     version 1.5  -  September 9, 1993
c
c     Purpose:       Plot earthquake ray polarities and fault planes on a lower hemisphere equal area projection.
c
c     Input file:    A file of the type "*.pol", which is generated by the program "Fpfit" (see "Fpfit, Fpplot, and Fppage: Fortran
c                    computer programs for calculating and displaying earthquake fault-plane solutions,
c                    by P. Reasenberg and D. Oppenheimer, U.S. Geological Survey Open-File Rep. 85-739)
c
c     Required routines: Calcomp style plot routines plots, plot, newpen, symbol.
c
c     Output:        Graphic output only
c
c     Authors:       Paul Reasenberg and David Oppenheimer, U.S.G.S. in Menlo Park.  Some of the routines
c                    were adopted from code written by John Lahr, Bruce Julian, and Fred Klein.
c
c     revisions:     5/29/86 - Ability to select events by sequence number or date added
c     revisions:     9/09/93 - Ability to colorize plot, make headers intelligible, add filename, date, strike/dip/rake on beachball
c
      implicit none
c
      real              ain                             
c                                                       ! ray angle of incidence
      character*1       ansc                            
c                                                       ! flag: y(n)=do (not) plot color beach balls
      character*1       ansd                            
c                                                       ! flag: y(n)=do (not) plot discrepancy report
      character*1       ansn                            
c                                                       ! flag: y(n)=do (not) plot station names adjacent to first motions
      character*1       ansp                            
c                                                       ! flag: y(n)=do (not) plot current mechanism
      character*1       answ                            
c                                                       ! flag: y(n)=do (not) plot symbol size and names proportional to weight
      real              azm                             
c                                                       ! ray azimuth
      real              cx1                             
c                                                       ! x position of large circle center
      real              cx2                             
c                                                       ! x position of small circle center
      real              cy1                             
c                                                       ! y position of large circle center
      real              cy2                             
c                                                       ! y position of small circle center
      real              da1                             
c                                                       ! dip angle of principal plane
      real              da2                             
c                                                       ! dip angle of auxilliary plane
      character*11      date                            
c                                                       ! requested event date and origin time
      character*11      date1                           
c                                                       ! scratch variable for event date and origin time
      real              dd1                             
c                                                       ! dip direction of principal plane
      real              dd2                             
c                                                       ! dip direction of auxilliary plane
      character*1       disc                            
c                                                       ! flag: if "*" then first motion discrepant with solution
      real              dist                            
c                                                       ! epicentral distance
      character*132     event                           
c                                                       ! hypo71 summary card
      character*50	filnam
c                                                       ! file name of data
      logical           first                           
c                                                       ! flag: true prior to plotting discrepant first motion
      integer           funit                           
c                                                       ! logical unit ".fps" file
      real              hite1                           
c                                                       ! height of p,t symbol in large circle
      real              hite2                           
c                                                       ! height of p,t symbol in small circle, dscrpncy rprt
      real              hite3                           
c                                                       ! height of title, extended summary card, first motion legend
      integer           i                               
c                                                       ! loop index over number of lines of nearby solutions
      integer           iday                            
c                                                       ! day
      integer           ihr                             
c                                                       ! hour
      integer           iline                           
c                                                       ! current line #
      integer           imin                            
c                                                       ! minute
      integer           imo                             
c                                                       ! month
      integer           indx                            
c                                                       ! character position of first blank in title
      integer           ios                             
c                                                       ! i/o status descriptor
      integer           iunit                           
c                                                       ! logical unit ".pol" file
      integer           iyr                             
c                                                       ! year
      integer           iwt                             
c							! reading quality
      integer		jask
c							! function
      character*125     line                            
c                                                       ! scratch variable for plot output
      character*4       name                            
c                                                       ! station name
      integer           n                               
c                                                       ! loop index over number of nearby solutions
      integer           ncfrm
c                                                       ! frame pen color
      integer           ncup
c                                                       ! up pen color
      integer           ncdwn
c                                                       ! down pen color
      integer           ndisc
c							! number of reported discrepant observations                             
      integer           ndiscm
c							! maximum number of reported discrepant observations                             
      integer           nev                             
c                                                       ! event number
      logical           new                             
c                                                       ! flag: true prior to initializing plot software
      integer           nskip                           
c                                                       ! number of solutions to skip
      integer           num                             
c                                                       ! requested event number
      character*1       option                          
c                                                       ! plot option
      integer           ounit
c                                                       ! logical unit for output 
      real              pi                              
c                                                       ! pi
      character*4       prmk                            
c                                                       ! first motion description (eg. ipu0)
      logical           proces                          
c                                                       ! t(f)=plot this mechanism
      real              rad                             
c                                                       ! pi/180
      real              rmax1                           
c                                                       ! radius of large circle
      real              rmax2                           
c                                                       ! radius of small circle
      real              sa1                             
c                                                       ! rake of principal plane
      real              sa2                             
c                                                       ! rake of auxilliary plane
      character*1       sym                             
c                                                       ! first motion direction
      character*80      title                           
c                                                       ! data set descriptor
      real              wt                              
c                                                       ! plotting weight 
      real              xpos1                           
c                                                       ! leftmost x position of title, summary card, symbol legend
      real              xpos2                           
c                                                       ! leftmost x position of discrepancy report
      real              ypos                            
c                                                       ! y plot position
      real              ypos1                           
c                                                       ! y plot position of title
      real              ypos2                           
c                                                       ! y plot position of symbol legend
      real              ypos3                           
c                                                       ! y plot position of top of discrepancy report

      parameter (iunit = 9, funit = 10, ndiscm = 36)
      parameter (cx1 = 4.00, cx2 = 8.8, cy1 = 3.20, cy2 = 1.05)
      parameter (hite1 = 0.2, hite2 = 0.07, hite3 = 0.1, rmax1 = 2.95)
      parameter (rmax2 = 0.80, xpos1 = 0.1, xpos2 = 8.0)
      parameter (ypos1 = 7.2, ypos2 = 0.1, ypos3 = 6.0)
      parameter (ounit = 0)
c      parameter (ounit = 6)							! VAX/VMS version
      pi = atan(1.0)*4.0
      rad = pi/180.0
      new = .true.
c
c  get user input
c
      call intero (iunit, ansn, answ, ansd, ansc, ncfrm, ncup,
     1 ncdwn, option, nskip, funit, date, filnam)
c
c read hypo71 header card (first line in model file)
c
74    nev = 0
      iline = 1
      read (iunit, 75, err = 2000) title
75    format (a)
      indx = 1
      do 80 i = 1, 80
      if (title(i:i) .ne. ' ') then
        indx = i
        goto 90
      end if
80    continue
90    title = title(indx:len(title))
c
c initialize plot program
c
      if (new) then
        call plots (0., 0., 0)
        call plot (0., 0., -999)
	if (ansc .eq. 'y') call newpen (ncfrm)
        new = .false.
      end if
c
c read next event
c
        ansp = 'y'
        proces = .true.
c
c  but first find out which event to plot
c
100     if ((option .eq. 'd' .and. proces) .or.
     & (option .eq. 'd' .and. ansp .eq. 'n')) then
c          call plot (0., 0., -999)
105       call askc ('Enter date & origin time or "stop"::  ', date)
          if (date .eq. 'stop') goto 1010
          read (date, '(3i2, 1x, 2i2)', iostat =ios) iyr, imo, iday,
     & ihr, imin
          if (ios .ne. 0) then
            write (ounit,106) '**** Invalid date; please try again ****'
106	    format (//, 1x, a, /)
            goto 105
          end if
          write (date, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
          ansp = 'y'
        else if (option .eq. 'n' .and. proces) then
110       num = nev + 1
c          call plot (0., 0., -999)
          num = jask ('Enter sequence number (0 to stop):  ', num)
          if (num .eq. 0) then
            goto  1010
          else if (num .le. nev) then
            write (ounit, 106) 
     & '**** Requested # must be greater than current event # ****'
            goto 110
          end if
        else if (option .eq. 'f' .and. proces) then
          read (funit, '(3i2, 1x, 2i2)', end = 1010) iyr, imo, iday,
     & ihr, imin
          write (date, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
        end if
        iline = iline + 1
c
c  read extended summary card
c
        read (iunit, 120, end = 1000, err = 2000) event
120     format (a132)
        nev = nev + 1
        if (option .eq. 'd' .or. option .eq. 'f') then
          read (event, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
          write (date1, '(3i2, 1x, 2i2)') iyr, imo, iday, ihr, imin
        end if
        if (option .eq. 'a' .and. nev .gt. nskip) then
          proces = .true.
        else if ((option .eq. 'd' .or. option .eq. 'f') .and. 
     & date1 .eq. date) then
          proces = .true.
        else if (option .eq. 'f' .and. date1 .gt. date) then
          write (ounit, 106) 
     & '**** Requested event not found; current date is: '//event(1:11)
     &//' ****'
          proces = .false.
        else if (option .eq. 'd' .and. date1 .gt. date) then
          write (ounit, 106) 
     & '**** Requested event not found; current date is: '//event(1:11)
     &//' ****'
          date = date1
130       ansp = 'y'
          call askc ('Do you want to plot this event (y or n)?  ', ansp)
          if ((ansp .ne. 'y' .and. ansp .ne. 'n') .or. ios .ne. 0) then
            write (ounit, '(a)') 
     & '**** Please answer "y" or "n"; try again ****'
            goto 130
          else if (ansp .eq. 'y') then
            proces = .true.
          else
            proces = .false.
          end if
        else if (option .eq. 'n' .and. nev .eq. num) then
          proces = .true.
        else
          proces = .false.
        end if
c
c  plot this event
c
        if (proces) then
c           call plot (0.2, .5, -3)
          first = .true.
          if (ansc .eq. 'n') call newpen (1)
          read (event, 140) dd1, da1, sa1
140       format (t81, f4.0, f3.0, f4.0)
c
c plot summary card information, nets, and explanation of symbols
c
	  call pltnet (xpos1, ypos1, ansc, hite3, event, hite2, pi,
     & ncfrm, ncdwn, cx1, cx2, cy1, cy2, rmax1, rmax2, ncup, iunit)
c
c plot nodal planes
c
          call plotpl (cx1, cy1, da1, pi, rad, rmax1, dd1 - 90.)
          call auxpln (dd1, da1, sa1, dd2, da2, sa2)
          call plotpl (cx1, cy1, da2, pi, rad, rmax1, dd2 - 90.)
c
c  plot "p" and "t" axes in big net
c
          name = '    '
          wt = 1.0
          if (ansc .eq. 'n') call newpen (3)
          call tpplot (cx1, cy1, da1, dd1, hite1, pi, rad, rmax1, sa1,
     & wt)
c
c plot the p and t axes in small net corresponding to the set of "neighboring solutions"
c
          call tpplot (cx2, cy2, da1, dd1, hite2, pi, rad, rmax2, sa1,
     & wt)
          if (ansc .eq. 'n') call newpen (1)
        end if
c
c  now read the auxilliary solutions
c
150     iline = iline + 1
        read (iunit, '(a)') line
        if (line(1:4) .eq. 'P-AX' .or. line(1:4) .eq. 'T-AX') then
          if (proces) then
            if (line(1:4) .eq. 'P-AX') then
              sym = 'P'
            else
              sym = 'T'
            end if
            do 160 n = 1, 24
              indx = 5 + (n - 1)*5
              if (line(indx:indx + 5) .eq. '     ') then
                goto 150
              else
                read (line(indx:indx + 5), '(f3.0, f2.0)') azm, ain
                call pltsym (ain, azm, cx2, cy2, hite2, name, pi, rad,
     & rmax2, sym, wt)
              end if
160         continue
          end if
          goto 150
        end if
c
c read phase cards
c
	ndisc = 0
180     iline = iline + 1
        read (iunit, 190, end = 1000, err = 2000) name, dist, azm, ain,
     & prmk, iwt, disc
190     format (a4, 3f6.1, 3x, a4, t29, i1, t37, a1)
	if (dist .gt. 999.) dist = 999.
	wt = 1. - 0.25*float(iwt)
        if (name .ne. '    ') then
c
c report discrepant observations
c
          if (proces) then
            if (disc .eq. '*' .and. ansd .eq. 'y') then
              if (first) then
                line(1:23) = 'DISCREPANT OBSERVATIONS'
                ypos = ypos3
                call symbol (xpos2 + .15, ypos, hite2, line, 0., 23)
c                call symbol (xpos2, ypos, hite2, %ref(line), 0., 23)		! VAX/VMS version
                ypos = ypos - hite2*1.5
                line(1:4) = 'STAT'
	        call symbol (xpos2, ypos, hite2, line, 0., 4) 
c	        call symbol (xpos2, ypos, hite2, %ref(line), 0., 4) 			! VAX/VMS version
	        line(1:3) = 'DIST'
	        call symbol (xpos2 + 0.4, ypos, hite2, line, 0., 4) 
c	        call symbol (xpos2 + 0.4, ypos, hite2, %ref(line), 0.,4) 		! VAX/VMS version
	        line(1:3) = 'AZM'
	        call symbol (xpos2 + 0.8, ypos, hite2, line, 0., 3) 
c	        call symbol (xpos2 + 0.8, ypos, hite2, %ref(line), 0.,3) 		! VAX/VMS version
	        line(1:3) = 'AIN'
	        call symbol (xpos2 + 1.15, ypos, hite2, line, 0., 3) 
c	        call symbol (xpos2 + 1.15, ypos, hite2, %ref(line),0.,3) 		! VAX/VMS version
	        line(1:4) = 'PRMK'
	        call symbol (xpos2 + 1.5, ypos, hite2, line, 0., 4) 
c	        call symbol (xpos2 + 1.5, ypos, hite2, %ref(line), 0.,4) 		! VAX/VMS version
                ypos = ypos - hite2*.5
	        call plot (xpos2, ypos, 3)
	        call plot (xpos2 + 1.75, ypos, 2)
                ypos = ypos - hite2*1.5
                first = .false.
              end if
	      ndisc = ndisc + 1
              if (ndisc .lt. ndiscm) then
	        call symbol (xpos2, ypos, hite2, name, 0., 4)
c	        call symbol (xpos2, ypos, hite2, %ref(name), 0., 4)		! VAX/VMS version
	        write (line, '(i4)') nint(dist)
	        call symbol (xpos2 + 0.4, ypos, hite2, line, 0., 4) 
c	        call symbol (xpos2 + 0.4, ypos, hite2, %ref(line), 0., 4) 	! VAX/VMS version
	        write (line, '(i3)') nint(azm)
	        call symbol (xpos2 + 0.8, ypos, hite2, line, 0., 3) 
c	        call symbol (xpos2 + 0.8, ypos, hite2, %ref(line), 0., 3) 	! VAX/VMS version
	        write (line, '(i3)') nint(ain)
	        call symbol (xpos2 + 1.15, ypos, hite2, line, 0., 3) 
c	        call symbol (xpos2 + 1.15, ypos, hite2, %ref(line), 0., 3) 	! VAX/VMS version
	        call symbol (xpos2 + 1.5, ypos, hite2, prmk, 0., 4) 
c	        call symbol (xpos2 + 1.5, ypos, hite2, %ref(prmk), 0., 4) 	! VAX/VMS version
                ypos = ypos - hite2*1.5
	      endif
	   
c
c plot first motions
c
            end if
            if (ansn .eq. 'n') name = '    '
            if (prmk(3:3) .eq. 'U' .or. prmk(3:3) .eq. '+' .or.
     & prmk(3:3) .eq. 'C') then
              sym = 'C'
	      if (ansc .eq. 'y') call newpen (ncup)
            else
              sym = 'D'
	      if (ansc .eq. 'y') call newpen (ncdwn)
            end if
            if (answ .eq. 'n') wt = 1.
            call pltsym (ain, azm, cx1, cy1, hite1, name, pi, rad,
     & rmax1, sym, wt)
	    if (ansc .eq. 'y') call newpen(ncfrm)
          end if
          goto 180
        end if
        if (proces) then
          call auxpln (dd1, da1, sa1, dd2, da2, sa2)
	  call pltsol (dd1, da1, sa1, pi, rmax1, cx1, cy1, hite3)
	  call pltsol (dd2, da2, sa2, pi, rmax1, cx1, cy1, hite3)
	  if (ndisc .ge. ndiscm) then
	    write (line, 200) ndisc - ndiscm
200	    format ('+ ', i3, ' MORE DISCREPANT PHASES')
            ypos = ypos - hite2*1.5
	    call symbol (xpos2, ypos, hite2, line, 0., 28) 
c	    call symbol (xpos2, ypos, hite2, %ref(line), 0., 28) 	! VAX/VMS version
	  end if
	  call plot (0., 0., -999)
	end if
      goto 100
c
c end of file; close up shop
c
1000  indx = 1
      do 1004 i = 50, 1, -1
      if (filnam(i:i) .ne. ' ') then
        indx = i
        goto 1005
      end if
1004  continue
1005  write (ounit, 106) 'End of file '//filnam(1:indx)//' reached'
1009  filnam = 'stop'
      call askc ('Enter name of next ".pol" file ("stop" to stop):  ',
     & filnam)
      if (filnam .eq. 'stop') then
        goto 1010
      else
	close (iunit)
        open (iunit, file = filnam, status = 'old', blank
     & = 'zero', iostat = ios)
        if (ios .ne. 0) then
          write (ounit, '(a)') 'Error opening file - try again'
          goto 1009
        else
          goto 74
        end if
      end if
1010  call plot (0., 0., +999)
      close (iunit)
      close (funit)
      stop
c
c read error
c
2000  write (ounit, '(a, i6)') 'Read error on line ', iline
      stop
      end
