       program mktable
c
c     purpose:       create table from extented summary cards which have both fault planes plus p&t axes orientation
c
c     input file:    .fps file
c

      real              da1                             
c							! dip angle of first plane
      real              da2                             
c							! dip angle of second plane
      real              dd1                             
c							! dip direction of first plane
      real              dd2                             
c							! dip direction of second plane
      character*33      event                           
c							! part of hypo71 summary card
      character*50      filnam                          
c							! file name of data
      character*1	flag				
c							! output option flag
      integer           idate                           
c							! event date
      integer           ihr                             
c							! event hour
      integer           isec                            
c							! event whole second 
      integer           min                             
c							! event minute
      integer           nobs                            
c							! number of first motion observations
      integer           num                             
c							! summary card counter
      real              pain                            
c							! angle of incidence of p axis
      real              paz                             
c							! azimuth of p axis
      real              pi                              
c							! pi
      real              rad                             
c							! pi/180
      real              sa1                             
c							! rake of first plane
      real              sa2                             
c							! rake of second plane
      real              sec                             
c							! event second remainder
      real              tain                            
c							! angle of incidence of t axis
      real              taz                             
c							! azimuth of t axis

      pi = atan(1.0)*4.0
      rad = pi/180.0
c
      filnam = 'data.fps'
10    call askc ('enter name of "fps" file', filnam)
      open (unit = 2, file = filnam, err = 10, status = 'old', blank =
     & 'zero')
      filnam = 'fps.table'
      call askc ('enter name of output file', filnam)
      open (unit = 3, file = filnam, status = 'unknown', blank =
     * 'zero')
      flag = 's'
15    call askc ('output downdip direction (d) or strike (s)?', flag)
      if (flag .ne. 's' .and. flag .ne. 'd') goto 15
      if (flag .eq. 's') then
        write (3, 20) ('-', i = 1, 111)
20      format('   # YRMODA HRMN:SECND LATITUDE LONGITUDE  DEPTH    ',
     1 'MAG    # FM     PLANE 1     PLANE 2     P-AXIS      T-AXIS', /,
     2 t67, 'STRK  DIP   STRK  DIP    AZM PLNG    AZM PLNG', /, 111a1)
      else
        write (3, 25) ('-', i = 1, 111)
25      format('   # YRMODA HRMN:SECND LATITUDE LONGITUDE  DEPTH    ',
     1 'MAG    # FM     PLANE 1     PLANE 2     P-AXIS      T-AXIS', /,
     2 t67, ' DDR  DIP    DDR  DIP    AZM PLNG    AZM PLNG', /, 111a1)
      end if
      num = 0
c
c read event 
c
60	if (num .lt. 9999) num = num + 1
        read (2, 70, end = 1000) idate, ihr, min, sec, event, dd1, da1,
     & sa1, nobs
70      format (i6, 1x, 2i2, f6.2, a33, t81, f4.0, f3.0, f4.0, 7x, i3)
	isec = int(sec)
	sec = sec - float(isec)
c
c compute nodal planes
c
        call auxpln (dd1, da1, sa1, dd2, da2, sa2)
c
c  compute "p" and "t" axes 
c
        call tandp (pain, tain, paz, taz, da1, da2, dd1, dd2, sa1, sa2,
     & pi, rad)
c
c  write out table
c
	if (flag .eq. 's') then
	  dd1 = dd1 - 90.
	  if (dd1 .lt. 0.) dd1 = dd1 + 360.
          dd2 = dd2 - 90. 
          if (dd2 .lt. 0.) dd2 = dd2 + 360.
	end if
        write(3, 80) num, idate, ihr, min, isec, sec, event, nobs,
     & nint(dd1), nint(da1), nint(dd2), nint(da2), nint(paz),
     & nint(90. - pain), nint(taz), nint(90. - tain)
80      format (i4, 1x, i6, 1x, 2i2.2, ':', i2.2, f3.2, a33, 5x, i3,
     & 4(2x, 2i5))
      goto 60
c
c end of file
c
1000  close (2)
      close (3)
      stop
      end
