      subroutine params (mxqual, mxstat, ddelc, ddelf, del0c, del1c,
     & distmx, dlamc, dlamf, dpdr0c, dpdr1c, dphic, dphif, erate,
     & filnm1, filnm2, filnm3, filnm4, filnm5, filnm6, fmagmn, iamwt,
     & ifin, infmt, ittl, irep, kilsta, lopen2, lopen3, lopen4, minobs,
     & nkil, nrev, ounit, revsta, title, xlam0c, xlam1c, icmp, ainmin,
     & ainmax, resmax, ibst, idate)

c lists current parameter settings on unit ounit

      integer           mxqual                          
c							! (input) maximum # of qualities permitted
      integer           mxstat                          
c							! (input) maximum # of stations permitted
      real              ainmax                          
c							! (input) maximum permitted angle of incidence
      real              ainmin                          
c							! (input) minimum permitted angle of incidence
      real              ddelc                           
c							! (input) fault dip increment in degrees for coarse search
      real              ddelf                           
c							! (input) fault dip increment in degrees for fine search
      real              del0c                           
c							! (input) minimum value of coarse search dip range in degrees
      real              del1c                           
c							! (input) maximum value of coarse search dip range in degrees
      real              distmx                          
c							! (input) maximum permitted epicentral distance
      real              dlamc                           
c							! (input) fault rake increment in degrees for coarse search
      real              dlamf                           
c							! (input) fault rake increment in degrees for fine search
      real              dpdr0c                          
c							! (input) minimum value of coarse search dip direction range in degrees
      real              dpdr1c                          
c							! (input) maximum value of coarse search dip direction range in degrees
      real              dphic                           
c							! (input) fault strike increment in degrees for coarse search
      real              dphif                           
c							! (input) fault strike increment in degrees for fine search
      real              erate(mxqual)                   
c							! (input) assumed weighted error rates for data, read from control card
      character*40      filnm1                          
c							! (input) name of report output file
      character*40      filnm2                          
c							! (input) name of extended summary output file
      character*40      filnm3                          
c							! (input) name of solution output file
      character*40      filnm4                          
c							! (input) name of fit function output file
      character*40      filnm5                          
c							! (input) name of hypo input file
      character*40      filnm6                          
c							! (input) name of control file
      real              fmagmn                          
c							! (input) minimum permitted magnitude
      integer           iamwt                           
c							! (input) flag controling amplitude weighting (0=omit, 1=use)
      integer           ibst                            
c							! (input) flag: 0(1)=do(not) calculate multiple solutions 
      integer           icmp                            
c							! (input) flag: 1(0)=do (not) composite data into one mechanism
      integer           idate(mxstat,2)                 
c							! (input) date range of station reversal; 0=>open-ended
      integer           ifin                            
c							! (input) flag: 1(0)=do (not) limit fine search to coarse search range
      integer           infmt                           
c							! (input) input file format : 1=hypo71, 2=hypoinverse, 3=hypoellipse
                                                        
c							!                              4=hypoinverse with shadow card
      integer           irep                            
c							! (input) flag: 1(0)=do(not) report each fps to terminal when computed 
      integer           ittl                            
c							! (input) title option: 0=no title
      character*4       kilsta(mxstat)                  
c							! (input) ignored station names
      logical           lopen2                          
c							! (input) t if sunit open
      logical           lopen3                          
c							! (input) t if punit open
      logical           lopen4                          
c							! (input) t if funit open
      integer           minobs                          
c							! (input) minimum number of observations required
      integer           nkil                            
c							! (input) number of ignored stations
      integer           nrev                            
c							! (input) number of reversed stations
      integer           ounit                           
c							! (input) output unit #
      real              resmax                          
c							! (input) maximum permitted p-residual
      character*4       revsta(mxstat)                  
c							! (input) reversed station names
      character*(*)     title                           
c							! (input) output title
      real              xlam0c                          
c							! (input) minimum value of coarse search rake range in degrees
      real              xlam1c                          
c							! (input) maximum value of coarse search rake range in degrees

      integer           i                              
c							! loop index
      integer           ifor1                          
c							! format statement label
      integer           ifor2                          
c							! format statement label
      integer           ifor3                          
c							! format statement label
      integer           ifor4                          
c							! format statement label
      integer           ifor5                          
c							! format statement label
      integer           leng                           
c							! function

      if (ounit .eq. 6) then
        assign 100 to ifor1
        assign 200 to ifor2
        assign 300 to ifor3
        assign 400 to ifor4
        assign 450 to ifor5
      else
        assign 500 to ifor1
        assign 600 to ifor2
        assign 700 to ifor3
        assign 800 to ifor4
        assign 850 to ifor5
      end if
c
c if not writing out to save file, print a header
c
      if (ounit .eq. 8) then 
        write (ounit, *) ' parameter settings for fpfit'
        write (ounit, *) ' -----------------------------'
      end if
      write (ounit, ifor4) 'ttl', ittl, title(1:leng(title))
      write (ounit, ifor1) 'hyp', filnm5(1:leng(filnm5))
      write (ounit, ifor1) 'out', filnm1(1:leng(filnm1))
      if (lopen2) write (ounit, ifor1) 'sum', filnm2(1:leng(filnm2))
      if (lopen3) write (ounit, ifor1) 'pol', filnm3(1:leng(filnm3))
      if (lopen4) write (ounit, ifor1) 'fit', filnm4(1:leng(filnm4))
      if (ounit .ne. 18) write (ounit, ifor1) 'jmp', 
     &filnm6(1:leng(filnm6))
      write (ounit, ifor2) 'for', infmt
      write (ounit, ifor3) 'mag', fmagmn
      write (ounit, ifor2) 'obs', minobs
      write (ounit, ifor3) 'dis', distmx
      write (ounit, ifor3) 'res', resmax
      write (ounit, ifor3) 'ain', ainmin, ainmax
      write (ounit, ifor2) 'amp', iamwt
      write (ounit, ifor2) 'bst', ibst
      write (ounit, ifor2) 'fin', ifin
      write (ounit, ifor2) 'rep', irep
      write (ounit, ifor2) 'cmp', icmp
      write (ounit, ifor3) 'hnd', (erate(i), i = 1, mxqual/2)
      write (ounit, ifor3) 'mac', (erate(i), i = mxqual/2 + 1, mxqual)
      write (ounit, ifor3) 'dir', dpdr0c, dpdr1c, dphic, dphif
      write (ounit, ifor3) 'dip', del0c, del1c, ddelc, ddelf
      write (ounit, ifor3) 'rak', xlam0c, xlam1c, dlamc, dlamf
      if (ounit .eq. 6 .and. (nkil .gt. 0 .or. nrev .gt. 0)) then
        write (6, '(/, $, a)') ' hit carriage return to continue'
        read (5, '(i)', err = 5) i
      end if
5     if (nkil .gt. 0) then
        do 10 i = 1, nkil
          write (ounit, ifor4) 'kil', i, kilsta(i)
10      continue
      end if
      if (nrev .gt. 0) then
        do 20 i = 1, nrev
          write (ounit, ifor5) 'rev', i, revsta(i), idate(i, 1),
     & idate(i, 2)
20      continue
      end if
100   format (1x, a3, 1x, '''', a, '''')
200   format (1x, a3, 1x, i3)
300   format (1x, a3, 1x, 4g11.4)
400   format (1x, a3, 1x, i3, 1x, '''', a, '''')
450   format (1x, a3, 1x, i3, 1x, '''', a, '''', 2(1x, i6))
500   format (a3, 1x, '''', a, '''')
600   format (a3, 1x, i3)
700   format (a3, 1x, 4g11.4)
800   format (a3, 1x, i3, 1x, '''', a, '''')
850   format (a3, 1x, i3, 1x, '''', a, '''', 2(1x, i6))
      return
      end
