      subroutine rdeq2 (ain, ainmin, ainmax, az, dist, distmx, eunit, 
     & event, fmagmn, iunit, kilsta, minobs, mxqual, mxstat,
     & nkil, nr, nrev, pobs, prcntx, prmk, resmax, revsta, sigmaf, stn,
     & sumwt, weight, wtobs, icmp, idate, infmt, evntid, src)
c
c reads hypoinverse archive file. returns summary card and corresponding phase first motions, qualitites, angles of incidence,
c station names, and azimuths.  calculates standard deviation (sigmaf) of fit from estimated standard deviations of the data.
c the estimated data errors are control-file inputs; corresponding data weights are calculated in main and passed to this
c routine in the parameter "weight".
c
      integer           mxqual                          
c							! (input) maximum # of qualities permitted
      integer           mxstat                          
c							! (input) maximum # of stations permitted
      real              ain(mxstat)                     
c							! (output) ray incidence angles
      real              ainmax                          
c							! (input) maximum permitted angle of incidence
      real              ainmin                          
c							! (input) minimum permitted angle of incidence
      real              az(mxstat)                      
c							! (output) ray azimuth angles (corresponding to ain)
      real              dist(mxstat)                    
c							! (output) epicentral distance
      real              distmx                          
c							! (input) maximum permitted epicentral distance
      integer           eunit                           
c							! (input) logical unit # of output of error messages
      character*80      event                           
c							! (output) summary card
      integer           evntid                           
c                                                       ! event id #
      real              fmagmn                          
c							! (input) minimum permitted magnitude
      integer           icmp                            
c							! (input) 1(0)=do (not) composite data into one mechanism; ievp on output
      integer           idate(mxstat,2)                 
c							! (input) date range of station reversal; 0=>open-ended
      integer           infmt                           
c							! (input) input file format : 1=hypo71, 2=hypoinverse, 3=hypoellipse
                                                        
c							!                              4=hypoinverse with shadow card
      integer           iunit                           
c							! (input) logical unit # of hypo71 listing file (input file)
      character*4       kilsta(mxstat)                  
c							! (input) ignored station names
      integer           minobs                          
c							! (input) minimum number of observations required
      integer           nkil                            
c							! (input) number of ignored stations
      integer           nr                              
c							! (output) -1=eof, 0=skip event, nr>0 => number of stations
      integer           nrev                            
c							! (input) number of reversed stations
      real              pobs(mxstat)                    
c							! (output) observed first motion polarities; .5=compression, -.5=dilatation
      real              prcntx                          
c							! (output) % of stations that are machine picked
      character*4       prmk(mxstat)                    
c							! (output) first motion description (eg. ipu0)
      real              resmax                          
c							! (input) maximum permitted p-residual
      character*4       revsta(mxstat)                  
c							! (input) reversed station names
      real              sigmaf                          
c							! (output) calculated standard deviation of fit based on data errors
      character*1       src(mxstat)
c							! data source code
      character*4       stn(mxstat)                     
c							! (output) station names
      real              sumwt                           
c							! (output) sum of observed first motion weights
      real              weight(mxqual)                  
c							! (input) weights associated with qualities
      real              wtobs(mxstat)                   
c							! (input) observed first motions weights
c
      real		amag1
c							! secondary magnitude 
      real		amag2
c							! secondary magnitude
      character*1	bstflg
c							! magnitude designator for bstmag
      real		bstmag
c							! best magnitude
      character*1	cm(4)
c							! magnitude designator
      character*1	cm1
c							! secondary magnitude label on summary card
      character*1	cm2
c							! secondary magnitude label on summary card
      real              dep                             
c							! hypocenter depth (not used)
      real              dmin                            
c							! distance to nearest station (not used)
      real              erh                             
c							! horizontal error (not used)
      real              erz                             
c							! vertical error (not used)
      character*128     evline                          
c							! line for reading event summary
      logical           first                           
c							! flag: t=first time into routine
      character*1       fm                              
c							! first motion direction (u, d, +, -)
      real              fmag                            
c							! event magnitude
      integer           i                               
c							! dummy loop index
      integer           ic                              
c							! number of characters in summary card
      integer           igap                            
c							! gap (not used)
      integer           ihm                             
c							! origin hour (not used)
      integer           ios                             
c							! iostat error
      integer           ipwt                            
c							! qualiity assigned to p arrival
      integer           j                               
c							! dummy loop index
      integer           jdate                           
c							! date of event
      integer           jdate1                           
c							! year of event
      integer           jdate2                           
c							! month of event
      integer           jdate3                           
c							! day of event
      integer           jwt                             
c							! index for data weight
      integer           k                               
c							! counter of good phase readings
      integer           lat                             
c							! origin latitude (not used)
      character*94      line                            
c							! line of hypoinverse station data
      integer           lon                             
c							! origin longitude (not used)
      integer           mpref(4)
c							! preference order of 4 magnitudes (USGS ML, UCB ML, coda, xmag)
      integer           nclas(20)                       
c							! number of observations in each data class
      integer           nsp                             
c							! number of stations (not used)
      real              pres                            
c							! traveltime residual
      real              rms                             
c							! location rms (not used)
      real              sec                             
c							! origin second (not used)
      character*1       shdo                            
c							! shadow card
      real              tmag(4)
c							! array of 4 potential magnitudes on summary card                            
      real              varf                            
c							! calculated variance in fit based on data errors.
      real              varf1                           
c							! summation of number of observations
      real              varf2                           
c							! summation of number of observations per class x corresponding weight
      real              wt                              
c							! weight assigned to p arrival
      real              xlat                            
c							! epicentral latitude (not used)
      real              xlon                            
c							! epicentral longitude (not used)
      real              xmag                            
c							! amplitude magnitude
c
      data first/.true./
      data cm/'C', 'A', 'B', 'L'/
      data mpref/4, 3, 1, 2/
      save first, nclas
c
c reset values
c
      if (icmp .eq. 0 .or. (icmp .eq. 1 .and. first)) then
        do 10 i = 1, mxqual
          nclas(i) = 0
10      continue
        prcntx = 0.
        sumwt = 0.
        first = .false.
      end if
      evline = ' '
c
c read summary card (skip non-summary cards)
c
20      read (iunit, 30, end = 1000) evline
30      format (a)
        if (infmt .eq. 4) read (iunit, 30, end = 1000) shdo
        ic = ichar (evline(1:1))
        if (ic .lt. 48 .or. ic .gt. 57) goto 20
        read (evline, 40) jdate1, jdate2, jdate3, xmag, fmag, cm1, 
     & amag1, cm2, amag2
40	format (3i2, t35, f2.1, t68, f2.1, t115, a1, f3.2, 3x, a1, f3.2)
        jdate = jdate1*10000 + jdate2*100 + jdate3
c
c Choose magnitude from preference list. Search down the list of mags in
c the preferred order until a non-zero magnitude is found.
	tmag(3) = 0
	tmag(4) = 0
c
c Find the Berkeley & local mag if present
c
	if (cm1 .eq. 'B') tmag(3) = amag1
	if (cm1 .eq. 'L') tmag(4) = amag1
	if (cm2 .eq. 'B') tmag(3) = amag2
	if (cm2 .eq. 'L') tmag(4) = amag2
c
c Assemble preference list
c
	tmag(1) = fmag
	tmag(2) = xmag
c
c The preferred mag is the first non-zero one
c
	do 45 i = 1,4
	  bstmag = tmag(mpref(i))
	  if (bstmag .gt. 0.) then
	    bstflg = cm(mpref(i))
	    goto 46
	  end if
45	continue
46      if (bstmag .lt. fmagmn) then
          if (icmp .eq. 0) nr = 0
          return
        end if
c
c get the phase data
c
        if (icmp .eq. 0) then
          k = 1
        else
          k = nr + 1
        end if
50      stn(k) = '    '
        read (iunit, 60, end = 70) line
60      format (a)
        if (infmt .eq. 4) read (iunit, 60, end = 70) shdo
        read (line, '(a4)') stn(k)
c
c check for end of phase data
c
70      if (stn(k) .eq. '    ') then
c
c end of event
c
          if (k - 1 .ge. minobs .or. (icmp .eq. 1 .and. k .gt. 1)) then
c
c reformat summary record into standard hypo71 summary format
c
            if (icmp .eq. 0 .or. (icmp .eq. 1 .and. nr .eq. 0)) then
              read (evline, 75, iostat = ios) ihm, sec, lat,
     & xlat, lon, xlon, dep, nsp, igap, dmin, rms, erh, erz
75            format (6x, i4, f4.2, i2, 1x, f4.2, i3, 1x, f4.2, f5.2,
     & 2x, i3, i3, f3.0, f4.2, 31x, 2f4.2)
              write (event, 76) jdate, ihm, sec, lat, xlat, lon, xlon,
     & dep, bstmag, nsp, igap, dmin, rms, erh, erz, bstflg
76            format (i6, 1x, i4, 1x, f5.2, i3, '-', f5.2, i4, '-',
     & f5.2, 2f7.2, i3, i4, f5.1, f5.2, 2f5.1, t80, a1)
            end if
            nr = k - 1
            prcntx = prcntx/float(nr)
            varf1 = 0.
            varf2 = 0.
            do 80 jwt = 1, mxqual
              varf1 = varf1 + nclas(jwt)
              varf2 = varf2 + nclas(jwt)*weight(jwt)
80          continue
            varf  = varf1/(varf2*varf2)
            sigmaf= sqrt(varf)
	    read (line, '(t63, i10)') evntid
          else if (icmp .eq. 0) then
            nr = 0
          end if
          return
        end if
c
c ignore this station?
c
        if (nkil .gt. 0) then
          do 90  i = 1, nkil
            if (stn(k) .eq. kilsta(i)) goto 50
90        continue
        end if
c
c  so far, so good: now check phase card for polarity, distance, quality
c
        read (line, 100) prmk(k), pres, dist(k), ain(k), az(k), src(k)
100     format (4x, a4, t25, f4.2, t59, f4.1, f3.0, t76, f3.0, t92, a1)
        read (prmk(k), '(2x, a1, i1)') fm, ipwt
        if (fm .ne. 'U' .and. fm .ne. 'D' .and. fm .ne. '+' .and.
     & fm .ne. '-' .and. fm .ne. 'C') goto 50
        if (dist(k) .gt. distmx) goto 50
        if (ain(k) .lt. ainmin .or. ain(k) .gt. ainmax) goto 50
        if (abs(pres) .gt. resmax) goto 50
        if (dist(k) .eq. 0.) then
          write (eunit, 105) stn(k), evline(1:14)
105       format (' ', '***** ', a4,
     & ' ignored due to zero distance for event:', a14, ' *****')
          goto 50
        end if
        if (ipwt .ge. mxqual/2) then
          wt = 0.
        else if (src(k) .eq. 'R' .or. src(k) .eq. 'P' .or. 
     & src(k) .eq. 'O') then
          jwt = ipwt + mxqual/2 + 1
          wt = weight(jwt)
          if (wt .ne. 0.) prcntx = prcntx + 1.
        else
          jwt = ipwt + 1
          wt = weight(jwt)
        end if
        if (wt .eq. 0.) goto 50
c
c check for repeated phase card
c
        if (k .gt. 2 .and. icmp .eq. 0) then
          do 120 j = 1, k - 1
            if (stn(k) .eq. stn(j)) then
              write (eunit, 110) stn(k), evline(1:14)
110            format (' ', '***** error: ', a4,
     & ' has multiple phase cards for event:', a14, ' *****')
              goto 50
            end if
120       continue
        end if
c
c flip polariites if station is designated as reversed
c
        do 130 i = 1, nrev
          if (stn(k) .eq. revsta(i) .and. jdate .ge. idate(i, 1) .and.
     & (idate(i, 2) .eq. 0 .or. jdate .le. idate(i, 2))) then
            if (fm .eq. 'U') prmk(k)(3:3) = 'D'
            if (fm .eq. 'C') prmk(k)(3:3) = 'D'
            if (fm .eq. 'D') prmk(k)(3:3) = 'U'
            if (fm .eq. '+') prmk(k)(3:3) = '-'
            if (fm .eq. '-') prmk(k)(3:3) = '+'
            fm = prmk(k)(3:3)
          end if
130     continue
c
        nclas(jwt) = nclas(jwt) + 1
        wtobs(k) = wt
        sumwt = sumwt + wt
        if (fm .eq. 'U' .or. fm .eq. '+' .or. fm .eq. 'C') then
          pobs(k) = .5
        else
          pobs(k) = -.5
        end if
c
c increment k and check number against array dimensions
c
        k = k + 1
        if (k .gt. mxstat) then
          write (eunit, *) '***** readeq error: number of stations re'//
     & 'adings exceeds ', mxstat, 'for event:', evline(1:14), ' *****'
          if (nr .gt. minobs) then
            nr = k - 1
            prcntx = prcntx/float(nr)
          else
            nr = 0
          end if
          return
        end if
c
c read another phase
c
        goto 50
c
c end of file
c
1000  nr = -1
      return
      end
