	program rfdis
c
c	Reads a .POL file, spits out discrepant station list with
c	ability to choose, solution NFM, epicentral distance, and
c	theoretical radiation amplitude
c
	character*1 axis, title
	character*132 l1
	character*42 l2
	character*1 c1
	character*42 filnam
	integer jask
	real askr
	filnam = 'none'
1	call askc ('POL filename?', filnam)
	open (2, file =filnam, status ='old', err = 1)
	filnam = 'rfdis.out'
	call askc ('Output filename?', filnam)
	open (3, file = filnam, status = 'unknown')
	nfmmin = 50
2	nfmmin = jask ('Minimum # of first-motion readings?', nfmmin)
	if (nfmmin .lt. 15) goto 2
	dismax = 100.
3	dismax = askr ('Maximum distance?', dismax)
	if (dismax .lt. 1.) goto 3
	mxqual = 1
4	mxqual = jask ('Maximum reading quality?', mxqual)
	if (mxqual .lt. 0 .or. mxqual .gt. 3) goto 4
	prdmin = 0.65
	prdmin = askr ('Minimum P-radiation amplitude?', prdmin)
	read (2, '(a)', end = 100) title
50	read (2, '(a)', end = 100) l1
	c1 = l1(1:1)
	read (l1, '(t99, i3)') nfm
60	read (2, '(a1)') axis
	if (axis .ne. ' ') goto 60
70	read (2, '(a)') l2
	if (l2(1:1) .ne. ' ') then
	  if (nfm .ge. nfmmin .and. l2(26:26) .ne. 'X' .and.
     & l2(26:26) .ne. 'Y' .and. l2(26:26) .ne. 'Z') then
	    read (l2, '(t6, f5.1, t29, i1, t39, f4.2)') dis, iqual, prad
	    if (prad .ge. prdmin .and. dis .le. dismax .and.
     & iqual .le. mxqual) then
	      write (3,10) 
     & l2(1:4)//l2(26:29)//l1(1:6)//l1(8:11)//l2(37:37)
10	      format (a)
	    end if
	  end if
	  goto 70
	else
	  goto 50
	end if
100	close(2)
	close(3)
	stop
	end
