	subroutine pltsol (dd, da, sa, pi, rmax1, cx1, cy1, hite)
c
c     Plot focal mechanism solution parameters
c                                                       ! ray azimuth
      real              cx1                             
c                                                       ! x position of large circle center
      real              cy1                             
c                                                       ! y position of large circle center
      real              da                             
c                                                       ! dip angle 
      real              dd                             
c                                                       ! strike
      real              hite                           
c                                                       ! height of string
      real              pi                              
c                                                       ! pi
      real              rmax1                           
c                                                       ! radius of large circle
      real              sa                             
c                                                       ! rake 
      character*80      string                           
c                                                       ! dummy string
      real              xs                           
c                                                       ! x position of string
      real              ys                            
c                                                       ! y position of string

        dd = dd - 90.
        if (dd .lt. 0.) dd = dd + 360.
        idd = nint(dd)
        ida = nint(da)
        isa = nint(sa)
	xs = rmax1*cos((90. - dd)*pi/180.)
	ys = rmax1*sin((90. - dd)*pi/180.)
	if (xs .lt. 0.) then
	  xs = cx1 + xs - 1.3
	else
	  xs = cx1 + xs +.04*rmax1
	end if
	if (ys .lt. 0.) then
	  ys = cy1 + ys - .04*rmax1 - hite
	else
	  ys = cy1 + ys + .04*rmax1
	end if
	write (string, 990) idd,ida,isa
990	format ('(', i3, ',', i2, ',', i4, ')') 
	call symbol (xs, ys, hite, string, 0., len(string))
	return
	end
