	program zdstrib
c	zdstrib reads an extended hypo71 summary card , prompts for the minimum permitted hypocentral separation
c	between events, and outputs a subset summary file (dstrib.dat) satisfying separation criteria

	parameter (mxstat = 5000)

	real x(mxstat), y(mxstat), z(mxstat)
	character * 132 sumcrd
	character *41 file
	pio180 = 4.0*atan(1.0)/180.

1	write (6, 2) 'enter file name of extended summary cards:  '
2	format ('$', a)
	read 5, file
5	format(a)
	open (2, file = file, status = 'old', err = 1)
	write (6, 2) 'enter name of output file:  '
	read 5, file
	open (1, file = file, status = 'unknown')

	write (6, 2) 'enter dmin:  '
	read *, dmin
	write (6, 2) 'enter minimum stdr ratio (0-1):  '
	read *, ratio
	num = 1
10	read (2, 20, end = 100) sumcrd
20	format (a132)
	read (sumcrd, 30) dlatdg, dlatmn, dlondg, dlonmn, depth, stdr
30	format (18x, f2.0, 1x, f5.2, 1x, f3.0, 1x, f5.2, 2x, f5.2, t108,
     & f5.1)
	if (stdr .lt. ratio) then
	  goto 10
	else
	  dlatdg = (dlatdg + dlatmn/60.)*pio180
	  dlatdg = ggtogc(dlatdg)
	  dlondg = -(dlondg + dlonmn/60.)*pio180
	  if (num .eq. 1) call refpt(dlatdg, dlondg)
	  call delaz (dlatdg, dlondg, delta, azm, bazm, xpos, ypos)
	  if (num .gt. 1) then
	    do 40 i = 1, num - 1
	      dist = sqrt( (x(i) - xpos)**2 + (y(i) - ypos)**2 + (z(i) -
     & depth)**2)
	      if (dist .le. dmin) goto 10
40	    continue
	  end if
	  x(num) = xpos
	  y(num) = ypos
	  z(num) = depth
	  write (1, 20) sumcrd
	  num = num + 1
	  if (num .gt. mxstat) then
	    print *, '***** number of earthquakes exceeds ', mxstat,
     1 ' *****'
	    stop
	  end if
	  goto 10
	end if

100	close (2)
	close (1)
	stop
	end
