library(FPF)

stafile = "hengil_sta.LLZ"
velfile = "krafla.vel"
rev.file = "hengill.REV"
SENSORfile = 'hengill.sensors'



SENSOR =  getSENSORfile(SENSORfile)
 FOCPLOTPARAMS <<-   list(fkind=0, PLANES=TRUE, SEIS=FALSE,NAME=TRUE, POINTS=TRUE,  PT=TRUE,
           NET=TRUE,TIT=TRUE,  MECUP=TRUE)


data(HENG)

pfile=HENG$pickfile


A = getpfile(pfile, stafile=stafile)

REVS = setSENSOR(A, SENSOR=SENSORfile )

sethpinv(fout="fpfit.inp", REV=REVS)

PTS = getPTS(HENG$pickfile, stafile, velfile, UP= TRUE)

runfpfit(A, PTS, SENSOR=SENSORfile)

AFOC = setfoccerSEIS(HENG, stafile, velfile, SENSOR=SENSOR, FPFIT=TRUE)

AFOC$fkind = 1

FOCPLOTPARAMS = list(fkind=1, PLANES=TRUE, 
  SEIS=FALSE,NAME=TRUE, POINTS=TRUE,  PT=TRUE,
  NET=TRUE,TIT=TRUE,  MECUP=TRUE)

assign("FOCPLOTPARAMS", FOCPLOTPARAMS,  env = .GlobalEnv)


###################################################
### code chunk number 16: FOCR.Rnw:450-451
###################################################
pfoccer0(AFOC )
