/* --------------------------------------------------------- */
/* ========= Code defining a Gen Widget Class ========= */
/* --------------------------------------------------------- */

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

/* --- local headers --- */

#include "GenP.h"

/* --- macros --- */

#define offset(field) XtOffsetOf(GenRec, field)

/* --- function prototypes --- */

static void Redisplay();
static void Destroy();

/* --- global variables --- */

static char defaultTranslations[] = "";
static XtActionsRec actions[] = { };

static XtResource resources[] =
  {
    {
    XtNdata,
    XtCdata,
    XtRPointer,
    sizeof(XtPointer),
    offset(gen.data),
    XtRPointer,
    0
    },
    {
    XtNredraw,
    XtCredraw,
    XtRCallback,
    sizeof(XtPointer),
    offset(gen.redraw),
    XtRCallback,
    0
    },
    {
    XtNdestroy,
    XtCdestroy,
    XtRCallback,
    sizeof(XtPointer),
    offset(gen.destroy),
    XtRCallback,
    0
    }
  };

GenClassRec genClassRec =
  {
    {
    (WidgetClass)&coreClassRec,
    "Gen",
    sizeof(GenRec),
    NULL,
    NULL,
    FALSE,
    NULL,	/* Initialize, */
    NULL,
    XtInheritRealize,
    actions,
    XtNumber(actions),
    resources,
    XtNumber(resources),
    NULLQUARK,
    TRUE,
    XtExposeCompressMultiple,
    TRUE,
    FALSE,
    Destroy,
    NULL,		/* Resize  ?  */
    Redisplay,		/* expose  */
    NULL,		/* set_values */
    NULL,
    XtInheritSetValuesAlmost,
    NULL,
    NULL,
    XtVersion,
    NULL,
    defaultTranslations,
    NULL,
    XtInheritDisplayAccelerator,
    NULL
    },
    {
    0
    }
  };

WidgetClass genWidgetClass = (WidgetClass)&genClassRec;

/* --- functions --- */

static void Redisplay(Widget w, XExposeEvent *event)
  {
  Dimension x, y;
  static Region exposed;
  static Boolean middle_expose = FALSE;
  XRectangle r = { event->x, event->y, event->width, event->height };
  Pixel bg;
  Display *d;
  void *data;

  if(!XtIsRealized(w)) return;

  /* See if widget has any data to display */

  XtVaGetValues(w, XtNdata, &data, NULL);
  if(data == NULL) return;

  /* Set the clipping */

  if(!middle_expose)
    {
    exposed = XCreateRegion();
    middle_expose = TRUE;
    }

  XUnionRectWithRegion(&r, exposed, exposed);
  if(event->count > 0) return;	/* Wait for more... */

  /* Clear exposed portion of window */

  XtVaGetValues(w, XtNwidth, &x, XtNheight, &y,	XtNbackground, &bg, NULL);
  d = XtDisplay(w);
  XtCallCallbacks(w, XtNredraw, exposed);
  middle_expose = FALSE;
  XDestroyRegion(exposed);
  }

/* ------------------------------------------------------------------ */

static void Destroy(Widget w)
  {

  XtCallCallbacks(w, XtNdestroy, NULL);
  }

/*  this is not used now....Resize is defined elsewhere */

/*

static void Resize(Widget w)
  {

  XtCallCallbacks(w, XtNredraw, NULL);
  }

*/
