/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "mpic.h"
#include "xsec.h"
#include "xlext.h"
#include "jutil.h"
#include "image_stuff.h"

/* --- macros --- */

#define LINE_LENGTH 200
#define DEGRAD 0.017453293
#define DIAGNOS 0

/* --- function prototypes --- */

typedef fxy fpoint;
typedef fxyz point;

void  flip_color_palette(mpic *m);
void break_line(char *line, int *fake_argc, char **fake_argv);
int getline(FILE *input, char s[], int lim);
Boolean readac(FILE *f, ac_rec *a);
Boolean readacE(FILE *f, ac_rec *a);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
int user_to_pix_x(JGRAPH *gr, double x);
int user_to_pix_y(JGRAPH *gr, double y);
void citoxyz(int nx, int ny, int nlay, int iway, int *i, int *ix, int *iy,
	     int *iz);
int  Get_Image_JML(char image_file[50], mpic *m);
int geo2xy_2(int type, float phi1, float lam1, float phi, float lam, float *x,
	     float *y);
void lltic(int type, float phi1, float lam1, float phi2, float lam2,
	   Markup_File *tics);
void get_rect_vol(float x1, float y1, float x2, float y2, float dip,
		  float mat[3][3]);
int eigvct_(float *a, int *n, int *nm, float *wrk1, float *o, float *lmbda,
	    int *ierr);
int Num_Lines(char *source_file);
bool_t readfoc(FILE *f, foc_rec *a);
bool_t readmc(FILE *f, Mech *a);
bool_t read_hinv_str(char *str, ac_rec *a);
bool_t readac_str(char *str, ac_rec *a);
bool_t readacE_str(char *str, ac_rec *a);
bool_t read_citcat_str(char *str, ac_rec *a);
bool_t read_hypo71_str(char *str, ac_rec *a);
bool_t read_lcard_str(char *str, ac_rec *a);
bool_t read_hcard_str(char *str, ac_rec *a);
int Kind_Sta(char *line);
bool_t GET_A_STA(FILE *f, station_rec_uw *a, int kind);
int which_kind_grid(char *file);
int Get_Image_GMT(char *file, mpic *m);
int Get_Image_CDF(char *file, mpic * m);
int inside(fpoint t, fpoint *p, int N);
void blank2under(char *ident);
void under2blank(char *ident);
void Scale_Image_Layer(mpic * m);
void Scale_Image_Set(mpic * m);

float fix_lon(float lon);

bool_t readMcard(char *str, Mech *a);


void make_leg_win(mpic *mplot);

/*----------------------------------------------*/
Boolean rect_overlap(float x1, float y1, float x2, float y2, 
                     float x3, float y3, float x4, float y4)
  {
  /*  return true if two rectangles overlap  */
  /*   rectangles are defined by lower left and upper right corners  */
  if( ( (x2>=x3)&&(x4>=x1)&& (y2>=y3)&&(y4>=y1) ) == 1 ) return 1;
  else 
  return 0;
  

  }


Boolean readfoc(FILE *f, foc_rec *a)
  {

  readac(f, &a->ac);
  readmc(f, &a->fm);

  /*

     create_Acard(&a->ac, acard);
     fprintf(stdout, "%s", acard);
     create_Mcard(&a->fm, mcard);
     fprintf(stdout, "%s", mcard);
     */

  /*M F 100 77 G 194 75 U 280 13 V  14 15 P 327 20 T 262  8*/

  return(!feof(f));
  }

Boolean readfoc_ext(FILE *f, foc_rec *a, float *phi, float *lam)
  {
  int  fake_argc;
  char line[LINE_LENGTH], temline[LINE_LENGTH], *fake_argv[100];

    int i;
    
    
   
    
    

    readac(f, &a->ac);
    i = getline(f, line, LINE_LENGTH );
    strcpy(temline, line);
    break_line(temline, &fake_argc, fake_argv);
    a->fm.strk1 = atof(fake_argv[2]); 
    a->fm.dip1= atof(fake_argv[3]);
    a->fm.strk2=atof( fake_argv[5]);
    a->fm.dip2= atof(fake_argv[6]);
    
    a->fm.urot = atof(fake_argv[8]); 
    a->fm.udip= atof(fake_argv[9]);
    a->fm.vrot= atof(fake_argv[11]);
    a->fm.vdip= atof(fake_argv[12]);
    
    a->fm.prot = atof(fake_argv[14]); 
    a->fm.pdip= atof(fake_argv[15]);
    a->fm.trot= atof(fake_argv[17]);
    a->fm.tdip= atof(fake_argv[18]);
    

  *phi = atof(fake_argv[19]);
  *lam = atof(fake_argv[20]);


  /* b = readMcard(str, &a->fm);
    
    sscanf(str[55], &phi, &lam);
    */
  
    
    


    /*  readmc(f, &a->fm); */
    
  

  return(!feof(f));
  }

/**************************/
/*FUNC DEF */ int Get_Image_glob(char *image_file, mpic * m)
  {

  int simage, pimage, prev;
  char *input; 

  int test;
  int k = 3;


  m->image_scale_log_flag=0; /*nps*/


  strcpy(m->image.file_name, image_file);
  m->image.KIND = 3;
  fprintf(stderr,"kind of image=%d\n", m->image.KIND);


 test = Get_Image_JML(image_file, m);

    if( (input = getenv("XMA_SCALE_IMAGE")) == NULL)
       {
       simage = 0;
       }
    else
       {
       simage = atoi(input);
       }
  
    if( (input = getenv("XMA_PALETTE_IMAGE")) == NULL)
       {
       pimage = 0;
       }
    else
       {
       pimage = atoi(input);
       }
  
    if( (input = getenv("XMA_PALETTE_REV")) == NULL)
       {
       prev = 0;
       }
    else
       {
       prev = atoi(input);
       }
  

  fprintf(stderr, "XMA_SCALE_IMAGE=%d XMA_PALETTE_IMAGE=%d XMA_PALETTE_REV=%d\n", simage, pimage, prev);
 

  if(pimage==1)
     {
     m->Which_Pal = 1;
     m->MinColor = m->Pal_index[m->Which_Pal];
     m->MaxColor = m->MinColor + m->Pal_num[m->Which_Pal]-1;
     }
  
  if(simage==1)
     {
  Scale_Image_Set(m);
     Scale_Image_Layer(m);
     }

  fprintf(stderr, "************done getting image_glob*************\n");
  return(k);
  }

/*FUNC DEF */ int Get_Image(char image_file[50], mpic * m)
  {

  int simage, pimage, prev;
  char *input;
  
  int k = which_kind_grid(image_file);

  m->image_scale_log_flag=0; /*nps*/
  strcpy(m->image.file_name, image_file);
  fprintf(stderr,"kind of image=%d\n",k);
  m->image.KIND = k;


  if(k < 0) Get_Image_JML(image_file, m);
  else if(k == 0) Get_Image_GMT(image_file, m);
  else Get_Image_CDF(image_file, m);


    if( (input = getenv("XMA_SCALE_IMAGE")) == NULL)
       {
       simage = 0;
       }
    else
       {
       simage = atoi(input);
       }
  
    if( (input = getenv("XMA_PALETTE_IMAGE")) == NULL)
       {
       pimage = 0;
       }
    else
       {
       pimage = atoi(input);
       }
  
    if( (input = getenv("XMA_PALETTE_REV")) == NULL)
       {
       prev = 0;
       }
    else
       {
       prev = atoi(input);
       }
  

  fprintf(stderr, "XMA_SCALE_IMAGE=%d XMA_PALETTE_IMAGE=%d XMA_PALETTE_REV=%d\n", simage, pimage, prev);
 

  if(pimage==1)
     {
     m->Which_Pal = 1;
     m->MinColor = m->Pal_index[m->Which_Pal];
     m->MaxColor = m->MinColor + m->Pal_num[m->Which_Pal]-1;
     }
  
  if(simage==1)
     {
  Scale_Image_Set(m);
     Scale_Image_Layer(m);
     }

#if 0
   if(prev==1)
      {
      m->Reverse_Pal = !m->Reverse_Pal;

      } 
#endif




  return(k);
  }

/*----------------------------------------------*/

void Scale_Image_Global(mpic *m,float max, float min)
  {
  float diff;
  int i, nelements, COL_diff;

  nelements = m->image.nx * m->image.ny * m->image.nz;
  diff = max - min;
  fprintf(stderr, "Global Scaling  min=%f max=%f\n", min, max);
  fprintf(stderr, "Global Scaling MinColor=%d  MaxColor=%d  Palette status=%d\n",
	  m->MinColor, m->MaxColor , m->Reverse_Pal );

  if(m->MaxColor > m->MinColor) COL_diff = (m->MaxColor - m->MinColor - 1);
  else COL_diff = (m->MaxColor - m->MinColor);

  for(i = 0; i < nelements; i++)
    {
    if(m->image.val[i] == m->image.image_skip) m->image.col[i] = 0;
    else
      {

   
      m->image.col[i] = (m->image_scale_log_flag?
			 getColorLogrithmic(m->image.val[i],
					    min,max,
					    m->MinColor,m->MaxColor, m->Reverse_Pal):
			 getColorLinear(m->image.val[i],
					min,max,
					m->MinColor,m->MaxColor, m->Reverse_Pal) 
			 );


      }
    }

  m->image.Temp_image_max = max;
  m->image.Temp_image_min = min;
  m->image_scale_flag = 0;
  }

/*----------------------------------------------*/

void Scale_Image_Layer(mpic * m)
  {
  float diff, max, min;
  int i, j, k;


  fprintf(stderr, "Layer Scaling MinColor=%d  MaxColor=%d  Palette status=%d\n",
	  m->MinColor, m->MaxColor , m->Reverse_Pal );

 /*  if(m->MaxColor > m->MinColor) COL_diff = (m->MaxColor - m->MinColor - 1);
  else COL_diff = (m->MaxColor - m->MinColor);  */

  for(k = 0, i = 0; k < m->image.nz; k++)
    {
    max = m->image.Layer_max[k];
    min = m->image.Layer_min[k];
    diff = max - min;

    for(j = 0; j < m->image.nx * m->image.ny; j++, i++)
      {
      if(m->image.val[i] == m->image.image_skip) m->image.col[i] = 0;
      
      else m->image.col[i] = (m->image_scale_log_flag?
			      getColorLogrithmic(m->image.val[i],
						 m->image.Layer_min[k],m->image.Layer_max[k],
						 m->MinColor,m->MaxColor, m->Reverse_Pal):
			      getColorLinear(m->image.val[i],
					     m->image.Layer_min[k],m->image.Layer_max[k],
					     m->MinColor,m->MaxColor, m->Reverse_Pal));
      }
    }

  m->image_scale_flag = 1;
  }

void Scale_Image_Set(mpic * m)
  {
  int i, j, k, minmaxset;
  float max, min;
  float *aves;
  int  *eNs;
  
   aves = alloc_fvec(0, m->image.nz + 1);
   eNs =  alloc_ivec(0, m->image.nz + 1);

  for(k = 0, i = 0; k < m->image.nz; k++)
    {
    minmaxset = 0;
    aves[k] = 0.0;
    eNs[k] = 0;
    
    for(j = 0; j < m->image.nx * m->image.ny; j++, i++)
      {
      if((minmaxset == 0) && (m->image.val[i] != m->image.image_skip))
	{
	max = m->image.val[i];
	min = m->image.val[i];
        eNs[k]++;
	aves[k]+=m->image.val[i];
	
	minmaxset = 1;
	continue;
	}
      if(m->image.val[i] != m->image.image_skip)
	{
	max = max2(max, m->image.val[i]);
	min = min2(min, m->image.val[i]);
        eNs[k]++;
	aves[k]+=m->image.val[i];
	
	}



      }
    m->image.Layer_max[k] = max;
    m->image.Layer_min[k] = min;
    }

  m->image.Global_image_max = m->image.Layer_max[0];
  m->image.Global_image_min = m->image.Layer_min[0];

  for(k = 0; k < m->image.nz; k++)
    {
    m->image.Global_image_max = max2(m->image.Layer_max[k],
				     m->image.Global_image_max);
    m->image.Global_image_min = min2(m->image.Layer_min[k],
				     m->image.Global_image_min);
    if(eNs[k]>0) aves[k]=aves[k]/eNs[k];
    
    }
  fprintf(stderr, "\n");
  fprintf(stderr, "Layer     Min        Max          N      Ave\n");
  
 
  for(k = 0; k < m->image.nz; k++)
    fprintf(stderr, "%3d %12f %12f %7d %12f\n", k, m->image.Layer_min[k], 
	    m->image.Layer_max[k], eNs[k], aves[k]);
  fprintf(stderr, "\n");

  fprintf(stderr, "Total Min=%f  Total Max=%f \n", m->image.Global_image_min,
	  m->image.Global_image_max);

  m->image.Temp_image_max = m->image.Global_image_max;
  m->image.Temp_image_min = m->image.Global_image_min;
    free_fvec(aves, 0, m->image.nz + 1);
    free_ivec(eNs, 0, m->image.nz + 1);
  }

/*----------------------------------------------*/

int Get_Image_JML(char *image_file, mpic *m)
  {
     FILE *inf;
     int fake_argc, kind;
     char line[LINE_LENGTH], temline[LINE_LENGTH], *fake_argv[100];
     int nelements, i, k, minmaxset, j;
     float max, min, val;

     if((inf = fopen(image_file, "r")) == NULL)
     {
	fprintf(stderr,"Can't open image %s ....try again\n", image_file);
	m->image_flag = 0;
	return(0);
     }

     m->image.image_skip = 1000.0;

     if(m->image.nx > 0)
     {
	nelements = m->image.nx * m->image.ny * m->image.nz;
	fprintf(stderr, "nx=%d\n :  Freeing memory", m->image.nx);

	free_fvec(m->image.val, 0, nelements);
	free_ivec(m->image.col, 0, nelements);
	free_fvec(m->image.z_parts, 0, m->image.nz + 1);
	free_fvec(m->image.Layer_max, 0, m->image.nz);
	free_fvec(m->image.Layer_min, 0, m->image.nz); 
     }

     /*numi = getline(inf, line, nline);*/
     /*fprintf(stderr,"line=%s\n", line);*/
  
     i = getline(inf, line, LINE_LENGTH);
  
     strcpy(temline, line);
     break_line(temline, &fake_argc, fake_argv);

     if(fake_argc==7)
     {

     sscanf(line, "%f %f %d %d %d %f %f", 
	    &m->image.phi, &m->image.lam, &m->image.nx,
	    &m->image.ny, &m->image.nz, &m->image.dx, &m->image.dy);
     kind = 0;
     }
     else
     {
     sscanf(line, "%f %f %d %d %d %f %f %d", 
	    &m->image.phi, &m->image.lam, &m->image.nx,
	    &m->image.ny, &m->image.nz, &m->image.dx, &m->image.dy, &kind);
     m->image.KIND = kind;
     }



     /* 
         Mike Huang asked me to remove this line
          because of images in the Pacific ocean  */
 
/* if(m->image.lam > 180) m->image.lam -= 360; 
*/


  
  m->image.spac = m->image.dx;

  geo2xy(m, m->image.phi, m->image.lam, &m->image.org_minx,
	 &m->image.org_miny);
  m->image.org_maxx = m->image.org_minx + m->image.dx * m->image.nx;
  m->image.org_maxy = m->image.org_miny + m->image.dy * m->image.ny;

  fprintf(stderr,"Get_Image_JML: image: minx=%f miny=%f maxx=%f maxy=%f\n",
	  m->image.org_minx, m->image.org_miny, m->image.org_maxx,
	  m->image.org_maxy);

  nelements = m->image.nx * m->image.ny * m->image.nz;
  fprintf(stderr, "Get_Image_JML:  file = %s lat=%f lon=%f nx=%d ny=%d nz=%d spac=%f"
	  " npoints=%d\n", image_file, m->image.phi, m->image.lam, m->image.nx,
	  m->image.ny, m->image.nz, m->image.spac, nelements);

  if(nelements <= 0) return(0);

  m->image.z_parts = alloc_fvec(0, m->image.nz + 1);
  m->image.z_vels =  alloc_fvec(0, m->image.nz + 1);

  for(i = 0; i < m->image.nz ; i++)
    {
    fscanf(inf, "%f", &val);
    m->image.z_parts[i] = val;
    }
  m->image.z_parts[i] = val+val;


/** read in  the background velocity  **/

/*
  for(i = 0; i < m->image.nz ; i++)
    {
       
       fscanf(inf, "%f", &val);
       m->image.z_vels[i] = val;

    }
  m->image.z_vels[i] = val;



  for(i = 0; i < m->image.nz ; i++)
    {
 fprintf(stderr, "Get_Image_JML:%d %f %f\n", i, m->image.z_parts[i], m->image.z_vels[i]);

    }
*/


  m->image.val = alloc_fvec(0, nelements);
  m->image.Layer_max = alloc_fvec(0, m->image.nz);
  m->image.Layer_min = alloc_fvec(0, m->image.nz);
  m->image.col = alloc_ivec(0, nelements);


  for(k = 0, i = 0; k < m->image.nz; k++)
     {
     minmaxset = 0;
     for(j = 0; j < m->image.nx * m->image.ny; j++, i++)
	{
	fscanf(inf, "%f", &val);
	/*fprintf(stderr,"%d %f\n", i,val);*/ 
	m->image.val[i] = val;

	if(minmaxset == 0 && m->image.val[i] != m->image.image_skip)
	   {
	   max = m->image.val[i];
	   min = m->image.val[i];
	   minmaxset = 1;
	   continue;
	   }
	if(m->image.val[i] != m->image.image_skip)
	   {
	   max = max2(max, m->image.val[i]);
	   min = min2(min, m->image.val[i]);
	   }

	}
     m->image.Layer_max[k] = max;
     m->image.Layer_min[k] = min;
     }
  
  m->image.Global_image_max = m->image.Layer_max[0];
  m->image.Global_image_min = m->image.Layer_min[0];
  
  for(k = 0; k < m->image.nz; k++)
     {
     m->image.Global_image_max = max2(m->image.Layer_max[k],
				      m->image.Global_image_max);
     m->image.Global_image_min = min2(m->image.Layer_min[k],
				      m->image.Global_image_min);
     }

  fprintf(stderr,"pre Scale_Image_Set min=%f max=%f\n",m->image.Global_image_min,  m->image.Global_image_max);
  
  Scale_Image_Set(m);

  Scale_Image_Global(m, m->image.Global_image_max, m->image.Global_image_min);

  m->image_flag =  m->image_layer = 1;
  fprintf(stderr," Done reading in Image file...KIND=%d\n",m->image.KIND );

  return(1);
  }

/*----------------------------------------------*/

float get_mag_size(float mag, float minsize,  float slope,  float minmag, float maxmag,
		   int style)
  {
  float hsize, mdiff;

  mdiff = (maxmag - minmag);
  

  switch(style)
    {
    case 0:
      hsize = minsize;
      break;

    case 1:
      hsize = minsize + 0.08 * exp(mag);
      if(hsize > 50.0) hsize = 37.5 + .25 * hsize;
      break;

    case 2:
      if((maxmag - minmag) == 0) hsize = minsize;
      else hsize = minsize + slope * (mag - minmag) / (maxmag - minmag);;
      break;
    default:
      hsize = minsize;
      break;
    }
        
  return(hsize);
  }

int change_mag_scale(mpic *m, int style)
  {
  int j, i;

  fprintf(stderr," Change source mag scaling: MINMAG=%f MAXMAG=%f size=%d slope=%f style=%d\n",
	  m->min_mag, m->max_mag, m->SourceSize, m->SourceSlope, style);


  for(j = 0; j < m->max_more_src; j++)
    {
    for(i = 0; i < m->sources[j].numpoints; i++)
      {
      m->sources[j].size[i] = get_mag_size(m->sources[j].acard[i].mag,
					   (float)m->SourceSize,(float)m->SourceSlope,
					   (float)m->min_mag,
					   (float)m->max_mag,  style);
      }
    }



  return(0);
  }

/*****************************************/

int Get_Sources(char source_file[50], mpic *m)
  {
  FILE *inf;
  float x, y, phi, lam, urx, ury, blx, bly;
  int  gi, i, idiscard;
  long int t3;
  ac_rec accard;
  Boolean b;
  char str[LINE_LENGTH];
  enum { UW, UWE, HINV, CIT , H71, HCARD } hypo_format; 

  m->src_flag = 1;

  t3 = Num_Lines(source_file);

  if((inf = fopen(source_file, "r")) == NULL)
    {
    fprintf(stderr,"Can't open sources %s ....try again\n", source_file);
    m->src_flag = 0;
    return(0);
    }

  i = 0;
    
  /* m->sources[m->current_src] =
     (Source_File *)calloc(1, sizeof(Source_File)); */

  m->sources[m->current_src].numpoints = t3;

  fprintf(stderr,
	  " current_src =%d allocating memory allocation for %d hypocenters\n",
	  m->current_src, m->sources[m->current_src].numpoints);
  
  m->sources[m->current_src].loc =
    XmapNewArray(point, m->sources[m->current_src].numpoints);
  m->sources[m->current_src].acard =
    XmapNewArray(ac_rec, m->sources[m->current_src].numpoints);
  m->sources[m->current_src].point_color = 
    XmapNewArray(int, m->sources[m->current_src].numpoints);
  m->sources[m->current_src].onoff =
    XmapNewArray(int, m->sources[m->current_src].numpoints);
  m->sources[m->current_src].size =
    XmapNewArray(float, m->sources[m->current_src].numpoints);

  urx = m->origin.maxx + m->origin.maxx / 4;
  ury = m->origin.maxy + m->origin.maxy / 4;

  blx = 0.0 - m->origin.maxx / 4;
  bly = 0.0 - m->origin.maxy / 4;

  /* fprintf(stderr,"%f %f %f %f\n", urx, ury, blx, bly); */

  hypo_format = UW;



  if(!strcmp(m->hypo_format_str, "UW")) hypo_format = UW;
  else if(!strcmp(m->hypo_format_str, "uw")) hypo_format = UW;
  else if(!strcmp(m->hypo_format_str, "UWE"))hypo_format = UWE; 
  else if(!strcmp(m->hypo_format_str, "hypoinverse")) hypo_format = HINV;
  else if(!strcmp(m->hypo_format_str, "CIT")) hypo_format = CIT;
  else if(!strcmp(m->hypo_format_str, "cit")) hypo_format = CIT;
  else if(!strcmp(m->hypo_format_str, "hypo71")) hypo_format = H71;
  else if(!strcmp(m->hypo_format_str, "hcard")) hypo_format = HCARD;



  fprintf(stderr, "format=%s enum=%d\n", m->hypo_format_str, hypo_format);
  idiscard = 0;

  while((gi = getline(inf, str, 200)) != 0)
    {
    switch(hypo_format)
      {
      case UW:
        b = readac_str(str, &accard);
	break;

      case UWE:
        b = readacE_str(str, &accard);
	break;

      case HINV:
	b = read_hinv_str(str, &accard);
	break;

      case CIT:
	b = read_citcat_str(str, &accard);
	break;

      case H71:
	b = read_hypo71_str(str, &accard);
	break;

      case HCARD:
	b = read_hcard_str(str, &accard);
	break;
      }

    phi = accard.phi, lam = accard.lam;
    if(accard.EW[0] == 'W') lam *= -1;
    if(accard.NS[0] == 'S' ) phi *= -1;
    geo2xy(m, phi, lam, &x, &y);
    
    
    if(m->force_source==1)
       {
   
       m->sources[m->current_src].loc[i].x = x;
       m->sources[m->current_src].loc[i].y = y;
       m->sources[m->current_src].loc[i].z = accard.depth;
       m->sources[m->current_src].acard[i] = accard;
       m->sources[m->current_src].onoff[i] = 1;
       if(m->max_mag < accard.mag) m->max_mag = accard.mag;
       if(m->min_mag > accard.mag) m->min_mag = accard.mag;

       m->sources[m->current_src].size[i] =
       get_mag_size(m->sources[m->current_src].acard[i].mag,
		    (float)m->SourceSize,(float)m->SourceSlope, (float)m->min_mag,
		    (float)m->max_mag, 1);

       m->sources[m->current_src].point_color[i] = m->src_col - m->current_src;
       i++;

       }
    else
       {
       
       if(x < urx && x > blx && y < ury && y > bly)
	  {
	  m->sources[m->current_src].loc[i].x = x;
	  m->sources[m->current_src].loc[i].y = y;
	  m->sources[m->current_src].loc[i].z = accard.depth;
	  m->sources[m->current_src].acard[i] = accard;
	  m->sources[m->current_src].onoff[i] = 1;
	  if(m->max_mag < accard.mag) m->max_mag = accard.mag;
	  if(m->min_mag > accard.mag) m->min_mag = accard.mag;

	  m->sources[m->current_src].size[i] =
	  get_mag_size(m->sources[m->current_src].acard[i].mag,
		       (float)m->SourceSize,(float)m->SourceSlope, (float)m->min_mag,
		       (float)m->max_mag, 1);

	  m->sources[m->current_src].point_color[i] = m->src_col - m->current_src;
	  i++;
	  }
       else idiscard++;
       }
    
    }

  m->sources[m->current_src].numpoints = i;
  m->sources[m->current_src].style = 0;

  strcpy(m->sources[m->current_src].file_name, source_file);
  m->max_more_src++;
  fclose(inf);

  fprintf(stderr, "Read in Source file %d: %s Number=%d col=%d\n",
	  m->current_src, m->sources[m->current_src].file_name,
	  m->sources[m->current_src].numpoints, m->src_col - m->current_src); 

  if(idiscard > 0)
    fprintf(stderr,
	    "\t\tRejected %d hypocenters out of target defined by origin\n",
	    idiscard); 

  return(1);
  }

/* ----------------------------------------------------- */
/*********   Routine to download the Focal mechanisms     */

int Get_Focs(char foc_file[50], mpic *m)
  {
  FILE *inf;
  int i, kount;
  foc_rec foc;
  float urx, ury, blx, bly, phi, lam, x, y;
  long int t3 = Num_Lines(foc_file) / 2;

  urx = m->origin.maxx + m->origin.maxx / 4;
  ury = m->origin.maxy + m->origin.maxy / 4;
  blx = -(m->origin.maxx / 4);
  bly = -(m->origin.maxy / 4);

  if((inf = fopen(foc_file, "r")) == NULL)
    {
    fprintf(stderr, "Can't open Focal Mechanisms: %s  Try again\n", foc_file);
    return(0);
    }
		

  /* since the focal files consist of two lines per record  */

  kount = m->num_focm_files;
  m->focm[kount].focs = XmapNewArray(foc_rec, t3);
  i = 0;
	
  while(readfoc(inf, &foc))
    {
    phi = foc.ac.lat1 + foc.ac.lat2 / 6000.0;       
    lam = foc.ac.lon1 + foc.ac.lon2 / 6000.0; 
    if(foc.ac.EW[0] == 'W') lam *= -1;
    if(foc.ac.NS[0] == 'S') phi *= -1;

    geo2xy(m, phi, lam, &x, &y);
    if(i > t3) break;

    if(x < urx && x > blx && y < ury && y > bly)
      {
      m->focm[kount].focs[i].loc.x = phi;
      m->focm[kount].focs[i].loc.y = lam; 
      m->focm[kount].focs[i].loc.z = foc.ac.depth;
      m->focm[kount].focs[i].ac = foc.ac;
      m->focm[kount].focs[i].fm = foc.fm;
      m->focm[kount].focs[i].on_off = 1;
      i++;
      }
    }

  m->focm[kount].numpoints = i;
  m->focal_total_num += i;

  strcpy(m->focm[kount].file_name, foc_file); 
  m->focm[kount].flag = 2;
  fclose(inf);
  m->num_focm_files++;
  fprintf(stderr, " Done getting %d focal spheres from: %s\n",
	  m->focm[kount].numpoints, m->focm[kount].file_name);
  return(1);
  }

/* ---------------------------------------------------------------- */

int Get_Focs_Ext(char foc_file[50], mpic *m)
  {
  FILE *inf;
  int i, kount;
  foc_rec foc;
  float urx, ury, blx, bly, phi, lam, x, y;
  float phie, lame;
  
  long int t3 = Num_Lines(foc_file) / 2;

  urx = m->origin.maxx + m->origin.maxx / 4;
  ury = m->origin.maxy + m->origin.maxy / 4;
  blx = -(m->origin.maxx / 4);
  bly = -(m->origin.maxy / 4);

  if((inf = fopen(foc_file, "r")) == NULL)
    {
    fprintf(stderr, "Can't open Focal Mechanisms: %s  Try again\n", foc_file);
    return(0);
    }
		

  /* since the focal files consist of two lines per record  */

  kount = m->num_focm_files;
  m->focm[kount].focs = XmapNewArray(foc_rec, t3);
  i = 0;
	
  while(readfoc_ext(inf, &foc, &phie, &lame))
    {
    phi = foc.ac.lat1 + foc.ac.lat2 / 6000.0;       
    lam = foc.ac.lon1 + foc.ac.lon2 / 6000.0; 
    if(foc.ac.EW[0] == 'W') lam *= -1;
    if(foc.ac.NS[0] == 'S') phi *= -1;

    geo2xy(m, phi, lam, &x, &y);
    if(i > t3) break;

    if(x < urx && x > blx && y < ury && y > bly)
      {
      m->focm[kount].focs[i].loc.x = phi;
      m->focm[kount].focs[i].loc.y = lam; 
      m->focm[kount].focs[i].loc.z = foc.ac.depth;
      m->focm[kount].focs[i].ac = foc.ac;
      m->focm[kount].focs[i].fm = foc.fm;
      m->focm[kount].focs[i].on_off = 1;
      geo2xy(m, phie, lame, &x, &y);
      m->focm[kount].focs[i].explode_x =x;
      m->focm[kount].focs[i].explode_y =y;
      
      i++;
      }
    }

  m->focm[kount].numpoints = i;
  m->focal_total_num += i;

  strcpy(m->focm[kount].file_name, foc_file); 
  m->focm[kount].flag = 2;
  fclose(inf);
  m->num_focm_files++;
  fprintf(stderr, " Done getting %d focal spheres from: %s\n",
	  m->focm[kount].numpoints, m->focm[kount].file_name);
  return(1);
  }

/* ---------------------------------------------------------------- */
/* stations are in UW format NS or EW  */

int Get_Stations(char *stafile, mpic *m)
  {
  FILE *inf;
  float x, y, urx, ury, blx, bly, phi, lam;
  int numi, i, j, kind;
  station_rec_uw sta_read;
  
  char line[LINE_LENGTH];
  long int t1,  t3;

  t3 = Num_Lines(stafile);

  if((inf = fopen(stafile ,"r")) == NULL)
    {
    fprintf(stderr,"Can't open station file %s .....continuing\n",stafile);
    m->sta_flag = 0;
    return(0);
    }

  t1 = ftell(inf);

#if 0
  j = fseek(inf, 0L, SEEK_END);
  t2 = ftell(inf);
  j = fseek(inf, 0L, SEEK_SET);
  j = fseek(inf, t1, SEEK_SET);	/* position back to where it was */
  t3 = (t2 - t1) / 34;
#endif

  i = getline(inf, line, LINE_LENGTH);
  kind = Kind_Sta(line);
  j = fseek(inf, t1, SEEK_SET);	/* position back to where it was */

  /* m->stations[m->current_sta] = (Station_File *) calloc(1,
     sizeof(Station_File));*/

  m->stations[m->current_sta].sta = XmapNewArray(STAREC, t3);
  strcpy( m->stations[m->current_sta].file_name, stafile);

  m->sta_flag = 1;
  i=  0;
  numi = 1;

  urx = m->origin.maxx + m->origin.maxx / 4;
  ury = m->origin.maxy + m->origin.maxy / 4;
  blx = -(m->origin.maxx / 4);
  bly = -(m->origin.maxy / 4);

  /* fprintf(stderr,"%f %f \n", m->origin.phi,m->origin.lam); */
  /* fprintf(stderr,"urx=%f ury=%f blx=%f bly=%f\n", urx, ury, blx, bly); */
  

  m->stations[m->current_sta].mean_elev = 0.0;

  while(GET_A_STA(inf, &sta_read, kind))
    {
    phi = sta_read.lat1+sta_read.lat2 / 60.0;
    lam = sta_read.lon1+ sta_read.lon2 / 60.0;
    if(sta_read.EW == 'W') lam *= -1;
    if(sta_read.NS == 'S') phi *= -1;

    geo2xy(m, phi, lam, &x, &y);

    /* fprintf(stderr, "%s phi=%f lam=%f x=%f y=%f\n",sta_read.name, phi, lam, x, y); */
    

    if(x < urx && x > blx && y < ury && y > bly)
      {
      /* this is to cut down on the number of stations  */
      m->stations[m->current_sta].sta[i].loc.x = x;
      m->stations[m->current_sta].sta[i].loc.y = y; 
      m->stations[m->current_sta].sta[i].loc.z = -sta_read.elevation;
      strcpy(m->stations[m->current_sta].sta[i].name, sta_read.name); 
      m->stations[m->current_sta].sta[i].latlon.x = phi;
      m->stations[m->current_sta].sta[i].latlon.y = lam; 
      m->stations[m->current_sta].mean_elev +=
        m->stations[m->current_sta].sta[i].loc.z;
      i++;
      if(i > t3) break;
      }
    }

  m->stations[m->current_sta].numpoints = i;
  if(m->stations[m->current_sta].numpoints > 0)
    m->stations[m->current_sta].mean_elev =
      (m->stations[m->current_sta].mean_elev
       / (float)m->stations[m->current_sta].numpoints);
  m->stations[m->current_sta].num_special_stations = 0;
  m->stations[m->current_sta].size_sta = 4;
  m->stations[m->current_sta].color = m->sta_color + m->num_sta_files;
  m->num_sta_files++;     
  fclose(inf);
  return(1);
  }

int Get_Lips(char *lipfile, mpic *m)
  {
  FILE *inf;
  int num, numi, i, nd3 = 3, ierr, kount, fake_argc;
  char line[LINE_LENGTH], temline[LINE_LENGTH], staname[200], *fake_argv[100];
  /* max 100 parameters */
  float x, y, urx, ury, blx, bly, phi, lam, ina[9], wrk1[3],
    out[9], lam2[3];

  num = Num_Lines(lipfile);

  if((inf = fopen(lipfile, "r")) == NULL)
    {
    fprintf(stderr, "Can't open Ellipse_file=%s...continuing\n", lipfile);
    return(0);
    } 
  else
    {
    urx = m->origin.maxx + m->origin.maxx / 4;
    ury = m->origin.maxy + m->origin.maxy / 4;
    blx = -(m->origin.maxx / 4);
    bly = -(m->origin.maxy / 4);

    /* fprintf(stderr," creating memory for %d Points \n", num); */
    kount = m->lip_num;
    m->lip[kount].lips = XmapNewArray(Ellipse, num);

    m->lip[kount].n = 0;
    numi = 1;
    while((numi = getline(inf, line, LINE_LENGTH)) >= 1)
      {
      strcpy(temline, line);
      break_line(temline, &fake_argc, fake_argv);
      if(fake_argc < 4) continue;

      /*
       for(icount=0; icount<10;  icount++)
        fprintf(stderr,"%d %s\n",icount,
        fake_argv[icount]); */
       

      strcpy(staname, fake_argv[0]);
      if(staname[0] == '#') continue;
      phi = m->lip[kount].lips[m->lip[kount].n].latlon.phi
        = atof(fake_argv[1]);
      lam = m->lip[kount].lips[m->lip[kount].n].latlon.lam
        = atof(fake_argv[2]);
      m->lip[kount].lips[m->lip[kount].n].latlon.z = atof(fake_argv[3]);

      if(fake_argc > 4 && fake_argc < 9)
	{
	m->lip[kount].lips[m->lip[kount].n].ind = 1;
	m->lip[kount].lips[m->lip[kount].n].ebar.x = atof(fake_argv[4]);
	m->lip[kount].lips[m->lip[kount].n].ebar.y = atof(fake_argv[5]);
	m->lip[kount].lips[m->lip[kount].n].ebar.z = atof(fake_argv[6]);
	}
      else
	{
	m->lip[kount].lips[m->lip[kount].n].ind = 0;
	ina[0] = m->lip[kount].lips[m->lip[kount].n].cov.f11
	  = atof(fake_argv[4]);
	ina[1] = m->lip[kount].lips[m->lip[kount].n].cov.f12
	  = atof(fake_argv[5]);
	ina[2] = m->lip[kount].lips[m->lip[kount].n].cov.f13
	  = atof(fake_argv[6]);
	ina[4] = m->lip[kount].lips[m->lip[kount].n].cov.f22
	  = atof(fake_argv[7]);
	ina[5] = m->lip[kount].lips[m->lip[kount].n].cov.f23
	  = atof(fake_argv[8]);
	ina[8] = m->lip[kount].lips[m->lip[kount].n].cov.f33
	  = atof(fake_argv[9]);
	ina[3] = ina[1];
	ina[6] = ina[3];
	ina[7] = ina[5];

	/*for(i=0; i<9; i++)fprintf(stderr,"%f ",ina[i]); fprintf(stderr,"\n");*/

	eigvct_(ina, &nd3, &nd3, wrk1, out, lam2, &ierr);
	/* fprintf(stderr, "EIGENVALUES %d %d: %.20f %.20f %.20f\n", kount,
		m->lip[kount].n, lam2[0], lam2[1], lam2[2]); */
	for(i = 0; i < 3; i++) if(lam2[i] <= 0.0) lam2[i] = 0;

	m->lip[kount].lips[m->lip[kount].n].lambda[0] = sqrt((double)lam2[0]);
	m->lip[kount].lips[m->lip[kount].n].lambda[1] = sqrt((double)lam2[1]);
	m->lip[kount].lips[m->lip[kount].n].lambda[2] = sqrt((double)lam2[2]);

	m->lip[kount].lips[m->lip[kount].n].vec[0][0] = out[0];
	m->lip[kount].lips[m->lip[kount].n].vec[0][1] = out[1];
	m->lip[kount].lips[m->lip[kount].n].vec[0][2] = out[2];

	m->lip[kount].lips[m->lip[kount].n].vec[1][0] = out[3];
	m->lip[kount].lips[m->lip[kount].n].vec[1][1] = out[4];
	m->lip[kount].lips[m->lip[kount].n].vec[1][2] = out[5];

	m->lip[kount].lips[m->lip[kount].n].vec[2][0] = out[6];
	m->lip[kount].lips[m->lip[kount].n].vec[2][1] = out[7];
	m->lip[kount].lips[m->lip[kount].n].vec[2][2] = out[8];

	m->lip[kount].lips[m->lip[kount].n].ebar.x =
	  m->lip[kount].lips[m->lip[kount].n].lambda[0];
	m->lip[kount].lips[m->lip[kount].n].ebar.y =
	  m->lip[kount].lips[m->lip[kount].n].lambda[1];
	m->lip[kount].lips[m->lip[kount].n].ebar.z =
	  m->lip[kount].lips[m->lip[kount].n].lambda[2];
	}

      strcpy(m->lip[kount].lips[m->lip[kount].n].label, staname);
      m->lip[kount].lips[m->lip[kount].n].col = 1;
      geo2xy(m, phi, lam, &x, &y);
      if(x < urx && x > blx && y < ury && y > bly) m->lip[kount].n++;
      }
    }

  strcpy(m->lip[kount].file_name, lipfile);
  fprintf(stderr, "Read in %d points\n", m->lip[kount].n);
  m->lip_flag = 1;
  m->lip_num++;
  fclose(inf);
  return(1);
  }

/* ---------------------------------------------------------------- */

int Get_Point_Labs(char *pointfile, mpic *m)
  {
  FILE *inf;
  float x, y, urx, ury, blx, bly, phi, lam;
  char line[LINE_LENGTH], temline[LINE_LENGTH], staname[200], *fake_argv[100];
  /* max 100 parameters */
  int fake_argc, num, numi, icount, kount;

  num = Num_Lines(pointfile);

  if((inf = fopen(pointfile, "r")) == NULL)
    {
    fprintf(stderr,"Can't open point_mark_file=%s...continuing\n", pointfile);
    return 0;
	} else {

/*example:
 Lake_Washington  47.619713 122.237053 0 1 3 1 10 1 13 0 
minimum line=length = 22
L 4 1 0 1 3 1 1 1 1 0 
c...|....1....|....2....|....3....|

*/

	urx = m->origin.maxx + m->origin.maxx / 4;
	ury = m->origin.maxy + m->origin.maxy / 4;
	blx = -(m->origin.maxx / 4);
	bly = -(m->origin.maxy / 4);

	/* fprintf(stderr," t1=%d t2=%d t3=%d t4=%d \n", t1,t2,t3,t4);*/
	/*fprintf(stderr," creating memory for %d Points \n", num);*/

	kount = m->point_flag;
       	m->Mpoint[kount].points = XmapNewArray(point_lab, num);
	m->Mpoint[kount].numpoints = 0;
	numi = 1;

	while((numi = getline(inf, line, LINE_LENGTH)) >= 1)
	  {
	    /* fprintf(stderr,"%d %s\n", numi , line); */
	    
	  strcpy(temline,line);
	  break_line(temline, &fake_argc, fake_argv);
          if(fake_argc < 3) continue;
	  strcpy(staname, fake_argv[0]);
	  if(staname[0]=='#') continue;

	  /* Note the negative Longitude   */
	  /* Ascii_Label lat lon depth color symbol code size string_code
	     font_size string_justification  */

	  phi = m->Mpoint[kount].points[m->Mpoint[kount].numpoints].lat
	    = atof(fake_argv[1]);
	  lam = m->Mpoint[kount].points[m->Mpoint[kount].numpoints].lon
	    = atof(fake_argv[2]);
	  if(fake_argc >= 4)
	    {
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].depth
	      = atof(fake_argv[3]);
	    }
	  else m->Mpoint[kount].points[m->Mpoint[kount].numpoints].depth = 0.0;

	  if(fake_argc >= 5)
	    {
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].color
	      = atoi(fake_argv[4]);
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].symbol
	      = atoi(fake_argv[5]);
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].symcode
	      = atoi(fake_argv[6]);
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].symsize
	      = atoi(fake_argv[7]);
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].strcode
	      = atoi(fake_argv[8]);
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].fsize
	      = atoi(fake_argv[9]);
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].just
	      = atoi(fake_argv[10]);
	    }
	  else
	    {
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].color = 2;
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].symbol = 3;
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].symcode = 1;
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].symsize = 8;
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].strcode = 1;
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].fsize = 9;
	    m->Mpoint[kount].points[m->Mpoint[kount].numpoints].just = 0;
	    }

	  for(icount=0; icount < strlen(staname); icount++)
	    if(staname[icount] == '_') staname[icount] = ' ';
					
	  strcpy(m->Mpoint[kount].points[m->Mpoint[kount].numpoints].name,
		 staname);

	  geo2xy(m, phi, lam, &x, &y);

	  if(x < urx && x > blx && y < ury && y > bly)
	    m->Mpoint[kount].numpoints++;
	  }
	}

  strcpy(m->Mpoint[kount].file_name, pointfile);
  fprintf(stderr, "Get_Point_Labs: Read in %d points (should be=%d)\n", m->Mpoint[kount].numpoints, num);
  m->point_flag++;

  fclose(inf);
  return(1);
  }

/* ---------------------------------------------------------------- */

int Get_Stuff(char *markfile, mpic *m)
  {
  FILE *inf;
  char *staname, line[LINE_LENGTH], TIT[50];
  int numi, numo, icount;

  if((inf = fopen(markfile, "r")) == NULL)
    {
    fprintf(stderr, "Can't open mark_file=%s...continuing\n", markfile);
    return(0);
    }
  else
    {
    m->markup.numpoints = 0;
    numi = 1;
    while(numi >= 1)
      {
      numi = getline(inf, line, LINE_LENGTH);
      for(icount = 0; icount < 12; icount++) TIT[icount] = ' ';
      for(icount = 0; line[icount] != ' '; icount++) TIT[icount]= line[icount];
      TIT[icount] = '\0';

      numo = sscanf(line,"%s %f %f %d %d",
		    staname,
		    &m->markup.stuff[m->markup.numpoints].m.x,
		    &m->markup.stuff[m->markup.numpoints].m.y,
		    &m->markup.stuff[m->markup.numpoints].code1,
		    &m->markup.stuff[m->markup.numpoints].code2);

      strcpy(m->markup.stuff[m->markup.numpoints].name, TIT);
      m->markup.numpoints++;
      }
    }
  fclose(inf);
  return(1);
  }

/* -------------------------------------------------- */

/* this version uses the min-max x-y in km's to determine the LAT-LON tics  */

int Get_Stuff1(mpic *m)
  {
  Markup_File mfile;
  float phi, lam, phio, lamo, xmax, ymax, xmin, ymin, dum,
    xshift, yshift;
  int  i;
/*  #if DIAGNOS */
  xmin =  m->origin.minx;
  xmax =  m->origin.maxx;
  ymin =  m->origin.miny;
  ymax =  m->origin.maxy;

  xy2geo(m,  &phio, &lamo, xmin, ymin);
  xy2geo(m,  &dum, &lam, xmax, ymin);
  xy2geo(m,  &phi, &dum, xmin, ymax);

#if  DIAGNOS
  fprintf(stderr,"\n\nGetstuff1: %d %f %f %f %f %f %f %f %f\n\n",
	  m->project_type, xmin, ymin, xmax,ymax,phio, lamo, phi , lam);
#endif

  lltic(m->project_type, phio, lamo, phi, lam, &mfile);
  m->markup.numpoints = mfile.numpoints;
  geo2xy(m, phio, lamo, &xshift, &yshift);

#if  DIAGNOS
  fprintf(stderr,"Getstuff1: xshift=%f yshift=%f \n", xshift, yshift);
#endif

  if(m->project_type!=1) 
    {
    xshift=0;
    yshift=0;
    }
  
  for(i = 0; i < mfile.numpoints; i++)
    {
    m->markup.stuff[i].m.x = mfile.stuff[i].m.x + xshift;
    m->markup.stuff[i].m.y = mfile.stuff[i].m.y + yshift;

    /*
       m->markup.stuff[i].m.x = mfile.stuff[i].m.x;
       m->markup.stuff[i].m.y = mfile.stuff[i].m.y;
       */

    m->markup.stuff[i].code1 = mfile.stuff[i].code1;
    m->markup.stuff[i].code2 = mfile.stuff[i].code2;
    m->markup.stuff[i].deg = mfile.stuff[i].deg;
    m->markup.stuff[i].min = mfile.stuff[i].min;
    m->markup.stuff[i].ddeg = mfile.stuff[i].ddeg;

    strcpy( m->markup.stuff[i].name, mfile.stuff[i].name);
    }

  /*for(i=0; i< m->markup.numpoints; i++) 
    fprintf(stderr,"%s %f %f %d %d %d %d %f\n",m->markup.stuff[i].name,
    m->markup.stuff[i].m.x,
    m->markup.stuff[i].m.y,
    m->markup.stuff[i].code1,
    m->markup.stuff[i].code2,
    m->markup.stuff[i].p.x,
    m->markup.stuff[i].p.y,
    m->markup.stuff[i].ddeg);*/

  return(1);
  }

/* ---------------------------------------------------------------- */

/* this version uses the min-max phi-lam to determine the LAT-LON tics  */

int Get_Stuff2(mpic *m)
  {
  Markup_File mfile;
  float phi, lam, xmax, ymax, xmin, ymin;
  int i;

  xmin =  m->origin.minx;
  xmax =  m->origin.maxx;
  ymin =  m->origin.miny;
  ymax =  m->origin.maxy;
  phi = m->origin.phimax; 
  lam = m->origin.lammax; 
  
  lltic(m->project_type, m->origin.phi, m->origin.lam, phi, lam, &mfile);
  m->markup.numpoints = mfile.numpoints;
    
  for(i = 0; i < mfile.numpoints; i++)
    {				
    m->markup.stuff[i].m.x = mfile.stuff[i].m.x;
    m->markup.stuff[i].m.y = mfile.stuff[i].m.y;
    m->markup.stuff[i].code1 = mfile.stuff[i].code1;
    m->markup.stuff[i].code2 = mfile.stuff[i].code2;
    m->markup.stuff[i].deg = mfile.stuff[i].deg;
    m->markup.stuff[i].min = mfile.stuff[i].min;
    m->markup.stuff[i].ddeg = mfile.stuff[i].ddeg;
    strcpy(m->markup.stuff[i].name, mfile.stuff[i].name);
    }
/*
   for(i=0; i< m->markup.numpoints; i++) 
     fprintf(stderr,"%s %f %f %d %d %d %d \n",m->markup.stuff[i].name,
     m->markup.stuff[i].m.x,
     m->markup.stuff[i].m.y,
     m->markup.stuff[i].code1,
     m->markup.stuff[i].code2,
     m->markup.stuff[i].p.x,
     m->markup.stuff[i].p.y);
*/
  return(1);
  }

/* ---------------------------------------------------------------- */
/************   MAP ROUTINES  ************************/
/* ---------------------------------------------------------------- */

int Get_Map_xyxy(char *mapfile,	mpic *m)
  {
  int i = 0, num;
  FILE *mf;
  char *mapdir, map_file[100];
  float phi, lam, x1, y1, x2, y2;

  num = Num_Lines(mapfile);

  if((mf = fopen(mapfile, "r")) == NULL)
    {
    fprintf(stderr, "Normally looking for the lat-lon map file in "
	    "the current directory,\n");
    fprintf(stderr, "Can't open %s so we will try the envirnoment "
	    "directory....\n", mapfile);
    m->xy_map.numpoints = 0;

    if((mapdir = getenv("THEMAP")) == NULL) return (0);
    else
      {
      sprintf(map_file, "%s/themap", mapdir);
      fprintf(stderr, "the default map file is: %s\n", map_file);
      if((mf = fopen(map_file, "r")) == NULL)
	{
	fprintf(stderr, "Can't open Map file=%s .... continuing\n", map_file);
	fprintf(stderr, "Since there is no simple map file you may read a"); 
	fprintf(stderr,"  complicated one in by using the MAP menu item\n");
	m->xy_map.numpoints = 0;
	return(0);
	} 
      }
    } 

  m->xy_map.km = (FSeg *) calloc(num, sizeof(FSeg));
  
  i = 0;
  
  while(fscanf(mf, "%f %f %f %f", &x1, &y1, &x2, &y2) > 0)
    {
    phi = x1, lam = y1;
    geo2xy(m, phi, lam, &m->xy_map.km[i].x1, &m->xy_map.km[i].y1);

    phi = x2, lam = y2;
    geo2xy(m, phi, lam, &m->xy_map.km[i].x2, &m->xy_map.km[i].y2);
  
    i++;
    if(i >= num) break;
    }

  m->xy_map.numpoints = i;
  m->map_flag = m->map_type = 1;
  fprintf(stderr, "GETMAP NP: %d\n", m->xy_map.numpoints); 
  fclose(mf);
  return(1);
  }

/*******************************************************************/

int Get_Map_GMT(char *mapfile, mpic *m)
  {
  int j, i = 0, num, numi, kind, lonlat, fake_argc;
  FILE *mf;
  float phi, lam, x1, y1, x2, y2;
  long int t1;
  char map_file[100], line[LINE_LENGTH], temline[LINE_LENGTH], *fake_argv[100];
  /* max 100 parameters for now */

  num = Num_Lines(mapfile);

  if((mf = fopen(mapfile, "r")) == NULL)
    {
    fprintf(stderr,"Can't open Map file=%s .... continuing\n", map_file);
    m->xy_map.numpoints = 0;
    return(0);
    } 

  t1 = ftell(mf);
  getline(mf, line, LINE_LENGTH);
  strcpy(temline, line);
  break_line(temline, &fake_argc, fake_argv);

  /* lonlat = 0 -> pairs are in LAT LON format  */

  lonlat = 1;
  if(strstr(line, "latlon") != NULL) lonlat = 0;
  if(strstr(line, "lonlat") != NULL) lonlat = 1;

  kind = 0;
  if(!strcmp(fake_argv[0], ">")) kind = 2;
       
  getline(mf, line, LINE_LENGTH);
  strcpy(temline, line);
  break_line(temline, &fake_argc, fake_argv);

  if(fake_argc < 1 || fake_argc > 3)
    {
    fprintf(stderr, "input fake_argc=%d line=%s", fake_argc, line);
    fprintf(stderr, "\n**NOTE:\n**There is a problem with this gmt mapfile\n");
    fprintf(stderr, "**There need to be 2 coordinates per line, entered as"
	    " lon-lat or lat-lon\n");
    fprintf(stderr, "**(if lat-lon is entered, the \"latlon\" flag must"
	    " appear in the first line of the file\n");
    fprintf(stderr,"**returning to main with out reading in file\n");
    return(0);
    }

  x1 = atof(fake_argv[0]);
  y1 = atof(fake_argv[1]);

  if((fabs(x1) > 90) && (fabs(y1) < 90)) lonlat = 1;
  if((fabs(x1) < 90) && (fabs(y1) > 90)) lonlat = 0;

  if(getenv("XMA_LONLAT") != NULL) lonlat = 1;
  j = strlen(line);

  j = fseek(mf, t1, SEEK_SET);	/* position back to where it was */
     
  m->xy_map.km = XmapNewArray(FSeg, num);

  i = 0;

  if(kind == 2)
    {		/*  gmt style file   note:   lon lat entry values */
    fprintf(stderr, " NOTE: gmt style file   By Default values are entered:"
	    "  lon lat (unless latlon appears in first line)\n");
    if(lonlat == 0) fprintf(stderr,
			    "Reading in gmt file with LAT LON pairs\n");
    if(lonlat == 1) fprintf(stderr,
			    "Reading in gmt file with LON LAT pairs\n");

    while((numi = getline(mf, line, LINE_LENGTH)) > 0)
      {
      if(strstr(line, ">") != NULL)
	{
	if((numi = getline(mf, line, LINE_LENGTH)) > 0)
	  sscanf(line, "%f %f", &x1, &y1);
	} 
      else
	{
	if(lonlat == 1)
	  {

	  phi = y1;
	  lam = x1;
	 if(m->origin.proj!=5) fix_lon(lam);
	  geo2xy(m, phi, lam, &m->xy_map.km[i].x1, &m->xy_map.km[i].y1);

	  sscanf(line, "%f %f", &x2, &y2);

	  phi = y2;
	  lam = x2;
	  if(m->origin.proj!=5) fix_lon(lam);
	  geo2xy(m, phi, lam, &m->xy_map.km[i].x2, &m->xy_map.km[i].y2);
	  x1 = x2;
	  y1 = y2;
	  i++;
	  if(i >= num) break;
	  } 
	else
	  {
          
	  phi = x1;
	  lam = y1;
	  if(m->origin.proj!=5)fix_lon(lam);
	  geo2xy(m, phi, lam, &m->xy_map.km[i].x1, &m->xy_map.km[i].y1);

	  sscanf(line, "%f %f", &x2, &y2);

	  phi = x2;
	  lam = y2;
	 if(m->origin.proj!=5) fix_lon(lam);
	  geo2xy(m, phi, lam, &m->xy_map.km[i].x2, &m->xy_map.km[i].y2);
	  x1 = x2;
	  y1 = y2;
	  i++;
	  if(i >= num) break;
	  }
	}
      }
    }

  if(kind == 0)
    {
    while((numi = getline(mf, line, LINE_LENGTH)) > 0)
      {
      sscanf(line,"%f %f %f %f", &x1, &y1, &x2, &y2);
      phi = x1;
      lam = y1;
    if(m->origin.proj!=5)  fix_lon(lam);
      geo2xy(m, phi, lam, &m->xy_map.km[i].x1, &m->xy_map.km[i].y1);

      phi = x2;
      lam = y2;
     if(m->origin.proj!=5) fix_lon(lam);
      geo2xy(m, phi, lam, &m->xy_map.km[i].x2, &m->xy_map.km[i].y2);

      i++;
      if(i >= num) break;
      }
    }
 
  m->xy_map.numpoints = i;
  m->map_flag = m->map_type = 1;
  fprintf(stderr, "GETMAP NP: %d\n", m->xy_map.numpoints); 
  fclose(mf);
  return(1);
  }

/* ---------------------------------------------------------------- */
void  print_stroke_info(mpic *m, int kount, int k)
{

	   fprintf(stderr, "stroke info < %s %d %d %d %c %f %f %f %f index=%d>\n",
	   m->map[kount].stroke[k].name, m->map[kount].stroke[k].num, 
	   m->map[kount].stroke[k].style, m->map[kount].stroke[k].col, 
	   m->map[kount].stroke[k].code, m->map[kount].stroke[k].latmin,
	   m->map[kount].stroke[k].latmax, m->map[kount].stroke[k].lonmin,
	   m->map[kount].stroke[k].lonmax, m->map[kount].stroke[k].index1 );
    
}
/* for reading in ASCII formatted maps  */

int Get_Map2(char *mapfile, mpic *m)
{
   int i = 0,ii, j, k, kount, n, nump, sty, co, fake_argc, nstroke, npoint,
      lowy, num, indx[4];
  
   int kin, sin, left;

   
   int *wraps, nwrap, kn;
  
   float ftem;
  
   FILE *mf;
   float rlatmin, rlatmax, rlonmin, rlonmax, phi, lam, xmax, xmin, ymax, ymin,
      bx1, by1, bx2, by2, mx1, my1, mx2, my2, p1x, p1y, pys[4], pxs[4];
   char gmtchar, alph[12], code, line[LINE_LENGTH], *fake_argv[100];
   /* max 100 parameters for now */
   fpoint plotkin[5], po1, po2, po3, po4;

/*  set up target coordinates to determine if strokes are in or out of the target  */

   xmin = m->origin.minx, xmax = m->origin.maxx;
   ymin = m->origin.miny, ymax = m->origin.maxy;
   bx1 = m->origin.phimin, bx2 = m->origin.phimax;
   by1 = m->origin.lammin, by2 = m->origin.lammax;

   phi = m->origin.phimin, lam = m->origin.lammin;
   geo2xy(m, phi, lam, &p1x, &p1y);
   pys[0] = p1y, pxs[0] = p1x;

   phi = m->origin.phimax, lam = m->origin.lammin;
   geo2xy(m, phi, lam, &p1x, &p1y);
   pys[1] = p1y, pxs[1] = p1x;

   phi = m->origin.phimax, lam = m->origin.lammax;
   geo2xy(m, phi, lam, &p1x, &p1y);
   pys[2] = p1y, pxs[2] = p1x;

   phi = m->origin.phimin, lam = m->origin.lammax;
   geo2xy(m, phi, lam, &p1x, &p1y);
   pys[3] = p1y, pxs[3] = p1x;

   num = 4;
   cindex(pys, indx, num);
   lowy = indx[0];
   for(i = lowy, j = 1; i < num; i++)
   {
      plotkin[j].x = pxs[i];
      plotkin[j].y = pys[i];
      j++;
   }

   for(i = 0; i < lowy; i++)
   {
      plotkin[j].x = pxs[i];
      plotkin[j].y = pys[i];
      j++;
   }

  
   fprintf(stderr, "\nGet_Map2 XY Bounds: %f %f %f %f \n", xmin, xmax, ymin,
	   ymax);
   fprintf(stderr, "Get_Map2 LL Bounds: %f %f %f %f \n", bx1, bx2, by1, by2);
   /*
     for(i=1; i<num+1; i++)fprintf(stderr," plotkin  %d %f %f\n",i,
     plotkin[i].x, plotkin[i].y); */


/***   open map file, ignore all lines starting with the lb sign #   ****/ 
   if((mf = fopen(mapfile, "r")) == NULL)
   {
      fprintf(stderr, "Can't open Map-file %s : Try Again!\n", mapfile);
      return(0);
   }
   else j = 0;

   while((i = getline(mf, line, LINE_LENGTH)) > 0)
   {
      if(!strncmp(line, "#", 1)) continue;
      break_line(line, &fake_argc, fake_argv);
      break;
   }

/*  if first line is two args, then it tells the program how many strokes 
    and how many points to read  */
   if(fake_argc == 2)
   {
      /* sscanf(line, "%d %d", &nstroke, &npoint); */

      nstroke = atoi(fake_argv[0]);
      npoint = atoi(fake_argv[1]);
      fprintf(stderr, "ASCII mapfile nstroke=%d npoint=%d :\n If you convert"
	      " to BIN it will run faster...\n", nstroke, npoint);
   }
   else
   {
      /*
       * this is not a correct new format map file. we must read
       * through the whole file and count the number of strokes and
       * points. Then proceeed as before
       */

      /*  fprintf(stderr, " Warning: this is an old version of a mapfile.\n");
	  fprintf(stderr, "To speed things up you may want to convert this file"
	  " using a utility program.\n");
	  fprintf(stderr, "Try maplees2binA input > output.BIN \n"); */
      fclose(mf);
      nstroke = npoint = 0;
      mf = fopen(mapfile, "r");

      while((i = getline(mf, line, LINE_LENGTH)) > 0)
      {
	 if(!strncmp(line, "#", 1)) continue;

	 sscanf(line, "%s %s %d %d %d %c %f %f %f %f", &gmtchar, alph, &nump,
		&sty, &co, &code, &rlatmin, &rlatmax, &rlonmin, &rlonmax);

	 for(j = 0; j < nump; j++)
	 {
	    if(!strncmp(line, "#", 1))
	    {
	       j--;
	       continue;
	    }
	    k = getline(mf, line, LINE_LENGTH);
	 }
	 nstroke++;
	 npoint += nump;
      } /* end loop  */

      fclose(mf);
      /* we now know how many points and strokes are in the file */
 
      mf = fopen(mapfile, "r");
   }

   fprintf(stderr, "GETMAP2 MAPFILE: nstroke=%d  npoint=%d\n" , nstroke, npoint);

   kount = m->num_map_files;

   /* assign memory for the mapfile  */
   m->map[kount].stroke = XmapNewArray(MAPSTROKE, nstroke);
   m->map[kount].km = XmapNewArray(point, npoint);
   m->map[kount].latlon = XmapNewArray(point, npoint);
      
   j = k = 0;
   /*   read in the mapfile  */
   while((i = getline(mf, line, LINE_LENGTH)) > 0)
   {
      if(!strncmp(line, "#", 1)) continue;
      sscanf(line, "%s %s %d %d %d %c %f %f %f %f", &gmtchar, alph, &nump,
	     &sty, &co, &code, &rlatmin, &rlatmax, &rlonmin, &rlonmax);

      if(m->origin.proj!=5)
      {
      
	 rlonmin = fix_lon(rlonmin);
	 rlonmax = fix_lon(rlonmax);
      }
    


      if(rlonmin>rlonmax)
      {
	 ftem = rlonmin;
	 rlonmin = rlonmax;
	 rlonmax = ftem;
      }
      
      if(rlatmin>rlatmax)
      {
	 ftem = rlatmin;
	 rlatmin = rlatmax;
	 rlatmax = ftem;
      }
      

      mx1 = rlatmin, mx2 = rlatmax;
      my1 = rlonmin, my2 = rlonmax;
 
 
      phi = mx1, lam = my1;
      geo2xy(m, phi, lam, &po1.x, &po1.y);

      phi = mx1, lam = my2;
      geo2xy(m, phi, lam, &po2.x, &po2.y);

      phi = mx2, lam = my2;
      geo2xy(m, phi, lam, &po3.x, &po3.y);

      phi = mx2, lam = my1;
      geo2xy(m, phi, lam, &po4.x, &po4.y);

/*  check to see if mapstroke overlaps target region  */
      kin = rect_overlap(  
	 by1, bx1,  by2,  bx2, 
	 rlonmin,rlatmin,  rlonmax, rlatmax ); 

      if((inside(po1, plotkin, num) == 1) || (inside(po2, plotkin, num) == 1)
	 || (inside(po3, plotkin, num) == 1) || (inside(po4, plotkin, num) ==1))
      { 
	 sin=1; 
      }
      else
      {
	 sin = 0;
      }
    
      if( (sin==1) ) kin=1;



/*
  fprintf(stderr,"stroke %s %f %f %f %f : %d %d\n",
  alph, mx1, mx2, my1, my2 , kin, sin );

  fprintf(stderr,"p1:%f %f p2:%f %f p3:%f %f p4:%f %f\n",
  po1.x, po1.y, po2.x, po2.y,po3.x, po3.y, po4.x, po4.y);



  fprintf(stderr,"%f %f %f %f %f %f %f %f %d %d \n",
  by1, bx1,  by2,  bx2, 
  rlonmin,rlatmin,  rlonmax, rlatmax, kin, sin);
*/
      if( (sin==1) ) kin=1;

      if(kin)
      {
	 /*  fprintf(stderr," IN\n");*/
       
	 /*  there is some overlap of the regions, so include it in database  */

	 m->map[kount].stroke[k].num = nump;
	 m->map[kount].stroke[k].style = sty;
	 m->map[kount].stroke[k].col = co;
	 m->map[kount].stroke[k].code = code;
	 strcpy(m->map[kount].stroke[k].name, alph);
	 m->map[kount].stroke[k].latmin = rlatmin;
	 m->map[kount].stroke[k].latmax = rlatmax;
	 m->map[kount].stroke[k].lonmin = rlonmin;
	 m->map[kount].stroke[k].lonmax = rlonmax;
	 m->map[kount].stroke[k].index1 = j;


	 wraps = XmapNewArray(int, nump);

	 /* print_stroke_info(m, kount, k); */


	 for(i = j; i < j + nump; i++)
	 {
	    getline(mf, line, LINE_LENGTH);
	    if(!strncmp(line, "#", 1))
	    {
	       i--;
	       continue;
	    }
	    sscanf(line, "%f %f", &phi, &lam);
	    if(m->origin.proj!=5) fix_lon(lam);
	    m->map[kount].latlon[i].x = phi;
	    m->map[kount].latlon[i].y = lam;
	    geo2xy(m, phi, lam, &m->map[kount].km[i].x, &m->map[kount].km[i].y);
	 }

	 n=0;
	 nwrap = 0;
	 wraps[n] = 0;
       
       
	 for( i=j+1, n = 1, kn=1; n < nump; i++, n++, kn++)
	 {
	  
	    wraps[n] = 0;
	    if( ( (m->map[kount].km[i].x>xmax) &&  (m->map[kount].km[i-1].x<xmin) ) ||
		( (m->map[kount].km[i].x<xmin) &&  (m->map[kount].km[i-1].x>xmax) ) )
	    {
	       wraps[n] = kn;
	       nwrap++;
	       kn = 0;
	    }
	 }
	 left=0;  
	 if(wraps[n-1]!=0)
	 { 
	    left=1;
	 }
       
       
       
	 if(nwrap==0)
	 {
	    k++;			/* finished stroke  **/
	    j += nump;
	 }
       
	 else
	 {
	  
	    for( n = 0,i=j , ii=0; n <  nump; i++, n++, ii++)
	    {
	     
	       if( (wraps[n]>=1) || (n==(nump-1)) )
	       {
		
		  m->map[kount].stroke[k].num = ii;
		  m->map[kount].stroke[k].style = 2;
		  m->map[kount].stroke[k].col = 3;
		  m->map[kount].stroke[k].code = code;
		  strcpy(m->map[kount].stroke[k].name, alph);
		  m->map[kount].stroke[k].latmin = rlatmin;
		  m->map[kount].stroke[k].latmax = rlatmax;
		  m->map[kount].stroke[k].lonmin = rlonmin;
		  m->map[kount].stroke[k].lonmax = rlonmax;
		  m->map[kount].stroke[k].index1 = j;

		  /* print_stroke_info(m, kount, k); */
	 
		  /* fprintf(stderr, "k=%d ii=%d %s \n",k, ii,  map.name); */
		  k++;		
		  j+=ii;
		  ii=0;
	       }
	     
	     
	    }
	    if(left==1)
	    {
	       ii= 1;
	     
	       m->map[kount].stroke[k].num = ii;
	       m->map[kount].stroke[k].style = 1;
	       m->map[kount].stroke[k].col = 3;
	       m->map[kount].stroke[k].code = code;
	       strcpy(m->map[kount].stroke[k].name, alph);
	       m->map[kount].stroke[k].latmin = rlatmin;
	       m->map[kount].stroke[k].latmax = rlatmax;
	       m->map[kount].stroke[k].lonmin = rlonmin;
	       m->map[kount].stroke[k].lonmax = rlonmax;
	     
	       m->map[kount].stroke[k].index1 = j;

	       /* print_stroke_info(m, kount, k); */

	       /* fprintf(stderr, "k=%d ii=%d %s \n",k, ii,  map.name); */	
	       k++;
	       j += ii;
	    }
	 } 
       
	 free(wraps);
       
       
       
      }
      else
      {
	 /*  loop through points and ignore them  */
       
	 for(n = 0; n < nump; n++)
	 {
	    getline(mf, line, LINE_LENGTH);
	    if(!strncmp(line, "#", 1))
	    {
	       n--;
	       continue;
	    }
	  
	    sscanf(line, "%f %f", &phi, &lam);
	 }
      }
    

    
   }
  
   m->map[kount].numpoints = i;
   m->map[kount].stroke_count = k;
   strcpy(m->map[kount].file_name, mapfile);
  
   m->map_type = 2;
   m->map_flag = 1;
   m->num_map_files++;
  
   fprintf(stderr, "GETMAP2 stroke count: %d\n", m->map[kount].stroke_count);
   fprintf(stderr, "GETMAP2 numpoints: %d\n", m->map[kount].numpoints); 
   fprintf(stderr, "GETMAP2 num_map_files: %d\n", m->num_map_files); 
   fprintf(stderr, "\n");
   fclose(mf);
   return(1);
}

/* ---------------------------------------------------------------- */

/* for reading in a binary formatted lees map file */

int Get_Map3(char *mapfile, mpic *m)
  {
  int i = 0,ii, j, k, n, nump, in, kount, lowy, num, nstroke, npoint, indx[4];
  int kin, sin, left;
  
  FILE *mf;
  float phi, lam, *phis, *lams, xmax, xmin, ymax, ymin, bx1, by1, bx2, by2,
    mx1, my1, mx2, my2, p1x, p1y, pys[4], pxs[4];

  float *exs, *whys;
  int *wraps, nwrap, kn;
  
  int  aone=1, atwo=2, athree=3;
  
  float ftem;
  

  fpoint plotkin[5], po1, po2, po3, po4;
  MAPSTROKE map;

  xmin = m->origin.minx, xmax = m->origin.maxx;
  ymin = m->origin.miny, ymax = m->origin.maxy;
  bx1 = m->origin.phimin, bx2 = m->origin.phimax;
  by1 = m->origin.lammin, by2 = m->origin.lammax;

  phi = m->origin.phimin, lam = m->origin.lammin;
  geo2xy(m, phi, lam, &p1x, &p1y);
  pys[0] = p1y, pxs[0] = p1x;

  phi = m->origin.phimax, lam = m->origin.lammin;
  geo2xy(m, phi, lam, &p1x, &p1y);
  pys[1] = p1y, pxs[1] = p1x;

  phi = m->origin.phimax, lam = m->origin.lammax ;
  geo2xy(m, phi, lam, &p1x, &p1y);
  pys[2] = p1y, pxs[2] = p1x;

  phi = m->origin.phimin, lam = m->origin.lammax;
  geo2xy(m, phi, lam, &p1x, &p1y);
  pys[3] = p1y, pxs[3] = p1x;

  num = 4;

  cindex(pys, indx, num);

  lowy = indx[0];
  for(i = lowy, j = 1; i < num; i++)
    {
    plotkin[j].x = pxs[i];
    plotkin[j].y = pys[i];
    j++;
    }

  for(i = 0; i < lowy; i++)
    {
    plotkin[j].x = pxs[i];
    plotkin[j].y = pys[i];
    j++;
    }

  /* check for crossing the IDL (-180, 180 )  */

  fprintf(stderr, "Get_Map3 XY Bounds: %f %f %f %f \n", xmin, xmax, ymin,
	  ymax);
  fprintf(stderr, "Get_Map3 LL Bounds: %f %f %f %f \n", bx1, bx2, by1, by2);

  if((mf = fopen(mapfile, "rb")) == NULL)
    {
    fprintf(stderr, "Can't open BINARY Map-file %s : Try Again!\n", mapfile);
    return(0);
    }
  else j = 0;

  in = fread(&nstroke, 1, sizeof(int),  mf);
  in = fread(&npoint, 1, sizeof(int),  mf);
  fprintf(stderr, "numstroke=%d  npoint=%d\n",nstroke,  npoint);
  
  kount = m->num_map_files;

  m->map[kount].stroke = XmapNewArray(MAPSTROKE, nstroke);
  m->map[kount].km = XmapNewArray(point, npoint);
  m->map[kount].latlon = XmapNewArray(point, npoint);
       
  j = k = 0;

  while((in = fread(&map, 1, sizeof(MAPSTROKE), mf)) > 0)
    {
    nump = map.num;
   

    if(m->origin.proj!=5)
      {
      map.lonmin = fix_lon(map.lonmin);
      map.lonmax = fix_lon(map.lonmax);
      }
    
      if(map.lonmin>map.lonmax)
	{
	ftem = map.lonmin;
	map.lonmin = map.lonmax;
	map.lonmax = ftem;
	}
      if(map.latmin>map.latmax)
	{
	ftem = map.latmin;
	map.latmin = map.latmax;
	map.latmax = ftem;
	}     


    mx1 = map.latmin, mx2 = map.latmax;
    my1 = map.lonmin, my2 = map.lonmax;




    phi = mx1, lam = my1;
    geo2xy(m, phi, lam, &po1.x, &po1.y);

    phi = mx1, lam = my2;
    geo2xy(m, phi, lam, &po2.x, &po2.y);

    phi = mx2, lam = my2;
    geo2xy(m, phi, lam, &po3.x, &po3.y);

    phi = mx2, lam = my1;
    geo2xy(m, phi, lam, &po4.x, &po4.y);


   kin = rect_overlap( xmin, ymin, xmax, ymax,
		      po1.x, po1.y, po3.x, po3.y);
    
		      
   /* fprintf(stderr,"Map3 kin=%d \n", kin); */ 
    
   /* map.latmin,map.lonmin, map.latmax, map.lonmax);  */
  if((inside(po1, plotkin, num) == 1) || (inside(po2, plotkin, num) == 1)
       || (inside(po3, plotkin, num) == 1) || (inside(po4, plotkin, num) ==1))
    { 
    sin=1; 
    }
  else
    {
    sin = 0;
    }
    
    if( (sin==1) ) kin=1;
    
    if(kin)
      {
      /*  there is some overlap of the regions, so include it in database  */
      /* fprintf(stderr,"Map3 kin=%d kount=%d  k=%d\n", kin, kount, k); */
      m->map[kount].stroke[k].num = map.num;
      m->map[kount].stroke[k].style = map.style;
      m->map[kount].stroke[k].col = map.col;
      m->map[kount].stroke[k].code = map.code;
      strcpy(m->map[kount].stroke[k].name, map.name);
      m->map[kount].stroke[k].latmin = mx1;
      m->map[kount].stroke[k].latmax = mx2;
      m->map[kount].stroke[k].lonmin = my1;
      m->map[kount].stroke[k].lonmax = my2;
      m->map[kount].stroke[k].index1 = j;
      
      phis = XmapNewArray(float, map.num);
      lams = XmapNewArray(float, map.num);
      
      exs = XmapNewArray(float, map.num);
      whys = XmapNewArray(float, map.num);
      wraps = XmapNewArray(int, map.num);
      
      fread(phis, map.num, sizeof(float), mf);
      fread(lams, map.num, sizeof(float), mf);

      /* check for wrap around here:
	 break up the stroke into smaller strokes
	 that do not wrap around....*/

      n=0;
      nwrap = 0;
      phi = phis[n];
      lam = lams[n];
      geo2xy(m, phi, lam, &exs[n], &whys[n]);
      wraps[n] = 0;
      /* fprintf(stderr, "phis[%d]=%f lams[%d]=%f\n", n, phis[n], n,lams[n]); */ 


      for( n = 1, kn=1; n < map.num;  n++, kn++)
	 {
	 phi = phis[n];
	 lam = lams[n];
         /* fprintf(stderr, "phis[%d]=%f lams[%d]=%f\n", n, phis[n], n,lams[n]); */ 
	 geo2xy(m, phi, lam, &exs[n], &whys[n]);
	 wraps[n] = 0;
	 if( ( (exs[n]>xmax) &&  (exs[n-1]<xmin) ) ||
	    ( (exs[n]<xmin) &&  (exs[n-1]>xmax) ) )
	    {
	    wraps[n] = kn;
	    nwrap++;
	    kn = 0;
	    }

	 }


      left=0;  
      if(wraps[n-1]!=0)
	 { 
	 left=1;
	 }

      
#if 0

      if(kin!=sin) 
	{
      
      
	/*fprintf(stderr,"SEEIT nwap = %d kn=%d  kin=%d  sin=%d  %d %d %d %c %s %f %f %f %f\n",
		nwrap , kn,  kin, sin,
		map.num, map.style, map.col, 
		map.code, map.name, mx1, mx2, my1 , my2);*/

	for( n = 0; n < map.num;  n++)
	  {
	  fprintf(stderr,"%f %f %f %f %d\n",phis[n], lams[n], exs[n], whys[n], wraps[n]);
	  }
      
	}
#endif

      if(nwrap==0)
	{
  
	for(i = j, n = 0; i < j + map.num; i++, n++)
	  {  
	  m->map[kount].latlon[i].x = phis[n];
	  m->map[kount].latlon[i].y = lams[n];
	  m->map[kount].km[i].x = exs[n];
	  m->map[kount].km[i].y = whys[n];
	  }
	/*fprintf(stderr,"SEEIT %d %d %d %d %c %s %f %f %f %f %d\n",
		k,
		m->map[kount].stroke[k].num,
		m->map[kount].stroke[k].style,
		m->map[kount].stroke[k].col,
		m->map[kount].stroke[k].code,
		m->map[kount].stroke[k].name,
		m->map[kount].stroke[k].latmin,
		m->map[kount].stroke[k].latmax,
		m->map[kount].stroke[k].lonmin, 
		m->map[kount].stroke[k].lonmax,
		m->map[kount].stroke[k].index1);*/
	
	k++;			/* finished stroke  **/
	j += map.num;
	}
      else
	{
	  
	for( n = 0,i=j , ii=0; n <  map.num; i++, n++, ii++)
	  {
	  
	  if( (wraps[n]>=1) || (n==(map.num-1)) )
	     {
	     
	     m->map[kount].stroke[k].num = ii;
	     m->map[kount].stroke[k].style = atwo;
	     m->map[kount].stroke[k].col = athree;
	     m->map[kount].stroke[k].code = map.code;
	     strcpy(m->map[kount].stroke[k].name, map.name);
	     m->map[kount].stroke[k].latmin = mx1;
	     m->map[kount].stroke[k].latmax = mx2;
	     m->map[kount].stroke[k].lonmin = my1;
	     m->map[kount].stroke[k].lonmax = my2;
	     m->map[kount].stroke[k].index1 = j;
	     /* fprintf(stderr, "k=%d ii=%d %s \n",k, ii,  map.name); */
	     /*  fprintf(stdout,"MAPLINE %d %d %d %d %c %s %f %f %f %f %d\n",
		 k,
		 m->map[kount].stroke[k].num,
		 m->map[kount].stroke[k].style,
		 m->map[kount].stroke[k].col,
		 m->map[kount].stroke[k].code,
		 m->map[kount].stroke[k].name,
		 m->map[kount].stroke[k].latmin,
		 m->map[kount].stroke[k].latmax,
		 m->map[kount].stroke[k].lonmin, 
		 m->map[kount].stroke[k].lonmax,
		 m->map[kount].stroke[k].index1);*/
	     
	     k++;		
	     j+=ii;
	     
	     ii=0;
	     }
	  
	  
	  /* fprintf(stderr, "kount=%d i=%d n=%d map.num=%d\n", kount, i, n, map.num ); */
	  
	  m->map[kount].latlon[i].x = phis[n];
	  m->map[kount].latlon[i].y = lams[n];
	  m->map[kount].km[i].x = exs[n];
	  m->map[kount].km[i].y = whys[n];
	  
	  }
      
	if(left==1)
	  {
	  ii= 1;
	  
	  m->map[kount].stroke[k].num = ii;
	  m->map[kount].stroke[k].style = aone;
	  m->map[kount].stroke[k].col = athree;
	  m->map[kount].stroke[k].code = map.code;
	  strcpy(m->map[kount].stroke[k].name, map.name);
	  m->map[kount].stroke[k].latmin = mx1;
	  m->map[kount].stroke[k].latmax = mx2;
	  m->map[kount].stroke[k].lonmin = my1;
	  m->map[kount].stroke[k].lonmax = my2;
	  m->map[kount].stroke[k].index1 = j;
	  /* fprintf(stderr, "k=%d ii=%d %s \n",k, ii,  map.name); */	
	/*fprintf(stdout,"MAPLINE %d %d %d %d %c %s %f %f %f %f %d\n",
		k,
		m->map[kount].stroke[k].num,
		m->map[kount].stroke[k].style,
		m->map[kount].stroke[k].col,
		m->map[kount].stroke[k].code,
		m->map[kount].stroke[k].name,
		m->map[kount].stroke[k].latmin,
		m->map[kount].stroke[k].latmax,
		m->map[kount].stroke[k].lonmin, 
		m->map[kount].stroke[k].lonmax,
		m->map[kount].stroke[k].index1);*/
	
	  k++;
	  j += ii;
	  }
      




			/* finished stroke  **/



      }



    
      
     
      free(phis);
      free(lams);
      free(exs);
      free(whys);
      free(wraps);

      sin=1;
      
    /* fprintf(stderr,"  IN\n"); */
      }
    else
      {
      /*  read through points and ignore them  */

      phis = XmapNewArray(float, map.num);
      lams = XmapNewArray(float, map.num);

      fread(phis, map.num, sizeof(float), mf);
      fread(lams, map.num, sizeof(float), mf);

      free(phis);
      free(lams);
    /* fprintf(stderr,"  OUT\n"); */
      sin=0;
      
      /* finished stroke  **/		
      }

    
    }

  m->map[kount].numpoints = i;
  m->map[kount].stroke_count = k;
  m->map_type = 2;
  m->map_flag = 1;
  strcpy(m->map[kount].file_name, mapfile);

  m->num_map_files++;

  fprintf(stderr, "GETMAP3 stroke count: %d\n", m->map[kount].stroke_count);
  fprintf(stderr, "GETMAP3 numpoints: %d\n", m->map[kount].numpoints); 

  fclose(mf);
  return(1);
  }

void make_xsect(mpic *mplot, xyxy *l);
Boolean CopyToXDipWindow(XDIP_PARMS *pxdipParms);

/* ---------------------------------------------------------------- */

int Load_Xsec(char *xsecfile, mpic *mplot)
  {
  FILE *mf;
  float phi, lam, phi2, lam2, x, y, xs_dip, min_xsdepth, max_xsdepth,
    max_xsfront, max_xsback;
  xyxy li;

  if((mf = fopen(xsecfile, "r")) == NULL)
    {
    fprintf(stderr, "Can't open xsec file %s .... continuing\n", xsecfile);
    return(0);
    }

  fprintf(stderr, " In Load_Xsec....\n");
  while(fscanf(mf,"%f %f %f %f %f %f %f %f %f",
	       &phi, &lam, &phi2, &lam2, &xs_dip, &min_xsdepth,	&max_xsdepth,
	       &max_xsfront, &max_xsback) > 0)
    {
    fprintf(stderr, "INPUT: %f %f %f %f %f %f %f %f %f\n", phi, lam,
	    phi2, lam2, xs_dip, min_xsdepth, max_xsdepth, max_xsfront,
	    max_xsback);

    mplot->xdipParms.dip = xs_dip;
    mplot->xdipParms.minz = min_xsdepth;
    mplot->xdipParms.maxz = max_xsdepth;
    mplot->xdipParms.front = max_xsfront;
    mplot->xdipParms.back = max_xsback;

    /* iokay = CopyToXDipWindow( &mplot->xdipParms); */

    

    geo2xy(mplot, phi, lam, &x, &y);
    li.x1 = user_to_pix_x(&mplot->gr, x);
    li.y1 = user_to_pix_y(&mplot->gr, y);

    

    geo2xy(mplot, phi2, lam2, &x, &y);
    li.x2 = user_to_pix_x(&mplot->gr, x);
    li.y2 = user_to_pix_y(&mplot->gr, y);

    fprintf(stderr, "LINE: %d %d %d %d\n", li.x1, li.y1, li.x2, li.y2);
    make_xsect(mplot, &li);

 

    }

  fclose(mf);
  return(1);
  }

/* ---------------------------------------------------------------- */
int Set_an_xsec(mpic *mplot)
  {
  
  float phi, lam, phi2, lam2, x, y, x2, y2, xs_dip, min_xsdepth, max_xsdepth,
    max_xsfront, max_xsback;
  double angle;
  
  xyxy li;

  float lat, lon , az, len, width,  mindepth ,maxdepth ;
  

  fprintf(stderr, "type in: Lat Lon azimuth(deg) Length(km) Width min-depth max-depth:\n");

  fscanf(stdin, "%f %f %f %f %f %f %f",  &lat, &lon , &az, &len, &width, &mindepth ,&maxdepth );
  fprintf(stderr, "%f %f %f %f %f %f %f",  lat, lon , az, len, width, mindepth ,maxdepth );

  phi= lat;
  lam= lon;

  geo2xy(mplot, lat, lon, &x, &y);

    angle = deg2rad(az);
    
  x2 = x+ len*cos( angle );
  y2 = y+ len*sin( angle );
   xy2geo(mplot,  &phi2, &lam2, x2, y2);
  
   xs_dip=0.0 ;
   min_xsdepth=mindepth ;
   
   max_xsdepth=maxdepth ;
   

   max_xsfront=width;
   max_xsback=width;
 

  fprintf(stderr, " In Set_an_xsec....\n");
/*   while(fscanf(mf,"%f %f %f %f %f %f %f %f %f", */
/* 	       &phi, &lam, &phi2, &lam2, &xs_dip, &min_xsdepth,	&max_xsdepth, */
/* 	       &max_xsfront, &max_xsback) > 0) */
    {
    fprintf(stderr, "INPUT: %f %f %f %f %f %f %f %f %f\n", phi, lam,
	    phi2, lam2, xs_dip, min_xsdepth, max_xsdepth, max_xsfront,
	    max_xsback);

    mplot->xdipParms.dip = xs_dip;
    mplot->xdipParms.minz = min_xsdepth;
    mplot->xdipParms.maxz = max_xsdepth;
    mplot->xdipParms.front = max_xsfront;
    mplot->xdipParms.back = max_xsback;

    /* iokay = CopyToXDipWindow( &mplot->xdipParms); */

    

    geo2xy(mplot, phi, lam, &x, &y);
    li.x1 = user_to_pix_x(&mplot->gr, x);
    li.y1 = user_to_pix_y(&mplot->gr, y);

    

    geo2xy(mplot, phi2, lam2, &x, &y);
    li.x2 = user_to_pix_x(&mplot->gr, x);
    li.y2 = user_to_pix_y(&mplot->gr, y);

    fprintf(stderr, "LINE: %d %d %d %d\n", li.x1, li.y1, li.x2, li.y2);
    make_xsect(mplot, &li);

 

    }

 
  return(1);
  }

/* ---------------------------------------------------------------- */
int Get_Wells(char *wellfile, mpic *m)
  {
  int i = 0, j, k, kount, nump, sty, co, numi, nwell, lith;
  float phi, lam, z, dx, dy, dz;
  FILE *mf;
  char alph[25], line[LINE_LENGTH];

  if((mf = fopen(wellfile, "r")) == NULL)
    {
    fprintf(stderr, "Can't open well file %s : try again!\n", wellfile);
    m->wells_flag = 0;
    return(0);
    }
  else j = 0;

  /* first determine how many wells there are so we can create the storage */

  j = nwell= 0;

  while((numi = getline(mf, line, LINE_LENGTH)) > 0)
    {

     if(!strncmp(line, "#", 1))
 	{
	  
	  continue;
	}
     else
       {
	 sscanf(line, "%s %d %d %d", alph, &nump, &sty, &co);
	 
	 
	}
     
    
    j += nump;
    for(i = 0; i < nump; i++)
       {
	 getline(mf, line, LINE_LENGTH);
	 if(!strncmp(line, "#", 1))
	   {
	     i--;
	     continue;
	   }

       }
    nwell++;
    }

  fclose(mf);

  
  
  mf = fopen(wellfile,"r");
  kount = m->num_wells_files;

  /* m->wells[kount] = (Wells_File *) malloc (sizeof (Wells_File)); */

  m->wells[kount].well = XmapNewArray(Well, nwell);
  strcpy(m->wells[kount].file_name, wellfile);

  j = k = 0;

  /*  here style (sty) is a free parameter.
      now we will start using it to separate different
      kinds of well data information :
      
      sty = 0   ->  regular well with lat lon z
      sty = 1   ->  well with lat lon z lithology
      sty = 2   ->            lat lon z x y z of dipmeter
      sty = 3   ->            lat lon z x y z lithology
      
      */

  while((numi = getline(mf, line, LINE_LENGTH)) > 0)
    {
      
      if(!strncmp(line, "#", 1))
 	{
	  continue;
	}
      else
	{
	  sscanf(line, "%s %d %d %d", alph, &nump, &sty, &co);
	}


      
    j += nump;

    m->wells[kount].well[k].loc = XmapNewArray(fxyz, nump);
    m->wells[kount].well[k].dip = XmapNewArray(fxyz, nump);
    m->wells[kount].well[k].lith = XmapNewArray(int, nump);

    m->wells[kount].well[k].nump = nump;
    m->wells[kount].well[k].style = sty;
    m->wells[kount].well[k].color = co;
    strcpy(m->wells[kount].well[k].name, alph);

    for(i = 0; i < nump; i++)
      {
	
	getline(mf, line, LINE_LENGTH);
	  if(!strncmp(line, "#", 1))
	    {
	      i--;
	      continue;
	    }
	  else
	    {
	      switch(m->wells[kount].well[k].style)
		{
		  
		case 0:
		  sscanf(line, "%f %f %f ", &phi, &lam, &z);  
		  m->wells[kount].well[k].loc[i].x = phi;
		  m->wells[kount].well[k].loc[i].y = lam;
		  m->wells[kount].well[k].loc[i].z = z;
		  break;
		  
		case 1:
		  sscanf(line, "%f %f %f %d", &phi, &lam, &z, &lith);  
		  m->wells[kount].well[k].loc[i].x = phi;
		  m->wells[kount].well[k].loc[i].y = lam;
		  m->wells[kount].well[k].loc[i].z = z;
		  m->wells[kount].well[k].lith[i] = lith;
		  break;
		  
		case 2:
		  sscanf(line, "%f %f %f %f %f %f", &phi, &lam, &z, &dx, &dy, &dz);  
		  m->wells[kount].well[k].loc[i].x = phi;
		  m->wells[kount].well[k].loc[i].y = lam;
		  m->wells[kount].well[k].loc[i].z = z;
		  m->wells[kount].well[k].dip[i].x = DEGRAD * dx; 
		  m->wells[kount].well[k].dip[i].y = DEGRAD * dy;
		  m->wells[kount].well[k].dip[i].z = dz;
		  break;
		  
		case 3:
		  sscanf(line, "%f %f %f %f %f %f %d", &phi, &lam, &z, &dx, &dy, &dz,
			 &lith);
		  m->wells[kount].well[k].loc[i].x = phi;
		  m->wells[kount].well[k].loc[i].y = lam;
		  m->wells[kount].well[k].loc[i].z = z;
		  m->wells[kount].well[k].dip[i].x = DEGRAD * (90 - dx); /*strike */
		  m->wells[kount].well[k].dip[i].y = DEGRAD * dy; /* dip */
		  m->wells[kount].well[k].dip[i].z = dz;
		  m->wells[kount].well[k].lith[i] = lith;
		  break;
		}
	    }
      }
    k++;				/* finished well  **/
    }

  m->wells[kount].point_count = j;
  m->wells[kount].well_count = k;
  m->wells[kount].flag = 2;
  m->num_wells_files++;
  fclose(mf);
  return(1);
  }

/* ---------------------------------------------------------------- */

/* ---------------------------------------------------------------- */


int Get_ThreeD(char infile[200], mpic *mplot)
  {
  FILE *inf;
  char label[50];
  int i, j, n1, n2, col, kount, numi;
  float a1, a2, a3, px, py;
   char  line[LINE_LENGTH];
 
  fprintf(stderr, "Get Wireframe %d: reading file: %s\n", mplot->wire_num,
	  infile);
  if((inf = fopen(infile, "r")) == NULL)
    {
    printf("Can't open wireframe file: %s ....try again\n", infile);
    return(0);
    }

  kount = mplot->wire_num;
  
  strcpy(mplot->wire[kount].file_name, infile);

  while((numi = getline(inf, line, LINE_LENGTH)) > 0)
    {	
      if(!strncmp(line, "#", 1))
	{
	  
	  continue;
	}
      else
	{
	  sscanf(line, "%s %d", label, &n1);
	  break;
	}
    }
	
  strcpy(mplot->wire[kount].label, label);
  fprintf(stderr,"Label %s: num vectors= %d\n", mplot->wire[kount].label, n1);

  mplot->wire[kount].n = n1;
  mplot->wire[kount].poly = XmapNewArray(Slab, n1);

  for (i = 0; i < n1; i++)
    {
      numi = getline(inf, line, LINE_LENGTH);
      /* fprintf(stderr, "%s", line); */
      if(!strncmp(line, "#", 1))
	{
	  i--;
	 continue;
	}
      else
	{
	  sscanf(line, "%d %d", &n2, &col);
	  
	}
    
    mplot->wire[kount].poly[i].n = n2;
    mplot->wire[kount].poly[i].col = col;
    mplot->wire[kount].poly[i].kmloc = XmapNewArray(fxyz, n2);
    mplot->wire[kount].poly[i].latlon = XmapNewArray(fllz, n2);

    for(j = 0; j < n2; j++)
      {

      numi = getline(inf, line, LINE_LENGTH);
      if(!strncmp(line, "#", 1))
	{
	  j--;
	  continue;
	  
	}
      else
	{
	  sscanf(line, "%f %f %f", &a1, &a2, &a3);
	}
    	
      

      mplot->wire[kount].poly[i].latlon[j].phi = a1;
      mplot->wire[kount].poly[i].latlon[j].lam = a2;
      mplot->wire[kount].poly[i].latlon[j].z = a3;
      geo2xy(mplot, mplot->wire[kount].poly[i].latlon[j].phi,
	     mplot->wire[kount].poly[i].latlon[j].lam, &px, &py);
      mplot->wire[kount].poly[i].kmloc[j].x = px;
      mplot->wire[kount].poly[i].kmloc[j].y = py;
      mplot->wire[kount].poly[i].kmloc[j].z = a3;

      mplot->wire_tot++;
      }
    }

  mplot->wire_num++;
  mplot->wire_flag = 1;



  
  return(1);
  }
/***************/
void Get_Labels(mpic *mplot)
  {
  
  int i;
  char  savefile[100];
  FILE  *sf;
  int numi;
  char  line[LINE_LENGTH];
  float phi, lam, x, y;
  float rx,ry;
  float x1, y1, x2, y2;
  char lab[100];
  

  fprintf(stderr,"Type in the file for the labels:\n");
  fscanf(stdin,"%s", savefile);
  
    if((sf = fopen(savefile, "r")) == NULL)
    {
    fprintf(stderr,"Can't open file: %s ....try again\n",
	   savefile);
    return;
    }
  i=0;
    while((numi = getline(sf, line, LINE_LENGTH)) >= 1)
      {

    sscanf(line,"%s %f %f %f %f",
	    lab,
	    &x1,
	    &y1,
	    &x2,
	    &y2
	    );

    under2blank(lab);
    
    strcpy(mplot->labels[i].label, lab);
    
    mplot->labels[i].latlon.x1 = x1;
    mplot->labels[i].latlon.y1 = y1;
    mplot->labels[i].latlon.x2 = x2;
    mplot->labels[i].latlon.y2 = y2;
    

    phi = mplot->labels[i].latlon.x1;
    lam =mplot->labels[i].latlon.y1;
    
    geo2xy(mplot, phi, lam, &x, &y);
  mplot->labels[i].kmloc.x1 = x;
  mplot->labels[i].kmloc.y1 = y;

    rx = user_to_pix_x(&mplot->gr,    (double)x);
    ry = user_to_pix_y(&mplot->gr,    (double)y);
 

    mplot->labels[i].p.x1 =rx;
    mplot->labels[i].p.y1 = ry;
    
    phi = mplot->labels[i].latlon.x2;
    lam =mplot->labels[i].latlon.y2;
    
    geo2xy(mplot, phi, lam, &x, &y);
  mplot->labels[i].kmloc.x2 = x;
  mplot->labels[i].kmloc.y2 = y;

    rx = user_to_pix_x(&mplot->gr,    (double)x);
    ry = user_to_pix_y(&mplot->gr,    (double)y);


    mplot->labels[i].p.x2 =rx;
    mplot->labels[i].p.y2 = ry;
    

    i++;
    
    }
  mplot->num_labels = i;
  
  fclose(sf);
  
  }
/**************************/
void Get_legend(mpic *mplot, char *sfile)
  {

    FILE  *inf, *fopen();
    char   name[200];
    int icol;
    int i, num, legnum;
    int kchar;
     
    
   /*  fprintf(stderr,"Type in the name of the legend file:\n"); */
/*     fscanf(stdin, "%s", sfile); */
  
    num = Num_Lines(sfile);
      fprintf(stderr,"The name of the legend file: %s %d\n",  sfile, num);
    if((inf = fopen(sfile, "r")) == NULL)
      {
	printf("Can't open %s ....try again\n", sfile);
	return;
      }

    
    legnum = mplot->num_well_leg;
    
    mplot->well_leg[legnum].leg_in = XmapNewArray(Legend_Item, num);

    
      for(i=0; i<num; i++)
	{
	fscanf(inf, "%s %d", name, &icol);
	 /* fprintf(stderr, "%s %d %d\n", name, icol, strlen(name)); */ 

	/* mplot->well_leg[legnum].leg_in[i].name = (char *)calloc(strlen(name),sizeof(char)); */
	 kchar = strlen(name)+1;
	mplot->well_leg[legnum].leg_in[i].name = XmapNewArray(char,kchar);
	strcpy(mplot->well_leg[legnum].leg_in[i].name, name);
	mplot->well_leg[legnum].leg_in[i].col =icol; 
	 }
	fclose(inf);

	mplot->well_leg[legnum].Num = num;
	mplot->plot_well_leg = 1;
	mplot->num_well_leg++;

	/*
	for(i=0; i<num; i++)
	  {
	    fprintf(stderr, "%s %d\n", mplot->well_leg[legnum].leg_in[i].name, mplot->well_leg[legnum].leg_in[i].col);
	  }
	*/
 
    
	make_leg_win(mplot);


    
  }
