
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* void usleep(unsigned int useconds); */

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "user2pix.h"
#include "mpic.h"
#include "xsec.h"
#include "jutil.h"
#include "focproto.h"

int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);

void citoxyz(int nx, int ny, int nlay, int iway, int *i, int *ix, int *iy,
	     int *iz);



void J_to_XYZ(int nx, int ny, int nlay,  int j,  int *ix,  int *iy,  int *iz)
   {
   static float side;
   static int  nrem, lentop, i;
 
   /*  given an index i converts to [ ix iy iz] */

   i=j+1;
   
   lentop = nx * ny;
   side = (float) (nx);
   nrem = i % lentop;
    
   if (nrem == 0) 
      {
      nrem = lentop;
      *iz = i / lentop;
      } 
   else 
      {
      *iz = i / lentop + 1;
      }
   *iy = (int) ((float) (nrem - 1) / side) + 1;
   *ix = nrem - (*iy - 1) * nx;
   if (*ix == 0) 
      {
      *ix = nx;
      }
   } 

int Get_iv(int ix, int iy, int iz, int nx, int ny)
   { 
   int iv;
   
   iv = ix + nx*(iy-1)+(nx*ny)*(iz-1) - 1;
   return(iv);
   }
 


void Get_neigbors(int j , int nx, int ny, int nz, int ney[] )
   { 
    
   
    int ix, iy, iz;
    int k;
    /* neigbors are returned like this:

             2
           0 J 1_4(bot)
             3
             _5 (top)
    */

    J_to_XYZ(nx, ny, iz, j, &ix, &iy, &iz);
    k = ix -1;
    ney[0]  = Get_iv( k,  iy,  iz,  nx,  ny);
    k = ix + 1;
    ney[1]  = Get_iv( k,  iy,  iz,  nx,  ny);
    k = iy + 1;
    ney[2]  = Get_iv( ix,  k,  iz,  nx,  ny);
    k = iy - 1;
    ney[3]  = Get_iv( ix,  k,  iz,  nx,  ny);
    k = iz + 1;
    ney[4]  = Get_iv( ix,  iy,  k,  nx,  ny);
    k = iz - 1;
    ney[5]  = Get_iv( ix,  iy,  k,  nx,  ny);
    return;        


   }


void Simple_Render(mpic *mplot, float blx, float bly, float urx, float ury)
   {
   
   int i, ney[6];
    FILE *outf, *outi;

   int npoints, kall, kin, iway;
   int ix, iy, iz, j;
   
   float upper, lower, val;
   float  xorg, yorg, px1, py1, px2, py2, pz1, pz2;
   float phi1, lam1, phi2, lam2, phi3, lam3, phi4, lam4;
   
   xorg = mplot->image.org_minx;
   yorg = mplot->image.org_miny;

   iway = 1;
   kin=0;
   kall=0;
   
   npoints = mplot->image.nx * mplot->image.ny* mplot->image.nz;
   fprintf(stderr, "type in the min and max values to consider:\n");
   fscanf(stdin,"%f %f", &lower, &upper);
   /* fprintf(stderr, "type in the output file\n"); */
   /*    fscanf(stdin, */
   if((outf = fopen("dumpit_wire_frame", "w")) == NULL)
      {
      fprintf(stderr, "file could not be opened\n");
      return;
      }
   if((outi = fopen("dumpit_wire_frame_top", "w")) == NULL)
      {
      fprintf(stderr, "file could not be opened\n");
      return;
      }
      
   fprintf(stderr,"Bounds: %f %f %f %f\n", blx,  bly,  urx,  ury);
   
   for(i=0; i<npoints; i++)
      {
      if(mplot->image.val[i] == mplot->image.image_skip )  continue;
      if( mplot->image.val[i] < lower || mplot->image.val[i]>upper)continue;



      citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, 
	      iway, &i, &ix, &iy, &iz);
      px1 = xorg + (ix - 1) * mplot->image.dx;
      px2 = xorg + (ix) * mplot->image.dx;

      py1 = yorg + (iy-1) * mplot->image.dy;
      py2 = yorg + (iy) * mplot->image.dy;

      fprintf(stderr,"p1: %f %f\n", px1, py1);
      
      if( ((px1<blx) || (px1>urx) || (py1<bly) || (py1>ury)) )continue;
      
	 
      kin++;
      
      
      
      Get_neigbors( i ,  mplot->image.nx,  
		   mplot->image.ny,  mplot->image.nz,  ney );






      pz1 = mplot->image.z_parts[iz - 1];
      pz2 = mplot->image.z_parts[iz];

      xy2geo(mplot, &phi1, &lam1, px1, py1);
      xy2geo(mplot, &phi2, &lam2, px2, py1);
      xy2geo(mplot, &phi3, &lam3, px2, py2);
      xy2geo(mplot, &phi4, &lam4, px1, py2);

      /***   side 0  West ***/
      j = 0;	      
      if(ney[j]>0&&ney[j]<npoints)
	 {
	 val = mplot->image.val[ney[j]];
    
	 if( val==mplot->image.image_skip || val<lower || val>upper )
	    {
	    fprintf(outf,"4 1\n");
	    fprintf(outf,"%f %f %f\n", phi1, lam1, pz1);
	    fprintf(outf,"%f %f %f\n", phi4, lam4, pz1);
	    fprintf(outf,"%f %f %f\n", phi4, lam4, pz2);
	    fprintf(outf,"%f %f %f\n", phi1, lam1, pz2);	
            kall++;
	    }
	 }
      /***   side 1 East  ***/
      j = 1;	      
      if(ney[j]>0&&ney[j]<npoints)
	 {
	 val = mplot->image.val[ney[j]];
    
	 if( val==mplot->image.image_skip || val<lower || val>upper )
	    {
	    fprintf(outf,"4 1\n");
	    fprintf(outf,"%f %f %f\n", phi2, lam2, pz1);
	    fprintf(outf,"%f %f %f\n", phi3, lam3, pz1);
	    fprintf(outf,"%f %f %f\n", phi3, lam3, pz2);
	    fprintf(outf,"%f %f %f\n", phi2, lam2, pz2);	       
	    kall++;
	    }
	 }
      /***   side 2 North   ***/
      j = 2;	      
      if(ney[j]>0&&ney[j]<npoints)
	 {
	 val = mplot->image.val[ney[j]];
    
	 if( val==mplot->image.image_skip || val<lower || val>upper )
	    {
	    fprintf(outf,"4 1\n");
	    fprintf(outf,"%f %f %f\n", phi3, lam3, pz1);
	    fprintf(outf,"%f %f %f\n", phi4, lam4, pz1);
	    fprintf(outf,"%f %f %f\n", phi4, lam4, pz2);
	    fprintf(outf,"%f %f %f\n", phi3, lam3, pz2);	       
	    kall++;
	    }
	 }
      /***   side 3 South   ***/
      j = 3;	      
      if(ney[j]>0&&ney[j]<npoints)
	 {
	 val = mplot->image.val[ney[j]];
    
	 if( val==mplot->image.image_skip || val<lower || val>upper )
	    {
	    fprintf(outf,"4 1\n");
	    fprintf(outf,"%f %f %f\n", phi1, lam1, pz1);
	    fprintf(outf,"%f %f %f\n", phi2, lam2, pz1);
	    fprintf(outf,"%f %f %f\n", phi2, lam2, pz2);
	    fprintf(outf,"%f %f %f\n", phi1, lam1, pz2);	       
	    kall++;
	    }
	 }
      /***   side 4 Bottom  ***/
      j = 4;	      
      if(ney[j]>0&&ney[j]<npoints)
	 {
	 val = mplot->image.val[ney[j]];
    
	 if( val==mplot->image.image_skip || val<lower || val>upper )
	    {
	    fprintf(outf,"4 1\n");
	    fprintf(outf,"%f %f %f\n", phi1, lam1, pz2);
	    fprintf(outf,"%f %f %f\n", phi2, lam2, pz2);
	    fprintf(outf,"%f %f %f\n", phi3, lam3, pz2);
	    fprintf(outf,"%f %f %f\n", phi4, lam4, pz2);	       
	    kall++;
	    }
	 }
		 	 
      /***   side 5 top  ***/
      j = 5;	      
      if(ney[j]>0&&ney[j]<npoints)
	 {
	 val = mplot->image.val[ney[j]];
    
	 if( val==mplot->image.image_skip || val<lower || val>upper )
	    {
	    fprintf(outf,"4 1\n");
	    fprintf(outf,"%f %f %f\n", phi1, lam1, pz1);
	    fprintf(outf,"%f %f %f\n", phi2, lam2, pz1);
	    fprintf(outf,"%f %f %f\n", phi3, lam3, pz1);
	    fprintf(outf,"%f %f %f\n", phi4, lam4, pz1);	       
	    kall++;
	    }
	 }
			 
      }

   fprintf(stderr,"KIN= %d\n",kin);
 
   fprintf(stderr,"R%g-%g %d\n",lower,upper,kall);
   fprintf(outi,"R%g-%g %d\n",lower,upper,kall);
   
   fclose(outf);
    fclose(outi);
   
/* cat dumpit_wire_frame_top  dumpit_wire_frame > wframe */
   }


 
