
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"

#include "wleg.h"


static int numwins=0;

static XtActionsRec actions[] =
  {
  /* {"key_xok",(XtActionProc)XDialogDoneAction}, */
    
  };
static char defaultTranslations[] =
  "#override\n"
  ;


/* --------------------------------------------------------- */
void Plot_WL(Display *dpy, Window xwin, GC gc, WLeg *wl)
  {
  int i,  x2, y, y2, bsiz = 24;
  mpic *mplot;
   int index;


  
   mplot = wl->mplot;
   index = wl->index;

  
   /*
  y = user_to_pix_y(&mplot->gr, mplot->origin.minx);
  y2 = user_to_pix_y(&mplot->gr, (double)((float)mplot->origin.maxy));
  x = user_to_pix_x(&mplot->gr, mplot->origin.minx);
  x2 = user_to_pix_x(&mplot->gr, (double)((float)mplot->origin.maxx));
  x2 = mplot->ScreenX - 50;

  */
x2 = 10;

  XSetFont(dpy, gc, mplot->fonts[1]);

  for(i = 0; i <mplot->well_leg[index].Num ; i++)
    {
      y = i%12;
      y2 = 10 + (y + 1) * bsiz;


      
      if(y==0 && i!=0) x2 += 200;
      
    /* printf("Geo-Table %s %d \n", mplot->well_leg[index].leg_in[i].name,
       mplot->well_leg[index].leg_in[i].col); */

    XSetForeground(dpy, gc, mplot->colors[XmapAppColor( mplot->well_leg[index].leg_in[i].col )]);
    XFillRectangle(dpy, xwin, gc, x2, y2, bsiz, bsiz);

    XSetForeground(dpy, gc, mplot->colors[XmapAppColor(mplot->text_col)]);
    XDrawRectangle(dpy, xwin, gc, x2, y2, bsiz, bsiz);

    XSetForeground(dpy, gc, mplot->colors[XmapAppColor(mplot->text_col)]);
    draw_just_text(dpy, xwin, gc, x2 + bsiz + 5, y2 + 3 * bsiz / 4,
		   mplot->well_leg[index].leg_in[i].name, HJ_LEFT, VJ_BASELINE);
    }   
  }
/* --------------------------------------------------------- */

static void redraw_wleg(Widget wij, void *client_data, Region exposed)
  {
  WLeg *WL;		/* The data to redraw */
  Display *d;		/* The display we're using */
  Window w;		/* The window we're drawing in */
  GC ggc;		/* The gc to use */
  Pixel *colors;	/* Color map */

  /* This must be first, before redrawing */

  XtVaGetValues(wij, XtNdata, &WL, NULL);
  /* printf("SWL->GGC: %lx\n", (long)WL->ggc); */
  w = XtWindow(wij);
  d = XtDisplay(wij);
  ggc = WL->ggc;
  colors = WL->colors;
  XSetRegion(d, ggc, exposed);

  /* Now get around to drawing */

 /*  printf("Drawing Legend WL\n"); */
  XSetForeground(d, ggc, colors[XmapAppColor(5)]);
  /* XDrawRectangle(d, w, ggc, 10, 10, 100, 100); */
  Plot_WL(d, w, ggc, WL);

  
 
  }

/* ----------------------------------------------------- */

/* Tells a widget to repaint one rectangle */

static void send_repaint(Widget wij, int x, int y, int w, int h)
  {
  Region exposed;
  XRectangle r = { x, y, w, h };

  exposed = XCreateRegion();
  XUnionRectWithRegion(&r, exposed, exposed);
  redraw_wleg(wij, NULL, exposed);
  XDestroyRegion(exposed);
  }

/* --------------------------------------------------------- */

static void quit()
  {

  exit(0);
  }

void init_wleg_class(XtAppContext apcon)
  {

  XtAppAddActions(apcon, actions, XtNumber(actions));
  }

/* --------------------------------------------------------- */

static void destroy_wleg(Widget wij, void *client_data, void *server_data)
  {
  WLeg *m;

  XtVaGetValues(wij, XtNdata, &m, NULL);
  XmapFree(m);
  printf("\nDestroying wleg!\n");
  }



/* Given an already-created GenWidget, and an wleg structure with
    data in it, initializes the rest of the stuff in wleg, and attaches it
    and the widget together, also puts translations into the widget. */

static void init_wleg_wij(Widget w, WLeg *m, Pixel *colors, Font *fonts)
  {
  XGCValues xgc;

  xgc.function = GXnor;
  xgc.foreground = BlackPixelOfScreen(XtScreen(w));
  if(m == NULL) return;
  m->ggc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		     GCForeground, &xgc);
 
  m->colors = colors;
  m->fonts = fonts;
  m->wij = w;
  XtVaSetValues(w, XtNdata, m, NULL);
  XtAddCallback(w, XtNredraw, (XtCallbackProc)redraw_wleg, NULL);
  XtAddCallback(w, XtNdestroy, (XtCallbackProc)destroy_wleg, NULL);
  }
/* ------------------------------------------------------------------ */

static void quit_window(Widget wij, WLeg *pf, char *call_data)
  {

  XtDestroyWidget(pf->shell);
  }
/* ------------------------------------------------------------------ */


static void make_wleg_window(Widget top, WLeg *WL, Pixel *colors, Font *fonts)
  {
  int lx, ly;
  int  bc;
  
  Widget xp, box, menu, gen, pane;

  

  lx =  500;
  ly =  500;
 
/* fprintf(stderr,"in make_wleg_window.......\n"); */

 pane = XtVaCreateManagedWidget("pane", panedWidgetClass, top,
				 XtNwidth, lx,XtNheight, ly,
				 XtNallowHoriz, FALSE, XtNallowVert, FALSE,
				 NULL);
 
  /* fprintf(stderr,"in make_wleg_window pane\n"); */
  
  box = XtVaCreateManagedWidget("control", boxWidgetClass, pane, NULL);
/*  fprintf(stderr,"in make_wleg_window box\n"); */
 
  xp = XtVaCreateManagedWidget("viewport", viewportWidgetClass, pane, NULL);
/* fprintf(stderr,"in make_wleg_window viewport\n"); */
 
  gen = XtVaCreateManagedWidget("core", genWidgetClass, xp,
				XtNtranslations,
				XtParseTranslationTable(defaultTranslations),
				XtNdata, WL, NULL);



  
  
  /* fprintf(stderr,"in make_wleg_window 1\n"); */
  
  init_wleg_wij(gen, WL, colors, fonts);
  WL->shell = top;

  /* fprintf(stderr,"in make_wleg_window 2\n"); */
  

  /* File menu */

 
  xp = XtVaCreateManagedWidget("File", menuButtonWidgetClass, box, NULL);
 
  XtVaGetValues(xp, XtNbackground, &bc, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);
 
  xp = XtVaCreateManagedWidget("Destroy Window", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)quit_window, WL);

  
 

  /* Done making widgets, let's see them. */
/* fprintf(stderr,"in make_wleg_window: RealizeWidget \n"); */
  XtRealizeWidget(top);
  }


void make_leg_win(mpic *mplot)
  {
    char name[20];
    int j;
    Colormap  xcmap;
    
    WLeg *WL;
    Widget top;
   

    /* fprintf(stderr, "going to make_wleg_window \n"); */
    numwins++;
    j=0;
    
    sprintf(name, "leg-%d\n", numwins);
    top = XtVaAppCreateShell(name, "Geotouch-legwin", applicationShellWidgetClass,
			     XtDisplay(mplot->wij), NULL);
    XtVaGetValues(mplot->shell, XtNcolormap, &xcmap , NULL);
    
     XtVaSetValues(top , XtNcolormap, xcmap , NULL);


    WL = XmapNewElement(WLeg);

    WL->mplot = mplot;

    WL->index = mplot->num_well_leg-1;
    /* fprintf(stderr, "going to make_wleg_window %d\n", WL->index); */
    
      make_wleg_window(top, WL, mplot->colors, mplot->fonts);
    
    XtVaSetValues(top, XtNwidth, 500, XtNheight, 500,
		  XtNx, 50, XtNy, 50, NULL);
    
  }
