
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "focproto.h"
#include "jutil.h"
#include "user2pix.h"
#include "Rots.h"
#include "image_stuff.h"

/* --- macros --- */

#define DOTTED_LIST_LENGTH		2
#define DOT_DASHED_LIST_LENGTH		4
#define SHORT_DASHED_LIST_LENGTH	2
#define LONG_DASHED_LIST_LENGTH		2
#define ODD_DASHED_LIST_LENGTH		3
#define DEG2RAD				0.017453293

/* --- global variables --- */

static unsigned char dotted[DOTTED_LIST_LENGTH] = {3,1};
static unsigned char dot_dashed[DOT_DASHED_LIST_LENGTH] = {3,4,3,1};
static unsigned char short_dashed[SHORT_DASHED_LIST_LENGTH] = {4,4};
static unsigned char long_dashed[LONG_DASHED_LIST_LENGTH] = {4,7};
static unsigned char odd_dashed[ODD_DASHED_LIST_LENGTH] = {1,2,3};

static int dash_list_length[] =
  {
  DOTTED_LIST_LENGTH, DOT_DASHED_LIST_LENGTH, SHORT_DASHED_LIST_LENGTH,
  LONG_DASHED_LIST_LENGTH, ODD_DASHED_LIST_LENGTH
  };

unsigned int line_width = 0;
int line_style = LineSolid;
int cap_style = CapRound;
int join_style = JoinRound;

static unsigned char *dash_list[] =
  { dotted, dot_dashed, short_dashed, long_dashed, odd_dashed, };
int dash_offset = 0;

extern char MAPCODE[30];

/* --- function prototypes --- */

float get_mag_size(float mag, float minsize, float slope,  float minmag, float maxmag,
		   int style);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);


void citoxyz(int nx, int ny, int nlay, int iway, int *i, int *ix, int *iy,
	     int *iz);
void get_perim(float dir[3], float axis[3], float elip[][2], int *n);
void jrot(float r[3][3], float vec[3]);
void fixlips(int n, float elip[][2], float zee[], int *nout);
void Rot_Vec(float rmat[3][3], float *in, float *out);
double nrmliz(float in[3], float out[3]);
void draw_triang(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_triang_2(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_square(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_star_david(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_ex(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_Plus(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_Diamond(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_Circle(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_Fill_Circle(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_asterix(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_star5(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void fill_star5(Display *dpy, Window xwin, GC gc, int x, int y, int siz);



/*
0 = draw_triang = upside down triangle
1 = draw_triang_2 = right side up triangle
2 = draw_square = square
3 = draw_star_david = star of david
4 = draw_ex  =   X mark
5 = draw_Plus =  + mark
6 = draw_Diamond = diamond
*/

/* ---------------------------------------------------------------- */

/* --- functions --- */

void  plot_ThreeD(Display *dpy, Window xwin, GC gc, mpic *mplot)
  {
  int kount, i, j, n;
  XPoint p[FOC_TRACE];

  /* fprintf(stderr, "3D total files = %d\n", mplot->wire_num); */

  for(kount = 0; kount < mplot->wire_num; kount++)
    {
    for(i = 0; i < mplot->wire[kount].n; i++)
      {
      XSetForeground(dpy, gc,
        mplot->colors[XmapAppColor(mplot->wire[kount].poly[i].col)]);
      n = mplot->wire[kount].poly[i].n;

      /* fprintf(stderr, "3D Slab = %d  num=%d\n", i,n); */

      for(j = 0; j < n; j++)
	{
	p[j].x = user_to_pix_x(&mplot->gr,
			       mplot->wire[kount].poly[i].kmloc[j].x);
	p[j].y = user_to_pix_y(&mplot->gr,
			       mplot->wire[kount].poly[i].kmloc[j].y);

	/* fprintf(stderr, "PLOT %d %f %f %f\n", j,
	   mplot->wire[kount].poly[i].kmloc[j].x,
	   mplot->wire[kount].poly[i].kmloc[j].y,
	   mplot->wire[kount].poly[i].kmloc[j].z); */

	}
      p[j].x = user_to_pix_x(&mplot->gr,
			     mplot->wire[kount].poly[i].kmloc[0].x);
      p[j].y = user_to_pix_y(&mplot->gr,
			     mplot->wire[kount].poly[i].kmloc[0].y);

      XDrawLines(dpy, xwin, gc, p, n + 1, CoordModeOrigin);
      }
    }
  }

/* --------------------------------------------------------- */
int plot_color_image_scale(Display *dpy, Window xwin, GC gc, mpic *m)
  {  
  int i, bsiz = 5, xp, num, icol;
  char pchar[10];
  float currMin,currMax,diff;

  xp = user_to_pix_x(&m->gr, (double)m->origin.maxx) + 2;
  num = abs(m->MaxColor - m->MinColor);

  if(m->image_scale_flag == 0){
    currMin=m->image.Temp_image_min;
    currMax=m->image.Temp_image_max;
  }else{
    currMin=m->image.Layer_min[m->image_layer-1];
    currMax=m->image.Layer_max[m->image_layer-1];
  }
  diff=currMax-currMin;

  for(i = 0; i < num; i++){
    icol = i + m->MinColor;

    XSetForeground(dpy, gc, m->colors[XmapAppColor(icol)]); 
    XFillRectangle(dpy, xwin, gc, xp, (10 + i * bsiz), bsiz, bsiz);
  }

  /*Now print the values at N places on the scale*/
  if(!m->image_scale_log_flag){
    float currMin,currMax;
    int i,N=4;
    if(m->image_scale_flag == 0){
      currMin=m->image.Temp_image_min;
      currMax=m->image.Temp_image_max;
    }else{
      currMin=m->image.Layer_min[m->image_layer - 1];
      currMax=m->image.Layer_max[m->image_layer - 1];
    }
    for(i=0;i<N;i++){
      sprintf(pchar, "%#.3g ", 
	      (currMin*(N-1-i)+currMax*i)/(N-1));
      draw_just_text(dpy, xwin, gc, xp + bsiz + 5, 
		     10 + num*bsiz*i/(N-1) + bsiz,
		     pchar, HJ_LEFT, VJ_BASELINE);
    }
  }else{
    float currMin,currMax,currVal,diff;
    int i,N=4;
    if(m->image_scale_flag == 0){
      currMin=m->image.Temp_image_min;
      currMax=m->image.Temp_image_max;
    }else{
      currMin=m->image.Layer_min[m->image_layer - 1];
      currMax=m->image.Layer_max[m->image_layer - 1];
    }
    diff=log10(1.0+currMax-currMin);
    for(i=0;i<N;i++){
      currVal=currMin-1.0+pow(10.0,diff*i/(N-1));
      sprintf(pchar, "%#.3g ", 
	      currVal);
      draw_just_text(dpy, xwin, gc, xp + bsiz + 5, 
		     10 + num*bsiz*i/(N-1) + bsiz,
		     pchar, HJ_LEFT, VJ_BASELINE);
    }
  }
  return(1);
}

int plot_color_image_scale_old(Display *dpy, Window xwin, GC gc, mpic *m)
  {  
  int i, bsiz = 5, xp, num, icol;
  char pchar[10];

  xp = user_to_pix_x(&m->gr, (double)m->origin.maxx) + 2;
  num = abs(m->MaxColor - m->MinColor);

  for(i = 0; i < num; i++)
    {
    /* icol = ((m->MaxColor - m->MinColor - 1) * (i) / num) + m->MinColor; */
    icol = i + m->MinColor;

    XSetForeground(dpy, gc, m->colors[XmapAppColor(icol)]); 
    XFillRectangle(dpy, xwin, gc, xp, (10 + i * bsiz), bsiz, bsiz);
    }

  if(m->image_scale_flag == 0)
    {
    sprintf(pchar, "%f ", m->image.Temp_image_min);
    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
    draw_just_text(dpy, xwin, gc, xp + bsiz + 5, 10 + bsiz, pchar,
		   HJ_LEFT, VJ_BASELINE);
    sprintf(pchar, "%f ", m->image.Temp_image_max);
    draw_just_text(dpy, xwin, gc, xp + bsiz + 5, (10 + i * bsiz + bsiz),
		   pchar, HJ_LEFT, VJ_BASELINE);
    }
  else
    {
    sprintf(pchar, "%f ", m->image.Layer_min[m->image_layer-1]);
    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
    draw_just_text(dpy, xwin, gc, xp + bsiz + 5, 10 + bsiz, pchar,
		   HJ_LEFT, VJ_BASELINE);
    sprintf(pchar, "%f ", m->image.Layer_max[m->image_layer - 1]);
    draw_just_text(dpy, xwin, gc, xp + bsiz + 5, 10 + i * bsiz + bsiz,
		   pchar, HJ_LEFT, VJ_BASELINE);
    }
  return(1);
  }
/**************************************/
/**************************************/

void plot_sat_image(Display *dpy, Window xwin, GC gc, mpic *mplot)
  {
  int px, py, hsizex, hsizey, ix, iy, c, cpix;
  float xorg, yorg, x, y, phi, lam;
  int i;
  XColor rgb;
  enum { UL, LL, UR, LR, CE } reg_point;

  phi = mplot->satimage.lat;
  /* if(mplot->satimage.lon < 0) lam = -mplot->satimage.lon;
  else lam = mplot->satimage.lon;*/
	

 lam = mplot->satimage.lon;
 
 for(i=0; i<COLORS_MAX; i++)
    {

      rgb.pixel = i;
    /* XStoreColor(disp, col, &rgb); */
      XQueryColor(dpy, mplot->colmap , &rgb);
      /* fprintf(stderr,"mplot color[%d] :   %d %d %d : %ld\n", i, rgb.red, rgb.green,
       rgb.blue, rgb.pixel);
       */
    }

   fprintf(stderr,"plotting satellite image: plot_sat_image %f %f\n",
     phi, lam); 

  geo2xy(mplot, phi, lam, &xorg, &yorg);

  hsizex = abs((user_to_pix_x(&mplot->gr, (double)mplot->satimage.dx)
		- user_to_pix_x(&mplot->gr, (double)0)));
  hsizey = abs((user_to_pix_y(&mplot->gr, (double)0)
		- user_to_pix_y(&mplot->gr, (double)mplot->satimage.dy)));
  reg_point = mplot->satimage.regisflag;

  switch(reg_point)
    {
    case LL:
      for(c = 0, iy = 0; iy < mplot->satimage.sy; iy++)
	{
	for(ix = 0; ix < mplot->satimage.sx; ix++, c++)
	  {
	  cpix = (int)XmapQuantColor(mplot->satimage.pixels[c]);
	  XSetForeground(dpy, gc, cpix);
	  x = xorg + (ix) * mplot->satimage.dx;
	  y = yorg + (iy) * mplot->satimage.dy;
	  px = user_to_pix_x(&mplot->gr, (double)x);
	  py = user_to_pix_y(&mplot->gr, (double)y);

	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	  }
	}
      break;

    case UL:
      for(c = 0, iy = 0; iy < mplot->satimage.sy; iy++)
	{
	for(ix = 0; ix < mplot->satimage.sx; ix++, c++)
	  {
	  cpix = (int)XmapQuantColor(mplot->satimage.pixels[c]);
	  /* fprintf(stderr,"SAT Image: mplot=%d cpix=%d \n", mplot->satimage.pixels[c], cpix); */
	  
	  XSetForeground(dpy, gc, cpix);
	  x = xorg + (ix) * mplot->satimage.dx;
	  y = yorg - (iy) * mplot->satimage.dy;
	  px = user_to_pix_x(&mplot->gr, (double)x);
	  py = user_to_pix_y(&mplot->gr, (double)y);

	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	  }
	}
      break;

    case UR:
      for(c = 0, iy = 0; iy < mplot->satimage.sy; iy++)
	{
	for(ix = 0; ix < mplot->satimage.sx; ix++, c++)
	  {
	  cpix = (int)XmapQuantColor(mplot->satimage.pixels[c]);
	  XSetForeground(dpy, gc, cpix);
	  x = xorg - (ix) * mplot->satimage.dx;
	  y = yorg - (iy) * mplot->satimage.dy;
	  px = user_to_pix_x(&mplot->gr, (double)x);
	  py = user_to_pix_y(&mplot->gr, (double)y);
	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	  }
	}
      break;

    case LR:
      for(c = 0, iy = 0; iy < mplot->satimage.sy; iy++)
	{
	for(ix = 0; ix < mplot->satimage.sx; ix++, c++)
	  {
	  cpix = (int)XmapQuantColor(mplot->satimage.pixels[c]);
	  XSetForeground(dpy, gc, cpix);
	  x = xorg - (ix) * mplot->satimage.dx;
	  y = yorg + (iy) * mplot->satimage.dy;
	  px = user_to_pix_x(&mplot->gr, (double)x);
	  py = user_to_pix_y(&mplot->gr, (double)y);

	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	  }
	}
      break;

    case CE:
      break;

    default:
      for(c = 0, iy = 0; iy < mplot->satimage.sy; iy++)
	{
	for(ix = 0; ix < mplot->satimage.sx; ix++, c++)
	  {
	  cpix = (int)XmapQuantColor(mplot->satimage.pixels[c]);
	  XSetForeground(dpy, gc, cpix);
	  x = xorg + (ix) * mplot->satimage.dx;
	  y = yorg + (iy) * mplot->satimage.dy;
	  px = user_to_pix_x(&mplot->gr, (double)x);
	  py = user_to_pix_y(&mplot->gr, (double)y);

	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	  }
	}
      break;
    }
  }
/**************************************/
/**************************************/


void plot_image_gmt( Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int j, i, px, py, hsizex, hsizey, npoints, ix, iy, iz, iway = 1, start;
  float xorg, yorg, x, y;
  char pchar[20];
  int px1, px2, py1, py2;
  float phi1, phi2, lam1, lam2;
  int ixstart, ixend, iystart, iyend;

  
  if(m->image_layer > m->image.nz) m->image_layer = m->image.nz;
  if(m->image_layer < 1) m->image_layer = 1;

  /* fprintf(stderr,"plotting %d\n",m->image_layer); */

  npoints = m->image.nx * m->image.ny;

  /* phi = m->image.phi, lam = m->image.lam;
     geo2xy(m, phi, lam, &xorg, &yorg); */

  xorg = m->image.org_minx;
  yorg = m->image.org_miny;

  hsizex = abs((user_to_pix_x(&m->gr, (double)m->image.dx)
		- user_to_pix_x(&m->gr, (double)0)));
  hsizey = abs((user_to_pix_y(&m->gr, (double)0)
		- user_to_pix_y(&m->gr, (double)m->image.dy)));

  start = (m->image_layer - 1) * npoints;

   fprintf(stderr, "start=%d layer=%d npoints=%d\n\n", start,
     m->image_layer, npoints);

fprintf(stderr, "nx = %d ny = %d  nz = %d\n", m->image.nx, m->image.ny, m->image.nz);
fprintf(stderr, "phi=%f lam=%f\n", m->image.phi, m->image.lam);
fprintf(stderr, "dx=%f dy=%f\n", m->image.dx , m->image.dy);

   
 iway = 2;
 iz = 1;
 xy2geo(m, &phi1, &lam1, m->origin.minx, m->origin.maxy);
 ixstart = (int)((lam1 - m->image.lam+m->image.dx)/m->image.dx) ;
 iystart = (int)((m->image.phi - phi1 +m->image.dy)/m->image.dy); 

 xy2geo(m, &phi1, &lam1, m->origin.maxx, m->origin.miny);
 ixend = (int)((lam1 - m->image.lam+m->image.dx)/m->image.dx) ;
 iyend = (int)((m->image.phi - phi1 +m->image.dy)/m->image.dy); 


/* fprintf(stderr, "GMT PLOT: %d %d %d %d\n", ixstart, ixend, iystart , iyend ); */

 

 

 for(iy = iystart; iy <= iyend; iy++)
   {
     for(ix = ixstart; ix <= ixend; ix++)
       {
	 citoxyz(m->image.nx, m->image.ny, m->image.nz, iway, &j, &ix, &iy, &iz);
	 
	 i=j;
	 
     
    if(m->image.col[i] != 0)
      {
       citoxyz(m->image.nx, m->image.ny, m->image.nz, iway, &j, &ix, &iy, &iz);


 
       lam1 = m->image.lam + (ix - 1) * m->image.dx;
       lam2 = lam1 +  m->image.dx;

       phi1 = m->image.phi - (iy - 1) * m->image.dy;
       phi2 = phi1 -  m->image.dy;


       geo2xy(m, phi1, lam1, &xorg, &yorg);
        geo2xy(m, phi2, lam2, &x, &y);

      px1 = px =user_to_pix_x(&m->gr, (double)xorg);
      py1= py = user_to_pix_y(&m->gr, (double)yorg);
      px2 = user_to_pix_x(&m->gr, (double)x);
      py2 = user_to_pix_y(&m->gr, (double)y);

      hsizex = px2-px1;
      hsizey = py2-py1;

      if(hsizex<0)
	{
	  px = px2;
	  hsizex *= -1;
	}
      if(hsizey<0)
	{
	  py = py2;
	  hsizey *= -1;
	}
       /* if(i<50 || (i>2000 && i<2100)|| (i>20000 && i<20100)) */



      if(  (px >  m->gr.pix_xmin && px <  m->gr.pix_xmax)
	   &&
	   (py >  m->gr.pix_ymin && py <  m->gr.pix_ymax)
	   )
	{
	  /* fprintf(stderr,"%i %f %f %f %f %d %d %d %d %f %d\n", i, phi1, lam1,phi2, lam2, */
/* 		  px, py, hsizex,  hsizey, m->image.val[i], m->image.col[i]); */
	  
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->image.col[i])]);
	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	 }
      
      }
    }
    }
  XSetFont(dpy, gc, m->fonts[0]);
  plot_color_image_scale(dpy, xwin, gc, m);

  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
  sprintf(pchar, "Layer %d: %7.3f-%7.3f ", m->image_layer,
	  m->image.z_parts[m->image_layer - 1],
	  m->image.z_parts[m->image_layer]);

/*   draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, (double)0.75  */
/* 					      * m->origin.maxx), */
/* 		 user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2, pchar, */
/* 		 HJ_LEFT, VJ_BASELINE); */
/*  draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
0.75*((double) m->origin.maxx)-user_to_pix_x(&m->gr, (double)m->origin.minx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_LEFT, VJ_BASELINE);
*/
 XSetFont(dpy, gc, m->fonts[1]);
draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
((double) m->origin.maxx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_RIGHT, VJ_BASELINE);
  }
/**************************************/
void plot_image_glob( Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int j, i, px, py, hsizex, hsizey, npoints, ix, iy, iz, iway = 1, start;
  float xorg, yorg, x, y;
  char pchar[20];
  int px1, px2, py1, py2;
  float phi1, phi2, lam1, lam2;
  int ixstart, ixend, iystart, iyend;

    

  if(m->image_layer > m->image.nz) m->image_layer = m->image.nz;
  if(m->image_layer < 1) m->image_layer = 1;

  /* fprintf(stderr,"plotting %d  KIND=%d\n",m->image_layer, m->image.KIND ); */

  npoints = m->image.nx * m->image.ny;

  /* phi = m->image.phi, lam = m->image.lam;
     geo2xy(m, phi, lam, &xorg, &yorg); */

  xorg = m->image.org_minx;
  yorg = m->image.org_miny;

  hsizex = abs((user_to_pix_x(&m->gr, (double)m->image.dx)
		- user_to_pix_x(&m->gr, (double)0)));
  hsizey = abs((user_to_pix_y(&m->gr, (double)0)
		- user_to_pix_y(&m->gr, (double)m->image.dy)));

  start = (m->image_layer - 1) * npoints;

/*    fprintf(stderr, "start=%d layer=%d npoints=%d\n\n", start, */
/*      m->image_layer, npoints); */

/* fprintf(stderr, "nx = %d ny = %d  nz = %d\n", m->image.nx, m->image.ny, m->image.nz); */
/* fprintf(stderr, "phi=%f lam=%f\n", m->image.phi, m->image.lam); */
/* fprintf(stderr, "dx=%f dy=%f\n", m->image.dx , m->image.dy); */

   
 iway = 2;
 iz = m->image_layer;

 xy2geo(m, &phi1, &lam1, m->origin.minx, m->origin.maxy);

 ixstart = (int)((lam1 - m->image.lam+m->image.dx)/m->image.dx) ;
 iystart = (int)((m->image.phi - phi1 +m->image.dy)/m->image.dy); 

 xy2geo(m, &phi1, &lam1, m->origin.maxx, m->origin.miny);

 ixend = (int)((lam1 - m->image.lam+m->image.dx)/m->image.dx) ;
 iyend = (int)((m->image.phi - phi1 +m->image.dy)/m->image.dy); 


/* fprintf(stderr, "GMT PLOT: %d %d %d %d\n", ixstart, ixend, iystart , iyend ); */

 

 ixstart = 1;
 iystart = 1;
 ixend = m->image.nx;
 iyend =  m->image.ny ;


 /* fprintf(stderr, "GLOBE  PLOT: %d %d %d %d\n", ixstart, ixend, iystart , iyend );  */

 

 for(iy = iystart; iy <= iyend; iy++)
   {
     for(ix = ixstart; ix <= ixend; ix++)
       {
	 citoxyz(m->image.nx, m->image.ny, m->image.nz, iway, &j, &ix, &iy, &iz);
	 
	 i=j;
	 
     
    if(m->image.col[i] != 0)
      {
       citoxyz(m->image.nx, m->image.ny, m->image.nz, iway, &j, &ix, &iy, &iz);


 
       lam1 = m->image.lam + (ix - 1) * m->image.dx;
       lam2 = lam1 +  m->image.dx;

       phi1 = m->image.phi + (iy - 1) * m->image.dy;
       phi2 = phi1 +  m->image.dy;


       geo2xy(m, phi1, lam1, &xorg, &yorg);
        geo2xy(m, phi2, lam2, &x, &y);

      px1 = px =user_to_pix_x(&m->gr, (double)xorg);
      py1= py = user_to_pix_y(&m->gr, (double)yorg);
      px2 = user_to_pix_x(&m->gr, (double)x);
      py2 = user_to_pix_y(&m->gr, (double)y);

      hsizex = px2-px1;
      hsizey = py2-py1;

      if(hsizex<0)
	{
	  px = px2;
	  hsizex *= -1;
	}
      if(hsizey<0)
	{
	  py = py2;
	  hsizey *= -1;
	}
       /* if(i<50 || (i>2000 && i<2100)|| (i>20000 && i<20100)) */



      if(  (px >  m->gr.pix_xmin && px <  m->gr.pix_xmax)
	   &&
	   (py >  m->gr.pix_ymin && py <  m->gr.pix_ymax)
	   )
	{
	   /*
	     fprintf(stderr,"%i %f %f %f %f %d %d %d %d %f %d\n", i, phi1, lam1,phi2, lam2,
		  px, py, hsizex,  hsizey, m->image.val[i], m->image.col[i]);
	   */
	  
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->image.col[i])]);
	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	 }
      
      }
    }
    }
 /* fprintf(stderr,"DONE plotting GLOBE\n"); */

#if 1
  XSetFont(dpy, gc, m->fonts[0]);
  plot_color_image_scale(dpy, xwin, gc, m);

  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
  sprintf(pchar, "Layer %d: %7.3f-%7.3f ", m->image_layer,
	  m->image.z_parts[m->image_layer - 1],
	  m->image.z_parts[m->image_layer]);

/*   draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, (double)0.75  */
/* 					      * m->origin.maxx), */
/* 		 user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2, pchar, */
/* 		 HJ_LEFT, VJ_BASELINE); */
/*  draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
0.75*((double) m->origin.maxx)-user_to_pix_x(&m->gr, (double)m->origin.minx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_LEFT, VJ_BASELINE);
*/
 XSetFont(dpy, gc, m->fonts[1]);
draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
((double) m->origin.maxx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_RIGHT, VJ_BASELINE);
#endif

  }
/**************************************/
/**************************************/

void plot_gmt_imageB( Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int j, i, px, py, hsizex, hsizey, npoints, ix, iy, iz, iway = 1, start;
  float xorg, yorg, x, y;
  char pchar[20];
  int px1, px2, py1, py2;
  float phi1, phi2, lam1, lam2;

  
  if(m->image_layer > m->image.nz) m->image_layer = m->image.nz;
  if(m->image_layer < 1) m->image_layer = 1;

  /* fprintf(stderr,"plotting %d\n",m->image_layer); */

  npoints = m->image.nx * m->image.ny;

  /* phi = m->image.phi, lam = m->image.lam;
     geo2xy(m, phi, lam, &xorg, &yorg); */

  xorg = m->image.org_minx;
  yorg = m->image.org_miny;

  hsizex = abs((user_to_pix_x(&m->gr, (double)m->image.dx)
		- user_to_pix_x(&m->gr, (double)0)));
  hsizey = abs((user_to_pix_y(&m->gr, (double)0)
		- user_to_pix_y(&m->gr, (double)m->image.dy)));

  start = (m->image_layer - 1) * npoints;

   fprintf(stderr, "start=%d layer=%d npoints=%d\n\n", start,
     m->image_layer, npoints);

fprintf(stderr, "nx = %d ny = %d  nz = %d\n", m->image.nx, m->image.ny, m->image.nz);
fprintf(stderr, "phi=%f lam=%f\n", m->image.phi, m->image.lam);
fprintf(stderr, "dx=%f dy=%f\n", m->image.dx , m->image.dy);

   

  for(i = start; i < start + npoints; i++)
    {
    j = i;

    if(m->image.col[i] != 0)
      {
       citoxyz(m->image.nx, m->image.ny, m->image.nz, iway, &j, &ix, &iy, &iz);


 
       lam1 = m->image.lam + (ix - 1) * m->image.dx;
       lam2 = lam1 +  m->image.dx;

       phi1 = m->image.phi - (iy - 1) * m->image.dy;
       phi2 = phi1 -  m->image.dy;


       geo2xy(m, phi1, lam1, &xorg, &yorg);
        geo2xy(m, phi2, lam2, &x, &y);

      px1 = px =user_to_pix_x(&m->gr, (double)xorg);
      py1= py = user_to_pix_y(&m->gr, (double)yorg);
      px2 = user_to_pix_x(&m->gr, (double)x);
      py2 = user_to_pix_y(&m->gr, (double)y);

      hsizex = px2-px1;
      hsizey = py2-py1;

      if(hsizex<0)
	{
	  px = px2;
	  hsizex *= -1;
	}
      if(hsizey<0)
	{
	  py = py2;
	  hsizey *= -1;
	}
       /* if(i<50 || (i>2000 && i<2100)|| (i>20000 && i<20100)) */



      if(  (px >  m->gr.pix_xmin && px <  m->gr.pix_xmax)
	   &&
	   (py >  m->gr.pix_ymin && py <  m->gr.pix_ymax)
	   )
	{
	  /* fprintf(stderr,"%i %f %f %f %f %d %d %d %d %f %d\n", i, phi1, lam1,phi2, lam2, */
/* 		  px, py, hsizex,  hsizey, m->image.val[i], m->image.col[i]); */
	  
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->image.col[i])]);
	  XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
	 }
      
      }
    }

  XSetFont(dpy, gc, m->fonts[0]);
  plot_color_image_scale(dpy, xwin, gc, m);

  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
  sprintf(pchar, "Layer %d: %7.3f-%7.3f ", m->image_layer,
	  m->image.z_parts[m->image_layer - 1],
	  m->image.z_parts[m->image_layer]);

/*   draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, (double)0.75  */
/* 					      * m->origin.maxx), */
/* 		 user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2, pchar, */
/* 		 HJ_LEFT, VJ_BASELINE); */
/*  draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
0.75*((double) m->origin.maxx)-user_to_pix_x(&m->gr, (double)m->origin.minx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_LEFT, VJ_BASELINE);
*/
 XSetFont(dpy, gc, m->fonts[1]);
draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
((double) m->origin.maxx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_RIGHT, VJ_BASELINE);
  }
/**************************************/
/**************************************/

void plot_image( Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int j, i, px, py, hsizex, hsizey, npoints, ix, iy, iz, iway = 1, start;
  float xorg, yorg, x, y;
  char pchar[20];

  if(m->image_layer > m->image.nz) m->image_layer = m->image.nz;
  if(m->image_layer < 1) m->image_layer = 1;

  /* fprintf(stderr,"plotting %d\n",m->image_layer); */

  npoints = m->image.nx * m->image.ny;

  /* phi = m->image.phi, lam = m->image.lam;
     geo2xy(m, phi, lam, &xorg, &yorg); */

  xorg = m->image.org_minx;
  yorg = m->image.org_miny;

  hsizex = abs((user_to_pix_x(&m->gr, (double)m->image.dx)
		- user_to_pix_x(&m->gr, (double)0)));
  hsizey = abs((user_to_pix_y(&m->gr, (double)0)
		- user_to_pix_y(&m->gr, (double)m->image.dy)));

  start = (m->image_layer - 1) * npoints;

  /* fprintf(stderr, "start=%d layer=%d npoints=%d\n\n", start,
     m->image_layer, npoints); */

  for(i = start; i < start + npoints; i++)
    {
    j = i;

    if(m->image.col[i] != 0)
      {
      citoxyz(m->image.nx, m->image.ny, m->image.nz, iway, &j, &ix, &iy, &iz);
      x = xorg + (ix - 1) * m->image.dx;
      y = yorg + (iy) * m->image.dy;

      px = user_to_pix_x(&m->gr, (double)x);
      py = user_to_pix_y(&m->gr, (double)y);

      XSetForeground(dpy, gc, m->colors[XmapAppColor(m->image.col[i])]);
      XFillRectangle(dpy, xwin, gc, px, py, hsizex + 1, hsizey + 1);
      }
    }

  XSetFont(dpy, gc, m->fonts[0]);
  plot_color_image_scale(dpy, xwin, gc, m);

  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
  sprintf(pchar, "Layer %d: %7.3f-%7.3f ", m->image_layer,
	  m->image.z_parts[m->image_layer - 1],
	  m->image.z_parts[m->image_layer]);

/*   draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, (double)0.75  */
/* 					      * m->origin.maxx), */
/* 		 user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2, pchar, */
/* 		 HJ_LEFT, VJ_BASELINE); */
/*  draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
0.75*((double) m->origin.maxx)-user_to_pix_x(&m->gr, (double)m->origin.minx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_LEFT, VJ_BASELINE);
*/
 XSetFont(dpy, gc, m->fonts[1]);
draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
((double) m->origin.maxx))  , 
user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		 pchar,
		 HJ_RIGHT, VJ_BASELINE);
  }
/**************************************/
/**************************************/

void plot_sources(Display *dpy, Window xwin, GC gc, mpic *m)
   {
   int i, pcolor, hsize, circle = 23040;
   float bot, top;
  
   if( m->sources[m->current_src].numpoints > 0 )
      {
   
      XFillRectangle(dpy, xwin, gc, 12, 12 * m->current_src + 12 - 5, 5, 5);
      draw_just_text(dpy, xwin, gc, 19, 12 * m->current_src + 12,
		     m->sources[m->current_src].file_name, HJ_LEFT, VJ_BASELINE);
      }
   top = -10000;
   bot = +10000;
   if( m->src_in_layer == 1 && m->image.nz > 1)
      {
      top  = m->image.z_parts[m->image_layer - 1]; 
      bot  = m->image.z_parts[m->image_layer];
      }
   
   /* fprintf(stderr,"layer=%d  bot=%f  top=%f\n", m->image_layer, bot, top); */
  

   for(i = 0; i < m->sources[m->current_src].numpoints; i++)
      {
      if(m->sources[m->current_src].onoff[i] == 1  )
	 {
       
	 if( m->src_in_layer == 0 || (m->src_in_layer == 1 && m->sources[m->current_src].loc[i].z < bot  
				      && m->sources[m->current_src].loc[i].z >= top) )  
	    {
	    hsize = m->sources[m->current_src].size[i];
	    pcolor = m->sources[m->current_src].point_color[i];
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(pcolor)]);

	    switch(m->sources[m->current_src].style)
	       {
	       case 0:		/*  simple circle  */
	       XDrawArc(dpy, xwin, gc,
			user_to_pix_x(&m->gr,
				      (double)m->sources[m->current_src].loc[i].x)
			- hsize / 2,
			user_to_pix_y(&m->gr,
				      (double)m->sources[m->current_src].loc[i].y)
			- hsize / 2,
			hsize, hsize, 0, circle);
	       break;

	       case 1:		/* fancy circle  */
	       XFillArc(dpy, xwin, gc,
			user_to_pix_x(&m->gr,
				      (double)m->sources[m->current_src].loc[i].x)
			- hsize / 2,
			user_to_pix_y(&m->gr,
				      (double)m->sources[m->current_src].loc[i].y)
			- hsize / 2,
			hsize, hsize, 0, circle);

	       XSetForeground(dpy, gc, m->colors[XmapAppColor(m->draw_arc_col)]);
	       XDrawArc(dpy, xwin, gc,
			user_to_pix_x(&m->gr,
				      (double)m->sources[m->current_src].loc[i].x)
			- hsize / 2,
			user_to_pix_y(&m->gr,
				      (double)m->sources[m->current_src].loc[i].y)
			- hsize / 2,
			hsize, hsize, 0, circle);
	       break;
	       }
	    }
	 }
    
      }	/* end plotting of sources   */

   }

/*   end plotting of sources   */

void plot_mag_scale(Display *dpy, Window xwin, GC gc, mpic *m)
   {
   int i, iy, ix = 20, hsize, circle = 23040, ypos, maxmag, minmag;
   char pchar[6];

   XSetForeground(dpy, gc, m->colors[XmapAppColor(m->magscale_col)]);
   hsize = m->SourceSize / 2;
   iy = 12 * (m->current_src + 1) + 12;
   ypos = iy;
   maxmag = (int)(m->max_mag + 1);
   minmag =(int)(m->min_mag - 1);
   for(i = minmag; i <= maxmag; i++)
      {
      ypos += hsize + 5;
      hsize = get_mag_size((float)i, (float)m->SourceSize,(float)m->SourceSlope, (float)minmag,
			   (float)maxmag, m->mag_src_flag);

      XDrawArc(dpy, xwin, gc, ix-hsize / 2, ypos, hsize, hsize, 0, circle);
      sprintf(pchar, "%d", i);
      draw_just_text(dpy, xwin, gc, ix + hsize / 2, ypos + hsize / 2, pchar,
		     HJ_LEFT, VJ_CENTER);
      }
   }

/* ---------------------------------------------------------------- */

void plot_color_scale(Display *dpy, Window xwin, GC gc, mpic *m)
   {  
   int i, bsiz = 12;
   char pchar[6];

   for(i = 0; i < (m->MaxColor - m->MinColor); i++)
      {
      XSetForeground(dpy, gc, m->colors[XmapAppColor(m->MinColor + i)]); 
      XFillRectangle(dpy, xwin, gc, 50, (10 + i * bsiz), bsiz, bsiz);
      }

   sprintf(pchar, "%d km", (int)m->MinDepth);
   XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
   draw_just_text(dpy, xwin, gc, 50 + bsiz + 5, 10 + bsiz, pchar,
		  HJ_LEFT, VJ_BASELINE);
   sprintf(pchar, "%d km", (int)m->MaxDepth);
   draw_just_text(dpy, xwin, gc, 50 + bsiz + 5, (10 + i * bsiz + bsiz), pchar,
		  HJ_LEFT, VJ_BASELINE);
   }

/* ---------------------------------------------------------------- */

void connect_sources(Display *dpy, Window xwin, GC gc, mpic *m)
   {
   int a = 0, b = 1, i, j;

   for(j = 0; j < m->max_more_src - 1; j++) 
      {
      a = j, b = j + 1;
      XSetForeground(dpy, gc, m->colors[XmapAppColor(m->src_col-j)]);
      for(i = 0; i < m->sources[a].numpoints; i++)
	 { 
	 /* temporary: require that the sources be above MaxDepth for */
	 /* a connection to be made   */

	 if(m->sources[a].loc[i].z <= m->MaxDepth)
	    {
          
	    XDrawLine(dpy, xwin, gc, 
		      user_to_pix_x(&m->gr, (double)m->sources[a].loc[i].x),
		      user_to_pix_y(&m->gr, (double)m->sources[a].loc[i].y),
		      user_to_pix_x(&m->gr, (double)m->sources[b].loc[i].x), 
		      user_to_pix_y(&m->gr, (double)m->sources[b].loc[i].y));
	    }
	 }
      }
   }

/***********************************************/

void Plot_football3(Display *dpy, Window xwin, GC gc, JGRAPH *gr, float x,
		    float y, float dir[3], float axis[3], int nkount,
		    int itheta)
   {
   XPoint p[200];
   int ndim = 3, i, j, k, kk, ii, m, k1, k2, kount;
   float xp, yp, rnewplan[3], M[3][3], phi, theta, sphi, tem[3], rtem[3],
   atem[3], ctem[3], elip[360][2], zee[360];
   double dphi;

   jrot(M, dir);
   m = (int)(nkount / 2) + 1;
   dphi = 90.0 / (float)m;

   /* fprintf(stderr,"%d %d %f\n", nkount, m, dphi); */
   /* fprintf(stderr,"EGG: %f %f %f %f %f %f %f %f\n", x, y, dir[0], dir[1],
      dir[2], axis[0], axis[1], axis[2]); */

   for(ii = 0; ii < ndim; ii++)
      {
      k1 = (ii + 1) % ndim;
      k2 = (k1 + 1) % ndim;

      for(i = 0; i < nkount; i++)
	 {
	 phi = dphi * (i + 1) * DEG2RAD;
	 /* if(ii == 0) fprintf(stderr, "%d %f\n", i, dphi * (i + 1)); */
	 tem[ii] = axis[ii] * cos(phi);
	 sphi = sin(phi);
	 k = 0;

	 /* fprintf(ofile, "\n%% Next %.1f %.1f %.1f %d\n", dir[0], dir[1],
	    dir[2], i); */

	 for(j = 0; j < 360; j += itheta)
	    {
	    theta = j * DEG2RAD;

	    tem[k1] = axis[k1] * cos(theta) * sphi;
	    tem[k2] = axis[k2] * sin(theta) * sphi;

	    rnewplan[0] = tem[0] / sqr(axis[0]);
	    rnewplan[1] = tem[1] / sqr(axis[1]);
	    rnewplan[2] = tem[2] / sqr(axis[2]);
	    Rot_Vec(M, tem, rtem);
	    Rot_Vec(M, rnewplan, ctem);
	    elip[k][0] = rtem[0];
	    elip[k][1] = rtem[1];
	    nrmliz(ctem, atem);
	    zee[k] = atem[2];
	    k++;
	    }
	 elip[k][0] = elip[0][0];
	 elip[k][1] = elip[0][1];
	 zee[k] = zee[0];
	 k++;

	 /* fprintf(stderr, "fixlips k=%d\n", k); */
	 fixlips(k - 1, elip, zee, &kk);
	 kount = 0;

	 for(j = 0; j < kk; j++)
	    {
	    xp = elip[j][0] + x;
	    yp = elip[j][1] + y;
	    p[kount].x = user_to_pix_x(gr, (double)xp);
	    p[kount].y = user_to_pix_y(gr, (double)yp);
	    kount++;
	    }

	 XDrawLines(dpy, xwin, gc, p, kount, CoordModeOrigin);
	 }
      }
   }

/* ---------------------------------------------------------------- */

void Plot_LIPS(mpic *mplot)
   {
   XPoint p[200];
   int i, kount, klip, k, kk;
   float ang, degrad, fi, xp, yp, x, y, dirin[3], axis[3], dir[3], elip[360][2];
   double  phir,a, b;
   
   degrad = 0.0174532;
   ang = 0.0;
   
   /*
      fprintf(stderr, "type in x y a b ang\n");
      fscanf(stdin, "%f %f %f %f %f", &x, &y, &a, &b, &fi);
      */
   
   if(mplot->lip_flag == 0) return;
   dirin[0] = 0;
   dirin[1] = 0;
   dirin[2] = -1;
   fi = 0;
   for(klip = 0; klip < mplot->lip_num; klip++)
      {
      for(k = 0; k < mplot->lip[klip].n; k++)
	 {
	 geo2xy(mplot, mplot->lip[klip].lips[k].latlon.phi,
		mplot->lip[klip].lips[k].latlon.lam, &x, &y);

	 if(mplot->lip[klip].lips[k].ind==0)
	    {
   
	    axis[0] = mplot->lip[klip].lips[k].lambda[0];
	    axis[1] = mplot->lip[klip].lips[k].lambda[1];
	    axis[2] = mplot->lip[klip].lips[k].lambda[2];
   
	    dir[0] = (mplot->lip[klip].lips[k].vec[0][0] * dirin[0]
		      + mplot->lip[klip].lips[k].vec[0][1] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[0][2] * dirin[2]);
	    dir[1] = (mplot->lip[klip].lips[k].vec[1][0] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[1][1] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[1][2] * dirin[2]);
	    dir[2] = (mplot->lip[klip].lips[k].vec[2][0] * dirin[2]
		      + mplot->lip[klip].lips[k].vec[2][1] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[2][2] * dirin[2]);

	    /* fprintf(stderr, "PLIP: %f %f %f %f %f %f %f %f\n", x, y, dir[0],
	       dir[1], dir[2], axis[0], axis[1], axis[2]); */

	    kount = 0;
	    get_perim(dir, axis, elip, &kk);
	    for(i = 0; i < kk; i++)
	       {
	       xp = elip[i][0] + x;
	       yp = elip[i][1] + y;
	       p[kount].x = user_to_pix_x(&mplot->gr, (double)xp);
	       p[kount].y = user_to_pix_y(&mplot->gr, (double)yp);
	       kount++;
	       }
   
	   
	    /* Plot_football3(XtDisplay(mplot->wij), XtWindow(mplot->wij),
	       mplot->ggc, &mplot->gr, x, y, dir, axis, nkount, itheta); */
	    }
	 else
	    {
	    fi = 0.0;
	    
	    phir = degrad * fi;
	    a = mplot->lip[klip].lips[k].ebar.x;
	    b = mplot->lip[klip].lips[k].ebar.y;
	    xp = (a * cos(ang) * cos(phir) - b * sin(ang) * sin(phir)) + x;
	    yp = (a * cos(ang) * sin(phir) + b * sin(ang) * cos(phir)) + y;
	    kount = 0;
	    p[kount].x = user_to_pix_x(&mplot->gr, (double)xp);
	    p[kount].y = user_to_pix_y(&mplot->gr, (double)yp);
	    kount++;
	    for(i = 10; i < 360; i += 10)
	       {
	       ang = degrad * i;
	       xp = (a * cos(ang) * cos(phir) - b * sin(ang) * sin(phir)) + x;
	       yp = (a * cos(ang) * sin(phir) + b * sin(ang) * cos(phir)) + y;
	       p[kount].x = user_to_pix_x(&mplot->gr, (double) xp);
	       p[kount].y = user_to_pix_y(&mplot->gr, (double) yp);
	       kount++;
	       }
	    p[kount].x = p[0].x;
	    p[kount].y = p[0].y;
	    kount++;
	    }

	 XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
			mplot->colors[XmapAppColor(1)]);
	 XDrawLines(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
		    p, kount, CoordModeOrigin);
   

	 }

      }



   }



/* ---------------------------------------------------------------- */

void plot_stations(Display *dpy, Window xwin, GC gc, mpic *m)
   {
   int i, k;

   XSetForeground(dpy, gc,
		  m->colors[XmapAppColor(m->stations[m->current_sta].color)]);

   /* fprintf(stderr, "station color = %d\n",
      m->colors[m->stations[m->current_sta].color]); */

   for(i = 0; i < m->stations[m->current_sta].numpoints; i++)
      {
      switch(m->stations[m->current_sta].symbol)
	 {
	 case 0:
	 draw_triang(dpy, xwin, gc,
		     user_to_pix_x(&m->gr,
				   (double)m->stations[m->current_sta].sta[i].loc.x),
		     user_to_pix_y(&m->gr,
				   (double)m->stations[m->current_sta].sta[i].loc.y), 
		     m->size_sta);
	 break;

	 case 1:
	 draw_triang_2(dpy, xwin, gc,
		       user_to_pix_x(&m->gr,
				     (double)m->stations[m->current_sta].sta[i].loc.x),
		       user_to_pix_y(&m->gr,
				     (double)m->stations[m->current_sta].sta[i].loc.y), 
		       m->size_sta);
	 break;

	 case 2:
	 draw_square(dpy, xwin, gc,
		     user_to_pix_x(&m->gr,
				   (double)m->stations[m->current_sta].sta[i].loc.x),
		     user_to_pix_y(&m->gr,
				   (double)m->stations[m->current_sta].sta[i].loc.y), 
		     m->size_sta);
	 break;

	 case 3:
	 draw_star_david(dpy, xwin, gc,
			 user_to_pix_x(&m->gr,
				       (double)m->stations[m->current_sta].sta[i].loc.x),
			 user_to_pix_y(&m->gr,
				       (double)m->stations[m->current_sta].sta[i].loc.y), 
			 m->size_sta);
	 break;

	 case 4:
	 draw_ex(dpy, xwin, gc,
		 user_to_pix_x(&m->gr,
			       (double)m->stations[m->current_sta].sta[i].loc.x),
		 user_to_pix_y(&m->gr,
			       (double)m->stations[m->current_sta].sta[i].loc.y), 
		 m->size_sta);
	 break;

	 case 5:
	 draw_Plus(dpy, xwin, gc,
		   user_to_pix_x(&m->gr,
				 (double)m->stations[m->current_sta].sta[i].loc.x),
		   user_to_pix_y(&m->gr,
				 (double)m->stations[m->current_sta].sta[i].loc.y), 
		   m->size_sta);
	 break;

	 case 6:
	 draw_Diamond(dpy, xwin, gc,
		      user_to_pix_x(&m->gr,
				    (double)m->stations[m->current_sta].sta[i].loc.x),
		      user_to_pix_y(&m->gr,
				    (double)m->stations[m->current_sta].sta[i].loc.y), 
		      m->size_sta);
	 break;

	 default:
	 draw_triang(dpy, xwin, gc,
		     user_to_pix_x(&m->gr,
				   (double)m->stations[m->current_sta].sta[i].loc.x),
		     user_to_pix_y(&m->gr,
				   (double)m->stations[m->current_sta].sta[i].loc.y), 
		     m->size_sta);
	 break;
	 }
      }

   if(m->special_station_flag)
      {
      XSetForeground(dpy, gc, m->colors[XmapAppColor(m->special_sta_col)]);      
      for (i = 0; i < m->stations[m->current_sta].num_special_stations; i++)
	 {
	 k = m->stations[m->current_sta].special_stations[i];        
	 draw_triang(dpy, xwin, gc,
		     user_to_pix_x(&m->gr,
				   (double)m->stations[m->current_sta].sta[k].loc.x),
		     user_to_pix_y(&m->gr,
				   (double)m->stations[m->current_sta].sta[k].loc.y), 
		     m->size_sta);
	 }
      }
   }

/* ---------------------------------------------------------------- */

void plot_symbol(Display *dpy, Window xwin, GC gc, int ix, int iy, int sym,
		 int size)
   {
   switch(sym)
      {
      case 0:
      draw_triang(dpy, xwin, gc, ix, iy, size);
      break;

      case 1:
      draw_triang_2(dpy, xwin, gc, ix, iy, size);       
      break;

      case 2:
      draw_square(dpy, xwin, gc, ix, iy, size);
      break;

      case 3:
      draw_star_david(dpy, xwin, gc, ix, iy, size); 
      break;

      case 4:
      draw_ex(dpy, xwin, gc, ix, iy, size);
      break;

      case 5:
      draw_Plus(dpy, xwin, gc, ix, iy, size);
      break;

      case 6:
      draw_Diamond(dpy, xwin, gc, ix, iy, size);
      break;

      case 7:
      draw_Circle(dpy, xwin, gc, ix, iy, size);
      break;

      case 8:
      draw_Fill_Circle(dpy, xwin, gc, ix, iy, size);
      break;

      case 9:
      draw_asterix(dpy, xwin, gc, ix, iy, size);
      break;

      case 10:
      draw_star5(dpy, xwin, gc, ix, iy, size);
      break;

      case 11:
      fill_star5(dpy, xwin, gc, ix, iy, size);
      break;



      default:
      draw_triang(dpy, xwin, gc, ix, iy, size);
      break;
      }
   }

/* ---------------------------------------------------------------- */

void plot_one_point(mpic *m, Display * dpy, Window xwin, GC gc, int ix,
		    int iy, int kount, int i)
   {

#if 0
   name
   color, fsize, symbol, symsize
   symcode;			/* symbol 0 = off 1 = on */
   strcode;			/* string 0 = off 1 = on */
   just;			/* HJ_LEFT=0, HJ_CENTER=1, HJ_RIGHT=2 */
   lat, lon, depth;
#endif


   XSetForeground(dpy, gc,
		  m->colors[XmapAppColor(m->Mpoint[kount].points[i].color)]);

   if(m->Mpoint[kount].points[i].symcode == 1)
      {
      plot_symbol(dpy, xwin, gc, ix, iy, m->Mpoint[kount].points[i].symbol,
		  m->Mpoint[kount].points[i].symsize);
      }
   if(m->Mpoint[kount].points[i].strcode == 1)
      {
      if(m->Mpoint[kount].points[i].fsize < 12) XSetFont(dpy, gc, m->fonts[0]);
      else XSetFont(dpy, gc, m->fonts[2]);

      if(m->Mpoint[kount].points[i].symcode == 0)
	 {
	 draw_just_text(dpy, xwin, gc, ix, iy, m->Mpoint[kount].points[i].name,
			m->Mpoint[kount].points[i].just, VJ_BASELINE);
	 }
      else
	 {
	 switch(m->Mpoint[kount].points[i].just)
	    {
	    case 0:
	    draw_just_text(dpy, xwin, gc,
			   ix + m->Mpoint[kount].points[i].symsize / 2,
			   iy - m->Mpoint[kount].points[i].symsize / 2,
			   m->Mpoint[kount].points[i].name,
			   m->Mpoint[kount].points[i].just, VJ_BASELINE);
	    break;

	    case 1:
	    draw_just_text(dpy, xwin, gc, ix,
			   iy - m->Mpoint[kount].points[i].symsize / 2,
			   m->Mpoint[kount].points[i].name,
			   m->Mpoint[kount].points[i].just, VJ_BASELINE);
	    break;

	    case 2:
	    draw_just_text(dpy, xwin, gc,
			   ix - m->Mpoint[kount].points[i].symsize / 2,
			   iy - m->Mpoint[kount].points[i].symsize / 2,
			   m->Mpoint[kount].points[i].name,
			   m->Mpoint[kount].points[i].just, VJ_BASELINE);
	    break;
	    }
	 }
      }
   }

void Plot_Points(Display * dpy, Window xwin, GC gc, mpic *m)
   {
   int i, ix, iy, kount;
   float px, py;

   for(kount = 0; kount < m->point_flag; kount++)
      {
      for(i = 0; i < m->Mpoint[kount].numpoints; i++)
	 {
	 geo2xy(m, m->Mpoint[kount].points[i].lat,
		m->Mpoint[kount].points[i].lon, &px, &py);
	 ix = user_to_pix_x(&m->gr, (double)px);
	 iy = user_to_pix_y(&m->gr, (double)py);
	 plot_one_point(m, dpy, xwin, gc, ix, iy, kount, i);
	 }
      }
   }

/* --------------------------------------------------------- */

void draw_well(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
   {
   float sin30 = 0.5, cos30 = 0.866025, cos45 = 0.707107;
   int x2, y2, x3, y3, x4, y4, circle = 23040;

   x2 = x - siz * cos30;
   y2 = y - siz * sin30;
   x3 = x + siz * cos30;
   y3 = y - siz * sin30;
   x4 = x;
   y4 = y + siz;

   /* XDrawLine(dpy, xwin, gc,x2,y2,x3,y3);
      XDrawLine(dpy, xwin, gc,x3,y3,x4,y4);
      XDrawLine(dpy, xwin, gc,x4,y4,x2,y2); */

   x2 = x, y2 = y;

   XDrawArc(dpy, xwin, gc, x - (siz) / 2, y - (siz) / 2,	siz, siz, 0, circle);
   XDrawLine(dpy, xwin, gc, x + (siz) / 2, y, x + (siz) / 2 + siz / 3, y);
   XDrawLine(dpy, xwin, gc, x - (siz) / 2, y, x - (siz) / 2 - siz / 3, y);
   XDrawLine(dpy, xwin, gc, x, y + (siz) / 2, x, y + (siz) / 2 + siz / 3);
   XDrawLine(dpy, xwin, gc, x, y - (siz) / 2, x, y - (siz) / 2 - siz / 3);

   XDrawLine(dpy, xwin, gc, x + cos45 * (siz / 2), y + cos45 * (siz / 2),
	     x + cos45 * (siz / 2 + siz / 3), y + cos45 * (siz / 2 + siz / 3));
   XDrawLine(dpy, xwin, gc, x - cos45 * (siz / 2), y + cos45 * (siz / 2),
	     x - cos45 * (siz / 2 + siz / 3), y + cos45 * (siz / 2 + siz / 3));
   XDrawLine(dpy, xwin, gc, x + cos45 * (siz / 2), y - cos45 * (siz / 2),
	     x + cos45 * (siz / 2 + siz / 3), y - cos45 * (siz / 2 + siz / 3));
   XDrawLine(dpy, xwin, gc, x - cos45 * (siz / 2), y - cos45 * (siz / 2),
	     x - cos45 * (siz / 2 + siz / 3), y - cos45 * (siz / 2 + siz / 3));
   }

/* --------------------------------------------------------- */

void draw_Xmark(Display *dpy, Window xwin, GC gc, int x, int y, int siz)
   {
   float cos45 = 0.707107;

   XDrawLine(dpy, xwin, gc, x + cos45 * (siz / 2), y + cos45 * (siz / 2),
	     x - cos45 * (siz / 2), y - cos45 * (siz / 2));
   XDrawLine(dpy, xwin, gc, x - cos45 * (siz / 2), y + cos45 * (siz / 2),
	     x + cos45 * (siz / 2), y - cos45 * (siz / 2));
   }

/* --------------------------------------------------------- */

void draw_Arrow(Display *dpy, Window xwin, GC gc, int x1, int y1, int x2,
		int y2)
   {
   float sin30 = 0.5, cos30 = 0.866025, sin1, cos1, sina, cosa, dis;
   int siz = 12;

   XDrawLine(dpy, xwin, gc, x1, y1, x2, y2);
   dis = sqrt(sqr(x2 - x1) + sqr(y2 - y1));

   sin1 = (y1 - y2) / dis;
   cos1 = (x1 - x2) / dis;

   sina = sin1 * cos30 + cos1 * sin30;
   cosa = cos1 * cos30 - sin1 * sin30;
   XDrawLine(dpy, xwin, gc, x2, y2, x2 + siz * cosa, y2 + siz * sina);

   sina = sin1 * cos30 - cos1 * sin30;
   cosa = cos1 * cos30 + sin1 * sin30;
   XDrawLine(dpy, xwin, gc, x2, y2, x2 + siz * cosa, y2 + siz * sina);
   }

/* ---------------------------------------------------------------- */

void plot_wells(Display *dpy, Window xwin, GC gc, mpic *m, int kwell)
   {
   int i, ix,iy;
   float phi, lam, px, py;

   for(i = 0; i < m->wells[kwell].well_count; i++)
      {
      phi = m->wells[kwell].well[i].loc[0].x ;
      lam = m->wells[kwell].well[i].loc[0].y;

      geo2xy(m, phi, lam, &px, &py);
      /*  printf("%d %f %f \n", i, px, py); */
      ix = user_to_pix_x(&m->gr, (double)px);
      iy = user_to_pix_y(&m->gr, (double)py);

      XSetForeground(dpy, gc,
		     m->colors[XmapAppColor(m->wells[kwell].well[i].color)]);
      if(m->wells_symbol_flag == 1)
      draw_well(dpy, xwin, gc, ix, iy, m->size_well);

      if(m->wells_name_flag == 1)
      draw_just_text(dpy, xwin, gc, ix + m->size_well, iy - m->size_well,
		     m->wells[kwell].well[i].name, HJ_LEFT, VJ_BASELINE);
      }
   }

/* ---------------------------------------------------------------- */

void plot_project_wells(Display *dpy, Window xwin, GC gc, mpic *m, int kwell)
   {
     int i, j;
     float phi, lam, px, py;
     XPoint p[FOC_TRACE];
     char pchar[20];
     
     for(i = 0; i < m->wells[kwell].well_count; i++)
       {
	 /*
	  * fprintf(stderr,"%d %d %f %f %f ", i, m->hoz_slab_flag,
	  * m->wells[kwell].well[i].loc[0].z, m->hoz_slab_top,
	  * m->hoz_slab_bot);
	  */
	 
	 if((m->hoz_slab_flag == 1)
	    && ((m->wells[kwell].well[i].loc[0].z < m->hoz_slab_top)
		|| (m->wells[kwell].well[i].loc[0].z > m->hoz_slab_bot)))
	   {
	     /* fprintf(stderr,"  NOT plotting\n"); */
	     continue;
	   }
	 
	 /* fprintf(stderr,"  plotting\n"); */
	 
	 XSetForeground(dpy, gc,
			m->colors[XmapAppColor(m->wells[kwell].well[i].color)]);
	 for(j = 0; j < m->wells[kwell].well[i].nump; j++)
	   {
	     phi = m->wells[kwell].well[i].loc[j].x;
	     lam = m->wells[kwell].well[i].loc[j].y;
	     
	     geo2xy(m, phi, lam, &px, &py);
	     /* printf("%d %f %f \n", i, px, py); */
	     p[j].x = user_to_pix_x(&m->gr, (double)px);
	     p[j].y = user_to_pix_y(&m->gr, (double)py);
	   }

	 XDrawLines(dpy, xwin, gc, p, m->wells[kwell].well[i].nump,
		    CoordModeOrigin);
       }


     if(m->hoz_slab_flag == 1 )
	{
       
       XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
       sprintf(pchar, "Layer %d: %7.3f-%7.3f ", m->image_layer,
	       m->hoz_slab_top,
	       m->hoz_slab_bot);
       XSetFont(dpy, gc, m->fonts[1]);
       draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr, 
						   ((double) m->origin.maxx))  , 
		      user_to_pix_y(&m->gr, (double)m->origin.maxy) - 2  ,
		      pchar,
		      HJ_RIGHT, VJ_BASELINE);


       
       
     }
     




   }

void Plot_Cont_values(mpic *mplot)
   {
   int j, size = 3;
   float px, py, pz;
   char pchar[8];

   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(1)]);
   XSetFont(XtDisplay(mplot->wij), mplot->ggc, mplot->fonts[0]);

   for(j = 0; j < mplot->contParms.length_data; j++)
      {
      px = mplot->contParms.datapt[j].x;
      py = mplot->contParms.datapt[j].y;
      pz = mplot->contParms.datapt[j].z;

      XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
		     user_to_pix_x(&mplot->gr, px),
		     user_to_pix_y(&mplot->gr, py), size, size);
      sprintf(pchar, "%g", pz);

      draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
		     user_to_pix_x(&mplot->gr, px),
		     user_to_pix_y(&mplot->gr, py),
		     pchar, HJ_CENTER, VJ_BASELINE);
      }
   }

void Plot_Cont_points(mpic *mplot)
   {
   int j, size = 3;
   float px, py, pz;

   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(1)]);

   for(j = 0; j < mplot->contParms.length_data; j++)
      {
      px = mplot->contParms.datapt[j].x;
      py = mplot->contParms.datapt[j].y;
      pz = mplot->contParms.datapt[j].z;
      XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
		     user_to_pix_x(&mplot->gr, px),
		     user_to_pix_y(&mplot->gr, py), size, size);
      }
   }

void Plot_Labels(Display *dpy, Window xwin, GC gc, mpic *m)
   {
   int i;

   for(i = 0; i <= m->num_labels; i++) 
      {

#if 0
      XDrawLine(dpy, xwin, gc, m->labels[i].p.x1, m->labels[i].p.y1,
		m->labels[i].p.x2, m->labels[i].p.y2);
#endif

      if((m->labels[i].kmloc.x1 != m->labels[i].kmloc.x2)
	 && (m->labels[i].kmloc.y1 != m->labels[i].kmloc.y2))
	 {
	 draw_Arrow(dpy, xwin, gc, user_to_pix_x(&m->gr,m->labels[i].kmloc.x1), 
		    user_to_pix_y(&m->gr,m->labels[i].kmloc.y1),
		    user_to_pix_x(&m->gr,m->labels[i].kmloc.x2), 
		    user_to_pix_y(&m->gr,m->labels[i].kmloc.y2));
	 }

      draw_just_text(dpy, xwin, gc, user_to_pix_x(&m->gr,m->labels[i].kmloc.x1),
		     user_to_pix_y(&m->gr,m->labels[i].kmloc.y1),
		     m->labels[i].label, HJ_CENTER, VJ_BASELINE);
      }
   }

/* ---------------------------------------------------------------- */

void plot_focs(Display *dpy, Window xwin, GC gc, mpic *m, int kfoc)
   {
   float focrad, phi, lam, px, py, meanX, meanY, ax, ay, xi, tq, hsize;
   int i, j, circle = 23040, foc_color, ix, iy, ixpoint, iypoint, kx, ky, kx2,
   ky2, slip_siz = 3, ntype = 7, itype[7]={ 18, 23, 22, 21, 19, 20, 2 };
   XPoint p[1000];
   float bot, top;
   char *ctype[7] = { "strikeslip", "rev-oblSS", "obl-rev", "reverse",
		      "norm-oblSS", "obl-norm", "normal" };

   foc_color = m->focm_color - kfoc;
   if(foc_color < 0) foc_color = m->num_fixed_colors - 1;
   XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);
   hsize = m->SourceSize;
   if( m->foc_in_layer == 1 && m->image.nz > 1)
      {
      top  = m->image.z_parts[m->image_layer - 1]; 
      bot  = m->image.z_parts[m->image_layer];
      }
   
   if(m->focal_explode == 1 )	/* need to explode the focals  */
      {
      phi = m->focm[kfoc].meanPhi;
      lam = m->focm[kfoc].meanLam;
      geo2xy(m, phi, lam, &px, &py); 
      meanX = px;
      meanY = py;
      /* printf("Plotting focal file %d: %s\n", kfoc, m->focm[kfoc].file_name); */
      XSetForeground(dpy, gc, m->colors[XmapAppColor(m->exploding_line_col)]);
      XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);

      for(i = 0; i < m->focm[kfoc].numpoints; i++)
	 {

	 if(!m->focm[kfoc].focs[i].on_off)continue;
      
	 if( !(m->foc_in_layer == 0 || 
	       (m->foc_in_layer == 1 && m->focm[kfoc].focs[i].loc.z < bot  
		&& m->focm[kfoc].focs[i].loc.z >= top)) ) continue; 
      
	 phi = m->focm[kfoc].focs[i].loc.x ;
	 lam = m->focm[kfoc].focs[i].loc.y;
	 geo2xy(m, phi, lam, &px, &py); 
	 ixpoint = user_to_pix_x(&m->gr, (double)px);
	 iypoint = user_to_pix_y(&m->gr, (double)py);
	 ix = user_to_pix_x(&m->gr, (double)m->focm[kfoc].focs[i].explode_x);
	 iy = user_to_pix_y(&m->gr, (double)m->focm[kfoc].focs[i].explode_y);

	 if(m->focm_color == 0)
	 XSetForeground(dpy, gc,
			m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);
	 XDrawLine(dpy, xwin, gc, ixpoint, iypoint, ix, iy);
	 }

      /* printf("MEAN FOCALS %f %f %f\n", meanX, meanY, m->focm[kfoc].disMax); */
      }

   for(i = 0; i < m->focm[kfoc].numpoints; i++)
      {
      if(!m->focm[kfoc].focs[i].on_off)continue;

      if( !(m->foc_in_layer == 0 || 
	    (m->foc_in_layer == 1 && m->focm[kfoc].focs[i].loc.z < bot  
	     && m->focm[kfoc].focs[i].loc.z >= top)) ) continue; 

      phi = m->focm[kfoc].focs[i].loc.x ;
      lam = m->focm[kfoc].focs[i].loc.y;
      geo2xy(m, phi, lam, &px, &py); 

      /*  printf("%d %f %f \n", i, px, py); */
      ix = user_to_pix_x(&m->gr, (double)px) - m->size_focm / 2;
      iy = user_to_pix_y(&m->gr, (double)py) - m->size_focm / 2;
      focrad = m->size_focm / 2;

      if(m->focm[kfoc].scale_by_mag == 1)
	 {
	 if(m->focm[kfoc].minMag < m->focm[kfoc].maxMag)
	 focrad += (focrad * (m->focm[kfoc].focs[i].ac.mag
			      - m->focm[kfoc].minMag)
		    / (m->focm[kfoc].maxMag - m->focm[kfoc].minMag));
	 else focrad = m->size_focm / 2;
	 }

      /************ START EXPLODE   **********/

      if(m->focal_explode == 1)	/* need to explode the focals  */
	 {
	 ixpoint = user_to_pix_x(&m->gr, (double)px);
	 iypoint = user_to_pix_y(&m->gr, (double)py);

	 ix = user_to_pix_x(&m->gr, (double)m->focm[kfoc].focs[i].explode_x);
	 iy = user_to_pix_y(&m->gr, (double)m->focm[kfoc].focs[i].explode_y);
	 }

      /****************END EXPLODE**********************/

      else
	 {
	 ix = user_to_pix_x(&m->gr, (double)px);
	 iy = user_to_pix_y(&m->gr, (double)py);
	 }

      /* plot a circle  with the color chosen according to the ipol param */

      XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);

      switch(m->focal_plot_style)
	 {
	 case 5:
	 if(m->focm_color == 0)
	 XSetForeground(dpy, gc,
			m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);
	 for(j = 0; j < m->focm[kfoc].focs[i].numft1; j++)
	    {
	    p[j].x = ix + focrad * m->focm[kfoc].focs[i].fault[j].x;
	    p[j].y = iy - focrad * m->focm[kfoc].focs[i].fault[j].y;
	    }
	 XDrawLines(dpy, xwin, gc, p, m->focm[kfoc].focs[i].numft1,
		    CoordModeOrigin);

	 /* plot the slip direction find the pole of the auxiliary plane strk2,
	    dip2 */

	 xi = -0.0174532 * m->focm[kfoc].focs[i].fm.dip2;
	 tq = XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.strk2));
	 ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.strk2));
	 kx = ix + ax, ky = iy - ay;

	 /* xi =  1.570796327 - 0.0174532*m->focm[kfoc].focs[i].fm.dip2;
	    tq = 1.414213562*sin(xi/2.0);
	    ax = focrad*tq*sin(0.0174532*(m->focm[kfoc].focs[i].fm.strk2) );
	    ay = focrad*tq *cos(0.0174532*(m->focm[kfoc].focs[i].fm.strk2) ) ;
	    kx2 = ix + ax + slip_siz/2;
	    ky2 = iy - ay + slip_siz/2; */

	 XFillRectangle(dpy, xwin, gc, kx, ky, slip_siz, slip_siz);
	 break;

	 case 3:        
	 if(m->focm_color == 0)
	 XSetForeground(dpy, gc,
			m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);

	 /*    P-Axis   */       

	 xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.pdip;
	 tq = XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	 ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	 kx = ix + ax, ky = iy - ay;
	 xi =  1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.pdip;
	 /* this is the lower hemisphere point  */
	 tq = -XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.prot));
	 ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.prot));
	 kx2 = ix + ax, ky2 = iy - ay;

	 /* printf("P axis: kx ky kx2 ky2: %d %d %d %d ",kx,ky,kx2,ky2); */
	 XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);
 
	 /*     T-Axis    */

	 xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	 tq = -XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	 ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	 kx = ix + ax, ky = iy - ay;
	 xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	 /* this is the lower hemisphere point  */
	 tq = XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.trot));
	 ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.trot));
	 kx2 = ix + ax, ky2 = iy - ay;
	 XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);
	 XSetForeground(dpy, gc, m->colors[XmapAppColor(1)]);
	 /* end PT axis  style 3  */
	 break;

	 case 7:
	 if(m->focm_color == 0)
	 XSetForeground(dpy, gc,
			m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);

	 /*    P-Axis   */       

	 xi = 1.570796327 - 0.0174532*m->focm[kfoc].focs[i].fm.pdip;
	 tq = XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	 ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	 kx = ix + ax, ky = iy - ay;
	 xi =  1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.pdip;
	 /* this is the lower hemisphere point  */
	 tq = -XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.prot));
	 ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.prot));
	 kx2 = ix + ax, ky2 = iy - ay;

	 /* printf("P axis: kx ky kx2 ky2: %d %d %d %d ",kx,ky,kx2,ky2); */

	 XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);
	 break;

	 case 8:
	 if(m->focm_color == 0)
	 XSetForeground(dpy, gc,
			m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);

	 /*     T-Axis    */

	 xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	 tq = -XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	 ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	 kx = ix + ax, ky = iy - ay;
	 xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	 /* this is the lower hemisphere point */

	 tq = XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.trot));
	 ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.trot));
	 kx2 = ix + ax, ky2 = iy - ay;

	 XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);

	 XSetForeground(dpy, gc, m->colors[XmapAppColor(1)]);
	 break;

	 case 6:		/* Ralph Archuleta method   */         
	 if(m->focm_color == 0)
	 XSetForeground(dpy, gc,
			m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);
	 /*    strike line -Axis   */       

	 tq = 1.0;
	 xi =  0.0174532 * m->focm[kfoc].focs[i].fm.strk1 - 1.570796327;
	 ax = focrad * tq * sin(xi);
	 ay = focrad * tq * cos(xi);
	 kx = ix + ax, ky = iy - ay;
	 tq = -1.0;
	 ax = focrad * tq * sin(xi);
	 ay = focrad * tq * cos(xi);
	 kx2 = ix + ax, ky2 = iy - ay;
	 XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);
 
	 /*   Down  Dip line    */

	 xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.dip1;
	 tq = -XMAP_SQRT2 * sin(xi / 2.0);
	 ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.strk1));
	 ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.strk1));
	 kx = ix + ax, ky = iy - ay;
	 XDrawLine(dpy, xwin, gc, kx, ky, ix, iy);
	 break;

	 default:
	 if(m->focm[kfoc].focs[i].ipol == 0)
	    {
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->back_foc_col)]);
	    XFillArc(dpy, xwin, gc, ix - focrad, iy - focrad, focrad * 2,
		     focrad * 2, 0, circle);
	    if(m->focm_color == 0)
	    XSetForeground(dpy, gc,
			   m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);
	    else
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);
	    }
	 else  
	    {
	    if(m->focm_color == 0)
	    XSetForeground(dpy, gc,
			   m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);
	    else
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);

	    XFillArc(dpy, xwin, gc, ix - focrad, iy - focrad, focrad * 2,
		     focrad * 2, 0, circle);
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->back_foc_col)]);
	    }

	 /* plot first trajectory  */

	 for(j = 0; j < m->focm[kfoc].focs[i].num1; j++)    
	    {
	    p[j].x = ix + focrad * m->focm[kfoc].focs[i].traj1[j].x;
	    p[j].y = iy - focrad * m->focm[kfoc].focs[i].traj1[j].y;
	    }
	 XFillPolygon(dpy, xwin, gc, p, m->focm[kfoc].focs[i].num1, 
		      Nonconvex, CoordModeOrigin);

	 /* plot second trajectory  */

	 for(j = 0; j < m->focm[kfoc].focs[i].num2; j++)
	    {
	    p[j].x = ix + focrad * m->focm[kfoc].focs[i].traj2[j].x;
	    p[j].y = iy - focrad * m->focm[kfoc].focs[i].traj2[j].y;
	    }

	 XFillPolygon(dpy, xwin, gc, p, m->focm[kfoc].focs[i].num2,
		      Nonconvex, CoordModeOrigin);

	 /*    plot  P and T axis    */

	 if(m->focal_plot_style == 2)
	    {
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->ptax_col)]);

	    /*    P-Axis   */       

	    xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.pdip;
	    tq = XMAP_SQRT2 * sin(xi / 2.0);
	    ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	    ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.prot) ;
	    kx = ix + ax, ky = iy - ay;
	    draw_Xmark(dpy, xwin, gc, kx, ky, hsize);

	    /*     T-Axis    */

	    xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	    tq = XMAP_SQRT2 * sin(xi / 2.0);
	    ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	    ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	    kx = ix + ax, ky = iy - ay;

	    XFillRectangle(dpy, xwin, gc, kx - hsize / 2, ky - hsize / 2,
			   hsize, hsize);
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(1)]);
	    }

	 /* add  plot of fault plane */
  
	 if(m->focal_plot_style == 4)
	    {
	    for(j = 0; j < m->focm[kfoc].focs[i].numft1; j++)
	       {
	       XSetForeground(dpy, gc,
			      m->colors[XmapAppColor(m->faultplane_col)]);
	       p[j].x = ix + focrad * m->focm[kfoc].focs[i].fault[j].x;
	       p[j].y = iy - focrad * m->focm[kfoc].focs[i].fault[j].y;
	       }
	    XDrawLines(dpy, xwin, gc, p, m->focm[kfoc].focs[i].numft1,
		       CoordModeOrigin); 
	    }
	 break;
	 } /* end switching  */
      }	/*  End loop on focal spheres  */

   /* plot a table showing the meaning of the colors  */

   /* 18 23 22 21 19 20 2
      strikeslip 18
      rev-oblSS 23
      obl-rev  22
      reverse  21
      norm-oblSS 19
      normal  2 */  

     
   if(m->focm_color == 0)
      {
      XSetFont(dpy, gc, m->fonts[0]);
      focrad = m->size_focm / 2;


      itype[0] = m->strikeslip_col;
      itype[1] = m->rev_oblSS_col;
      itype[2] = m->obl_rev_col;
      itype[3] = m->reverse_col;
      itype[4] = m->norm_oblSS_col;
      itype[5] = m->oblq_norm_col;
      itype[6] = m->normal_col;

      /*  
	  for(i = 0; i < ntype; i++)
	  {
	  fprintf(stderr,"focal colors: %d %d\n", i, itype[i]);
	  } 
	  */
      
      for(i = 0; i < ntype; i++)
	{
	  ix = m->ScreenX - 60;
	  iy = m->ScreenY - (100 + 24 * i + 12 - focrad / 2);
	  
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(itype[i])]);
	  
	  XFillArc(dpy, xwin, gc, ix - focrad, iy - focrad,	focrad * 2, focrad * 2,
		   0, circle);
	  ix = m->ScreenX - 60 + 20;
	  iy = m->ScreenY - (100 + 24 * i + 12 - focrad / 2 + 6);
	  
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->title_col)]);
	  draw_just_text(dpy, xwin, gc, ix, iy, ctype[i], HJ_LEFT, VJ_CENTER);
	}
      XSetFont(dpy, gc, m->fonts[0]);
      }
   }

/* ---------------------------------------------------------------- */

void plot_focs_BW(Display *dpy, Window xwin, GC gc, mpic *m, int kfoc)
   {
   XPoint p[1000];
   int i, j, circle = 23040, foc_color = 1, back_foc_col = 0, ix, iy, ixpoint,
   iypoint, kx, ky, kx2, ky2, slip_siz = 3;
   float focrad, phi, lam, px, py, meanX, meanY, ax, ay, xi, tq, hsize;
   
   /*
      int ntype = 7;
      int itype[7]={18, 23, 22, 21, 19, 20, 2};  
      char *ctype[7]={"strikeslip","rev-oblSS","obl-rev","reverse",
     "norm-oblSS","obl-norm","normal"};

     XSetForeground(XtDisplay(w), mplot->ggc,
     BlackPixel(XtDisplay(w),gscr_num));
     XSetBackground(XtDisplay(w), mplot->ggc,
     WhitePixel(XtDisplay(w),gscr_num));
     */

  hsize = m->SourceSize;
  if(m->focal_explode == 1)    /* need to explode the focals  */
    {
    phi = m->focm[kfoc].meanPhi;
    lam = m->focm[kfoc].meanLam;
    geo2xy(m, phi, lam, &px, &py); 
    meanX = px;
    meanY = py;

    for(i = 0; i < m->focm[kfoc].numpoints; i++)
      {
      if(!m->focm[kfoc].focs[i].on_off)continue;
      phi = m->focm[kfoc].focs[i].loc.x;
      lam = m->focm[kfoc].focs[i].loc.y;
      geo2xy(m, phi, lam, &px, &py); 
      ixpoint = user_to_pix_x(&m->gr, (double)px);
      iypoint = user_to_pix_y(&m->gr, (double)py);
      ix = user_to_pix_x(&m->gr, (double)m->focm[kfoc].focs[i].explode_x);
      iy = user_to_pix_y(&m->gr, (double)m->focm[kfoc].focs[i].explode_y);
      XDrawLine(dpy, xwin, gc, ixpoint, iypoint, ix, iy);
      }

    /* printf("MEAN FOCALS %f %f %f\n", meanX, meanY, m->focm[kfoc].disMax); */
    }

  for(i = 0; i < m->focm[kfoc].numpoints; i++)
    {
      if(!m->focm[kfoc].focs[i].on_off)continue;
    phi = m->focm[kfoc].focs[i].loc.x;
    lam = m->focm[kfoc].focs[i].loc.y;
    geo2xy(m, phi, lam, &px, &py); 
    ix = user_to_pix_x(&m->gr, (double)px) - m->size_focm / 2;
    iy = user_to_pix_y(&m->gr, (double)py) - m->size_focm / 2;
    focrad = m->size_focm / 2;
    if(m->focm[kfoc].scale_by_mag == 1)
      {
      if(m->focm[kfoc].minMag <  m->focm[kfoc].maxMag)
        focrad += (focrad * (m->focm[kfoc].focs[i].ac.mag
			    - m->focm[kfoc].minMag)
		   / (m->focm[kfoc].maxMag - m->focm[kfoc].minMag));
      else focrad = m->size_focm / 2;
      }

    /************ START EXPLODE   **********/

    if(m->focal_explode == 1) /* need to explode the focals  */
      {
      ixpoint = user_to_pix_x(&m->gr, (double)px);
      iypoint = user_to_pix_y(&m->gr, (double)py);

      ix = user_to_pix_x(&m->gr, (double)m->focm[kfoc].focs[i].explode_x);
      iy = user_to_pix_y(&m->gr, (double)m->focm[kfoc].focs[i].explode_y);
      }

    /****************END EXPLODE**********************/

    else
     {
     ix = user_to_pix_x(&m->gr, (double)px);
     iy = user_to_pix_y(&m->gr, (double)py);
     }

    /* plot a circle  with the color chosen according to the ipol param */

    switch(m->focal_plot_style)
      {
      case 5:
        for(j = 0; j < m->focm[kfoc].focs[i].numft1; j++)
	  {
	  p[j].x = ix + focrad * m->focm[kfoc].focs[i].fault[j].x;
	  p[j].y = iy - focrad * m->focm[kfoc].focs[i].fault[j].y;
	  }
	XDrawLines(dpy, xwin, gc, p, m->focm[kfoc].focs[i].numft1,
		   CoordModeOrigin);

	/* plot the slip direction find the pole of the auxiliary plane
	   strk2,dip2 */

	xi = -0.0174532 * m->focm[kfoc].focs[i].fm.dip2;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.strk2));
	ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.strk2));
	kx = ix + ax, ky = iy - ay;
	xi =  1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.dip2;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.strk2));
	ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.strk2));
	kx2 = ix + ax + slip_siz / 2;
	ky2 = iy - ay + slip_siz / 2;

	XFillRectangle(dpy, xwin, gc, kx, ky, slip_siz, slip_siz);
	break;

      case 3:
	if(m->focm_color == 0)
	  XSetForeground(dpy, gc,
			 m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);

	/*    P-Axis   */       

	xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.pdip;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	kx = ix + ax, ky = iy - ay;
	xi =  1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.pdip;
	/* this is the lower hemisphere point  */
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.prot));
	ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.prot));
	kx2 = ix + ax, ky2 = iy - ay;
	XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);
 
	/*     T-Axis    */

	xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	kx = ix + ax, ky = iy - ay;
	xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	/* this is the lower hemisphere point  */
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.trot));
	ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.trot));
	kx2 = ix + ax, ky2 = iy - ay;
	XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);
	XSetForeground(dpy, gc, m->colors[XmapAppColor(1)]);
	break;

      case 6:                  /* Ralph Archuleta method   */
	if(m->focm_color == 0)
	  XSetForeground(dpy, gc,
			 m->colors[XmapAppColor(m->focm[kfoc].focs[i].type)]);

	/*    strike line -Axis   */

	tq = 1.0;
	xi =  0.0174532 * m->focm[kfoc].focs[i].fm.strk1 - 1.570796327;
	ax = focrad * tq * sin(xi);
	ay = focrad * tq * cos(xi);
	kx = ix + ax, ky = iy - ay;

	tq = -1.0;
	ax = focrad * tq * sin(xi);
	ay = focrad * tq * cos(xi);
	kx2 = ix + ax, ky2 = iy - ay;

	XDrawLine(dpy, xwin, gc, kx, ky, kx2, ky2);
 
	/*   Down  Dip line    */

	xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.dip1;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = focrad * tq * sin(0.0174532 * (m->focm[kfoc].focs[i].fm.strk1));
	ay = focrad * tq * cos(0.0174532 * (m->focm[kfoc].focs[i].fm.strk1));
	kx = ix + ax, ky = iy - ay;
	XDrawLine(dpy, xwin, gc, kx, ky, ix, iy);
	break;

      default:
	if(m->focm[kfoc].focs[i].ipol == 0)
	  {
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(back_foc_col)]); 
	  XFillArc(dpy, xwin, gc, ix - focrad, iy - focrad, focrad * 2,
		   focrad * 2, 0, circle);
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);
	  }
	else  
	  {
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);
	  XFillArc(dpy, xwin, gc, ix - focrad, iy - focrad, focrad * 2,
		   focrad * 2, 0, circle);
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(back_foc_col)]);
	  }

	/* XSetForeground(dpy, gc, m->colors[foc_color]);
	   XDrawArc(dpy, xwin, gc, ix-focrad, iy-focrad, focrad * 2,
	   focrad*2, 0, circle); */

	/* plot first trajectory  */

	for(j = 0; j < m->focm[kfoc].focs[i].num1; j++)
	  {
	  p[j].x = ix + focrad * m->focm[kfoc].focs[i].traj1[j].x;
	  p[j].y = iy - focrad * m->focm[kfoc].focs[i].traj1[j].y;
	  }
	XFillPolygon(dpy, xwin, gc, p, m->focm[kfoc].focs[i].num1,
		     Nonconvex, CoordModeOrigin);

	/* XDrawLines(dpy, xwin, gc, p, m->focm[kfoc].focs[i].num1,
	   CoordModeOrigin); */

	/* plot second trajectory  */

	for(j = 0; j < m->focm[kfoc].focs[i].num2; j++)
	  {
	  p[j].x = ix + focrad * m->focm[kfoc].focs[i].traj2[j].x;
	  p[j].y = iy - focrad * m->focm[kfoc].focs[i].traj2[j].y;
	  }

	XFillPolygon(dpy, xwin, gc, p, m->focm[kfoc].focs[i].num2,
		     Nonconvex, CoordModeOrigin);

	/* XDrawLines(dpy, xwin, gc, p, m->focm[kfoc].focs[i].num2,
	   CoordModeOrigin); */

	XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);
	XDrawArc(dpy, xwin, gc, ix - focrad, iy - focrad, focrad * 2,
		 focrad * 2, 0, circle);

	/* plot  P and T axis */

	if(m->focal_plot_style == 2)
	  {
	  XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);

	  /*    P-Axis   */       

	  xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.pdip;
	  tq = XMAP_SQRT2 * sin(xi / 2.0);
	  ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	  ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.prot);
	  kx = ix + ax, ky = iy - ay;

	  /*  XFillArc(dpy, xwin, gc, kx - hsize, ky - hsize, hsize, hsize,
	      0, circle); */

	  draw_Xmark(dpy, xwin, gc, kx, ky, hsize);

	  /*     T-Axis    */

	  xi = 1.570796327 - 0.0174532 * m->focm[kfoc].focs[i].fm.tdip;
	  tq = XMAP_SQRT2 * sin(xi / 2.0);
	  ax = focrad * tq * sin(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	  ay = focrad * tq * cos(0.0174532 * m->focm[kfoc].focs[i].fm.trot);
	  kx = ix + ax, ky = iy - ay;

	  XFillRectangle(dpy, xwin, gc, kx - hsize / 2, ky - hsize / 2,
			 hsize, hsize);
          }

	/*   add  plot of fault plane    */

	if(m->focal_plot_style == 4)
	  {
	  for(j = 0; j < m->focm[kfoc].focs[i].numft1; j++)
	    {
	    XSetForeground(dpy, gc, m->colors[XmapAppColor(foc_color)]);
	    p[j].x = ix + focrad * m->focm[kfoc].focs[i].fault[j].x;
	    p[j].y = iy - focrad * m->focm[kfoc].focs[i].fault[j].y;
	    }

	  XDrawLines(dpy, xwin, gc, p, m->focm[kfoc].focs[i].numft1,
		     CoordModeOrigin);
	  }
	break;
      } /* end switching  */            
    }  /*  End loop on focal spheres  */
  }

/* ---------------------------------------------------------------- */

void plot_station_names(Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int i, k;

  XSetForeground(dpy, gc,
		 m->colors[XmapAppColor(m->stations[m->current_sta].color)]);
  for(i = 0; i < m->stations[m->current_sta].numpoints; i++)
    {
    draw_just_text(dpy, xwin, gc,
		   user_to_pix_x(&m->gr,
		     (double)m->stations[m->current_sta].sta[i].loc.x)+m->size_sta*0.8,
		   user_to_pix_y(&m->gr,
		     (double)m->stations[m->current_sta].sta[i].loc.y)-m->size_sta*0.6,
		   m->stations[m->current_sta].sta[i].name,
		   HJ_LEFT, VJ_BASELINE);
    }

  if(m->special_station_flag)
    {
    for(i = 0; i < m->stations[m->current_sta].num_special_stations; i++)
      {
      k = m->stations[m->current_sta].special_stations[i];
      XSetForeground(dpy, gc, m->colors[XmapAppColor(m->special_sta_col)]);
      draw_just_text(dpy, xwin, gc,
		     user_to_pix_x(&m->gr,
		       (double)m->stations[m->current_sta].sta[k].loc.x)+m->size_sta*0.8,
		     user_to_pix_y(&m->gr,
			(double)m->stations[m->current_sta].sta[k].loc.y)-m->size_sta*0.6,
		     m->stations[m->current_sta].sta[k].name,
		     HJ_LEFT, VJ_BASELINE);        
      }
    }
  }

void plot_stuff(Display *dpy, Window xwin, GC gc, mpic *m, int codeA,
		int codeB)
  {
  int xpoint, ypoint, i, j, clen;
  char pchar[13];

  for(i = 0; i < m->markup.numpoints; i++)
    {
    xpoint = user_to_pix_x(&m->gr, (double)m->markup.stuff[i].m.x);
    ypoint = user_to_pix_y(&m->gr, (double)m->markup.stuff[i].m.y);

#if 0	 
    printf(" plot stuff name px py: %s %f %f %d %d\n",
	   m->markup.stuff[i].name, m->markup.stuff[i].m.x,
	   m->markup.stuff[i].m.y, xpoint, ypoint);
#endif

    /***  LATITUDE   ***/

    if((m->markup.stuff[i].code1 == codeA) && (m->markup.stuff[i].code1 == 1))
      {
      /* its a lattitude */
      XDrawLine(dpy, xwin, gc, xpoint, ypoint, xpoint - 5, ypoint);
      strcpy(pchar, m->markup.stuff[i].name);
      clen = strlen(pchar);
      for(j = 0; j < clen; j++)
	{
	if(pchar[j] == -54)
	  {
	  if(clen > 4) pchar[j] = ':';
	  else pchar[j] = '\0';
	  }
	if(pchar[j] == -62) pchar[j] = '\0';
	}

      if(codeB == 1)
        draw_just_text(dpy, xwin, gc, xpoint - 5, ypoint, pchar, HJ_RIGHT,
		       VJ_CENTER);
      }

    /***  LONGITUDE   ***/

    if(m->markup.stuff[i].code1 == codeA && m->markup.stuff[i].code1 == 2)
      {
      /* its a longitude      */

      XDrawLine(dpy, xwin, gc, xpoint, ypoint, xpoint, ypoint + 5);

      strcpy(pchar, m->markup.stuff[i].name);
      clen = strlen(pchar);
      for(j = 0; j < clen; j++)
	{
	if(pchar[j] == -54)
	  {
	  if(clen > 4) pchar[j] = ':';
	  else pchar[j] = '\0';
	  }
	if(pchar[j] == -62) pchar[j] = '\0';

/*  194 = -62   202=-54 */ 
    
	}
      if(codeB == 1)
        draw_just_text(dpy, xwin, gc, xpoint, ypoint + 5, pchar, HJ_CENTER,
		       VJ_TOP);
      }

    if(m->markup.stuff[i].code1 == 3 && codeA == 1)
      {
      /* its a latitude      */

      XDrawLine(dpy, xwin, gc, xpoint, ypoint, xpoint - 5, ypoint);
      strcpy(pchar, m->markup.stuff[i].name);

      if(codeB == 1)
        draw_just_text(dpy, xwin, gc, xpoint - 5, ypoint, pchar, HJ_RIGHT,
		       VJ_CENTER);
      }

    if(m->markup.stuff[i].code1 == 4 && codeA == 2)
      {
      /* its a longitude      */

      XDrawLine(dpy, xwin, gc, xpoint, ypoint, xpoint, ypoint + 5);
      strcpy(pchar, m->markup.stuff[i].name);

      if(codeB == 1)
        draw_just_text(dpy, xwin, gc, xpoint, ypoint + 5, pchar, HJ_CENTER,
		       VJ_TOP);
      }
    if(m->markup.stuff[i].code1 == 5 && codeA == 1)
      {
      /* its a latitude      */

      XDrawLine(dpy, xwin, gc, xpoint, ypoint, xpoint - 10, ypoint);
      strcpy(pchar, m->markup.stuff[i].name);

      if(codeB == 1)
        draw_just_text(dpy, xwin, gc, xpoint - 10, ypoint, pchar, HJ_RIGHT,
		       VJ_CENTER);
      }

    if(m->markup.stuff[i].code1 == 6 && codeA == 2)
      {
      /* its a longitude      */

      XDrawLine(dpy, xwin, gc, xpoint, ypoint, xpoint, ypoint + 15);
      
      strcpy(pchar, m->markup.stuff[i].name);

      if(codeB == 1)
        draw_just_text(dpy, xwin, gc, xpoint, ypoint + 15, pchar, HJ_CENTER,
		       VJ_TOP);
      }




    }
  }

/* ---------------------------------------------------------------- */

void Plot_Map( Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int i;
  static XSegment *mapp;

  /* fprintf(stderr, "in Plot_Map %d\n", m->xy_map.numpoints); */

  mapp = XmapNewArray(XSegment, m->xy_map.numpoints);

  for(i = 0; i < m->xy_map.numpoints; i++)
    {
    mapp[i].x1 = user_to_pix_x(&m->gr, (double)m->xy_map.km[i].x1);
    mapp[i].y1 = user_to_pix_y(&m->gr, (double)m->xy_map.km[i].y1);
    mapp[i].x2 = user_to_pix_x(&m->gr, (double)m->xy_map.km[i].x2);
    mapp[i].y2 = user_to_pix_y(&m->gr, (double)m->xy_map.km[i].y2);
    }
  XSetForeground(dpy, gc, m->colors[XmapAppColor(m->map_col)]);

  /* for(i = 0; i < 25; i++)
     fprintf(stderr, "Plot_Map %d %d %f %f\n", mapp[i].x1, mapp[i].y1,
     m->xy_map.km[i].x1, m->xy_map.km[i].y1); */

  XDrawSegments(dpy, xwin, gc, mapp, m->xy_map.numpoints);
  XmapFree(mapp);
  }

/* ---------------------------------------------------------------- */

void Plot_Map2(Display *dpy, Window xwin, GC gc, mpic *m, int kmap)
  {
  Pixel *colors = m->colors; /* Color map */
  int i, j, k;
  XPoint p[10000];
  char *c;

/*
  for(k = 0; k < m->map[kmap].stroke_count; k++)
    {
     fprintf(stderr, "plot_map:%d  %d %d %d %d\n", kmap, k, m->map[kmap].stroke[k].style,
       m->map[kmap].stroke[k].col, m->map[kmap].stroke[k].num); 
     }
  
*/

  for(k = 0; k < m->map[kmap].stroke_count; k++)
    {
if(m->map[kmap].stroke[k].style>100)
     fprintf(stderr, "plot_map:%d  %d %d %d %d\n", kmap, k, m->map[kmap].stroke[k].style,
       m->map[kmap].stroke[k].col, m->map[kmap].stroke[k].num); 

    /*
       codes
       a = major coasts  islands  lakes
       b = intermediate coasts islands lakes
       c = minor coasts islands lakes
       d =  very minor coasts islands lakes
       e =  major rivers
       f =  intermediate rivers
       g =  minor rivers
       h =  very minor rivers
       i = political borders
       j = major faults
       k = minor faults
       l = geology formation
       m = major high ways
       n = minor roads
       p = plates
       */

    c = m->map[kmap].map_code;
    while(*(c++) != m->map[kmap].stroke[k].code) 
      if(*c == '\0') goto AGAIN;

    j = 0;
    for(i = m->map[kmap].stroke[k].index1;
	(i < m->map[kmap].stroke[k].index1 + m->map[kmap].stroke[k].num); i++)
      {
      p[j].x = user_to_pix_x(&m->gr, (double)m->map[kmap].km[i].x);
      p[j].y = user_to_pix_y(&m->gr, (double)m->map[kmap].km[i].y);
      j++;
      }

#if 0
    fprintf(stderr, "%d\n", k);
for(mm = 0; mm < j; mm++)
  { fprintf(stderr,"%d %d\n", p[mm].x, p[mm].y); 
  /* if( (mm%5) == 0 ) fprintf(stderr,"\n"); */
  }
fprintf(stderr,"\n");
#endif

XSetForeground(dpy, gc, colors[XmapAppColor(m->map[kmap].stroke[k].col)]);

switch(m->map[kmap].stroke[k].style)
  {
  case 1:
  XDrawPoints(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
	      CoordModeOrigin);
  break;

  case 2:
  XDrawLines(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
	     CoordModeOrigin);
  break;

  case 3:
  XFillPolygon(dpy, xwin, gc, p, m->map[kmap].stroke[k].num, Nonconvex,
	       CoordModeOrigin); 
  break;

  default:
  XDrawLines(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
	     CoordModeOrigin); 
  break;
  }
 AGAIN: ;
}
  }

/*********   line map   *****************/

void Plot_Map3(Display *dpy, Window xwin, GC gc, mpic *m, int kmap)
  {
  int i, kk = 0, j, k;
  XPoint p[10000];

  /* printf("In plot_map2...stroke count = %d\n",
     m->map[kmap].stroke[k].count); */

  for(k = 0; k < m->map[kmap].stroke_count; k++)
    {
    j = 0;
    for(i = kk; i < kk + m->map[kmap].stroke[k].num; i++)
      {
      p[j].x = user_to_pix_x(&m->gr, (double)m->map[kmap].km[i].x);
      p[j].y = user_to_pix_y(&m->gr, (double)m->map[kmap].km[i].y);
      j++;
      }
    kk += m->map[kmap].stroke[k].num;

#if 0
    XSetForeground(dpy, gc, colors[XmapAppColor(m->map[kmap].stroke[k].col)]);
#endif

    switch(m->map[kmap].stroke[k].style)
      {
      case 1:
      XDrawPoints(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
		  CoordModeOrigin);
      break;

      case 2:
      XDrawLines(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
		 CoordModeOrigin);
      break;

      case 3:
      /* XFillPolygon(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
	 Nonconvex, CoordModeOrigin); */
      XDrawLines(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
		 CoordModeOrigin);
      break;

      default:
      XDrawLines(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,
		 CoordModeOrigin);
      break;
      }
    }
  }

/*-------------------------------------------*/

void Add_lines_to_map(mpic *m)
  {
  Pixel *colors = m->colors;	/* Color map */
  int i, kk, j, k, kmap;
  XPoint p[10000];
  Display *dpy = XtDisplay(m->wij);
  Window xwin = XtWindow(m->wij);
  GC gc = m->ggc;

  /* printf("In plot_map2...stroke count = %d\n",
     m->map[kmap].stroke[k].count); */

  XSetForeground(dpy, gc, colors[XmapAppColor(0)]);

  for(kmap = 0; kmap < m->num_map_files; kmap++)
    {
    kk = 0;

    for(k = 0; k < m->map[kmap].stroke_count; k++)
      {
      j = 0;
      for(i = kk; i < kk + m->map[kmap].stroke[k].num; i++)
	{
	p[j].x = user_to_pix_x(&m->gr, (double)m->map[kmap].km[i].x);
	p[j].y = user_to_pix_y(&m->gr, (double)m->map[kmap].km[i].y);
	j++;
	}
      kk += m->map[kmap].stroke[k].num;

      if(m->map[kmap].stroke[k].style == 3)
	{
	XDrawLines(dpy, xwin, gc, p, m->map[kmap].stroke[k].num,  
                   CoordModeOrigin); 
        XFlush(dpy);
	}
      }
    }
  }

/* ---------------------------------------------------------------- */

void Plot_Border0(Display *d, Window w, GC ggc, mpic *mplot)
  {
  int ix, ix1, iy, iy1;

  ix = user_to_pix_x(&mplot->gr, (double)mplot->origin.minx);
  iy = user_to_pix_y(&mplot->gr, (double)mplot->origin.miny);
  ix1 = user_to_pix_x(&mplot->gr, (double)mplot->origin.maxx);
  iy1 = user_to_pix_y(&mplot->gr, (double)mplot->origin.maxy);

  XSetForeground(d, ggc, mplot->colors[XmapAppColor(mplot->bord_col)]);
  XDrawRectangle(d, w, ggc, ix, iy1, ix1 - ix,  iy-iy1);
  }

void Plot_Border(Display *d, Window w, GC ggc, mpic *mplot)
  {
  int ix, ix1, iy, iy1;

  ix = user_to_pix_x(&mplot->gr, (double)mplot->origin.minx);
  iy = user_to_pix_y(&mplot->gr, (double)mplot->origin.miny);
  ix1 = user_to_pix_x(&mplot->gr, (double)mplot->origin.maxx);
  iy1 = user_to_pix_y(&mplot->gr, (double)mplot->origin.maxy);

  XSetForeground(d, ggc, mplot->colors[XmapAppColor(mplot->back_fill_col)]);
  XFillRectangle(d, w, ggc, ix, iy1, ix1 - ix,  iy- iy1);

  /***************************/

  XSetForeground(d, ggc, mplot->colors[XmapAppColor(mplot->bord_col)]);
  XDrawRectangle(d, w, ggc, ix, iy1, ix1 - ix,  iy-iy1 );
  }

void Plot_Border2(Display *d, Window w, GC ggc, mpic *mplot)
  {
  int i, k = 0, inc = 10;
  float dif1, dif2, px, py, phi, lam;
  XPoint p[1000];
  float  phio, lamo, xmax, ymax, xmin, ymin, dum,
    xshift, yshift;
  float pmax, lmax;
  

  xmin =  mplot->origin.minx;
  xmax =  mplot->origin.maxx;
  ymin =  mplot->origin.miny;
  ymax =  mplot->origin.maxy;
/*  fprintf(stderr, " BORD2 %f %f %f %f\n", xmin, xmax, ymin, ymax); */
 
  xy2geo(mplot,  &phio, &lamo, xmin, ymin);
  xy2geo(mplot,  &dum, &lam, xmax, ymin);
  xy2geo(mplot,  &phi, &dum, xmin, ymax);

  pmax = phi;
  lmax = lam;
  
  dif1 = pmax - phio;
  dif1 = fabs(dif1);
  dif2 = lmax - lamo;
  dif2 = fabs(dif2);

/* fprintf(stderr, " BORD2 %f %f %f %f %f %f   \n", phio, lamo , pmax, lmax, dif1, dif2); */

  geo2xy(mplot, phio, lamo, &xshift, &yshift);
     if(mplot->project_type!=1) 
    {
    xshift=0;
    yshift=0;
    }
  
  lam = lamo; 

  for(i = 0; i < inc; i++)
    {
    phi = phio + i * dif1 / inc;
    geo2xy(mplot, phi, lam, &px, &py);
    p[k].x = user_to_pix_x(&mplot->gr, px-xshift);
    p[k].y = user_to_pix_y(&mplot->gr, py-yshift);
    k++;
    }

  phi = pmax;

  for(i = 0; i < inc; i++)
    {
    lam = lamo + i * dif2 / inc;
    geo2xy(mplot, phi, lam, &px, &py);
    p[k].x = user_to_pix_x(&mplot->gr, px-xshift);
    p[k].y = user_to_pix_y(&mplot->gr, py-yshift);

    /* fprintf(stderr,"%d %d %f %f %d %d\n", i,k,phi, lam, p[k].x, p[k].y); */
    k++;
    }

  lam = lmax; 
  for(i = 0; i < inc; i++)
    {
    phi = pmax  - i * dif1 / inc;
    geo2xy(mplot, phi, lam, &px, &py);
    p[k].x = user_to_pix_x(&mplot->gr, px-xshift);
    p[k].y = user_to_pix_y(&mplot->gr, py-yshift);

    /* fprintf(stderr,"%d %d %f %f %d %d\n", i,k,phi, lam, p[k].x, p[k].y); */
    k++;
    }

  phi = phio;
  for(i = 0; i < inc; i++)
    {
    lam = lmax - i * dif2 / inc;
    geo2xy(mplot, phi, lam, &px, &py);
    p[k].x = user_to_pix_x(&mplot->gr, px-xshift);
    p[k].y = user_to_pix_y(&mplot->gr, py-yshift);

    /* fprintf(stderr, "%d %d %f %f %d %d\n", i, k, phi, lam, p[k].x,
       p[k].y);*/

    k++;
    }
  p[k].x = p[0].x;
  p[k].y = p[0].y;
  k++;

  XSetForeground(d, ggc, mplot->colors[XmapAppColor(mplot->back_fill_col)]);
  XFillPolygon(d, w, ggc, p, k, Nonconvex, CoordModeOrigin);

  /***************************/

  XSetForeground(d, ggc, mplot->colors[XmapAppColor(mplot->bord_col)]);
  XDrawLines(d, w, ggc, p, k, CoordModeOrigin);
  }

/* ---------------------------------------------------------------- */

void Plot_Grid0( Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int i, x, x2, y, y2;

  y = user_to_pix_y(&m->gr, (double)m->origin.miny);
  y2 = user_to_pix_y(&m->gr, (double)m->origin.maxy);

  for(i = 1; i < m->origin.nxblk; i++)
    {
    x = user_to_pix_x(&m->gr, (double)(float)i * m->origin.dx);
    XDrawLine(dpy, xwin, gc, x, y, x, y2);
    }

  x = user_to_pix_x(&m->gr, m->origin.minx);
  x2 = user_to_pix_x(&m->gr, (double)m->origin.maxx);
  for(i = 1; i < m->origin.nyblk; i++)
    {
    y = user_to_pix_y(&m->gr, (double)(float)i * m->origin.dy);
    XDrawLine(dpy, xwin, gc, x, y, x2, y);
    }            
  }

/* ---------------------------------------------------------------- */

void Plot_Grid( Display *dpy, Window xwin, GC gc, mpic *m)
  {

  int i, k = 0,  n, j;
  float dif1, dif2, px, py, phi, lam;
  XPoint *p;
  float  phio, lamo, xmax, ymax, xmin, ymin, dum;
  float pmax, lmax;
  
 
  n = max2(m->origin.nyblk, m->origin.nxblk);
  
  p = XmapNewArray(XPoint, n );




  xmin =  m->origin.minx;
  xmax =  m->origin.maxx;
  ymin =  m->origin.miny;
  ymax =  m->origin.maxy;
/*  fprintf(stderr, " BORD2 %f %f %f %f\n", xmin, xmax, ymin, ymax); */
 
  xy2geo(m,  &phio, &lamo, xmin, ymin);
  xy2geo(m,  &dum, &lam, xmax, ymin);
  xy2geo(m,  &phi, &dum, xmin, ymax);

  pmax = phi;
  lmax = lam;
  
  dif1 = pmax - phio;
  dif1 = fabs(dif1);
  dif2 = lmax - lamo;
  dif2 = fabs(dif2);
  XSetForeground(dpy, gc, m->colors[XmapAppColor(1)]);

  for(i = 0; i < m->origin.nxblk; i++)
    {
    k = 0;
    
    phi = phio + i * dif1 / m->origin.nxblk;
    for(j = 0; j < m->origin.nyblk; j++)
      {
      lam = lamo + j * dif2 / m->origin.nyblk;
      geo2xy(m, phi, lam, &px, &py);
      p[k].x = user_to_pix_x(&m->gr, px);
      p[k].y = user_to_pix_y(&m->gr, py);
      k++;
      }

    XDrawLines(dpy, xwin, gc, p, k, CoordModeOrigin);

    }
  
 for(i = 0; i < m->origin.nyblk; i++)
    {
    k = 0;
    
lam = lamo + i * dif2 / m->origin.nyblk;
    for(j = 0; j < m->origin.nyblk; j++)
      {
    phi = phio + j * dif1 / m->origin.nxblk;
      
      geo2xy(m, phi, lam, &px, &py);
      p[k].x = user_to_pix_x(&m->gr, px);
      p[k].y = user_to_pix_y(&m->gr, py);
      k++;
      }

    XDrawLines(dpy, xwin, gc, p, k, CoordModeOrigin);

    }
  


  XmapFree(p);


  }




/* ---------------------------------------------------------------- */

void Plot_Map_Grid(Widget wij, mpic *m, char *call_data)
  {
  Display *dpy= XtDisplay(m->wij);
  Window xwin = XtWindow(m->wij);
  GC gc = m->ggc;
  int i, j, k, n, x, y;
  float phi, lam, plat, plon, qlat, qlon, px, py, dphi, dlam, deginc, laminc;

  plat = m->origin.phimin;
  plon = m->origin.lammin;
  qlat = m->origin.phimax;
  qlon = m->origin.lammax;

  dphi = (plat - qlat);
  dphi = fabs(dphi);
  dlam = (plon - qlon);
  dlam = fabs(dlam);

  if(dphi > 50) deginc = 10;
  if(dphi > 20 && dphi <= 50) deginc = 5;
  if(dphi > 10 && dphi <= 20) deginc = 2;
  if(dphi <= 10) deginc = 1;

  if(dlam > 50) laminc = 10;
  if(dlam > 20 && dlam <= 50) laminc = 5;
  if(dlam > 10 && dlam <= 20) laminc = 2;
  if(dlam <= 10) laminc = 1;

  j = deginc * (int)(plat / deginc);
  n = laminc * (int)(plon / laminc);

  XSetForeground(dpy, gc, m->colors[XmapAppColor(2)]);

  for(i = j; i < qlat; i += deginc)
    {
    for(k = n; k < qlon; k += laminc)
      {
      phi = i, lam = k;
      geo2xy(m, phi, lam, &px, &py); 

      x = user_to_pix_x(&m->gr, (double)px);
      y = user_to_pix_y(&m->gr, (double)py);

      XDrawLine(dpy, xwin, gc, x - 2, y, x + 2, y);
      XDrawLine(dpy, xwin, gc, x, y + 2, x, y - 2);

      /* fprintf(stderr, "lat=%f lon=%f\n", phi, lam); */
      XFlush(dpy);
      }
    }
  }

/* ---------------------------------------------------------------- */

void Plot_GeoTab(Display *dpy, Window xwin, GC gc, mpic *m)
  {
  int i, x, x2, y, y2, bsiz = 24;
  
  y = user_to_pix_y(&m->gr, m->origin.minx);
  y2 = user_to_pix_y(&m->gr, (double)((float)m->origin.maxy));
  x = user_to_pix_x(&m->gr, m->origin.minx);
  x2 = user_to_pix_x(&m->gr, (double)((float)m->origin.maxx));
  x2 = m->ScreenX - 50; 

  for(i = 0; i < m->Formation_count; i++)
    {
    /* printf("Geo-Table %s %d \n", m->Formation_name[ i ],
       m->Formation_color[i]); */

    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->Formation_color[i])]);
    XFillRectangle(dpy, xwin, gc, x2, 10 + (i + 1) * bsiz, bsiz, bsiz);

    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
    XDrawRectangle(dpy, xwin, gc, x2, 10 + (i + 1) * bsiz, bsiz, bsiz);

    XSetForeground(dpy, gc, m->colors[XmapAppColor(m->text_col)]);
    draw_just_text(dpy, xwin, gc, x2 + bsiz + 5, (10 + (i + 1) * bsiz + 3
						  * bsiz / 4),
		   m->Formation_name[i], HJ_LEFT, VJ_BASELINE);
    }   
  }

void set_xsec(float **amat, float x1, float y1, float x2, float y2,
	      float front, float back, float min_z, float max_z, float dip)
  {
  float dx, dy, dist, dz, strike, RMAT[4][4];

  dx = x2 - x1, dy = y2 - y1;

  dist = sqrt(sqr(dx) + sqr(dy));
  strike = atan2(dy, dx);
  dz = -(max_z - min_z);
  dip = 90 - dip;

  /* fprintf(stderr,"set_xsec strike=%f  dip=%f\n",RAD2DEG*strike, dip); */

  amat[0][0] = 0.0;
  amat[0][1] = back;
  amat[0][2] = 0;
  amat[0][3] = 1;

  amat[1][0] = 0.0;
  amat[1][1] = -front;
  amat[1][2] = 0;
  amat[1][3] = 1;

  amat[2][0] = dist;
  amat[2][1] = -front;
  amat[2][2] = 0;
  amat[2][3] = 1;

  amat[3][0] = dist;
  amat[3][1] = back;
  amat[3][2] = 0;
  amat[3][3] = 1;

  amat[4][0] = 0.0;
  amat[4][1] = back;
  amat[4][2] = dz;
  amat[4][3] = 1;

  amat[5][0] = 0.0;
  amat[5][1] = -front;
  amat[5][2] = dz;
  amat[5][3] = 1;

  amat[6][0] = dist;
  amat[6][1] = -front;
  amat[6][2] = dz;
  amat[6][3] = 1;

  amat[7][0] = dist;
  amat[7][1] = back;
  amat[7][2] = dz;
  amat[7][3] = 1;

  amat[8][0] = 0.0;
  amat[8][1] = 0.0;
  amat[8][2] = 0.0;
  amat[8][3] = 1;

  amat[9][0] = dist;
  amat[9][1] = 0.0;
  amat[9][2] = 0.0;
  amat[9][3] = 1;

  Idn(RMAT);
  xrot(DEG2RAD * dip, RMAT);
  zrot(strike, RMAT);
  Tran3D(x1, y1, 0.0, RMAT);
  MatRot(amat, 10, RMAT);
  }

/* ---------------------------------------------------------------- */

void Plot_Xsec(Display *d, Window w, GC ggc, mpic *mplot, int i)
  {
  XPoint p[5];
  char pchar[6];
  float **tmat =  alloc_fmat(0, 10, 0, 4);

  /* fprintf(stderr,"XSEC: %d %f %f %f %f %f %f %f %f %f\n",i,
     mplot->cross[i].xseckm.x1,
     mplot->cross[i].xseckm.y1,
     mplot->cross[i].xseckm.x2,
     mplot->cross[i].xseckm.y2,
     mplot->cross[i].max_xsfront,
     mplot->cross[i].max_xsback,
     mplot->cross[i].min_xsdepth,
     mplot->cross[i].max_xsdepth,
     mplot->cross[i].xs_dip);
     */

  set_xsec(tmat, mplot->cross[i].xseckm.x1, mplot->cross[i].xseckm.y1,
	   mplot->cross[i].xseckm.x2, mplot->cross[i].xseckm.y2,
	   mplot->cross[i].max_xsfront, mplot->cross[i].max_xsback,
	   mplot->cross[i].min_xsdepth, mplot->cross[i].max_xsdepth,
	   mplot->cross[i].xs_dip);

  if(mplot->cross[i].xs_dip != 90.0)
    {
    XSetForeground(d, ggc, mplot->colors[XmapAppColor(mplot->box_xsec_col+1)]);
    XSetDashes(d, ggc, dash_offset, dash_list[1], dash_list_length[1]);

    line_style = LineOnOffDash;

    XSetLineAttributes(d, ggc, line_width, line_style, cap_style, join_style);

    p[0].x = user_to_pix_x(&mplot->gr, tmat[4][0]);
    p[0].y = user_to_pix_y(&mplot->gr, tmat[4][1]);

    p[1].x = user_to_pix_x(&mplot->gr, tmat[5][0]);
    p[1].y = user_to_pix_y(&mplot->gr, tmat[5][1]);

    p[2].x = user_to_pix_x(&mplot->gr, tmat[6][0]);
    p[2].y = user_to_pix_y(&mplot->gr, tmat[6][1]);

    p[3].x = user_to_pix_x(&mplot->gr, tmat[7][0]);
    p[3].y = user_to_pix_y(&mplot->gr, tmat[7][1]);

    p[4].x =  p[0].x;
    p[4].y =  p[0].y;

    XDrawLines(d, w, ggc , p, 5, CoordModeOrigin);

    XDrawLine(d, w, ggc, user_to_pix_x(&mplot->gr, tmat[0][0]),
	      user_to_pix_y(&mplot->gr, tmat[0][1]), 
	      user_to_pix_x(&mplot->gr, tmat[4][0]) ,
	      user_to_pix_y(&mplot->gr, tmat[4][1]));
    XDrawLine(d, w, ggc, user_to_pix_x(&mplot->gr, tmat[1][0]),
	      user_to_pix_y(&mplot->gr, tmat[1][1]), 
	      user_to_pix_x(&mplot->gr, tmat[5][0]) ,
	      user_to_pix_y(&mplot->gr, tmat[5][1]));
    XDrawLine(d, w, ggc, user_to_pix_x(&mplot->gr, tmat[2][0]),
	      user_to_pix_y(&mplot->gr, tmat[2][1]), 
	      user_to_pix_x(&mplot->gr, tmat[6][0]) ,
	      user_to_pix_y(&mplot->gr, tmat[6][1]));
XDrawLine(d, w, ggc, user_to_pix_x(&mplot->gr, tmat[3][0]),
	  user_to_pix_y(&mplot->gr, tmat[3][1]), 
	  user_to_pix_x(&mplot->gr, tmat[7][0]) ,
	  user_to_pix_y(&mplot->gr, tmat[7][1]));
XDrawLine(d, w, ggc, user_to_pix_x(&mplot->gr, tmat[8][0]),
	  user_to_pix_y(&mplot->gr, tmat[8][1]), 
	  user_to_pix_x(&mplot->gr, tmat[9][0]) ,
	  user_to_pix_y(&mplot->gr, tmat[9][1]));
    }

  line_style = LineSolid;

  XSetLineAttributes(d, ggc, line_width, line_style, cap_style, join_style);
  XSetForeground(d, ggc, mplot->colors[XmapAppColor(mplot->box_xsec_col)]);

  p[0].x = user_to_pix_x(&mplot->gr, tmat[0][0]);
  p[0].y = user_to_pix_y(&mplot->gr, tmat[0][1]);

  p[1].x = user_to_pix_x(&mplot->gr, tmat[1][0]);
  p[1].y = user_to_pix_y(&mplot->gr, tmat[1][1]);

  p[2].x = user_to_pix_x(&mplot->gr, tmat[2][0]);
  p[2].y = user_to_pix_y(&mplot->gr, tmat[2][1]);

  p[3].x = user_to_pix_x(&mplot->gr, tmat[3][0]);
  p[3].y = user_to_pix_y(&mplot->gr, tmat[3][1]);

  p[4].x =  p[0].x;
  p[4].y =  p[0].y;

  XDrawLines(d, w, ggc , p, 5, CoordModeOrigin);

  XSetForeground(d, ggc, mplot->colors[XmapAppColor(1)]);
  XDrawLine(d, w, ggc, user_to_pix_x(&mplot->gr, tmat[8][0]),
	    user_to_pix_y(&mplot->gr, tmat[8][1]), 
	    user_to_pix_x(&mplot->gr, tmat[9][0]) ,
	    user_to_pix_y(&mplot->gr, tmat[9][1]));

  sprintf(pchar, "%d", mplot->cross[i].xsec_index);
  /* sprintf(pchar, "%d", i); */

  draw_just_text(d, w, ggc, user_to_pix_x(&mplot->gr, tmat[8][0]),
		 user_to_pix_y(&mplot->gr, tmat[8][1]), pchar, HJ_CENTER,
		 VJ_BASELINE);

  free_fmat(tmat, 0, 10, 0, 4);
  }

