
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "user2pix.h"
#include "mpic.h"
#include "xsec.h"

/* --- typedefs and macros --- */

typedef fxy KMPoint;

#define            DEG2RAD   0.017453293
#define            RAD2DEG  57.295778667

/* --- function prototypes --- */

int In_Rect_Vol(float RMAT[3][3], float dx, float dy, float dz, float mindep,
		float maxdep, float mindist, float maxdist, float d1, float d2, float *range,
		float *dep, float *aproj);
extern int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);

extern void draw_well(Display *dpy, Window xwin, GC gc, int x, int y, int siz);



float Xshiftps_x(xsec *xs, float x);
float Xshiftps_z(xsec *xs, float z);
void putpsXpoint(FILE *inf, xsec *xs, float x, float y);
void m2psXpoint(FILE *inf, xsec *xs, float x, float y);
void line2psXpoint(FILE *inf, xsec *xs, float x, float y);


void change_linewidth(Display *dpy, GC gc, int width)
{
  unsigned int line_width = 0;
  int line_style = LineSolid;
  int cap_style = CapRound;
  int join_style = JoinRound;
  line_width = width;
  XSetLineAttributes(dpy, gc, line_width, line_style, cap_style, join_style);
}

/* --- functions --- */

void Xsec_plot_well(xsec *xs, Display *d, Window w, GC ggc)
  {
  mpic *xm;
  float px, py, px2, py2, pz2, phi, lam, hoz_dist, dep, r, off, r2, off2,
    dep2, dx, dy, dz, beta, tdip, az, apparent;
  int lx, ly, a, i, k, j,  kount;
  XPoint p[FOC_TRACE], p2[FOC_TRACE];
  int first_point=1;
  

  xm = xs->m;

  hoz_dist = sqrt((xs->line.x1 - xs->line.x2) * (xs->line.x1 - xs->line.x2)
		  + (xs->line.y1 - xs->line.y2) * (xs->line.y1 - xs->line.y2));


  for(kount = 0; kount < xm->num_wells_files; kount++)
    {
    for(a = 0; a < xm->wells[kount].well_count; a++)
      {

	if(xm->wells[kount].well[a].nump<3) 
	  {  
	    first_point=0;  
	  }
	else
	  {
	    first_point=1;  
	  }
	
	
      phi = xm->wells[kount].well[a].loc[first_point].x;
      lam = xm->wells[kount].well[a].loc[first_point].y;
      geo2xy(xm, phi, lam, &px, &py); 

      k = In_Rect_Vol(xs->RM, px-xs->line.x1, py-xs->line.y1,
		      xm->wells[kount].well[a].loc[first_point].z, xs->min_xsdepth,
		      xs->max_xsdepth, xs->x_left, xs->x_right, xs->max_xsfront,
		      xs->max_xsback, &r, &dep, &off);

      /* printf("WELL - proj:k=%d %d %f %f %f %f %f %d %d\n",k,a,px,py,r,
	 off,dep, xm->wells[kount].well[a].style,
	 xm->wells[kount].well[a].nump);*/
      /* xs->line.x1, xs->line.y1, xs->line.x2, xs->line.y2, xs->dip,
	 xs->xdepth, xs->xwidth 
      if((dep <= xs->max_xsdepth) && (off <= xs->max_xsfront)
	 && (off >= xs->max_xsback) && (r > 0.0) && (r < hoz_dist))
 if(k==1)

*/



      if(((dep <= xs->y_bot) && (off <= xs->max_xsfront)
	 && (off >= xs->max_xsback) && (r > xs->x_left) && (r <xs->x_right )) )
	{
	  {
	  az = atan2((xs->line.y2 - xs->line.y1), (xs->line.x2 - xs->line.x1));
	  XSetForeground(d, ggc,
	    xm->colors[XmapAppColor(xm->wells[kount].well[a].color)]);
	  j = 0;

	  for(i = 0; i < xm->wells[kount].well[a].nump; i++)
	    {
	    phi = xm->wells[kount].well[a].loc[i].x;
	    lam = xm->wells[kount].well[a].loc[i].y;
	    geo2xy(xm, phi, lam, &px, &py); 
	    k = In_Rect_Vol(xs->RM, px-xs->line.x1, py-xs->line.y1,
			    xm->wells[kount].well[a].loc[i].z,
			    xs->min_xsdepth,xs->max_xsdepth, xs->x_left, xs->x_right,
			    xs->max_xsfront, xs->max_xsback, &r, &dep, &off);

	    /* check to make sure the well lies inside of box */
	    /* if ((dep <= xs->xdepth) && (off <= xs->xwidth) && (r > 0.0)
	       && (r < hoz_dist)) */
	    if(xm->wells_proj_all==1) k=1;
	    
	    if(k == 1)
	      {
	      p[j].x = user_to_pix_x(&xs->GR, (double)r);
	      p[j].y = user_to_pix_y(&xs->GR, (double)dep);
	      if((xm->wells[kount].well[a].style == 2)
		 || (xm->wells[kount].well[a].style == 3))
		{
		if(xs->dip_meter_flag == 1)
		  {
		  /* x is the strike and y is the dip   */

		  /* dx = (cos(xm->wells[kount].well[a].dip[i].x)
		   * cos(xm->wells[kount].well[a].dip[i].y));
		   dy = (sin(xm->wells[kount].well[a].dip[i].x)
		   * cos(xm->wells[kount].well[a].dip[i].y)); */

		  dx = cos(xm->wells[kount].well[a].dip[i].x);
		  dy = sin(xm->wells[kount].well[a].dip[i].x) ;
		  dz = sin(xm->wells[kount].well[a].dip[i].y);

		  px2 = px + xm->wells[kount].well[a].dip[i].z * dx;
		  py2 = py + xm->wells[kount].well[a].dip[i].z * dy;
		  pz2 = (xm->wells[kount].well[a].loc[i].z
			 + xm->wells[kount].well[a].dip[i].z * dz);
		                                 
		  k = In_Rect_Vol(xs->RM, px2-xs->line.x1, py2-xs->line.y1,
				  pz2, xs->min_xsdepth, xs->max_xsdepth,
				  xs->x_left,xs->x_right, xs->max_xsfront, xs->max_xsback,
				  &r2, &dep2, &off2);
		  }
		else
		  {
		  /*  data comes in azimuth dip and error  in radians */

		  beta = fabs((xm->wells[kount].well[a].dip[i].x - az));
		  tdip =  tan(xm->wells[kount].well[a].dip[i].y);
		  apparent = atan(tdip * cos(beta));
		  r2 = r + xm->wells[kount].well[a].dip[i].z * cos(apparent);
		  dep2 = (dep + xm->wells[kount].well[a].dip[i].z
			  * sin(apparent));
		  }

		/* fprintf(stderr, "apparent=%f beta=%f dip=%f r2=%f"
		   " dep2=%f\n",RAD2DEG*apparent , RAD2DEG*beta,
		   RAD2DEG*xm->wells[kount].well[a].dip[i].y, r2, dep2); */

		p2[j].x = user_to_pix_x(&xs->GR, (double)r2);
		p2[j].y = user_to_pix_y(&xs->GR, (double)dep2);
		}
	      j++;
	      }
	    }

	  if(xm->wells_project_flag == 1)
	    {


	      change_linewidth(d, ggc, xm->wells_thickness );

	      
	    switch(xm->wells[kount].well[a].style)
	      {
	      case 0:
	        XDrawLines(d, w, ggc, p, j, CoordModeOrigin);
		break;

	      case 1:
		for(i = 0; i < j - 1; i++)
		  {
		  XSetForeground(d, ggc,
		   xm->colors[XmapAppColor(xm->wells[kount].well[a].lith[i])]);
		  XDrawLine(d, w, ggc, p[i].x, p[i].y, p[i + 1].x, p[i + 1].y);
		  }
		break;

	      case 2:
		XDrawLines(d, w, ggc, p, j, CoordModeOrigin);
		for(i = 0; i < j; i++)
		  XDrawLine(d, w, ggc, p[i].x, p[i].y, p2[i].x, p2[i].y);
		break;

	      case 3:
		for(i = 0; i < j - 1; i++)
		  {
		  XSetForeground(d, ggc,
		   xm->colors[XmapAppColor(xm->wells[kount].well[a].lith[i])]);
		  XDrawLine(d, w, ggc, p[i].x, p[i].y, p[i + 1].x, p[i + 1].y);
		  XDrawLine(d, w, ggc, p[i].x, p[i].y, p2[i].x, p2[i].y);
		  }
		XDrawLine(d, w, ggc, p[j - 1].x, p[j - 1].y, p2[j - 1].x,
			  p2[j - 1].y);
		break;

	      default:
		XDrawLines(d, w, ggc, p, j, CoordModeOrigin);
		break;
	      }
	    }

	  if(xm->wells_name_flag)
	    {
	    if((a % 2) == 0) lx = 2;
	    else lx = 1;

	    ly = p[0].y - lx * xm->size_well;
	    XDrawLine(d, w, ggc, p[0].x, p[0].y, p[0].x, ly);
	    draw_just_text(d, w, ggc, p[0].x, ly,
			   xm->wells[kount].well[a].name, HJ_CENTER,
			   VJ_BASELINE);
	    }

	  if(xm->wells_symbol_flag)
	    {
	      change_linewidth(d, ggc, 1 );
	    draw_well(d, w, ggc, p[0].x, p[0].y, xm->size_well);
	    }
	  }
	}		/* end selection criteria  */
      }			/* end well loop  */
    }     /* end kount loop   */

  change_linewidth(d, ggc, 1 );
  
  }

void PSsec_plot_well(xsec *xs, FILE *inf)
  {
  mpic *xm = xs->m;
  float px, py, phi, lam, hoz_dist, dep, r, symb_dep, off, r2, dep2, beta,
    tdip, az, apparent;
  int a, i, k, j,  i1, kount;
  KMPoint p[FOC_TRACE], p2[FOC_TRACE];
  int first_point=1;


  hoz_dist = sqrt((xs->line.x1 - xs->line.x2) * (xs->line.x1 - xs->line.x2)
		  + (xs->line.y1 - xs->line.y2)
		  * ( xs->line.y1 - xs->line.y2));
	
  /* printf("In XSECT  WELLS -- %d  and top location:\n",
     xm->wells[kount].well_count); */	 

  fprintf(inf, " %% Plotting Well Data \n");
  fprintf(inf, "/plwell { newpath \n gsave translate 0 0 wsiz 0 360 arc"
	  " stroke \n ");
  fprintf(inf, "  0 45 360 { rotate \n wsiz 0 moveto wsiz 2 div 0 rlineto"
	  " stroke \n ");
  fprintf(inf, " } for \n grestore \n    } def \n\n\n");
  fprintf(inf, "\n\n /wsiz  3  def %%  well size \n");
  fprintf(inf, " .2 setlinewidth \n ");

  for(kount = 0; kount < xm->num_wells_files; kount++)
    {
    for(a = 0; a < xm->wells[kount].well_count; a++)
      {

	if(xm->wells[kount].well[a].nump<3) 
	  {  
	    first_point=0;  
	  }
	else
	  {
	    first_point=1;  
	  }
	
	



      phi = xm->wells[kount].well[a].loc[first_point].x;
      lam = xm->wells[kount].well[a].loc[first_point].y;
      geo2xy(xm, phi, lam, &px, &py); 

      k = In_Rect_Vol(xs->RM, px-xs->line.x1, py-xs->line.y1,
		      xm->wells[kount].well[a].loc[first_point].z, 
		      xs->min_xsdepth,
		      xs->max_xsdepth,xs->x_left, xs->x_right, xs->max_xsfront,
		      xs->max_xsback, &r, &dep, &off);

      /* if((dep <= xs->max_xsdepth) && (off <= xs->max_xsfront) */
      /* 	  && (off >= xs->max_xsback) && (r > 0.0) && (r < hoz_dist))

  if(k==1)

 */


     if((dep <= xs->y_bot) && (off <= xs->max_xsfront)
	 && (off >= xs->max_xsback) && (r > xs->x_left) && (r <xs->x_right ))
    
	{
	  {
	  fprintf(inf, " %% Well:  %s \n", xm->wells[kount].well[a].name);
	  az = atan2((xs->line.y2 - xs->line.y1), (xs->line.x2 - xs->line.x1));

	  i1 = xm->wells[kount].well[a].color;
	  fprintf(inf, "%f %f %f setcol1 \n", xm->jmlcol[i1].red, 
		  xm->jmlcol[i1].green, xm->jmlcol[i1].blue);
	  j = 0;

	  for(i = 0; i < xm->wells[kount].well[a].nump; i++)
	    {
	    phi = xm->wells[kount].well[a].loc[i].x;
	    lam = xm->wells[kount].well[a].loc[i].y;
	    geo2xy(xm, phi, lam, &px, &py); 

	    k = In_Rect_Vol(xs->RM, px-xs->line.x1, py-xs->line.y1,
			    xm->wells[kount].well[a].loc[i].z, xs->min_xsdepth,
			    xs->max_xsdepth, xs->x_left, xs->x_right, xs->max_xsfront,
			    xs->max_xsback, &r, &dep, &off);


	    if(xm->wells_proj_all==1) k=1;


	    if(k == 1)
	      {
	      p[j].x = r;
	      p[j].y = dep;
	      if((xm->wells[kount].well[a].style == 2)
		 || (xm->wells[kount].well[a].style == 3))
		{
		/*  data comes in azimuth dip and error  */

		tdip =  tan(xm->wells[kount].well[a].dip[i].y);
		apparent = atan(tdip * cos(beta));
		r2 = r + xm->wells[kount].well[a].dip[i].z * cos(apparent);
		dep2 = dep + xm->wells[kount].well[a].dip[i].z * sin(apparent);
		p2[j].x = r2;
		p2[j].y =  dep2;
		}
	      j++;
	      }
	    }

	  if(xm->wells_project_flag == 1)
	    {

	      fprintf(inf, "%f setlinewidth ",    0.2*(float)xm->wells_thickness );
	      
	    switch(xm->wells[kount].well[a].style)
	      {
	      case 0:
                m2psXpoint(inf, xs, p[0].x, p[0].y);
	        fprintf(inf, "\n");
		for(i = 1; i < j ; i++)
		   {
		   line2psXpoint(inf, xs, p[i].x, p[i].y);  fprintf(inf, "\n");
		   }
		fprintf(inf,"    stroke  \n");
		fprintf(inf, " %% end Well:  %s \n", xm->wells[kount].well[a].name);
		break;

	      case 1:
		for(i = 0; i < j - 1; i++)
		  {
		  i1 = xm->wells[kount].well[a].lith[i];
		  fprintf(inf, "%f %f %f setcol1 %% lith col\n", xm->jmlcol[i1].red, 
			  xm->jmlcol[i1].green, xm->jmlcol[i1].blue);
		  
		     m2psXpoint(inf, xs, p[i].x, p[i].y);
		     line2psXpoint(inf, xs, p[i+1].x, p[i+1].y);  fprintf(inf, "\n");
		     fprintf(inf,  " stroke\n");
		    
		  }
		   fprintf(inf, " %% end Well:  %s \n", xm->wells[kount].well[a].name);
		  
		break;

	      case 2:
		fprintf(inf, " %% Well:  DATA %s \n", xm->wells[kount].well[a].name );
                m2psXpoint(inf, xs, p[0].x, p[0].y);  fprintf(inf, "\n");
		
		for (i = 0; i < j - 1; i++)
		   {
		    line2psXpoint(inf, xs, p[i].x, p[i].y); fprintf(inf, "\n");
		    }
		
		fprintf(inf,"    stroke  \n");
		
		
		for(i = 0; i < j; i++)
		   {
		   m2psXpoint(inf, xs, p[i].x, p[i].y);  fprintf(inf, "\n");
		   line2psXpoint(inf, xs, p2[i].x, p2[i].y); fprintf(inf, " stroke\n");
		  }
		
		break;

	      case 3:
		fprintf(inf, " %% Well:  DATA \n");
		for(i = 0; i < j - 1; i++)
		  {
		  i1 = xm->wells[kount].well[a].lith[i];
		  fprintf(inf, "%f %f %f setcol1 \n", xm->jmlcol[i1].red, 
			  xm->jmlcol[i1].green, xm->jmlcol[i1].blue);
		   m2psXpoint(inf, xs, p[i].x, p[i].y); 
		   line2psXpoint(inf, xs, p2[i+1].x, p2[i+1].y); fprintf(inf, " stroke\n");
		 
		  }
		fprintf(inf, " %% Well:  DIP-METER %s\n", xm->wells[kount].well[a].name   );

		for(i = 0; i < j ; i++)
		  {
		  i1 = xm->wells[kount].well[a].lith[i];
		  fprintf(inf, "%f %f %f setcol1 \n", xm->jmlcol[i1].red, 
			  xm->jmlcol[i1].green, xm->jmlcol[i1].blue);

		   m2psXpoint(inf, xs, p[i].x, p[i].y); 
		   line2psXpoint(inf, xs, p2[i].x, p2[i].y); fprintf(inf, " stroke\n");

		  }
		break;

	      default:

		m2psXpoint(inf, xs, p[0].x, p[0].y);  fprintf(inf, "\n");
		for(i = 0; i < j - 1; i++)
		   {
		   line2psXpoint(inf, xs, p[i].x, p[i].y); fprintf(inf, "\n");
		   }
		fprintf(inf,"    stroke  \n");
		fprintf(inf, " %% end Well:  %s\n", xm->wells[kount].well[a].name   );
		
		break;
	      }
	    }

	  symb_dep = 0.0;
	  if(xm->wells_name_flag)
             {
	     putpsXpoint(inf, xs, p[0].x, p[0].y);
	     
	     fprintf(inf, "  .08 inch add moveto  gsave 45 rotate (%s) show grestore\n", 
		    xm->wells[kount].well[a].name);
	     }
	  

	  if(xm->wells_symbol_flag)
	     {
	     putpsXpoint(inf, xs, p[0].x, p[0].y);
	     fprintf(inf, "  plwell %% %s \n", 
		     xm->wells[kount].well[a].name);
	    }
	  

	  }
	}		/* end selection criteria  */
      }			/* end well loop  */
    }
  }



