/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"
#include "Rots.h"

/* --- functions --- */

/* copy in onto out */

void CopyTr(float in[4][4], float outt[4][4])
  {
  int i, j;

  for(i = 0; i < 4; i++)
    {
    for(j = 0; j < 4; j++)
      {
      outt[i][j] = in[i][j];
      }
    }
  }

/* transpose in onto out */

void Trn(float in[4][4], float outt[4][4])
  {
  int i, j;

  for(i = 0; i < 4; i++)
    {
    for(j = 0; j < 4; j++)
      {
      outt[i][j] = in[j][i];
      }
    }
  }

void MultConCat(float t[4][4], float rot[4][4], float out[4][4])
  {
  int i, j, k;

  for(i = 0; i < 4; i++)
    {
    for(j = 0; j < 4; j++)
      {
      out[i][j] = 0.0;
      for(k = 0; k < 4; k++)
	{
	out[i][j] += t[i][k] * rot[k][j];
	}
      }
    }
  }

void ConCat(float t[4][4], float rot[4][4])
  {
  int i, j, k;
  float out[4][4];

  for(i = 0; i < 4; i++)
    {
    for(j = 0; j < 4; j++)
      {
      out[i][j] = 0.0;
      for(k = 0; k < 4; k++)
	{
	out[i][j] += t[i][k] * rot[k][j];
	}
      }
    }
  CopyTr(out, t);
  }

void Idn(float rotmat[4][4])
  {
  int i, j;

  for(i = 0; i < 4; i++)
    for(j = 0; j < 4; j++)
      rotmat[i][j] = ((i == j) ? 1 : 0);
  }

void xrot(float deg1, float t[4][4])
  {
  float rot[4][4];

  Idn(rot);
  rot[1][1] = cos(deg1);
  rot[1][2] = sin(deg1);
  rot[2][2] = rot[1][1];
  rot[2][1] = -rot[1][2];
  ConCat(t, rot);
  }

void yrot(float deg1, float t[4][4])
  {
  float rot[4][4];

  Idn(rot);
  rot[0][0] = cos(deg1);
  rot[2][0] = sin(deg1);
  rot[0][2] = -rot[2][0];
  rot[2][2] = rot[0][0];
  ConCat(t, rot);
  }

void zrot(float deg1, float t[4][4])
  {
  float rot[4][4];

  Idn(rot);
  rot[0][0] = cos(deg1);
  rot[0][1] = sin(deg1);
  rot[1][1] = rot[0][0];
  rot[1][0] = -rot[0][1];
  ConCat(t, rot);
  }

void Tran3D(float a, float b, float c, float t[4][4])
  {
  float tr[4][4];

  Idn(tr);
  tr[3][0] = a;
  tr[3][1] = b;
  tr[3][2] = c;
  ConCat(t, tr);
  }

void VecRot(float invr[4], float t[4][4], float ov[4])
  {
  int i, j;

  for(i = 0; i < 4; i++)
    {
    ov[i] = 0;
    for(j = 0; j < 4; j++) ov[i] += invr[j] * t[j][i];
    }
  }

void MatRot(float **r, int n, float t[4][4])
  {
  int i,  k;
  float v1[4], v2[4];

  for(k = 0; k < n; k++)
    {
    for(i = 0; i < 4; i++) v1[i] = r[k][i];
    VecRot(v1, t, v2);
    for(i = 0; i < 4; i++) r[k][i] = v2[i];
    }
  }

void CopyMat(float **r, int n, float **new)
  {
  int i,  k;

  for(k = 0; k < n; k++)
    for(i = 0; i < 4; i++) new[k][i] = r[k][i];
  }

void project(int projcode, float t[4][4])
  {
  float proj[4][4];

  Idn(proj);
  if(projcode == 1) proj[0][0] = 0;
  if(projcode == 2) proj[1][1] = 0;
  if(projcode == 3) proj[2][2] = 0;
  ConCat(t,proj);
  }

void dimetric(int ycode, int xcode, float f, float t[4][4])
  {
  float phi, theta;

  phi = asin(f / (sqrt(2 - sqr(f))));
  theta = asin(f / XMAP_SQRT2);

  if(ycode == 0) phi *= -1;
  if(xcode == 0) theta *= -1;

  yrot(phi, t);
  xrot(theta, t);
  project(3, t);
  }

void genrot(float **a, float delta, float t[4][4])
  {
  float rx[4][4], ry[4][4], rdelta[4][4], rxinv[4][4], ryinv[4][4],
    tran[4][4], traninv[4][4], m[4][4],minv[4][4], temp1[4][4], temp2[4][4],
    cx, cy, cz, d, nfactor;

  Idn(rx);
  Idn(ry);
  Idn(tran);
  Idn(rdelta);
  Idn(rxinv);
  Idn(ryinv);
  Idn(traninv);

  cx = a[1][0] - a[0][0];
  cy = a[1][1] - a[0][1];
  cz = a[1][2] - a[0][3];

  nfactor = sqrt(sqr(cx) + sqr(cy) + sqr(cz));
  cx /= nfactor;
  cy /= nfactor;
  cz /= nfactor;
  d = sqrt(sqr(cy) + sqr(cz));
  tran[3][0] = -a[0][0];
  tran[3][1] = -a[0][1];
  tran[3][2] = -a[0][2];

  traninv[3][0] = a[0][0];
  traninv[3][1] = a[0][1];
  traninv[3][2] = a[0][2];

  rx[1][1] = cz / d;
  rx[1][2] = cy / d;
  rx[2][1] =- rx[1][2];
  rx[2][2] = rx[1][1];
  Trn(rx, rxinv);

  ry[0][0] = d;
  ry[0][2] = cx;
  ry[2][0] = -cx;
  ry[2][2] = d;
  Trn(ry, ryinv);

  rdelta[0][0] = cos(delta);
  rdelta[1][1] = rdelta[0][0];
  rdelta[0][1] = sin(delta);
  rdelta[1][0] = -rdelta[0][1];

  MultConCat(rx, ry, temp1);
  MultConCat(tran, temp1, m);
  MultConCat(rxinv, traninv, temp2);
  MultConCat(ryinv, temp2, minv);
  MultConCat(rdelta, minv, temp1);
  MultConCat(m, temp1, temp2);

  ConCat(t, temp2);
  }

void SeeRot(float t[4][4])
  {
  int i, j;

  for(i = 0; i < 4; i++)
    {
    for(j = 0; j < 4; j++) printf("%7.3f ", t[i][j]);
    putchar('\n');
    }
  }
