
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

/* --- local headers --- */

#include "geotouch.h"
#include "mpic.h"

/* --- function prototypes --- */

int PrintContParms(CONT_PARMS *pcontParms);
int PrintXDipParms(XDIP_PARMS *pxdipParms);

/* --- functions --- */

/*
 * Returns the specified integer attribute of the specified widget.
 */

int GetWidgetInt(Widget w, String attr)
  {
  Dimension iRet;
  Arg arg;

  XtSetArg(arg, attr, &iRet);
  XtGetValues(w, &arg, 1);
  return(iRet);
  }

/*
 * Sets the specified integer attribute of the specified widget to
 * the specified value.
 */

void SetWidgetInt(Widget w, String attr, int i)
  {
  Arg arg;

  XtSetArg(arg, attr, i);
  XtSetValues(w, &arg, 1);
  }

/*
 * Returns the specified float attribute of the specified widget.
 */

float GetWidgetFloat(Widget w, String attr)
  {
  Dimension iRet;
  Arg arg;

  XtSetArg(arg, attr, &iRet);
  XtGetValues(w, &arg, 1);
  return(iRet);
  }

/*
 * Sets the specified float attribute of the specified widget to
 * the specified value.
 */

void SetWidgetFloat(Widget w, String attr, float i)
  {
  Arg arg;

  XtSetArg(arg, attr, i);
  XtSetValues(w, &arg, 1);
  }

/*
 * Gets a string attribute of a widget.
 */

char *GetWidgetString(Widget w, String attr)
  {
  Arg arg;
  char *sz;

  XtSetArg(arg, attr, &sz);
  XtGetValues(w, &arg, 1);
  return(sz);
  }

int GetWidgetStringAsInt(Widget w,String  attr)
  {

  return(atoi(GetWidgetString(w, attr)));
  }

float GetWidgetStringAsFloat(Widget w, String attr)
  {

  return((float)atof(GetWidgetString(w, attr)));
  }

/*
 * Sets a string attribute of a widget.
 */

void SetWidgetString(Widget w, String attr, String sz)
  {
  Arg arg;

  XtSetArg(arg, attr, sz);
  XtSetValues(w, &arg, 1);
  }

/*
 * Sets a string attribute of a widget to the string representation
 * of the specified int.
 */

void SetWidgetStringToInt(Widget w, String attr, int i)
  {
  static char rgchTmp[16];

  sprintf(rgchTmp, "%d", i);
  SetWidgetString(w, attr, rgchTmp);
  }

/*
 * Sets a string attribute of a widget to the string representation
 * of the specified float.
 */

void SetWidgetStringToFloat(Widget w, String attr, float fl)
  {
  static char rgchTmp[16];

  sprintf(rgchTmp, "%g", fl);
  SetWidgetString(w, attr, rgchTmp);
  }

/*
 * Sets the label attribute of a widget that has that attribute.
 */

void SetLabel(Widget w, char *szLabel)
  {
  Arg arg;

  XtSetArg(arg, XtNlabel, szLabel);
  XtSetValues(w, &arg, 1);
  }

/**************************
   Window Updating Stuff
**************************/

/*
 * Sets the label attribute of a widget to the textual representation
 * of the specified integer.
 */

void SetIntLabel(Widget w, int iLabel)
  {
  char rgchTmp[16];

  sprintf(rgchTmp, "%d", iLabel);
  SetLabel(w, rgchTmp);
  }

/*
 * Copies the current cont variables to the cont window's widgets.
 * Returns FALSE if fails.
 */

Boolean CopyToContWindow(CONT_PARMS *pcontParms)
  {

  /* fprintf(stderr,"in copytocontwind\n"); */
  
  SetWidgetString(pcontParms->wREdit, XtNstring, pcontParms->R);
  SetWidgetString(pcontParms->wIEdit, XtNstring, pcontParms->I);
  SetWidgetStringToFloat(pcontParms->wAEdit, XtNstring, pcontParms->A);
  SetWidgetStringToFloat(pcontParms->wLEdit, XtNstring, pcontParms->L);
  SetWidgetStringToFloat(pcontParms->wNEdit, XtNstring, pcontParms->N);
  SetWidgetStringToFloat(pcontParms->wTEdit, XtNstring, pcontParms->T);
  SetWidgetStringToFloat(pcontParms->wXEdit, XtNstring, pcontParms->X);
  SetWidgetString(pcontParms->wFEdit, XtNstring, pcontParms->contfile);
  SetWidgetStringToFloat(pcontParms->wSEdit, XtNstring, pcontParms->S);
  SetWidgetStringToFloat(pcontParms->wZEdit, XtNstring, pcontParms->Z);

  /* PrintContParms(pcontParms); */

  return(TRUE);
  }

/*
 * Copies the contents of the contt window's widgets to be the current cont
 * parameters.
 * Returns FALSE if fails.
 */

Boolean CopyFromContWindow(CONT_PARMS *pcontParms)
  {
 
  /* XawListReturnStruct *plistret;
   * Get the values of the cont parameters specified in the cont window.
   */
  /* Get the values from the edit boxes. */

  strcpy(pcontParms->R, GetWidgetString(pcontParms->wREdit, XtNstring));
  strcpy(pcontParms->I, GetWidgetString(pcontParms->wIEdit, XtNstring));
  pcontParms->A = GetWidgetStringAsFloat(pcontParms->wAEdit, XtNstring);
  pcontParms->L = GetWidgetStringAsFloat(pcontParms->wLEdit, XtNstring);
  pcontParms->N = GetWidgetStringAsFloat(pcontParms->wNEdit, XtNstring);
  pcontParms->T = GetWidgetStringAsFloat(pcontParms->wTEdit, XtNstring);
  pcontParms->X = GetWidgetStringAsFloat(pcontParms->wXEdit, XtNstring);
  strcpy(pcontParms->contfile, GetWidgetString(pcontParms->wFEdit, XtNstring));
  pcontParms->S = GetWidgetStringAsFloat(pcontParms->wSEdit, XtNstring);
  pcontParms->Z = GetWidgetStringAsFloat(pcontParms->wZEdit, XtNstring);

  /* PrintContParms(pcontParms); */

  return(TRUE);
  }

/**********************************************************/

/*
 * Copies the current xdip variables to the xdip window's widgets.
 * Returns FALSE if fails.
 */

Boolean CopyToXDipWindow(XDIP_PARMS *pxdipParms)
  {

  SetWidgetStringToFloat(pxdipParms->wDipEdit, XtNstring, pxdipParms->dip);
  SetWidgetStringToFloat(pxdipParms->wMinzEdit, XtNstring, pxdipParms->minz);
  SetWidgetStringToFloat(pxdipParms->wMaxzEdit, XtNstring, pxdipParms->maxz);
  SetWidgetStringToFloat(pxdipParms->wFrontEdit, XtNstring, pxdipParms->front);
  SetWidgetStringToFloat(pxdipParms->wBackEdit, XtNstring, pxdipParms->back);

  return(TRUE);
  }

/*
 * Copies the xdipents of the xdipt window's widgets to be the current xdip
 * parameters.
 * Returns FALSE if fails.
 */

Boolean CopyFromXDipWindow(XDIP_PARMS *pxdipParms)
  {

  /*  XawListReturnStruct *plistret;
   * Get the values of the xdip parameters specified in the xdip window.
   */
  /* Get the values from the edit boxes. */

  pxdipParms->dip = GetWidgetStringAsFloat(pxdipParms->wDipEdit, XtNstring);
  pxdipParms->minz = GetWidgetStringAsFloat(pxdipParms->wMinzEdit, XtNstring);
  pxdipParms->maxz = GetWidgetStringAsFloat(pxdipParms->wMaxzEdit, XtNstring);
  pxdipParms->front = GetWidgetStringAsFloat(pxdipParms->wFrontEdit,
					     XtNstring);
  pxdipParms->back = GetWidgetStringAsFloat(pxdipParms->wBackEdit, XtNstring);

  /* PrintXDipParms(pxdipParms); */

  return(TRUE);
  }
