
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/*
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
*/

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jml.h"
#include "jutil.h"
#include "user2pix.h"
#include "focproto.h"

/* --- function prototypes --- */

Boolean readac(FILE * f, ac_rec * a);
int In_Rect_Vol(float RMAT[3][3], float dx, float dy, float dz, float mindep,
		float maxdep, float mindist , float maxdist, float d1, float d2, float *range,
		float *dep, float *aproj);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);

void create_Acard(ac_rec *ac, char *acrd);
void  plot_one_point(mpic *m, Display *dpy, Window xwin, GC gc, int ix,
		     int iy, int kount, int i);
void draw_Xmark(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
int simpX(int lx, int ly, float spacx, float spacy, float xq, float yq,
	  float xsta, float ysta, int *ivec, float *bvec);
int line_in_rect(float x1, float y1, float x2, float y2, float **poly1,
		 float newx[2], float newy[2]);
void get_perim(float dir[3], float axis[3], float elip[][2], int *n);
void Plane_Traj(float dip, float az, float *a1, float *a2, int *len);

double great_dist(double phi1, double lam0, double phi, double lam);

 int simp_greatX(int lx, int ly, float spacx, float spacy, 
		 double phieq, double lameq,
		 double  xq, double  yq,
		 double  xsta, double  ysta, 
		 int *ivec, float *rvec, double  *PHIvec,  double  *LAMvec);


/* --- functions --- */
/**  FUNC DEF **/ void cut_great_image(xsec *xs)
{
   mpic *xm = xs->m;
   int n;
  


/*    fprintf(stderr,"Cutting Great Image %f %f %f %f\n", */
/* 	   xm->cross[xm->num_xsec].xsecphilam.x1, */
/* 	   xm->cross[xm->num_xsec].xsecphilam.y1, */
/* 	   xm->cross[xm->num_xsec].xsecphilam.x2, */
/* 	   xm->cross[xm->num_xsec].xsecphilam.y2); */


/*    fprintf(stderr,"Cutting Great Image ORG %d %d %f %f %f %f\n", */
/* 	   xm->image.nx, xm->image.ny,  */
/* 	   xm->image.dx, xm->image.dy,  */
/* 	   xm->image.phi, xm->image.lam); */


   n = xm->image.nx + xm->image.ny + 2;


   xs->image_PHIvec = alloc_dvec(0, n);
   xs->image_LAMvec = alloc_dvec(0, n);
   xs->image_bvec = alloc_fvec(0, n);
   xs->image_ivec = alloc_ivec(0, n);

   fprintf(stderr, "IN: cut_great_image, going to simp_greatX\n");

   xs->image_nbloc = simp_greatX(xm->image.nx, xm->image.ny, 
				(double) xm->image.dx, (double)xm->image.dy, 
				(double) xm->image.phi, (double) xm->image.lam,
				 (double) xm->cross[xm->num_xsec].xsecphilam.x1,
				(double) xm->cross[xm->num_xsec].xsecphilam.y1,
				 (double)xm->cross[xm->num_xsec].xsecphilam.x2,
				(double) xm->cross[xm->num_xsec].xsecphilam.y2,
				 xs->image_ivec,  xs->image_bvec,
				 xs->image_PHIvec, xs->image_LAMvec);

   if(xs->image_nbloc == 0)
   {
      fprintf(stderr, "Sorry, Cross section does not intersect image...\n");
      return;
   }

   xs->image_are   = 6371*great_dist((double)deg2rad(xm->cross[xm->num_xsec].xsecphilam.x1), (double)deg2rad(xm->cross[xm->num_xsec].xsecphilam.y1),
			 (double)deg2rad(xs->image_PHIvec[0]), (double) deg2rad(xs->image_LAMvec[0]));

fprintf(stderr, "ARE=%f\n",xs->image_are );
  
}
/************************************************************/
/**  FUNC DEF **/ void cut_image(xsec *xs)
{
   mpic *xm = xs->m;
   int n, lx, ly, inout;
   float xq, yq, xsta, ysta, maxx, maxy, minx, miny, newx[2], newy[2], **poly1,
      dis1, dis2;

   n = xm->image.nx + xm->image.ny + 2;

   /* fprintf(stderr,"In plot_X_image...n=%d....%d %d\n", n, xm->image.nx,
      xm->image.ny);
      fprintf(stderr,"%f %f %f %f\n",xs->line.x1, xs->line.y1, xs->line.x2,
      xs->line.y2);
      bvec =  (float *) calloc(n*sizeof(float)); ivec =  (int *)calloc(n
      *sizeof(int)); */

   xs->image_bvec = alloc_fvec(0, n);
   xs->image_ivec = alloc_ivec(0, n);

   lx = xm->image.nx, ly = xm->image.ny;
   xq = xs->line.x1, yq = xs->line.y1;
   xsta = xs->line.x2, ysta = xs->line.y2;

   minx = xm->image.org_minx, maxx = xm->image.org_maxx;
   miny = xm->image.org_miny, maxy = xm->image.org_maxy;

   /* need to check here if the cross section starts or ends outside model */

   poly1 = alloc_fmat(0, 4, 0, 1);
   poly1[0][0] = minx, poly1[0][1] = miny;
   poly1[1][0] = maxx, poly1[1][1] = miny;
   poly1[2][0] = maxx, poly1[2][1] = maxy;
   poly1[3][0] = minx, poly1[3][1] = maxy;

   inout = line_in_rect(xq, yq, xsta, ysta, poly1, newx, newy);
   free_fmat(poly1, 0, 4, 0, 1);

   if(inout == 0)
   {
      fprintf(stderr, "Sorry, Cross section does not intersect image...\n");
      return;
   }

   if(inout > 0)
   {
      /* for (i = 0; i < inout; i++)fprintf(stderr, "Intersection Point %d
	 : %f %f\n", i, newx[i], newy[i]); */

      if(inout == 1)
      {
	 if((xq < minx || xq > maxx) || (yq < miny || yq > maxy)) 
	    xq = newx[0], yq = newy[0];
	 if((xsta < minx || xsta > maxx) || (ysta < miny || ysta > maxy))
	    xsta = newx[0], ysta = newy[0];
      }

      if(inout == 2)
      {
	 dis1 = (sqr(xq - newx[0]) + sqr(yq - newy[0]));
	 dis2 = (sqr(xq - newx[1]) + sqr(yq - newy[1]));
	 if(dis1 < dis2)
	 {
	    xq = newx[0], yq = newy[0];
	    xsta = newx[1], ysta = newy[1];
	 }
	 else
	 {
	    xq = newx[1], yq = newy[1];
	    xsta = newx[0],	ysta = newy[0];
	 }
      }
   }

   xs->image_nbloc = simpX(lx, ly, xm->image.dx, xm->image.dy, xq - minx,
			   yq - miny, xsta - minx, ysta - miny, xs->image_ivec,
			   xs->image_bvec);
   xs->image_are = sqrt(sqr(xq - xs->line.x1) + sqr(yq - xs->line.y1));
}
/*****************************************************************/
/** FUNC DEF **/ void plot_X_image(Display *d, Window w, GC ggc, xsec *xs)
  {
  mpic *xm = xs->m;
  int i, j, k, px, py, hsizex, hsizey, naughtx, imdepth;
  float y = 0.0, x1, x2;

  naughtx = user_to_pix_x(&xs->GR, (double)0);
  imdepth = xm->image.nz;

  for(i = 0; i < xm->image.nz; i++)
    {
    if((xs->xdepth > xm->image.z_parts[i])
       && (xs->xdepth < xm->image.z_parts[i + 1]))
      imdepth = i;
    }

  for(i = 0; i < imdepth; i++)
    {
    y = xm->image.z_parts[i];
    x2 = 0;

    /* the following line is inefficient because abs() evalutes arguments
       more than once */

    hsizey = abs(user_to_pix_y(&xs->GR, (double)xm->image.z_parts[i + 1])
		 - (user_to_pix_y(&xs->GR, (double)y)));

    for(j = 0; j < xs->image_nbloc; j++)
      {
      x2 += xs->image_bvec[j];
      x1 = x2 - xs->image_bvec[j];
      px = user_to_pix_x(&xs->GR, (double)(x1 + xs->image_are));
      /* px2 = user_to_pix_x(&xs->GR, (double) x2); */
      py = user_to_pix_y(&xs->GR, (double)y);
      hsizex = user_to_pix_x(&xs->GR, (double)xs->image_bvec[j]) - naughtx;
      k = xs->image_ivec[j] + i * (xm->image.nx * xm->image.ny);

      if(xm->image.col[k] != 0){
      XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->image.col[k])]);
      XFillRectangle(d, w, ggc, px, py, hsizex + 1, hsizey + 1);
      }
      

      }
    }
  }

void Xsec_plot_points(xsec *xs, Display *dpy, Window xwin, GC gc)
  {
  mpic *m = xs->m;
  int i, k, ix, iy, kount;
  float px, py, garb, dep, r, off;

  for(kount = 0; kount < m->point_flag; kount++)
    {
    for(i = 0; i < m->Mpoint[kount].numpoints; i++)
      {
      geo2xy(m, m->Mpoint[kount].points[i].lat, m->Mpoint[kount].points[i].lon,
	     &px, &py);
      garb = m->Mpoint[kount].points[i].depth;
      k = In_Rect_Vol(xs->RM, px - xs->line.x1, py - xs->line.y1, garb,
		      xs->min_xsdepth, xs->max_xsdepth, xs->x_left,xs->x_right,
		      xs->max_xsfront, xs->max_xsback, &r, &dep, &off);
      if(k == 1)
	{
	ix = user_to_pix_x(&xs->GR, (double)r);
	iy = user_to_pix_y(&xs->GR, (double)dep);
	plot_one_point(m, dpy, xwin, gc, ix, iy, kount, i);
	}
      }
    }
  }

void Xsec_plot_lips(xsec *xs, Display *dpy, Window xwin, GC gc)
   {
   mpic *mplot = xs->m;
   int i, k, klip, kin, kk, kount;
   float px, py, xp, yp, garb, dep, r, off, ang, degrad,
   dirin[3], dir[3], axis[3], elip[360][2];
   XPoint p[200];
   double dis;
   double fi, phir, theta;
   double a, b;
   

   degrad = 0.0174532;
   ang = 0.0;

   /* direction is 90 degrees away, orthogonal to direction of line */
       
   dis = sqrt((xs->line.x2 - xs->line.x1) * (xs->line.x2 - xs->line.x1)
	      + (xs->line.y2 - xs->line.y1) * (xs->line.y2 - xs->line.y1));
   dirin[0] = -(xs->line.y2 - xs->line.y1) / dis;
   dirin[1] = (xs->line.x2 - xs->line.x1) / dis;
   dirin[2] = sin(degrad * (xs->dip - 90));

   /* fprintf(stderr,"dx=%f dy=%f dz=%f dip1=%f dip2=%f\n", dirin[0], dirin[1],
      dirin[2], xs->dip, xs->xs_dip); */

   for(klip = 0; klip < mplot->lip_num; klip++)
      {
      for(k = 0; k < mplot->lip[klip].n; k++)
	 {
	 geo2xy(mplot, mplot->lip[klip].lips[k].latlon.phi,
		mplot->lip[klip].lips[k].latlon.lam, &px, &py);
	 garb = mplot->lip[klip].lips[k].latlon.z;
	 kin = In_Rect_Vol(xs->RM, px - xs->line.x1, py - xs->line.y1, garb,
			   xs->min_xsdepth, xs->max_xsdepth, xs->x_left, xs->x_right,
			   xs->max_xsfront, xs->max_xsback, &r, &dep, &off);
	 if(kin == 1)
	    {

	    if(mplot->lip[klip].lips[k].ind==1)
	       {
   
	       fi = 0;
	       phir = degrad * fi;
	       a = mplot->lip[klip].lips[k].ebar.x;

	       /*  to get the a axis need to make a calculation  */

	       theta = atan((mplot->lip[klip].lips[k].ebar.x
			     / mplot->lip[klip].lips[k].ebar.y)
			    * ((xs->line.x2 - xs->line.x1)
			       / (xs->line.y2 - xs->line.y1)));
	       a = sqrt(sqr(mplot->lip[klip].lips[k].ebar.x * sin(theta))
			+ sqr(mplot->lip[klip].lips[k].ebar.y * cos(theta)));
	       b = mplot->lip[klip].lips[k].ebar.z;
	       /*fprintf(stderr,"xlip: a=%f b=%f\n", a,b);*/
	       xp = (a * cos(ang) * cos(phir) - b * sin(ang) * sin(phir)) + r;
	       yp = (a * cos(ang) * sin(phir) + b * sin(ang) * cos(phir)) + dep;
	       kount = 0;
	       p[kount].x = user_to_pix_x(&xs->GR, (double)xp);
	       p[kount].y = user_to_pix_y(&xs->GR, (double)yp);
	       kount++;

	       for(i = 10; i < 360; i += 10)
		  {
		  ang = degrad * i;
		  xp = (a * cos(ang) * cos(phir) - b * sin(ang) * sin(phir)) + r;
		  yp = (a * cos(ang) * sin(phir) + b * sin(ang) * cos(phir)) + dep;
		  p[kount].x = user_to_pix_x(&xs->GR, (double)xp);
		  p[kount].y = user_to_pix_y(&xs->GR, (double)yp);
		  kount++;
		  }
	       p[kount].x = p[0].x;
	       p[kount].y = p[0].y;
	       kount++;

	       }
	    else
	       {
	   
	       axis[0] = mplot->lip[klip].lips[k].lambda[0];
	       axis[1] = mplot->lip[klip].lips[k].lambda[1];
	       axis[2] = mplot->lip[klip].lips[k].lambda[2];

	       dir[0] = (mplot->lip[klip].lips[k].vec[0][0] * dirin[0]
			 + mplot->lip[klip].lips[k].vec[0][1] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[0][2] * dirin[2]);
	       dir[1] = (mplot->lip[klip].lips[k].vec[1][0] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[1][1] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[1][2] * dirin[2]);
	       dir[2] = (mplot->lip[klip].lips[k].vec[2][0] * dirin[2]
			 + mplot->lip[klip].lips[k].vec[2][1] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[2][2] * dirin[2]);

	       kount = 0;
	       get_perim(dir, axis, elip, &kk);
	       for(i = 0; i < kk; i++)
		  {
		  xp = elip[i][0] + r;
		  yp = elip[i][1] + dep;
		  p[kount].x = user_to_pix_x(&xs->GR, (double)xp);
		  p[kount].y = user_to_pix_y(&xs->GR, (double)yp);
		  kount++;
		  }
	       }
	
	    XSetForeground(dpy,  gc, mplot->colors[XmapAppColor(1)]);
	    XDrawLines(dpy, xwin, gc, p, kount, CoordModeOrigin);
	    }
	 }
      }
   }

void plot_X_focs( Display *d, Window w, GC ggc, xsec *xs)
  {
  XPoint p[FOC_TRACE];
  int circle = 23040, i, k, j, kount, mx, my, kx, ky, kx2, ky2, slip_siz = 3,
    ix, iy, foc_color, ipol, iplotpt = 0, iang = 5, num1, num2, hsize, numft1;
  float phirot, tq, ax, xi, ay, xtr1[FOC_TRACE], xtr2[FOC_TRACE],
    ytr1[FOC_TRACE],ytr2[FOC_TRACE], urot, udip, vrot, vdip, prot, pdip,
    trot, tdip, focx[FAULT_TRACE], focy[FAULT_TRACE], ang, ang2, az1, d1, az2,
    d2;
  mpic *xm = xs->m;

  if(xm->focal_explode >= 1)
    {
    XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->foreground_col)]);
    for(j = 0; j < xs->jselect; j++) 
      {
      hsize = xs->focrad[j];
      ix = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x2);
      iy = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y2);
      mx = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x1);
      my = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y1);
      XDrawLine(d, w, ggc, ix, iy, mx, my);
      }
    }

  /* READY TO PLOT */

  for(j = 0; j < xs->jselect; j++) 
    {
    hsize = xs->focrad[j];
    ix = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x1);
    iy = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y1);
                
    if(xm->focal_explode >= 1)
      {
      ix = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x2);
      iy = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y2);
      mx = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x1);
      my = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y1);
      }

    i = xs->focind[j];
    kount = xs->focind_file[j];
    foc_color = xm->focm_color - kount;
    if(foc_color < 0) foc_color = xm->num_fixed_colors - 1;
    XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
    phirot  = -xs->XSEC_angle;
    urot = xm->focm[kount].focs[i].fm.urot;
    udip = xm->focm[kount].focs[i].fm.udip;
    vrot = xm->focm[kount].focs[i].fm.vrot;
    vdip = xm->focm[kount].focs[i].fm.vdip;
    prot = xm->focm[kount].focs[i].fm.prot;
    pdip = xm->focm[kount].focs[i].fm.pdip;
    trot = xm->focm[kount].focs[i].fm.trot;
    tdip = xm->focm[kount].focs[i].fm.tdip;

    Rot_foc_phi(&phirot, &urot, &udip, &vrot, &vdip, &az1, &d1, &az2, &d2,
		&prot, &pdip, &trot, &tdip);
    Beach_ball(&az1, &d1, &az2, &d2, &prot, &pdip, &trot, &tdip, &iplotpt,
	       iang, xtr1, ytr1, &num1, xtr2, ytr2, &num2, &ipol);

/* original....*/
    /* temp ang = d1; ang2 =  az1-90.; 
       Plane_Traj(ang,ang2, focx,focy,&numft1); */

/*  later - this was in here but craig pointed out it was a bug  */
    /*    ang = d2; */
/*     ang2 =  az2 - 90.0;  */
    ang = d1; 
    ang2 =  az1 - 90.0;


    Plane_Traj(ang, ang2, focx, focy, &numft1);

    /* PLOTTING */

    switch(xm->focal_plot_style)
      {
      case 5:
        if(xm->focm_color == 0)
	  XSetForeground(d, ggc,
	     xm->colors[XmapAppColor(xm->focm[kount].focs[i].type)]);
	else
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);

	for(k = 0; k < numft1; k++)     
	  {
	  p[k].x = ix + hsize * focx[k];
	  p[k].y = iy - hsize * focy[k];           
	  }
	XDrawLines(d, w, ggc, p, numft1, CoordModeOrigin);

	xi =  -0.0174532 * d1;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (az1));
	ay = hsize * tq * cos(0.0174532 * (az1));
	kx = ix + ax;
	ky = iy - ay;
	xi =  1.570796327 - 0.0174532 * d1;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (az1));
	ay = hsize * tq * cos(0.0174532 * (az1));
	kx2 = ix + ax + slip_siz / 2;
	ky2 = iy - ay + slip_siz / 2;
	XFillRectangle(d, w, ggc, kx, ky, slip_siz, slip_siz);
	break;

      case 3:
	if(xm->focm_color == 0)
	  XSetForeground(d, ggc,
	     xm->colors[XmapAppColor(xm->focm[kount].focs[i].type)]);

	/* P-Axis */       
	xi = 1.570796327 - 0.0174532 * pdip;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * prot);
	ay = hsize * tq * cos(0.0174532 * prot) ;
	kx = ix + ax;
	ky = iy - ay;
	/* this is the lower hemisphere point  */
	xi =  1.570796327 - 0.0174532 * pdip;
	tq = -1.414213562*sin(xi/2.0);
	ax = hsize * tq * sin(0.0174532 * (prot));
	ay = hsize * tq * cos(0.0174532 * (prot));
	kx2 = ix + ax;
	ky2 = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);
 
	/* T-Axis */
	xi = 1.570796327 - 0.0174532 * tdip;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * trot);
	ay = hsize * tq * cos(0.0174532 * trot);
	kx = ix + ax;
	ky = iy - ay;
	/* this is the lower hemisphere point  */
	xi = 1.570796327 - 0.0174532 * tdip;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (trot));
	ay = hsize * tq * cos(0.0174532 * (trot));
	kx2 = ix + ax;
	ky2 = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);
	XSetForeground(d, ggc, xm->colors[XmapAppColor(1)]);
	break;

      case 7:
	if(xm->focm_color == 0)
	  XSetForeground(d, ggc,
	     xm->colors[XmapAppColor(xm->focm[kount].focs[i].type)]);
	/*    P-Axis   */       
	xi = 1.570796327 - 0.0174532 * pdip;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * prot);
	ay = hsize * tq * cos(0.0174532 * prot);
	kx = ix + ax;
	ky = iy - ay;
	/* this is the lower hemisphere point  */
	xi =  1.570796327 - 0.0174532 * pdip;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (prot));
	ay = hsize * tq * cos(0.0174532 * (prot));
	kx2 = ix + ax;
	ky2 = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);
	break;

      case 8:
	if(xm->focm_color == 0)
	  XSetForeground(d, ggc,
	    xm->colors[XmapAppColor(xm->focm[kount].focs[i].type)]);
	/*     T-Axis    */
	xi = 1.570796327 - 0.0174532 * tdip;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * trot);
	ay = hsize * tq * cos(0.0174532 * trot);
	kx = ix + ax;
	ky = iy - ay;
	/* this is the lower hemisphere point  */
	xi = 1.570796327 - 0.0174532 * tdip;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (trot));
	ay = hsize * tq * cos(0.0174532 * (trot));
	kx2 = ix + ax;
	ky2 = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);
	XSetForeground(d, ggc, xm->colors[XmapAppColor(1)]);
	/* end T axis */
	break;

      case 6:                  /* Ralph Archuleta method   */
	if(xm->focm_color == 0)
	  XSetForeground(d, ggc,
	    xm->colors[XmapAppColor(xm->focm[kount].focs[i].type)]);
	/*    strike line -Axis   */       
	tq = 1.0;
	xi =  0.0174532 * az2 - 1.570796327;
	ax = hsize * tq * sin(xi);
	ay = hsize * tq * cos(xi);
	kx = ix + ax;
	ky = iy - ay;
	tq = -1.0;
	ax = hsize * tq * sin(xi);
	ay = hsize * tq * cos(xi);
	kx2 = ix + ax;
	ky2 = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);

	/*   Down  Dip line    */

	xi = 1.570796327 - 0.0174532 * d2;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (az2));
	ay = hsize * tq * cos(0.0174532 * (az2));
	kx = ix + ax;
	ky = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, ix, iy);
	break;

      default:
	if(ipol == 0)
	  {
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->back_foc_col)]);
	  XFillArc(d, w, ggc, ix - hsize, iy - hsize, 2 * hsize, 2 * hsize, 0,
		   circle);
	  if(xm->focm_color == 0)
	    XSetForeground(d, ggc,
	      xm->colors[XmapAppColor(xm->focm[kount].focs[i].type)]);
	  else
	    XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
	  }
	else  
	  {
	  if(xm->focm_color == 0)
	  XSetForeground(d, ggc, 
	    xm->colors[XmapAppColor(xm->focm[kount].focs[i].type)]);
	  else
	    XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);

	  XFillArc(d, w, ggc, ix - hsize, iy - hsize, 2 * hsize, 2 * hsize, 0,
		   circle);
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->back_foc_col)]);
	  }
                      
	/* plot first trajectory  */

	for(k = 0; k < num1; k++)    
	  {
	  p[k].x = ix + hsize * xtr1[k];
	  p[k].y = iy - hsize * ytr1[k];
	  }
	XFillPolygon(d, w, ggc, p, num1, Nonconvex, CoordModeOrigin);
	/* plot second trajectory  */
	for(k = 0; k < num2; k++)     
	  {
	  p[k].x = ix + hsize * xtr2[k];
	  p[k].y = iy - hsize * ytr2[k];
	  }
	XFillPolygon(d, w, ggc, p, num2, Nonconvex, CoordModeOrigin);

	/* plot  P and T axis */

	if(xm->focal_plot_style == 2)
	  {
	  if(xm->focal_plot_style == 3)
	    {
	    /*  blank out work done in plotting planes  */
	    XSetForeground(d, ggc,
			   xm->colors[XmapAppColor(xm->back_foc_col)]);
	    XFillArc(d, w, ggc, ix - hsize, iy - hsize, 2 * hsize, 2 * hsize,
		     0, circle);
	    }
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->ptax_col)]);

	  /*    P-Axis   */       
	  xi = 1.570796327 - 0.0174532 * pdip;
	  tq = XMAP_SQRT2 * sin(xi / 2.0);
	  ax = hsize * tq * sin(0.0174532 * prot);
	  ay = hsize * tq * cos(0.0174532 * prot);
	  kx = ix + ax;
	  ky = iy - ay;
	  draw_Xmark(d, w, ggc, kx, ky, xm->SourceSize);

	  /*     T-Axis    */
	  xi = 1.570796327 - 0.0174532 * tdip;
	  tq = XMAP_SQRT2 * sin(xi / 2.0);
	  ax = hsize * tq * sin(0.0174532 * trot);
	  ay = hsize * tq * cos(0.0174532 * trot);
	  kx = ix + ax;
	  ky = iy - ay;

	  XFillRectangle(d, w, ggc, kx - xm->SourceSize / 2,
			 ky - xm->SourceSize / 2, xm->SourceSize,
			 xm->SourceSize);
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->foreground_col)]);
	  }

	/* draw fault plane  */

        if(xm->focal_plot_style == 4)
	  {
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->faultplane_col)]);
	  for(k = 0; k < numft1; k++)     
	    {
	    p[k].x = ix + hsize * focx[k];
	    p[k].y = iy - hsize * focy[k];
	    }
	  XDrawLines(d, w, ggc, p, numft1, CoordModeOrigin); 
	  }
	break;
      }                                   
    }
  }

/*****************************************************************/

void plot_X_focs_BW(Display *d, Window w, GC ggc, xsec *xs)
  {
  XPoint p[FOC_TRACE];
  int circle = 23040, i, k, j, kount, numft1, foc_color = 1, back_foc_col = 0,
    mx, my, hsize, kx, ky, kx2, ky2, slip_siz = 3, ix, iy, ipol, iplotpt = 0,
    iang = 5, num1, num2;
  float phirot, tq, ax, xi, ay, xtr1[FOC_TRACE], xtr2[FOC_TRACE],
    ytr1[FOC_TRACE], ytr2[FOC_TRACE], urot, udip, vrot, vdip, prot,
    pdip, trot, tdip, focx[FAULT_TRACE], focy[FAULT_TRACE], ang, ang2, az1,
    d1, az2, d2;
  mpic *xm = xs->m;

  if(xm->focal_explode >= 1)
    {
    XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
    for(j = 0; j < xs->jselect; j++) 
      {
      hsize = xs->focrad[j];
      ix = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x2);
      iy = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y2);
      mx = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x1);
      my = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y1);
      XDrawLine(d, w, ggc, ix, iy, mx, my);
      }
    }

  /* READY TO PLOT */

  for(j = 0; j < xs->jselect; j++) 
    {
    hsize = xs->focrad[j];
    ix = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x1);
    iy = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y1);

    if(xm->focal_explode >= 1)
      {
      ix = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x2);
      iy = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y2);
      mx = user_to_pix_x(&xs->GR, (double)xs->focpos[j].x1);
      my = user_to_pix_y(&xs->GR, (double)xs->focpos[j].y1);
      }

    i = xs->focind[j];
    kount = xs->focind_file[j];
    XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
    phirot = -xs->XSEC_angle;
    urot = xm->focm[kount].focs[i].fm.urot;
    udip = xm->focm[kount].focs[i].fm.udip;
    vrot = xm->focm[kount].focs[i].fm.vrot;
    vdip = xm->focm[kount].focs[i].fm.vdip;
    prot = xm->focm[kount].focs[i].fm.prot;
    pdip = xm->focm[kount].focs[i].fm.pdip;
    trot = xm->focm[kount].focs[i].fm.trot;
    tdip = xm->focm[kount].focs[i].fm.tdip;

    Rot_foc_phi(&phirot, &urot, &udip, &vrot, &vdip, &az1, &d1, &az2, &d2,
		&prot, &pdip, &trot, &tdip);
    Beach_ball(&az1, &d1, &az2, &d2, &prot, &pdip, &trot, &tdip, &iplotpt,
	       iang, xtr1, ytr1, &num1, xtr2, ytr2, &num2, &ipol);
    ang = d2;
    ang2 = az2 - 90.0; 
    Plane_Traj(ang, ang2, focx, focy, &numft1);

    /* PLOTTING */

    switch(xm->focal_plot_style)
      {
      case 5:
        XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
	for(k = 0; k < numft1; k++)     
	  {
	  p[k].x = ix + hsize * focx[k];
	  p[k].y = iy - hsize * focy[k];
	  }
	XDrawLines(d, w, ggc, p, numft1, CoordModeOrigin);
	xi =  - 0.0174532 * d1;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (az1));
	ay = hsize * tq * cos(0.0174532 * (az1));
	kx = ix + ax;
	ky = iy - ay;
	xi =  1.570796327 - 0.0174532 * d1;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (az1));
	ay = hsize * tq * cos(0.0174532 * (az1));
	kx2 = ix + ax + slip_siz / 2;
	ky2 = iy - ay + slip_siz / 2;
	XFillRectangle(d, w, ggc, kx, ky, slip_siz, slip_siz);
	break;

      case 3:
	/*    P-Axis   */       
	xi = 1.570796327 - 0.0174532 * pdip;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * prot);
	ay = hsize * tq * cos(0.0174532 * prot);
	kx = ix + ax;
	ky = iy - ay;
	/* this is the lower hemisphere point  */
	xi =  1.570796327 - 0.0174532 * pdip;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (prot));
	ay = hsize * tq * cos(0.0174532 * (prot));
	kx2 = ix + ax;
	ky2 = iy - ay;
	/*  printf("P axis: kx ky kx2 ky2: %d %d %d %d ",kx,ky,kx2,ky2);*/
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);
	/*     T-Axis    */
	xi = 1.570796327 - 0.0174532 * tdip;
	tq = -XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * trot);
	ay = hsize * tq * cos(0.0174532 * trot);
	kx = ix + ax;
	ky = iy - ay;
	/* this is the lower hemisphere point  */
	xi = 1.570796327 - 0.0174532 * tdip;
	tq = XMAP_SQRT2 * sin(xi / 2.0);
	ax = hsize * tq * sin(0.0174532 * (trot));
	ay = hsize * tq * cos(0.0174532 * (trot));
	kx2 = ix + ax;
	ky2 = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);
	break;

      case 6:                  /* Ralph Archuleta method */
	/* strike line -Axis */
	tq = 1.0;
	xi =  0.0174532 * az2 - 1.570796327;
	ax = hsize * tq * sin(xi);
	ay = hsize * tq * cos(xi);
	kx = ix + ax;
	ky = iy - ay;
	tq = -1.0;
	ax = hsize * tq * sin(xi);
	ay = hsize * tq * cos(xi);
	kx2 = ix + ax;
	ky2 = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, kx2, ky2);
 
	/*   Down  Dip line    */
	xi = 1.570796327 - 0.0174532 * d2;
	tq = -XMAP_SQRT2 * sin(xi/2.0);
	ax = hsize * tq * sin(0.0174532 * (az2));
	ay = hsize * tq * cos(0.0174532 * (az2));
	kx = ix + ax;
	ky = iy - ay;
	XDrawLine(d, w, ggc, kx, ky, ix, iy);
	break;

      default:
	if(ipol == 0)
	  {
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(back_foc_col)]);
	  XFillArc(d, w, ggc, ix - hsize, iy - hsize, 2 * hsize, 2 * hsize, 0,
		   circle);
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
	  }
	else  
	  {
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
	  XFillArc(d, w, ggc, ix - hsize, iy - hsize, 2 * hsize, 2 * hsize, 0,
		   circle);
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(back_foc_col)]);
	  }

           /* plot first trajectory  */
         
	for(k = 0; k < num1; k++)
	  {
	  p[k].x = ix + hsize * xtr1[k];
	  p[k].y = iy - hsize * ytr1[k];
	  }
	XFillPolygon(d, w, ggc, p, num1, Nonconvex, CoordModeOrigin);
	/* plot second trajectory  */
          
	for(k = 0; k < num2; k++)     
	  {
	  p[k].x = ix + hsize * xtr2[k];
	  p[k].y = iy - hsize * ytr2[k];
	  }
	XFillPolygon(d, w, ggc, p, num2, Nonconvex, CoordModeOrigin);
	XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
	XDrawArc(d, w, ggc, ix - hsize, iy - hsize, 2 * hsize, 2 * hsize, 0,
		 circle);

	/*    plot  P and T axis    */
	if(xm->focal_plot_style == 2)
	  {
	  if(xm->focal_plot_style == 3)
	    {
	    /*  blank out work done in plotting planes  */
	    XSetForeground(d, ggc, xm->colors[XmapAppColor(back_foc_col)]);
	    XFillArc(d, w, ggc, ix - hsize, iy - hsize,	2 * hsize, 2 * hsize,
		     0, circle);
	    }
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);

	  /*    P-Axis   */       
	  xi = 1.570796327 - 0.0174532 * pdip;
	  tq = XMAP_SQRT2 * sin(xi / 2.0);
	  ax = hsize * tq * sin(0.0174532 * prot);
	  ay = hsize * tq * cos(0.0174532 * prot);
	  kx = ix + ax;
	  ky = iy - ay;
	  draw_Xmark(d, w, ggc, kx, ky, xm->SourceSize);

	  /*     T-Axis    */
	  xi = 1.570796327 - 0.0174532 * tdip;
	  tq = XMAP_SQRT2 * sin(xi / 2.0);
	  ax = hsize * tq * sin(0.0174532 * trot);
	  ay = hsize * tq * cos(0.0174532 * trot);
	  kx = ix + ax;
	  ky = iy - ay;
	  XFillRectangle(d, w, ggc, kx - xm->SourceSize / 2,
			 ky - xm->SourceSize / 2, xm->SourceSize,
			 xm->SourceSize);
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
	  }

	/* draw fault plane  */

        if(xm->focal_plot_style == 4)
	  {
	  XSetForeground(d, ggc, xm->colors[XmapAppColor(foc_color)]);
	  for(k = 0; k < numft1; k++)
	    {
	    p[k].x = ix + hsize * focx[k];
	    p[k].y = iy - hsize * focy[k];
	    }

	  XDrawLines(d, w, ggc, p, numft1, CoordModeOrigin); 
	  }
	break;
      }                                   
    }
  }

/******************************************************/

int select_X_focs(xsec *xs)
  {
  mpic *xm = xs->m;
  int i ,k, j = 0, kount;
  float aiy, dep, r, off, px, py, phi, lam, dis, dist, explode_angle, dismax,
    meand, meanr;

  meanr = meand = 0.0;
  xs->jselect = 0;
  aiy = xs->xdim;

  for(kount = 0; kount < xm->num_focm_files; kount++)
    {
    for(i = 0; i < xm->focm[kount].numpoints; i++) 
      {

   if(!xm->focm[kount].focs[i].on_off)continue;

      phi = xm->focm[kount].focs[i].loc.x;
      lam = xm->focm[kount].focs[i].loc.y;
      geo2xy(xm, phi, lam, &px, &py);

      k = In_Rect_Vol(xs->RM, px-xs->line.x1, py-xs->line.y1,
		      xm->focm[kount].focs[i].loc.z, xs->min_xsdepth,
		      xs->max_xsdepth, xs->x_left, xs->x_right, xs->max_xsfront,
		      xs->max_xsback, &r, &dep, &off);

      /*  SELECTION CRITERIA  */

      if(k == 1) 
	{
	xs->FOC_IN[i] = 1;
	xs->focpos[j].y1 = dep;
	xs->focpos[j].x1 = r;
	meanr += r, meand += dep;
	xs->focrad[j] = xm->size_focm / 2;

	if(xm->focm[kount].scale_by_mag == 1)
	  {
	  if(xm->focm[kount].minMag < xm->focm[kount].maxMag)
	    xs->focrad[j] += (xs->focrad[j] * (xm->focm[kount].focs[i].ac.mag
					       - xm->focm[kount].minMag)
			      / (xm->focm[kount].maxMag
				 - xm->focm[kount].minMag));
	  else xs->focrad[j] = xm->size_focm / 2;
	  }
	xs->focind[j] = i;
	xs->focind_file[j] = kount;
	++j;                 
	} 
      else xs->FOC_IN[i] = 0;
      }
    }   

  xs->jselect = j;
  if(xs->jselect != 0)
    {
    meanr /= (float)xs->jselect;
    meand /= (float)xs->jselect;
    }

  /* find the maximum distance */

  dismax = 0.0;
  for(j = 0; j < xs->jselect; j++)
    {
    dis = sqrt(sqr(meanr-xs->focpos[j].x1) + sqr(meand-xs->focpos[j].y1));
    dismax = max2(dis,dismax);
    }


  printf("\nXS %d : %d focals were selected\n and md mr dmax: %f %f %f\n",
	 xs->index, xs->jselect, meand, meanr, dismax);

  /* get the explode positions */

  for(j = 0; j < xs->jselect; j++) 
    {
    dis = sqrt(sqr(meanr-xs->focpos[j].x1) + sqr(meand-xs->focpos[j].y1));
    dist = dismax + dis + 0.4 * dismax;
    explode_angle = atan2((xs->focpos[j].y1 - meand),
			  (xs->focpos[j].x1 - meanr));
    if(explode_angle < 0.0) explode_angle = 2.0 * XMAP_PI + explode_angle;

    xs->focpos[j].x2 = xs->focpos[j].x1 + dist * cos(explode_angle);
    xs->focpos[j].y2 = xs->focpos[j].y1 + dist * sin(explode_angle);

    if(xs->focpos[j].x2 > aiy) xs->focpos[j].x2 = aiy;
    if(xs->focpos[j].y2 > xs->xdepth) xs->focpos[j].y2 = xs->xdepth;
    if(xs->focpos[j].x2 < 0.0) xs->focpos[j].x2 = 0.0;
    if(xs->focpos[j].y2 < 0.0) xs->focpos[j].y2 = 0.0;
    }
  return(1);
  }

/*************************************************/

void Dump_selXsource(xsec *xs, char *source_file, int append)
  {
  int i, k, nsave, a, astart, aend;  
  float minx, maxx, miny, maxy, dep, r, off;
  char acrd[76];
  FILE *inf;
  mpic *xm = xs->m;

  switch(append)
    {
    case 0:
      fprintf(stderr, "Saving Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "w")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;

    case 1:
      fprintf(stderr,"Appending Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "a")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;

    default:
      fprintf(stderr,"Saving Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "w")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;
    }

  if(xs->selXsource_org.x > xs->selXsource_spot.x)
    {
    minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
    maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
    }
  else
    {
    minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
    maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
    }

  if(xs->selXsource_org.y > xs->selXsource_spot.y)
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
    }
  else
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
    }

  printf("\n\n");

  /* SELECT SOURCES */

  nsave = 0;
  if(xm->src_flag == 1) astart = 0;
  else astart = 1;

  if(xm->more_src_flag == 1) aend = xm->max_more_src;
  else aend = 1;

  for(a = astart; a <= aend - 1; a++)
    {
    printf("\n-------------From Source File %s ---------------\n",
	   xm->sources[a].file_name);
    for(i = 0; i < xm->sources[a].numpoints; i++)
      {
         
 
      k = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
		      xm->sources[a].loc[i].y - xs->line.y1,
		      xm->sources[a].loc[i].z, xs->min_xsdepth,
		      xs->max_xsdepth, xs->x_left, xs->x_right, xs->max_xsfront,
		      xs->max_xsback, &r, &dep, &off);

              

      if(k == 1)
	{
	  {
	  if((r >= minx) && (r <= maxx) && (dep >= miny) && (dep  <=  maxy))
	    {
	    create_Acard( &xm->sources[a].acard[i], acrd);
	    fprintf(inf, "%s", acrd);
	    nsave++;
	    }
	  }
        }
      }
    }

  fprintf(stdout, "\n Number of points saved= %d\n", nsave);
  printf("\n");
  fclose(inf);
  }

/* ------------------------------------------------------------------ */

void SAVE_selXsource(Widget wij, xsec *xs, char *call_data)
  {
  int append = 0;

  Dump_selXsource(xs, xs->m->src_dump_file, append);
  }

/* ------------------------------------------------------------------ */

void APPEND_selXsource(Widget wij, xsec *xs, char *call_data)
  {
  int append = 1;

  Dump_selXsource(xs, xs->m->src_dump_file, append);
  }

/* ------------------------------------------------------------------ */

void xs_Key_s_lees(Widget wij, XKeyEvent *ev, String *params,
		   Cardinal *num_params)
  {
  xsec *xs;
  mpic *xm;
  int k, ix, iy, hsize, circle = 23040;
  float dep, r, off, phi, lam, fy, fx;
  Display *disp;
  Window wind;
  GC ggc;
  FILE *inf;
  ac_rec accard;

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  xm = xs->m;
  wind = XtWindow(wij);
  disp = XtDisplay(wij);
  ggc = xs->ggc;
  hsize = 4 * xm->SourceSize;

  if((inf = fopen(xm->src_dump_file, "r")) == NULL)
    {
    printf("Can't open special source %s ....try again\n", xm->src_dump_file);
    return;
    }

  /* READ SOURCES */

  while(readac(inf, &accard))
    {
    phi = accard.lat1 + accard.lat2 / 6000.0;
    lam = accard.lon1 + accard.lon2 / 6000.0;
    if(accard.EW[0] == 'W') lam *= -1;
    if(accard.NS[0] == 'S') phi *= -1;

    /* fprintf(stderr, "HI: %f %f  \n", phi,  lam); */

    geo2xy(xm, phi, lam, &fx, &fy);

    /* fprintf(stderr, "xyz: %f %f %f \n",fx,fy,accard.depth); */
    /*k = gproj(xs->line.x1, xs->line.y1, xs->line.x2, xs->line.y2, xs->dip,
      fx, fy, accard.depth, &r, &off, &dep); */

    k = In_Rect_Vol(xs->RM, fx - xs->line.x1, fy - xs->line.y1, accard.depth,
		    xs->min_xsdepth, xs->max_xsdepth, xs->x_left, xs->x_right,
		    xs->max_xsfront, xs->max_xsback, &r, &dep, &off);

    /* fprintf(stderr, "%f %f %f\n", r, off, dep); */

    /* if (dep <= xs->xdepth)
       {
       if (off < 0.0)
       off = -1.0 * off;
       if (off <= xs->xwidth && (r > 0.0 && r < xs->xdim)) { */

    if(k == 1)
      {
	{
	ix = user_to_pix_x(&xs->GR, (double)r) - (hsize / 2);
	iy = user_to_pix_y(&xs->GR, (double)dep) - (hsize / 2);

	/* fprintf(stderr, "%d %d\n", ix, iy); */

	if(strlen(accard.id) == 10)
	  XSetForeground(disp, ggc, xm->colors[XmapAppColor(13)]);
	else XSetForeground(disp, ggc, xm->colors[XmapAppColor(19)]);
	XFillArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

	XSetForeground(disp, ggc, xm->colors[XmapAppColor(21)]);
	XDrawArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

	XSetFont(disp, ggc, xs->fonts[0]);
	XSetForeground(disp, ggc, xm->colors[XmapAppColor(1)]);
	if(xm->sta_name_flag)
	  {
	  draw_just_text(disp, wind, ggc, ix, iy, accard.id, HJ_LEFT,
			 VJ_BASELINE);
	  fprintf(stderr, "%f bx %f bz  (%s) 0 0.5 0 0 bx 0  bz jshow\n", 
		  r, -dep,accard.id);
	  }

	XFlush(disp);
	}
      }
    }
  fclose(inf);
  }

/*************************************************************/


void XDump_Point_Info(Widget wij, xsec *xs, char *call_data)
  {
  int i, k, nsave, a, astart, aend, kount;  
  float dep, r, off, garb1;
  
  FILE *inf, *fopen();
  int kind;
  
  mpic *xm = xs->m;
   

if((inf = fopen("XSEC_POINTS_DUMP", "w")) == NULL)
	{
	printf("Can't open  XSEC_POINTS_DUMP....try again\n");
	return;
	}
  
 
  kind = 0;
  
  nsave = 0;
  if(xm->src_flag == 1) astart = 0;
  else astart = 1;

  if(xm->more_src_flag == 1) aend = xm->max_more_src;
  else aend = 1;

  for(a = astart; a <= aend - 1; a++)
     {
     printf("\n-------------From Source File %s ---------------\n",
	    xm->sources[a].file_name);
     for(i = 0; i < xm->sources[a].numpoints; i++)
	{
	if(xm->sources[a].onoff[i])
	   {
	     
 
	   k = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
			   xm->sources[a].loc[i].y - xs->line.y1,
			   xm->sources[a].loc[i].z, xs->min_xsdepth,
			   xs->max_xsdepth, xs->x_left, xs->x_right, xs->max_xsfront,
			   xs->max_xsback, &r, &dep, &off);
	   if(k == 1)
	      {	 
		 fprintf(inf, "%f %f %d\n", r, dep, kind);
		 nsave++;
	      }
	   }
	}
     }
/************/
  kind = 1;
  
  for(kount = 0; kount < xm->num_sta_files; kount++)
     {
      
     for(a = 0; a < xm->stations[kount].numpoints; a++)
	{
	switch(xs->sta_elevation_flag)
	   {
	   case 0:
	   garb1 = 0.0;
	   break;

	   case 1:
	   garb1 = (xm->stations[kount].sta[a].loc.z );
	   break;

	  case 2:
	    garb1 = (xm->stations[kount].sta[a].loc.z
		     - xm->stations[kount].mean_elev);
	    break;

          default:
	    garb1 = 0.0;
	    break;
	  }

	k = In_Rect_Vol(xs->RM, xm->stations[kount].sta[a].loc.x - xs->line.x1,
			xm->stations[kount].sta[a].loc.y - xs->line.y1, garb1,
			xs->min_xsdepth, xs->max_xsdepth,  xs->x_left, xs->x_right,
			xs->max_xsfront, xs->max_xsback, &r, &dep, &off);

	if(k == 1)
	   {
	   fprintf(inf, "%f %f %d\n", r, dep, kind);
	   nsave++;
	   }
	
	}
     }
  
  fprintf(stdout, "\n Number of points saved= %d\n", nsave);
  printf("\n");
  fclose(inf);
  }
