
/*notes from working at ICS
  /local/ucsb/hypo2ps/geom.c
  for algorithms from Algorithms in C
  by Robert Sedgewick */

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"

/* --- macros --- */

#define FLT_MIN		-1E+37
#define FLT_MAX		1E+37
#define SHRT_MIN	-32768
#define SHRT_MAX	32767
#define INT_MAX		2147483647
#define INT_MIN		-2147483648
#define LONG_MAX	2147483647
#define LONG_MIN	-2147483648
#define USHRT_MAX	65535
#define UINT_MAX	4294967295
#define ULONG_MAX	4294967295
#define ULONG_MIN	0
#define TIME_T_MAX	2147483647
#define TIME_T_MIN	0

/* --- typedefs --- */

typedef xy point;

typedef fxy fpoint;

typedef struct
  {
  fpoint p1, p2;
  } line;

/* --- functions --- */

int ccw(fpoint p0, fpoint p1, fpoint p2)
  {
  double dx1, dx2, dy1, dy2;

  dx1 = p1.x - p0.x;
  dy1 = p1.y - p0.y;
  dx2 = p2.x - p0.x;
  dy2 = p2.y - p0.y;

  if(dx1 * dy2 > dy1 * dx2) return(1);
  if(dx1 * dy2 < dy1 * dx2) return(-1);

  if((dx1 * dx2 < 0) || (dy1 * dy2 < 0)) return(-1);
  if((sqr(dx1) + sqr(dy1)) < (sqr(dx2) + sqr(dy2))) return(1);
  return(0);
  }

/************************************************************/

int intersect(line l1, line l2)
  {

  return(((ccw(l1.p1, l1.p2, l2.p1) * ccw(l1.p1, l1.p2, l2.p2)) <= 0)
	 && ((ccw(l2.p1, l2.p2, l1.p1) * ccw(l2.p1, l2.p2, l1.p2)) <= 0));
  }

/************************************************************/
/*** routine assumes that p[1] is the smallest x coord    ***/
/*** among all the points with the smallest y coordinate  ***/
/*** j is maintained as the last point known not to fall  ***/
/*** on the test line                                     ***/
/*** lp is a polygon line, lt is a test line              ***/

int inside(fpoint t, fpoint *p, int N)
  {
  int i, count = 0, j = 0;
  line lt, lp;

  p[0] = p[N];

  /* use the point to test to build a line with one end outside of array */

  lt.p1 = lt.p2 = t;
  lt.p2.x = FLT_MAX;  /* changed from INT_MAX because of overscaling in ccw! */

  /* test each point from 1 to N (0 is an anchor) */

  for(i = 1; i <= N; i++)
    {
    /* define first line as a point and see if it falls on test line */
    lp.p1 = lp.p2 = p[i];
    if(!intersect(lp, lt))
      {
      lp.p2 = p[j];
      j = i;
      /* check if last point not on line intersects */
      if(intersect(lp, lt)) count++;
      }
    }
  return(count & 1);
  }

