
#ifndef _contour_h
#define _contour_h

/*
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <pwd.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Shell.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/* --- macros --- */

#define MAX_GRID_DIM 200
#define GMT_CHUNK 2000


/* --- typedefs and structure definitions --- */

typedef struct
  {
  double x;
  double y;
  double z;
  double lat;
  double lon;

  } PT;

typedef struct
  {
  double xmin;
  double xmax;
  double ymin;
  double ymax;
  double zmin;
  double zmax;
  } MINMAX;

typedef struct
  {
  Widget wShell;	/* The top-level transient shell. */
  Widget wRLabel;	/* The R label. */
  Widget wREdit;	/* The R edit box. */
  Widget wILabel;	/* The I label. */
  Widget wIEdit;	/* The I edit box. */
  Widget wALabel;
  Widget wAEdit;
  Widget wLLabel;
  Widget wLEdit;
  Widget wNLabel;
  Widget wNEdit;
  Widget wTLabel;
  Widget wTEdit;
  Widget wXLabel;
  Widget wXEdit;
  Widget wFLabel;
  Widget wFEdit;
  Widget wSLabel;
  Widget wSEdit;
  Widget wZLabel;
  Widget wZEdit;
  Widget wSet;		/* The "Set" command button. */
  Widget wCancel;	/* The "Cancel" command button. */
  struct RETURN_VEC *cont_struct;
  struct SURF_GRD *surf_grd;
  MINMAX minmax;
  int MinCol, MaxCol, Which_Pal;
  PT *datapt;
  int length_data;
  char R[500];
  char I[500];
  double A;
  double L;
  double N;
  double T;
  double X;
  char contfile[500];
  double S;
  double Z;
  } CONT_PARMS;

struct VEC_REC
  {
  int length;
  float *x_vec;
  float *y_vec;
  };

/* return contour lines */

struct RETURN_VEC
  {
  float *cont_level;
  int *number_sections;
  struct VEC_REC *vec;
  };

struct SURF_GRD
  {
  double xmin;
  double xmax;
  double ymin;
  double ymax;
  double xinc;
  double yinc;
  int nx;
  int ny;
  float val[MAX_GRID_DIM*MAX_GRID_DIM];
  };

/* --- global variable exports --- */

extern int MAX_PTS, npoints, nx, ny, mx, my, ij_sw_corner, ij_se_corner,
  ij_nw_corner, ij_ne_corner, block_nx, block_ny, max_iterations,
  total_iterations, grid, old_grid, grid_east, n_fact, factors[32],
  long_verbose, n_empty, offset[25][12];

extern char *iu, mode_type[2];

extern float *u, *v2;

extern double low_limit, high_limit, xmin, xmax, ymin, ymax, xinc, yinc,
  xstep, ystep, grid_xinc, grid_yinc, r_xinc, r_yinc, r_grid_xinc,
  r_grid_yinc, converge_limit, tension, boundary_tension, interior_tension,
  a0_const_1, a0_const_2, e_2, e_m2, one_plus_e2, eps_p2, eps_m2,
  two_plus_ep2, two_plus_em2, x_edge_const, y_edge_const, epsilon, z_scale,
  r_z_scale, plane_c0, plane_c1, plane_c2, small, coeff[2][12], relax_old,
  relax_new;

extern struct BRIGGS *briggs;

#endif /* _contour_h */
