
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <stdlib.h>
#include <math.h>

/* --- local headers --- */

#include "jutil.h"

/* --- functions --- */

/*
 * csorta does incore bubble sorting of input array into
 * output array.  bufout may overwrite bufin and then only one
 * array is used in addition to the index array. In this case,
 * the input array is lost in its original form. Sort is always
 * into ascending order.
 *
 * ibufdx is auxiliary pointer array, which is returned with the
 * output sorted array. The values in ibufdx are the positions in
 * the original sequence (bufin) of the current values of bufout.
 * i.e., if ibufdx(5) currently stores the value 27, this means that
 * the current value in bufout(5) was originally stored in the array
 * location bufin(27) prior to the call to csorta.
 */

void csorta(float *bufin, int *ibufdx, float *bufout, int n)
  {
  int i, index, itemp;
  float temp;

  for(i = 0; i < n; i++)
    {
    ibufdx[i] = i;
    bufout[(i)] = bufin[(i)];
    }

  if(n <= 1) return;

  for(;;)
    {
    index = 0;

    for(i = 0; i < n - 1; i++)
      {
      if(bufout[(i)] <= bufout[(i + 1)]) continue;
      temp = bufout[(i + 1)];
      bufout[(i + 1)] = bufout[(i)];
      bufout[(i)] = temp;
      itemp = ibufdx[(i + 1)];
      ibufdx[(i + 1)] = ibufdx[(i)];
      ibufdx[(i)] = itemp;
      index++;
      }
    if(index == 0) return;
    }
  }

/* Same as above but only returns the index. */

void cindex(float *bufin, int *ibufdx, int n)
  {
  int i, index, itemp;
  float temp, *bufout;

  bufout = alloc_fvec(0, n);

  for(i = 0; i < n; i++)
    {
    ibufdx[i] = i;
    bufout[(i)] = bufin[(i)];
    }

  if(n <= 1)
    {
    free_fvec(bufout, 0, n);
    return;
    }

  for(;;)
    {
    index = 0;

    for(i = 0; i < n - 1; i++)
      {
      if(bufout[(i)] <= bufout[(i + 1)]) continue;
      temp = bufout[(i + 1)];
      bufout[(i + 1)] = bufout[(i)];
      bufout[(i)] = temp;
      itemp = ibufdx[(i + 1)];
      ibufdx[(i + 1)] = ibufdx[(i)];
      ibufdx[(i)] = itemp;
      index++;
      }
    if(index == 0)
      {
      free_fvec(bufout, 0 , n);
      return;
      }
    }
  }

/* Double precision vector version */

void dsorta(double *bufin, int *ibufdx, double *bufout, int n)
  {
  int i, index, itemp;
  double temp;

  for(i = 0; i < n; i++)
    {
    ibufdx[i] = i;
    bufout[(i)] = bufin[(i)];
    }

  if(n <= 1) return;

  for(;;)
    {
    index = 0;

    for(i = 0; i < n - 1; i++)
      {
      if (bufout[(i)] <= bufout[(i + 1)]) continue;
      temp = bufout[(i + 1)];
      bufout[(i + 1)] = bufout[(i)];
      bufout[(i)] = temp;
      itemp = ibufdx[(i + 1)];
      ibufdx[(i + 1)] = ibufdx[(i)];
      ibufdx[(i)] = itemp;
      index++;
      }
    if(index == 0) return;
    }
  }

