/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"

/* --- macros --- */

#define JM_ADD 0
#define FREE_BOY char*

/* --- functions --- */

float *alloc_fvec(long first, long last)
  {
  float *a;

  a = XmapNewArray(float, (last - first + 1 + JM_ADD));
  return(a - first + JM_ADD);
  }

double *alloc_dvec(long first, long last)
  {
  double *a;

  a = XmapNewArray(double, (last - first + 1 + JM_ADD));
  return(a - first + JM_ADD);
  }

int *alloc_ivec(long first, long last)
  {
  int *a;

  a = XmapNewArray(int, (last - first + 1 + JM_ADD));
  return(a - first + JM_ADD);
  }

long *alloc_lvec(long first, long last)
  {
  long *a;

  a = XmapNewArray(long, (last - first + 1 + JM_ADD));
  return(a - first + JM_ADD);
  }

/* allocate a float matrix with subscript range
   m[row_first..row_last][col_first..col_last] */

float **alloc_fmat(long row_first, long row_last, long col_first,
		   long col_last)
  {
  long i, nrow = row_last - row_first + 1, ncol = col_last - col_first + 1;
  float **m;

  /* allocate pointers to rows */

  m = XmapNewArray(float *, (nrow + JM_ADD));
  m += JM_ADD;
  m -= row_first;

  /* allocate rows and set pointers to them */

  m[row_first] = XmapNewArray(float, (nrow * ncol + JM_ADD));
  m[row_first] += JM_ADD;
  m[row_first] -= col_first;

  for(i = row_first + 1; i <= row_last; i++) m[i] = m[i - 1] + ncol;

  /* return pointer to array of pointers to rows */

  return(m);
  }

void free_fmat(float **m, long row_first, long row_last, long col_first,
	       long col_last)
  {

  XmapFree(m[row_first] + col_first - JM_ADD);
  XmapFree(m + row_first - JM_ADD);
  }

/***********************************/
/* allocate a double   matrix with subscript range
   m[row_first..row_last][col_first..col_last] */

double  **alloc_dmat(long row_first, long row_last, long col_first,
		   long col_last)
  {
  long i, nrow = row_last - row_first + 1, ncol = col_last - col_first + 1;
  double **m;

  /* allocate pointers to rows */

  m = XmapNewArray(double *, (nrow + JM_ADD));
  m += JM_ADD;
  m -= row_first;

  /* allocate rows and set pointers to them */

  m[row_first] = XmapNewArray(double, (nrow * ncol + JM_ADD));
  m[row_first] += JM_ADD;
  m[row_first] -= col_first;

  for(i = row_first + 1; i <= row_last; i++) m[i] = m[i - 1] + ncol;

  /* return pointer to array of pointers to rows */

  return(m);
  }

void free_dmat(double **m, long row_first, long row_last, long col_first,
	       long col_last)
  {

  XmapFree(m[row_first] + col_first - JM_ADD);
  XmapFree(m + row_first - JM_ADD);
  }



/* allocate a int  matrix with subscript range
   m[row_first..row_last][col_first..col_last] */

int  **alloc_imat(long row_first, long row_last, long col_first,
		   long col_last)
  {
  long i, nrow = row_last - row_first + 1, ncol = col_last - col_first + 1;
  int  **m;

  /* allocate pointers to rows */

  m = XmapNewArray(int  *, (nrow + JM_ADD));
  m += JM_ADD;
  m -= row_first;

  /* allocate rows and set pointers to them */

  m[row_first] = XmapNewArray(int, (nrow * ncol + JM_ADD));
  m[row_first] += JM_ADD;
  m[row_first] -= col_first;

  for(i = row_first + 1; i <= row_last; i++) m[i] = m[i - 1] + ncol;

  /* return pointer to array of pointers to rows */

  return(m);
  }

void free_imat(int **m, long row_first, long row_last, long col_first,
	       long col_last)
  {

  XmapFree(m[row_first] + col_first - JM_ADD);
  XmapFree(m + row_first - JM_ADD);
  }

void free_fvec(float *a, long first, long last)
  {

  XmapFree(a + first - JM_ADD);
  }
void free_dvec(double *a, long first, long last)
  {

  XmapFree(a + first - JM_ADD);
  }

void free_ivec(int *a, long first, long last)
  {

  XmapFree(a + first - JM_ADD);
  }

void free_lvec(long *a, long first, long last)
  {

  XmapFree(a + first - JM_ADD);
  }

/* ############################################# */
/* ############################################# */
/* ############################################# */
/* ############################################# */

/** FUNC DEF  **/ char  **alloc_cmat(int nrl, int nrh, int ncl, int nch)
/* allocate a float matrix with subscript range m[nrl..nrh][ncl..nch] */
{
        long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
        char  **m;

        /* allocate pointers to rows */
        m=(char **) malloc((size_t)((nrow+JM_ADD)*sizeof(char*)));
        if (!m) fprintf(stderr, "allocation failure 1 in matrix()\n");
        m += JM_ADD;
        m -= nrl;

        /* allocate rows and set pointers to them */
        m[nrl]=(char *) malloc((size_t)((nrow*ncol+JM_ADD)*sizeof(char)));
        if (!m[nrl]) fprintf(stderr, "allocation failure 2 in cmatrix()\n");
        m[nrl] += JM_ADD;
        m[nrl] -= ncl;

        for(i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

        /* return pointer to array of pointers to rows */
        return m;
}
/** FUNC DEF  **/ void free_cmat(char **m, int row_first, int row_last, int col_first, int col_last)
{
        free((FREE_BOY) (m[row_first]+col_first-JM_ADD));
        free((FREE_BOY) (m+row_first-JM_ADD));
}




