
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"

/* --- function prototypes --- */

void switch_foc(mpic *m, int kfoc);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);

int user_to_pix_x(JGRAPH *gr, double x);
int user_to_pix_y(JGRAPH *gr, double y);

/* --- functions --- */

void explode_selfoc(Widget wij, XButtonEvent *ev, String *params,
		    Cardinal *num_params)
  {
    mpic *pf;
  int i, j, k, kfoc, minx, maxx, miny, maxy, num, ixpoint, iypoint, *inds, *knds;
  float px, py, dismax, dis, phi, lam, minpx, maxpx, minpy, maxpy, meanX = 0,
    meanY = 0, *pointx, *pointy;

  XtVaGetValues(wij, XtNdata, &pf, NULL);


    if(pf->picsourcemove_flag) 
      {
      XSetClipMask(XtDisplay(wij), pf->ggc, None);

      if(pf->picsource_org.x > pf->picsource_spot.x)
	{
	minx = pf->picsource_spot.x;
	maxx = pf->picsource_org.x;
	}
      else
	{
	minx = pf->picsource_org.x;
	maxx = pf->picsource_spot.x;
	}

      if(pf->picsource_org.y > pf->picsource_spot.y)
	{
	miny = pf->picsource_spot.y;
	maxy = pf->picsource_org.y;
	}
      else
	{
	miny = pf->picsource_org.y;
	maxy = pf->picsource_spot.y;
	}
      }
    
    else
      { 
	return;
      }
    
    fprintf(stderr,"minx=%d maxx=%d miny=%d maxy=%d\n", minx, maxx, miny, maxy);
    

    j = k = 0;

    for(kfoc = 0; kfoc < pf->num_focm_files; kfoc++)
      {
	k += pf->focm[kfoc].numpoints;
      }
  
    inds =   XmapNewArray(int, k );
    knds =   XmapNewArray(int, k );
    pointx = XmapNewArray(float, k );
    pointy = XmapNewArray(float, k );

    for(kfoc = 0; kfoc < pf->num_focm_files; kfoc++)
      {

      
	for(i = 0; i < pf->focm[kfoc].numpoints; i++)
	  {
	    phi = pf->focm[kfoc].focs[i].loc.x;
	    lam = pf->focm[kfoc].focs[i].loc.y;
	    geo2xy(pf, phi, lam, &px, &py);

	    ixpoint = user_to_pix_x(&pf->gr, (double)px);
	    iypoint = user_to_pix_y(&pf->gr, (double)py);

	    /* fprintf(stderr,"%d %f %f %d %d\n", i, px, py, ixpoint, iypoint); */
	
   
	    if((ixpoint >= minx) && (ixpoint <=  maxx) && (iypoint >=  miny)
	       && (iypoint <=  maxy))
	      {

		knds[j] = kfoc;
		inds[j] = i;
		meanX += px;
		meanY += py;
		pointx[j] = px;
		pointy[j] = py;

		/* printf("%d %f %f \n",j,px,py); */
		j++;
	      }
	  }
      }
  
    num = j;

    meanX /= (float)num, meanY /= (float)num;

    maxpx = minpx = pointx[0];
    maxpy = minpy = pointy[0];

    printf("total=%d meanx=%f meany=%f \n", num, meanX, meanY);

    for(i = 0; i < num; i++)
      {
	minpx = min2(minpx, pointx[i]);
	maxpx = max2(maxpx, pointx[i]);
	minpy = min2(minpy, pointy[i]);
	maxpy = max2(maxpy, pointy[i]);
      }

    dismax = sqrt((minpx - maxpx) * (minpx - maxpx) + (minpy - maxpy)
		  * (minpy - maxpy));

    for(i = 0; i < num; i++)
      {
	dis = sqrt(sqr(meanX - pointx[i]) + sqr(meanY - pointy[i]));

	pf->focm[knds[i]].focs[inds[i]].explode_dist = dismax + dis;
	pf->focm[knds[i]].focs[inds[i]].explode_angle = atan2((pointy[i] - meanY),
							      (pointx[i] - meanX));

	pf->focm[knds[i]].focs[inds[i]].explode_x =
	  (pointx[i] + pf->focm[knds[i]].focs[inds[i]].explode_dist
	   * cos(pf->focm[knds[i]].focs[inds[i]].explode_angle));
	pf->focm[knds[i]].focs[inds[i]].explode_y =
	  (pointy[i] + pf->focm[knds[i]].focs[inds[i]].explode_dist
	   * sin(pf->focm[knds[i]].focs[inds[i]].explode_angle));



      if(pf->focm[knds[i]].focs[inds[i]].explode_x > pf->origin.maxx)
        pf->focm[knds[i]].focs[inds[i]].explode_x = pf->origin.maxx;
      if(pf->focm[knds[i]].focs[inds[i]].explode_y > pf->origin.maxy)
        pf->focm[knds[i]].focs[inds[i]].explode_y = pf->origin.maxy;
      if(pf->focm[knds[i]].focs[inds[i]].explode_x < 0.0)
        pf->focm[knds[i]].focs[inds[i]].explode_x = 0.0;
      if(pf->focm[knds[i]].focs[inds[i]].explode_y < 0.0)
        pf->focm[knds[i]].focs[inds[i]].explode_y = 0.0;







      }
 
    
    
    XmapFree(knds);
    XmapFree(inds);
    XmapFree(pointx);
    XmapFree(pointy);
  }


/* ------------------------------------------------------------------ */

void Switch_selfoc(Widget wij, XButtonEvent *ev, String *params,
		   Cardinal *num_params)
  {
  mpic *pf;
  int i, j, k, kfoc, minx, maxx, miny, maxy, ixpoint, iypoint;
  float px, py, phi, lam;

  XtVaGetValues(wij, XtNdata, &pf, NULL);
  if(pf->picsource_org.x > pf->picsource_spot.x)
    {
    minx = pf->picsource_spot.x;
    maxx = pf->picsource_org.x;
    }
  else
    {
    minx = pf->picsource_org.x;
    maxx = pf->picsource_spot.x;
    }

  if(pf->picsource_org.y > pf->picsource_spot.y)
    {
    miny = pf->picsource_spot.y;
    maxy = pf->picsource_org.y;
    }
  else
    {
    miny = pf->picsource_org.y;
    maxy = pf->picsource_spot.y;
    }

  j = k = 0;

  fprintf(stderr, "minx=%d maxx=%d miny=%d maxy=%d\n", minx, maxx, miny, maxy);

  for(kfoc = 0; kfoc < pf->num_focm_files; kfoc++)
    {
    for(i = 0; i < pf->focm[kfoc].numpoints; i++)
      {
      phi = pf->focm[kfoc].focs[i].loc.x;
      lam = pf->focm[kfoc].focs[i].loc.y;
      geo2xy(pf, phi, lam, &px, &py);

      ixpoint = user_to_pix_x(&pf->gr, (double)px);
      iypoint = user_to_pix_y(&pf->gr, (double)py);

      if((ixpoint >= minx) && (ixpoint <= maxx) && (iypoint >= miny)
	 && (iypoint <= maxy))
	{
	pf->focal_selection = i;
	switch_foc(pf, kfoc);
	k++;
	}
      }
    }
  fprintf(stderr, "Switched %d focal mechanisms\n", k);
  }


