
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "contour.h"

/* --- function prototypes --- */


int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
void remove_blanks(char *ident);

/* --- global variables --- */

float XORG, YORG;

/* --- functions --- */

void dump_contour_file(char dump_file[50], mpic *mplot)
  {
  int j, k, m, n, i1, i2, kk, style, col;
  float phi, lam, maxx, maxy, x0, y0, phimin, phimax, lammin, lammax;
  char name[20], ch[10], code;
  struct RETURN_VEC *C_r;
  FILE *inf;

  fprintf(stderr, "dumping contours into file %s\n", dump_file);

  if((inf = fopen(dump_file, "w")) == NULL)
    {
    printf("Can't open postscript file...continuing\n");
    return;
    }

  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  if(mplot->plot_cont_flag == 1)
    {
    C_r = mplot->contParms.cont_struct;
    n = kk = 0;

    for(k = 0; C_r->number_sections[k] != 0; k++)
      {
      for(j = 0; j < C_r->number_sections[k]; j++)
	{
	i2 = C_r->vec[kk].length;
	i1 = (((mplot->MaxColor - mplot->MinColor) *
	       (C_r->cont_level[k] - mplot->contParms.minmax.zmin)
	       / (mplot->contParms.minmax.zmax - mplot->contParms.minmax.zmin))
	      + mplot->MinColor);

	fprintf(stderr, "k=%d j=%d %d %d %f\n", k, j, i2, i1,
		C_r->cont_level[k]);

	/* label =  C_r->cont_level[k] */
	lammin = phimin = 9000;
	lammax = phimax = -9000;

	for(m = 0; m < i2; m++)
	  {
	  xy2geo(mplot, &phi, &lam, C_r->vec[kk].x_vec[m],
		 C_r->vec[kk].y_vec[m]);

	  phimin = min2(phimin, phi);
	  phimax = max2(phimax, phi);
	  lammin = min2(lammin, lam);
	  lammax = max2(lammax, lam);

	  /* fprintf(inf, " %f bx %f bz lineto \n",
	     ps_kmx(C_r->vec[kk].x_vec[m], x0),
	     ps_kmy(C_r->vec[kk].y_vec[m], y0)); */
	  }
	fprintf(stderr, "name =");

	style = 2, col = i1, code = 'o';

	strcpy(name, "C");

	if( (C_r->cont_level[k]<10)  )
	{
	   sprintf(ch, "%8.5f", C_r->cont_level[k]);
	}

	if( (C_r->cont_level[k]>10) && (C_r->cont_level[k]<=100)  )
	{
	   sprintf(ch, "%6f", C_r->cont_level[k]);
	}

	if( (C_r->cont_level[k]>100) && (C_r->cont_level[k]<=1000) )
	{
	   sprintf(ch, "%5.0f", C_r->cont_level[k]);
	}

	if( (C_r->cont_level[k]>1000) &&  (C_r->cont_level[k]<=10000) )
	{
	   sprintf(ch, "%6.0f", C_r->cont_level[k]);
	}




	strcat(name, ch);
	remove_blanks(name);
	fprintf(stderr, "%s\n", name);
	fprintf(inf, "> %s %d %d %d %c %f %f %f %f\n", name, i2, style, col,
		code, phimin, phimax, lammin, lammax);

	for(m = 0; m < i2; m++)
	  {
	  xy2geo(mplot, &phi, &lam, C_r->vec[kk].x_vec[m],
		 C_r->vec[kk].y_vec[m]);
	  fprintf(inf, " %f  %f  \n", phi, lam);
	  }
	kk++;
	}
      }
    n++;
    }

  fprintf(stderr, "dumped kk=%d n=%d strokes\n", kk, n);
  }
