
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <stdio.h>
#include <math.h>
#include <string.h>

/* --- local headers --- */

#include "primitive.h"

/* --- global variables --- */

static int numtheta = 36;
static double costheta[36] =
  { 1.0000000000, 0.9848077522, 0.9396926175, 0.8660253966, 0.7660444308,
    0.6427875913, 0.4999999751, 0.3420201117, 0.1736481398, -0.0000000432,
    -0.1736482249, -0.3420201929, -0.5000000499, -0.6427876575, -0.7660444863,
    -0.8660254398, -0.9396926471, -0.9848077672, -1.0000000000, -0.9848077372,
    -0.9396925879, -0.8660253534, -0.7660443752, -0.6427875251, -0.4999999002,
    -0.3420200305, -0.1736480547, 0.0000001296, 0.1736483100, 0.3420202741,
    0.5000001247, 0.6427877237, 0.7660445419, 0.8660254830, 0.9396926766,
    0.9848077822 };

static double sintheta[36] =
  { 0.0000000000, 0.1736481824, 0.3420201523, 0.5000000125, 0.6427876244,
    0.7660444585, 0.8660254182, 0.9396926323, 0.9848077597, 1.0000000000,
    0.9848077447, 0.9396926027, 0.8660253750, 0.7660444030, 0.6427875582,
    0.4999999376, 0.3420200711, 0.1736480973, -0.0000000864, -0.1736482675,
    -0.3420202335, -0.5000000873, -0.6427876906, -0.7660445141, -0.8660254614,
    -0.9396926618, -0.9848077747, -1.0000000000, -0.9848077297, -0.9396925732,
    -0.8660253318, -0.7660443475, -0.6427874920, -0.4999998628, -0.3420199899,
    -0.1736480122 };

/* --- functions --- */

void printvec(float *vec, int ndim)
  {
  int i;
  for(i = 0; i < ndim; i++) fprintf(stderr,"%f ", vec[i]);
  fputc('\n', stderr);
  }

int eigvct_(float *a, int *n, int *nm, float *wrk1, float *o, float *lmbda,
	    int *ierr);

void Rot_Vec(float rmat[3][3], float *in, float *out)
  {
  int i, j;

  for(i = 0; i < 3; i++)
    {
    out[i] = 0.0;

    for (j = 0; j < 3; j++)
      {
      out[i] += rmat[j][i] * in[j];
      }
    }
  }

double nrmliz(float in[3], float out[3])
  {
  double nv = sqrt((double)(in[0] * in[0] + in[1] * in[1] + in[2] * in[2]));

  out[0] = in[0] / nv;
  out[1] = in[1] / nv;
  out[2] = in[2] / nv;

  return(nv);
  }

void mul_mat(float rotmat[3][3], float rotleft[3][3],  float rotright[3][3])
  {
  int i, j, k;

  /* combine these two rotations by matrix multiplication
   * rotmat = rotleft %*% rotright
   * so that the rotright is applied first and then  rotleft rotation
   */

  for(i = 0; i < 3; i++)
    {
    for(j = 0; j < 3; j++)
      {
      rotmat[i][j] = 0.0;
      for(k = 0; k < 3; k++)
	{
	rotmat[i][j] += rotleft[i][k] * rotright[k][j];
	}
      }
    }
  }

void tr_mul_mat(float rotmat[3][3], float rotleft[3][3],  float rotright[3][3])
  {
  int i, j, k;

  /* combine these two rotations by matrix multiplication
   * rotmat = rotleft %*% rotright
   * so that the rotright is applied first and then  rotleft rotation
   */

  for(i = 0; i < 3; i++)
    {
    for(j = 0; j < 3; j++)
      {
      rotmat[i][j] = 0.0;
      for(k = 0; k < 3; k++)
	{
	rotmat[i][j] += rotleft[k][i] * rotright[k][j];
	}
      }
    }
  }

void trans_mat(float inmat[3][3], float outmat[3][3])
  {
  int i, j;

  for(i = 0; i < 3; i++)
    {
    for(j = 0; j < 3; j++)
      {
      outmat[i][j] = inmat[j][i];
      }
    }
  }

void zero_vec(float *vec, int ndim)
  {
  int i;

  for(i = 0; i < ndim; i++) vec[i] = 0;
  }

void vec_2_mat(float mat[3][3], float *vec, int ndim)
  {
  int i, j, m = 0;

  for(j = 0; j < ndim; j++)
    for(i = 0; i < ndim; i++)
      mat[i][j]= vec[m++];
  }

void diag_mat(float mat[3][3], float *vec, int ndim)
  {
  int i, j;

  for(j = 0; j < ndim; j++)
    for(i = 0; i < ndim; i++)
      mat[i][j] = ((i == j) ? vec[j] : 0.0);
  }

void jrot(float r[3][3], float vec[3])
  {
  double d, nv, v[3];

  /* normalize vector  */

  nv = sqrt((double)(vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2]));
  v[0] = vec[0] / nv;
  v[1] = vec[1] / nv;
  v[2] = vec[2] / nv;

  d = sqrt((double)(v[1] * v[1] + v[2] * v[2]));

  if(d == 0.0)
    {
    r[0][0] = 0;
    r[0][1] = 0;
    r[0][2] = 1;
    r[1][0] = 0;
    r[1][1] = 1;
    r[1][2] = 0;
    r[2][0] = -1;
    r[2][1] = 0;
    r[2][2] = 0;
    }
  else
    {
    r[0][0] = d;
    r[0][1] = 0;
    r[0][2] = v[0];
    r[1][0] = (-v[0] * v[1] / d);
    r[1][1] = (v[2] / d);
    r[1][2] = v[1];
    r[2][0] = (-v[2] * v[0] / d);
    r[2][1] = -v[1] / d;
    r[2][2] = v[2];
    }
  }

void fixlips(int n, float elip[][2], float zee[], int *nout)
  {
  int i, k, m, icase;
  float temp[360][3]; 

  /* there are four cases
   *  1) +++++++++++--------------+++++++++   + wrap-around
   *  2) ++++++++++++++++------------------   separate
   *  3) ---------------+++++++++++++++++++   separate
   *  4) ----------++++++++++++++----------  - wrap-araound
   */

  if((zee[0] < 0.0) && (zee[n-1] < 0.0)) icase = 4;
  if((zee[0] < 0.0) && (zee[n-1] >= 0.0)) icase = 3;
  if((zee[0] >= 0.0) && (zee[n-1] >= 0.0)) icase = 1;
  if((zee[0] >= 0.0) && (zee[n-1] < 0.0)) icase = 2;

  m = 0;

  switch(icase)
    {
    case 2:
      for(i = 0; i < n; i++)
	if(zee[i] >= 0.0) m++;
      *nout = m;
      break;

    case 1:
      for(i = n - 1; i > 0; i--)
	if(zee[i] < 0.0) { k = i; break; }

      for(i = k + 1; i < n; i++)
	{
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}
      for(i = 0; i < k + 1; i++)
	{
	if(zee[i] < 0.0) { k = i; break; }
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}
      for(i = k; i < n ; i++)
	{
	if(zee[i] > 0.0) break;
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}

      m = 0;
      for(i = 0; i < n; i++)
	{
	elip[i][0] = temp[i][0];
	elip[i][1] = temp[i][1];
	zee[i] = temp[i][2];
	if(zee[i] >= 0.0) m++;
	}
      *nout = m;
      break;

    case 3:
      for(i = 0; i < n; i++)
	if(zee[i] > 0.0) { k = i; break; }

      for(i = k; i < n; i++)
	{
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}
      for(i = 0; i < k; i++)
	{
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}

      for(i = 0; i < n; i++)
	{
	elip[i][0] = temp[i][0];
	elip[i][1] = temp[i][1];
	zee[i] = temp[i][2];
	if(zee[i] >= 0.0) m++;
	}

      *nout = m;
     break;

    case 4:
      for(i = 0; i < n ; i++)
	if(zee[i] > 0.0) { k = i; break; }

      for (i = k; i < n ; i++)
	{
	if(zee[i] < 0.0) { k = i; break; }
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}
      for(i = k; i < n; i++)
	{
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}
      for(i = 0; i < n; i++)
	{
	if(zee[i] > 0.0) break;
	temp[m][0] = elip[i][0];
	temp[m][1] = elip[i][1];
	temp[m][2] = zee[i];
	m++;
	}

      for (i = 0; i < n; i++)
	{
	elip[i][0]=temp[i][0];
	elip[i][1]=temp[i][1];
	zee[i]=temp[i][2];
	if(zee[i] >= 0.0) m++;
	}
      *nout=m;
      break;
    }
  }

void eig22(float A[3][3], float *lam1, float *lam2, float *phi, float v1[2],
	   float v2[2])
  {
  double x1, x2, xn;

  if(A[0][1] == 0.0)
    {
    *lam1 = A[0][0];
    *lam2 = A[1][1];
    *phi = 0.0;
    v1[0] = 1;
    v1[1] = 0;
    v2[0]=0;
    v2[1]=1;
    }
  else
    {
    *lam1 = (((A[0][0] + A[1][1])
	      + sqrt(A[0][0] * A[0][0] + A[1][1] * A[1][1] - 2 * A[0][0]
		     * A[1][1] + 4 * A[0][1] * A[0][1])) / 2);
    *lam2 = (((A[0][0] + A[1][1])
	      - sqrt(A[0][0] * A[0][0] + A[1][1] * A[1][1] - 2 * A[0][0]
		     * A[1][1] + 4 * A[0][1] * A[0][1])) / 2);

    x2 = 1;

    /*  I don't see why the sign must be switched here...*/
    x1 = (A[1][1] - *lam1) / A[0][1];

    xn = sqrt(x1 * x1 + x2 * x2);
    v1[0] = x1 / xn;
    v1[1] = x2 / xn;

    v2[0] = v1[1];
    v2[1] = -v1[0];

    *phi = atan2((double)v1[1], (double)v1[0]);
    }
  }

void get_perim(float dir[3], float axis[3], float elip[][2], int *n)
  {
  int ndim = 3, j, k;
  float a, b, x, y, z,
    newplan[3], v1[2], v2[2], lam1, lam2,
    smat[3][3], tmat[3][3], lmat[3][3], M[3][3], Mp[3][3];
  double sina, cosa;


    if( (axis[0]==0.0) || (axis[1]==0.0) || (axis[2]==0.0) )
       {
       *n=0;
       return;
       }

  jrot(M, dir);

  
  newplan[0] = dir[0] / (axis[0] * axis[0]);
  newplan[1] = dir[1] / (axis[1] * axis[1]);
  newplan[2] = dir[2] / (axis[2] * axis[2]);

  jrot(Mp, newplan);
  diag_mat(smat, axis, ndim);
  mul_mat(tmat, smat, Mp);
  tr_mul_mat(lmat, Mp, tmat);
  trans_mat(M, tmat);

  /*************************/

  eig22(lmat, &lam1, &lam2, &a, v1, v2);

#if 0
       
  /*
     fprintf(stderr,"angle = %f          lam1=%f    lam2=%f\n",
     a * RAD2DEG, lam1, lam2);
     fprintf(stderr,"v1 = %f %f    v2 = %f %f\n", v1[0],v1[1], v2[0], v2[1]);
   */
  zero_vec(olam2,nd2);
  zero_vec(o,nd2*nd2);

  ina[0] = lmat[0][0];
  ina[1] = lmat[0][1];
  ina[2] = lmat[1][0];
  ina[3] = lmat[1][1];

  fprintf(stderr,"ina:");
  printvec(ina, nd2*nd2);

  eigvct_( ina , &nd2, &nd2, wrk1, o, olam2 , &ierr);

  fprintf(stderr,"2D eigenvalues : ");
  printvec(olam2, nd2);
  vec_2_mat(bmat, o , nd2);
  fprintf(stderr,"2D eigenvectors:\n");
  fprintf(stderr,"%f %f \n %f %f \n", o[0],o[1],o[2],o[3] );
  fprintf(stderr,"bmat:\n %f %f \n %f %f \n", bmat[0][0],bmat[0][1],
	  bmat[1][0],bmat[1][1] );

  /* STDERR_3Mat(bmat) ; */

  rx = v1[0];
  ry = v1[1];

  a = atan2(ry, rx);
  fprintf(stderr,"rx=%f ry=%f   angle(v1)= %f\n", rx, ry, a*RAD2DEG);

  rx = bmat[1][0];
  ry = bmat[1][1];

  a = atan2(ry, rx);
  fprintf(stderr,"rx=%f ry=%f   angle = %f\n",  rx, ry, a*RAD2DEG);
#endif

  b = 0, k = 0, cosa = cos(a), sina = sin(a);

  /*		for (j = 0; j < 360; j += 10) {
		theta = j * DEG2RAD;
		x =  lam1*cos(theta);
		y =  lam2*sin(theta);
		*/

  for (j = 0; j < numtheta; j++) 
    {
    x = lam1 * costheta[j];
    y = lam2 * sintheta[j];

    elip[k][0] = x * cosa + y * sina;
    elip[k][1] = -x * sina + y * cosa;
    z = 0.0;
    /*fprintf(stderr,"%f %f %f \n", elip[k][0],elip[k][1], z);*/

    /* rotation back to principal directions  */
    x = Mp[0][0] * elip[k][0] + Mp[0][1] * elip[k][1] + Mp[0][2] * z;
    y = Mp[1][0] * elip[k][0] + Mp[1][1] * elip[k][1] + Mp[1][2] * z;
    z = Mp[2][0] * elip[k][0] + Mp[2][1] * elip[k][1] + Mp[2][2] * z;
    elip[k][0] = x;
    elip[k][1] = y;

    /* rotation to view direction  */
    x = tmat[0][0] * elip[k][0] + tmat[0][1] * elip[k][1] + tmat[0][2] * z;
    y = tmat[1][0] * elip[k][0] + tmat[1][1] * elip[k][1] + tmat[1][2] * z;
    /* z = tmat[2][0] * elip[k][0] + tmat[2][1] * elip[k][1] + tmat[2][2] * z;*/
    elip[k][0] = x;
    elip[k][1] = y;
    z = 0.0;
    k++;    
    }

  elip[k][0] = elip[0][0];
  elip[k][1] = elip[0][1];

  *n = ++k;
  }

