
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "focal_param.h"

/* --- function prototypes --- */

Boolean CopyToFocalWindow(FOCAL_PARMS *pfocalParms);
Boolean CopyFromFocalWindow(FOCAL_PARMS *pfocalParms);
void init_focalParms(mpic *mp);
void focal_new_parms(mpic *mplot);
void SetWidgetInt(Widget w, String attr, int i);
void focal_selection(mpic *mplot);
char *GetWidgetString(Widget w, String attr);
float GetWidgetStringAsFloat(Widget w, String attr);
void SetWidgetStringToFloat(Widget w, String attr, float fl);
void SetWidgetStringToInt(Widget w,String attr, int i);
int GetWidgetStringAsInt(Widget w, String attr);
int PrintFocalParms(FOCAL_PARMS *pfocalParms);

/* --- functions --- */

void init_focalParms(mpic *mp)
  {

  mp->focalParms.t1 = 0.0;
  mp->focalParms.t2 = 0.0;

  mp->focalParms.z1 = 0.0;
  mp->focalParms.z2 = 0.0;

  mp->focalParms.m1 = 0.0;
  mp->focalParms.m2 = 0.0;

  mp->focalParms.np1 = 0.0;
  mp->focalParms.np2 = 0.0;
  mp->focalParms.ns1 = 0.0;
  mp->focalParms.ns2 = 0.0;
  mp->focalParms.g1 = 0.0;
  mp->focalParms.g2 = 0.0;

  mp->focalParms.del1 = 0.0;
  mp->focalParms.del2 = 0.0;

  mp->focalParms.rms1 = 0.0;
  mp->focalParms.rms2 = 0.0;

  mp->focalParms.err1 = 0.0;
  mp->focalParms.err2 = 0.0;

  mp->focalParms.q1 = 0.0;
  mp->focalParms.q2 = 0.0;

  mp->focalParms.intarg = 0;
  }

void focal_new_parms(mpic *mplot)
  {
  int iokay;

  iokay = CopyFromFocalWindow(&mplot->focalParms);
  }

void PopupFocal(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  /* fprintf(stderr, "in PopupFocal\n");
     PrintFocalParms(&mplot->focalParms); */

  iokay = CopyToFocalWindow(&mplot->focalParms);
  XtPopup(mplot->focalParms.wShell, XtGrabNonexclusive);
  }

void FocalDoit(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;
 
  /* fprintf(stderr,"in FocalSet\n"); */
  iokay = CopyFromFocalWindow(&mplot->focalParms);
  /* PrintFocalParms(&mplot->focalParms); */
  XtPopdown(mplot->focalParms.wShell);
  focal_new_parms(mplot);
  focal_selection(mplot);
  }

void FocalSet(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  /* fprintf(stderr,"in FocalSet\n"); */
  iokay = CopyFromFocalWindow(&mplot->focalParms);
  /* PrintFocalParms(&mplot->focalParms); */
  XtPopdown(mplot->focalParms.wShell);
  }

void FocalDone(Widget w, mpic *mplot, char *call_data)
  {
  /* fprintf(stderr,"in FocalDone\n"); */
  /* PrintFocalParms(&mplot->focalParms); */
  XtPopdown(mplot->focalParms.wShell);
  }

void make_focal_pop(Widget box, mpic *mplot)
  {
  Widget xp, view, top, focalshell;

  /* fprintf(stderr,"begin\n"); */

  top = mplot->shell;
  xp = XtVaCreateManagedWidget("Set Focal", smeBSBObjectClass, box, NULL);

  mplot->focalParms.wShell = focalshell
    = XtVaCreatePopupShell("focalWin", transientShellWidgetClass, top, NULL);
  
  view = XtVaCreateManagedWidget("focalForm", formWidgetClass, focalshell, NULL);
  
  /* -----------NOTE:  these must be created in the correct order   !  */
  
  /* Create the various parameter labels and their text boxes. */

  mplot->focalParms.hTime = XtVaCreateManagedWidget("Time_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hTime1Edit = XtVaCreateManagedWidget("Time1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hTime2Edit = XtVaCreateManagedWidget("Time2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hDepth = XtVaCreateManagedWidget("Depth_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hDepth1Edit = XtVaCreateManagedWidget("Depth1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hDepth2Edit = XtVaCreateManagedWidget("Depth2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hMag = XtVaCreateManagedWidget("Mag_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hMag1Edit = XtVaCreateManagedWidget("Mag1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hMag2Edit = XtVaCreateManagedWidget("Mag2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hNump = XtVaCreateManagedWidget("Nump_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hNump1Edit = XtVaCreateManagedWidget("Nump1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hNump2Edit = XtVaCreateManagedWidget("Nump2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hNums = XtVaCreateManagedWidget("Nums_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hNums1Edit = XtVaCreateManagedWidget("Nums1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hNums2Edit = XtVaCreateManagedWidget("Nums2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hGap = XtVaCreateManagedWidget("Gap_Label",
    labelWidgetClass, view, NULL);
    
  mplot->focalParms.hGap1Edit = XtVaCreateManagedWidget("Gap1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hGap2Edit = XtVaCreateManagedWidget("Gap2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hDelta = XtVaCreateManagedWidget("Delta_Label",
     labelWidgetClass, view, NULL);
    
  mplot->focalParms.hDelta1Edit = XtVaCreateManagedWidget("Delta1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hDelta2Edit = XtVaCreateManagedWidget("Delta2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hRms = XtVaCreateManagedWidget("Rms_Label",
    labelWidgetClass, view, NULL);
    
  mplot->focalParms.hRms1Edit = XtVaCreateManagedWidget("Rms1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hRms2Edit = XtVaCreateManagedWidget("Rms2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hErr = XtVaCreateManagedWidget("Err_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hErr1Edit = XtVaCreateManagedWidget("Err1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hErr2Edit = XtVaCreateManagedWidget("Err2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hQ = XtVaCreateManagedWidget("Q_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hQ1Edit = XtVaCreateManagedWidget("Q1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hQ2Edit = XtVaCreateManagedWidget("Q2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->focalParms.hTarg = XtVaCreateManagedWidget("Targ_Label",
    labelWidgetClass, view, NULL);

  mplot->focalParms.hTargEdit = XtVaCreateManagedWidget("TargEdit",
    asciiTextWidgetClass, view, NULL);

  /* Make all of the edit boxes editable. */

  SetWidgetInt(mplot->focalParms.hTime1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hTime2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hDepth1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hDepth2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hMag1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hMag2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hNump1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hNump2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hNums1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hNums2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hGap1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hGap2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hDelta1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hDelta2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hRms1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hRms2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hErr1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hErr2Edit, XtNeditType, XawtextEdit);
 
  SetWidgetInt(mplot->focalParms.hQ1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->focalParms.hQ2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->focalParms.hTargEdit, XtNeditType, XawtextEdit);

  /* Create the Set and Cancel command buttons. */

  mplot->focalParms.wSet = XtVaCreateManagedWidget("set",
    commandWidgetClass, view, NULL);

  mplot->focalParms.wDoit = XtVaCreateManagedWidget("doit",
    commandWidgetClass, view, NULL);

  mplot->focalParms.wCancel = XtVaCreateManagedWidget("cancel",
    commandWidgetClass, view, NULL);

  /* InitFocalParms(&mplot->focalParms); */

  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PopupFocal, mplot);

  XtAddCallback(mplot->focalParms.wSet, XtNcallback, (XtCallbackProc)FocalSet,
		mplot);
  XtAddCallback(mplot->focalParms.wDoit, XtNcallback, (XtCallbackProc)FocalDoit,
		mplot);
  XtAddCallback(mplot->focalParms.wCancel, XtNcallback,
		(XtCallbackProc)FocalDone, mplot);

  /***************DONE XDIP WINDOW ***********************/
  }

/*
 * Copies the current focal variables to the focal window's widgets.
 * Returns FALSE if fails.
 */

Boolean CopyToFocalWindow(FOCAL_PARMS *pfocalParms)
  {

  SetWidgetStringToFloat(pfocalParms->hTime1Edit, XtNstring, pfocalParms->t1);
  SetWidgetStringToFloat(pfocalParms->hTime2Edit, XtNstring, pfocalParms->t2);

  SetWidgetStringToFloat(pfocalParms->hDepth1Edit, XtNstring, pfocalParms->z1);
  SetWidgetStringToFloat(pfocalParms->hDepth2Edit, XtNstring, pfocalParms->z2);

  SetWidgetStringToFloat(pfocalParms->hMag1Edit, XtNstring, pfocalParms->m1);
  SetWidgetStringToFloat(pfocalParms->hMag2Edit, XtNstring, pfocalParms->m2);

  SetWidgetStringToFloat(pfocalParms->hNump1Edit, XtNstring, pfocalParms->np1);
  SetWidgetStringToFloat(pfocalParms->hNump2Edit, XtNstring, pfocalParms->np2);

  SetWidgetStringToFloat(pfocalParms->hNums1Edit, XtNstring, pfocalParms->ns1);
  SetWidgetStringToFloat(pfocalParms->hNums2Edit, XtNstring, pfocalParms->ns2);

  SetWidgetStringToFloat(pfocalParms->hGap1Edit, XtNstring, pfocalParms->g1);
  SetWidgetStringToFloat(pfocalParms->hGap2Edit, XtNstring, pfocalParms->g2);

  SetWidgetStringToFloat(pfocalParms->hDelta1Edit, XtNstring, pfocalParms->del1);
  SetWidgetStringToFloat(pfocalParms->hDelta2Edit, XtNstring, pfocalParms->del2);

  SetWidgetStringToFloat(pfocalParms->hRms1Edit, XtNstring, pfocalParms->rms1);
  SetWidgetStringToFloat(pfocalParms->hRms2Edit, XtNstring, pfocalParms->rms2);

  SetWidgetStringToFloat(pfocalParms->hErr1Edit, XtNstring, pfocalParms->err1);
  SetWidgetStringToFloat(pfocalParms->hErr2Edit, XtNstring, pfocalParms->err2);

  SetWidgetStringToFloat(pfocalParms->hQ1Edit, XtNstring, pfocalParms->q1);
  SetWidgetStringToFloat(pfocalParms->hQ2Edit, XtNstring, pfocalParms->q2);

  SetWidgetStringToInt(pfocalParms->hTargEdit, XtNstring, pfocalParms->intarg);

  return(TRUE);
  }

/*
 * Copies the focalents of the focalt window's widgets to be the current focal
 * parameters.
 * Returns FALSE if fails.
 */

Boolean CopyFromFocalWindow(FOCAL_PARMS *pfocalParms)
  {
 
  /* Get the values of the focal parameters specified in the focal window. */
  /* Get the values from the edit boxes. */

  pfocalParms->t1 = GetWidgetStringAsFloat(pfocalParms->hTime1Edit, XtNstring);
  pfocalParms->t2 = GetWidgetStringAsFloat(pfocalParms->hTime2Edit, XtNstring);

  pfocalParms->z1 = GetWidgetStringAsFloat(pfocalParms->hDepth1Edit, XtNstring);
  pfocalParms->z2 = GetWidgetStringAsFloat(pfocalParms->hDepth2Edit, XtNstring);

  pfocalParms->m1 = GetWidgetStringAsFloat(pfocalParms->hMag1Edit, XtNstring);
  pfocalParms->m2 = GetWidgetStringAsFloat(pfocalParms->hMag2Edit, XtNstring);

  pfocalParms->np1 = GetWidgetStringAsFloat(pfocalParms->hNump1Edit, XtNstring);
  pfocalParms->np2 = GetWidgetStringAsFloat(pfocalParms->hNump2Edit, XtNstring);

  pfocalParms->ns1 = GetWidgetStringAsFloat(pfocalParms->hNums1Edit, XtNstring);
  pfocalParms->ns2 = GetWidgetStringAsFloat(pfocalParms->hNums2Edit, XtNstring);

  pfocalParms->g1 = GetWidgetStringAsFloat(pfocalParms->hGap1Edit, XtNstring);
  pfocalParms->g2 = GetWidgetStringAsFloat(pfocalParms->hGap2Edit, XtNstring);

  pfocalParms->del1 = GetWidgetStringAsFloat(pfocalParms->hDelta1Edit,
					    XtNstring);
  pfocalParms->del2 = GetWidgetStringAsFloat(pfocalParms->hDelta2Edit,
					    XtNstring);

  pfocalParms->np1 = GetWidgetStringAsFloat(pfocalParms->hNump1Edit, XtNstring);
  pfocalParms->np2 = GetWidgetStringAsFloat(pfocalParms->hNump2Edit, XtNstring);

  pfocalParms->ns1 = GetWidgetStringAsFloat(pfocalParms->hNums1Edit, XtNstring);
  pfocalParms->ns2 = GetWidgetStringAsFloat(pfocalParms->hNums2Edit, XtNstring);

  pfocalParms->rms1 = GetWidgetStringAsFloat(pfocalParms->hRms1Edit, XtNstring);
  pfocalParms->rms2 = GetWidgetStringAsFloat(pfocalParms->hRms2Edit, XtNstring);

  pfocalParms->err1 = GetWidgetStringAsFloat(pfocalParms->hErr1Edit, XtNstring);
  pfocalParms->err2 = GetWidgetStringAsFloat(pfocalParms->hErr2Edit, XtNstring);

  pfocalParms->q1 = GetWidgetStringAsFloat(pfocalParms->hQ1Edit, XtNstring);
  pfocalParms->q2 = GetWidgetStringAsFloat(pfocalParms->hQ2Edit, XtNstring);

  pfocalParms->intarg = GetWidgetStringAsInt(pfocalParms->hTargEdit, XtNstring);

  return(TRUE);
  }

