/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>


#include <ctype.h>

/* --- local headers --- */

#include "geotouch.h"
#include "geotouch-help.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jutil.h"
#include "focproto.h"
#include "fsel.h"
#include "cascade.h"
#include "user2pix.h"

int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
void create_Acard(ac_rec *ac , char *acrd);
void send_repaint(Widget wij, int x, int y, int w, int h);


void focal_selection( mpic *mplot)
  {
  int i, k = 0, j, icode, inout, kk, numcode, codes[20];
  char acrd[76];
  float tim;
  FILE *inf;
  float phi, lam;
  float px, py;


  fprintf(stdout, " -------------------------------- \n\n");

  /* make a vector of the options  */

  numcode = 0;

  if(mplot->focalParms.t2 > mplot->focalParms.t1) codes[numcode++] = 11;
  if(mplot->focalParms.z2 > mplot->focalParms.z1) codes[numcode++] = 1;
  if(mplot->focalParms.m2 > mplot->focalParms.m1) codes[numcode++] = 2;
  if(mplot->focalParms.np2 > mplot->focalParms.np1) codes[numcode++] = 3;
  if(mplot->focalParms.ns2 > mplot->focalParms.ns1) codes[numcode++] = 4;
  if(mplot->focalParms.g2 > mplot->focalParms.g1) codes[numcode++] = 5;
  if(mplot->focalParms.del2 > mplot->focalParms.del1) codes[numcode++] = 6;
  if(mplot->focalParms.rms2 > mplot->focalParms.rms1) codes[numcode++] = 7;
  if(mplot->focalParms.err2 > mplot->focalParms.err1) codes[numcode++] = 8;
  if(mplot->focalParms.q1 > 0) codes[numcode++] = 9;
  if(mplot->focalParms.q2 > 0) codes[numcode++] = 10;
  if(mplot->focalParms.intarg > 0) codes[numcode++] = 0;

  fprintf(stderr, "done setting options\n");
  fprintf(stderr, "focal file = %s\n", mplot->src_dump_file);
  if((inf = fopen(mplot->src_dump_file, "w")) == NULL)
    {
    printf("Can't open focal dump %s ....try again\n",
	   mplot->src_dump_file);
    return;
    }

  for(j = 0; j < mplot->num_focm_files; j++)
    {
    fprintf(stdout, "\n-------------From Source File %s ---------------\n",
	    mplot->focm[j].file_name);
    phi = mplot->focm[j].meanPhi;
    lam = mplot->focm[j].meanLam;
    for(i = 0; i < mplot->focm[j].numpoints; i++)
      {
      inout = 0;
      for(kk = 0; kk < numcode; kk++)
	{
	icode = codes[kk];
	switch(icode)
	  {
	  case 0:
    phi = mplot->focm[j].focs[i].loc.x ;
    lam = mplot->focm[j].focs[i].loc.y;
    geo2xy(mplot, phi, lam, &px, &py); 
/*
	    if((px > SELXMIN)
	       && (px < SELXMAX)
	       && (py > SELYMIN)
	       && (py < SELYMAX))
	      inout++;
*/
	    break;

	  case 11:
	    tim = atof(mplot->focm[j].focs[i].ac.id);
	    if(tim >= mplot->focalParms.t1 && tim <= mplot->focalParms.t2)
	      inout++;
	    break;

	  case 1:
	    if((mplot->focm[j].focs[i].ac.depth >= mplot->focalParms.z1)
	       && (mplot->focm[j].focs[i].ac.depth <= mplot->focalParms.z2))
	    inout++;
	    break;

	  case 2:
	    if((mplot->focm[j].focs[i].ac.mag >= mplot->focalParms.m1)
	       && (mplot->focm[j].focs[i].ac.mag <= mplot->focalParms.m2))
	      inout++;
	    break;

	  case 3:
	    if((mplot->focm[j].focs[i].ac.nump >= mplot->focalParms.np1)
	       && (mplot->focm[j].focs[i].ac.nump <= mplot->focalParms.np2))
	      inout++;
	    break;

	  case 4:
	    if((mplot->focm[j].focs[i].ac.nums >= mplot->focalParms.ns1)
	       && (mplot->focm[j].focs[i].ac.nums <= mplot->focalParms.ns2))
	      inout++;
	    break;

	  case 5:
	    if((mplot->focm[j].focs[i].ac.gap >= mplot->focalParms.g1)
	       && (mplot->focm[j].focs[i].ac.gap <= mplot->focalParms.g2))
	      inout++;
	    break;

	  case 6:
	    if((mplot->focm[j].focs[i].ac.delta >= mplot->focalParms.del1)
	       && (mplot->focm[j].focs[i].ac.delta <= mplot->focalParms.del2))
	      inout++;
	    break;

	  case 7:
	    if((mplot->focm[j].focs[i].ac.rms >= mplot->focalParms.rms1)
	       && (mplot->focm[j].focs[i].ac.rms <= mplot->focalParms.rms2))
	      inout++;
	    break;

	  case 8:
	    if((mplot->focm[j].focs[i].ac.err >= mplot->focalParms.err1)
	       && (mplot->focm[j].focs[i].ac.err <= mplot->focalParms.err2))
	      inout++;
	    break;

	  case 9:
	    if((mplot->focm[j].focs[i].ac.q1[0]) < (mplot->focalParms.q1 + 63))
	      inout++;
	    break;

	  case 10:
	    if((mplot->focm[j].focs[i].ac.q2[0]) < (mplot->focalParms.q2 + 63))
	      inout++;
	    break;
	  }
	}

      if(inout >= numcode)
	{
	create_Acard(&mplot->focm[j].focs[i].ac, acrd);
	fprintf(stdout, "%s", acrd);
	fprintf(inf, "%s", acrd);
	k++;
	}
      }
    }

  fprintf(stdout, "\n\n number of points = %d\n", k);
  fprintf(stdout, "---------------------------------\n");
  fclose(inf);
  }

void reset_focal_onoff(mpic *mplot)
  {
  int i, j;

  
  for(j = 0; j <= mplot->max_more_src - 1; j++)
    for (i = 0; i < mplot->focm[j].numpoints; i++)
      mplot->focm[j].focs[i].on_off = 1;
  }

void focal_selection2(mpic *mplot)
  {
  int i, k = 0, j, icode, inout, kk, numcode, codes[20];
  float tim;
  float phi, lam;
  float px, py;

  fprintf(stdout, " -------------------------------- \n\n");

  /* make a vector of the options  */
  numcode = 0;

  if(mplot->focalParms.t2 > mplot->focalParms.t1) codes[numcode] = 11;
  if(mplot->focalParms.z2 > mplot->focalParms.z1) codes[numcode++] = 1;
  if(mplot->focalParms.m2 > mplot->focalParms.m1) codes[numcode++] = 2;
  if(mplot->focalParms.np2 > mplot->focalParms.np1) codes[numcode++] = 3;
  if(mplot->focalParms.ns2 > mplot->focalParms.ns1) codes[numcode++] = 4;
  if(mplot->focalParms.g2 > mplot->focalParms.g1) codes[numcode++] = 5;
  if(mplot->focalParms.del2 > mplot->focalParms.del1) codes[numcode++] = 6;
  if(mplot->focalParms.rms2 > mplot->focalParms.rms1) codes[numcode++] = 7;
  if(mplot->focalParms.err2 > mplot->focalParms.err1) codes[numcode++] = 8;
  if(mplot->focalParms.q1 > 0) codes[numcode++] = 9;
  if(mplot->focalParms.q2 > 0) codes[numcode++] = 10;
  if(mplot->focalParms.intarg > 0) codes[numcode++] = 0;

  if(numcode <= 0)
    {
    reset_focal_onoff(mplot); 
    return;
    }
   
  fprintf(stderr, "done setting options\n");

  for(j = 0; j <= mplot->max_more_src - 1; j++)
    {
    fprintf(stdout, "\n-------------From Focal File %s ---------------\n",
	    mplot->focm[j].file_name);

    phi = mplot->focm[j].meanPhi;
    lam = mplot->focm[j].meanLam;

    for(i = 0; i < mplot->focm[j].numpoints; i++)
      {
      inout = 0;
      for(kk = 0; kk < numcode; kk++)
	{
	icode = codes[kk];
	switch(icode)
	  {
	  case 0:

	  phi = mplot->focm[j].focs[i].loc.x ;
	  lam = mplot->focm[j].focs[i].loc.y;
	  geo2xy(mplot, phi, lam, &px, &py); 
/*
	    if((px > SELXMIN)
	       && (px < SELXMAX)
	       && (py > SELYMIN)
	       && (py < SELYMAX))
	      inout++;
*/
	    break;

	  case 11:
	    tim = atof(mplot->focm[j].focs[i].ac.id);
	    if(tim >= mplot->focalParms.t1 && tim <= mplot->focalParms.t2)
	      inout++;
	    break;

	  case 1:
	    if((mplot->focm[j].focs[i].ac.depth >= mplot->focalParms.z1)
	       && (mplot->focm[j].focs[i].ac.depth <= mplot->focalParms.z2))
	      inout++;
	    break;

	  case 2:
	    if((mplot->focm[j].focs[i].ac.mag >= mplot->focalParms.m1)
	       && (mplot->focm[j].focs[i].ac.mag <= mplot->focalParms.m2))
	      inout++;
	    break;

	  case 3:
	    if((mplot->focm[j].focs[i].ac.nump >= mplot->focalParms.np1)
	       && (mplot->focm[j].focs[i].ac.nump <= mplot->focalParms.np2))
	      inout++;
	    break;

          case 4:
	    if((mplot->focm[j].focs[i].ac.nums >= mplot->focalParms.ns1)
	       && (mplot->focm[j].focs[i].ac.nums <= mplot->focalParms.ns2))
	      inout++;
	    break;

	  case 5:
	    if((mplot->focm[j].focs[i].ac.gap >= mplot->focalParms.g1)
	       && (mplot->focm[j].focs[i].ac.gap <= mplot->focalParms.g2))
	      inout++;
	    break;

	  case 6:
	    if((mplot->focm[j].focs[i].ac.delta >= mplot->focalParms.del1)
	       && (mplot->focm[j].focs[i].ac.delta <= mplot->focalParms.del2))
	      inout++;
	    break;

	  case 7:
	    if((mplot->focm[j].focs[i].ac.rms >= mplot->focalParms.rms1)
	       && (mplot->focm[j].focs[i].ac.rms <= mplot->focalParms.rms2))
	      inout++;
	    break;

	  case 8:
	    if((mplot->focm[j].focs[i].ac.err >= mplot->focalParms.err1)
	       && (mplot->focm[j].focs[i].ac.err <= mplot->focalParms.err2))
	      inout++;
	    break;

	  case 9:
	    if((mplot->focm[j].focs[i].ac.q1[0]) < (mplot->focalParms.q1 + 63))
	      inout++;
	    break;

	  case 10:
	    if((mplot->focm[j].focs[i].ac.q2[0]) < (mplot->focalParms.q2 + 63))
	      inout++;
	    break;
	  }
	}
       
      if(inout >= numcode)
	{
	mplot->focm[j].focs[i].on_off = 1;
	k++;
	}
      else mplot->focm[j].focs[i].on_off = 0;
      }
    }

  fprintf(stdout, "\n\n number of points = %d\n", k);
  fprintf(stdout, "---------------------------------\n");
  }

void database_focal(Widget wij, mpic *mplot, char *call_data)
  {

  focal_selection2(mplot);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

void reset_database_focal(Widget wij, mpic *mplot, char *call_data)
  {

  reset_focal_onoff(mplot);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }
