
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

/* --- local headers --- */

#include "geotouch.h"

/* --- global variables --- */

int screenx = 800, screeny = 800;

/* --- function prototypes --- */

extern void submap8(int argc, char **argv);
extern void startup_help(void);

/* --- functions --- */

int  main(int argc, char **argv)
  {
  int  nargc, i;
  char **nargv;

  void intro(char *);

  intro(*argv);

  if(argc == 1)
    {
    nargc = 3 + argc;

    nargv = XmapNewArray(char *, nargc);

    nargv[0] = "geotouch";
    if( (nargv[1] = getenv("XMA_ORG_FILE")) == NULL)
       {
       /*  Bad business, better abort  */
       fprintf(stderr,"USAGE  ERROR: to run geotouch you must have an origin file\n");
       exit(0);
       
       }
    
        if( (nargv[2] = getenv("XMA_STA_FILE")) == NULL)
       {
       nargv[2] = "geotouch.sta.null";  
       }

        if( (nargv[3] = getenv("XMA_AC_FILE")) == NULL)
       {
       nargv[3] = "geotouch.src.null";  
       }

     fprintf(stderr, "number of args = %d\n", nargc); 

    for(i = 0; i < nargc; i++)
      fprintf(stderr, " %s ", nargv[i]);
    fprintf(stderr, "\n");

    if(argc > 1)
      {
      for(i = 0; i < argc; i++)
	nargv[i + 4] = argv[i + 1];
      }
    }
  else
    {
    if(argv[1][0] == '-')
      {
      if((argv[1][1] == 'H') || (argv[1][1] == 'h'))
	startup_help();
      else
	{
	nargc = 3 + argc;

	nargv = XmapNewArray(char *, nargc);

	nargv[0] = "geotouch";
	nargv[1] = getenv("XMA_ORG_FILE");
	nargv[2] = getenv("XMA_STA_FILE");
	nargv[3] = getenv("XMA_AC_FILE");
	/* fprintf(stderr, "nargc=%d\n", nargc); */
	

	if(argc > 1)
	  {
	     for(i = 0; i < argc-1; i++)
	     {
		/* fprintf(stderr, "%d %s\n", i, argv[i + 1]); */
		nargv[i + 4] = argv[i + 1];
	     }
	  }
	fprintf(stderr, "ARGS: ");
	for(i = 0; i < nargc; i++)
	  fprintf(stderr, " %s ", nargv[i]);
	fprintf(stderr, "\n");


	}
      }

    if(argc > 1 && argv[1][0] != '-')
      {
      nargc = argc;
      nargv = XmapNewArray(char *, nargc);
      for(i = 0; i < argc; i++)
	nargv[i] = argv[i];
      }
    }

  submap8(nargc, nargv);
  XmapFree(nargv);
  return(1);
  }

void intro(char *p)
  {
  fprintf(stderr, "\n[%s]\n\n", p);
  fprintf(stderr, "geotouch - v2.2 - Compiled: %s %s\n\n\n", __DATE__, __TIME__);


  fprintf(stderr, "All Longitudes in Geotouch are POSITIVE EAST\n");
 
 
  fprintf(stderr, "\n\n\n");
  
  }
