
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/* --- local headers --- */

#include "geotouch.h"
#include "mpic.h"
#include "Xcols.h"


/* --- macros --- */

#define MAXCOL 65535
#define NUM_FIX_COLORS (sizeof(fix_color_names) / sizeof(char *))
#define NUM_MAX_COLORS 256

/* --- function prototypes --- */

void break_line(char *line, int *fake_argc, char **fake_argv);
int getline(FILE *input, char s[], int lim);
void  gstrc(char *string1, int begin, int num, char *i);

/* --- global variables --- */

char *fix_color_names[] =
  {
  "black",		/* 0 */
  "white",		/* 1 */
  "red",		/* 2 */
  "light blue",		/* 3 */
  "mediumpurple",	/* 4 */
  "azure",		/* 5 */
  "darkorange",		/* 6 */
  "green",		/* 7 */
  "plum",		/* 8 */
  "LemonChiffon1",	/* 9 */
  "SeaGreen1",		/* 10 */
  "DeepSkyBlue1",	/* 11 */
  "turquoise1",		/* 12 */
  "DeepPink",		/* 13 */
  "gold",		/* 14 */
  "lightcyan",		/* 15 */
  "OldLace",		/* 16 */
  "DarkSlateGray",	/* 17 */
  "DarkSeaGreen",	/* 18 */
  "GreenYellow",	/* 19 */
  "orange",		/* 20 */
  "RoyalBlue",		/* 21 */
  "SkyBlue1",		/* 22 */
  "cyan1",		/* 23 */
  "DarkSlateGray4",	/* 24 */
  "dimgray",		/* 25 105 105 105 */
  "beige",		/* 26 245 245 220 */
  "aquamarine1",	/* 27 127 255 212 */
  "LemonChiffon",	/* 28 255 250 205 */
  "AntiqueWhite",	/* 29 250 235 215 */
  "MintCream",		/* 30 245 255 250 */ 
  "lavender",		/* 31 230 230 250 */
  "PeachPuff1",		/* 32 255 218 185 */
  "cornsilk2",		/* 33 238 232 205 */
  "LightSkyBlue1",	/* 34 176 226 255 */
  "MediumAquamarine",	/* 35 102 205 170 */
  "PaleGreen",		/* 36 152 251 152 */
  "LightSeaGreen",	/* 37 32 178 170 */
  "PaleGreen3",		/* 38 124 205 124 */
  "SkyBlue",		/* 39 135 206 235 */
  "green",		/* 40 0 255 0 */
  "LightCyan2",		/* 41 209 238 238 */
  "yellow1",		/* 42 255 255 0 */
  "IndianRed",		/* 43 205 92 92 */
  "salmon",		/* 44 250 128 114 */
  "bisque3",		/* 45 205 183 158 */
  "yellow2",		/* 46 238 238 0 */
  "khaki",		/* 47 240 230 140 */
  "moccasin",		/* 48 255 228 181 */
  "pink",		/* 49 255 192 203 */
  "SteelBlue2",		/* 50 92 172 238 */
  "MistyRose2",		/* 51 238 213 210 */
  "tan4",		/* 52 139 90 43 */
  "SeaGreen1",		/* 53 84 255 159 */
  "DeepPink",		/* 54 255 20 147 */
  "magenta3",		/* 55 205 0 205 */
  "LightPink",		/* 56 255 182 193 */
  "thistle1",		/* 57 255 225 255 */
  "LightSalmon",	/* 58 255 160 122 */
  "sienna4",		/* 59 139 71 38 */

  /* these are 40 colors from bob's makerain program  */

  "#ffec00", "#fcff00", "#edff00", "#e2ff00", "#d7ff00",
  "#c9ff00", "#b3ff00", "#93ff00", "#6aff00", "#38ff00",
  "#00ff00", "#00ff3a", "#00ff71", "#00ffa3", "#00ffcd",
  "#00ffec", "#00fbff", "#00edff", "#00e2ff", "#00d7ff",
  "#00c9ff", "#00b3ff", "#0093ff", "#006aff", "#0038ff",
  "#0000ff", "#3a00ff", "#7100ff", "#a300ff", "#cd00ff",
  "#ec00ff", "#ff00fb", "#ff00ed", "#ff00e2", "#ff00d7",
  "#ff00c9", "#ff00b2", "#ff0093", "#ff006a", "#ff0038",

  /* these are 40 colors from bob's makepal program  (makepal 40 -x) */

  "#00ffff", "#00fcfc", "#00f9f9", "#00f5f5", "#00f1f1",
  "#00ecec", "#00e7e7", "#00e1e1", "#00dada","#00d2d2",
  "#00c9c9", "#00bebe", "#00b1b1", "#00a2a2", "#008f8f",
  "#007777", "#005b5b", "#003b3b", "#001a1a", "#000303",
  "#030000", "#1a0000", "#3b0000", "#5b0000", "#770000",
  "#8f0000", "#a20000", "#b10000", "#be0000", "#c90000",
  "#d20000", "#da0000", "#e10000", "#e70000", "#ec0000",
  "#f10000", "#f50000", "#f90000", "#fc0000", "#ff0000",



"#576e2d" ,
"#5d763c" ,
"#658149" ,
"#6d8c56" ,
"#759764" ,
"#7da371" ,
"#85ae7e" ,
"#8db98c" ,
"#719671" ,
"#7ba37b" ,
"#86b186" ,
"#90bf90" ,
"#9bcd9b" ,
"#a5daa5" ,
"#afe8af" ,
"#c4fcbe" ,
"#cbf7ba" ,
"#d1f3b6" ,
"#d8eeb2" ,
"#dee9ae" ,
"#e5e5aa" ,
"#ebe0a6" ,
"#f2dca2" ,
"#f8d79e" ,
"#eec591" ,
"#ecc28d" ,
"#ebbf8a" ,
"#e9bd86" ,
"#e8ba83" ,
"#e7b77f" ,
"#e5b57c" ,
"#e4b279" ,
"#e3af75" ,
"#e1ad72" ,
"#e0aa6e" ,
"#dea76b" ,
"#dda568" ,
"#dca264" ,
"#da9f61" ,
"#d99d5d" ,
"#d89a5a" ,
"#d69756" ,
"#d59553" ,
"#d39250" ,
"#d28f4c" ,
"#d18d49" ,
"#cf8a45" ,
"#ce8742" ,
"#cd853f" ,
"#cb8541" ,
"#ca8543" ,
"#c98645" ,
"#c88647" ,
"#c68749" ,
"#c5874b" ,
"#c4884d" ,
"#c3884f" ,
"#c28951" ,
"#c08953" ,
"#bf8a55" ,
"#be8a58" ,
"#bd8b5a" ,
"#bc8b5c" ,
"#ba8b5e" ,
"#b98c60" ,
"#b88c62" ,
"#b78d64" ,
"#b68d66" ,
"#b48e68" ,
"#b38e6a" ,
"#b28f6c" ,
"#b18f6e" ,
"#b09071" ,
"#ae9073" ,
"#ad9175" ,
"#ac9177" ,
"#ab9179" ,
"#aa927b" ,
"#a8927d" ,
"#a7937f" ,
"#a69381" ,
"#a59483" ,
"#a49485" ,
"#a29587" ,
"#a1958a" ,
"#a0968c" ,
"#9f968e" ,
"#9e9790" ,
"#9c9792" ,
"#9b9794" ,
"#9a9896" ,
"#999898" ,
"#9a9a9a" ,
"#9d9d9c" ,
"#a0a09e" ,
"#a2a2a1" ,
"#a5a5a3" ,
"#a7a7a5" ,
"#a9a9a7" ,
"#acaca9" ,
"#aeaeab" ,
"#b1b1ad" ,
"#b4b4b0" ,
"#b6b6b2" ,
"#b8b8b4" ,
"#bbbbb6" ,
"#bdbdb8" ,
"#c0c0ba" ,
"#c3c3bc" ,
"#c5c5be" ,
"#c7c7c1" 

  };


/* --- functions --- */
int xfind_quotes(char *ident, int *len)
  {
  int i, k = 0, n = 0, m = 0;

  for(i = 0; i < strlen(ident); i++)
    {
      
    if(ident[i] == '\"') {
      k++;
    if(k == 1) n = i;
    else if(k > 1) m = i;
    }
   /*  fprintf(stderr,"<%c>%d %d %d %d", ident[i], i, k, n, m); */
    }
  *len = m - n;
  /* fprintf(stderr,"n=%d m=%d k=%d\n", n, m, k); */
  return(n);
  }

/**************************************************/
int find_quotes(char *ident, int *len)
  {
  int i, k = 0, n = 0, m = 0;

  for(i = 0; i < strlen(ident); i++)
    {
    if(ident[i] == '"')	k++;
    if(k == 1) n = i;
    else if(k > 1) m = i;
    }
  *len = m - n;
  return(n);
  }

/* flag = 0 retrun count flag = 1 return
 * first occurance flag = 2 retrun last
 * occurance
 */
/**************************************************/
int count_quotes(char *s, int flag)
  {
  int i, len, n = 0, *pey;
  int ans;

  len = strlen(s);
  pey = XmapNewArray(int, len);

  for(i = 0; i < strlen(s); i++)
  {
     /* fprintf(stderr,"%c", s[i]); */

     if(s[i] == '"')
     {
	pey[n] = i;
	n++;
     }
  }
 /*  fprintf(stderr,"\n"); */
  /* fprintf(stderr,"peyns:  %d %d %d %d\n", len , n, pey[0], pey[n - 1]); */
 
  if(flag == 0)	ans = n;
  else if(flag == 1) ans = pey[0] ;
  else if(flag == 2) ans = pey[n - 1] ;
  else ans = 0 ;

  XmapFree(pey);
  return(ans);
  }
/**************************************************/
int change_ps_colors(mpic *mplot)
  {
  FILE *fp;
  
  Colormap gcol;
  Display *gdisp;
  int i, j, k, gscr_num, nx11;
  
  char *color_file, line[100];
  char hexn[100], hexj[100];
   int ir, ig, ib;
int firstq, secondq;
 
  if((color_file = getenv("XMA_PALETTE")) != NULL)
    {
    gdisp = XtDisplay(mplot->wij);
    gscr_num = DefaultScreen(gdisp);
    gcol = DefaultColormap(gdisp, gscr_num);

    fprintf(stderr, " changing the postscript colors according to file: %s\n",
	    color_file);

    if((fp = fopen(color_file, "r")) == NULL) return(0);

    nx11=NX11COL;

    while((i = getline(fp, line, 100)) != 0)
      {
	sscanf(line, "%d %s", &j, hexn);
	
	fprintf(stderr," Modify color %d to %s\n", j, hexn);
	
	/*
	  co.pixel = mplot->colors[j];
	  XQueryColor(gdisp, gcol, &co);
	  */
	if(hexn[1] == '#')
	  {
	    strncpy( hexj, hexn+2, 6);
	    hexj[6] = '\0';
	    sscanf(hexj, "%02x%02x%02x", &ir, &ig, &ib);

	    /* fprintf(stderr,"%d %s %6s %d %d %d ", j, hexn, hexj, ir, ig , ib); */

	    mplot->jmlcol[j].red = (float)ir/ (float)(NUM_MAX_COLORS-1);
	    mplot->jmlcol[j].green = (float)ig/ (float)(NUM_MAX_COLORS-1);
	    mplot->jmlcol[j].blue = (float)ib/ (float)(NUM_MAX_COLORS-1);
	   /*  fprintf(stderr,"%f %f %f\n",mplot->jmlcol[j].red, mplot->jmlcol[j].green , mplot->jmlcol[j].blue); */
	  }
	else
	  {

	    
          

	    firstq = xfind_quotes(hexn, &k );
	  
	    secondq = firstq+k;
	    /*  fprintf(stderr,"j=%d k=%d firstq=%d secondq=%d\n", j,k,firstq, secondq); */
	  
	    strncpy( hexj, hexn+firstq+1, k-1);
	  
	    hexj[k-1] = '\0';
	     /* fprintf(stderr,"%d %d <%s> <%s> %d %d \n", j,k, hexj, hexn, firstq, secondq); */ 
	  
	    for(i=0; i<nx11; i++)
	      {
		if(!strcmp(hexj, x11colname[i]))
		  {
		    /* fprintf(stderr,"%s %f %f %f\n", hexj,  x11col[i].red, x11col[i].green, x11col[i].blue); */
		    mplot->jmlcol[j].red = (float)x11col[i].red/ (float)(NUM_MAX_COLORS-1);
		    mplot->jmlcol[j].green = (float)x11col[i].green/ (float)(NUM_MAX_COLORS-1);
		    mplot->jmlcol[j].blue = (float)x11col[i].blue/ (float)(NUM_MAX_COLORS-1);
		  }
	      }
	  }
      
	/*
	red = (float)co.red / (float)MAXCOL;
	green = (float)co.green / (float)MAXCOL;
	blue = (float)co.blue / (float)MAXCOL;

	mplot->jmlcol[j].red = red;
	mplot->jmlcol[j].green = green;
	mplot->jmlcol[j].blue = blue;
	*/
      }
    fclose(fp);
    }
  return(0);
  }
/**************************************************/
int get_colors(char *color_names, int *numcols)
  {
  int i, j, hi, hir;
  char *color_file, line[100], ch[100];
  FILE *fp;

  /* first set the fixed colors from the string defined at the beginning */

  for(i = 0; i < NUM_FIX_COLORS; i++)
    {
  /* fprintf(stderr,"%d  %s\n", i,   fix_color_names[i] ); */
     
    strcpy(color_names + 25 * i, fix_color_names[i]);
    }

#if 0
  fprintf(stderr,"NUM_FIX_COLORS = %d\n", i);
  
  for(i = NUM_FIX_COLORS; i < NUM_MAX_COLORS; i++)
    strcpy(color_names + 25 * i, "gray");
#endif

  if((color_file = getenv("XMA_PALETTE")) != NULL)
    {
    if((fp = fopen(color_file, "r")) == NULL) return(0);

    while((i = getline(fp, line, 100)) != 0)
      {
      /* fprintf(stderr, "%s", line);  */

      hi = count_quotes(line, 1);
      hir = count_quotes(line, 2);

     /*  fprintf(stderr, "hi hir:   %d %d \n",hi,  hir);  */
      gstrc(line, hi + 1, hir - hi - 1, ch);
      sscanf(line, "%d", &j);
      if(j>=0 && j<=256)
	{
	  strcpy(color_names + 25 * j, ch);
	}
      }
    fclose(fp);
    }

  *numcols = NUM_FIX_COLORS;
  return(1);
  }
/**************************************************/
int modify_color_scheme(mpic *oneplot)
  {
  int i, fake_argc;
  char *color_file, line[100], *fake_argv[100];  /* max 100 parameters */
  FILE  *fp;

  if((color_file = getenv("XMA_COLORS")) != NULL)
    {
    if((fp = fopen(color_file, "r")) == NULL)
      {
      fprintf(stderr,"Cannot open file: %s\n", color_file);
      return(0);
      }

    fprintf(stderr, "Modifying colors from file: %s\n", color_file);
    while((i = getline(fp, line, 100)) != 0)
      {
      break_line(line, &fake_argc, fake_argv);

      if(strcmp(fake_argv[0], "special_src_col") == 0)
        oneplot->special_src_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "special_sta_col") == 0)
        oneplot->special_sta_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "special_perim_col") == 0)
      oneplot->special_perim_col=atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "special_name_col") == 0)
      oneplot->special_name_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "back_label_col") == 0)
      oneplot->back_label_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "name_label_col") == 0)
        oneplot->name_label_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "date_col") == 0)
        oneplot->date_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "fill_arc_col") == 0)
        oneplot->fill_arc_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "draw_arc_col") == 0)
        oneplot->draw_arc_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "fancy_src_col") == 0)
        oneplot->fancy_src_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "fancy_perim_col") == 0)
        oneplot->fancy_perim_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "magscale_col") == 0)
        oneplot->magscale_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "special_station_col") == 0)
        oneplot->special_station_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "exploding_line_col") == 0)
        oneplot->exploding_line_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "back_foc_col") == 0)
        oneplot->back_foc_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "ptax_col") == 0)
        oneplot->ptax_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "faultplane_col") == 0)
        oneplot->faultplane_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "strikeslip_col") == 0)
        oneplot->strikeslip_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "rev_oblSS_col") == 0)
        oneplot->rev_oblSS_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "obl_rev_col") == 0)
        oneplot->obl_rev_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "reverse_col") == 0)
        oneplot->reverse_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "norm_oblSS_col") == 0)
        oneplot->norm_oblSS_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "oblq_norm_col") == 0)
        oneplot->oblq_norm_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "normal_col") == 0)
        oneplot->normal_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "xsec_col") == 0)
        oneplot->xsec_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "box_xsec_col") == 0)
        oneplot->box_xsec_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "zoom_box_col") == 0)
        oneplot->zoom_box_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "spline_col") == 0)
        oneplot->spline_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "spline_points_col") == 0)
        oneplot->spline_points_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "sta_col") == 0)
        oneplot->sta_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "sta_color") == 0)
        oneplot->sta_color=atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "bord_col") == 0)
        oneplot->bord_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "back_fill_col") == 0)
        oneplot->back_fill_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "stuff_col") == 0)
        oneplot->stuff_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "map_col") == 0)
        oneplot->map_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "src_col") == 0)
        oneplot->src_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "title_col") == 0)
        oneplot->title_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "picsource_col") == 0)
        oneplot->picsource_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "text_col") == 0)
        oneplot->text_col = atoi(fake_argv[1]);

      if(strcmp(fake_argv[0], "background_col") == 0)
        oneplot->background_col = atoi(fake_argv[1]);
      if(strcmp(fake_argv[0], "foreground_col") == 0)
        oneplot->foreground_col = atoi(fake_argv[1]);
      }
    }
  return(1);
  }
/**************************************************/
void dump_color_scheme(mpic *oneplot)
  {
  int i, gscr_num;
  XColor co;
  Colormap gcol;
  Display *gdisp;
  float red, green, blue;

  fprintf(stdout, "special_src_col %d\n", oneplot->special_src_col);
  fprintf(stdout, "special_sta_col %d\n", oneplot->special_sta_col);
  fprintf(stdout, "sta_color %d\n", oneplot->sta_color);
  fprintf(stdout, "special_perim_col %d\n", oneplot->special_perim_col);
  fprintf(stdout, "special_name_col %d\n", oneplot->special_name_col);
  fprintf(stdout, "back_label_col %d\n", oneplot->back_label_col);
  fprintf(stdout, "name_label_col %d\n", oneplot->name_label_col);
  fprintf(stdout, "date_col %d\n", oneplot->date_col);
  fprintf(stdout, "fill_arc_col %d\n", oneplot->fill_arc_col);
  fprintf(stdout, "draw_arc_col %d\n", oneplot->draw_arc_col);
  fprintf(stdout, "fancy_src_col %d\n", oneplot->fancy_src_col);
  fprintf(stdout, "fancy_perim_col %d\n", oneplot->fancy_perim_col);
  fprintf(stdout, "magscale_col %d\n", oneplot->magscale_col);
  fprintf(stdout, "special_station_col %d\n", oneplot->special_station_col);
  fprintf(stdout, "exploding_line_col %d\n", oneplot->exploding_line_col);
  fprintf(stdout, "back_foc_col %d\n", oneplot->back_foc_col);
  fprintf(stdout, "ptax_col %d\n", oneplot->ptax_col);
  fprintf(stdout, "faultplane_col %d\n", oneplot->faultplane_col);
  fprintf(stdout, "strikeslip_col %d\n", oneplot->strikeslip_col);
  fprintf(stdout, "rev_oblSS_col %d\n", oneplot->rev_oblSS_col);
  fprintf(stdout, "oblq_norm_col %d\n", oneplot->oblq_norm_col);
  fprintf(stdout, "obl_rev_col %d\n", oneplot->obl_rev_col);
  fprintf(stdout, "reverse_col %d\n", oneplot->reverse_col);
  fprintf(stdout, "norm_oblSS_col %d\n", oneplot->norm_oblSS_col);
  fprintf(stdout, "normal_col %d\n", oneplot->normal_col);
  fprintf(stdout, "xsec_color %d\n", oneplot->xsec_col);
  fprintf(stdout, "box_xsec_col %d\n", oneplot->box_xsec_col);
  fprintf(stdout, "zoom_box_col %d\n", oneplot->zoom_box_col);
  fprintf(stdout, "spline_col %d\n", oneplot->spline_col);
  fprintf(stdout, "spline_points_col %d\n", oneplot->spline_points_col);
  fprintf(stdout, "sta_col %d\n", oneplot->sta_col);
  fprintf(stdout, "bord_col %d\n", oneplot->bord_col);
  fprintf(stdout, "back_fill_col %d\n", oneplot->back_fill_col);
  fprintf(stdout, "stuff_col %d\n", oneplot->stuff_col);
  fprintf(stdout, "map_col %d\n", oneplot->map_col);
  fprintf(stdout, "src_col %d\n", oneplot->src_col);
  fprintf(stdout, "title_col %d\n", oneplot->title_col);
  fprintf(stdout, "picsource_col %d\n", oneplot->picsource_col);
  fprintf(stdout, "text_col %d\n", oneplot->text_col);
  fprintf(stdout, "background_col %d\n", oneplot->background_col);
  fprintf(stdout, "foreground_col %d\n", oneplot->foreground_col);

  gdisp = XtDisplay(oneplot->wij);
  gscr_num = DefaultScreen(gdisp);
  gcol = DefaultColormap(gdisp, gscr_num);

  for(i = 0; i < oneplot->num_colors; i++)
    {
    co.pixel = oneplot->colors[i];
    XQueryColor(gdisp, gcol, &co);

    red = (float)co.red / (float)MAXCOL;
    green = (float)co.green / (float)MAXCOL;
    blue = (float)co.blue / (float)MAXCOL;

    fprintf(stderr, "%8f %8f %8f\n", red, green, blue);
    }
  }
/**************************************************/
/*-------------------------------------------------*/
void dump_color_palette(mpic *m)
   {
   int i, n = 0, gscr_num;
   XColor co;
  Pixel col[100];
  Colormap gcol;
  Display *gdisp;

   gdisp = XtDisplay(m->wij);
   gscr_num = DefaultScreen(gdisp);
   gcol = DefaultColormap(gdisp, gscr_num);

   for(i = m->MinColor; i <= m->MaxColor; i++)
      {
      col[n] = m->colors[XmapAppColor(i)];
      co.pixel = col[n];
      XQueryColor(gdisp, gcol, &co);
      fprintf(stderr, "%d: R=%d G=%d B=%d\n", i, co.red, co.green, co.blue);
      }
  
   }
/**************************************************/
/*-------------------------------------------------*/
void flip_color_palette(mpic *m)
  {
  int i, n = 0, gscr_num;
  XColor co;
  Jcol pscol[100];
  
  Pixel col[100];
  Colormap gcol;
  Display *gdisp;
  fprintf(stderr,"Reverse Palette: min=%d max=%d status=%d\n",m->MinColor,m->MaxColor, m->Reverse_Pal);
 
  gdisp = XtDisplay(m->wij);
  gscr_num = DefaultScreen(gdisp);
  gcol = DefaultColormap(gdisp, gscr_num);

  for(i = m->MinColor; i <= m->MaxColor; i++)
    {
    col[n] = m->colors[XmapAppColor(i)];
    co.pixel = col[n];
    XQueryColor(gdisp, gcol, &co);
   /* fprintf(stderr, "%d: R=%d G=%d B=%d\n", i, co.red, co.green, co.blue);*/
    pscol[n].red = m->jmlcol[i].red;
    pscol[n].green = m->jmlcol[i].green;
    pscol[n].blue = m->jmlcol[i].blue;
  
 

    n++;
    }

  n = 0;
  for(i = (m->MaxColor); i >= m->MinColor; i--)
    {
    m->colors[XmapAppColor(i)] = col[n];
   m->jmlcol[i].red = pscol[n].red ;
   m->jmlcol[i].green =  pscol[n].green  ;
   m->jmlcol[i].blue =  pscol[n].blue  ;
  
 

    n++;
    }
  }
/**************************************************/
void change_palette_colors(mpic *m)
  {
  FILE *inf;
  char ch[100], line[100];
  int i, n = 0, gscr_num;
  Colormap gcol;
  Display *gdisp;
  float r, g, b;
        
  gdisp = XtDisplay(m->wij);
  gscr_num = DefaultScreen(gdisp);
  gcol = DefaultColormap(gdisp, gscr_num);
  fprintf(stderr, "\n\nType in the name of the color file:\n");
  fscanf(stdin, "%s", ch);

  if((inf = fopen(ch, "r")) == NULL)
    {
    fprintf(stderr, "color file %s not readable\n", ch);
    return;
    }

  while((i = getline(inf, line, 100)) != 0)
    {
    sscanf(line, "%f %f %f", &r, &g, &b);
    fprintf(stderr, "%f %f %f\n", r, g,  b);

          /* XQueryColor(gdisp, gcol, &co);
	     fprintf(stderr, "%d: R=%d G=%d B=%d\n", i, co.red, co.green,
	     co.blue); */

    n++;
    }
  }
/**************************************************/
/*

0	"black"
1	"white"
2	"red"			
3	"light blue"		
4	"mediumpurple"		
5	"azure"		
6	"darkorange"		
7	"green"		
8	"plum"			
9	"LemonChiffon1"	
10	"SeaGreen1"		
11	"DeepSkyBlue1"		
12	"turquoise1"		
13	"DeepPink"		
14	"gold"			
15	"lightcyan"		
16	"OldLace"		
17	"DarkSlateGray"	
18	"DarkSeaGreen"		
19	"GreenYellow"		
20	"orange"		
21	"RoyalBlue"		
22	"SkyBlue1"		
23	"cyan1"		
24	"DarkSlateGray4"	
25	"dimgray"	
26	"beige"		
27	"aquamarine1"
28    "LightPink"
29    "yellow1"
30    "SkyBlue"
31    "LightSeaGreen"
32    "MistyRose2"
33    "tan4"
34    "LightCyan2"
35    "PeachPuff1"
36    "lavender"
37    "magenta3"
38    "pink"
39    "green"
40    "PaleGreen3"
41    "SteelBlue2"
42    "moccasin"
43    "DeepPink"
44    "AntiqueWhite"
45    "cornsilk2"
46    "khaki"
47    "bisque3"
48    "PaleGreen"
49    "IndianRed"
50    "LightSalmon"
51    "thistle1"
52    "LightSkyBlue1"
53    "MediumAquamarine"
54    "yellow2"
55    "MintCream"
56    "sienna4"
57    "salmon"
58    "LemonChiffon"
59    "SeaGreen1"

*/
